/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import java.util.Map;
import org.hibernate.LockMode;
import org.hibernate.NonUniqueObjectException;
import org.hibernate.action.internal.AbstractEntityInsertAction;
import org.hibernate.action.internal.EntityIdentityInsertAction;
import org.hibernate.action.internal.EntityInsertAction;
import org.hibernate.classic.Lifecycle;
import org.hibernate.engine.internal.Cascade;
import org.hibernate.engine.internal.CascadePoint;
import org.hibernate.engine.internal.ManagedTypeHelper;
import org.hibernate.engine.internal.Versioning;
import org.hibernate.engine.spi.CascadingAction;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityEntryExtraState;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SelfDirtinessTracker;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.internal.AbstractReassociateEventListener;
import org.hibernate.event.internal.WrapVisitor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.generator.BeforeExecutionGenerator;
import org.hibernate.generator.EventType;
import org.hibernate.generator.Generator;
import org.hibernate.id.IdentifierGenerationException;
import org.hibernate.id.IdentifierGeneratorHelper;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.jpa.event.spi.CallbackRegistry;
import org.hibernate.jpa.event.spi.CallbackRegistryConsumer;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.Type;
import org.hibernate.type.TypeHelper;

public abstract class AbstractSaveEventListener<C>
extends AbstractReassociateEventListener
implements CallbackRegistryConsumer {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(AbstractSaveEventListener.class);
    private CallbackRegistry callbackRegistry;

    @Override
    public void injectCallbackRegistry(CallbackRegistry callbackRegistry) {
        this.callbackRegistry = callbackRegistry;
    }

    protected Object saveWithRequestedId(Object entity, Object requestedId, String entityName, C context, EventSource source) {
        this.callbackRegistry.preCreate(entity);
        return this.performSave(entity, requestedId, source.getEntityPersister(entityName, entity), false, context, source, true);
    }

    protected Object saveWithGeneratedId(Object entity, String entityName, C context, EventSource source, boolean requiresImmediateIdAccess) {
        this.callbackRegistry.preCreate(entity);
        ManagedTypeHelper.processIfSelfDirtinessTracker(entity, SelfDirtinessTracker::$$_hibernate_clearDirtyAttributes);
        EntityPersister persister = source.getEntityPersister(entityName, entity);
        Generator generator = persister.getGenerator();
        if (!generator.generatedOnExecution()) {
            Object generatedId = ((BeforeExecutionGenerator)generator).generate(source, entity, null, EventType.INSERT);
            if (generatedId == null) {
                throw new IdentifierGenerationException("null id generated for: " + entity.getClass());
            }
            if (generatedId == IdentifierGeneratorHelper.SHORT_CIRCUIT_INDICATOR) {
                return source.getIdentifier(entity);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debugf("Generated identifier: %s, using strategy: %s", persister.getIdentifierType().toLoggableString(generatedId, source.getFactory()), generator.getClass().getName());
            }
            return this.performSave(entity, generatedId, persister, false, context, source, true);
        }
        return this.performSave(entity, null, persister, true, context, source, requiresImmediateIdAccess);
    }

    protected Object performSave(Object entity, Object id, EntityPersister persister, boolean useIdentityColumn, C context, EventSource source, boolean requiresImmediateIdAccess) {
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Saving {0}", MessageHelper.infoString(persister, id, source.getFactory()));
        }
        EntityKey key = AbstractSaveEventListener.entityKey(entity, id, persister, useIdentityColumn, source);
        if (this.invokeSaveLifecycle(entity, persister, source)) {
            return id;
        }
        return this.performSaveOrReplicate(entity, key, persister, useIdentityColumn, context, source, requiresImmediateIdAccess);
    }

    private static EntityKey entityKey(Object entity, Object id, EntityPersister persister, boolean useIdentityColumn, EventSource source) {
        if (!useIdentityColumn) {
            EntityKey key = source.generateEntityKey(id, persister);
            PersistenceContext persistenceContext = source.getPersistenceContextInternal();
            Object old = persistenceContext.getEntity(key);
            if (old != null) {
                if (persistenceContext.getEntry(old).getStatus() == Status.DELETED) {
                    source.forceFlush(persistenceContext.getEntry(old));
                } else {
                    throw new NonUniqueObjectException(id, persister.getEntityName());
                }
            }
            persister.setIdentifier(entity, id, source);
            return key;
        }
        return null;
    }

    protected boolean invokeSaveLifecycle(Object entity, EntityPersister persister, EventSource source) {
        if (persister.implementsLifecycle()) {
            LOG.debug("Calling onSave()");
            if (((Lifecycle)entity).onSave(source)) {
                LOG.debug("Insertion vetoed by onSave()");
                return true;
            }
        }
        return false;
    }

    protected Object performSaveOrReplicate(Object entity, EntityKey key, EntityPersister persister, boolean useIdentityColumn, C context, EventSource source, boolean requiresImmediateIdAccess) {
        EntityEntryExtraState extraState;
        Object id = key == null ? null : key.getIdentifier();
        boolean shouldDelayIdentityInserts = !source.isTransactionInProgress() && !requiresImmediateIdAccess;
        PersistenceContext persistenceContext = source.getPersistenceContextInternal();
        EntityEntry original = persistenceContext.addEntry(entity, Status.SAVING, null, null, id, null, LockMode.WRITE, useIdentityColumn, persister, false);
        this.cascadeBeforeSave(source, persister, entity, context);
        AbstractEntityInsertAction insert = this.addInsertAction(this.cloneAndSubstituteValues(entity, persister, context, source, id), id, entity, persister, useIdentityColumn, source, shouldDelayIdentityInserts);
        this.cascadeAfterSave(source, persister, entity, context);
        Object finalId = AbstractSaveEventListener.handleGeneratedId(useIdentityColumn, id, insert);
        EntityEntry newEntry = persistenceContext.getEntry(entity);
        if (newEntry != original && (extraState = newEntry.getExtraState(EntityEntryExtraState.class)) == null) {
            newEntry.addExtraState(original.getExtraState(EntityEntryExtraState.class));
        }
        return finalId;
    }

    private static Object handleGeneratedId(boolean useIdentityColumn, Object id, AbstractEntityInsertAction insert) {
        if (useIdentityColumn && insert.isEarlyInsert()) {
            if (insert instanceof EntityIdentityInsertAction) {
                Object generatedId = ((EntityIdentityInsertAction)insert).getGeneratedId();
                insert.handleNaturalIdPostSaveNotifications(generatedId);
                return generatedId;
            }
            throw new IllegalStateException("Insert should be using an identity column, but action is of unexpected type: " + insert.getClass().getName());
        }
        return id;
    }

    private Object[] cloneAndSubstituteValues(Object entity, EntityPersister persister, C context, EventSource source, Object id) {
        Object[] values = persister.getPropertyValuesToInsert(entity, this.getMergeMap(context), source);
        Type[] types = persister.getPropertyTypes();
        boolean substitute = this.substituteValuesIfNecessary(entity, id, values, persister, source);
        if (persister.hasCollections()) {
            boolean bl = substitute = this.visitCollectionsBeforeSave(entity, id, values, types, source) || substitute;
        }
        if (substitute) {
            persister.setValues(entity, values);
        }
        TypeHelper.deepCopy(values, types, persister.getPropertyUpdateability(), values, source);
        return values;
    }

    private AbstractEntityInsertAction addInsertAction(Object[] values, Object id, Object entity, EntityPersister persister, boolean useIdentityColumn, EventSource source, boolean shouldDelayIdentityInserts) {
        if (useIdentityColumn) {
            EntityIdentityInsertAction insert = new EntityIdentityInsertAction(values, entity, persister, this.isVersionIncrementDisabled(), source, shouldDelayIdentityInserts);
            source.getActionQueue().addAction(insert);
            return insert;
        }
        EntityInsertAction insert = new EntityInsertAction(id, values, entity, Versioning.getVersion(values, persister), persister, this.isVersionIncrementDisabled(), source);
        source.getActionQueue().addAction(insert);
        return insert;
    }

    protected Map<Object, Object> getMergeMap(C anything) {
        return null;
    }

    protected boolean isVersionIncrementDisabled() {
        return false;
    }

    protected boolean visitCollectionsBeforeSave(Object entity, Object id, Object[] values, Type[] types, EventSource source) {
        WrapVisitor visitor = new WrapVisitor(entity, id, source);
        visitor.processEntityPropertyValues(values, types);
        return visitor.isSubstitutionRequired();
    }

    protected boolean substituteValuesIfNecessary(Object entity, Object id, Object[] values, EntityPersister persister, SessionImplementor source) {
        boolean substitute = source.getInterceptor().onSave(entity, id, values, persister.getPropertyNames(), persister.getPropertyTypes());
        if (persister.isVersioned()) {
            substitute = Versioning.seedVersion(entity, values, persister, (SharedSessionContractImplementor)source) || substitute;
        }
        return substitute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cascadeBeforeSave(EventSource source, EntityPersister persister, Object entity, C context) {
        PersistenceContext persistenceContext = source.getPersistenceContextInternal();
        persistenceContext.incrementCascadeLevel();
        try {
            Cascade.cascade(this.getCascadeAction(), CascadePoint.BEFORE_INSERT_AFTER_DELETE, source, persister, entity, context);
        }
        finally {
            persistenceContext.decrementCascadeLevel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cascadeAfterSave(EventSource source, EntityPersister persister, Object entity, C context) {
        PersistenceContext persistenceContext = source.getPersistenceContextInternal();
        persistenceContext.incrementCascadeLevel();
        try {
            Cascade.cascade(this.getCascadeAction(), CascadePoint.AFTER_INSERT_BEFORE_DELETE, source, persister, entity, context);
        }
        finally {
            persistenceContext.decrementCascadeLevel();
        }
    }

    protected abstract CascadingAction<C> getCascadeAction();
}

