/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import java.util.ArrayList;
import org.hibernate.LockOptions;
import org.hibernate.engine.internal.BatchFetchQueueHelper;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.SubselectFetch;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.loader.ast.internal.LoaderSelectBuilder;
import org.hibernate.loader.ast.internal.SingleIdEntityLoaderStandardImpl;
import org.hibernate.loader.ast.internal.SingleIdEntityLoaderSupport;
import org.hibernate.loader.ast.spi.Loadable;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryOptionsAdapter;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.BaseExecutionContext;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.results.graph.entity.LoadingEntityEntry;
import org.hibernate.sql.results.internal.RowTransformerStandardImpl;
import org.hibernate.sql.results.spi.ListResultsConsumer;
import org.jboss.logging.Logger;

public class SingleIdEntityLoaderDynamicBatch<T>
extends SingleIdEntityLoaderSupport<T> {
    private static final Logger log = Logger.getLogger(SingleIdEntityLoaderDynamicBatch.class);
    private final int maxBatchSize;
    private SingleIdEntityLoaderStandardImpl<T> singleIdLoader;

    public SingleIdEntityLoaderDynamicBatch(EntityMappingType entityDescriptor, int maxBatchSize, SessionFactoryImplementor sessionFactory) {
        super(entityDescriptor, sessionFactory);
        this.maxBatchSize = maxBatchSize;
    }

    @Override
    public T load(Object pkValue, LockOptions lockOptions, Boolean readOnly, SharedSessionContractImplementor session) {
        return this.load(pkValue, null, lockOptions, readOnly, session);
    }

    @Override
    public T load(Object pkValue, Object entityInstance, LockOptions lockOptions, Boolean readOnly, SharedSessionContractImplementor session) {
        Object[] batchIds = session.getPersistenceContextInternal().getBatchFetchQueue().getBatchLoadableEntityIds(this.getLoadable(), pkValue, this.maxBatchSize);
        int numberOfIds = ArrayHelper.countNonNull(batchIds);
        if (numberOfIds <= 1) {
            this.initializeSingleIdLoaderIfNeeded(session);
            T result = this.singleIdLoader.load(pkValue, entityInstance, lockOptions, readOnly, session);
            if (result == null) {
                BatchFetchQueueHelper.removeBatchLoadableEntityKey(pkValue, this.getLoadable(), session);
            }
            return result;
        }
        Object[] idsToLoad = new Object[numberOfIds];
        System.arraycopy(batchIds, 0, idsToLoad, 0, numberOfIds);
        if (log.isDebugEnabled()) {
            log.debugf("Batch loading entity [%s] : %s", (Object)this.getLoadable().getEntityName(), (Object)idsToLoad);
        }
        ArrayList<JdbcParameter> jdbcParameters = new ArrayList<JdbcParameter>();
        SelectStatement sqlAst = LoaderSelectBuilder.createSelect((Loadable)this.getLoadable(), null, this.getLoadable().getIdentifierMapping(), null, numberOfIds, session.getLoadQueryInfluencers(), lockOptions, jdbcParameters::add, session.getFactory());
        SessionFactoryImplementor sessionFactory = session.getFactory();
        JdbcServices jdbcServices = sessionFactory.getJdbcServices();
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        SqlAstTranslatorFactory sqlAstTranslatorFactory = jdbcEnvironment.getSqlAstTranslatorFactory();
        JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl(this.getLoadable().getIdentifierMapping().getJdbcTypeCount());
        int offset = 0;
        for (int i = 0; i < numberOfIds; ++i) {
            offset += jdbcParameterBindings.registerParametersForEachJdbcValue(idsToLoad[i], offset, this.getLoadable().getIdentifierMapping(), jdbcParameters, session);
        }
        assert (offset == jdbcParameters.size());
        JdbcOperationQuerySelect jdbcSelect = sqlAstTranslatorFactory.buildSelectTranslator(sessionFactory, sqlAst).translate(jdbcParameterBindings, QueryOptions.NONE);
        SubselectFetch.RegistrationHandler subSelectFetchableKeysHandler = SubselectFetch.createRegistrationHandler(session.getPersistenceContext().getBatchFetchQueue(), sqlAst, jdbcParameters, jdbcParameterBindings);
        session.getJdbcServices().getJdbcSelectExecutor().list(jdbcSelect, jdbcParameterBindings, this.getExecutionContext(pkValue, entityInstance, readOnly, lockOptions, session, subSelectFetchableKeysHandler), RowTransformerStandardImpl.instance(), ListResultsConsumer.UniqueSemantic.FILTER);
        for (int i = 0; i < idsToLoad.length; ++i) {
            Object id = idsToLoad[i];
            BatchFetchQueueHelper.removeBatchLoadableEntityKey(id, this.getLoadable(), session);
        }
        EntityKey entityKey = session.generateEntityKey(pkValue, this.getLoadable().getEntityPersister());
        return (T)session.getPersistenceContext().getEntity(entityKey);
    }

    private ExecutionContext getExecutionContext(Object entityId, Object entityInstance, Boolean readOnly, LockOptions lockOptions, SharedSessionContractImplementor session, SubselectFetch.RegistrationHandler subSelectFetchableKeysHandler) {
        return new SingleIdExecutionContext(session, entityInstance, entityId, readOnly, lockOptions, subSelectFetchableKeysHandler);
    }

    private void initializeSingleIdLoaderIfNeeded(SharedSessionContractImplementor session) {
        if (this.singleIdLoader == null) {
            this.singleIdLoader = new SingleIdEntityLoaderStandardImpl(this.getLoadable(), session.getFactory());
            this.singleIdLoader.prepare();
        }
    }

    private static class SingleIdExecutionContext
    extends BaseExecutionContext {
        private final Object entityInstance;
        private final Object entityId;
        private final Boolean readOnly;
        private final LockOptions lockOptions;
        private final SubselectFetch.RegistrationHandler subSelectFetchableKeysHandler;

        public SingleIdExecutionContext(SharedSessionContractImplementor session, Object entityInstance, Object entityId, Boolean readOnly, LockOptions lockOptions, SubselectFetch.RegistrationHandler subSelectFetchableKeysHandler) {
            super(session);
            this.entityInstance = entityInstance;
            this.entityId = entityId;
            this.readOnly = readOnly;
            this.lockOptions = lockOptions;
            this.subSelectFetchableKeysHandler = subSelectFetchableKeysHandler;
        }

        @Override
        public Object getEntityInstance() {
            return this.entityInstance;
        }

        @Override
        public Object getEntityId() {
            return this.entityId;
        }

        @Override
        public QueryOptions getQueryOptions() {
            return new QueryOptionsAdapter(){

                @Override
                public Boolean isReadOnly() {
                    return readOnly;
                }

                @Override
                public LockOptions getLockOptions() {
                    return lockOptions;
                }
            };
        }

        @Override
        public void registerLoadingEntityEntry(EntityKey entityKey, LoadingEntityEntry entry) {
            this.subSelectFetchableKeysHandler.addKey(entityKey, entry);
        }
    }
}

