/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.io.Serializable;
import java.util.Locale;
import java.util.function.Function;
import org.hibernate.MappingException;
import org.hibernate.SharedSessionContract;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.aggregate.AggregateSupport;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.mapping.AggregateColumn;
import org.hibernate.mapping.Any;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Value;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SelectableMappings;
import org.hibernate.metamodel.mapping.SelectablePath;
import org.hibernate.metamodel.mapping.internal.AbstractEmbeddableMapping;
import org.hibernate.metamodel.mapping.internal.DiscriminatedAssociationAttributeMapping;
import org.hibernate.metamodel.mapping.internal.EmbeddedAttributeMapping;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationHelper;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.mapping.internal.MutableAttributeMappingList;
import org.hibernate.metamodel.mapping.internal.SelectableMappingImpl;
import org.hibernate.metamodel.mapping.internal.SimpleAttributeMetadata;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.metamodel.spi.EmbeddableRepresentationStrategy;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupProducer;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.embeddable.internal.EmbeddableResultImpl;
import org.hibernate.type.AnyType;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.CollectionType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.spi.CompositeTypeImplementor;
import org.hibernate.type.spi.TypeConfiguration;

public class EmbeddableMappingTypeImpl
extends AbstractEmbeddableMapping
implements SelectableMappings {
    private final JavaType<?> embeddableJtd;
    private final EmbeddableRepresentationStrategy representationStrategy;
    private final EmbeddableValuedModelPart valueMapping;
    private final boolean createEmptyCompositesEnabled;
    private final SelectableMapping aggregateMapping;
    private final boolean aggregateMappingRequiresColumnWriter;
    private final boolean preferSelectAggregateMapping;
    private final boolean preferBindAggregateMapping;

    public static EmbeddableMappingTypeImpl from(Component bootDescriptor, CompositeType compositeType, boolean[] insertability, boolean[] updateability, Function<EmbeddableMappingType, EmbeddableValuedModelPart> embeddedPartBuilder, MappingModelCreationProcess creationProcess) {
        return EmbeddableMappingTypeImpl.from(bootDescriptor, compositeType, null, null, null, null, 0, insertability, updateability, embeddedPartBuilder, creationProcess);
    }

    public static EmbeddableMappingTypeImpl from(Component bootDescriptor, CompositeType compositeType, String rootTableExpression, String[] rootTableKeyColumnNames, Property componentProperty, DependantValue dependantValue, int dependantColumnIndex, boolean[] insertability, boolean[] updateability, Function<EmbeddableMappingType, EmbeddableValuedModelPart> embeddedPartBuilder, MappingModelCreationProcess creationProcess) {
        RuntimeModelCreationContext creationContext = creationProcess.getCreationContext();
        EmbeddableMappingTypeImpl mappingType = new EmbeddableMappingTypeImpl(bootDescriptor, componentProperty, embeddedPartBuilder, creationContext);
        if (compositeType instanceof CompositeTypeImplementor) {
            ((CompositeTypeImplementor)compositeType).injectMappingModelPart(mappingType.getEmbeddedValueMapping(), creationProcess);
        }
        creationProcess.registerInitializationCallback("EmbeddableMappingType(" + mappingType.getNavigableRole().getFullPath() + ")#finishInitialization", () -> mappingType.finishInitialization(bootDescriptor, compositeType, rootTableExpression, rootTableKeyColumnNames, dependantValue, dependantColumnIndex, insertability, updateability, creationProcess));
        return mappingType;
    }

    private EmbeddableMappingTypeImpl(Component bootDescriptor, Property componentProperty, Function<EmbeddableMappingType, EmbeddableValuedModelPart> embeddedPartBuilder, RuntimeModelCreationContext creationContext) {
        super(new MutableAttributeMappingList(5));
        this.representationStrategy = creationContext.getBootstrapContext().getRepresentationStrategySelector().resolveStrategy(bootDescriptor, () -> this, creationContext);
        this.embeddableJtd = this.representationStrategy.getMappedJavaType();
        this.valueMapping = embeddedPartBuilder.apply(this);
        this.createEmptyCompositesEnabled = ConfigurationHelper.getBoolean("hibernate.create_empty_composites.enabled", creationContext.getServiceRegistry().getService(ConfigurationService.class).getSettings(), false);
        AggregateColumn aggregateColumn = bootDescriptor.getAggregateColumn();
        if (aggregateColumn != null) {
            boolean updatable;
            boolean insertable;
            Dialect dialect = creationContext.getDialect();
            if (componentProperty == null) {
                insertable = true;
                updatable = true;
            } else {
                insertable = componentProperty.isInsertable();
                updatable = componentProperty.isUpdateable();
            }
            this.aggregateMapping = SelectableMappingImpl.from(bootDescriptor.getOwner().getTable().getName(), (Selectable)aggregateColumn, bootDescriptor.getParentAggregateColumn() != null ? bootDescriptor.getParentAggregateColumn().getSelectablePath() : null, this.resolveJdbcMapping(bootDescriptor, creationContext), creationContext.getTypeConfiguration(), insertable, updatable, false, dialect, null);
            AggregateSupport aggregateSupport = dialect.getAggregateSupport();
            int sqlTypeCode = aggregateColumn.getSqlTypeCode();
            this.aggregateMappingRequiresColumnWriter = aggregateSupport.requiresAggregateCustomWriteExpressionRenderer(sqlTypeCode);
            this.preferSelectAggregateMapping = aggregateSupport.preferSelectAggregateMapping(sqlTypeCode);
            this.preferBindAggregateMapping = aggregateSupport.preferBindAggregateMapping(sqlTypeCode);
        } else {
            this.aggregateMapping = null;
            this.aggregateMappingRequiresColumnWriter = false;
            this.preferSelectAggregateMapping = false;
            this.preferBindAggregateMapping = false;
        }
    }

    private JdbcMapping resolveJdbcMapping(Component bootDescriptor, RuntimeModelCreationContext creationContext) {
        TypeConfiguration typeConfiguration = creationContext.getTypeConfiguration();
        BasicTypeRegistry basicTypeRegistry = typeConfiguration.getBasicTypeRegistry();
        AggregateColumn aggregateColumn = bootDescriptor.getAggregateColumn();
        BasicType<?> basicType = basicTypeRegistry.resolve(this.getMappedJavaType(), typeConfiguration.getJdbcTypeRegistry().resolveAggregateDescriptor(aggregateColumn.getSqlTypeCode(), aggregateColumn.getSqlTypeCode() == 2002 ? aggregateColumn.getSqlType() : null, this, creationContext));
        if (bootDescriptor.getStructName() != null) {
            basicTypeRegistry.register(basicType, bootDescriptor.getStructName());
            basicTypeRegistry.register(basicType, this.getMappedJavaType().getJavaTypeClass().getName());
        }
        return basicType;
    }

    public EmbeddableMappingTypeImpl(EmbeddedAttributeMapping valueMapping, TableGroupProducer declaringTableGroupProducer, SelectableMappings selectableMappings, EmbeddableMappingType inverseMappingType, MappingModelCreationProcess creationProcess) {
        super(new MutableAttributeMappingList(5));
        this.embeddableJtd = inverseMappingType.getJavaType();
        this.representationStrategy = inverseMappingType.getRepresentationStrategy();
        this.valueMapping = valueMapping;
        this.createEmptyCompositesEnabled = inverseMappingType.isCreateEmptyCompositesEnabled();
        this.aggregateMapping = null;
        this.aggregateMappingRequiresColumnWriter = false;
        this.preferSelectAggregateMapping = false;
        this.preferBindAggregateMapping = false;
        this.selectableMappings = selectableMappings;
        creationProcess.registerInitializationCallback("EmbeddableMappingType(" + inverseMappingType.getNavigableRole().getFullPath() + ".{inverse})#finishInitialization", () -> this.inverseInitializeCallback(declaringTableGroupProducer, selectableMappings, inverseMappingType, creationProcess, valueMapping.getDeclaringType(), this.attributeMappings));
    }

    @Override
    public EmbeddableMappingType createInverseMappingType(EmbeddedAttributeMapping valueMapping, TableGroupProducer declaringTableGroupProducer, SelectableMappings selectableMappings, MappingModelCreationProcess creationProcess) {
        return new EmbeddableMappingTypeImpl(valueMapping, declaringTableGroupProducer, selectableMappings, this, creationProcess);
    }

    private boolean finishInitialization(Component bootDescriptor, CompositeType compositeType, String rootTableExpression, String[] rootTableKeyColumnNames, DependantValue dependantValue, int dependantColumnIndex, boolean[] insertability, boolean[] updateability, MappingModelCreationProcess creationProcess) {
        TypeConfiguration typeConfiguration = creationProcess.getCreationContext().getTypeConfiguration();
        JdbcServices jdbcServices = creationProcess.getCreationContext().getJdbcServices();
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        Dialect dialect = jdbcEnvironment.getDialect();
        String baseTableExpression = this.valueMapping.getContainingTableExpression();
        Type[] subtypes = compositeType.getSubtypes();
        int attributeIndex = 0;
        int columnPosition = 0;
        this.attributeMappings.clear();
        for (Property bootPropertyDescriptor : bootDescriptor.getProperties()) {
            AttributeMapping attributeMapping;
            Type subtype = subtypes[attributeIndex];
            Value value = bootPropertyDescriptor.getValue();
            if (subtype instanceof BasicType) {
                SelectablePath selectablePath;
                boolean nullable;
                Integer scale;
                Integer precision;
                Long length;
                String columnDefinition;
                String containingTableExpression;
                String columnExpression;
                Selectable selectable;
                BasicValue basicValue = (BasicValue)value;
                Selectable selectable2 = selectable = dependantValue != null ? (Selectable)dependantValue.getColumns().get(dependantColumnIndex + columnPosition) : basicValue.getColumn();
                if (rootTableKeyColumnNames == null) {
                    columnExpression = selectable.isFormula() ? selectable.getTemplate(dialect, creationProcess.getCreationContext().getTypeConfiguration(), creationProcess.getSqmFunctionRegistry()) : selectable.getText(dialect);
                    if (selectable instanceof Column) {
                        Column column = (Column)selectable;
                        containingTableExpression = MappingModelCreationHelper.getTableIdentifierExpression(column.getValue().getTable(), creationProcess);
                    } else {
                        containingTableExpression = baseTableExpression;
                    }
                } else {
                    containingTableExpression = rootTableExpression;
                    columnExpression = rootTableKeyColumnNames[columnPosition];
                }
                if (selectable instanceof Column) {
                    Column column = (Column)selectable;
                    columnDefinition = column.getSqlType();
                    length = column.getLength();
                    precision = column.getPrecision();
                    scale = column.getScale();
                    nullable = column.isNullable();
                    selectablePath = basicValue.createSelectablePath(column.getQuotedName(dialect));
                } else {
                    columnDefinition = null;
                    length = null;
                    precision = null;
                    scale = null;
                    nullable = true;
                    selectablePath = basicValue.createSelectablePath(bootPropertyDescriptor.getName());
                }
                attributeMapping = MappingModelCreationHelper.buildBasicAttributeMapping(bootPropertyDescriptor.getName(), this.valueMapping.getNavigableRole().append(bootPropertyDescriptor.getName()), attributeIndex, attributeIndex, bootPropertyDescriptor, this, (BasicType)subtype, containingTableExpression, columnExpression, selectablePath, selectable.isFormula(), selectable.getCustomReadExpression(), selectable.getWriteExpr(((BasicType)subtype).getJdbcMapping(), dialect), columnDefinition, length, precision, scale, nullable, insertability[columnPosition], updateability[columnPosition], this.representationStrategy.resolvePropertyAccess(bootPropertyDescriptor), compositeType.getCascadeStyle(attributeIndex), creationProcess);
                ++columnPosition;
            } else if (subtype instanceof AnyType) {
                Any bootValueMapping = (Any)value;
                AnyType anyType = (AnyType)subtype;
                PropertyAccess propertyAccess = this.representationStrategy.resolvePropertyAccess(bootPropertyDescriptor);
                boolean nullable = bootValueMapping.isNullable();
                boolean insertable = insertability[columnPosition];
                boolean updateable = updateability[columnPosition];
                boolean includeInOptimisticLocking = bootPropertyDescriptor.isOptimisticLocked();
                CascadeStyle cascadeStyle = compositeType.getCascadeStyle(attributeIndex);
                SimpleAttributeMetadata attributeMetadataAccess = new SimpleAttributeMetadata(propertyAccess, EmbeddableMappingTypeImpl.getMutabilityPlan(updateable), nullable, insertable, updateable, includeInOptimisticLocking, true, cascadeStyle);
                attributeMapping = new DiscriminatedAssociationAttributeMapping(this.valueMapping.getNavigableRole().append(bootPropertyDescriptor.getName()), typeConfiguration.getJavaTypeRegistry().getDescriptor((java.lang.reflect.Type)((Object)Object.class)), this, attributeIndex, attributeIndex, attributeMetadataAccess, bootPropertyDescriptor.isLazy() ? FetchTiming.DELAYED : FetchTiming.IMMEDIATE, propertyAccess, bootPropertyDescriptor, anyType, bootValueMapping, creationProcess);
            } else if (subtype instanceof CompositeType) {
                String[] subRootTableKeyColumnNames;
                String subTableExpression;
                CompositeType subCompositeType = (CompositeType)subtype;
                int columnSpan = subCompositeType.getColumnSpan(creationProcess.getCreationContext().getMetadata());
                if (rootTableKeyColumnNames == null) {
                    subTableExpression = baseTableExpression;
                    subRootTableKeyColumnNames = null;
                } else {
                    subTableExpression = rootTableExpression;
                    subRootTableKeyColumnNames = new String[columnSpan];
                    System.arraycopy(rootTableKeyColumnNames, columnPosition, subRootTableKeyColumnNames, 0, columnSpan);
                }
                attributeMapping = MappingModelCreationHelper.buildEmbeddedAttributeMapping(bootPropertyDescriptor.getName(), attributeIndex, attributeIndex, bootPropertyDescriptor, dependantValue, dependantColumnIndex + columnPosition, this, subCompositeType, subTableExpression, subRootTableKeyColumnNames, this.representationStrategy.resolvePropertyAccess(bootPropertyDescriptor), compositeType.getCascadeStyle(attributeIndex), creationProcess);
                columnPosition += columnSpan;
            } else if (subtype instanceof CollectionType) {
                attributeMapping = MappingModelCreationHelper.buildPluralAttributeMapping(bootPropertyDescriptor.getName(), attributeIndex, attributeIndex, bootPropertyDescriptor, this, this.representationStrategy.resolvePropertyAccess(bootPropertyDescriptor), compositeType.getCascadeStyle(attributeIndex), compositeType.getFetchMode(attributeIndex), creationProcess);
            } else if (subtype instanceof EntityType) {
                EntityPersister entityPersister = creationProcess.getEntityPersister(bootDescriptor.getOwner().getEntityName());
                attributeMapping = MappingModelCreationHelper.buildSingularAssociationAttributeMapping(bootPropertyDescriptor.getName(), this.valueMapping.getNavigableRole().append(bootPropertyDescriptor.getName()), attributeIndex, attributeIndex, bootPropertyDescriptor, this, entityPersister, (EntityType)subtype, this.getRepresentationStrategy().resolvePropertyAccess(bootPropertyDescriptor), compositeType.getCascadeStyle(attributeIndex), creationProcess);
                columnPosition += bootPropertyDescriptor.getColumnSpan();
            } else {
                throw new MappingException(String.format(Locale.ROOT, "Unable to determine attribute nature : %s#%s", bootDescriptor.getOwner().getEntityName(), bootPropertyDescriptor.getName()));
            }
            this.addAttribute(attributeMapping);
            ++attributeIndex;
        }
        creationProcess.registerInitializationCallback("EmbeddableMappingType(" + this.getEmbeddedValueMapping().getNavigableRole().getFullPath() + ")#initColumnMappings", this::initColumnMappings);
        return true;
    }

    private static MutabilityPlan<?> getMutabilityPlan(boolean updateable) {
        if (updateable) {
            return new MutabilityPlan<Object>(){

                @Override
                public boolean isMutable() {
                    return true;
                }

                @Override
                public Object deepCopy(Object value) {
                    return value;
                }

                @Override
                public Serializable disassemble(Object value, SharedSessionContract session) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public Object assemble(Serializable cached, SharedSessionContract session) {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return ImmutableMutabilityPlan.INSTANCE;
    }

    @Override
    public EmbeddableValuedModelPart getEmbeddedValueMapping() {
        return this.valueMapping;
    }

    @Override
    public JavaType<?> getMappedJavaType() {
        return this.embeddableJtd;
    }

    @Override
    public EmbeddableRepresentationStrategy getRepresentationStrategy() {
        return this.representationStrategy;
    }

    @Override
    public String getPartName() {
        return this.getEmbeddedValueMapping().getPartName();
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.valueMapping.getNavigableRole();
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        return new EmbeddableResultImpl(navigablePath, this.valueMapping, resultVariable, creationState);
    }

    @Override
    public <X, Y> int breakDownJdbcValues(Object domainValue, int offset, X x, Y y, ModelPart.JdbcValueBiConsumer<X, Y> valueConsumer, SharedSessionContractImplementor session) {
        int size = this.attributeMappings.size();
        int span = 0;
        if (domainValue instanceof Object[]) {
            Object[] values = (Object[])domainValue;
            assert (values.length == size);
            for (int i = 0; i < size; ++i) {
                AttributeMapping attributeMapping = this.attributeMappings.get(i);
                Object attributeValue = values[i];
                span += attributeMapping.breakDownJdbcValues(attributeValue, offset + span, x, y, valueConsumer, session);
            }
        } else {
            for (int i = 0; i < size; ++i) {
                AttributeMapping attributeMapping = this.attributeMappings.get(i);
                Object attributeValue = domainValue == null ? null : attributeMapping.getPropertyAccess().getGetter().get(domainValue);
                span += attributeMapping.breakDownJdbcValues(attributeValue, offset + span, x, y, valueConsumer, session);
            }
        }
        return span;
    }

    @Override
    public <X, Y> int decompose(Object domainValue, int offset, X x, Y y, ModelPart.JdbcValueBiConsumer<X, Y> valueConsumer, SharedSessionContractImplementor session) {
        if (this.shouldBindAggregateMapping()) {
            valueConsumer.consume(offset, x, y, domainValue, this.aggregateMapping);
            return 1;
        }
        int span = 0;
        if (domainValue instanceof Object[]) {
            Object[] values = (Object[])domainValue;
            assert (values.length == this.attributeMappings.size());
            for (int i = 0; i < this.attributeMappings.size(); ++i) {
                AttributeMapping attributeMapping = this.attributeMappings.get(i);
                Object attributeValue = values[i];
                span += attributeMapping.decompose(attributeValue, offset + span, x, y, valueConsumer, session);
            }
        } else {
            for (int i = 0; i < this.attributeMappings.size(); ++i) {
                AttributeMapping attributeMapping = this.attributeMappings.get(i);
                if (attributeMapping instanceof PluralAttributeMapping) continue;
                Object attributeValue = domainValue == null ? null : attributeMapping.getPropertyAccess().getGetter().get(domainValue);
                span += attributeMapping.decompose(attributeValue, offset + span, x, y, valueConsumer, session);
            }
        }
        return span;
    }

    @Override
    public void forEachInsertable(int offset, SelectableConsumer consumer) {
        if (this.shouldMutateAggregateMapping()) {
            if (this.aggregateMapping.isInsertable()) {
                consumer.accept(offset, this.aggregateMapping);
            }
        } else {
            int jdbcTypeCount = this.selectableMappings.getJdbcTypeCount();
            for (int i = 0; i < jdbcTypeCount; ++i) {
                SelectableMapping selectable = this.selectableMappings.getSelectable(i);
                if (!selectable.isInsertable()) continue;
                consumer.accept(offset + i, selectable);
            }
        }
    }

    @Override
    public void forEachUpdatable(int offset, SelectableConsumer consumer) {
        if (this.shouldMutateAggregateMapping()) {
            if (this.aggregateMapping.isUpdateable()) {
                consumer.accept(offset, this.aggregateMapping);
            }
        } else {
            int jdbcTypeCount = this.selectableMappings.getJdbcTypeCount();
            for (int i = 0; i < jdbcTypeCount; ++i) {
                SelectableMapping selectable = this.selectableMappings.getSelectable(i);
                if (!selectable.isUpdateable()) continue;
                consumer.accept(offset + i, selectable);
            }
        }
    }

    @Override
    public EntityMappingType findContainingEntityMapping() {
        return this.valueMapping.findContainingEntityMapping();
    }

    @Override
    public boolean isCreateEmptyCompositesEnabled() {
        return this.createEmptyCompositesEnabled;
    }

    @Override
    public SelectableMapping getAggregateMapping() {
        return this.aggregateMapping;
    }

    @Override
    public boolean requiresAggregateColumnWriter() {
        return this.aggregateMappingRequiresColumnWriter;
    }

    @Override
    public boolean shouldSelectAggregateMapping() {
        return this.preferSelectAggregateMapping;
    }

    @Override
    public boolean shouldBindAggregateMapping() {
        return this.preferBindAggregateMapping;
    }
}

