/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.collection.mutation;

import java.util.ArrayList;
import java.util.Iterator;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.jdbc.batch.internal.BasicBatchKey;
import org.hibernate.engine.jdbc.mutation.MutationExecutor;
import org.hibernate.engine.jdbc.mutation.spi.MutationExecutorService;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.persister.collection.mutation.AbstractUpdateRowsCoordinator;
import org.hibernate.persister.collection.mutation.CollectionMutationTarget;
import org.hibernate.persister.collection.mutation.RowMutationOperations;
import org.hibernate.persister.collection.mutation.UpdateRowsCoordinator;
import org.hibernate.sql.model.MutationType;
import org.hibernate.sql.model.internal.MutationOperationGroupSingle;

public class UpdateRowsCoordinatorStandard
extends AbstractUpdateRowsCoordinator
implements UpdateRowsCoordinator {
    private final RowMutationOperations rowMutationOperations;
    private MutationOperationGroupSingle operationGroup;

    public UpdateRowsCoordinatorStandard(CollectionMutationTarget mutationTarget, RowMutationOperations rowMutationOperations, SessionFactoryImplementor sessionFactory) {
        super(mutationTarget, sessionFactory);
        this.rowMutationOperations = rowMutationOperations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int doUpdate(Object key, PersistentCollection<?> collection, SharedSessionContractImplementor session) {
        MutationOperationGroupSingle operationGroup = this.getOperationGroup();
        MutationExecutorService mutationExecutorService = session.getFactory().getServiceRegistry().getService(MutationExecutorService.class);
        MutationExecutor mutationExecutor = mutationExecutorService.createExecutor(() -> new BasicBatchKey(this.getMutationTarget().getRolePath() + "#UPDATE"), operationGroup, session);
        try {
            Iterator<?> entries = collection.entries(this.getMutationTarget().getTargetPart().getCollectionDescriptor());
            int count = 0;
            if (collection.isElementRemoved()) {
                ArrayList elements = new ArrayList();
                while (entries.hasNext()) {
                    elements.add(entries.next());
                }
                for (int i = elements.size() - 1; i >= 0; --i) {
                    Object entry = elements.get(i);
                    boolean updated = this.processRow(key, collection, entry, i, mutationExecutor, session);
                    if (!updated) continue;
                    ++count;
                }
            } else {
                int position = 0;
                while (entries.hasNext()) {
                    Object entry = entries.next();
                    boolean updated = this.processRow(key, collection, entry, position++, mutationExecutor, session);
                    if (!updated) continue;
                    ++count;
                }
            }
            int n = count;
            return n;
        }
        finally {
            mutationExecutor.release();
        }
    }

    private boolean processRow(Object key, PersistentCollection<?> collection, Object entry, int entryPosition, MutationExecutor mutationExecutor, SharedSessionContractImplementor session) {
        PluralAttributeMapping attribute = this.getMutationTarget().getTargetPart();
        if (!collection.needsUpdating(entry, entryPosition, attribute)) {
            return false;
        }
        this.rowMutationOperations.getUpdateRowValues().applyValues(collection, key, entry, entryPosition, session, mutationExecutor.getJdbcValueBindings());
        this.rowMutationOperations.getUpdateRowRestrictions().applyRestrictions(collection, key, entry, entryPosition, session, mutationExecutor.getJdbcValueBindings());
        mutationExecutor.execute(collection, null, null, null, session);
        return true;
    }

    protected MutationOperationGroupSingle getOperationGroup() {
        if (this.operationGroup == null) {
            this.operationGroup = new MutationOperationGroupSingle(MutationType.UPDATE, this.getMutationTarget(), this.rowMutationOperations.getUpdateRowOperation());
        }
        return this.operationGroup;
    }
}

