
package org.hibernate.boot.jaxb.mapping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;


/**
 * 
 *                 See `@org.hibernate.annotations.NaturalId`
 *             
 * 
 * <p>Java class for natural-id complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="natural-id">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="cache" type="{http://www.hibernate.org/xsd/orm/mapping}caching" minOccurs="0"/>
 *         <element name="basic" type="{http://www.hibernate.org/xsd/orm/mapping}basic" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="many-to-one" type="{http://www.hibernate.org/xsd/orm/mapping}many-to-one" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="embedded" type="{http://www.hibernate.org/xsd/orm/mapping}embedded" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="any" type="{http://www.hibernate.org/xsd/orm/mapping}hbm-any-mapping" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *       <attribute name="mutable" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "natural-id", namespace = "http://www.hibernate.org/xsd/orm/mapping", propOrder = {
    "cache",
    "basic",
    "manyToOne",
    "embedded",
    "any"
})
public class JaxbNaturalId
    implements Serializable
{

    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected JaxbCaching cache;
    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected List<JaxbBasic> basic;
    @XmlElement(name = "many-to-one", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected List<JaxbManyToOne> manyToOne;
    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected List<JaxbEmbedded> embedded;
    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected List<JaxbHbmAnyMapping> any;
    @XmlAttribute(name = "mutable")
    protected Boolean mutable;

    /**
     * Gets the value of the cache property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbCaching }
     *     
     */
    public JaxbCaching getCache() {
        return cache;
    }

    /**
     * Sets the value of the cache property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbCaching }
     *     
     */
    public void setCache(JaxbCaching value) {
        this.cache = value;
    }

    /**
     * Gets the value of the basic property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the basic property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getBasic().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbBasic }
     * 
     * 
     * @return
     *     The value of the basic property.
     */
    public List<JaxbBasic> getBasic() {
        if (basic == null) {
            basic = new ArrayList<>();
        }
        return this.basic;
    }

    /**
     * Gets the value of the manyToOne property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the manyToOne property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getManyToOne().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbManyToOne }
     * 
     * 
     * @return
     *     The value of the manyToOne property.
     */
    public List<JaxbManyToOne> getManyToOne() {
        if (manyToOne == null) {
            manyToOne = new ArrayList<>();
        }
        return this.manyToOne;
    }

    /**
     * Gets the value of the embedded property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the embedded property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getEmbedded().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbEmbedded }
     * 
     * 
     * @return
     *     The value of the embedded property.
     */
    public List<JaxbEmbedded> getEmbedded() {
        if (embedded == null) {
            embedded = new ArrayList<>();
        }
        return this.embedded;
    }

    /**
     * Gets the value of the any property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the any property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAny().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbHbmAnyMapping }
     * 
     * 
     * @return
     *     The value of the any property.
     */
    public List<JaxbHbmAnyMapping> getAny() {
        if (any == null) {
            any = new ArrayList<>();
        }
        return this.any;
    }

    /**
     * Gets the value of the mutable property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isMutable() {
        if (mutable == null) {
            return false;
        } else {
            return mutable;
        }
    }

    /**
     * Sets the value of the mutable property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setMutable(Boolean value) {
        this.mutable = value;
    }

}
