
/*
 * Hibernate, Relational Persistence for Idiomatic Java
 *
 * License: GNU Lesser General Public License (LGPL), version 2.1 or later.
 * See the lgpl.txt file in the root directory or <http://www.gnu.org/licenses/lgpl-2.1.html>.
 */
package org.hibernate.grammars.hql;

import org.antlr.v4.runtime.atn.*;
import org.antlr.v4.runtime.dfa.DFA;
import org.antlr.v4.runtime.*;
import org.antlr.v4.runtime.misc.*;
import org.antlr.v4.runtime.tree.*;
import java.util.List;
import java.util.Iterator;
import java.util.ArrayList;

@SuppressWarnings({"all", "warnings", "unchecked", "unused", "cast"})
public class HqlParser extends Parser {
	static { RuntimeMetaData.checkVersion("4.10.1", RuntimeMetaData.VERSION); }

	protected static final DFA[] _decisionToDFA;
	protected static final PredictionContextCache _sharedContextCache =
		new PredictionContextCache();
	public static final int
		WS=1, COMMENT=2, INTEGER_LITERAL=3, LONG_LITERAL=4, FLOAT_LITERAL=5, DOUBLE_LITERAL=6, 
		BIG_INTEGER_LITERAL=7, BIG_DECIMAL_LITERAL=8, HEX_LITERAL=9, STRING_LITERAL=10, 
		JAVA_STRING_LITERAL=11, BINARY_LITERAL=12, TIMESTAMP_ESCAPE_START=13, 
		DATE_ESCAPE_START=14, TIME_ESCAPE_START=15, EQUAL=16, NOT_EQUAL=17, GREATER=18, 
		GREATER_EQUAL=19, LESS=20, LESS_EQUAL=21, COMMA=22, DOT=23, LEFT_PAREN=24, 
		RIGHT_PAREN=25, LEFT_BRACKET=26, RIGHT_BRACKET=27, LEFT_BRACE=28, RIGHT_BRACE=29, 
		PLUS=30, MINUS=31, ASTERISK=32, SLASH=33, PERCENT_OP=34, AMPERSAND=35, 
		SEMICOLON=36, COLON=37, PIPE=38, DOUBLE_PIPE=39, QUESTION_MARK=40, ARROW=41, 
		ID=42, VERSION=43, VERSIONED=44, NATURALID=45, FK=46, ALL=47, AND=48, 
		ANY=49, AS=50, ASC=51, AVG=52, BETWEEN=53, BOTH=54, BREADTH=55, BY=56, 
		CASE=57, CAST=58, COLLATE=59, COUNT=60, CROSS=61, CUBE=62, CURRENT=63, 
		CURRENT_DATE=64, CURRENT_INSTANT=65, CURRENT_TIME=66, CURRENT_TIMESTAMP=67, 
		CYCLE=68, DATE=69, DATETIME=70, DAY=71, DEFAULT=72, DELETE=73, DEPTH=74, 
		DESC=75, DISTINCT=76, ELEMENT=77, ELEMENTS=78, ELSE=79, EMPTY=80, END=81, 
		ENTRY=82, EPOCH=83, ERROR=84, ESCAPE=85, EVERY=86, EXCEPT=87, EXCLUDE=88, 
		EXISTS=89, EXTRACT=90, FETCH=91, FILTER=92, FIRST=93, FOLLOWING=94, FOR=95, 
		FORMAT=96, FROM=97, FULL=98, FUNCTION=99, GROUP=100, GROUPS=101, HAVING=102, 
		HOUR=103, IGNORE=104, ILIKE=105, IN=106, INDEX=107, INDICES=108, INNER=109, 
		INSERT=110, INSTANT=111, INTERSECT=112, INTO=113, IS=114, JOIN=115, KEY=116, 
		LAST=117, LATERAL=118, LEADING=119, LEFT=120, LIKE=121, LIMIT=122, LIST=123, 
		LISTAGG=124, LOCAL=125, LOCAL_DATE=126, LOCAL_DATETIME=127, LOCAL_TIME=128, 
		MAP=129, MATERIALIZED=130, MAX=131, MAXELEMENT=132, MAXINDEX=133, MEMBER=134, 
		MICROSECOND=135, MILLISECOND=136, MIN=137, MINELEMENT=138, MININDEX=139, 
		MINUTE=140, MONTH=141, NANOSECOND=142, NEW=143, NEXT=144, NO=145, NOT=146, 
		NULLS=147, OBJECT=148, OF=149, OFFSET=150, OFFSET_DATETIME=151, ON=152, 
		ONLY=153, OR=154, ORDER=155, OTHERS=156, OUTER=157, OVER=158, OVERFLOW=159, 
		OVERLAY=160, PAD=161, PARTITION=162, PERCENT=163, PLACING=164, POSITION=165, 
		PRECEDING=166, QUARTER=167, RANGE=168, RESPECT=169, RIGHT=170, ROLLUP=171, 
		ROW=172, ROWS=173, SEARCH=174, SECOND=175, SELECT=176, SET=177, SIZE=178, 
		SOME=179, SUBSTRING=180, SUM=181, THEN=182, TIES=183, TIME=184, TIMESTAMP=185, 
		TIMEZONE_HOUR=186, TIMEZONE_MINUTE=187, TO=188, TRAILING=189, TREAT=190, 
		TRIM=191, TRUNC=192, TRUNCATE=193, TYPE=194, UNBOUNDED=195, UNION=196, 
		UPDATE=197, USING=198, VALUE=199, VALUES=200, WEEK=201, WHEN=202, WHERE=203, 
		WITH=204, WITHIN=205, WITHOUT=206, YEAR=207, ZONED=208, TRUE=209, FALSE=210, 
		NULL=211, IDENTIFIER=212, QUOTED_IDENTIFIER=213;
	public static final int
		RULE_statement = 0, RULE_selectStatement = 1, RULE_subquery = 2, RULE_targetEntity = 3, 
		RULE_deleteStatement = 4, RULE_updateStatement = 5, RULE_setClause = 6, 
		RULE_assignment = 7, RULE_insertStatement = 8, RULE_targetFields = 9, 
		RULE_valuesList = 10, RULE_values = 11, RULE_withClause = 12, RULE_cte = 13, 
		RULE_cteAttributes = 14, RULE_searchClause = 15, RULE_searchSpecifications = 16, 
		RULE_searchSpecification = 17, RULE_cycleClause = 18, RULE_queryExpression = 19, 
		RULE_orderedQuery = 20, RULE_setOperator = 21, RULE_queryOrder = 22, RULE_query = 23, 
		RULE_fromClause = 24, RULE_entityWithJoins = 25, RULE_fromRoot = 26, RULE_entityName = 27, 
		RULE_variable = 28, RULE_crossJoin = 29, RULE_jpaCollectionJoin = 30, 
		RULE_join = 31, RULE_joinType = 32, RULE_joinTarget = 33, RULE_joinRestriction = 34, 
		RULE_selectClause = 35, RULE_selectionList = 36, RULE_selection = 37, 
		RULE_selectExpression = 38, RULE_mapEntrySelection = 39, RULE_instantiation = 40, 
		RULE_instantiationTarget = 41, RULE_instantiationArguments = 42, RULE_instantiationArgument = 43, 
		RULE_instantiationArgumentExpression = 44, RULE_jpaSelectObjectSyntax = 45, 
		RULE_simplePath = 46, RULE_simplePathElement = 47, RULE_path = 48, RULE_pathContinuation = 49, 
		RULE_syntacticDomainPath = 50, RULE_generalPathFragment = 51, RULE_indexedPathAccessFragment = 52, 
		RULE_treatedNavigablePath = 53, RULE_collectionValueNavigablePath = 54, 
		RULE_mapKeyNavigablePath = 55, RULE_groupByClause = 56, RULE_groupByExpression = 57, 
		RULE_havingClause = 58, RULE_orderByClause = 59, RULE_orderByFragment = 60, 
		RULE_sortSpecification = 61, RULE_nullsPrecedence = 62, RULE_sortExpression = 63, 
		RULE_sortDirection = 64, RULE_collateFunction = 65, RULE_collation = 66, 
		RULE_limitClause = 67, RULE_offsetClause = 68, RULE_fetchClause = 69, 
		RULE_parameterOrIntegerLiteral = 70, RULE_parameterOrNumberLiteral = 71, 
		RULE_whereClause = 72, RULE_predicate = 73, RULE_comparisonOperator = 74, 
		RULE_inList = 75, RULE_likeEscape = 76, RULE_expression = 77, RULE_primaryExpression = 78, 
		RULE_expressionOrPredicate = 79, RULE_multiplicativeOperator = 80, RULE_additiveOperator = 81, 
		RULE_signOperator = 82, RULE_entityTypeReference = 83, RULE_entityIdReference = 84, 
		RULE_entityVersionReference = 85, RULE_entityNaturalIdReference = 86, 
		RULE_toOneFkReference = 87, RULE_caseList = 88, RULE_simpleCaseList = 89, 
		RULE_simpleCaseWhen = 90, RULE_caseOtherwise = 91, RULE_searchedCaseList = 92, 
		RULE_searchedCaseWhen = 93, RULE_literal = 94, RULE_booleanLiteral = 95, 
		RULE_numericLiteral = 96, RULE_binaryLiteral = 97, RULE_temporalLiteral = 98, 
		RULE_dateTimeLiteral = 99, RULE_localDateTimeLiteral = 100, RULE_zonedDateTimeLiteral = 101, 
		RULE_offsetDateTimeLiteral = 102, RULE_dateLiteral = 103, RULE_timeLiteral = 104, 
		RULE_dateTime = 105, RULE_localDateTime = 106, RULE_zonedDateTime = 107, 
		RULE_offsetDateTime = 108, RULE_offsetDateTimeWithMinutes = 109, RULE_date = 110, 
		RULE_time = 111, RULE_offset = 112, RULE_offsetWithMinutes = 113, RULE_year = 114, 
		RULE_month = 115, RULE_day = 116, RULE_hour = 117, RULE_minute = 118, 
		RULE_second = 119, RULE_zoneId = 120, RULE_jdbcTimestampLiteral = 121, 
		RULE_jdbcDateLiteral = 122, RULE_jdbcTimeLiteral = 123, RULE_genericTemporalLiteralText = 124, 
		RULE_generalizedLiteral = 125, RULE_generalizedLiteralType = 126, RULE_generalizedLiteralText = 127, 
		RULE_parameter = 128, RULE_function = 129, RULE_jpaNonstandardFunction = 130, 
		RULE_jpaNonstandardFunctionName = 131, RULE_genericFunction = 132, RULE_genericFunctionName = 133, 
		RULE_genericFunctionArguments = 134, RULE_collectionSizeFunction = 135, 
		RULE_indexAggregateFunction = 136, RULE_elementAggregateFunction = 137, 
		RULE_collectionFunctionMisuse = 138, RULE_aggregateFunction = 139, RULE_everyFunction = 140, 
		RULE_anyFunction = 141, RULE_listaggFunction = 142, RULE_onOverflowClause = 143, 
		RULE_withinGroupClause = 144, RULE_filterClause = 145, RULE_nullsClause = 146, 
		RULE_nthSideClause = 147, RULE_overClause = 148, RULE_partitionClause = 149, 
		RULE_frameClause = 150, RULE_frameStart = 151, RULE_frameEnd = 152, RULE_frameExclusion = 153, 
		RULE_standardFunction = 154, RULE_castFunction = 155, RULE_castTarget = 156, 
		RULE_castTargetType = 157, RULE_substringFunction = 158, RULE_substringFunctionStartArgument = 159, 
		RULE_substringFunctionLengthArgument = 160, RULE_trimFunction = 161, RULE_trimSpecification = 162, 
		RULE_trimCharacter = 163, RULE_padFunction = 164, RULE_padSpecification = 165, 
		RULE_padCharacter = 166, RULE_padLength = 167, RULE_overlayFunction = 168, 
		RULE_overlayFunctionStringArgument = 169, RULE_overlayFunctionReplacementArgument = 170, 
		RULE_overlayFunctionStartArgument = 171, RULE_overlayFunctionLengthArgument = 172, 
		RULE_currentDateFunction = 173, RULE_currentTimeFunction = 174, RULE_currentTimestampFunction = 175, 
		RULE_instantFunction = 176, RULE_localDateTimeFunction = 177, RULE_offsetDateTimeFunction = 178, 
		RULE_localDateFunction = 179, RULE_localTimeFunction = 180, RULE_formatFunction = 181, 
		RULE_format = 182, RULE_extractFunction = 183, RULE_truncFunction = 184, 
		RULE_extractField = 185, RULE_datetimeField = 186, RULE_dayField = 187, 
		RULE_weekField = 188, RULE_timeZoneField = 189, RULE_dateOrTimeField = 190, 
		RULE_positionFunction = 191, RULE_positionFunctionPatternArgument = 192, 
		RULE_positionFunctionStringArgument = 193, RULE_cube = 194, RULE_rollup = 195, 
		RULE_nakedIdentifier = 196, RULE_identifier = 197;
	private static String[] makeRuleNames() {
		return new String[] {
			"statement", "selectStatement", "subquery", "targetEntity", "deleteStatement", 
			"updateStatement", "setClause", "assignment", "insertStatement", "targetFields", 
			"valuesList", "values", "withClause", "cte", "cteAttributes", "searchClause", 
			"searchSpecifications", "searchSpecification", "cycleClause", "queryExpression", 
			"orderedQuery", "setOperator", "queryOrder", "query", "fromClause", "entityWithJoins", 
			"fromRoot", "entityName", "variable", "crossJoin", "jpaCollectionJoin", 
			"join", "joinType", "joinTarget", "joinRestriction", "selectClause", 
			"selectionList", "selection", "selectExpression", "mapEntrySelection", 
			"instantiation", "instantiationTarget", "instantiationArguments", "instantiationArgument", 
			"instantiationArgumentExpression", "jpaSelectObjectSyntax", "simplePath", 
			"simplePathElement", "path", "pathContinuation", "syntacticDomainPath", 
			"generalPathFragment", "indexedPathAccessFragment", "treatedNavigablePath", 
			"collectionValueNavigablePath", "mapKeyNavigablePath", "groupByClause", 
			"groupByExpression", "havingClause", "orderByClause", "orderByFragment", 
			"sortSpecification", "nullsPrecedence", "sortExpression", "sortDirection", 
			"collateFunction", "collation", "limitClause", "offsetClause", "fetchClause", 
			"parameterOrIntegerLiteral", "parameterOrNumberLiteral", "whereClause", 
			"predicate", "comparisonOperator", "inList", "likeEscape", "expression", 
			"primaryExpression", "expressionOrPredicate", "multiplicativeOperator", 
			"additiveOperator", "signOperator", "entityTypeReference", "entityIdReference", 
			"entityVersionReference", "entityNaturalIdReference", "toOneFkReference", 
			"caseList", "simpleCaseList", "simpleCaseWhen", "caseOtherwise", "searchedCaseList", 
			"searchedCaseWhen", "literal", "booleanLiteral", "numericLiteral", "binaryLiteral", 
			"temporalLiteral", "dateTimeLiteral", "localDateTimeLiteral", "zonedDateTimeLiteral", 
			"offsetDateTimeLiteral", "dateLiteral", "timeLiteral", "dateTime", "localDateTime", 
			"zonedDateTime", "offsetDateTime", "offsetDateTimeWithMinutes", "date", 
			"time", "offset", "offsetWithMinutes", "year", "month", "day", "hour", 
			"minute", "second", "zoneId", "jdbcTimestampLiteral", "jdbcDateLiteral", 
			"jdbcTimeLiteral", "genericTemporalLiteralText", "generalizedLiteral", 
			"generalizedLiteralType", "generalizedLiteralText", "parameter", "function", 
			"jpaNonstandardFunction", "jpaNonstandardFunctionName", "genericFunction", 
			"genericFunctionName", "genericFunctionArguments", "collectionSizeFunction", 
			"indexAggregateFunction", "elementAggregateFunction", "collectionFunctionMisuse", 
			"aggregateFunction", "everyFunction", "anyFunction", "listaggFunction", 
			"onOverflowClause", "withinGroupClause", "filterClause", "nullsClause", 
			"nthSideClause", "overClause", "partitionClause", "frameClause", "frameStart", 
			"frameEnd", "frameExclusion", "standardFunction", "castFunction", "castTarget", 
			"castTargetType", "substringFunction", "substringFunctionStartArgument", 
			"substringFunctionLengthArgument", "trimFunction", "trimSpecification", 
			"trimCharacter", "padFunction", "padSpecification", "padCharacter", "padLength", 
			"overlayFunction", "overlayFunctionStringArgument", "overlayFunctionReplacementArgument", 
			"overlayFunctionStartArgument", "overlayFunctionLengthArgument", "currentDateFunction", 
			"currentTimeFunction", "currentTimestampFunction", "instantFunction", 
			"localDateTimeFunction", "offsetDateTimeFunction", "localDateFunction", 
			"localTimeFunction", "formatFunction", "format", "extractFunction", "truncFunction", 
			"extractField", "datetimeField", "dayField", "weekField", "timeZoneField", 
			"dateOrTimeField", "positionFunction", "positionFunctionPatternArgument", 
			"positionFunctionStringArgument", "cube", "rollup", "nakedIdentifier", 
			"identifier"
		};
	}
	public static final String[] ruleNames = makeRuleNames();

	private static String[] makeLiteralNames() {
		return new String[] {
			null, null, null, null, null, null, null, null, null, null, null, null, 
			null, "'{ts'", "'{d'", "'{t'", "'='", null, "'>'", "'>='", "'<'", "'<='", 
			"','", "'.'", "'('", "')'", "'['", "']'", "'{'", "'}'", "'+'", "'-'", 
			"'*'", "'/'", "'%'", "'&'", "';'", "':'", "'|'", "'||'", "'?'", "'->'"
		};
	}
	private static final String[] _LITERAL_NAMES = makeLiteralNames();
	private static String[] makeSymbolicNames() {
		return new String[] {
			null, "WS", "COMMENT", "INTEGER_LITERAL", "LONG_LITERAL", "FLOAT_LITERAL", 
			"DOUBLE_LITERAL", "BIG_INTEGER_LITERAL", "BIG_DECIMAL_LITERAL", "HEX_LITERAL", 
			"STRING_LITERAL", "JAVA_STRING_LITERAL", "BINARY_LITERAL", "TIMESTAMP_ESCAPE_START", 
			"DATE_ESCAPE_START", "TIME_ESCAPE_START", "EQUAL", "NOT_EQUAL", "GREATER", 
			"GREATER_EQUAL", "LESS", "LESS_EQUAL", "COMMA", "DOT", "LEFT_PAREN", 
			"RIGHT_PAREN", "LEFT_BRACKET", "RIGHT_BRACKET", "LEFT_BRACE", "RIGHT_BRACE", 
			"PLUS", "MINUS", "ASTERISK", "SLASH", "PERCENT_OP", "AMPERSAND", "SEMICOLON", 
			"COLON", "PIPE", "DOUBLE_PIPE", "QUESTION_MARK", "ARROW", "ID", "VERSION", 
			"VERSIONED", "NATURALID", "FK", "ALL", "AND", "ANY", "AS", "ASC", "AVG", 
			"BETWEEN", "BOTH", "BREADTH", "BY", "CASE", "CAST", "COLLATE", "COUNT", 
			"CROSS", "CUBE", "CURRENT", "CURRENT_DATE", "CURRENT_INSTANT", "CURRENT_TIME", 
			"CURRENT_TIMESTAMP", "CYCLE", "DATE", "DATETIME", "DAY", "DEFAULT", "DELETE", 
			"DEPTH", "DESC", "DISTINCT", "ELEMENT", "ELEMENTS", "ELSE", "EMPTY", 
			"END", "ENTRY", "EPOCH", "ERROR", "ESCAPE", "EVERY", "EXCEPT", "EXCLUDE", 
			"EXISTS", "EXTRACT", "FETCH", "FILTER", "FIRST", "FOLLOWING", "FOR", 
			"FORMAT", "FROM", "FULL", "FUNCTION", "GROUP", "GROUPS", "HAVING", "HOUR", 
			"IGNORE", "ILIKE", "IN", "INDEX", "INDICES", "INNER", "INSERT", "INSTANT", 
			"INTERSECT", "INTO", "IS", "JOIN", "KEY", "LAST", "LATERAL", "LEADING", 
			"LEFT", "LIKE", "LIMIT", "LIST", "LISTAGG", "LOCAL", "LOCAL_DATE", "LOCAL_DATETIME", 
			"LOCAL_TIME", "MAP", "MATERIALIZED", "MAX", "MAXELEMENT", "MAXINDEX", 
			"MEMBER", "MICROSECOND", "MILLISECOND", "MIN", "MINELEMENT", "MININDEX", 
			"MINUTE", "MONTH", "NANOSECOND", "NEW", "NEXT", "NO", "NOT", "NULLS", 
			"OBJECT", "OF", "OFFSET", "OFFSET_DATETIME", "ON", "ONLY", "OR", "ORDER", 
			"OTHERS", "OUTER", "OVER", "OVERFLOW", "OVERLAY", "PAD", "PARTITION", 
			"PERCENT", "PLACING", "POSITION", "PRECEDING", "QUARTER", "RANGE", "RESPECT", 
			"RIGHT", "ROLLUP", "ROW", "ROWS", "SEARCH", "SECOND", "SELECT", "SET", 
			"SIZE", "SOME", "SUBSTRING", "SUM", "THEN", "TIES", "TIME", "TIMESTAMP", 
			"TIMEZONE_HOUR", "TIMEZONE_MINUTE", "TO", "TRAILING", "TREAT", "TRIM", 
			"TRUNC", "TRUNCATE", "TYPE", "UNBOUNDED", "UNION", "UPDATE", "USING", 
			"VALUE", "VALUES", "WEEK", "WHEN", "WHERE", "WITH", "WITHIN", "WITHOUT", 
			"YEAR", "ZONED", "TRUE", "FALSE", "NULL", "IDENTIFIER", "QUOTED_IDENTIFIER"
		};
	}
	private static final String[] _SYMBOLIC_NAMES = makeSymbolicNames();
	public static final Vocabulary VOCABULARY = new VocabularyImpl(_LITERAL_NAMES, _SYMBOLIC_NAMES);

	/**
	 * @deprecated Use {@link #VOCABULARY} instead.
	 */
	@Deprecated
	public static final String[] tokenNames;
	static {
		tokenNames = new String[_SYMBOLIC_NAMES.length];
		for (int i = 0; i < tokenNames.length; i++) {
			tokenNames[i] = VOCABULARY.getLiteralName(i);
			if (tokenNames[i] == null) {
				tokenNames[i] = VOCABULARY.getSymbolicName(i);
			}

			if (tokenNames[i] == null) {
				tokenNames[i] = "<INVALID>";
			}
		}
	}

	@Override
	@Deprecated
	public String[] getTokenNames() {
		return tokenNames;
	}

	@Override

	public Vocabulary getVocabulary() {
		return VOCABULARY;
	}

	@Override
	public String getGrammarFileName() { return "HqlParser.g4"; }

	@Override
	public String[] getRuleNames() { return ruleNames; }

	@Override
	public String getSerializedATN() { return _serializedATN; }

	@Override
	public ATN getATN() { return _ATN; }


		protected void logUseOfReservedWordAsIdentifier(Token token) {
		}

	public HqlParser(TokenStream input) {
		super(input);
		_interp = new ParserATNSimulator(this,_ATN,_decisionToDFA,_sharedContextCache);
	}

	public static class StatementContext extends ParserRuleContext {
		public TerminalNode EOF() { return getToken(HqlParser.EOF, 0); }
		public SelectStatementContext selectStatement() {
			return getRuleContext(SelectStatementContext.class,0);
		}
		public UpdateStatementContext updateStatement() {
			return getRuleContext(UpdateStatementContext.class,0);
		}
		public DeleteStatementContext deleteStatement() {
			return getRuleContext(DeleteStatementContext.class,0);
		}
		public InsertStatementContext insertStatement() {
			return getRuleContext(InsertStatementContext.class,0);
		}
		public StatementContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_statement; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterStatement(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitStatement(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitStatement(this);
			else return visitor.visitChildren(this);
		}
	}

	public final StatementContext statement() throws RecognitionException {
		StatementContext _localctx = new StatementContext(_ctx, getState());
		enterRule(_localctx, 0, RULE_statement);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(400);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case LEFT_PAREN:
			case FROM:
			case SELECT:
			case WITH:
				{
				setState(396);
				selectStatement();
				}
				break;
			case UPDATE:
				{
				setState(397);
				updateStatement();
				}
				break;
			case DELETE:
				{
				setState(398);
				deleteStatement();
				}
				break;
			case INSERT:
				{
				setState(399);
				insertStatement();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
			setState(402);
			match(EOF);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SelectStatementContext extends ParserRuleContext {
		public QueryExpressionContext queryExpression() {
			return getRuleContext(QueryExpressionContext.class,0);
		}
		public SelectStatementContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_selectStatement; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSelectStatement(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSelectStatement(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSelectStatement(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SelectStatementContext selectStatement() throws RecognitionException {
		SelectStatementContext _localctx = new SelectStatementContext(_ctx, getState());
		enterRule(_localctx, 2, RULE_selectStatement);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(404);
			queryExpression();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SubqueryContext extends ParserRuleContext {
		public QueryExpressionContext queryExpression() {
			return getRuleContext(QueryExpressionContext.class,0);
		}
		public SubqueryContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_subquery; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSubquery(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSubquery(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSubquery(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SubqueryContext subquery() throws RecognitionException {
		SubqueryContext _localctx = new SubqueryContext(_ctx, getState());
		enterRule(_localctx, 4, RULE_subquery);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(406);
			queryExpression();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class TargetEntityContext extends ParserRuleContext {
		public EntityNameContext entityName() {
			return getRuleContext(EntityNameContext.class,0);
		}
		public VariableContext variable() {
			return getRuleContext(VariableContext.class,0);
		}
		public TargetEntityContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_targetEntity; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterTargetEntity(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitTargetEntity(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitTargetEntity(this);
			else return visitor.visitChildren(this);
		}
	}

	public final TargetEntityContext targetEntity() throws RecognitionException {
		TargetEntityContext _localctx = new TargetEntityContext(_ctx, getState());
		enterRule(_localctx, 6, RULE_targetEntity);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(408);
			entityName();
			setState(410);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,1,_ctx) ) {
			case 1:
				{
				setState(409);
				variable();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class DeleteStatementContext extends ParserRuleContext {
		public TerminalNode DELETE() { return getToken(HqlParser.DELETE, 0); }
		public TargetEntityContext targetEntity() {
			return getRuleContext(TargetEntityContext.class,0);
		}
		public TerminalNode FROM() { return getToken(HqlParser.FROM, 0); }
		public WhereClauseContext whereClause() {
			return getRuleContext(WhereClauseContext.class,0);
		}
		public DeleteStatementContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_deleteStatement; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterDeleteStatement(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitDeleteStatement(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitDeleteStatement(this);
			else return visitor.visitChildren(this);
		}
	}

	public final DeleteStatementContext deleteStatement() throws RecognitionException {
		DeleteStatementContext _localctx = new DeleteStatementContext(_ctx, getState());
		enterRule(_localctx, 8, RULE_deleteStatement);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(412);
			match(DELETE);
			setState(414);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,2,_ctx) ) {
			case 1:
				{
				setState(413);
				match(FROM);
				}
				break;
			}
			setState(416);
			targetEntity();
			setState(418);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==WHERE) {
				{
				setState(417);
				whereClause();
				}
			}

			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class UpdateStatementContext extends ParserRuleContext {
		public TerminalNode UPDATE() { return getToken(HqlParser.UPDATE, 0); }
		public TargetEntityContext targetEntity() {
			return getRuleContext(TargetEntityContext.class,0);
		}
		public SetClauseContext setClause() {
			return getRuleContext(SetClauseContext.class,0);
		}
		public TerminalNode VERSIONED() { return getToken(HqlParser.VERSIONED, 0); }
		public WhereClauseContext whereClause() {
			return getRuleContext(WhereClauseContext.class,0);
		}
		public UpdateStatementContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_updateStatement; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterUpdateStatement(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitUpdateStatement(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitUpdateStatement(this);
			else return visitor.visitChildren(this);
		}
	}

	public final UpdateStatementContext updateStatement() throws RecognitionException {
		UpdateStatementContext _localctx = new UpdateStatementContext(_ctx, getState());
		enterRule(_localctx, 10, RULE_updateStatement);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(420);
			match(UPDATE);
			setState(422);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,4,_ctx) ) {
			case 1:
				{
				setState(421);
				match(VERSIONED);
				}
				break;
			}
			setState(424);
			targetEntity();
			setState(425);
			setClause();
			setState(427);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==WHERE) {
				{
				setState(426);
				whereClause();
				}
			}

			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SetClauseContext extends ParserRuleContext {
		public TerminalNode SET() { return getToken(HqlParser.SET, 0); }
		public List<AssignmentContext> assignment() {
			return getRuleContexts(AssignmentContext.class);
		}
		public AssignmentContext assignment(int i) {
			return getRuleContext(AssignmentContext.class,i);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public SetClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_setClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSetClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSetClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSetClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SetClauseContext setClause() throws RecognitionException {
		SetClauseContext _localctx = new SetClauseContext(_ctx, getState());
		enterRule(_localctx, 12, RULE_setClause);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(429);
			match(SET);
			setState(430);
			assignment();
			setState(435);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(431);
				match(COMMA);
				setState(432);
				assignment();
				}
				}
				setState(437);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class AssignmentContext extends ParserRuleContext {
		public SimplePathContext simplePath() {
			return getRuleContext(SimplePathContext.class,0);
		}
		public TerminalNode EQUAL() { return getToken(HqlParser.EQUAL, 0); }
		public ExpressionOrPredicateContext expressionOrPredicate() {
			return getRuleContext(ExpressionOrPredicateContext.class,0);
		}
		public AssignmentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_assignment; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterAssignment(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitAssignment(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitAssignment(this);
			else return visitor.visitChildren(this);
		}
	}

	public final AssignmentContext assignment() throws RecognitionException {
		AssignmentContext _localctx = new AssignmentContext(_ctx, getState());
		enterRule(_localctx, 14, RULE_assignment);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(438);
			simplePath();
			setState(439);
			match(EQUAL);
			setState(440);
			expressionOrPredicate();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class InsertStatementContext extends ParserRuleContext {
		public TerminalNode INSERT() { return getToken(HqlParser.INSERT, 0); }
		public TargetEntityContext targetEntity() {
			return getRuleContext(TargetEntityContext.class,0);
		}
		public TargetFieldsContext targetFields() {
			return getRuleContext(TargetFieldsContext.class,0);
		}
		public QueryExpressionContext queryExpression() {
			return getRuleContext(QueryExpressionContext.class,0);
		}
		public ValuesListContext valuesList() {
			return getRuleContext(ValuesListContext.class,0);
		}
		public TerminalNode INTO() { return getToken(HqlParser.INTO, 0); }
		public InsertStatementContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_insertStatement; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterInsertStatement(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitInsertStatement(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitInsertStatement(this);
			else return visitor.visitChildren(this);
		}
	}

	public final InsertStatementContext insertStatement() throws RecognitionException {
		InsertStatementContext _localctx = new InsertStatementContext(_ctx, getState());
		enterRule(_localctx, 16, RULE_insertStatement);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(442);
			match(INSERT);
			setState(444);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,7,_ctx) ) {
			case 1:
				{
				setState(443);
				match(INTO);
				}
				break;
			}
			setState(446);
			targetEntity();
			setState(447);
			targetFields();
			setState(450);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case LEFT_PAREN:
			case FROM:
			case SELECT:
			case WITH:
				{
				setState(448);
				queryExpression();
				}
				break;
			case VALUES:
				{
				setState(449);
				valuesList();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class TargetFieldsContext extends ParserRuleContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public List<SimplePathContext> simplePath() {
			return getRuleContexts(SimplePathContext.class);
		}
		public SimplePathContext simplePath(int i) {
			return getRuleContext(SimplePathContext.class,i);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public TargetFieldsContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_targetFields; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterTargetFields(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitTargetFields(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitTargetFields(this);
			else return visitor.visitChildren(this);
		}
	}

	public final TargetFieldsContext targetFields() throws RecognitionException {
		TargetFieldsContext _localctx = new TargetFieldsContext(_ctx, getState());
		enterRule(_localctx, 18, RULE_targetFields);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(452);
			match(LEFT_PAREN);
			setState(453);
			simplePath();
			setState(458);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(454);
				match(COMMA);
				setState(455);
				simplePath();
				}
				}
				setState(460);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			setState(461);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class ValuesListContext extends ParserRuleContext {
		public TerminalNode VALUES() { return getToken(HqlParser.VALUES, 0); }
		public List<ValuesContext> values() {
			return getRuleContexts(ValuesContext.class);
		}
		public ValuesContext values(int i) {
			return getRuleContext(ValuesContext.class,i);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public ValuesListContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_valuesList; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterValuesList(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitValuesList(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitValuesList(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ValuesListContext valuesList() throws RecognitionException {
		ValuesListContext _localctx = new ValuesListContext(_ctx, getState());
		enterRule(_localctx, 20, RULE_valuesList);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(463);
			match(VALUES);
			setState(464);
			values();
			setState(469);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(465);
				match(COMMA);
				setState(466);
				values();
				}
				}
				setState(471);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class ValuesContext extends ParserRuleContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public List<ExpressionOrPredicateContext> expressionOrPredicate() {
			return getRuleContexts(ExpressionOrPredicateContext.class);
		}
		public ExpressionOrPredicateContext expressionOrPredicate(int i) {
			return getRuleContext(ExpressionOrPredicateContext.class,i);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public ValuesContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_values; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterValues(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitValues(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitValues(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ValuesContext values() throws RecognitionException {
		ValuesContext _localctx = new ValuesContext(_ctx, getState());
		enterRule(_localctx, 22, RULE_values);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(472);
			match(LEFT_PAREN);
			setState(473);
			expressionOrPredicate();
			setState(478);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(474);
				match(COMMA);
				setState(475);
				expressionOrPredicate();
				}
				}
				setState(480);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			setState(481);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class WithClauseContext extends ParserRuleContext {
		public TerminalNode WITH() { return getToken(HqlParser.WITH, 0); }
		public List<CteContext> cte() {
			return getRuleContexts(CteContext.class);
		}
		public CteContext cte(int i) {
			return getRuleContext(CteContext.class,i);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public WithClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_withClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterWithClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitWithClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitWithClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final WithClauseContext withClause() throws RecognitionException {
		WithClauseContext _localctx = new WithClauseContext(_ctx, getState());
		enterRule(_localctx, 24, RULE_withClause);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(483);
			match(WITH);
			setState(484);
			cte();
			setState(489);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(485);
				match(COMMA);
				setState(486);
				cte();
				}
				}
				setState(491);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class CteContext extends ParserRuleContext {
		public IdentifierContext identifier() {
			return getRuleContext(IdentifierContext.class,0);
		}
		public TerminalNode AS() { return getToken(HqlParser.AS, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public QueryExpressionContext queryExpression() {
			return getRuleContext(QueryExpressionContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode MATERIALIZED() { return getToken(HqlParser.MATERIALIZED, 0); }
		public SearchClauseContext searchClause() {
			return getRuleContext(SearchClauseContext.class,0);
		}
		public CycleClauseContext cycleClause() {
			return getRuleContext(CycleClauseContext.class,0);
		}
		public TerminalNode NOT() { return getToken(HqlParser.NOT, 0); }
		public CteContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_cte; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCte(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCte(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCte(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CteContext cte() throws RecognitionException {
		CteContext _localctx = new CteContext(_ctx, getState());
		enterRule(_localctx, 26, RULE_cte);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(492);
			identifier();
			setState(493);
			match(AS);
			setState(498);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==MATERIALIZED || _la==NOT) {
				{
				setState(495);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==NOT) {
					{
					setState(494);
					match(NOT);
					}
				}

				setState(497);
				match(MATERIALIZED);
				}
			}

			setState(500);
			match(LEFT_PAREN);
			setState(501);
			queryExpression();
			setState(502);
			match(RIGHT_PAREN);
			setState(504);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==SEARCH) {
				{
				setState(503);
				searchClause();
				}
			}

			setState(507);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==CYCLE) {
				{
				setState(506);
				cycleClause();
				}
			}

			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class CteAttributesContext extends ParserRuleContext {
		public List<IdentifierContext> identifier() {
			return getRuleContexts(IdentifierContext.class);
		}
		public IdentifierContext identifier(int i) {
			return getRuleContext(IdentifierContext.class,i);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public CteAttributesContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_cteAttributes; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCteAttributes(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCteAttributes(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCteAttributes(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CteAttributesContext cteAttributes() throws RecognitionException {
		CteAttributesContext _localctx = new CteAttributesContext(_ctx, getState());
		enterRule(_localctx, 28, RULE_cteAttributes);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(509);
			identifier();
			setState(514);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(510);
				match(COMMA);
				setState(511);
				identifier();
				}
				}
				setState(516);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SearchClauseContext extends ParserRuleContext {
		public TerminalNode SEARCH() { return getToken(HqlParser.SEARCH, 0); }
		public TerminalNode FIRST() { return getToken(HqlParser.FIRST, 0); }
		public TerminalNode BY() { return getToken(HqlParser.BY, 0); }
		public SearchSpecificationsContext searchSpecifications() {
			return getRuleContext(SearchSpecificationsContext.class,0);
		}
		public TerminalNode SET() { return getToken(HqlParser.SET, 0); }
		public IdentifierContext identifier() {
			return getRuleContext(IdentifierContext.class,0);
		}
		public TerminalNode BREADTH() { return getToken(HqlParser.BREADTH, 0); }
		public TerminalNode DEPTH() { return getToken(HqlParser.DEPTH, 0); }
		public SearchClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_searchClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSearchClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSearchClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSearchClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SearchClauseContext searchClause() throws RecognitionException {
		SearchClauseContext _localctx = new SearchClauseContext(_ctx, getState());
		enterRule(_localctx, 30, RULE_searchClause);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(517);
			match(SEARCH);
			setState(518);
			_la = _input.LA(1);
			if ( !(_la==BREADTH || _la==DEPTH) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			setState(519);
			match(FIRST);
			setState(520);
			match(BY);
			setState(521);
			searchSpecifications();
			setState(522);
			match(SET);
			setState(523);
			identifier();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SearchSpecificationsContext extends ParserRuleContext {
		public List<SearchSpecificationContext> searchSpecification() {
			return getRuleContexts(SearchSpecificationContext.class);
		}
		public SearchSpecificationContext searchSpecification(int i) {
			return getRuleContext(SearchSpecificationContext.class,i);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public SearchSpecificationsContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_searchSpecifications; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSearchSpecifications(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSearchSpecifications(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSearchSpecifications(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SearchSpecificationsContext searchSpecifications() throws RecognitionException {
		SearchSpecificationsContext _localctx = new SearchSpecificationsContext(_ctx, getState());
		enterRule(_localctx, 32, RULE_searchSpecifications);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(525);
			searchSpecification();
			setState(530);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(526);
				match(COMMA);
				setState(527);
				searchSpecification();
				}
				}
				setState(532);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SearchSpecificationContext extends ParserRuleContext {
		public IdentifierContext identifier() {
			return getRuleContext(IdentifierContext.class,0);
		}
		public SortDirectionContext sortDirection() {
			return getRuleContext(SortDirectionContext.class,0);
		}
		public NullsPrecedenceContext nullsPrecedence() {
			return getRuleContext(NullsPrecedenceContext.class,0);
		}
		public SearchSpecificationContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_searchSpecification; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSearchSpecification(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSearchSpecification(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSearchSpecification(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SearchSpecificationContext searchSpecification() throws RecognitionException {
		SearchSpecificationContext _localctx = new SearchSpecificationContext(_ctx, getState());
		enterRule(_localctx, 34, RULE_searchSpecification);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(533);
			identifier();
			setState(535);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==ASC || _la==DESC) {
				{
				setState(534);
				sortDirection();
				}
			}

			setState(538);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==NULLS) {
				{
				setState(537);
				nullsPrecedence();
				}
			}

			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class CycleClauseContext extends ParserRuleContext {
		public TerminalNode CYCLE() { return getToken(HqlParser.CYCLE, 0); }
		public CteAttributesContext cteAttributes() {
			return getRuleContext(CteAttributesContext.class,0);
		}
		public TerminalNode SET() { return getToken(HqlParser.SET, 0); }
		public List<IdentifierContext> identifier() {
			return getRuleContexts(IdentifierContext.class);
		}
		public IdentifierContext identifier(int i) {
			return getRuleContext(IdentifierContext.class,i);
		}
		public TerminalNode TO() { return getToken(HqlParser.TO, 0); }
		public List<LiteralContext> literal() {
			return getRuleContexts(LiteralContext.class);
		}
		public LiteralContext literal(int i) {
			return getRuleContext(LiteralContext.class,i);
		}
		public TerminalNode DEFAULT() { return getToken(HqlParser.DEFAULT, 0); }
		public TerminalNode USING() { return getToken(HqlParser.USING, 0); }
		public CycleClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_cycleClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCycleClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCycleClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCycleClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CycleClauseContext cycleClause() throws RecognitionException {
		CycleClauseContext _localctx = new CycleClauseContext(_ctx, getState());
		enterRule(_localctx, 36, RULE_cycleClause);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(540);
			match(CYCLE);
			setState(541);
			cteAttributes();
			setState(542);
			match(SET);
			setState(543);
			identifier();
			setState(549);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==TO) {
				{
				setState(544);
				match(TO);
				setState(545);
				literal();
				setState(546);
				match(DEFAULT);
				setState(547);
				literal();
				}
			}

			setState(553);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==USING) {
				{
				setState(551);
				match(USING);
				setState(552);
				identifier();
				}
			}

			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class QueryExpressionContext extends ParserRuleContext {
		public QueryExpressionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_queryExpression; }
	 
		public QueryExpressionContext() { }
		public void copyFrom(QueryExpressionContext ctx) {
			super.copyFrom(ctx);
		}
	}
	public static class SetQueryGroupContext extends QueryExpressionContext {
		public List<OrderedQueryContext> orderedQuery() {
			return getRuleContexts(OrderedQueryContext.class);
		}
		public OrderedQueryContext orderedQuery(int i) {
			return getRuleContext(OrderedQueryContext.class,i);
		}
		public WithClauseContext withClause() {
			return getRuleContext(WithClauseContext.class,0);
		}
		public List<SetOperatorContext> setOperator() {
			return getRuleContexts(SetOperatorContext.class);
		}
		public SetOperatorContext setOperator(int i) {
			return getRuleContext(SetOperatorContext.class,i);
		}
		public SetQueryGroupContext(QueryExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSetQueryGroup(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSetQueryGroup(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSetQueryGroup(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class SimpleQueryGroupContext extends QueryExpressionContext {
		public OrderedQueryContext orderedQuery() {
			return getRuleContext(OrderedQueryContext.class,0);
		}
		public WithClauseContext withClause() {
			return getRuleContext(WithClauseContext.class,0);
		}
		public SimpleQueryGroupContext(QueryExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSimpleQueryGroup(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSimpleQueryGroup(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSimpleQueryGroup(this);
			else return visitor.visitChildren(this);
		}
	}

	public final QueryExpressionContext queryExpression() throws RecognitionException {
		QueryExpressionContext _localctx = new QueryExpressionContext(_ctx, getState());
		enterRule(_localctx, 38, RULE_queryExpression);
		int _la;
		try {
			setState(570);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,26,_ctx) ) {
			case 1:
				_localctx = new SimpleQueryGroupContext(_localctx);
				enterOuterAlt(_localctx, 1);
				{
				setState(556);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==WITH) {
					{
					setState(555);
					withClause();
					}
				}

				setState(558);
				orderedQuery();
				}
				break;
			case 2:
				_localctx = new SetQueryGroupContext(_localctx);
				enterOuterAlt(_localctx, 2);
				{
				setState(560);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==WITH) {
					{
					setState(559);
					withClause();
					}
				}

				setState(562);
				orderedQuery();
				setState(566); 
				_errHandler.sync(this);
				_la = _input.LA(1);
				do {
					{
					{
					setState(563);
					setOperator();
					setState(564);
					orderedQuery();
					}
					}
					setState(568); 
					_errHandler.sync(this);
					_la = _input.LA(1);
				} while ( _la==EXCEPT || _la==INTERSECT || _la==UNION );
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class OrderedQueryContext extends ParserRuleContext {
		public OrderedQueryContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_orderedQuery; }
	 
		public OrderedQueryContext() { }
		public void copyFrom(OrderedQueryContext ctx) {
			super.copyFrom(ctx);
		}
	}
	public static class QuerySpecExpressionContext extends OrderedQueryContext {
		public QueryContext query() {
			return getRuleContext(QueryContext.class,0);
		}
		public QueryOrderContext queryOrder() {
			return getRuleContext(QueryOrderContext.class,0);
		}
		public QuerySpecExpressionContext(OrderedQueryContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterQuerySpecExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitQuerySpecExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitQuerySpecExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class NestedQueryExpressionContext extends OrderedQueryContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public QueryExpressionContext queryExpression() {
			return getRuleContext(QueryExpressionContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public QueryOrderContext queryOrder() {
			return getRuleContext(QueryOrderContext.class,0);
		}
		public NestedQueryExpressionContext(OrderedQueryContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterNestedQueryExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitNestedQueryExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitNestedQueryExpression(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OrderedQueryContext orderedQuery() throws RecognitionException {
		OrderedQueryContext _localctx = new OrderedQueryContext(_ctx, getState());
		enterRule(_localctx, 40, RULE_orderedQuery);
		int _la;
		try {
			setState(582);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case FROM:
			case SELECT:
				_localctx = new QuerySpecExpressionContext(_localctx);
				enterOuterAlt(_localctx, 1);
				{
				setState(572);
				query();
				setState(574);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==ORDER) {
					{
					setState(573);
					queryOrder();
					}
				}

				}
				break;
			case LEFT_PAREN:
				_localctx = new NestedQueryExpressionContext(_localctx);
				enterOuterAlt(_localctx, 2);
				{
				setState(576);
				match(LEFT_PAREN);
				setState(577);
				queryExpression();
				setState(578);
				match(RIGHT_PAREN);
				setState(580);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==ORDER) {
					{
					setState(579);
					queryOrder();
					}
				}

				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SetOperatorContext extends ParserRuleContext {
		public TerminalNode UNION() { return getToken(HqlParser.UNION, 0); }
		public TerminalNode ALL() { return getToken(HqlParser.ALL, 0); }
		public TerminalNode INTERSECT() { return getToken(HqlParser.INTERSECT, 0); }
		public TerminalNode EXCEPT() { return getToken(HqlParser.EXCEPT, 0); }
		public SetOperatorContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_setOperator; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSetOperator(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSetOperator(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSetOperator(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SetOperatorContext setOperator() throws RecognitionException {
		SetOperatorContext _localctx = new SetOperatorContext(_ctx, getState());
		enterRule(_localctx, 42, RULE_setOperator);
		int _la;
		try {
			setState(596);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case UNION:
				enterOuterAlt(_localctx, 1);
				{
				setState(584);
				match(UNION);
				setState(586);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==ALL) {
					{
					setState(585);
					match(ALL);
					}
				}

				}
				break;
			case INTERSECT:
				enterOuterAlt(_localctx, 2);
				{
				setState(588);
				match(INTERSECT);
				setState(590);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==ALL) {
					{
					setState(589);
					match(ALL);
					}
				}

				}
				break;
			case EXCEPT:
				enterOuterAlt(_localctx, 3);
				{
				setState(592);
				match(EXCEPT);
				setState(594);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==ALL) {
					{
					setState(593);
					match(ALL);
					}
				}

				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class QueryOrderContext extends ParserRuleContext {
		public OrderByClauseContext orderByClause() {
			return getRuleContext(OrderByClauseContext.class,0);
		}
		public LimitClauseContext limitClause() {
			return getRuleContext(LimitClauseContext.class,0);
		}
		public OffsetClauseContext offsetClause() {
			return getRuleContext(OffsetClauseContext.class,0);
		}
		public FetchClauseContext fetchClause() {
			return getRuleContext(FetchClauseContext.class,0);
		}
		public QueryOrderContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_queryOrder; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterQueryOrder(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitQueryOrder(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitQueryOrder(this);
			else return visitor.visitChildren(this);
		}
	}

	public final QueryOrderContext queryOrder() throws RecognitionException {
		QueryOrderContext _localctx = new QueryOrderContext(_ctx, getState());
		enterRule(_localctx, 44, RULE_queryOrder);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(598);
			orderByClause();
			setState(600);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==LIMIT) {
				{
				setState(599);
				limitClause();
				}
			}

			setState(603);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==OFFSET) {
				{
				setState(602);
				offsetClause();
				}
			}

			setState(606);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==FETCH) {
				{
				setState(605);
				fetchClause();
				}
			}

			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class QueryContext extends ParserRuleContext {
		public SelectClauseContext selectClause() {
			return getRuleContext(SelectClauseContext.class,0);
		}
		public FromClauseContext fromClause() {
			return getRuleContext(FromClauseContext.class,0);
		}
		public WhereClauseContext whereClause() {
			return getRuleContext(WhereClauseContext.class,0);
		}
		public GroupByClauseContext groupByClause() {
			return getRuleContext(GroupByClauseContext.class,0);
		}
		public HavingClauseContext havingClause() {
			return getRuleContext(HavingClauseContext.class,0);
		}
		public QueryContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_query; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterQuery(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitQuery(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitQuery(this);
			else return visitor.visitChildren(this);
		}
	}

	public final QueryContext query() throws RecognitionException {
		QueryContext _localctx = new QueryContext(_ctx, getState());
		enterRule(_localctx, 46, RULE_query);
		int _la;
		try {
			setState(634);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case SELECT:
				enterOuterAlt(_localctx, 1);
				{
				setState(608);
				selectClause();
				setState(610);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==FROM) {
					{
					setState(609);
					fromClause();
					}
				}

				setState(613);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==WHERE) {
					{
					setState(612);
					whereClause();
					}
				}

				setState(619);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==GROUP) {
					{
					setState(615);
					groupByClause();
					setState(617);
					_errHandler.sync(this);
					_la = _input.LA(1);
					if (_la==HAVING) {
						{
						setState(616);
						havingClause();
						}
					}

					}
				}

				}
				break;
			case FROM:
				enterOuterAlt(_localctx, 2);
				{
				setState(621);
				fromClause();
				setState(623);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==WHERE) {
					{
					setState(622);
					whereClause();
					}
				}

				setState(629);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==GROUP) {
					{
					setState(625);
					groupByClause();
					setState(627);
					_errHandler.sync(this);
					_la = _input.LA(1);
					if (_la==HAVING) {
						{
						setState(626);
						havingClause();
						}
					}

					}
				}

				setState(632);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==SELECT) {
					{
					setState(631);
					selectClause();
					}
				}

				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class FromClauseContext extends ParserRuleContext {
		public TerminalNode FROM() { return getToken(HqlParser.FROM, 0); }
		public List<EntityWithJoinsContext> entityWithJoins() {
			return getRuleContexts(EntityWithJoinsContext.class);
		}
		public EntityWithJoinsContext entityWithJoins(int i) {
			return getRuleContext(EntityWithJoinsContext.class,i);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public FromClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_fromClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterFromClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitFromClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitFromClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final FromClauseContext fromClause() throws RecognitionException {
		FromClauseContext _localctx = new FromClauseContext(_ctx, getState());
		enterRule(_localctx, 48, RULE_fromClause);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(636);
			match(FROM);
			setState(637);
			entityWithJoins();
			setState(642);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(638);
				match(COMMA);
				setState(639);
				entityWithJoins();
				}
				}
				setState(644);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class EntityWithJoinsContext extends ParserRuleContext {
		public FromRootContext fromRoot() {
			return getRuleContext(FromRootContext.class,0);
		}
		public List<JoinContext> join() {
			return getRuleContexts(JoinContext.class);
		}
		public JoinContext join(int i) {
			return getRuleContext(JoinContext.class,i);
		}
		public List<CrossJoinContext> crossJoin() {
			return getRuleContexts(CrossJoinContext.class);
		}
		public CrossJoinContext crossJoin(int i) {
			return getRuleContext(CrossJoinContext.class,i);
		}
		public List<JpaCollectionJoinContext> jpaCollectionJoin() {
			return getRuleContexts(JpaCollectionJoinContext.class);
		}
		public JpaCollectionJoinContext jpaCollectionJoin(int i) {
			return getRuleContext(JpaCollectionJoinContext.class,i);
		}
		public EntityWithJoinsContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_entityWithJoins; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterEntityWithJoins(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitEntityWithJoins(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitEntityWithJoins(this);
			else return visitor.visitChildren(this);
		}
	}

	public final EntityWithJoinsContext entityWithJoins() throws RecognitionException {
		EntityWithJoinsContext _localctx = new EntityWithJoinsContext(_ctx, getState());
		enterRule(_localctx, 50, RULE_entityWithJoins);
		try {
			int _alt;
			enterOuterAlt(_localctx, 1);
			{
			setState(645);
			fromRoot();
			setState(651);
			_errHandler.sync(this);
			_alt = getInterpreter().adaptivePredict(_input,48,_ctx);
			while ( _alt!=2 && _alt!=org.antlr.v4.runtime.atn.ATN.INVALID_ALT_NUMBER ) {
				if ( _alt==1 ) {
					{
					setState(649);
					_errHandler.sync(this);
					switch (_input.LA(1)) {
					case FULL:
					case INNER:
					case JOIN:
					case LEFT:
					case OUTER:
					case RIGHT:
						{
						setState(646);
						join();
						}
						break;
					case CROSS:
						{
						setState(647);
						crossJoin();
						}
						break;
					case COMMA:
						{
						setState(648);
						jpaCollectionJoin();
						}
						break;
					default:
						throw new NoViableAltException(this);
					}
					} 
				}
				setState(653);
				_errHandler.sync(this);
				_alt = getInterpreter().adaptivePredict(_input,48,_ctx);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class FromRootContext extends ParserRuleContext {
		public FromRootContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_fromRoot; }
	 
		public FromRootContext() { }
		public void copyFrom(FromRootContext ctx) {
			super.copyFrom(ctx);
		}
	}
	public static class RootSubqueryContext extends FromRootContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public SubqueryContext subquery() {
			return getRuleContext(SubqueryContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public VariableContext variable() {
			return getRuleContext(VariableContext.class,0);
		}
		public RootSubqueryContext(FromRootContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterRootSubquery(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitRootSubquery(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitRootSubquery(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class RootEntityContext extends FromRootContext {
		public EntityNameContext entityName() {
			return getRuleContext(EntityNameContext.class,0);
		}
		public VariableContext variable() {
			return getRuleContext(VariableContext.class,0);
		}
		public RootEntityContext(FromRootContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterRootEntity(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitRootEntity(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitRootEntity(this);
			else return visitor.visitChildren(this);
		}
	}

	public final FromRootContext fromRoot() throws RecognitionException {
		FromRootContext _localctx = new FromRootContext(_ctx, getState());
		enterRule(_localctx, 52, RULE_fromRoot);
		try {
			setState(664);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case ID:
			case VERSION:
			case VERSIONED:
			case NATURALID:
			case ALL:
			case AND:
			case ANY:
			case AS:
			case ASC:
			case AVG:
			case BETWEEN:
			case BOTH:
			case BREADTH:
			case BY:
			case CASE:
			case CAST:
			case COLLATE:
			case COUNT:
			case CROSS:
			case CUBE:
			case CURRENT:
			case CURRENT_DATE:
			case CURRENT_INSTANT:
			case CURRENT_TIME:
			case CURRENT_TIMESTAMP:
			case CYCLE:
			case DATE:
			case DATETIME:
			case DAY:
			case DEFAULT:
			case DELETE:
			case DEPTH:
			case DESC:
			case DISTINCT:
			case ELEMENT:
			case ELEMENTS:
			case ELSE:
			case EMPTY:
			case END:
			case ENTRY:
			case EPOCH:
			case ERROR:
			case ESCAPE:
			case EVERY:
			case EXCEPT:
			case EXCLUDE:
			case EXISTS:
			case EXTRACT:
			case FETCH:
			case FILTER:
			case FIRST:
			case FOLLOWING:
			case FOR:
			case FORMAT:
			case FROM:
			case FULL:
			case FUNCTION:
			case GROUP:
			case GROUPS:
			case HAVING:
			case HOUR:
			case IGNORE:
			case ILIKE:
			case IN:
			case INDEX:
			case INDICES:
			case INNER:
			case INSERT:
			case INSTANT:
			case INTERSECT:
			case INTO:
			case IS:
			case JOIN:
			case KEY:
			case LAST:
			case LEADING:
			case LEFT:
			case LIKE:
			case LIMIT:
			case LIST:
			case LISTAGG:
			case LOCAL:
			case LOCAL_DATE:
			case LOCAL_DATETIME:
			case LOCAL_TIME:
			case MAP:
			case MATERIALIZED:
			case MAX:
			case MAXELEMENT:
			case MAXINDEX:
			case MEMBER:
			case MICROSECOND:
			case MILLISECOND:
			case MIN:
			case MINELEMENT:
			case MININDEX:
			case MINUTE:
			case MONTH:
			case NANOSECOND:
			case NEW:
			case NEXT:
			case NO:
			case NOT:
			case NULLS:
			case OBJECT:
			case OF:
			case OFFSET:
			case OFFSET_DATETIME:
			case ON:
			case ONLY:
			case OR:
			case ORDER:
			case OTHERS:
			case OUTER:
			case OVER:
			case OVERFLOW:
			case OVERLAY:
			case PAD:
			case PARTITION:
			case PERCENT:
			case PLACING:
			case POSITION:
			case PRECEDING:
			case QUARTER:
			case RANGE:
			case RESPECT:
			case RIGHT:
			case ROLLUP:
			case ROW:
			case ROWS:
			case SEARCH:
			case SECOND:
			case SELECT:
			case SET:
			case SIZE:
			case SOME:
			case SUBSTRING:
			case SUM:
			case THEN:
			case TIES:
			case TIME:
			case TIMESTAMP:
			case TIMEZONE_HOUR:
			case TIMEZONE_MINUTE:
			case TO:
			case TRAILING:
			case TREAT:
			case TRIM:
			case TRUNC:
			case TRUNCATE:
			case TYPE:
			case UNBOUNDED:
			case UNION:
			case UPDATE:
			case USING:
			case VALUE:
			case VALUES:
			case WEEK:
			case WHEN:
			case WHERE:
			case WITH:
			case WITHIN:
			case WITHOUT:
			case YEAR:
			case IDENTIFIER:
			case QUOTED_IDENTIFIER:
				_localctx = new RootEntityContext(_localctx);
				enterOuterAlt(_localctx, 1);
				{
				setState(654);
				entityName();
				setState(656);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,49,_ctx) ) {
				case 1:
					{
					setState(655);
					variable();
					}
					break;
				}
				}
				break;
			case LEFT_PAREN:
				_localctx = new RootSubqueryContext(_localctx);
				enterOuterAlt(_localctx, 2);
				{
				setState(658);
				match(LEFT_PAREN);
				setState(659);
				subquery();
				setState(660);
				match(RIGHT_PAREN);
				setState(662);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,50,_ctx) ) {
				case 1:
					{
					setState(661);
					variable();
					}
					break;
				}
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class EntityNameContext extends ParserRuleContext {
		public List<IdentifierContext> identifier() {
			return getRuleContexts(IdentifierContext.class);
		}
		public IdentifierContext identifier(int i) {
			return getRuleContext(IdentifierContext.class,i);
		}
		public List<TerminalNode> DOT() { return getTokens(HqlParser.DOT); }
		public TerminalNode DOT(int i) {
			return getToken(HqlParser.DOT, i);
		}
		public EntityNameContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_entityName; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterEntityName(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitEntityName(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitEntityName(this);
			else return visitor.visitChildren(this);
		}
	}

	public final EntityNameContext entityName() throws RecognitionException {
		EntityNameContext _localctx = new EntityNameContext(_ctx, getState());
		enterRule(_localctx, 54, RULE_entityName);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(666);
			identifier();
			setState(671);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==DOT) {
				{
				{
				setState(667);
				match(DOT);
				setState(668);
				identifier();
				}
				}
				setState(673);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class VariableContext extends ParserRuleContext {
		public TerminalNode AS() { return getToken(HqlParser.AS, 0); }
		public IdentifierContext identifier() {
			return getRuleContext(IdentifierContext.class,0);
		}
		public NakedIdentifierContext nakedIdentifier() {
			return getRuleContext(NakedIdentifierContext.class,0);
		}
		public VariableContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_variable; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterVariable(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitVariable(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitVariable(this);
			else return visitor.visitChildren(this);
		}
	}

	public final VariableContext variable() throws RecognitionException {
		VariableContext _localctx = new VariableContext(_ctx, getState());
		enterRule(_localctx, 56, RULE_variable);
		try {
			setState(677);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,53,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(674);
				match(AS);
				setState(675);
				identifier();
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(676);
				nakedIdentifier();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class CrossJoinContext extends ParserRuleContext {
		public TerminalNode CROSS() { return getToken(HqlParser.CROSS, 0); }
		public TerminalNode JOIN() { return getToken(HqlParser.JOIN, 0); }
		public EntityNameContext entityName() {
			return getRuleContext(EntityNameContext.class,0);
		}
		public VariableContext variable() {
			return getRuleContext(VariableContext.class,0);
		}
		public CrossJoinContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_crossJoin; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCrossJoin(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCrossJoin(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCrossJoin(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CrossJoinContext crossJoin() throws RecognitionException {
		CrossJoinContext _localctx = new CrossJoinContext(_ctx, getState());
		enterRule(_localctx, 58, RULE_crossJoin);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(679);
			match(CROSS);
			setState(680);
			match(JOIN);
			setState(681);
			entityName();
			setState(683);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,54,_ctx) ) {
			case 1:
				{
				setState(682);
				variable();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class JpaCollectionJoinContext extends ParserRuleContext {
		public TerminalNode COMMA() { return getToken(HqlParser.COMMA, 0); }
		public TerminalNode IN() { return getToken(HqlParser.IN, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public VariableContext variable() {
			return getRuleContext(VariableContext.class,0);
		}
		public JpaCollectionJoinContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_jpaCollectionJoin; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterJpaCollectionJoin(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitJpaCollectionJoin(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitJpaCollectionJoin(this);
			else return visitor.visitChildren(this);
		}
	}

	public final JpaCollectionJoinContext jpaCollectionJoin() throws RecognitionException {
		JpaCollectionJoinContext _localctx = new JpaCollectionJoinContext(_ctx, getState());
		enterRule(_localctx, 60, RULE_jpaCollectionJoin);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(685);
			match(COMMA);
			setState(686);
			match(IN);
			setState(687);
			match(LEFT_PAREN);
			setState(688);
			path();
			setState(689);
			match(RIGHT_PAREN);
			setState(691);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,55,_ctx) ) {
			case 1:
				{
				setState(690);
				variable();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class JoinContext extends ParserRuleContext {
		public JoinTypeContext joinType() {
			return getRuleContext(JoinTypeContext.class,0);
		}
		public TerminalNode JOIN() { return getToken(HqlParser.JOIN, 0); }
		public JoinTargetContext joinTarget() {
			return getRuleContext(JoinTargetContext.class,0);
		}
		public TerminalNode FETCH() { return getToken(HqlParser.FETCH, 0); }
		public JoinRestrictionContext joinRestriction() {
			return getRuleContext(JoinRestrictionContext.class,0);
		}
		public JoinContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_join; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterJoin(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitJoin(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitJoin(this);
			else return visitor.visitChildren(this);
		}
	}

	public final JoinContext join() throws RecognitionException {
		JoinContext _localctx = new JoinContext(_ctx, getState());
		enterRule(_localctx, 62, RULE_join);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(693);
			joinType();
			setState(694);
			match(JOIN);
			setState(696);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,56,_ctx) ) {
			case 1:
				{
				setState(695);
				match(FETCH);
				}
				break;
			}
			setState(698);
			joinTarget();
			setState(700);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==ON || _la==WITH) {
				{
				setState(699);
				joinRestriction();
				}
			}

			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class JoinTypeContext extends ParserRuleContext {
		public TerminalNode INNER() { return getToken(HqlParser.INNER, 0); }
		public TerminalNode OUTER() { return getToken(HqlParser.OUTER, 0); }
		public TerminalNode LEFT() { return getToken(HqlParser.LEFT, 0); }
		public TerminalNode RIGHT() { return getToken(HqlParser.RIGHT, 0); }
		public TerminalNode FULL() { return getToken(HqlParser.FULL, 0); }
		public JoinTypeContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_joinType; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterJoinType(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitJoinType(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitJoinType(this);
			else return visitor.visitChildren(this);
		}
	}

	public final JoinTypeContext joinType() throws RecognitionException {
		JoinTypeContext _localctx = new JoinTypeContext(_ctx, getState());
		enterRule(_localctx, 64, RULE_joinType);
		int _la;
		try {
			setState(711);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,61,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(703);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==INNER) {
					{
					setState(702);
					match(INNER);
					}
				}

				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(706);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==FULL || _la==LEFT || _la==RIGHT) {
					{
					setState(705);
					_la = _input.LA(1);
					if ( !(_la==FULL || _la==LEFT || _la==RIGHT) ) {
					_errHandler.recoverInline(this);
					}
					else {
						if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
						_errHandler.reportMatch(this);
						consume();
					}
					}
				}

				setState(709);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==OUTER) {
					{
					setState(708);
					match(OUTER);
					}
				}

				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class JoinTargetContext extends ParserRuleContext {
		public JoinTargetContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_joinTarget; }
	 
		public JoinTargetContext() { }
		public void copyFrom(JoinTargetContext ctx) {
			super.copyFrom(ctx);
		}
	}
	public static class JoinPathContext extends JoinTargetContext {
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public VariableContext variable() {
			return getRuleContext(VariableContext.class,0);
		}
		public JoinPathContext(JoinTargetContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterJoinPath(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitJoinPath(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitJoinPath(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class JoinSubqueryContext extends JoinTargetContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public SubqueryContext subquery() {
			return getRuleContext(SubqueryContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode LATERAL() { return getToken(HqlParser.LATERAL, 0); }
		public VariableContext variable() {
			return getRuleContext(VariableContext.class,0);
		}
		public JoinSubqueryContext(JoinTargetContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterJoinSubquery(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitJoinSubquery(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitJoinSubquery(this);
			else return visitor.visitChildren(this);
		}
	}

	public final JoinTargetContext joinTarget() throws RecognitionException {
		JoinTargetContext _localctx = new JoinTargetContext(_ctx, getState());
		enterRule(_localctx, 66, RULE_joinTarget);
		int _la;
		try {
			setState(726);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case ID:
			case VERSION:
			case VERSIONED:
			case NATURALID:
			case ALL:
			case AND:
			case ANY:
			case AS:
			case ASC:
			case AVG:
			case BETWEEN:
			case BOTH:
			case BREADTH:
			case BY:
			case CASE:
			case CAST:
			case COLLATE:
			case COUNT:
			case CROSS:
			case CUBE:
			case CURRENT:
			case CURRENT_DATE:
			case CURRENT_INSTANT:
			case CURRENT_TIME:
			case CURRENT_TIMESTAMP:
			case CYCLE:
			case DATE:
			case DATETIME:
			case DAY:
			case DEFAULT:
			case DELETE:
			case DEPTH:
			case DESC:
			case DISTINCT:
			case ELEMENT:
			case ELEMENTS:
			case ELSE:
			case EMPTY:
			case END:
			case ENTRY:
			case EPOCH:
			case ERROR:
			case ESCAPE:
			case EVERY:
			case EXCEPT:
			case EXCLUDE:
			case EXISTS:
			case EXTRACT:
			case FETCH:
			case FILTER:
			case FIRST:
			case FOLLOWING:
			case FOR:
			case FORMAT:
			case FROM:
			case FULL:
			case FUNCTION:
			case GROUP:
			case GROUPS:
			case HAVING:
			case HOUR:
			case IGNORE:
			case ILIKE:
			case IN:
			case INDEX:
			case INDICES:
			case INNER:
			case INSERT:
			case INSTANT:
			case INTERSECT:
			case INTO:
			case IS:
			case JOIN:
			case KEY:
			case LAST:
			case LEADING:
			case LEFT:
			case LIKE:
			case LIMIT:
			case LIST:
			case LISTAGG:
			case LOCAL:
			case LOCAL_DATE:
			case LOCAL_DATETIME:
			case LOCAL_TIME:
			case MAP:
			case MATERIALIZED:
			case MAX:
			case MAXELEMENT:
			case MAXINDEX:
			case MEMBER:
			case MICROSECOND:
			case MILLISECOND:
			case MIN:
			case MINELEMENT:
			case MININDEX:
			case MINUTE:
			case MONTH:
			case NANOSECOND:
			case NEW:
			case NEXT:
			case NO:
			case NOT:
			case NULLS:
			case OBJECT:
			case OF:
			case OFFSET:
			case OFFSET_DATETIME:
			case ON:
			case ONLY:
			case OR:
			case ORDER:
			case OTHERS:
			case OUTER:
			case OVER:
			case OVERFLOW:
			case OVERLAY:
			case PAD:
			case PARTITION:
			case PERCENT:
			case PLACING:
			case POSITION:
			case PRECEDING:
			case QUARTER:
			case RANGE:
			case RESPECT:
			case RIGHT:
			case ROLLUP:
			case ROW:
			case ROWS:
			case SEARCH:
			case SECOND:
			case SELECT:
			case SET:
			case SIZE:
			case SOME:
			case SUBSTRING:
			case SUM:
			case THEN:
			case TIES:
			case TIME:
			case TIMESTAMP:
			case TIMEZONE_HOUR:
			case TIMEZONE_MINUTE:
			case TO:
			case TRAILING:
			case TREAT:
			case TRIM:
			case TRUNC:
			case TRUNCATE:
			case TYPE:
			case UNBOUNDED:
			case UNION:
			case UPDATE:
			case USING:
			case VALUE:
			case VALUES:
			case WEEK:
			case WHEN:
			case WHERE:
			case WITH:
			case WITHIN:
			case WITHOUT:
			case YEAR:
			case IDENTIFIER:
			case QUOTED_IDENTIFIER:
				_localctx = new JoinPathContext(_localctx);
				enterOuterAlt(_localctx, 1);
				{
				setState(713);
				path();
				setState(715);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,62,_ctx) ) {
				case 1:
					{
					setState(714);
					variable();
					}
					break;
				}
				}
				break;
			case LEFT_PAREN:
			case LATERAL:
				_localctx = new JoinSubqueryContext(_localctx);
				enterOuterAlt(_localctx, 2);
				{
				setState(718);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==LATERAL) {
					{
					setState(717);
					match(LATERAL);
					}
				}

				setState(720);
				match(LEFT_PAREN);
				setState(721);
				subquery();
				setState(722);
				match(RIGHT_PAREN);
				setState(724);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,64,_ctx) ) {
				case 1:
					{
					setState(723);
					variable();
					}
					break;
				}
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class JoinRestrictionContext extends ParserRuleContext {
		public PredicateContext predicate() {
			return getRuleContext(PredicateContext.class,0);
		}
		public TerminalNode ON() { return getToken(HqlParser.ON, 0); }
		public TerminalNode WITH() { return getToken(HqlParser.WITH, 0); }
		public JoinRestrictionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_joinRestriction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterJoinRestriction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitJoinRestriction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitJoinRestriction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final JoinRestrictionContext joinRestriction() throws RecognitionException {
		JoinRestrictionContext _localctx = new JoinRestrictionContext(_ctx, getState());
		enterRule(_localctx, 68, RULE_joinRestriction);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(728);
			_la = _input.LA(1);
			if ( !(_la==ON || _la==WITH) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			setState(729);
			predicate(0);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SelectClauseContext extends ParserRuleContext {
		public TerminalNode SELECT() { return getToken(HqlParser.SELECT, 0); }
		public SelectionListContext selectionList() {
			return getRuleContext(SelectionListContext.class,0);
		}
		public TerminalNode DISTINCT() { return getToken(HqlParser.DISTINCT, 0); }
		public SelectClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_selectClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSelectClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSelectClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSelectClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SelectClauseContext selectClause() throws RecognitionException {
		SelectClauseContext _localctx = new SelectClauseContext(_ctx, getState());
		enterRule(_localctx, 70, RULE_selectClause);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(731);
			match(SELECT);
			setState(733);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,66,_ctx) ) {
			case 1:
				{
				setState(732);
				match(DISTINCT);
				}
				break;
			}
			setState(735);
			selectionList();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SelectionListContext extends ParserRuleContext {
		public List<SelectionContext> selection() {
			return getRuleContexts(SelectionContext.class);
		}
		public SelectionContext selection(int i) {
			return getRuleContext(SelectionContext.class,i);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public SelectionListContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_selectionList; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSelectionList(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSelectionList(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSelectionList(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SelectionListContext selectionList() throws RecognitionException {
		SelectionListContext _localctx = new SelectionListContext(_ctx, getState());
		enterRule(_localctx, 72, RULE_selectionList);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(737);
			selection();
			setState(742);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(738);
				match(COMMA);
				setState(739);
				selection();
				}
				}
				setState(744);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SelectionContext extends ParserRuleContext {
		public SelectExpressionContext selectExpression() {
			return getRuleContext(SelectExpressionContext.class,0);
		}
		public VariableContext variable() {
			return getRuleContext(VariableContext.class,0);
		}
		public SelectionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_selection; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSelection(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSelection(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSelection(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SelectionContext selection() throws RecognitionException {
		SelectionContext _localctx = new SelectionContext(_ctx, getState());
		enterRule(_localctx, 74, RULE_selection);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(745);
			selectExpression();
			setState(747);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,68,_ctx) ) {
			case 1:
				{
				setState(746);
				variable();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SelectExpressionContext extends ParserRuleContext {
		public InstantiationContext instantiation() {
			return getRuleContext(InstantiationContext.class,0);
		}
		public MapEntrySelectionContext mapEntrySelection() {
			return getRuleContext(MapEntrySelectionContext.class,0);
		}
		public JpaSelectObjectSyntaxContext jpaSelectObjectSyntax() {
			return getRuleContext(JpaSelectObjectSyntaxContext.class,0);
		}
		public ExpressionOrPredicateContext expressionOrPredicate() {
			return getRuleContext(ExpressionOrPredicateContext.class,0);
		}
		public SelectExpressionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_selectExpression; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSelectExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSelectExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSelectExpression(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SelectExpressionContext selectExpression() throws RecognitionException {
		SelectExpressionContext _localctx = new SelectExpressionContext(_ctx, getState());
		enterRule(_localctx, 76, RULE_selectExpression);
		try {
			setState(753);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,69,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(749);
				instantiation();
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(750);
				mapEntrySelection();
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(751);
				jpaSelectObjectSyntax();
				}
				break;
			case 4:
				enterOuterAlt(_localctx, 4);
				{
				setState(752);
				expressionOrPredicate();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class MapEntrySelectionContext extends ParserRuleContext {
		public TerminalNode ENTRY() { return getToken(HqlParser.ENTRY, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public MapEntrySelectionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_mapEntrySelection; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterMapEntrySelection(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitMapEntrySelection(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitMapEntrySelection(this);
			else return visitor.visitChildren(this);
		}
	}

	public final MapEntrySelectionContext mapEntrySelection() throws RecognitionException {
		MapEntrySelectionContext _localctx = new MapEntrySelectionContext(_ctx, getState());
		enterRule(_localctx, 78, RULE_mapEntrySelection);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(755);
			match(ENTRY);
			setState(756);
			match(LEFT_PAREN);
			setState(757);
			path();
			setState(758);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class InstantiationContext extends ParserRuleContext {
		public TerminalNode NEW() { return getToken(HqlParser.NEW, 0); }
		public InstantiationTargetContext instantiationTarget() {
			return getRuleContext(InstantiationTargetContext.class,0);
		}
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public InstantiationArgumentsContext instantiationArguments() {
			return getRuleContext(InstantiationArgumentsContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public InstantiationContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_instantiation; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterInstantiation(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitInstantiation(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitInstantiation(this);
			else return visitor.visitChildren(this);
		}
	}

	public final InstantiationContext instantiation() throws RecognitionException {
		InstantiationContext _localctx = new InstantiationContext(_ctx, getState());
		enterRule(_localctx, 80, RULE_instantiation);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(760);
			match(NEW);
			setState(761);
			instantiationTarget();
			setState(762);
			match(LEFT_PAREN);
			setState(763);
			instantiationArguments();
			setState(764);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class InstantiationTargetContext extends ParserRuleContext {
		public TerminalNode LIST() { return getToken(HqlParser.LIST, 0); }
		public TerminalNode MAP() { return getToken(HqlParser.MAP, 0); }
		public SimplePathContext simplePath() {
			return getRuleContext(SimplePathContext.class,0);
		}
		public InstantiationTargetContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_instantiationTarget; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterInstantiationTarget(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitInstantiationTarget(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitInstantiationTarget(this);
			else return visitor.visitChildren(this);
		}
	}

	public final InstantiationTargetContext instantiationTarget() throws RecognitionException {
		InstantiationTargetContext _localctx = new InstantiationTargetContext(_ctx, getState());
		enterRule(_localctx, 82, RULE_instantiationTarget);
		try {
			setState(769);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,70,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(766);
				match(LIST);
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(767);
				match(MAP);
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(768);
				simplePath();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class InstantiationArgumentsContext extends ParserRuleContext {
		public List<InstantiationArgumentContext> instantiationArgument() {
			return getRuleContexts(InstantiationArgumentContext.class);
		}
		public InstantiationArgumentContext instantiationArgument(int i) {
			return getRuleContext(InstantiationArgumentContext.class,i);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public InstantiationArgumentsContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_instantiationArguments; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterInstantiationArguments(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitInstantiationArguments(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitInstantiationArguments(this);
			else return visitor.visitChildren(this);
		}
	}

	public final InstantiationArgumentsContext instantiationArguments() throws RecognitionException {
		InstantiationArgumentsContext _localctx = new InstantiationArgumentsContext(_ctx, getState());
		enterRule(_localctx, 84, RULE_instantiationArguments);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(771);
			instantiationArgument();
			setState(776);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(772);
				match(COMMA);
				setState(773);
				instantiationArgument();
				}
				}
				setState(778);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class InstantiationArgumentContext extends ParserRuleContext {
		public InstantiationArgumentExpressionContext instantiationArgumentExpression() {
			return getRuleContext(InstantiationArgumentExpressionContext.class,0);
		}
		public VariableContext variable() {
			return getRuleContext(VariableContext.class,0);
		}
		public InstantiationArgumentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_instantiationArgument; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterInstantiationArgument(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitInstantiationArgument(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitInstantiationArgument(this);
			else return visitor.visitChildren(this);
		}
	}

	public final InstantiationArgumentContext instantiationArgument() throws RecognitionException {
		InstantiationArgumentContext _localctx = new InstantiationArgumentContext(_ctx, getState());
		enterRule(_localctx, 86, RULE_instantiationArgument);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(779);
			instantiationArgumentExpression();
			setState(781);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (((((_la - 42)) & ~0x3f) == 0 && ((1L << (_la - 42)) & ((1L << (ID - 42)) | (1L << (VERSION - 42)) | (1L << (VERSIONED - 42)) | (1L << (NATURALID - 42)) | (1L << (ALL - 42)) | (1L << (AND - 42)) | (1L << (ANY - 42)) | (1L << (AS - 42)) | (1L << (ASC - 42)) | (1L << (AVG - 42)) | (1L << (BETWEEN - 42)) | (1L << (BOTH - 42)) | (1L << (BREADTH - 42)) | (1L << (BY - 42)) | (1L << (CASE - 42)) | (1L << (CAST - 42)) | (1L << (COLLATE - 42)) | (1L << (COUNT - 42)) | (1L << (CROSS - 42)) | (1L << (CUBE - 42)) | (1L << (CURRENT - 42)) | (1L << (CURRENT_DATE - 42)) | (1L << (CURRENT_INSTANT - 42)) | (1L << (CURRENT_TIME - 42)) | (1L << (CURRENT_TIMESTAMP - 42)) | (1L << (CYCLE - 42)) | (1L << (DATE - 42)) | (1L << (DATETIME - 42)) | (1L << (DAY - 42)) | (1L << (DEFAULT - 42)) | (1L << (DELETE - 42)) | (1L << (DEPTH - 42)) | (1L << (DESC - 42)) | (1L << (DISTINCT - 42)) | (1L << (ELEMENT - 42)) | (1L << (ELEMENTS - 42)) | (1L << (ELSE - 42)) | (1L << (EMPTY - 42)) | (1L << (END - 42)) | (1L << (ENTRY - 42)) | (1L << (EPOCH - 42)) | (1L << (ERROR - 42)) | (1L << (ESCAPE - 42)) | (1L << (EVERY - 42)) | (1L << (EXCEPT - 42)) | (1L << (EXCLUDE - 42)) | (1L << (EXISTS - 42)) | (1L << (EXTRACT - 42)) | (1L << (FETCH - 42)) | (1L << (FILTER - 42)) | (1L << (FIRST - 42)) | (1L << (FOLLOWING - 42)) | (1L << (FOR - 42)) | (1L << (FORMAT - 42)) | (1L << (FROM - 42)) | (1L << (FUNCTION - 42)) | (1L << (GROUP - 42)) | (1L << (GROUPS - 42)) | (1L << (HAVING - 42)) | (1L << (HOUR - 42)) | (1L << (IGNORE - 42)) | (1L << (ILIKE - 42)))) != 0) || ((((_la - 106)) & ~0x3f) == 0 && ((1L << (_la - 106)) & ((1L << (IN - 106)) | (1L << (INDEX - 106)) | (1L << (INDICES - 106)) | (1L << (INSERT - 106)) | (1L << (INSTANT - 106)) | (1L << (INTERSECT - 106)) | (1L << (INTO - 106)) | (1L << (IS - 106)) | (1L << (JOIN - 106)) | (1L << (KEY - 106)) | (1L << (LAST - 106)) | (1L << (LEADING - 106)) | (1L << (LIKE - 106)) | (1L << (LIMIT - 106)) | (1L << (LIST - 106)) | (1L << (LISTAGG - 106)) | (1L << (LOCAL - 106)) | (1L << (LOCAL_DATE - 106)) | (1L << (LOCAL_DATETIME - 106)) | (1L << (LOCAL_TIME - 106)) | (1L << (MAP - 106)) | (1L << (MATERIALIZED - 106)) | (1L << (MAX - 106)) | (1L << (MAXELEMENT - 106)) | (1L << (MAXINDEX - 106)) | (1L << (MEMBER - 106)) | (1L << (MICROSECOND - 106)) | (1L << (MILLISECOND - 106)) | (1L << (MIN - 106)) | (1L << (MINELEMENT - 106)) | (1L << (MININDEX - 106)) | (1L << (MINUTE - 106)) | (1L << (MONTH - 106)) | (1L << (NANOSECOND - 106)) | (1L << (NEW - 106)) | (1L << (NEXT - 106)) | (1L << (NO - 106)) | (1L << (NOT - 106)) | (1L << (NULLS - 106)) | (1L << (OBJECT - 106)) | (1L << (OF - 106)) | (1L << (OFFSET - 106)) | (1L << (OFFSET_DATETIME - 106)) | (1L << (ON - 106)) | (1L << (ONLY - 106)) | (1L << (OR - 106)) | (1L << (ORDER - 106)) | (1L << (OTHERS - 106)) | (1L << (OVER - 106)) | (1L << (OVERFLOW - 106)) | (1L << (OVERLAY - 106)) | (1L << (PAD - 106)) | (1L << (PARTITION - 106)) | (1L << (PERCENT - 106)) | (1L << (PLACING - 106)) | (1L << (POSITION - 106)) | (1L << (PRECEDING - 106)) | (1L << (QUARTER - 106)) | (1L << (RANGE - 106)) | (1L << (RESPECT - 106)))) != 0) || ((((_la - 171)) & ~0x3f) == 0 && ((1L << (_la - 171)) & ((1L << (ROLLUP - 171)) | (1L << (ROW - 171)) | (1L << (ROWS - 171)) | (1L << (SEARCH - 171)) | (1L << (SECOND - 171)) | (1L << (SELECT - 171)) | (1L << (SET - 171)) | (1L << (SIZE - 171)) | (1L << (SOME - 171)) | (1L << (SUBSTRING - 171)) | (1L << (SUM - 171)) | (1L << (THEN - 171)) | (1L << (TIES - 171)) | (1L << (TIME - 171)) | (1L << (TIMESTAMP - 171)) | (1L << (TIMEZONE_HOUR - 171)) | (1L << (TIMEZONE_MINUTE - 171)) | (1L << (TO - 171)) | (1L << (TRAILING - 171)) | (1L << (TREAT - 171)) | (1L << (TRIM - 171)) | (1L << (TRUNC - 171)) | (1L << (TRUNCATE - 171)) | (1L << (TYPE - 171)) | (1L << (UNBOUNDED - 171)) | (1L << (UNION - 171)) | (1L << (UPDATE - 171)) | (1L << (USING - 171)) | (1L << (VALUE - 171)) | (1L << (VALUES - 171)) | (1L << (WEEK - 171)) | (1L << (WHEN - 171)) | (1L << (WHERE - 171)) | (1L << (WITH - 171)) | (1L << (WITHIN - 171)) | (1L << (WITHOUT - 171)) | (1L << (YEAR - 171)) | (1L << (IDENTIFIER - 171)) | (1L << (QUOTED_IDENTIFIER - 171)))) != 0)) {
				{
				setState(780);
				variable();
				}
			}

			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class InstantiationArgumentExpressionContext extends ParserRuleContext {
		public ExpressionOrPredicateContext expressionOrPredicate() {
			return getRuleContext(ExpressionOrPredicateContext.class,0);
		}
		public InstantiationContext instantiation() {
			return getRuleContext(InstantiationContext.class,0);
		}
		public InstantiationArgumentExpressionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_instantiationArgumentExpression; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterInstantiationArgumentExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitInstantiationArgumentExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitInstantiationArgumentExpression(this);
			else return visitor.visitChildren(this);
		}
	}

	public final InstantiationArgumentExpressionContext instantiationArgumentExpression() throws RecognitionException {
		InstantiationArgumentExpressionContext _localctx = new InstantiationArgumentExpressionContext(_ctx, getState());
		enterRule(_localctx, 88, RULE_instantiationArgumentExpression);
		try {
			setState(785);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,73,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(783);
				expressionOrPredicate();
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(784);
				instantiation();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class JpaSelectObjectSyntaxContext extends ParserRuleContext {
		public TerminalNode OBJECT() { return getToken(HqlParser.OBJECT, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public IdentifierContext identifier() {
			return getRuleContext(IdentifierContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public JpaSelectObjectSyntaxContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_jpaSelectObjectSyntax; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterJpaSelectObjectSyntax(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitJpaSelectObjectSyntax(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitJpaSelectObjectSyntax(this);
			else return visitor.visitChildren(this);
		}
	}

	public final JpaSelectObjectSyntaxContext jpaSelectObjectSyntax() throws RecognitionException {
		JpaSelectObjectSyntaxContext _localctx = new JpaSelectObjectSyntaxContext(_ctx, getState());
		enterRule(_localctx, 90, RULE_jpaSelectObjectSyntax);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(787);
			match(OBJECT);
			setState(788);
			match(LEFT_PAREN);
			setState(789);
			identifier();
			setState(790);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SimplePathContext extends ParserRuleContext {
		public IdentifierContext identifier() {
			return getRuleContext(IdentifierContext.class,0);
		}
		public List<SimplePathElementContext> simplePathElement() {
			return getRuleContexts(SimplePathElementContext.class);
		}
		public SimplePathElementContext simplePathElement(int i) {
			return getRuleContext(SimplePathElementContext.class,i);
		}
		public SimplePathContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_simplePath; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSimplePath(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSimplePath(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSimplePath(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SimplePathContext simplePath() throws RecognitionException {
		SimplePathContext _localctx = new SimplePathContext(_ctx, getState());
		enterRule(_localctx, 92, RULE_simplePath);
		try {
			int _alt;
			enterOuterAlt(_localctx, 1);
			{
			setState(792);
			identifier();
			setState(796);
			_errHandler.sync(this);
			_alt = getInterpreter().adaptivePredict(_input,74,_ctx);
			while ( _alt!=2 && _alt!=org.antlr.v4.runtime.atn.ATN.INVALID_ALT_NUMBER ) {
				if ( _alt==1 ) {
					{
					{
					setState(793);
					simplePathElement();
					}
					} 
				}
				setState(798);
				_errHandler.sync(this);
				_alt = getInterpreter().adaptivePredict(_input,74,_ctx);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SimplePathElementContext extends ParserRuleContext {
		public TerminalNode DOT() { return getToken(HqlParser.DOT, 0); }
		public IdentifierContext identifier() {
			return getRuleContext(IdentifierContext.class,0);
		}
		public SimplePathElementContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_simplePathElement; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSimplePathElement(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSimplePathElement(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSimplePathElement(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SimplePathElementContext simplePathElement() throws RecognitionException {
		SimplePathElementContext _localctx = new SimplePathElementContext(_ctx, getState());
		enterRule(_localctx, 94, RULE_simplePathElement);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(799);
			match(DOT);
			setState(800);
			identifier();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class PathContext extends ParserRuleContext {
		public SyntacticDomainPathContext syntacticDomainPath() {
			return getRuleContext(SyntacticDomainPathContext.class,0);
		}
		public PathContinuationContext pathContinuation() {
			return getRuleContext(PathContinuationContext.class,0);
		}
		public GeneralPathFragmentContext generalPathFragment() {
			return getRuleContext(GeneralPathFragmentContext.class,0);
		}
		public PathContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_path; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterPath(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitPath(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitPath(this);
			else return visitor.visitChildren(this);
		}
	}

	public final PathContext path() throws RecognitionException {
		PathContext _localctx = new PathContext(_ctx, getState());
		enterRule(_localctx, 96, RULE_path);
		try {
			setState(807);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,76,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(802);
				syntacticDomainPath();
				setState(804);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,75,_ctx) ) {
				case 1:
					{
					setState(803);
					pathContinuation();
					}
					break;
				}
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(806);
				generalPathFragment();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class PathContinuationContext extends ParserRuleContext {
		public TerminalNode DOT() { return getToken(HqlParser.DOT, 0); }
		public SimplePathContext simplePath() {
			return getRuleContext(SimplePathContext.class,0);
		}
		public PathContinuationContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_pathContinuation; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterPathContinuation(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitPathContinuation(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitPathContinuation(this);
			else return visitor.visitChildren(this);
		}
	}

	public final PathContinuationContext pathContinuation() throws RecognitionException {
		PathContinuationContext _localctx = new PathContinuationContext(_ctx, getState());
		enterRule(_localctx, 98, RULE_pathContinuation);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(809);
			match(DOT);
			setState(810);
			simplePath();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SyntacticDomainPathContext extends ParserRuleContext {
		public TreatedNavigablePathContext treatedNavigablePath() {
			return getRuleContext(TreatedNavigablePathContext.class,0);
		}
		public CollectionValueNavigablePathContext collectionValueNavigablePath() {
			return getRuleContext(CollectionValueNavigablePathContext.class,0);
		}
		public MapKeyNavigablePathContext mapKeyNavigablePath() {
			return getRuleContext(MapKeyNavigablePathContext.class,0);
		}
		public SimplePathContext simplePath() {
			return getRuleContext(SimplePathContext.class,0);
		}
		public IndexedPathAccessFragmentContext indexedPathAccessFragment() {
			return getRuleContext(IndexedPathAccessFragmentContext.class,0);
		}
		public SyntacticDomainPathContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_syntacticDomainPath; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSyntacticDomainPath(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSyntacticDomainPath(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSyntacticDomainPath(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SyntacticDomainPathContext syntacticDomainPath() throws RecognitionException {
		SyntacticDomainPathContext _localctx = new SyntacticDomainPathContext(_ctx, getState());
		enterRule(_localctx, 100, RULE_syntacticDomainPath);
		try {
			setState(818);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,77,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(812);
				treatedNavigablePath();
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(813);
				collectionValueNavigablePath();
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(814);
				mapKeyNavigablePath();
				}
				break;
			case 4:
				enterOuterAlt(_localctx, 4);
				{
				setState(815);
				simplePath();
				setState(816);
				indexedPathAccessFragment();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class GeneralPathFragmentContext extends ParserRuleContext {
		public SimplePathContext simplePath() {
			return getRuleContext(SimplePathContext.class,0);
		}
		public IndexedPathAccessFragmentContext indexedPathAccessFragment() {
			return getRuleContext(IndexedPathAccessFragmentContext.class,0);
		}
		public GeneralPathFragmentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_generalPathFragment; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterGeneralPathFragment(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitGeneralPathFragment(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitGeneralPathFragment(this);
			else return visitor.visitChildren(this);
		}
	}

	public final GeneralPathFragmentContext generalPathFragment() throws RecognitionException {
		GeneralPathFragmentContext _localctx = new GeneralPathFragmentContext(_ctx, getState());
		enterRule(_localctx, 102, RULE_generalPathFragment);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(820);
			simplePath();
			setState(822);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,78,_ctx) ) {
			case 1:
				{
				setState(821);
				indexedPathAccessFragment();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class IndexedPathAccessFragmentContext extends ParserRuleContext {
		public TerminalNode LEFT_BRACKET() { return getToken(HqlParser.LEFT_BRACKET, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode RIGHT_BRACKET() { return getToken(HqlParser.RIGHT_BRACKET, 0); }
		public TerminalNode DOT() { return getToken(HqlParser.DOT, 0); }
		public GeneralPathFragmentContext generalPathFragment() {
			return getRuleContext(GeneralPathFragmentContext.class,0);
		}
		public IndexedPathAccessFragmentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_indexedPathAccessFragment; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterIndexedPathAccessFragment(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitIndexedPathAccessFragment(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitIndexedPathAccessFragment(this);
			else return visitor.visitChildren(this);
		}
	}

	public final IndexedPathAccessFragmentContext indexedPathAccessFragment() throws RecognitionException {
		IndexedPathAccessFragmentContext _localctx = new IndexedPathAccessFragmentContext(_ctx, getState());
		enterRule(_localctx, 104, RULE_indexedPathAccessFragment);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(824);
			match(LEFT_BRACKET);
			setState(825);
			expression(0);
			setState(826);
			match(RIGHT_BRACKET);
			setState(829);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,79,_ctx) ) {
			case 1:
				{
				setState(827);
				match(DOT);
				setState(828);
				generalPathFragment();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class TreatedNavigablePathContext extends ParserRuleContext {
		public TerminalNode TREAT() { return getToken(HqlParser.TREAT, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public TerminalNode AS() { return getToken(HqlParser.AS, 0); }
		public SimplePathContext simplePath() {
			return getRuleContext(SimplePathContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public PathContinuationContext pathContinuation() {
			return getRuleContext(PathContinuationContext.class,0);
		}
		public TreatedNavigablePathContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_treatedNavigablePath; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterTreatedNavigablePath(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitTreatedNavigablePath(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitTreatedNavigablePath(this);
			else return visitor.visitChildren(this);
		}
	}

	public final TreatedNavigablePathContext treatedNavigablePath() throws RecognitionException {
		TreatedNavigablePathContext _localctx = new TreatedNavigablePathContext(_ctx, getState());
		enterRule(_localctx, 106, RULE_treatedNavigablePath);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(831);
			match(TREAT);
			setState(832);
			match(LEFT_PAREN);
			setState(833);
			path();
			setState(834);
			match(AS);
			setState(835);
			simplePath();
			setState(836);
			match(RIGHT_PAREN);
			setState(838);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,80,_ctx) ) {
			case 1:
				{
				setState(837);
				pathContinuation();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class CollectionValueNavigablePathContext extends ParserRuleContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode VALUE() { return getToken(HqlParser.VALUE, 0); }
		public TerminalNode ELEMENT() { return getToken(HqlParser.ELEMENT, 0); }
		public PathContinuationContext pathContinuation() {
			return getRuleContext(PathContinuationContext.class,0);
		}
		public CollectionValueNavigablePathContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_collectionValueNavigablePath; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCollectionValueNavigablePath(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCollectionValueNavigablePath(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCollectionValueNavigablePath(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CollectionValueNavigablePathContext collectionValueNavigablePath() throws RecognitionException {
		CollectionValueNavigablePathContext _localctx = new CollectionValueNavigablePathContext(_ctx, getState());
		enterRule(_localctx, 108, RULE_collectionValueNavigablePath);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(840);
			_la = _input.LA(1);
			if ( !(_la==ELEMENT || _la==VALUE) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			setState(841);
			match(LEFT_PAREN);
			setState(842);
			path();
			setState(843);
			match(RIGHT_PAREN);
			setState(845);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,81,_ctx) ) {
			case 1:
				{
				setState(844);
				pathContinuation();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class MapKeyNavigablePathContext extends ParserRuleContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode KEY() { return getToken(HqlParser.KEY, 0); }
		public TerminalNode INDEX() { return getToken(HqlParser.INDEX, 0); }
		public PathContinuationContext pathContinuation() {
			return getRuleContext(PathContinuationContext.class,0);
		}
		public MapKeyNavigablePathContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_mapKeyNavigablePath; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterMapKeyNavigablePath(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitMapKeyNavigablePath(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitMapKeyNavigablePath(this);
			else return visitor.visitChildren(this);
		}
	}

	public final MapKeyNavigablePathContext mapKeyNavigablePath() throws RecognitionException {
		MapKeyNavigablePathContext _localctx = new MapKeyNavigablePathContext(_ctx, getState());
		enterRule(_localctx, 110, RULE_mapKeyNavigablePath);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(847);
			_la = _input.LA(1);
			if ( !(_la==INDEX || _la==KEY) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			setState(848);
			match(LEFT_PAREN);
			setState(849);
			path();
			setState(850);
			match(RIGHT_PAREN);
			setState(852);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,82,_ctx) ) {
			case 1:
				{
				setState(851);
				pathContinuation();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class GroupByClauseContext extends ParserRuleContext {
		public TerminalNode GROUP() { return getToken(HqlParser.GROUP, 0); }
		public TerminalNode BY() { return getToken(HqlParser.BY, 0); }
		public List<GroupByExpressionContext> groupByExpression() {
			return getRuleContexts(GroupByExpressionContext.class);
		}
		public GroupByExpressionContext groupByExpression(int i) {
			return getRuleContext(GroupByExpressionContext.class,i);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public GroupByClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_groupByClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterGroupByClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitGroupByClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitGroupByClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final GroupByClauseContext groupByClause() throws RecognitionException {
		GroupByClauseContext _localctx = new GroupByClauseContext(_ctx, getState());
		enterRule(_localctx, 112, RULE_groupByClause);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(854);
			match(GROUP);
			setState(855);
			match(BY);
			setState(856);
			groupByExpression();
			setState(861);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(857);
				match(COMMA);
				setState(858);
				groupByExpression();
				}
				}
				setState(863);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class GroupByExpressionContext extends ParserRuleContext {
		public IdentifierContext identifier() {
			return getRuleContext(IdentifierContext.class,0);
		}
		public TerminalNode INTEGER_LITERAL() { return getToken(HqlParser.INTEGER_LITERAL, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public GroupByExpressionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_groupByExpression; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterGroupByExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitGroupByExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitGroupByExpression(this);
			else return visitor.visitChildren(this);
		}
	}

	public final GroupByExpressionContext groupByExpression() throws RecognitionException {
		GroupByExpressionContext _localctx = new GroupByExpressionContext(_ctx, getState());
		enterRule(_localctx, 114, RULE_groupByExpression);
		try {
			setState(867);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,84,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(864);
				identifier();
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(865);
				match(INTEGER_LITERAL);
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(866);
				expression(0);
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class HavingClauseContext extends ParserRuleContext {
		public TerminalNode HAVING() { return getToken(HqlParser.HAVING, 0); }
		public PredicateContext predicate() {
			return getRuleContext(PredicateContext.class,0);
		}
		public HavingClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_havingClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterHavingClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitHavingClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitHavingClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final HavingClauseContext havingClause() throws RecognitionException {
		HavingClauseContext _localctx = new HavingClauseContext(_ctx, getState());
		enterRule(_localctx, 116, RULE_havingClause);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(869);
			match(HAVING);
			setState(870);
			predicate(0);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class OrderByClauseContext extends ParserRuleContext {
		public TerminalNode ORDER() { return getToken(HqlParser.ORDER, 0); }
		public TerminalNode BY() { return getToken(HqlParser.BY, 0); }
		public List<SortSpecificationContext> sortSpecification() {
			return getRuleContexts(SortSpecificationContext.class);
		}
		public SortSpecificationContext sortSpecification(int i) {
			return getRuleContext(SortSpecificationContext.class,i);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public OrderByClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_orderByClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOrderByClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOrderByClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOrderByClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OrderByClauseContext orderByClause() throws RecognitionException {
		OrderByClauseContext _localctx = new OrderByClauseContext(_ctx, getState());
		enterRule(_localctx, 118, RULE_orderByClause);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(872);
			match(ORDER);
			setState(873);
			match(BY);
			setState(874);
			sortSpecification();
			setState(879);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(875);
				match(COMMA);
				setState(876);
				sortSpecification();
				}
				}
				setState(881);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class OrderByFragmentContext extends ParserRuleContext {
		public List<SortSpecificationContext> sortSpecification() {
			return getRuleContexts(SortSpecificationContext.class);
		}
		public SortSpecificationContext sortSpecification(int i) {
			return getRuleContext(SortSpecificationContext.class,i);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public OrderByFragmentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_orderByFragment; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOrderByFragment(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOrderByFragment(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOrderByFragment(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OrderByFragmentContext orderByFragment() throws RecognitionException {
		OrderByFragmentContext _localctx = new OrderByFragmentContext(_ctx, getState());
		enterRule(_localctx, 120, RULE_orderByFragment);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(882);
			sortSpecification();
			setState(887);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(883);
				match(COMMA);
				setState(884);
				sortSpecification();
				}
				}
				setState(889);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SortSpecificationContext extends ParserRuleContext {
		public SortExpressionContext sortExpression() {
			return getRuleContext(SortExpressionContext.class,0);
		}
		public SortDirectionContext sortDirection() {
			return getRuleContext(SortDirectionContext.class,0);
		}
		public NullsPrecedenceContext nullsPrecedence() {
			return getRuleContext(NullsPrecedenceContext.class,0);
		}
		public SortSpecificationContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_sortSpecification; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSortSpecification(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSortSpecification(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSortSpecification(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SortSpecificationContext sortSpecification() throws RecognitionException {
		SortSpecificationContext _localctx = new SortSpecificationContext(_ctx, getState());
		enterRule(_localctx, 122, RULE_sortSpecification);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(890);
			sortExpression();
			setState(892);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==ASC || _la==DESC) {
				{
				setState(891);
				sortDirection();
				}
			}

			setState(895);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==NULLS) {
				{
				setState(894);
				nullsPrecedence();
				}
			}

			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class NullsPrecedenceContext extends ParserRuleContext {
		public TerminalNode NULLS() { return getToken(HqlParser.NULLS, 0); }
		public TerminalNode FIRST() { return getToken(HqlParser.FIRST, 0); }
		public TerminalNode LAST() { return getToken(HqlParser.LAST, 0); }
		public NullsPrecedenceContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_nullsPrecedence; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterNullsPrecedence(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitNullsPrecedence(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitNullsPrecedence(this);
			else return visitor.visitChildren(this);
		}
	}

	public final NullsPrecedenceContext nullsPrecedence() throws RecognitionException {
		NullsPrecedenceContext _localctx = new NullsPrecedenceContext(_ctx, getState());
		enterRule(_localctx, 124, RULE_nullsPrecedence);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(897);
			match(NULLS);
			setState(898);
			_la = _input.LA(1);
			if ( !(_la==FIRST || _la==LAST) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SortExpressionContext extends ParserRuleContext {
		public IdentifierContext identifier() {
			return getRuleContext(IdentifierContext.class,0);
		}
		public TerminalNode INTEGER_LITERAL() { return getToken(HqlParser.INTEGER_LITERAL, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public SortExpressionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_sortExpression; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSortExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSortExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSortExpression(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SortExpressionContext sortExpression() throws RecognitionException {
		SortExpressionContext _localctx = new SortExpressionContext(_ctx, getState());
		enterRule(_localctx, 126, RULE_sortExpression);
		try {
			setState(903);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,89,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(900);
				identifier();
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(901);
				match(INTEGER_LITERAL);
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(902);
				expression(0);
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SortDirectionContext extends ParserRuleContext {
		public TerminalNode ASC() { return getToken(HqlParser.ASC, 0); }
		public TerminalNode DESC() { return getToken(HqlParser.DESC, 0); }
		public SortDirectionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_sortDirection; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSortDirection(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSortDirection(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSortDirection(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SortDirectionContext sortDirection() throws RecognitionException {
		SortDirectionContext _localctx = new SortDirectionContext(_ctx, getState());
		enterRule(_localctx, 128, RULE_sortDirection);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(905);
			_la = _input.LA(1);
			if ( !(_la==ASC || _la==DESC) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class CollateFunctionContext extends ParserRuleContext {
		public TerminalNode COLLATE() { return getToken(HqlParser.COLLATE, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode AS() { return getToken(HqlParser.AS, 0); }
		public CollationContext collation() {
			return getRuleContext(CollationContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public CollateFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_collateFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCollateFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCollateFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCollateFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CollateFunctionContext collateFunction() throws RecognitionException {
		CollateFunctionContext _localctx = new CollateFunctionContext(_ctx, getState());
		enterRule(_localctx, 130, RULE_collateFunction);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(907);
			match(COLLATE);
			setState(908);
			match(LEFT_PAREN);
			setState(909);
			expression(0);
			setState(910);
			match(AS);
			setState(911);
			collation();
			setState(912);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class CollationContext extends ParserRuleContext {
		public SimplePathContext simplePath() {
			return getRuleContext(SimplePathContext.class,0);
		}
		public CollationContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_collation; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCollation(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCollation(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCollation(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CollationContext collation() throws RecognitionException {
		CollationContext _localctx = new CollationContext(_ctx, getState());
		enterRule(_localctx, 132, RULE_collation);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(914);
			simplePath();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class LimitClauseContext extends ParserRuleContext {
		public TerminalNode LIMIT() { return getToken(HqlParser.LIMIT, 0); }
		public ParameterOrIntegerLiteralContext parameterOrIntegerLiteral() {
			return getRuleContext(ParameterOrIntegerLiteralContext.class,0);
		}
		public LimitClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_limitClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterLimitClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitLimitClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitLimitClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final LimitClauseContext limitClause() throws RecognitionException {
		LimitClauseContext _localctx = new LimitClauseContext(_ctx, getState());
		enterRule(_localctx, 134, RULE_limitClause);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(916);
			match(LIMIT);
			setState(917);
			parameterOrIntegerLiteral();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class OffsetClauseContext extends ParserRuleContext {
		public TerminalNode OFFSET() { return getToken(HqlParser.OFFSET, 0); }
		public ParameterOrIntegerLiteralContext parameterOrIntegerLiteral() {
			return getRuleContext(ParameterOrIntegerLiteralContext.class,0);
		}
		public TerminalNode ROW() { return getToken(HqlParser.ROW, 0); }
		public TerminalNode ROWS() { return getToken(HqlParser.ROWS, 0); }
		public OffsetClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_offsetClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOffsetClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOffsetClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOffsetClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OffsetClauseContext offsetClause() throws RecognitionException {
		OffsetClauseContext _localctx = new OffsetClauseContext(_ctx, getState());
		enterRule(_localctx, 136, RULE_offsetClause);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(919);
			match(OFFSET);
			setState(920);
			parameterOrIntegerLiteral();
			setState(922);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==ROW || _la==ROWS) {
				{
				setState(921);
				_la = _input.LA(1);
				if ( !(_la==ROW || _la==ROWS) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}
				}
			}

			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class FetchClauseContext extends ParserRuleContext {
		public TerminalNode FETCH() { return getToken(HqlParser.FETCH, 0); }
		public TerminalNode FIRST() { return getToken(HqlParser.FIRST, 0); }
		public TerminalNode NEXT() { return getToken(HqlParser.NEXT, 0); }
		public TerminalNode ROW() { return getToken(HqlParser.ROW, 0); }
		public TerminalNode ROWS() { return getToken(HqlParser.ROWS, 0); }
		public ParameterOrIntegerLiteralContext parameterOrIntegerLiteral() {
			return getRuleContext(ParameterOrIntegerLiteralContext.class,0);
		}
		public ParameterOrNumberLiteralContext parameterOrNumberLiteral() {
			return getRuleContext(ParameterOrNumberLiteralContext.class,0);
		}
		public TerminalNode PERCENT() { return getToken(HqlParser.PERCENT, 0); }
		public TerminalNode ONLY() { return getToken(HqlParser.ONLY, 0); }
		public TerminalNode WITH() { return getToken(HqlParser.WITH, 0); }
		public TerminalNode TIES() { return getToken(HqlParser.TIES, 0); }
		public FetchClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_fetchClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterFetchClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitFetchClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitFetchClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final FetchClauseContext fetchClause() throws RecognitionException {
		FetchClauseContext _localctx = new FetchClauseContext(_ctx, getState());
		enterRule(_localctx, 138, RULE_fetchClause);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(924);
			match(FETCH);
			setState(925);
			_la = _input.LA(1);
			if ( !(_la==FIRST || _la==NEXT) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			setState(930);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,91,_ctx) ) {
			case 1:
				{
				setState(926);
				parameterOrIntegerLiteral();
				}
				break;
			case 2:
				{
				setState(927);
				parameterOrNumberLiteral();
				setState(928);
				match(PERCENT);
				}
				break;
			}
			setState(932);
			_la = _input.LA(1);
			if ( !(_la==ROW || _la==ROWS) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			setState(936);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case ONLY:
				{
				setState(933);
				match(ONLY);
				}
				break;
			case WITH:
				{
				setState(934);
				match(WITH);
				setState(935);
				match(TIES);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class ParameterOrIntegerLiteralContext extends ParserRuleContext {
		public ParameterContext parameter() {
			return getRuleContext(ParameterContext.class,0);
		}
		public TerminalNode INTEGER_LITERAL() { return getToken(HqlParser.INTEGER_LITERAL, 0); }
		public ParameterOrIntegerLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_parameterOrIntegerLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterParameterOrIntegerLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitParameterOrIntegerLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitParameterOrIntegerLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ParameterOrIntegerLiteralContext parameterOrIntegerLiteral() throws RecognitionException {
		ParameterOrIntegerLiteralContext _localctx = new ParameterOrIntegerLiteralContext(_ctx, getState());
		enterRule(_localctx, 140, RULE_parameterOrIntegerLiteral);
		try {
			setState(940);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case COLON:
			case QUESTION_MARK:
				enterOuterAlt(_localctx, 1);
				{
				setState(938);
				parameter();
				}
				break;
			case INTEGER_LITERAL:
				enterOuterAlt(_localctx, 2);
				{
				setState(939);
				match(INTEGER_LITERAL);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class ParameterOrNumberLiteralContext extends ParserRuleContext {
		public ParameterContext parameter() {
			return getRuleContext(ParameterContext.class,0);
		}
		public TerminalNode INTEGER_LITERAL() { return getToken(HqlParser.INTEGER_LITERAL, 0); }
		public TerminalNode FLOAT_LITERAL() { return getToken(HqlParser.FLOAT_LITERAL, 0); }
		public TerminalNode DOUBLE_LITERAL() { return getToken(HqlParser.DOUBLE_LITERAL, 0); }
		public ParameterOrNumberLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_parameterOrNumberLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterParameterOrNumberLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitParameterOrNumberLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitParameterOrNumberLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ParameterOrNumberLiteralContext parameterOrNumberLiteral() throws RecognitionException {
		ParameterOrNumberLiteralContext _localctx = new ParameterOrNumberLiteralContext(_ctx, getState());
		enterRule(_localctx, 142, RULE_parameterOrNumberLiteral);
		try {
			setState(946);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case COLON:
			case QUESTION_MARK:
				enterOuterAlt(_localctx, 1);
				{
				setState(942);
				parameter();
				}
				break;
			case INTEGER_LITERAL:
				enterOuterAlt(_localctx, 2);
				{
				setState(943);
				match(INTEGER_LITERAL);
				}
				break;
			case FLOAT_LITERAL:
				enterOuterAlt(_localctx, 3);
				{
				setState(944);
				match(FLOAT_LITERAL);
				}
				break;
			case DOUBLE_LITERAL:
				enterOuterAlt(_localctx, 4);
				{
				setState(945);
				match(DOUBLE_LITERAL);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class WhereClauseContext extends ParserRuleContext {
		public TerminalNode WHERE() { return getToken(HqlParser.WHERE, 0); }
		public PredicateContext predicate() {
			return getRuleContext(PredicateContext.class,0);
		}
		public WhereClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_whereClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterWhereClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitWhereClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitWhereClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final WhereClauseContext whereClause() throws RecognitionException {
		WhereClauseContext _localctx = new WhereClauseContext(_ctx, getState());
		enterRule(_localctx, 144, RULE_whereClause);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(948);
			match(WHERE);
			setState(949);
			predicate(0);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class PredicateContext extends ParserRuleContext {
		public PredicateContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_predicate; }
	 
		public PredicateContext() { }
		public void copyFrom(PredicateContext ctx) {
			super.copyFrom(ctx);
		}
	}
	public static class BetweenPredicateContext extends PredicateContext {
		public List<ExpressionContext> expression() {
			return getRuleContexts(ExpressionContext.class);
		}
		public ExpressionContext expression(int i) {
			return getRuleContext(ExpressionContext.class,i);
		}
		public TerminalNode BETWEEN() { return getToken(HqlParser.BETWEEN, 0); }
		public TerminalNode AND() { return getToken(HqlParser.AND, 0); }
		public TerminalNode NOT() { return getToken(HqlParser.NOT, 0); }
		public BetweenPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterBetweenPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitBetweenPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitBetweenPredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class ExistsPredicateContext extends PredicateContext {
		public TerminalNode EXISTS() { return getToken(HqlParser.EXISTS, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public ExistsPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterExistsPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitExistsPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitExistsPredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class AndPredicateContext extends PredicateContext {
		public List<PredicateContext> predicate() {
			return getRuleContexts(PredicateContext.class);
		}
		public PredicateContext predicate(int i) {
			return getRuleContext(PredicateContext.class,i);
		}
		public TerminalNode AND() { return getToken(HqlParser.AND, 0); }
		public AndPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterAndPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitAndPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitAndPredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class GroupedPredicateContext extends PredicateContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PredicateContext predicate() {
			return getRuleContext(PredicateContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public GroupedPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterGroupedPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitGroupedPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitGroupedPredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class LikePredicateContext extends PredicateContext {
		public List<ExpressionContext> expression() {
			return getRuleContexts(ExpressionContext.class);
		}
		public ExpressionContext expression(int i) {
			return getRuleContext(ExpressionContext.class,i);
		}
		public TerminalNode LIKE() { return getToken(HqlParser.LIKE, 0); }
		public TerminalNode ILIKE() { return getToken(HqlParser.ILIKE, 0); }
		public TerminalNode NOT() { return getToken(HqlParser.NOT, 0); }
		public LikeEscapeContext likeEscape() {
			return getRuleContext(LikeEscapeContext.class,0);
		}
		public LikePredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterLikePredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitLikePredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitLikePredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class InPredicateContext extends PredicateContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode IN() { return getToken(HqlParser.IN, 0); }
		public InListContext inList() {
			return getRuleContext(InListContext.class,0);
		}
		public TerminalNode NOT() { return getToken(HqlParser.NOT, 0); }
		public InPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterInPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitInPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitInPredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class ComparisonPredicateContext extends PredicateContext {
		public List<ExpressionContext> expression() {
			return getRuleContexts(ExpressionContext.class);
		}
		public ExpressionContext expression(int i) {
			return getRuleContext(ExpressionContext.class,i);
		}
		public ComparisonOperatorContext comparisonOperator() {
			return getRuleContext(ComparisonOperatorContext.class,0);
		}
		public ComparisonPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterComparisonPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitComparisonPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitComparisonPredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class ExistsCollectionPartPredicateContext extends PredicateContext {
		public TerminalNode EXISTS() { return getToken(HqlParser.EXISTS, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public SimplePathContext simplePath() {
			return getRuleContext(SimplePathContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode ELEMENTS() { return getToken(HqlParser.ELEMENTS, 0); }
		public TerminalNode INDICES() { return getToken(HqlParser.INDICES, 0); }
		public ExistsCollectionPartPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterExistsCollectionPartPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitExistsCollectionPartPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitExistsCollectionPartPredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class NegatedPredicateContext extends PredicateContext {
		public TerminalNode NOT() { return getToken(HqlParser.NOT, 0); }
		public PredicateContext predicate() {
			return getRuleContext(PredicateContext.class,0);
		}
		public NegatedPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterNegatedPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitNegatedPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitNegatedPredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class BooleanExpressionPredicateContext extends PredicateContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public BooleanExpressionPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterBooleanExpressionPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitBooleanExpressionPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitBooleanExpressionPredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class OrPredicateContext extends PredicateContext {
		public List<PredicateContext> predicate() {
			return getRuleContexts(PredicateContext.class);
		}
		public PredicateContext predicate(int i) {
			return getRuleContext(PredicateContext.class,i);
		}
		public TerminalNode OR() { return getToken(HqlParser.OR, 0); }
		public OrPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOrPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOrPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOrPredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class MemberOfPredicateContext extends PredicateContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode MEMBER() { return getToken(HqlParser.MEMBER, 0); }
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public TerminalNode NOT() { return getToken(HqlParser.NOT, 0); }
		public TerminalNode OF() { return getToken(HqlParser.OF, 0); }
		public MemberOfPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterMemberOfPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitMemberOfPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitMemberOfPredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class IsEmptyPredicateContext extends PredicateContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode IS() { return getToken(HqlParser.IS, 0); }
		public TerminalNode EMPTY() { return getToken(HqlParser.EMPTY, 0); }
		public TerminalNode NOT() { return getToken(HqlParser.NOT, 0); }
		public IsEmptyPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterIsEmptyPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitIsEmptyPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitIsEmptyPredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class IsNullPredicateContext extends PredicateContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode IS() { return getToken(HqlParser.IS, 0); }
		public TerminalNode NULL() { return getToken(HqlParser.NULL, 0); }
		public TerminalNode NOT() { return getToken(HqlParser.NOT, 0); }
		public IsNullPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterIsNullPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitIsNullPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitIsNullPredicate(this);
			else return visitor.visitChildren(this);
		}
	}

	public final PredicateContext predicate() throws RecognitionException {
		return predicate(0);
	}

	private PredicateContext predicate(int _p) throws RecognitionException {
		ParserRuleContext _parentctx = _ctx;
		int _parentState = getState();
		PredicateContext _localctx = new PredicateContext(_ctx, _parentState);
		PredicateContext _prevctx = _localctx;
		int _startState = 146;
		enterRecursionRule(_localctx, 146, RULE_predicate, _p);
		int _la;
		try {
			int _alt;
			enterOuterAlt(_localctx, 1);
			{
			setState(1020);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,103,_ctx) ) {
			case 1:
				{
				_localctx = new GroupedPredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;

				setState(952);
				match(LEFT_PAREN);
				setState(953);
				predicate(0);
				setState(954);
				match(RIGHT_PAREN);
				}
				break;
			case 2:
				{
				_localctx = new IsNullPredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(956);
				expression(0);
				setState(957);
				match(IS);
				setState(959);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==NOT) {
					{
					setState(958);
					match(NOT);
					}
				}

				setState(961);
				match(NULL);
				}
				break;
			case 3:
				{
				_localctx = new IsEmptyPredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(963);
				expression(0);
				setState(964);
				match(IS);
				setState(966);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==NOT) {
					{
					setState(965);
					match(NOT);
					}
				}

				setState(968);
				match(EMPTY);
				}
				break;
			case 4:
				{
				_localctx = new InPredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(970);
				expression(0);
				setState(972);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==NOT) {
					{
					setState(971);
					match(NOT);
					}
				}

				setState(974);
				match(IN);
				setState(975);
				inList();
				}
				break;
			case 5:
				{
				_localctx = new BetweenPredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(977);
				expression(0);
				setState(979);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==NOT) {
					{
					setState(978);
					match(NOT);
					}
				}

				setState(981);
				match(BETWEEN);
				setState(982);
				expression(0);
				setState(983);
				match(AND);
				setState(984);
				expression(0);
				}
				break;
			case 6:
				{
				_localctx = new LikePredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(986);
				expression(0);
				setState(988);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==NOT) {
					{
					setState(987);
					match(NOT);
					}
				}

				setState(990);
				_la = _input.LA(1);
				if ( !(_la==ILIKE || _la==LIKE) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}
				setState(991);
				expression(0);
				setState(993);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,100,_ctx) ) {
				case 1:
					{
					setState(992);
					likeEscape();
					}
					break;
				}
				}
				break;
			case 7:
				{
				_localctx = new ComparisonPredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(995);
				expression(0);
				setState(996);
				comparisonOperator();
				setState(997);
				expression(0);
				}
				break;
			case 8:
				{
				_localctx = new ExistsCollectionPartPredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(999);
				match(EXISTS);
				setState(1000);
				_la = _input.LA(1);
				if ( !(_la==ELEMENTS || _la==INDICES) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}
				setState(1001);
				match(LEFT_PAREN);
				setState(1002);
				simplePath();
				setState(1003);
				match(RIGHT_PAREN);
				}
				break;
			case 9:
				{
				_localctx = new ExistsPredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(1005);
				match(EXISTS);
				setState(1006);
				expression(0);
				}
				break;
			case 10:
				{
				_localctx = new MemberOfPredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(1007);
				expression(0);
				setState(1009);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==NOT) {
					{
					setState(1008);
					match(NOT);
					}
				}

				setState(1011);
				match(MEMBER);
				setState(1013);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,102,_ctx) ) {
				case 1:
					{
					setState(1012);
					match(OF);
					}
					break;
				}
				setState(1015);
				path();
				}
				break;
			case 11:
				{
				_localctx = new NegatedPredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(1017);
				match(NOT);
				setState(1018);
				predicate(4);
				}
				break;
			case 12:
				{
				_localctx = new BooleanExpressionPredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(1019);
				expression(0);
				}
				break;
			}
			_ctx.stop = _input.LT(-1);
			setState(1030);
			_errHandler.sync(this);
			_alt = getInterpreter().adaptivePredict(_input,105,_ctx);
			while ( _alt!=2 && _alt!=org.antlr.v4.runtime.atn.ATN.INVALID_ALT_NUMBER ) {
				if ( _alt==1 ) {
					if ( _parseListeners!=null ) triggerExitRuleEvent();
					_prevctx = _localctx;
					{
					setState(1028);
					_errHandler.sync(this);
					switch ( getInterpreter().adaptivePredict(_input,104,_ctx) ) {
					case 1:
						{
						_localctx = new AndPredicateContext(new PredicateContext(_parentctx, _parentState));
						pushNewRecursionContext(_localctx, _startState, RULE_predicate);
						setState(1022);
						if (!(precpred(_ctx, 3))) throw new FailedPredicateException(this, "precpred(_ctx, 3)");
						setState(1023);
						match(AND);
						setState(1024);
						predicate(4);
						}
						break;
					case 2:
						{
						_localctx = new OrPredicateContext(new PredicateContext(_parentctx, _parentState));
						pushNewRecursionContext(_localctx, _startState, RULE_predicate);
						setState(1025);
						if (!(precpred(_ctx, 2))) throw new FailedPredicateException(this, "precpred(_ctx, 2)");
						setState(1026);
						match(OR);
						setState(1027);
						predicate(3);
						}
						break;
					}
					} 
				}
				setState(1032);
				_errHandler.sync(this);
				_alt = getInterpreter().adaptivePredict(_input,105,_ctx);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			unrollRecursionContexts(_parentctx);
		}
		return _localctx;
	}

	public static class ComparisonOperatorContext extends ParserRuleContext {
		public TerminalNode EQUAL() { return getToken(HqlParser.EQUAL, 0); }
		public TerminalNode NOT_EQUAL() { return getToken(HqlParser.NOT_EQUAL, 0); }
		public TerminalNode GREATER() { return getToken(HqlParser.GREATER, 0); }
		public TerminalNode GREATER_EQUAL() { return getToken(HqlParser.GREATER_EQUAL, 0); }
		public TerminalNode LESS() { return getToken(HqlParser.LESS, 0); }
		public TerminalNode LESS_EQUAL() { return getToken(HqlParser.LESS_EQUAL, 0); }
		public TerminalNode IS() { return getToken(HqlParser.IS, 0); }
		public TerminalNode DISTINCT() { return getToken(HqlParser.DISTINCT, 0); }
		public TerminalNode FROM() { return getToken(HqlParser.FROM, 0); }
		public TerminalNode NOT() { return getToken(HqlParser.NOT, 0); }
		public ComparisonOperatorContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_comparisonOperator; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterComparisonOperator(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitComparisonOperator(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitComparisonOperator(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ComparisonOperatorContext comparisonOperator() throws RecognitionException {
		ComparisonOperatorContext _localctx = new ComparisonOperatorContext(_ctx, getState());
		enterRule(_localctx, 148, RULE_comparisonOperator);
		try {
			setState(1046);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,106,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1033);
				match(EQUAL);
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1034);
				match(NOT_EQUAL);
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(1035);
				match(GREATER);
				}
				break;
			case 4:
				enterOuterAlt(_localctx, 4);
				{
				setState(1036);
				match(GREATER_EQUAL);
				}
				break;
			case 5:
				enterOuterAlt(_localctx, 5);
				{
				setState(1037);
				match(LESS);
				}
				break;
			case 6:
				enterOuterAlt(_localctx, 6);
				{
				setState(1038);
				match(LESS_EQUAL);
				}
				break;
			case 7:
				enterOuterAlt(_localctx, 7);
				{
				setState(1039);
				match(IS);
				setState(1040);
				match(DISTINCT);
				setState(1041);
				match(FROM);
				}
				break;
			case 8:
				enterOuterAlt(_localctx, 8);
				{
				setState(1042);
				match(IS);
				setState(1043);
				match(NOT);
				setState(1044);
				match(DISTINCT);
				setState(1045);
				match(FROM);
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class InListContext extends ParserRuleContext {
		public InListContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_inList; }
	 
		public InListContext() { }
		public void copyFrom(InListContext ctx) {
			super.copyFrom(ctx);
		}
	}
	public static class SubqueryInListContext extends InListContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public SubqueryContext subquery() {
			return getRuleContext(SubqueryContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public SubqueryInListContext(InListContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSubqueryInList(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSubqueryInList(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSubqueryInList(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class PersistentCollectionReferenceInListContext extends InListContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public SimplePathContext simplePath() {
			return getRuleContext(SimplePathContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode ELEMENTS() { return getToken(HqlParser.ELEMENTS, 0); }
		public TerminalNode INDICES() { return getToken(HqlParser.INDICES, 0); }
		public PersistentCollectionReferenceInListContext(InListContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterPersistentCollectionReferenceInList(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitPersistentCollectionReferenceInList(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitPersistentCollectionReferenceInList(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class ParamInListContext extends InListContext {
		public ParameterContext parameter() {
			return getRuleContext(ParameterContext.class,0);
		}
		public ParamInListContext(InListContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterParamInList(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitParamInList(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitParamInList(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class ExplicitTupleInListContext extends InListContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public List<ExpressionOrPredicateContext> expressionOrPredicate() {
			return getRuleContexts(ExpressionOrPredicateContext.class);
		}
		public ExpressionOrPredicateContext expressionOrPredicate(int i) {
			return getRuleContext(ExpressionOrPredicateContext.class,i);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public ExplicitTupleInListContext(InListContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterExplicitTupleInList(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitExplicitTupleInList(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitExplicitTupleInList(this);
			else return visitor.visitChildren(this);
		}
	}

	public final InListContext inList() throws RecognitionException {
		InListContext _localctx = new InListContext(_ctx, getState());
		enterRule(_localctx, 150, RULE_inList);
		int _la;
		try {
			setState(1070);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,109,_ctx) ) {
			case 1:
				_localctx = new PersistentCollectionReferenceInListContext(_localctx);
				enterOuterAlt(_localctx, 1);
				{
				setState(1048);
				_la = _input.LA(1);
				if ( !(_la==ELEMENTS || _la==INDICES) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}
				setState(1049);
				match(LEFT_PAREN);
				setState(1050);
				simplePath();
				setState(1051);
				match(RIGHT_PAREN);
				}
				break;
			case 2:
				_localctx = new ExplicitTupleInListContext(_localctx);
				enterOuterAlt(_localctx, 2);
				{
				setState(1053);
				match(LEFT_PAREN);
				setState(1062);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if ((((_la) & ~0x3f) == 0 && ((1L << _la) & ((1L << INTEGER_LITERAL) | (1L << LONG_LITERAL) | (1L << FLOAT_LITERAL) | (1L << DOUBLE_LITERAL) | (1L << BIG_INTEGER_LITERAL) | (1L << BIG_DECIMAL_LITERAL) | (1L << HEX_LITERAL) | (1L << STRING_LITERAL) | (1L << JAVA_STRING_LITERAL) | (1L << BINARY_LITERAL) | (1L << TIMESTAMP_ESCAPE_START) | (1L << DATE_ESCAPE_START) | (1L << TIME_ESCAPE_START) | (1L << LEFT_PAREN) | (1L << LEFT_BRACE) | (1L << PLUS) | (1L << MINUS) | (1L << COLON) | (1L << QUESTION_MARK) | (1L << ID) | (1L << VERSION) | (1L << VERSIONED) | (1L << NATURALID) | (1L << FK) | (1L << ALL) | (1L << AND) | (1L << ANY) | (1L << AS) | (1L << ASC) | (1L << AVG) | (1L << BETWEEN) | (1L << BOTH) | (1L << BREADTH) | (1L << BY) | (1L << CASE) | (1L << CAST) | (1L << COLLATE) | (1L << COUNT) | (1L << CROSS) | (1L << CUBE) | (1L << CURRENT))) != 0) || ((((_la - 64)) & ~0x3f) == 0 && ((1L << (_la - 64)) & ((1L << (CURRENT_DATE - 64)) | (1L << (CURRENT_INSTANT - 64)) | (1L << (CURRENT_TIME - 64)) | (1L << (CURRENT_TIMESTAMP - 64)) | (1L << (CYCLE - 64)) | (1L << (DATE - 64)) | (1L << (DATETIME - 64)) | (1L << (DAY - 64)) | (1L << (DEFAULT - 64)) | (1L << (DELETE - 64)) | (1L << (DEPTH - 64)) | (1L << (DESC - 64)) | (1L << (DISTINCT - 64)) | (1L << (ELEMENT - 64)) | (1L << (ELEMENTS - 64)) | (1L << (ELSE - 64)) | (1L << (EMPTY - 64)) | (1L << (END - 64)) | (1L << (ENTRY - 64)) | (1L << (EPOCH - 64)) | (1L << (ERROR - 64)) | (1L << (ESCAPE - 64)) | (1L << (EVERY - 64)) | (1L << (EXCEPT - 64)) | (1L << (EXCLUDE - 64)) | (1L << (EXISTS - 64)) | (1L << (EXTRACT - 64)) | (1L << (FETCH - 64)) | (1L << (FILTER - 64)) | (1L << (FIRST - 64)) | (1L << (FOLLOWING - 64)) | (1L << (FOR - 64)) | (1L << (FORMAT - 64)) | (1L << (FROM - 64)) | (1L << (FULL - 64)) | (1L << (FUNCTION - 64)) | (1L << (GROUP - 64)) | (1L << (GROUPS - 64)) | (1L << (HAVING - 64)) | (1L << (HOUR - 64)) | (1L << (IGNORE - 64)) | (1L << (ILIKE - 64)) | (1L << (IN - 64)) | (1L << (INDEX - 64)) | (1L << (INDICES - 64)) | (1L << (INNER - 64)) | (1L << (INSERT - 64)) | (1L << (INSTANT - 64)) | (1L << (INTERSECT - 64)) | (1L << (INTO - 64)) | (1L << (IS - 64)) | (1L << (JOIN - 64)) | (1L << (KEY - 64)) | (1L << (LAST - 64)) | (1L << (LEADING - 64)) | (1L << (LEFT - 64)) | (1L << (LIKE - 64)) | (1L << (LIMIT - 64)) | (1L << (LIST - 64)) | (1L << (LISTAGG - 64)) | (1L << (LOCAL - 64)) | (1L << (LOCAL_DATE - 64)) | (1L << (LOCAL_DATETIME - 64)))) != 0) || ((((_la - 128)) & ~0x3f) == 0 && ((1L << (_la - 128)) & ((1L << (LOCAL_TIME - 128)) | (1L << (MAP - 128)) | (1L << (MATERIALIZED - 128)) | (1L << (MAX - 128)) | (1L << (MAXELEMENT - 128)) | (1L << (MAXINDEX - 128)) | (1L << (MEMBER - 128)) | (1L << (MICROSECOND - 128)) | (1L << (MILLISECOND - 128)) | (1L << (MIN - 128)) | (1L << (MINELEMENT - 128)) | (1L << (MININDEX - 128)) | (1L << (MINUTE - 128)) | (1L << (MONTH - 128)) | (1L << (NANOSECOND - 128)) | (1L << (NEW - 128)) | (1L << (NEXT - 128)) | (1L << (NO - 128)) | (1L << (NOT - 128)) | (1L << (NULLS - 128)) | (1L << (OBJECT - 128)) | (1L << (OF - 128)) | (1L << (OFFSET - 128)) | (1L << (OFFSET_DATETIME - 128)) | (1L << (ON - 128)) | (1L << (ONLY - 128)) | (1L << (OR - 128)) | (1L << (ORDER - 128)) | (1L << (OTHERS - 128)) | (1L << (OUTER - 128)) | (1L << (OVER - 128)) | (1L << (OVERFLOW - 128)) | (1L << (OVERLAY - 128)) | (1L << (PAD - 128)) | (1L << (PARTITION - 128)) | (1L << (PERCENT - 128)) | (1L << (PLACING - 128)) | (1L << (POSITION - 128)) | (1L << (PRECEDING - 128)) | (1L << (QUARTER - 128)) | (1L << (RANGE - 128)) | (1L << (RESPECT - 128)) | (1L << (RIGHT - 128)) | (1L << (ROLLUP - 128)) | (1L << (ROW - 128)) | (1L << (ROWS - 128)) | (1L << (SEARCH - 128)) | (1L << (SECOND - 128)) | (1L << (SELECT - 128)) | (1L << (SET - 128)) | (1L << (SIZE - 128)) | (1L << (SOME - 128)) | (1L << (SUBSTRING - 128)) | (1L << (SUM - 128)) | (1L << (THEN - 128)) | (1L << (TIES - 128)) | (1L << (TIME - 128)) | (1L << (TIMESTAMP - 128)) | (1L << (TIMEZONE_HOUR - 128)) | (1L << (TIMEZONE_MINUTE - 128)) | (1L << (TO - 128)) | (1L << (TRAILING - 128)) | (1L << (TREAT - 128)) | (1L << (TRIM - 128)))) != 0) || ((((_la - 192)) & ~0x3f) == 0 && ((1L << (_la - 192)) & ((1L << (TRUNC - 192)) | (1L << (TRUNCATE - 192)) | (1L << (TYPE - 192)) | (1L << (UNBOUNDED - 192)) | (1L << (UNION - 192)) | (1L << (UPDATE - 192)) | (1L << (USING - 192)) | (1L << (VALUE - 192)) | (1L << (VALUES - 192)) | (1L << (WEEK - 192)) | (1L << (WHEN - 192)) | (1L << (WHERE - 192)) | (1L << (WITH - 192)) | (1L << (WITHIN - 192)) | (1L << (WITHOUT - 192)) | (1L << (YEAR - 192)) | (1L << (ZONED - 192)) | (1L << (TRUE - 192)) | (1L << (FALSE - 192)) | (1L << (NULL - 192)) | (1L << (IDENTIFIER - 192)) | (1L << (QUOTED_IDENTIFIER - 192)))) != 0)) {
					{
					setState(1054);
					expressionOrPredicate();
					setState(1059);
					_errHandler.sync(this);
					_la = _input.LA(1);
					while (_la==COMMA) {
						{
						{
						setState(1055);
						match(COMMA);
						setState(1056);
						expressionOrPredicate();
						}
						}
						setState(1061);
						_errHandler.sync(this);
						_la = _input.LA(1);
					}
					}
				}

				setState(1064);
				match(RIGHT_PAREN);
				}
				break;
			case 3:
				_localctx = new SubqueryInListContext(_localctx);
				enterOuterAlt(_localctx, 3);
				{
				setState(1065);
				match(LEFT_PAREN);
				setState(1066);
				subquery();
				setState(1067);
				match(RIGHT_PAREN);
				}
				break;
			case 4:
				_localctx = new ParamInListContext(_localctx);
				enterOuterAlt(_localctx, 4);
				{
				setState(1069);
				parameter();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class LikeEscapeContext extends ParserRuleContext {
		public TerminalNode ESCAPE() { return getToken(HqlParser.ESCAPE, 0); }
		public TerminalNode STRING_LITERAL() { return getToken(HqlParser.STRING_LITERAL, 0); }
		public TerminalNode JAVA_STRING_LITERAL() { return getToken(HqlParser.JAVA_STRING_LITERAL, 0); }
		public ParameterContext parameter() {
			return getRuleContext(ParameterContext.class,0);
		}
		public LikeEscapeContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_likeEscape; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterLikeEscape(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitLikeEscape(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitLikeEscape(this);
			else return visitor.visitChildren(this);
		}
	}

	public final LikeEscapeContext likeEscape() throws RecognitionException {
		LikeEscapeContext _localctx = new LikeEscapeContext(_ctx, getState());
		enterRule(_localctx, 152, RULE_likeEscape);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1072);
			match(ESCAPE);
			setState(1076);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case STRING_LITERAL:
				{
				setState(1073);
				match(STRING_LITERAL);
				}
				break;
			case JAVA_STRING_LITERAL:
				{
				setState(1074);
				match(JAVA_STRING_LITERAL);
				}
				break;
			case COLON:
			case QUESTION_MARK:
				{
				setState(1075);
				parameter();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class ExpressionContext extends ParserRuleContext {
		public ExpressionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_expression; }
	 
		public ExpressionContext() { }
		public void copyFrom(ExpressionContext ctx) {
			super.copyFrom(ctx);
		}
	}
	public static class AdditionExpressionContext extends ExpressionContext {
		public List<ExpressionContext> expression() {
			return getRuleContexts(ExpressionContext.class);
		}
		public ExpressionContext expression(int i) {
			return getRuleContext(ExpressionContext.class,i);
		}
		public AdditiveOperatorContext additiveOperator() {
			return getRuleContext(AdditiveOperatorContext.class,0);
		}
		public AdditionExpressionContext(ExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterAdditionExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitAdditionExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitAdditionExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class FromDurationExpressionContext extends ExpressionContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode BY() { return getToken(HqlParser.BY, 0); }
		public DatetimeFieldContext datetimeField() {
			return getRuleContext(DatetimeFieldContext.class,0);
		}
		public FromDurationExpressionContext(ExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterFromDurationExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitFromDurationExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitFromDurationExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class BarePrimaryExpressionContext extends ExpressionContext {
		public PrimaryExpressionContext primaryExpression() {
			return getRuleContext(PrimaryExpressionContext.class,0);
		}
		public BarePrimaryExpressionContext(ExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterBarePrimaryExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitBarePrimaryExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitBarePrimaryExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class TupleExpressionContext extends ExpressionContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public List<ExpressionOrPredicateContext> expressionOrPredicate() {
			return getRuleContexts(ExpressionOrPredicateContext.class);
		}
		public ExpressionOrPredicateContext expressionOrPredicate(int i) {
			return getRuleContext(ExpressionOrPredicateContext.class,i);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public TupleExpressionContext(ExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterTupleExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitTupleExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitTupleExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class UnaryExpressionContext extends ExpressionContext {
		public SignOperatorContext signOperator() {
			return getRuleContext(SignOperatorContext.class,0);
		}
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public UnaryExpressionContext(ExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterUnaryExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitUnaryExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitUnaryExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class GroupedExpressionContext extends ExpressionContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public GroupedExpressionContext(ExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterGroupedExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitGroupedExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitGroupedExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class ConcatenationExpressionContext extends ExpressionContext {
		public List<ExpressionContext> expression() {
			return getRuleContexts(ExpressionContext.class);
		}
		public ExpressionContext expression(int i) {
			return getRuleContext(ExpressionContext.class,i);
		}
		public TerminalNode DOUBLE_PIPE() { return getToken(HqlParser.DOUBLE_PIPE, 0); }
		public ConcatenationExpressionContext(ExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterConcatenationExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitConcatenationExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitConcatenationExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class MultiplicationExpressionContext extends ExpressionContext {
		public List<ExpressionContext> expression() {
			return getRuleContexts(ExpressionContext.class);
		}
		public ExpressionContext expression(int i) {
			return getRuleContext(ExpressionContext.class,i);
		}
		public MultiplicativeOperatorContext multiplicativeOperator() {
			return getRuleContext(MultiplicativeOperatorContext.class,0);
		}
		public MultiplicationExpressionContext(ExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterMultiplicationExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitMultiplicationExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitMultiplicationExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class ToDurationExpressionContext extends ExpressionContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public DatetimeFieldContext datetimeField() {
			return getRuleContext(DatetimeFieldContext.class,0);
		}
		public ToDurationExpressionContext(ExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterToDurationExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitToDurationExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitToDurationExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class SubqueryExpressionContext extends ExpressionContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public SubqueryContext subquery() {
			return getRuleContext(SubqueryContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public SubqueryExpressionContext(ExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSubqueryExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSubqueryExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSubqueryExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class UnaryNumericLiteralExpressionContext extends ExpressionContext {
		public SignOperatorContext signOperator() {
			return getRuleContext(SignOperatorContext.class,0);
		}
		public NumericLiteralContext numericLiteral() {
			return getRuleContext(NumericLiteralContext.class,0);
		}
		public UnaryNumericLiteralExpressionContext(ExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterUnaryNumericLiteralExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitUnaryNumericLiteralExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitUnaryNumericLiteralExpression(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ExpressionContext expression() throws RecognitionException {
		return expression(0);
	}

	private ExpressionContext expression(int _p) throws RecognitionException {
		ParserRuleContext _parentctx = _ctx;
		int _parentState = getState();
		ExpressionContext _localctx = new ExpressionContext(_ctx, _parentState);
		ExpressionContext _prevctx = _localctx;
		int _startState = 154;
		enterRecursionRule(_localctx, 154, RULE_expression, _p);
		int _la;
		try {
			int _alt;
			enterOuterAlt(_localctx, 1);
			{
			setState(1104);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,112,_ctx) ) {
			case 1:
				{
				_localctx = new GroupedExpressionContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;

				setState(1079);
				match(LEFT_PAREN);
				setState(1080);
				expression(0);
				setState(1081);
				match(RIGHT_PAREN);
				}
				break;
			case 2:
				{
				_localctx = new TupleExpressionContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(1083);
				match(LEFT_PAREN);
				setState(1084);
				expressionOrPredicate();
				setState(1087); 
				_errHandler.sync(this);
				_la = _input.LA(1);
				do {
					{
					{
					setState(1085);
					match(COMMA);
					setState(1086);
					expressionOrPredicate();
					}
					}
					setState(1089); 
					_errHandler.sync(this);
					_la = _input.LA(1);
				} while ( _la==COMMA );
				setState(1091);
				match(RIGHT_PAREN);
				}
				break;
			case 3:
				{
				_localctx = new SubqueryExpressionContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(1093);
				match(LEFT_PAREN);
				setState(1094);
				subquery();
				setState(1095);
				match(RIGHT_PAREN);
				}
				break;
			case 4:
				{
				_localctx = new BarePrimaryExpressionContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(1097);
				primaryExpression();
				}
				break;
			case 5:
				{
				_localctx = new UnaryNumericLiteralExpressionContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(1098);
				signOperator();
				setState(1099);
				numericLiteral();
				}
				break;
			case 6:
				{
				_localctx = new UnaryExpressionContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(1101);
				signOperator();
				setState(1102);
				expression(6);
				}
				break;
			}
			_ctx.stop = _input.LT(-1);
			setState(1124);
			_errHandler.sync(this);
			_alt = getInterpreter().adaptivePredict(_input,114,_ctx);
			while ( _alt!=2 && _alt!=org.antlr.v4.runtime.atn.ATN.INVALID_ALT_NUMBER ) {
				if ( _alt==1 ) {
					if ( _parseListeners!=null ) triggerExitRuleEvent();
					_prevctx = _localctx;
					{
					setState(1122);
					_errHandler.sync(this);
					switch ( getInterpreter().adaptivePredict(_input,113,_ctx) ) {
					case 1:
						{
						_localctx = new MultiplicationExpressionContext(new ExpressionContext(_parentctx, _parentState));
						pushNewRecursionContext(_localctx, _startState, RULE_expression);
						setState(1106);
						if (!(precpred(_ctx, 3))) throw new FailedPredicateException(this, "precpred(_ctx, 3)");
						setState(1107);
						multiplicativeOperator();
						setState(1108);
						expression(4);
						}
						break;
					case 2:
						{
						_localctx = new AdditionExpressionContext(new ExpressionContext(_parentctx, _parentState));
						pushNewRecursionContext(_localctx, _startState, RULE_expression);
						setState(1110);
						if (!(precpred(_ctx, 2))) throw new FailedPredicateException(this, "precpred(_ctx, 2)");
						setState(1111);
						additiveOperator();
						setState(1112);
						expression(3);
						}
						break;
					case 3:
						{
						_localctx = new ConcatenationExpressionContext(new ExpressionContext(_parentctx, _parentState));
						pushNewRecursionContext(_localctx, _startState, RULE_expression);
						setState(1114);
						if (!(precpred(_ctx, 1))) throw new FailedPredicateException(this, "precpred(_ctx, 1)");
						setState(1115);
						match(DOUBLE_PIPE);
						setState(1116);
						expression(2);
						}
						break;
					case 4:
						{
						_localctx = new ToDurationExpressionContext(new ExpressionContext(_parentctx, _parentState));
						pushNewRecursionContext(_localctx, _startState, RULE_expression);
						setState(1117);
						if (!(precpred(_ctx, 5))) throw new FailedPredicateException(this, "precpred(_ctx, 5)");
						setState(1118);
						datetimeField();
						}
						break;
					case 5:
						{
						_localctx = new FromDurationExpressionContext(new ExpressionContext(_parentctx, _parentState));
						pushNewRecursionContext(_localctx, _startState, RULE_expression);
						setState(1119);
						if (!(precpred(_ctx, 4))) throw new FailedPredicateException(this, "precpred(_ctx, 4)");
						setState(1120);
						match(BY);
						setState(1121);
						datetimeField();
						}
						break;
					}
					} 
				}
				setState(1126);
				_errHandler.sync(this);
				_alt = getInterpreter().adaptivePredict(_input,114,_ctx);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			unrollRecursionContexts(_parentctx);
		}
		return _localctx;
	}

	public static class PrimaryExpressionContext extends ParserRuleContext {
		public PrimaryExpressionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_primaryExpression; }
	 
		public PrimaryExpressionContext() { }
		public void copyFrom(PrimaryExpressionContext ctx) {
			super.copyFrom(ctx);
		}
	}
	public static class FunctionExpressionContext extends PrimaryExpressionContext {
		public FunctionContext function() {
			return getRuleContext(FunctionContext.class,0);
		}
		public FunctionExpressionContext(PrimaryExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterFunctionExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitFunctionExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitFunctionExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class LiteralExpressionContext extends PrimaryExpressionContext {
		public LiteralContext literal() {
			return getRuleContext(LiteralContext.class,0);
		}
		public LiteralExpressionContext(PrimaryExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterLiteralExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitLiteralExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitLiteralExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class ParameterExpressionContext extends PrimaryExpressionContext {
		public ParameterContext parameter() {
			return getRuleContext(ParameterContext.class,0);
		}
		public ParameterExpressionContext(PrimaryExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterParameterExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitParameterExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitParameterExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class EntityTypeExpressionContext extends PrimaryExpressionContext {
		public EntityTypeReferenceContext entityTypeReference() {
			return getRuleContext(EntityTypeReferenceContext.class,0);
		}
		public EntityTypeExpressionContext(PrimaryExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterEntityTypeExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitEntityTypeExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitEntityTypeExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class EntityIdExpressionContext extends PrimaryExpressionContext {
		public EntityIdReferenceContext entityIdReference() {
			return getRuleContext(EntityIdReferenceContext.class,0);
		}
		public EntityIdExpressionContext(PrimaryExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterEntityIdExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitEntityIdExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitEntityIdExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class EntityVersionExpressionContext extends PrimaryExpressionContext {
		public EntityVersionReferenceContext entityVersionReference() {
			return getRuleContext(EntityVersionReferenceContext.class,0);
		}
		public EntityVersionExpressionContext(PrimaryExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterEntityVersionExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitEntityVersionExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitEntityVersionExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class GeneralPathExpressionContext extends PrimaryExpressionContext {
		public GeneralPathFragmentContext generalPathFragment() {
			return getRuleContext(GeneralPathFragmentContext.class,0);
		}
		public GeneralPathExpressionContext(PrimaryExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterGeneralPathExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitGeneralPathExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitGeneralPathExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class EntityNaturalIdExpressionContext extends PrimaryExpressionContext {
		public EntityNaturalIdReferenceContext entityNaturalIdReference() {
			return getRuleContext(EntityNaturalIdReferenceContext.class,0);
		}
		public EntityNaturalIdExpressionContext(PrimaryExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterEntityNaturalIdExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitEntityNaturalIdExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitEntityNaturalIdExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class CaseExpressionContext extends PrimaryExpressionContext {
		public CaseListContext caseList() {
			return getRuleContext(CaseListContext.class,0);
		}
		public CaseExpressionContext(PrimaryExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCaseExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCaseExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCaseExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class ToOneFkExpressionContext extends PrimaryExpressionContext {
		public ToOneFkReferenceContext toOneFkReference() {
			return getRuleContext(ToOneFkReferenceContext.class,0);
		}
		public ToOneFkExpressionContext(PrimaryExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterToOneFkExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitToOneFkExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitToOneFkExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class SyntacticPathExpressionContext extends PrimaryExpressionContext {
		public SyntacticDomainPathContext syntacticDomainPath() {
			return getRuleContext(SyntacticDomainPathContext.class,0);
		}
		public PathContinuationContext pathContinuation() {
			return getRuleContext(PathContinuationContext.class,0);
		}
		public SyntacticPathExpressionContext(PrimaryExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSyntacticPathExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSyntacticPathExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSyntacticPathExpression(this);
			else return visitor.visitChildren(this);
		}
	}

	public final PrimaryExpressionContext primaryExpression() throws RecognitionException {
		PrimaryExpressionContext _localctx = new PrimaryExpressionContext(_ctx, getState());
		enterRule(_localctx, 156, RULE_primaryExpression);
		try {
			setState(1141);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,116,_ctx) ) {
			case 1:
				_localctx = new CaseExpressionContext(_localctx);
				enterOuterAlt(_localctx, 1);
				{
				setState(1127);
				caseList();
				}
				break;
			case 2:
				_localctx = new LiteralExpressionContext(_localctx);
				enterOuterAlt(_localctx, 2);
				{
				setState(1128);
				literal();
				}
				break;
			case 3:
				_localctx = new ParameterExpressionContext(_localctx);
				enterOuterAlt(_localctx, 3);
				{
				setState(1129);
				parameter();
				}
				break;
			case 4:
				_localctx = new EntityTypeExpressionContext(_localctx);
				enterOuterAlt(_localctx, 4);
				{
				setState(1130);
				entityTypeReference();
				}
				break;
			case 5:
				_localctx = new EntityIdExpressionContext(_localctx);
				enterOuterAlt(_localctx, 5);
				{
				setState(1131);
				entityIdReference();
				}
				break;
			case 6:
				_localctx = new EntityVersionExpressionContext(_localctx);
				enterOuterAlt(_localctx, 6);
				{
				setState(1132);
				entityVersionReference();
				}
				break;
			case 7:
				_localctx = new EntityNaturalIdExpressionContext(_localctx);
				enterOuterAlt(_localctx, 7);
				{
				setState(1133);
				entityNaturalIdReference();
				}
				break;
			case 8:
				_localctx = new ToOneFkExpressionContext(_localctx);
				enterOuterAlt(_localctx, 8);
				{
				setState(1134);
				toOneFkReference();
				}
				break;
			case 9:
				_localctx = new SyntacticPathExpressionContext(_localctx);
				enterOuterAlt(_localctx, 9);
				{
				setState(1135);
				syntacticDomainPath();
				setState(1137);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,115,_ctx) ) {
				case 1:
					{
					setState(1136);
					pathContinuation();
					}
					break;
				}
				}
				break;
			case 10:
				_localctx = new FunctionExpressionContext(_localctx);
				enterOuterAlt(_localctx, 10);
				{
				setState(1139);
				function();
				}
				break;
			case 11:
				_localctx = new GeneralPathExpressionContext(_localctx);
				enterOuterAlt(_localctx, 11);
				{
				setState(1140);
				generalPathFragment();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class ExpressionOrPredicateContext extends ParserRuleContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public PredicateContext predicate() {
			return getRuleContext(PredicateContext.class,0);
		}
		public ExpressionOrPredicateContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_expressionOrPredicate; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterExpressionOrPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitExpressionOrPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitExpressionOrPredicate(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ExpressionOrPredicateContext expressionOrPredicate() throws RecognitionException {
		ExpressionOrPredicateContext _localctx = new ExpressionOrPredicateContext(_ctx, getState());
		enterRule(_localctx, 158, RULE_expressionOrPredicate);
		try {
			setState(1145);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,117,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1143);
				expression(0);
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1144);
				predicate(0);
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class MultiplicativeOperatorContext extends ParserRuleContext {
		public TerminalNode SLASH() { return getToken(HqlParser.SLASH, 0); }
		public TerminalNode PERCENT_OP() { return getToken(HqlParser.PERCENT_OP, 0); }
		public TerminalNode ASTERISK() { return getToken(HqlParser.ASTERISK, 0); }
		public MultiplicativeOperatorContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_multiplicativeOperator; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterMultiplicativeOperator(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitMultiplicativeOperator(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitMultiplicativeOperator(this);
			else return visitor.visitChildren(this);
		}
	}

	public final MultiplicativeOperatorContext multiplicativeOperator() throws RecognitionException {
		MultiplicativeOperatorContext _localctx = new MultiplicativeOperatorContext(_ctx, getState());
		enterRule(_localctx, 160, RULE_multiplicativeOperator);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1147);
			_la = _input.LA(1);
			if ( !((((_la) & ~0x3f) == 0 && ((1L << _la) & ((1L << ASTERISK) | (1L << SLASH) | (1L << PERCENT_OP))) != 0)) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class AdditiveOperatorContext extends ParserRuleContext {
		public TerminalNode PLUS() { return getToken(HqlParser.PLUS, 0); }
		public TerminalNode MINUS() { return getToken(HqlParser.MINUS, 0); }
		public AdditiveOperatorContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_additiveOperator; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterAdditiveOperator(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitAdditiveOperator(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitAdditiveOperator(this);
			else return visitor.visitChildren(this);
		}
	}

	public final AdditiveOperatorContext additiveOperator() throws RecognitionException {
		AdditiveOperatorContext _localctx = new AdditiveOperatorContext(_ctx, getState());
		enterRule(_localctx, 162, RULE_additiveOperator);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1149);
			_la = _input.LA(1);
			if ( !(_la==PLUS || _la==MINUS) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SignOperatorContext extends ParserRuleContext {
		public TerminalNode PLUS() { return getToken(HqlParser.PLUS, 0); }
		public TerminalNode MINUS() { return getToken(HqlParser.MINUS, 0); }
		public SignOperatorContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_signOperator; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSignOperator(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSignOperator(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSignOperator(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SignOperatorContext signOperator() throws RecognitionException {
		SignOperatorContext _localctx = new SignOperatorContext(_ctx, getState());
		enterRule(_localctx, 164, RULE_signOperator);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1151);
			_la = _input.LA(1);
			if ( !(_la==PLUS || _la==MINUS) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class EntityTypeReferenceContext extends ParserRuleContext {
		public TerminalNode TYPE() { return getToken(HqlParser.TYPE, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public ParameterContext parameter() {
			return getRuleContext(ParameterContext.class,0);
		}
		public EntityTypeReferenceContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_entityTypeReference; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterEntityTypeReference(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitEntityTypeReference(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitEntityTypeReference(this);
			else return visitor.visitChildren(this);
		}
	}

	public final EntityTypeReferenceContext entityTypeReference() throws RecognitionException {
		EntityTypeReferenceContext _localctx = new EntityTypeReferenceContext(_ctx, getState());
		enterRule(_localctx, 166, RULE_entityTypeReference);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1153);
			match(TYPE);
			setState(1154);
			match(LEFT_PAREN);
			setState(1157);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case ID:
			case VERSION:
			case VERSIONED:
			case NATURALID:
			case ALL:
			case AND:
			case ANY:
			case AS:
			case ASC:
			case AVG:
			case BETWEEN:
			case BOTH:
			case BREADTH:
			case BY:
			case CASE:
			case CAST:
			case COLLATE:
			case COUNT:
			case CROSS:
			case CUBE:
			case CURRENT:
			case CURRENT_DATE:
			case CURRENT_INSTANT:
			case CURRENT_TIME:
			case CURRENT_TIMESTAMP:
			case CYCLE:
			case DATE:
			case DATETIME:
			case DAY:
			case DEFAULT:
			case DELETE:
			case DEPTH:
			case DESC:
			case DISTINCT:
			case ELEMENT:
			case ELEMENTS:
			case ELSE:
			case EMPTY:
			case END:
			case ENTRY:
			case EPOCH:
			case ERROR:
			case ESCAPE:
			case EVERY:
			case EXCEPT:
			case EXCLUDE:
			case EXISTS:
			case EXTRACT:
			case FETCH:
			case FILTER:
			case FIRST:
			case FOLLOWING:
			case FOR:
			case FORMAT:
			case FROM:
			case FULL:
			case FUNCTION:
			case GROUP:
			case GROUPS:
			case HAVING:
			case HOUR:
			case IGNORE:
			case ILIKE:
			case IN:
			case INDEX:
			case INDICES:
			case INNER:
			case INSERT:
			case INSTANT:
			case INTERSECT:
			case INTO:
			case IS:
			case JOIN:
			case KEY:
			case LAST:
			case LEADING:
			case LEFT:
			case LIKE:
			case LIMIT:
			case LIST:
			case LISTAGG:
			case LOCAL:
			case LOCAL_DATE:
			case LOCAL_DATETIME:
			case LOCAL_TIME:
			case MAP:
			case MATERIALIZED:
			case MAX:
			case MAXELEMENT:
			case MAXINDEX:
			case MEMBER:
			case MICROSECOND:
			case MILLISECOND:
			case MIN:
			case MINELEMENT:
			case MININDEX:
			case MINUTE:
			case MONTH:
			case NANOSECOND:
			case NEW:
			case NEXT:
			case NO:
			case NOT:
			case NULLS:
			case OBJECT:
			case OF:
			case OFFSET:
			case OFFSET_DATETIME:
			case ON:
			case ONLY:
			case OR:
			case ORDER:
			case OTHERS:
			case OUTER:
			case OVER:
			case OVERFLOW:
			case OVERLAY:
			case PAD:
			case PARTITION:
			case PERCENT:
			case PLACING:
			case POSITION:
			case PRECEDING:
			case QUARTER:
			case RANGE:
			case RESPECT:
			case RIGHT:
			case ROLLUP:
			case ROW:
			case ROWS:
			case SEARCH:
			case SECOND:
			case SELECT:
			case SET:
			case SIZE:
			case SOME:
			case SUBSTRING:
			case SUM:
			case THEN:
			case TIES:
			case TIME:
			case TIMESTAMP:
			case TIMEZONE_HOUR:
			case TIMEZONE_MINUTE:
			case TO:
			case TRAILING:
			case TREAT:
			case TRIM:
			case TRUNC:
			case TRUNCATE:
			case TYPE:
			case UNBOUNDED:
			case UNION:
			case UPDATE:
			case USING:
			case VALUE:
			case VALUES:
			case WEEK:
			case WHEN:
			case WHERE:
			case WITH:
			case WITHIN:
			case WITHOUT:
			case YEAR:
			case IDENTIFIER:
			case QUOTED_IDENTIFIER:
				{
				setState(1155);
				path();
				}
				break;
			case COLON:
			case QUESTION_MARK:
				{
				setState(1156);
				parameter();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
			setState(1159);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class EntityIdReferenceContext extends ParserRuleContext {
		public TerminalNode ID() { return getToken(HqlParser.ID, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public PathContinuationContext pathContinuation() {
			return getRuleContext(PathContinuationContext.class,0);
		}
		public EntityIdReferenceContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_entityIdReference; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterEntityIdReference(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitEntityIdReference(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitEntityIdReference(this);
			else return visitor.visitChildren(this);
		}
	}

	public final EntityIdReferenceContext entityIdReference() throws RecognitionException {
		EntityIdReferenceContext _localctx = new EntityIdReferenceContext(_ctx, getState());
		enterRule(_localctx, 168, RULE_entityIdReference);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1161);
			match(ID);
			setState(1162);
			match(LEFT_PAREN);
			setState(1163);
			path();
			setState(1164);
			match(RIGHT_PAREN);
			setState(1166);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,119,_ctx) ) {
			case 1:
				{
				setState(1165);
				pathContinuation();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class EntityVersionReferenceContext extends ParserRuleContext {
		public TerminalNode VERSION() { return getToken(HqlParser.VERSION, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public EntityVersionReferenceContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_entityVersionReference; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterEntityVersionReference(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitEntityVersionReference(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitEntityVersionReference(this);
			else return visitor.visitChildren(this);
		}
	}

	public final EntityVersionReferenceContext entityVersionReference() throws RecognitionException {
		EntityVersionReferenceContext _localctx = new EntityVersionReferenceContext(_ctx, getState());
		enterRule(_localctx, 170, RULE_entityVersionReference);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1168);
			match(VERSION);
			setState(1169);
			match(LEFT_PAREN);
			setState(1170);
			path();
			setState(1171);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class EntityNaturalIdReferenceContext extends ParserRuleContext {
		public TerminalNode NATURALID() { return getToken(HqlParser.NATURALID, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public PathContinuationContext pathContinuation() {
			return getRuleContext(PathContinuationContext.class,0);
		}
		public EntityNaturalIdReferenceContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_entityNaturalIdReference; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterEntityNaturalIdReference(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitEntityNaturalIdReference(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitEntityNaturalIdReference(this);
			else return visitor.visitChildren(this);
		}
	}

	public final EntityNaturalIdReferenceContext entityNaturalIdReference() throws RecognitionException {
		EntityNaturalIdReferenceContext _localctx = new EntityNaturalIdReferenceContext(_ctx, getState());
		enterRule(_localctx, 172, RULE_entityNaturalIdReference);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1173);
			match(NATURALID);
			setState(1174);
			match(LEFT_PAREN);
			setState(1175);
			path();
			setState(1176);
			match(RIGHT_PAREN);
			setState(1178);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,120,_ctx) ) {
			case 1:
				{
				setState(1177);
				pathContinuation();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class ToOneFkReferenceContext extends ParserRuleContext {
		public TerminalNode FK() { return getToken(HqlParser.FK, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public ToOneFkReferenceContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_toOneFkReference; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterToOneFkReference(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitToOneFkReference(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitToOneFkReference(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ToOneFkReferenceContext toOneFkReference() throws RecognitionException {
		ToOneFkReferenceContext _localctx = new ToOneFkReferenceContext(_ctx, getState());
		enterRule(_localctx, 174, RULE_toOneFkReference);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1180);
			match(FK);
			setState(1181);
			match(LEFT_PAREN);
			setState(1182);
			path();
			setState(1183);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class CaseListContext extends ParserRuleContext {
		public SimpleCaseListContext simpleCaseList() {
			return getRuleContext(SimpleCaseListContext.class,0);
		}
		public SearchedCaseListContext searchedCaseList() {
			return getRuleContext(SearchedCaseListContext.class,0);
		}
		public CaseListContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_caseList; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCaseList(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCaseList(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCaseList(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CaseListContext caseList() throws RecognitionException {
		CaseListContext _localctx = new CaseListContext(_ctx, getState());
		enterRule(_localctx, 176, RULE_caseList);
		try {
			setState(1187);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,121,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1185);
				simpleCaseList();
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1186);
				searchedCaseList();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SimpleCaseListContext extends ParserRuleContext {
		public TerminalNode CASE() { return getToken(HqlParser.CASE, 0); }
		public ExpressionOrPredicateContext expressionOrPredicate() {
			return getRuleContext(ExpressionOrPredicateContext.class,0);
		}
		public TerminalNode END() { return getToken(HqlParser.END, 0); }
		public List<SimpleCaseWhenContext> simpleCaseWhen() {
			return getRuleContexts(SimpleCaseWhenContext.class);
		}
		public SimpleCaseWhenContext simpleCaseWhen(int i) {
			return getRuleContext(SimpleCaseWhenContext.class,i);
		}
		public CaseOtherwiseContext caseOtherwise() {
			return getRuleContext(CaseOtherwiseContext.class,0);
		}
		public SimpleCaseListContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_simpleCaseList; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSimpleCaseList(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSimpleCaseList(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSimpleCaseList(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SimpleCaseListContext simpleCaseList() throws RecognitionException {
		SimpleCaseListContext _localctx = new SimpleCaseListContext(_ctx, getState());
		enterRule(_localctx, 178, RULE_simpleCaseList);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1189);
			match(CASE);
			setState(1190);
			expressionOrPredicate();
			setState(1192); 
			_errHandler.sync(this);
			_la = _input.LA(1);
			do {
				{
				{
				setState(1191);
				simpleCaseWhen();
				}
				}
				setState(1194); 
				_errHandler.sync(this);
				_la = _input.LA(1);
			} while ( _la==WHEN );
			setState(1197);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==ELSE) {
				{
				setState(1196);
				caseOtherwise();
				}
			}

			setState(1199);
			match(END);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SimpleCaseWhenContext extends ParserRuleContext {
		public TerminalNode WHEN() { return getToken(HqlParser.WHEN, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode THEN() { return getToken(HqlParser.THEN, 0); }
		public ExpressionOrPredicateContext expressionOrPredicate() {
			return getRuleContext(ExpressionOrPredicateContext.class,0);
		}
		public SimpleCaseWhenContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_simpleCaseWhen; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSimpleCaseWhen(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSimpleCaseWhen(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSimpleCaseWhen(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SimpleCaseWhenContext simpleCaseWhen() throws RecognitionException {
		SimpleCaseWhenContext _localctx = new SimpleCaseWhenContext(_ctx, getState());
		enterRule(_localctx, 180, RULE_simpleCaseWhen);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1201);
			match(WHEN);
			setState(1202);
			expression(0);
			setState(1203);
			match(THEN);
			setState(1204);
			expressionOrPredicate();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class CaseOtherwiseContext extends ParserRuleContext {
		public TerminalNode ELSE() { return getToken(HqlParser.ELSE, 0); }
		public ExpressionOrPredicateContext expressionOrPredicate() {
			return getRuleContext(ExpressionOrPredicateContext.class,0);
		}
		public CaseOtherwiseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_caseOtherwise; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCaseOtherwise(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCaseOtherwise(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCaseOtherwise(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CaseOtherwiseContext caseOtherwise() throws RecognitionException {
		CaseOtherwiseContext _localctx = new CaseOtherwiseContext(_ctx, getState());
		enterRule(_localctx, 182, RULE_caseOtherwise);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1206);
			match(ELSE);
			setState(1207);
			expressionOrPredicate();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SearchedCaseListContext extends ParserRuleContext {
		public TerminalNode CASE() { return getToken(HqlParser.CASE, 0); }
		public TerminalNode END() { return getToken(HqlParser.END, 0); }
		public List<SearchedCaseWhenContext> searchedCaseWhen() {
			return getRuleContexts(SearchedCaseWhenContext.class);
		}
		public SearchedCaseWhenContext searchedCaseWhen(int i) {
			return getRuleContext(SearchedCaseWhenContext.class,i);
		}
		public CaseOtherwiseContext caseOtherwise() {
			return getRuleContext(CaseOtherwiseContext.class,0);
		}
		public SearchedCaseListContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_searchedCaseList; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSearchedCaseList(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSearchedCaseList(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSearchedCaseList(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SearchedCaseListContext searchedCaseList() throws RecognitionException {
		SearchedCaseListContext _localctx = new SearchedCaseListContext(_ctx, getState());
		enterRule(_localctx, 184, RULE_searchedCaseList);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1209);
			match(CASE);
			setState(1211); 
			_errHandler.sync(this);
			_la = _input.LA(1);
			do {
				{
				{
				setState(1210);
				searchedCaseWhen();
				}
				}
				setState(1213); 
				_errHandler.sync(this);
				_la = _input.LA(1);
			} while ( _la==WHEN );
			setState(1216);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==ELSE) {
				{
				setState(1215);
				caseOtherwise();
				}
			}

			setState(1218);
			match(END);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SearchedCaseWhenContext extends ParserRuleContext {
		public TerminalNode WHEN() { return getToken(HqlParser.WHEN, 0); }
		public PredicateContext predicate() {
			return getRuleContext(PredicateContext.class,0);
		}
		public TerminalNode THEN() { return getToken(HqlParser.THEN, 0); }
		public ExpressionOrPredicateContext expressionOrPredicate() {
			return getRuleContext(ExpressionOrPredicateContext.class,0);
		}
		public SearchedCaseWhenContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_searchedCaseWhen; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSearchedCaseWhen(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSearchedCaseWhen(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSearchedCaseWhen(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SearchedCaseWhenContext searchedCaseWhen() throws RecognitionException {
		SearchedCaseWhenContext _localctx = new SearchedCaseWhenContext(_ctx, getState());
		enterRule(_localctx, 186, RULE_searchedCaseWhen);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1220);
			match(WHEN);
			setState(1221);
			predicate(0);
			setState(1222);
			match(THEN);
			setState(1223);
			expressionOrPredicate();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class LiteralContext extends ParserRuleContext {
		public TerminalNode STRING_LITERAL() { return getToken(HqlParser.STRING_LITERAL, 0); }
		public TerminalNode JAVA_STRING_LITERAL() { return getToken(HqlParser.JAVA_STRING_LITERAL, 0); }
		public TerminalNode NULL() { return getToken(HqlParser.NULL, 0); }
		public BooleanLiteralContext booleanLiteral() {
			return getRuleContext(BooleanLiteralContext.class,0);
		}
		public NumericLiteralContext numericLiteral() {
			return getRuleContext(NumericLiteralContext.class,0);
		}
		public BinaryLiteralContext binaryLiteral() {
			return getRuleContext(BinaryLiteralContext.class,0);
		}
		public TemporalLiteralContext temporalLiteral() {
			return getRuleContext(TemporalLiteralContext.class,0);
		}
		public GeneralizedLiteralContext generalizedLiteral() {
			return getRuleContext(GeneralizedLiteralContext.class,0);
		}
		public LiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_literal; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final LiteralContext literal() throws RecognitionException {
		LiteralContext _localctx = new LiteralContext(_ctx, getState());
		enterRule(_localctx, 188, RULE_literal);
		try {
			setState(1233);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,126,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1225);
				match(STRING_LITERAL);
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1226);
				match(JAVA_STRING_LITERAL);
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(1227);
				match(NULL);
				}
				break;
			case 4:
				enterOuterAlt(_localctx, 4);
				{
				setState(1228);
				booleanLiteral();
				}
				break;
			case 5:
				enterOuterAlt(_localctx, 5);
				{
				setState(1229);
				numericLiteral();
				}
				break;
			case 6:
				enterOuterAlt(_localctx, 6);
				{
				setState(1230);
				binaryLiteral();
				}
				break;
			case 7:
				enterOuterAlt(_localctx, 7);
				{
				setState(1231);
				temporalLiteral();
				}
				break;
			case 8:
				enterOuterAlt(_localctx, 8);
				{
				setState(1232);
				generalizedLiteral();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class BooleanLiteralContext extends ParserRuleContext {
		public TerminalNode TRUE() { return getToken(HqlParser.TRUE, 0); }
		public TerminalNode FALSE() { return getToken(HqlParser.FALSE, 0); }
		public BooleanLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_booleanLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterBooleanLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitBooleanLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitBooleanLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final BooleanLiteralContext booleanLiteral() throws RecognitionException {
		BooleanLiteralContext _localctx = new BooleanLiteralContext(_ctx, getState());
		enterRule(_localctx, 190, RULE_booleanLiteral);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1235);
			_la = _input.LA(1);
			if ( !(_la==TRUE || _la==FALSE) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class NumericLiteralContext extends ParserRuleContext {
		public TerminalNode INTEGER_LITERAL() { return getToken(HqlParser.INTEGER_LITERAL, 0); }
		public TerminalNode LONG_LITERAL() { return getToken(HqlParser.LONG_LITERAL, 0); }
		public TerminalNode BIG_INTEGER_LITERAL() { return getToken(HqlParser.BIG_INTEGER_LITERAL, 0); }
		public TerminalNode FLOAT_LITERAL() { return getToken(HqlParser.FLOAT_LITERAL, 0); }
		public TerminalNode DOUBLE_LITERAL() { return getToken(HqlParser.DOUBLE_LITERAL, 0); }
		public TerminalNode BIG_DECIMAL_LITERAL() { return getToken(HqlParser.BIG_DECIMAL_LITERAL, 0); }
		public TerminalNode HEX_LITERAL() { return getToken(HqlParser.HEX_LITERAL, 0); }
		public NumericLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_numericLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterNumericLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitNumericLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitNumericLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final NumericLiteralContext numericLiteral() throws RecognitionException {
		NumericLiteralContext _localctx = new NumericLiteralContext(_ctx, getState());
		enterRule(_localctx, 192, RULE_numericLiteral);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1237);
			_la = _input.LA(1);
			if ( !((((_la) & ~0x3f) == 0 && ((1L << _la) & ((1L << INTEGER_LITERAL) | (1L << LONG_LITERAL) | (1L << FLOAT_LITERAL) | (1L << DOUBLE_LITERAL) | (1L << BIG_INTEGER_LITERAL) | (1L << BIG_DECIMAL_LITERAL) | (1L << HEX_LITERAL))) != 0)) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class BinaryLiteralContext extends ParserRuleContext {
		public TerminalNode BINARY_LITERAL() { return getToken(HqlParser.BINARY_LITERAL, 0); }
		public TerminalNode LEFT_BRACE() { return getToken(HqlParser.LEFT_BRACE, 0); }
		public List<TerminalNode> HEX_LITERAL() { return getTokens(HqlParser.HEX_LITERAL); }
		public TerminalNode HEX_LITERAL(int i) {
			return getToken(HqlParser.HEX_LITERAL, i);
		}
		public TerminalNode RIGHT_BRACE() { return getToken(HqlParser.RIGHT_BRACE, 0); }
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public BinaryLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_binaryLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterBinaryLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitBinaryLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitBinaryLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final BinaryLiteralContext binaryLiteral() throws RecognitionException {
		BinaryLiteralContext _localctx = new BinaryLiteralContext(_ctx, getState());
		enterRule(_localctx, 194, RULE_binaryLiteral);
		int _la;
		try {
			setState(1250);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case BINARY_LITERAL:
				enterOuterAlt(_localctx, 1);
				{
				setState(1239);
				match(BINARY_LITERAL);
				}
				break;
			case LEFT_BRACE:
				enterOuterAlt(_localctx, 2);
				{
				setState(1240);
				match(LEFT_BRACE);
				setState(1241);
				match(HEX_LITERAL);
				setState(1246);
				_errHandler.sync(this);
				_la = _input.LA(1);
				while (_la==COMMA) {
					{
					{
					setState(1242);
					match(COMMA);
					setState(1243);
					match(HEX_LITERAL);
					}
					}
					setState(1248);
					_errHandler.sync(this);
					_la = _input.LA(1);
				}
				setState(1249);
				match(RIGHT_BRACE);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class TemporalLiteralContext extends ParserRuleContext {
		public DateTimeLiteralContext dateTimeLiteral() {
			return getRuleContext(DateTimeLiteralContext.class,0);
		}
		public DateLiteralContext dateLiteral() {
			return getRuleContext(DateLiteralContext.class,0);
		}
		public TimeLiteralContext timeLiteral() {
			return getRuleContext(TimeLiteralContext.class,0);
		}
		public JdbcTimestampLiteralContext jdbcTimestampLiteral() {
			return getRuleContext(JdbcTimestampLiteralContext.class,0);
		}
		public JdbcDateLiteralContext jdbcDateLiteral() {
			return getRuleContext(JdbcDateLiteralContext.class,0);
		}
		public JdbcTimeLiteralContext jdbcTimeLiteral() {
			return getRuleContext(JdbcTimeLiteralContext.class,0);
		}
		public TemporalLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_temporalLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterTemporalLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitTemporalLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitTemporalLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final TemporalLiteralContext temporalLiteral() throws RecognitionException {
		TemporalLiteralContext _localctx = new TemporalLiteralContext(_ctx, getState());
		enterRule(_localctx, 196, RULE_temporalLiteral);
		try {
			setState(1258);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,129,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1252);
				dateTimeLiteral();
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1253);
				dateLiteral();
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(1254);
				timeLiteral();
				}
				break;
			case 4:
				enterOuterAlt(_localctx, 4);
				{
				setState(1255);
				jdbcTimestampLiteral();
				}
				break;
			case 5:
				enterOuterAlt(_localctx, 5);
				{
				setState(1256);
				jdbcDateLiteral();
				}
				break;
			case 6:
				enterOuterAlt(_localctx, 6);
				{
				setState(1257);
				jdbcTimeLiteral();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class DateTimeLiteralContext extends ParserRuleContext {
		public LocalDateTimeLiteralContext localDateTimeLiteral() {
			return getRuleContext(LocalDateTimeLiteralContext.class,0);
		}
		public ZonedDateTimeLiteralContext zonedDateTimeLiteral() {
			return getRuleContext(ZonedDateTimeLiteralContext.class,0);
		}
		public OffsetDateTimeLiteralContext offsetDateTimeLiteral() {
			return getRuleContext(OffsetDateTimeLiteralContext.class,0);
		}
		public DateTimeLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_dateTimeLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterDateTimeLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitDateTimeLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitDateTimeLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final DateTimeLiteralContext dateTimeLiteral() throws RecognitionException {
		DateTimeLiteralContext _localctx = new DateTimeLiteralContext(_ctx, getState());
		enterRule(_localctx, 198, RULE_dateTimeLiteral);
		try {
			setState(1263);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,130,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1260);
				localDateTimeLiteral();
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1261);
				zonedDateTimeLiteral();
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(1262);
				offsetDateTimeLiteral();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class LocalDateTimeLiteralContext extends ParserRuleContext {
		public TerminalNode LEFT_BRACE() { return getToken(HqlParser.LEFT_BRACE, 0); }
		public LocalDateTimeContext localDateTime() {
			return getRuleContext(LocalDateTimeContext.class,0);
		}
		public TerminalNode RIGHT_BRACE() { return getToken(HqlParser.RIGHT_BRACE, 0); }
		public TerminalNode DATETIME() { return getToken(HqlParser.DATETIME, 0); }
		public TerminalNode LOCAL() { return getToken(HqlParser.LOCAL, 0); }
		public LocalDateTimeLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_localDateTimeLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterLocalDateTimeLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitLocalDateTimeLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitLocalDateTimeLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final LocalDateTimeLiteralContext localDateTimeLiteral() throws RecognitionException {
		LocalDateTimeLiteralContext _localctx = new LocalDateTimeLiteralContext(_ctx, getState());
		enterRule(_localctx, 200, RULE_localDateTimeLiteral);
		int _la;
		try {
			setState(1274);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case LEFT_BRACE:
				enterOuterAlt(_localctx, 1);
				{
				setState(1265);
				match(LEFT_BRACE);
				setState(1266);
				localDateTime();
				setState(1267);
				match(RIGHT_BRACE);
				}
				break;
			case DATETIME:
			case LOCAL:
				enterOuterAlt(_localctx, 2);
				{
				setState(1270);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==LOCAL) {
					{
					setState(1269);
					match(LOCAL);
					}
				}

				setState(1272);
				match(DATETIME);
				setState(1273);
				localDateTime();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class ZonedDateTimeLiteralContext extends ParserRuleContext {
		public TerminalNode LEFT_BRACE() { return getToken(HqlParser.LEFT_BRACE, 0); }
		public ZonedDateTimeContext zonedDateTime() {
			return getRuleContext(ZonedDateTimeContext.class,0);
		}
		public TerminalNode RIGHT_BRACE() { return getToken(HqlParser.RIGHT_BRACE, 0); }
		public TerminalNode DATETIME() { return getToken(HqlParser.DATETIME, 0); }
		public TerminalNode ZONED() { return getToken(HqlParser.ZONED, 0); }
		public ZonedDateTimeLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_zonedDateTimeLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterZonedDateTimeLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitZonedDateTimeLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitZonedDateTimeLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ZonedDateTimeLiteralContext zonedDateTimeLiteral() throws RecognitionException {
		ZonedDateTimeLiteralContext _localctx = new ZonedDateTimeLiteralContext(_ctx, getState());
		enterRule(_localctx, 202, RULE_zonedDateTimeLiteral);
		int _la;
		try {
			setState(1285);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case LEFT_BRACE:
				enterOuterAlt(_localctx, 1);
				{
				setState(1276);
				match(LEFT_BRACE);
				setState(1277);
				zonedDateTime();
				setState(1278);
				match(RIGHT_BRACE);
				}
				break;
			case DATETIME:
			case ZONED:
				enterOuterAlt(_localctx, 2);
				{
				setState(1281);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==ZONED) {
					{
					setState(1280);
					match(ZONED);
					}
				}

				setState(1283);
				match(DATETIME);
				setState(1284);
				zonedDateTime();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class OffsetDateTimeLiteralContext extends ParserRuleContext {
		public TerminalNode LEFT_BRACE() { return getToken(HqlParser.LEFT_BRACE, 0); }
		public OffsetDateTimeContext offsetDateTime() {
			return getRuleContext(OffsetDateTimeContext.class,0);
		}
		public TerminalNode RIGHT_BRACE() { return getToken(HqlParser.RIGHT_BRACE, 0); }
		public TerminalNode DATETIME() { return getToken(HqlParser.DATETIME, 0); }
		public OffsetDateTimeWithMinutesContext offsetDateTimeWithMinutes() {
			return getRuleContext(OffsetDateTimeWithMinutesContext.class,0);
		}
		public TerminalNode OFFSET() { return getToken(HqlParser.OFFSET, 0); }
		public OffsetDateTimeLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_offsetDateTimeLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOffsetDateTimeLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOffsetDateTimeLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOffsetDateTimeLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OffsetDateTimeLiteralContext offsetDateTimeLiteral() throws RecognitionException {
		OffsetDateTimeLiteralContext _localctx = new OffsetDateTimeLiteralContext(_ctx, getState());
		enterRule(_localctx, 204, RULE_offsetDateTimeLiteral);
		int _la;
		try {
			setState(1296);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case LEFT_BRACE:
				enterOuterAlt(_localctx, 1);
				{
				setState(1287);
				match(LEFT_BRACE);
				setState(1288);
				offsetDateTime();
				setState(1289);
				match(RIGHT_BRACE);
				}
				break;
			case DATETIME:
			case OFFSET:
				enterOuterAlt(_localctx, 2);
				{
				setState(1292);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==OFFSET) {
					{
					setState(1291);
					match(OFFSET);
					}
				}

				setState(1294);
				match(DATETIME);
				setState(1295);
				offsetDateTimeWithMinutes();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class DateLiteralContext extends ParserRuleContext {
		public TerminalNode LEFT_BRACE() { return getToken(HqlParser.LEFT_BRACE, 0); }
		public DateContext date() {
			return getRuleContext(DateContext.class,0);
		}
		public TerminalNode RIGHT_BRACE() { return getToken(HqlParser.RIGHT_BRACE, 0); }
		public TerminalNode DATE() { return getToken(HqlParser.DATE, 0); }
		public TerminalNode LOCAL() { return getToken(HqlParser.LOCAL, 0); }
		public DateLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_dateLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterDateLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitDateLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitDateLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final DateLiteralContext dateLiteral() throws RecognitionException {
		DateLiteralContext _localctx = new DateLiteralContext(_ctx, getState());
		enterRule(_localctx, 206, RULE_dateLiteral);
		int _la;
		try {
			setState(1307);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case LEFT_BRACE:
				enterOuterAlt(_localctx, 1);
				{
				setState(1298);
				match(LEFT_BRACE);
				setState(1299);
				date();
				setState(1300);
				match(RIGHT_BRACE);
				}
				break;
			case DATE:
			case LOCAL:
				enterOuterAlt(_localctx, 2);
				{
				setState(1303);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==LOCAL) {
					{
					setState(1302);
					match(LOCAL);
					}
				}

				setState(1305);
				match(DATE);
				setState(1306);
				date();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class TimeLiteralContext extends ParserRuleContext {
		public TerminalNode LEFT_BRACE() { return getToken(HqlParser.LEFT_BRACE, 0); }
		public TimeContext time() {
			return getRuleContext(TimeContext.class,0);
		}
		public TerminalNode RIGHT_BRACE() { return getToken(HqlParser.RIGHT_BRACE, 0); }
		public TerminalNode TIME() { return getToken(HqlParser.TIME, 0); }
		public TerminalNode LOCAL() { return getToken(HqlParser.LOCAL, 0); }
		public TimeLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_timeLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterTimeLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitTimeLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitTimeLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final TimeLiteralContext timeLiteral() throws RecognitionException {
		TimeLiteralContext _localctx = new TimeLiteralContext(_ctx, getState());
		enterRule(_localctx, 208, RULE_timeLiteral);
		int _la;
		try {
			setState(1318);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case LEFT_BRACE:
				enterOuterAlt(_localctx, 1);
				{
				setState(1309);
				match(LEFT_BRACE);
				setState(1310);
				time();
				setState(1311);
				match(RIGHT_BRACE);
				}
				break;
			case LOCAL:
			case TIME:
				enterOuterAlt(_localctx, 2);
				{
				setState(1314);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==LOCAL) {
					{
					setState(1313);
					match(LOCAL);
					}
				}

				setState(1316);
				match(TIME);
				setState(1317);
				time();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class DateTimeContext extends ParserRuleContext {
		public LocalDateTimeContext localDateTime() {
			return getRuleContext(LocalDateTimeContext.class,0);
		}
		public ZonedDateTimeContext zonedDateTime() {
			return getRuleContext(ZonedDateTimeContext.class,0);
		}
		public OffsetDateTimeContext offsetDateTime() {
			return getRuleContext(OffsetDateTimeContext.class,0);
		}
		public DateTimeContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_dateTime; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterDateTime(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitDateTime(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitDateTime(this);
			else return visitor.visitChildren(this);
		}
	}

	public final DateTimeContext dateTime() throws RecognitionException {
		DateTimeContext _localctx = new DateTimeContext(_ctx, getState());
		enterRule(_localctx, 210, RULE_dateTime);
		try {
			setState(1323);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,141,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1320);
				localDateTime();
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1321);
				zonedDateTime();
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(1322);
				offsetDateTime();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class LocalDateTimeContext extends ParserRuleContext {
		public DateContext date() {
			return getRuleContext(DateContext.class,0);
		}
		public TimeContext time() {
			return getRuleContext(TimeContext.class,0);
		}
		public LocalDateTimeContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_localDateTime; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterLocalDateTime(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitLocalDateTime(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitLocalDateTime(this);
			else return visitor.visitChildren(this);
		}
	}

	public final LocalDateTimeContext localDateTime() throws RecognitionException {
		LocalDateTimeContext _localctx = new LocalDateTimeContext(_ctx, getState());
		enterRule(_localctx, 212, RULE_localDateTime);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1325);
			date();
			setState(1326);
			time();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class ZonedDateTimeContext extends ParserRuleContext {
		public DateContext date() {
			return getRuleContext(DateContext.class,0);
		}
		public TimeContext time() {
			return getRuleContext(TimeContext.class,0);
		}
		public ZoneIdContext zoneId() {
			return getRuleContext(ZoneIdContext.class,0);
		}
		public ZonedDateTimeContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_zonedDateTime; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterZonedDateTime(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitZonedDateTime(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitZonedDateTime(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ZonedDateTimeContext zonedDateTime() throws RecognitionException {
		ZonedDateTimeContext _localctx = new ZonedDateTimeContext(_ctx, getState());
		enterRule(_localctx, 214, RULE_zonedDateTime);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1328);
			date();
			setState(1329);
			time();
			setState(1330);
			zoneId();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class OffsetDateTimeContext extends ParserRuleContext {
		public DateContext date() {
			return getRuleContext(DateContext.class,0);
		}
		public TimeContext time() {
			return getRuleContext(TimeContext.class,0);
		}
		public OffsetContext offset() {
			return getRuleContext(OffsetContext.class,0);
		}
		public OffsetDateTimeContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_offsetDateTime; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOffsetDateTime(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOffsetDateTime(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOffsetDateTime(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OffsetDateTimeContext offsetDateTime() throws RecognitionException {
		OffsetDateTimeContext _localctx = new OffsetDateTimeContext(_ctx, getState());
		enterRule(_localctx, 216, RULE_offsetDateTime);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1332);
			date();
			setState(1333);
			time();
			setState(1334);
			offset();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class OffsetDateTimeWithMinutesContext extends ParserRuleContext {
		public DateContext date() {
			return getRuleContext(DateContext.class,0);
		}
		public TimeContext time() {
			return getRuleContext(TimeContext.class,0);
		}
		public OffsetWithMinutesContext offsetWithMinutes() {
			return getRuleContext(OffsetWithMinutesContext.class,0);
		}
		public OffsetDateTimeWithMinutesContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_offsetDateTimeWithMinutes; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOffsetDateTimeWithMinutes(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOffsetDateTimeWithMinutes(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOffsetDateTimeWithMinutes(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OffsetDateTimeWithMinutesContext offsetDateTimeWithMinutes() throws RecognitionException {
		OffsetDateTimeWithMinutesContext _localctx = new OffsetDateTimeWithMinutesContext(_ctx, getState());
		enterRule(_localctx, 218, RULE_offsetDateTimeWithMinutes);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1336);
			date();
			setState(1337);
			time();
			setState(1338);
			offsetWithMinutes();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class DateContext extends ParserRuleContext {
		public YearContext year() {
			return getRuleContext(YearContext.class,0);
		}
		public List<TerminalNode> MINUS() { return getTokens(HqlParser.MINUS); }
		public TerminalNode MINUS(int i) {
			return getToken(HqlParser.MINUS, i);
		}
		public MonthContext month() {
			return getRuleContext(MonthContext.class,0);
		}
		public DayContext day() {
			return getRuleContext(DayContext.class,0);
		}
		public DateContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_date; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterDate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitDate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitDate(this);
			else return visitor.visitChildren(this);
		}
	}

	public final DateContext date() throws RecognitionException {
		DateContext _localctx = new DateContext(_ctx, getState());
		enterRule(_localctx, 220, RULE_date);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1340);
			year();
			setState(1341);
			match(MINUS);
			setState(1342);
			month();
			setState(1343);
			match(MINUS);
			setState(1344);
			day();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class TimeContext extends ParserRuleContext {
		public HourContext hour() {
			return getRuleContext(HourContext.class,0);
		}
		public List<TerminalNode> COLON() { return getTokens(HqlParser.COLON); }
		public TerminalNode COLON(int i) {
			return getToken(HqlParser.COLON, i);
		}
		public MinuteContext minute() {
			return getRuleContext(MinuteContext.class,0);
		}
		public SecondContext second() {
			return getRuleContext(SecondContext.class,0);
		}
		public TimeContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_time; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterTime(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitTime(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitTime(this);
			else return visitor.visitChildren(this);
		}
	}

	public final TimeContext time() throws RecognitionException {
		TimeContext _localctx = new TimeContext(_ctx, getState());
		enterRule(_localctx, 222, RULE_time);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1346);
			hour();
			setState(1347);
			match(COLON);
			setState(1348);
			minute();
			setState(1351);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,142,_ctx) ) {
			case 1:
				{
				setState(1349);
				match(COLON);
				setState(1350);
				second();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class OffsetContext extends ParserRuleContext {
		public HourContext hour() {
			return getRuleContext(HourContext.class,0);
		}
		public TerminalNode PLUS() { return getToken(HqlParser.PLUS, 0); }
		public TerminalNode MINUS() { return getToken(HqlParser.MINUS, 0); }
		public TerminalNode COLON() { return getToken(HqlParser.COLON, 0); }
		public MinuteContext minute() {
			return getRuleContext(MinuteContext.class,0);
		}
		public OffsetContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_offset; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOffset(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOffset(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOffset(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OffsetContext offset() throws RecognitionException {
		OffsetContext _localctx = new OffsetContext(_ctx, getState());
		enterRule(_localctx, 224, RULE_offset);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1353);
			_la = _input.LA(1);
			if ( !(_la==PLUS || _la==MINUS) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			setState(1354);
			hour();
			setState(1357);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==COLON) {
				{
				setState(1355);
				match(COLON);
				setState(1356);
				minute();
				}
			}

			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class OffsetWithMinutesContext extends ParserRuleContext {
		public HourContext hour() {
			return getRuleContext(HourContext.class,0);
		}
		public TerminalNode COLON() { return getToken(HqlParser.COLON, 0); }
		public MinuteContext minute() {
			return getRuleContext(MinuteContext.class,0);
		}
		public TerminalNode PLUS() { return getToken(HqlParser.PLUS, 0); }
		public TerminalNode MINUS() { return getToken(HqlParser.MINUS, 0); }
		public OffsetWithMinutesContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_offsetWithMinutes; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOffsetWithMinutes(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOffsetWithMinutes(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOffsetWithMinutes(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OffsetWithMinutesContext offsetWithMinutes() throws RecognitionException {
		OffsetWithMinutesContext _localctx = new OffsetWithMinutesContext(_ctx, getState());
		enterRule(_localctx, 226, RULE_offsetWithMinutes);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1359);
			_la = _input.LA(1);
			if ( !(_la==PLUS || _la==MINUS) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			setState(1360);
			hour();
			setState(1361);
			match(COLON);
			setState(1362);
			minute();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class YearContext extends ParserRuleContext {
		public TerminalNode INTEGER_LITERAL() { return getToken(HqlParser.INTEGER_LITERAL, 0); }
		public YearContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_year; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterYear(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitYear(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitYear(this);
			else return visitor.visitChildren(this);
		}
	}

	public final YearContext year() throws RecognitionException {
		YearContext _localctx = new YearContext(_ctx, getState());
		enterRule(_localctx, 228, RULE_year);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1364);
			match(INTEGER_LITERAL);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class MonthContext extends ParserRuleContext {
		public TerminalNode INTEGER_LITERAL() { return getToken(HqlParser.INTEGER_LITERAL, 0); }
		public MonthContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_month; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterMonth(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitMonth(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitMonth(this);
			else return visitor.visitChildren(this);
		}
	}

	public final MonthContext month() throws RecognitionException {
		MonthContext _localctx = new MonthContext(_ctx, getState());
		enterRule(_localctx, 230, RULE_month);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1366);
			match(INTEGER_LITERAL);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class DayContext extends ParserRuleContext {
		public TerminalNode INTEGER_LITERAL() { return getToken(HqlParser.INTEGER_LITERAL, 0); }
		public DayContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_day; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterDay(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitDay(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitDay(this);
			else return visitor.visitChildren(this);
		}
	}

	public final DayContext day() throws RecognitionException {
		DayContext _localctx = new DayContext(_ctx, getState());
		enterRule(_localctx, 232, RULE_day);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1368);
			match(INTEGER_LITERAL);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class HourContext extends ParserRuleContext {
		public TerminalNode INTEGER_LITERAL() { return getToken(HqlParser.INTEGER_LITERAL, 0); }
		public HourContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_hour; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterHour(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitHour(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitHour(this);
			else return visitor.visitChildren(this);
		}
	}

	public final HourContext hour() throws RecognitionException {
		HourContext _localctx = new HourContext(_ctx, getState());
		enterRule(_localctx, 234, RULE_hour);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1370);
			match(INTEGER_LITERAL);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class MinuteContext extends ParserRuleContext {
		public TerminalNode INTEGER_LITERAL() { return getToken(HqlParser.INTEGER_LITERAL, 0); }
		public MinuteContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_minute; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterMinute(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitMinute(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitMinute(this);
			else return visitor.visitChildren(this);
		}
	}

	public final MinuteContext minute() throws RecognitionException {
		MinuteContext _localctx = new MinuteContext(_ctx, getState());
		enterRule(_localctx, 236, RULE_minute);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1372);
			match(INTEGER_LITERAL);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SecondContext extends ParserRuleContext {
		public TerminalNode INTEGER_LITERAL() { return getToken(HqlParser.INTEGER_LITERAL, 0); }
		public TerminalNode FLOAT_LITERAL() { return getToken(HqlParser.FLOAT_LITERAL, 0); }
		public SecondContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_second; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSecond(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSecond(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSecond(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SecondContext second() throws RecognitionException {
		SecondContext _localctx = new SecondContext(_ctx, getState());
		enterRule(_localctx, 238, RULE_second);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1374);
			_la = _input.LA(1);
			if ( !(_la==INTEGER_LITERAL || _la==FLOAT_LITERAL) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class ZoneIdContext extends ParserRuleContext {
		public List<TerminalNode> IDENTIFIER() { return getTokens(HqlParser.IDENTIFIER); }
		public TerminalNode IDENTIFIER(int i) {
			return getToken(HqlParser.IDENTIFIER, i);
		}
		public TerminalNode SLASH() { return getToken(HqlParser.SLASH, 0); }
		public TerminalNode STRING_LITERAL() { return getToken(HqlParser.STRING_LITERAL, 0); }
		public ZoneIdContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_zoneId; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterZoneId(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitZoneId(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitZoneId(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ZoneIdContext zoneId() throws RecognitionException {
		ZoneIdContext _localctx = new ZoneIdContext(_ctx, getState());
		enterRule(_localctx, 240, RULE_zoneId);
		try {
			setState(1382);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case IDENTIFIER:
				enterOuterAlt(_localctx, 1);
				{
				setState(1376);
				match(IDENTIFIER);
				setState(1379);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,144,_ctx) ) {
				case 1:
					{
					setState(1377);
					match(SLASH);
					setState(1378);
					match(IDENTIFIER);
					}
					break;
				}
				}
				break;
			case STRING_LITERAL:
				enterOuterAlt(_localctx, 2);
				{
				setState(1381);
				match(STRING_LITERAL);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class JdbcTimestampLiteralContext extends ParserRuleContext {
		public TerminalNode TIMESTAMP_ESCAPE_START() { return getToken(HqlParser.TIMESTAMP_ESCAPE_START, 0); }
		public TerminalNode RIGHT_BRACE() { return getToken(HqlParser.RIGHT_BRACE, 0); }
		public DateTimeContext dateTime() {
			return getRuleContext(DateTimeContext.class,0);
		}
		public GenericTemporalLiteralTextContext genericTemporalLiteralText() {
			return getRuleContext(GenericTemporalLiteralTextContext.class,0);
		}
		public JdbcTimestampLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_jdbcTimestampLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterJdbcTimestampLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitJdbcTimestampLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitJdbcTimestampLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final JdbcTimestampLiteralContext jdbcTimestampLiteral() throws RecognitionException {
		JdbcTimestampLiteralContext _localctx = new JdbcTimestampLiteralContext(_ctx, getState());
		enterRule(_localctx, 242, RULE_jdbcTimestampLiteral);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1384);
			match(TIMESTAMP_ESCAPE_START);
			setState(1387);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case INTEGER_LITERAL:
				{
				setState(1385);
				dateTime();
				}
				break;
			case STRING_LITERAL:
				{
				setState(1386);
				genericTemporalLiteralText();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
			setState(1389);
			match(RIGHT_BRACE);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class JdbcDateLiteralContext extends ParserRuleContext {
		public TerminalNode DATE_ESCAPE_START() { return getToken(HqlParser.DATE_ESCAPE_START, 0); }
		public TerminalNode RIGHT_BRACE() { return getToken(HqlParser.RIGHT_BRACE, 0); }
		public DateContext date() {
			return getRuleContext(DateContext.class,0);
		}
		public GenericTemporalLiteralTextContext genericTemporalLiteralText() {
			return getRuleContext(GenericTemporalLiteralTextContext.class,0);
		}
		public JdbcDateLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_jdbcDateLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterJdbcDateLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitJdbcDateLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitJdbcDateLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final JdbcDateLiteralContext jdbcDateLiteral() throws RecognitionException {
		JdbcDateLiteralContext _localctx = new JdbcDateLiteralContext(_ctx, getState());
		enterRule(_localctx, 244, RULE_jdbcDateLiteral);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1391);
			match(DATE_ESCAPE_START);
			setState(1394);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case INTEGER_LITERAL:
				{
				setState(1392);
				date();
				}
				break;
			case STRING_LITERAL:
				{
				setState(1393);
				genericTemporalLiteralText();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
			setState(1396);
			match(RIGHT_BRACE);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class JdbcTimeLiteralContext extends ParserRuleContext {
		public TerminalNode TIME_ESCAPE_START() { return getToken(HqlParser.TIME_ESCAPE_START, 0); }
		public TerminalNode RIGHT_BRACE() { return getToken(HqlParser.RIGHT_BRACE, 0); }
		public TimeContext time() {
			return getRuleContext(TimeContext.class,0);
		}
		public GenericTemporalLiteralTextContext genericTemporalLiteralText() {
			return getRuleContext(GenericTemporalLiteralTextContext.class,0);
		}
		public JdbcTimeLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_jdbcTimeLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterJdbcTimeLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitJdbcTimeLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitJdbcTimeLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final JdbcTimeLiteralContext jdbcTimeLiteral() throws RecognitionException {
		JdbcTimeLiteralContext _localctx = new JdbcTimeLiteralContext(_ctx, getState());
		enterRule(_localctx, 246, RULE_jdbcTimeLiteral);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1398);
			match(TIME_ESCAPE_START);
			setState(1401);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case INTEGER_LITERAL:
				{
				setState(1399);
				time();
				}
				break;
			case STRING_LITERAL:
				{
				setState(1400);
				genericTemporalLiteralText();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
			setState(1403);
			match(RIGHT_BRACE);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class GenericTemporalLiteralTextContext extends ParserRuleContext {
		public TerminalNode STRING_LITERAL() { return getToken(HqlParser.STRING_LITERAL, 0); }
		public GenericTemporalLiteralTextContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_genericTemporalLiteralText; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterGenericTemporalLiteralText(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitGenericTemporalLiteralText(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitGenericTemporalLiteralText(this);
			else return visitor.visitChildren(this);
		}
	}

	public final GenericTemporalLiteralTextContext genericTemporalLiteralText() throws RecognitionException {
		GenericTemporalLiteralTextContext _localctx = new GenericTemporalLiteralTextContext(_ctx, getState());
		enterRule(_localctx, 248, RULE_genericTemporalLiteralText);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1405);
			match(STRING_LITERAL);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class GeneralizedLiteralContext extends ParserRuleContext {
		public TerminalNode LEFT_BRACE() { return getToken(HqlParser.LEFT_BRACE, 0); }
		public GeneralizedLiteralTypeContext generalizedLiteralType() {
			return getRuleContext(GeneralizedLiteralTypeContext.class,0);
		}
		public TerminalNode COLON() { return getToken(HqlParser.COLON, 0); }
		public GeneralizedLiteralTextContext generalizedLiteralText() {
			return getRuleContext(GeneralizedLiteralTextContext.class,0);
		}
		public TerminalNode RIGHT_BRACE() { return getToken(HqlParser.RIGHT_BRACE, 0); }
		public GeneralizedLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_generalizedLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterGeneralizedLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitGeneralizedLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitGeneralizedLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final GeneralizedLiteralContext generalizedLiteral() throws RecognitionException {
		GeneralizedLiteralContext _localctx = new GeneralizedLiteralContext(_ctx, getState());
		enterRule(_localctx, 250, RULE_generalizedLiteral);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1407);
			match(LEFT_BRACE);
			setState(1408);
			generalizedLiteralType();
			setState(1409);
			match(COLON);
			setState(1410);
			generalizedLiteralText();
			setState(1411);
			match(RIGHT_BRACE);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class GeneralizedLiteralTypeContext extends ParserRuleContext {
		public TerminalNode STRING_LITERAL() { return getToken(HqlParser.STRING_LITERAL, 0); }
		public GeneralizedLiteralTypeContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_generalizedLiteralType; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterGeneralizedLiteralType(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitGeneralizedLiteralType(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitGeneralizedLiteralType(this);
			else return visitor.visitChildren(this);
		}
	}

	public final GeneralizedLiteralTypeContext generalizedLiteralType() throws RecognitionException {
		GeneralizedLiteralTypeContext _localctx = new GeneralizedLiteralTypeContext(_ctx, getState());
		enterRule(_localctx, 252, RULE_generalizedLiteralType);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1413);
			match(STRING_LITERAL);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class GeneralizedLiteralTextContext extends ParserRuleContext {
		public TerminalNode STRING_LITERAL() { return getToken(HqlParser.STRING_LITERAL, 0); }
		public GeneralizedLiteralTextContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_generalizedLiteralText; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterGeneralizedLiteralText(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitGeneralizedLiteralText(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitGeneralizedLiteralText(this);
			else return visitor.visitChildren(this);
		}
	}

	public final GeneralizedLiteralTextContext generalizedLiteralText() throws RecognitionException {
		GeneralizedLiteralTextContext _localctx = new GeneralizedLiteralTextContext(_ctx, getState());
		enterRule(_localctx, 254, RULE_generalizedLiteralText);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1415);
			match(STRING_LITERAL);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class ParameterContext extends ParserRuleContext {
		public ParameterContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_parameter; }
	 
		public ParameterContext() { }
		public void copyFrom(ParameterContext ctx) {
			super.copyFrom(ctx);
		}
	}
	public static class NamedParameterContext extends ParameterContext {
		public TerminalNode COLON() { return getToken(HqlParser.COLON, 0); }
		public IdentifierContext identifier() {
			return getRuleContext(IdentifierContext.class,0);
		}
		public NamedParameterContext(ParameterContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterNamedParameter(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitNamedParameter(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitNamedParameter(this);
			else return visitor.visitChildren(this);
		}
	}
	public static class PositionalParameterContext extends ParameterContext {
		public TerminalNode QUESTION_MARK() { return getToken(HqlParser.QUESTION_MARK, 0); }
		public TerminalNode INTEGER_LITERAL() { return getToken(HqlParser.INTEGER_LITERAL, 0); }
		public PositionalParameterContext(ParameterContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterPositionalParameter(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitPositionalParameter(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitPositionalParameter(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ParameterContext parameter() throws RecognitionException {
		ParameterContext _localctx = new ParameterContext(_ctx, getState());
		enterRule(_localctx, 256, RULE_parameter);
		try {
			setState(1423);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case COLON:
				_localctx = new NamedParameterContext(_localctx);
				enterOuterAlt(_localctx, 1);
				{
				setState(1417);
				match(COLON);
				setState(1418);
				identifier();
				}
				break;
			case QUESTION_MARK:
				_localctx = new PositionalParameterContext(_localctx);
				enterOuterAlt(_localctx, 2);
				{
				setState(1419);
				match(QUESTION_MARK);
				setState(1421);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,149,_ctx) ) {
				case 1:
					{
					setState(1420);
					match(INTEGER_LITERAL);
					}
					break;
				}
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class FunctionContext extends ParserRuleContext {
		public StandardFunctionContext standardFunction() {
			return getRuleContext(StandardFunctionContext.class,0);
		}
		public AggregateFunctionContext aggregateFunction() {
			return getRuleContext(AggregateFunctionContext.class,0);
		}
		public CollectionSizeFunctionContext collectionSizeFunction() {
			return getRuleContext(CollectionSizeFunctionContext.class,0);
		}
		public IndexAggregateFunctionContext indexAggregateFunction() {
			return getRuleContext(IndexAggregateFunctionContext.class,0);
		}
		public ElementAggregateFunctionContext elementAggregateFunction() {
			return getRuleContext(ElementAggregateFunctionContext.class,0);
		}
		public CollectionFunctionMisuseContext collectionFunctionMisuse() {
			return getRuleContext(CollectionFunctionMisuseContext.class,0);
		}
		public JpaNonstandardFunctionContext jpaNonstandardFunction() {
			return getRuleContext(JpaNonstandardFunctionContext.class,0);
		}
		public GenericFunctionContext genericFunction() {
			return getRuleContext(GenericFunctionContext.class,0);
		}
		public FunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_function; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final FunctionContext function() throws RecognitionException {
		FunctionContext _localctx = new FunctionContext(_ctx, getState());
		enterRule(_localctx, 258, RULE_function);
		try {
			setState(1433);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,151,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1425);
				standardFunction();
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1426);
				aggregateFunction();
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(1427);
				collectionSizeFunction();
				}
				break;
			case 4:
				enterOuterAlt(_localctx, 4);
				{
				setState(1428);
				indexAggregateFunction();
				}
				break;
			case 5:
				enterOuterAlt(_localctx, 5);
				{
				setState(1429);
				elementAggregateFunction();
				}
				break;
			case 6:
				enterOuterAlt(_localctx, 6);
				{
				setState(1430);
				collectionFunctionMisuse();
				}
				break;
			case 7:
				enterOuterAlt(_localctx, 7);
				{
				setState(1431);
				jpaNonstandardFunction();
				}
				break;
			case 8:
				enterOuterAlt(_localctx, 8);
				{
				setState(1432);
				genericFunction();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class JpaNonstandardFunctionContext extends ParserRuleContext {
		public TerminalNode FUNCTION() { return getToken(HqlParser.FUNCTION, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public JpaNonstandardFunctionNameContext jpaNonstandardFunctionName() {
			return getRuleContext(JpaNonstandardFunctionNameContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode COMMA() { return getToken(HqlParser.COMMA, 0); }
		public GenericFunctionArgumentsContext genericFunctionArguments() {
			return getRuleContext(GenericFunctionArgumentsContext.class,0);
		}
		public JpaNonstandardFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_jpaNonstandardFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterJpaNonstandardFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitJpaNonstandardFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitJpaNonstandardFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final JpaNonstandardFunctionContext jpaNonstandardFunction() throws RecognitionException {
		JpaNonstandardFunctionContext _localctx = new JpaNonstandardFunctionContext(_ctx, getState());
		enterRule(_localctx, 260, RULE_jpaNonstandardFunction);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1435);
			match(FUNCTION);
			setState(1436);
			match(LEFT_PAREN);
			setState(1437);
			jpaNonstandardFunctionName();
			setState(1440);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==COMMA) {
				{
				setState(1438);
				match(COMMA);
				setState(1439);
				genericFunctionArguments();
				}
			}

			setState(1442);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class JpaNonstandardFunctionNameContext extends ParserRuleContext {
		public TerminalNode STRING_LITERAL() { return getToken(HqlParser.STRING_LITERAL, 0); }
		public JpaNonstandardFunctionNameContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_jpaNonstandardFunctionName; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterJpaNonstandardFunctionName(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitJpaNonstandardFunctionName(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitJpaNonstandardFunctionName(this);
			else return visitor.visitChildren(this);
		}
	}

	public final JpaNonstandardFunctionNameContext jpaNonstandardFunctionName() throws RecognitionException {
		JpaNonstandardFunctionNameContext _localctx = new JpaNonstandardFunctionNameContext(_ctx, getState());
		enterRule(_localctx, 262, RULE_jpaNonstandardFunctionName);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1444);
			match(STRING_LITERAL);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class GenericFunctionContext extends ParserRuleContext {
		public GenericFunctionNameContext genericFunctionName() {
			return getRuleContext(GenericFunctionNameContext.class,0);
		}
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public GenericFunctionArgumentsContext genericFunctionArguments() {
			return getRuleContext(GenericFunctionArgumentsContext.class,0);
		}
		public TerminalNode ASTERISK() { return getToken(HqlParser.ASTERISK, 0); }
		public NthSideClauseContext nthSideClause() {
			return getRuleContext(NthSideClauseContext.class,0);
		}
		public NullsClauseContext nullsClause() {
			return getRuleContext(NullsClauseContext.class,0);
		}
		public WithinGroupClauseContext withinGroupClause() {
			return getRuleContext(WithinGroupClauseContext.class,0);
		}
		public FilterClauseContext filterClause() {
			return getRuleContext(FilterClauseContext.class,0);
		}
		public OverClauseContext overClause() {
			return getRuleContext(OverClauseContext.class,0);
		}
		public GenericFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_genericFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterGenericFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitGenericFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitGenericFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final GenericFunctionContext genericFunction() throws RecognitionException {
		GenericFunctionContext _localctx = new GenericFunctionContext(_ctx, getState());
		enterRule(_localctx, 264, RULE_genericFunction);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1446);
			genericFunctionName();
			setState(1447);
			match(LEFT_PAREN);
			setState(1450);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case INTEGER_LITERAL:
			case LONG_LITERAL:
			case FLOAT_LITERAL:
			case DOUBLE_LITERAL:
			case BIG_INTEGER_LITERAL:
			case BIG_DECIMAL_LITERAL:
			case HEX_LITERAL:
			case STRING_LITERAL:
			case JAVA_STRING_LITERAL:
			case BINARY_LITERAL:
			case TIMESTAMP_ESCAPE_START:
			case DATE_ESCAPE_START:
			case TIME_ESCAPE_START:
			case LEFT_PAREN:
			case LEFT_BRACE:
			case PLUS:
			case MINUS:
			case COLON:
			case QUESTION_MARK:
			case ID:
			case VERSION:
			case VERSIONED:
			case NATURALID:
			case FK:
			case ALL:
			case AND:
			case ANY:
			case AS:
			case ASC:
			case AVG:
			case BETWEEN:
			case BOTH:
			case BREADTH:
			case BY:
			case CASE:
			case CAST:
			case COLLATE:
			case COUNT:
			case CROSS:
			case CUBE:
			case CURRENT:
			case CURRENT_DATE:
			case CURRENT_INSTANT:
			case CURRENT_TIME:
			case CURRENT_TIMESTAMP:
			case CYCLE:
			case DATE:
			case DATETIME:
			case DAY:
			case DEFAULT:
			case DELETE:
			case DEPTH:
			case DESC:
			case DISTINCT:
			case ELEMENT:
			case ELEMENTS:
			case ELSE:
			case EMPTY:
			case END:
			case ENTRY:
			case EPOCH:
			case ERROR:
			case ESCAPE:
			case EVERY:
			case EXCEPT:
			case EXCLUDE:
			case EXISTS:
			case EXTRACT:
			case FETCH:
			case FILTER:
			case FIRST:
			case FOLLOWING:
			case FOR:
			case FORMAT:
			case FROM:
			case FULL:
			case FUNCTION:
			case GROUP:
			case GROUPS:
			case HAVING:
			case HOUR:
			case IGNORE:
			case ILIKE:
			case IN:
			case INDEX:
			case INDICES:
			case INNER:
			case INSERT:
			case INSTANT:
			case INTERSECT:
			case INTO:
			case IS:
			case JOIN:
			case KEY:
			case LAST:
			case LEADING:
			case LEFT:
			case LIKE:
			case LIMIT:
			case LIST:
			case LISTAGG:
			case LOCAL:
			case LOCAL_DATE:
			case LOCAL_DATETIME:
			case LOCAL_TIME:
			case MAP:
			case MATERIALIZED:
			case MAX:
			case MAXELEMENT:
			case MAXINDEX:
			case MEMBER:
			case MICROSECOND:
			case MILLISECOND:
			case MIN:
			case MINELEMENT:
			case MININDEX:
			case MINUTE:
			case MONTH:
			case NANOSECOND:
			case NEW:
			case NEXT:
			case NO:
			case NOT:
			case NULLS:
			case OBJECT:
			case OF:
			case OFFSET:
			case OFFSET_DATETIME:
			case ON:
			case ONLY:
			case OR:
			case ORDER:
			case OTHERS:
			case OUTER:
			case OVER:
			case OVERFLOW:
			case OVERLAY:
			case PAD:
			case PARTITION:
			case PERCENT:
			case PLACING:
			case POSITION:
			case PRECEDING:
			case QUARTER:
			case RANGE:
			case RESPECT:
			case RIGHT:
			case ROLLUP:
			case ROW:
			case ROWS:
			case SEARCH:
			case SECOND:
			case SELECT:
			case SET:
			case SIZE:
			case SOME:
			case SUBSTRING:
			case SUM:
			case THEN:
			case TIES:
			case TIME:
			case TIMESTAMP:
			case TIMEZONE_HOUR:
			case TIMEZONE_MINUTE:
			case TO:
			case TRAILING:
			case TREAT:
			case TRIM:
			case TRUNC:
			case TRUNCATE:
			case TYPE:
			case UNBOUNDED:
			case UNION:
			case UPDATE:
			case USING:
			case VALUE:
			case VALUES:
			case WEEK:
			case WHEN:
			case WHERE:
			case WITH:
			case WITHIN:
			case WITHOUT:
			case YEAR:
			case ZONED:
			case TRUE:
			case FALSE:
			case NULL:
			case IDENTIFIER:
			case QUOTED_IDENTIFIER:
				{
				setState(1448);
				genericFunctionArguments();
				}
				break;
			case ASTERISK:
				{
				setState(1449);
				match(ASTERISK);
				}
				break;
			case RIGHT_PAREN:
				break;
			default:
				break;
			}
			setState(1452);
			match(RIGHT_PAREN);
			setState(1454);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,154,_ctx) ) {
			case 1:
				{
				setState(1453);
				nthSideClause();
				}
				break;
			}
			setState(1457);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,155,_ctx) ) {
			case 1:
				{
				setState(1456);
				nullsClause();
				}
				break;
			}
			setState(1460);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,156,_ctx) ) {
			case 1:
				{
				setState(1459);
				withinGroupClause();
				}
				break;
			}
			setState(1463);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,157,_ctx) ) {
			case 1:
				{
				setState(1462);
				filterClause();
				}
				break;
			}
			setState(1466);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,158,_ctx) ) {
			case 1:
				{
				setState(1465);
				overClause();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class GenericFunctionNameContext extends ParserRuleContext {
		public SimplePathContext simplePath() {
			return getRuleContext(SimplePathContext.class,0);
		}
		public GenericFunctionNameContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_genericFunctionName; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterGenericFunctionName(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitGenericFunctionName(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitGenericFunctionName(this);
			else return visitor.visitChildren(this);
		}
	}

	public final GenericFunctionNameContext genericFunctionName() throws RecognitionException {
		GenericFunctionNameContext _localctx = new GenericFunctionNameContext(_ctx, getState());
		enterRule(_localctx, 266, RULE_genericFunctionName);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1468);
			simplePath();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class GenericFunctionArgumentsContext extends ParserRuleContext {
		public List<ExpressionOrPredicateContext> expressionOrPredicate() {
			return getRuleContexts(ExpressionOrPredicateContext.class);
		}
		public ExpressionOrPredicateContext expressionOrPredicate(int i) {
			return getRuleContext(ExpressionOrPredicateContext.class,i);
		}
		public TerminalNode DISTINCT() { return getToken(HqlParser.DISTINCT, 0); }
		public DatetimeFieldContext datetimeField() {
			return getRuleContext(DatetimeFieldContext.class,0);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public GenericFunctionArgumentsContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_genericFunctionArguments; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterGenericFunctionArguments(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitGenericFunctionArguments(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitGenericFunctionArguments(this);
			else return visitor.visitChildren(this);
		}
	}

	public final GenericFunctionArgumentsContext genericFunctionArguments() throws RecognitionException {
		GenericFunctionArgumentsContext _localctx = new GenericFunctionArgumentsContext(_ctx, getState());
		enterRule(_localctx, 268, RULE_genericFunctionArguments);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1474);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,159,_ctx) ) {
			case 1:
				{
				setState(1470);
				match(DISTINCT);
				}
				break;
			case 2:
				{
				setState(1471);
				datetimeField();
				setState(1472);
				match(COMMA);
				}
				break;
			}
			setState(1476);
			expressionOrPredicate();
			setState(1481);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(1477);
				match(COMMA);
				setState(1478);
				expressionOrPredicate();
				}
				}
				setState(1483);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class CollectionSizeFunctionContext extends ParserRuleContext {
		public TerminalNode SIZE() { return getToken(HqlParser.SIZE, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public CollectionSizeFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_collectionSizeFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCollectionSizeFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCollectionSizeFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCollectionSizeFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CollectionSizeFunctionContext collectionSizeFunction() throws RecognitionException {
		CollectionSizeFunctionContext _localctx = new CollectionSizeFunctionContext(_ctx, getState());
		enterRule(_localctx, 270, RULE_collectionSizeFunction);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1484);
			match(SIZE);
			setState(1485);
			match(LEFT_PAREN);
			setState(1486);
			path();
			setState(1487);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class IndexAggregateFunctionContext extends ParserRuleContext {
		public TerminalNode MAXINDEX() { return getToken(HqlParser.MAXINDEX, 0); }
		public List<TerminalNode> LEFT_PAREN() { return getTokens(HqlParser.LEFT_PAREN); }
		public TerminalNode LEFT_PAREN(int i) {
			return getToken(HqlParser.LEFT_PAREN, i);
		}
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public List<TerminalNode> RIGHT_PAREN() { return getTokens(HqlParser.RIGHT_PAREN); }
		public TerminalNode RIGHT_PAREN(int i) {
			return getToken(HqlParser.RIGHT_PAREN, i);
		}
		public TerminalNode MININDEX() { return getToken(HqlParser.MININDEX, 0); }
		public TerminalNode MAX() { return getToken(HqlParser.MAX, 0); }
		public TerminalNode INDICES() { return getToken(HqlParser.INDICES, 0); }
		public TerminalNode MIN() { return getToken(HqlParser.MIN, 0); }
		public TerminalNode SUM() { return getToken(HqlParser.SUM, 0); }
		public TerminalNode AVG() { return getToken(HqlParser.AVG, 0); }
		public IndexAggregateFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_indexAggregateFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterIndexAggregateFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitIndexAggregateFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitIndexAggregateFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final IndexAggregateFunctionContext indexAggregateFunction() throws RecognitionException {
		IndexAggregateFunctionContext _localctx = new IndexAggregateFunctionContext(_ctx, getState());
		enterRule(_localctx, 272, RULE_indexAggregateFunction);
		try {
			setState(1531);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case MAXINDEX:
				enterOuterAlt(_localctx, 1);
				{
				setState(1489);
				match(MAXINDEX);
				setState(1490);
				match(LEFT_PAREN);
				setState(1491);
				path();
				setState(1492);
				match(RIGHT_PAREN);
				}
				break;
			case MININDEX:
				enterOuterAlt(_localctx, 2);
				{
				setState(1494);
				match(MININDEX);
				setState(1495);
				match(LEFT_PAREN);
				setState(1496);
				path();
				setState(1497);
				match(RIGHT_PAREN);
				}
				break;
			case MAX:
				enterOuterAlt(_localctx, 3);
				{
				setState(1499);
				match(MAX);
				setState(1500);
				match(LEFT_PAREN);
				setState(1501);
				match(INDICES);
				setState(1502);
				match(LEFT_PAREN);
				setState(1503);
				path();
				setState(1504);
				match(RIGHT_PAREN);
				setState(1505);
				match(RIGHT_PAREN);
				}
				break;
			case MIN:
				enterOuterAlt(_localctx, 4);
				{
				setState(1507);
				match(MIN);
				setState(1508);
				match(LEFT_PAREN);
				setState(1509);
				match(INDICES);
				setState(1510);
				match(LEFT_PAREN);
				setState(1511);
				path();
				setState(1512);
				match(RIGHT_PAREN);
				setState(1513);
				match(RIGHT_PAREN);
				}
				break;
			case SUM:
				enterOuterAlt(_localctx, 5);
				{
				setState(1515);
				match(SUM);
				setState(1516);
				match(LEFT_PAREN);
				setState(1517);
				match(INDICES);
				setState(1518);
				match(LEFT_PAREN);
				setState(1519);
				path();
				setState(1520);
				match(RIGHT_PAREN);
				setState(1521);
				match(RIGHT_PAREN);
				}
				break;
			case AVG:
				enterOuterAlt(_localctx, 6);
				{
				setState(1523);
				match(AVG);
				setState(1524);
				match(LEFT_PAREN);
				setState(1525);
				match(INDICES);
				setState(1526);
				match(LEFT_PAREN);
				setState(1527);
				path();
				setState(1528);
				match(RIGHT_PAREN);
				setState(1529);
				match(RIGHT_PAREN);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class ElementAggregateFunctionContext extends ParserRuleContext {
		public TerminalNode MAXELEMENT() { return getToken(HqlParser.MAXELEMENT, 0); }
		public List<TerminalNode> LEFT_PAREN() { return getTokens(HqlParser.LEFT_PAREN); }
		public TerminalNode LEFT_PAREN(int i) {
			return getToken(HqlParser.LEFT_PAREN, i);
		}
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public List<TerminalNode> RIGHT_PAREN() { return getTokens(HqlParser.RIGHT_PAREN); }
		public TerminalNode RIGHT_PAREN(int i) {
			return getToken(HqlParser.RIGHT_PAREN, i);
		}
		public TerminalNode MINELEMENT() { return getToken(HqlParser.MINELEMENT, 0); }
		public TerminalNode MAX() { return getToken(HqlParser.MAX, 0); }
		public TerminalNode ELEMENTS() { return getToken(HqlParser.ELEMENTS, 0); }
		public TerminalNode MIN() { return getToken(HqlParser.MIN, 0); }
		public TerminalNode SUM() { return getToken(HqlParser.SUM, 0); }
		public TerminalNode AVG() { return getToken(HqlParser.AVG, 0); }
		public ElementAggregateFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_elementAggregateFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterElementAggregateFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitElementAggregateFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitElementAggregateFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ElementAggregateFunctionContext elementAggregateFunction() throws RecognitionException {
		ElementAggregateFunctionContext _localctx = new ElementAggregateFunctionContext(_ctx, getState());
		enterRule(_localctx, 274, RULE_elementAggregateFunction);
		try {
			setState(1575);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case MAXELEMENT:
				enterOuterAlt(_localctx, 1);
				{
				setState(1533);
				match(MAXELEMENT);
				setState(1534);
				match(LEFT_PAREN);
				setState(1535);
				path();
				setState(1536);
				match(RIGHT_PAREN);
				}
				break;
			case MINELEMENT:
				enterOuterAlt(_localctx, 2);
				{
				setState(1538);
				match(MINELEMENT);
				setState(1539);
				match(LEFT_PAREN);
				setState(1540);
				path();
				setState(1541);
				match(RIGHT_PAREN);
				}
				break;
			case MAX:
				enterOuterAlt(_localctx, 3);
				{
				setState(1543);
				match(MAX);
				setState(1544);
				match(LEFT_PAREN);
				setState(1545);
				match(ELEMENTS);
				setState(1546);
				match(LEFT_PAREN);
				setState(1547);
				path();
				setState(1548);
				match(RIGHT_PAREN);
				setState(1549);
				match(RIGHT_PAREN);
				}
				break;
			case MIN:
				enterOuterAlt(_localctx, 4);
				{
				setState(1551);
				match(MIN);
				setState(1552);
				match(LEFT_PAREN);
				setState(1553);
				match(ELEMENTS);
				setState(1554);
				match(LEFT_PAREN);
				setState(1555);
				path();
				setState(1556);
				match(RIGHT_PAREN);
				setState(1557);
				match(RIGHT_PAREN);
				}
				break;
			case SUM:
				enterOuterAlt(_localctx, 5);
				{
				setState(1559);
				match(SUM);
				setState(1560);
				match(LEFT_PAREN);
				setState(1561);
				match(ELEMENTS);
				setState(1562);
				match(LEFT_PAREN);
				setState(1563);
				path();
				setState(1564);
				match(RIGHT_PAREN);
				setState(1565);
				match(RIGHT_PAREN);
				}
				break;
			case AVG:
				enterOuterAlt(_localctx, 6);
				{
				setState(1567);
				match(AVG);
				setState(1568);
				match(LEFT_PAREN);
				setState(1569);
				match(ELEMENTS);
				setState(1570);
				match(LEFT_PAREN);
				setState(1571);
				path();
				setState(1572);
				match(RIGHT_PAREN);
				setState(1573);
				match(RIGHT_PAREN);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class CollectionFunctionMisuseContext extends ParserRuleContext {
		public TerminalNode ELEMENTS() { return getToken(HqlParser.ELEMENTS, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode INDICES() { return getToken(HqlParser.INDICES, 0); }
		public CollectionFunctionMisuseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_collectionFunctionMisuse; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCollectionFunctionMisuse(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCollectionFunctionMisuse(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCollectionFunctionMisuse(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CollectionFunctionMisuseContext collectionFunctionMisuse() throws RecognitionException {
		CollectionFunctionMisuseContext _localctx = new CollectionFunctionMisuseContext(_ctx, getState());
		enterRule(_localctx, 276, RULE_collectionFunctionMisuse);
		try {
			setState(1587);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case ELEMENTS:
				enterOuterAlt(_localctx, 1);
				{
				setState(1577);
				match(ELEMENTS);
				setState(1578);
				match(LEFT_PAREN);
				setState(1579);
				path();
				setState(1580);
				match(RIGHT_PAREN);
				}
				break;
			case INDICES:
				enterOuterAlt(_localctx, 2);
				{
				setState(1582);
				match(INDICES);
				setState(1583);
				match(LEFT_PAREN);
				setState(1584);
				path();
				setState(1585);
				match(RIGHT_PAREN);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class AggregateFunctionContext extends ParserRuleContext {
		public EveryFunctionContext everyFunction() {
			return getRuleContext(EveryFunctionContext.class,0);
		}
		public AnyFunctionContext anyFunction() {
			return getRuleContext(AnyFunctionContext.class,0);
		}
		public ListaggFunctionContext listaggFunction() {
			return getRuleContext(ListaggFunctionContext.class,0);
		}
		public AggregateFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_aggregateFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterAggregateFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitAggregateFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitAggregateFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final AggregateFunctionContext aggregateFunction() throws RecognitionException {
		AggregateFunctionContext _localctx = new AggregateFunctionContext(_ctx, getState());
		enterRule(_localctx, 278, RULE_aggregateFunction);
		try {
			setState(1592);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case ALL:
			case EVERY:
				enterOuterAlt(_localctx, 1);
				{
				setState(1589);
				everyFunction();
				}
				break;
			case ANY:
			case SOME:
				enterOuterAlt(_localctx, 2);
				{
				setState(1590);
				anyFunction();
				}
				break;
			case LISTAGG:
				enterOuterAlt(_localctx, 3);
				{
				setState(1591);
				listaggFunction();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class EveryFunctionContext extends ParserRuleContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PredicateContext predicate() {
			return getRuleContext(PredicateContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode EVERY() { return getToken(HqlParser.EVERY, 0); }
		public TerminalNode ALL() { return getToken(HqlParser.ALL, 0); }
		public FilterClauseContext filterClause() {
			return getRuleContext(FilterClauseContext.class,0);
		}
		public OverClauseContext overClause() {
			return getRuleContext(OverClauseContext.class,0);
		}
		public SubqueryContext subquery() {
			return getRuleContext(SubqueryContext.class,0);
		}
		public SimplePathContext simplePath() {
			return getRuleContext(SimplePathContext.class,0);
		}
		public TerminalNode ELEMENTS() { return getToken(HqlParser.ELEMENTS, 0); }
		public TerminalNode INDICES() { return getToken(HqlParser.INDICES, 0); }
		public EveryFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_everyFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterEveryFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitEveryFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitEveryFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final EveryFunctionContext everyFunction() throws RecognitionException {
		EveryFunctionContext _localctx = new EveryFunctionContext(_ctx, getState());
		enterRule(_localctx, 280, RULE_everyFunction);
		int _la;
		try {
			setState(1615);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,167,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1594);
				_la = _input.LA(1);
				if ( !(_la==ALL || _la==EVERY) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}
				setState(1595);
				match(LEFT_PAREN);
				setState(1596);
				predicate(0);
				setState(1597);
				match(RIGHT_PAREN);
				setState(1599);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,165,_ctx) ) {
				case 1:
					{
					setState(1598);
					filterClause();
					}
					break;
				}
				setState(1602);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,166,_ctx) ) {
				case 1:
					{
					setState(1601);
					overClause();
					}
					break;
				}
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1604);
				_la = _input.LA(1);
				if ( !(_la==ALL || _la==EVERY) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}
				setState(1605);
				match(LEFT_PAREN);
				setState(1606);
				subquery();
				setState(1607);
				match(RIGHT_PAREN);
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(1609);
				_la = _input.LA(1);
				if ( !(_la==ALL || _la==EVERY) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}
				setState(1610);
				_la = _input.LA(1);
				if ( !(_la==ELEMENTS || _la==INDICES) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}
				setState(1611);
				match(LEFT_PAREN);
				setState(1612);
				simplePath();
				setState(1613);
				match(RIGHT_PAREN);
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class AnyFunctionContext extends ParserRuleContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PredicateContext predicate() {
			return getRuleContext(PredicateContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode ANY() { return getToken(HqlParser.ANY, 0); }
		public TerminalNode SOME() { return getToken(HqlParser.SOME, 0); }
		public FilterClauseContext filterClause() {
			return getRuleContext(FilterClauseContext.class,0);
		}
		public OverClauseContext overClause() {
			return getRuleContext(OverClauseContext.class,0);
		}
		public SubqueryContext subquery() {
			return getRuleContext(SubqueryContext.class,0);
		}
		public SimplePathContext simplePath() {
			return getRuleContext(SimplePathContext.class,0);
		}
		public TerminalNode ELEMENTS() { return getToken(HqlParser.ELEMENTS, 0); }
		public TerminalNode INDICES() { return getToken(HqlParser.INDICES, 0); }
		public AnyFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_anyFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterAnyFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitAnyFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitAnyFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final AnyFunctionContext anyFunction() throws RecognitionException {
		AnyFunctionContext _localctx = new AnyFunctionContext(_ctx, getState());
		enterRule(_localctx, 282, RULE_anyFunction);
		int _la;
		try {
			setState(1638);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,170,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1617);
				_la = _input.LA(1);
				if ( !(_la==ANY || _la==SOME) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}
				setState(1618);
				match(LEFT_PAREN);
				setState(1619);
				predicate(0);
				setState(1620);
				match(RIGHT_PAREN);
				setState(1622);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,168,_ctx) ) {
				case 1:
					{
					setState(1621);
					filterClause();
					}
					break;
				}
				setState(1625);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,169,_ctx) ) {
				case 1:
					{
					setState(1624);
					overClause();
					}
					break;
				}
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1627);
				_la = _input.LA(1);
				if ( !(_la==ANY || _la==SOME) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}
				setState(1628);
				match(LEFT_PAREN);
				setState(1629);
				subquery();
				setState(1630);
				match(RIGHT_PAREN);
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(1632);
				_la = _input.LA(1);
				if ( !(_la==ANY || _la==SOME) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}
				setState(1633);
				_la = _input.LA(1);
				if ( !(_la==ELEMENTS || _la==INDICES) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}
				setState(1634);
				match(LEFT_PAREN);
				setState(1635);
				simplePath();
				setState(1636);
				match(RIGHT_PAREN);
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class ListaggFunctionContext extends ParserRuleContext {
		public TerminalNode LISTAGG() { return getToken(HqlParser.LISTAGG, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public List<ExpressionOrPredicateContext> expressionOrPredicate() {
			return getRuleContexts(ExpressionOrPredicateContext.class);
		}
		public ExpressionOrPredicateContext expressionOrPredicate(int i) {
			return getRuleContext(ExpressionOrPredicateContext.class,i);
		}
		public TerminalNode COMMA() { return getToken(HqlParser.COMMA, 0); }
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode DISTINCT() { return getToken(HqlParser.DISTINCT, 0); }
		public OnOverflowClauseContext onOverflowClause() {
			return getRuleContext(OnOverflowClauseContext.class,0);
		}
		public WithinGroupClauseContext withinGroupClause() {
			return getRuleContext(WithinGroupClauseContext.class,0);
		}
		public FilterClauseContext filterClause() {
			return getRuleContext(FilterClauseContext.class,0);
		}
		public OverClauseContext overClause() {
			return getRuleContext(OverClauseContext.class,0);
		}
		public ListaggFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_listaggFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterListaggFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitListaggFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitListaggFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ListaggFunctionContext listaggFunction() throws RecognitionException {
		ListaggFunctionContext _localctx = new ListaggFunctionContext(_ctx, getState());
		enterRule(_localctx, 284, RULE_listaggFunction);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1640);
			match(LISTAGG);
			setState(1641);
			match(LEFT_PAREN);
			setState(1643);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,171,_ctx) ) {
			case 1:
				{
				setState(1642);
				match(DISTINCT);
				}
				break;
			}
			setState(1645);
			expressionOrPredicate();
			setState(1646);
			match(COMMA);
			setState(1647);
			expressionOrPredicate();
			setState(1649);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==ON) {
				{
				setState(1648);
				onOverflowClause();
				}
			}

			setState(1651);
			match(RIGHT_PAREN);
			setState(1653);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,173,_ctx) ) {
			case 1:
				{
				setState(1652);
				withinGroupClause();
				}
				break;
			}
			setState(1656);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,174,_ctx) ) {
			case 1:
				{
				setState(1655);
				filterClause();
				}
				break;
			}
			setState(1659);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,175,_ctx) ) {
			case 1:
				{
				setState(1658);
				overClause();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class OnOverflowClauseContext extends ParserRuleContext {
		public TerminalNode ON() { return getToken(HqlParser.ON, 0); }
		public TerminalNode OVERFLOW() { return getToken(HqlParser.OVERFLOW, 0); }
		public TerminalNode ERROR() { return getToken(HqlParser.ERROR, 0); }
		public TerminalNode TRUNCATE() { return getToken(HqlParser.TRUNCATE, 0); }
		public TerminalNode COUNT() { return getToken(HqlParser.COUNT, 0); }
		public TerminalNode WITH() { return getToken(HqlParser.WITH, 0); }
		public TerminalNode WITHOUT() { return getToken(HqlParser.WITHOUT, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public OnOverflowClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_onOverflowClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOnOverflowClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOnOverflowClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOnOverflowClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OnOverflowClauseContext onOverflowClause() throws RecognitionException {
		OnOverflowClauseContext _localctx = new OnOverflowClauseContext(_ctx, getState());
		enterRule(_localctx, 286, RULE_onOverflowClause);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1661);
			match(ON);
			setState(1662);
			match(OVERFLOW);
			setState(1670);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case ERROR:
				{
				setState(1663);
				match(ERROR);
				}
				break;
			case TRUNCATE:
				{
				{
				setState(1664);
				match(TRUNCATE);
				setState(1666);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,176,_ctx) ) {
				case 1:
					{
					setState(1665);
					expression(0);
					}
					break;
				}
				setState(1668);
				_la = _input.LA(1);
				if ( !(_la==WITH || _la==WITHOUT) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}
				setState(1669);
				match(COUNT);
				}
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class WithinGroupClauseContext extends ParserRuleContext {
		public TerminalNode WITHIN() { return getToken(HqlParser.WITHIN, 0); }
		public TerminalNode GROUP() { return getToken(HqlParser.GROUP, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public OrderByClauseContext orderByClause() {
			return getRuleContext(OrderByClauseContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public WithinGroupClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_withinGroupClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterWithinGroupClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitWithinGroupClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitWithinGroupClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final WithinGroupClauseContext withinGroupClause() throws RecognitionException {
		WithinGroupClauseContext _localctx = new WithinGroupClauseContext(_ctx, getState());
		enterRule(_localctx, 288, RULE_withinGroupClause);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1672);
			match(WITHIN);
			setState(1673);
			match(GROUP);
			setState(1674);
			match(LEFT_PAREN);
			setState(1675);
			orderByClause();
			setState(1676);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class FilterClauseContext extends ParserRuleContext {
		public TerminalNode FILTER() { return getToken(HqlParser.FILTER, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public WhereClauseContext whereClause() {
			return getRuleContext(WhereClauseContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public FilterClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_filterClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterFilterClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitFilterClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitFilterClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final FilterClauseContext filterClause() throws RecognitionException {
		FilterClauseContext _localctx = new FilterClauseContext(_ctx, getState());
		enterRule(_localctx, 290, RULE_filterClause);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1678);
			match(FILTER);
			setState(1679);
			match(LEFT_PAREN);
			setState(1680);
			whereClause();
			setState(1681);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class NullsClauseContext extends ParserRuleContext {
		public TerminalNode RESPECT() { return getToken(HqlParser.RESPECT, 0); }
		public TerminalNode NULLS() { return getToken(HqlParser.NULLS, 0); }
		public TerminalNode IGNORE() { return getToken(HqlParser.IGNORE, 0); }
		public NullsClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_nullsClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterNullsClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitNullsClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitNullsClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final NullsClauseContext nullsClause() throws RecognitionException {
		NullsClauseContext _localctx = new NullsClauseContext(_ctx, getState());
		enterRule(_localctx, 292, RULE_nullsClause);
		try {
			setState(1687);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case RESPECT:
				enterOuterAlt(_localctx, 1);
				{
				setState(1683);
				match(RESPECT);
				setState(1684);
				match(NULLS);
				}
				break;
			case IGNORE:
				enterOuterAlt(_localctx, 2);
				{
				setState(1685);
				match(IGNORE);
				setState(1686);
				match(NULLS);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class NthSideClauseContext extends ParserRuleContext {
		public TerminalNode FROM() { return getToken(HqlParser.FROM, 0); }
		public TerminalNode FIRST() { return getToken(HqlParser.FIRST, 0); }
		public TerminalNode LAST() { return getToken(HqlParser.LAST, 0); }
		public NthSideClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_nthSideClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterNthSideClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitNthSideClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitNthSideClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final NthSideClauseContext nthSideClause() throws RecognitionException {
		NthSideClauseContext _localctx = new NthSideClauseContext(_ctx, getState());
		enterRule(_localctx, 294, RULE_nthSideClause);
		try {
			setState(1693);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,179,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1689);
				match(FROM);
				setState(1690);
				match(FIRST);
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1691);
				match(FROM);
				setState(1692);
				match(LAST);
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class OverClauseContext extends ParserRuleContext {
		public TerminalNode OVER() { return getToken(HqlParser.OVER, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public PartitionClauseContext partitionClause() {
			return getRuleContext(PartitionClauseContext.class,0);
		}
		public OrderByClauseContext orderByClause() {
			return getRuleContext(OrderByClauseContext.class,0);
		}
		public FrameClauseContext frameClause() {
			return getRuleContext(FrameClauseContext.class,0);
		}
		public OverClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_overClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOverClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOverClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOverClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OverClauseContext overClause() throws RecognitionException {
		OverClauseContext _localctx = new OverClauseContext(_ctx, getState());
		enterRule(_localctx, 296, RULE_overClause);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1695);
			match(OVER);
			setState(1696);
			match(LEFT_PAREN);
			setState(1698);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==PARTITION) {
				{
				setState(1697);
				partitionClause();
				}
			}

			setState(1701);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==ORDER) {
				{
				setState(1700);
				orderByClause();
				}
			}

			setState(1704);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==GROUPS || _la==RANGE || _la==ROWS) {
				{
				setState(1703);
				frameClause();
				}
			}

			setState(1706);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class PartitionClauseContext extends ParserRuleContext {
		public TerminalNode PARTITION() { return getToken(HqlParser.PARTITION, 0); }
		public TerminalNode BY() { return getToken(HqlParser.BY, 0); }
		public List<ExpressionContext> expression() {
			return getRuleContexts(ExpressionContext.class);
		}
		public ExpressionContext expression(int i) {
			return getRuleContext(ExpressionContext.class,i);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public PartitionClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_partitionClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterPartitionClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitPartitionClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitPartitionClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final PartitionClauseContext partitionClause() throws RecognitionException {
		PartitionClauseContext _localctx = new PartitionClauseContext(_ctx, getState());
		enterRule(_localctx, 298, RULE_partitionClause);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1708);
			match(PARTITION);
			setState(1709);
			match(BY);
			setState(1710);
			expression(0);
			setState(1715);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(1711);
				match(COMMA);
				setState(1712);
				expression(0);
				}
				}
				setState(1717);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class FrameClauseContext extends ParserRuleContext {
		public FrameStartContext frameStart() {
			return getRuleContext(FrameStartContext.class,0);
		}
		public TerminalNode RANGE() { return getToken(HqlParser.RANGE, 0); }
		public TerminalNode ROWS() { return getToken(HqlParser.ROWS, 0); }
		public TerminalNode GROUPS() { return getToken(HqlParser.GROUPS, 0); }
		public FrameExclusionContext frameExclusion() {
			return getRuleContext(FrameExclusionContext.class,0);
		}
		public TerminalNode BETWEEN() { return getToken(HqlParser.BETWEEN, 0); }
		public TerminalNode AND() { return getToken(HqlParser.AND, 0); }
		public FrameEndContext frameEnd() {
			return getRuleContext(FrameEndContext.class,0);
		}
		public FrameClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_frameClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterFrameClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitFrameClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitFrameClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final FrameClauseContext frameClause() throws RecognitionException {
		FrameClauseContext _localctx = new FrameClauseContext(_ctx, getState());
		enterRule(_localctx, 300, RULE_frameClause);
		int _la;
		try {
			setState(1731);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,186,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1718);
				_la = _input.LA(1);
				if ( !(_la==GROUPS || _la==RANGE || _la==ROWS) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}
				setState(1719);
				frameStart();
				setState(1721);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==EXCLUDE) {
					{
					setState(1720);
					frameExclusion();
					}
				}

				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1723);
				_la = _input.LA(1);
				if ( !(_la==GROUPS || _la==RANGE || _la==ROWS) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}
				setState(1724);
				match(BETWEEN);
				setState(1725);
				frameStart();
				setState(1726);
				match(AND);
				setState(1727);
				frameEnd();
				setState(1729);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==EXCLUDE) {
					{
					setState(1728);
					frameExclusion();
					}
				}

				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class FrameStartContext extends ParserRuleContext {
		public TerminalNode CURRENT() { return getToken(HqlParser.CURRENT, 0); }
		public TerminalNode ROW() { return getToken(HqlParser.ROW, 0); }
		public TerminalNode UNBOUNDED() { return getToken(HqlParser.UNBOUNDED, 0); }
		public TerminalNode PRECEDING() { return getToken(HqlParser.PRECEDING, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode FOLLOWING() { return getToken(HqlParser.FOLLOWING, 0); }
		public FrameStartContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_frameStart; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterFrameStart(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitFrameStart(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitFrameStart(this);
			else return visitor.visitChildren(this);
		}
	}

	public final FrameStartContext frameStart() throws RecognitionException {
		FrameStartContext _localctx = new FrameStartContext(_ctx, getState());
		enterRule(_localctx, 302, RULE_frameStart);
		try {
			setState(1743);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,187,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1733);
				match(CURRENT);
				setState(1734);
				match(ROW);
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1735);
				match(UNBOUNDED);
				setState(1736);
				match(PRECEDING);
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(1737);
				expression(0);
				setState(1738);
				match(PRECEDING);
				}
				break;
			case 4:
				enterOuterAlt(_localctx, 4);
				{
				setState(1740);
				expression(0);
				setState(1741);
				match(FOLLOWING);
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class FrameEndContext extends ParserRuleContext {
		public TerminalNode CURRENT() { return getToken(HqlParser.CURRENT, 0); }
		public TerminalNode ROW() { return getToken(HqlParser.ROW, 0); }
		public TerminalNode UNBOUNDED() { return getToken(HqlParser.UNBOUNDED, 0); }
		public TerminalNode FOLLOWING() { return getToken(HqlParser.FOLLOWING, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode PRECEDING() { return getToken(HqlParser.PRECEDING, 0); }
		public FrameEndContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_frameEnd; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterFrameEnd(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitFrameEnd(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitFrameEnd(this);
			else return visitor.visitChildren(this);
		}
	}

	public final FrameEndContext frameEnd() throws RecognitionException {
		FrameEndContext _localctx = new FrameEndContext(_ctx, getState());
		enterRule(_localctx, 304, RULE_frameEnd);
		try {
			setState(1755);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,188,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1745);
				match(CURRENT);
				setState(1746);
				match(ROW);
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1747);
				match(UNBOUNDED);
				setState(1748);
				match(FOLLOWING);
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(1749);
				expression(0);
				setState(1750);
				match(PRECEDING);
				}
				break;
			case 4:
				enterOuterAlt(_localctx, 4);
				{
				setState(1752);
				expression(0);
				setState(1753);
				match(FOLLOWING);
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class FrameExclusionContext extends ParserRuleContext {
		public TerminalNode EXCLUDE() { return getToken(HqlParser.EXCLUDE, 0); }
		public TerminalNode CURRENT() { return getToken(HqlParser.CURRENT, 0); }
		public TerminalNode ROW() { return getToken(HqlParser.ROW, 0); }
		public TerminalNode GROUP() { return getToken(HqlParser.GROUP, 0); }
		public TerminalNode TIES() { return getToken(HqlParser.TIES, 0); }
		public TerminalNode NO() { return getToken(HqlParser.NO, 0); }
		public TerminalNode OTHERS() { return getToken(HqlParser.OTHERS, 0); }
		public FrameExclusionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_frameExclusion; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterFrameExclusion(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitFrameExclusion(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitFrameExclusion(this);
			else return visitor.visitChildren(this);
		}
	}

	public final FrameExclusionContext frameExclusion() throws RecognitionException {
		FrameExclusionContext _localctx = new FrameExclusionContext(_ctx, getState());
		enterRule(_localctx, 306, RULE_frameExclusion);
		try {
			setState(1767);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,189,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1757);
				match(EXCLUDE);
				setState(1758);
				match(CURRENT);
				setState(1759);
				match(ROW);
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1760);
				match(EXCLUDE);
				setState(1761);
				match(GROUP);
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(1762);
				match(EXCLUDE);
				setState(1763);
				match(TIES);
				}
				break;
			case 4:
				enterOuterAlt(_localctx, 4);
				{
				setState(1764);
				match(EXCLUDE);
				setState(1765);
				match(NO);
				setState(1766);
				match(OTHERS);
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class StandardFunctionContext extends ParserRuleContext {
		public CastFunctionContext castFunction() {
			return getRuleContext(CastFunctionContext.class,0);
		}
		public ExtractFunctionContext extractFunction() {
			return getRuleContext(ExtractFunctionContext.class,0);
		}
		public TruncFunctionContext truncFunction() {
			return getRuleContext(TruncFunctionContext.class,0);
		}
		public FormatFunctionContext formatFunction() {
			return getRuleContext(FormatFunctionContext.class,0);
		}
		public CollateFunctionContext collateFunction() {
			return getRuleContext(CollateFunctionContext.class,0);
		}
		public SubstringFunctionContext substringFunction() {
			return getRuleContext(SubstringFunctionContext.class,0);
		}
		public OverlayFunctionContext overlayFunction() {
			return getRuleContext(OverlayFunctionContext.class,0);
		}
		public TrimFunctionContext trimFunction() {
			return getRuleContext(TrimFunctionContext.class,0);
		}
		public PadFunctionContext padFunction() {
			return getRuleContext(PadFunctionContext.class,0);
		}
		public PositionFunctionContext positionFunction() {
			return getRuleContext(PositionFunctionContext.class,0);
		}
		public CurrentDateFunctionContext currentDateFunction() {
			return getRuleContext(CurrentDateFunctionContext.class,0);
		}
		public CurrentTimeFunctionContext currentTimeFunction() {
			return getRuleContext(CurrentTimeFunctionContext.class,0);
		}
		public CurrentTimestampFunctionContext currentTimestampFunction() {
			return getRuleContext(CurrentTimestampFunctionContext.class,0);
		}
		public InstantFunctionContext instantFunction() {
			return getRuleContext(InstantFunctionContext.class,0);
		}
		public LocalDateFunctionContext localDateFunction() {
			return getRuleContext(LocalDateFunctionContext.class,0);
		}
		public LocalTimeFunctionContext localTimeFunction() {
			return getRuleContext(LocalTimeFunctionContext.class,0);
		}
		public LocalDateTimeFunctionContext localDateTimeFunction() {
			return getRuleContext(LocalDateTimeFunctionContext.class,0);
		}
		public OffsetDateTimeFunctionContext offsetDateTimeFunction() {
			return getRuleContext(OffsetDateTimeFunctionContext.class,0);
		}
		public CubeContext cube() {
			return getRuleContext(CubeContext.class,0);
		}
		public RollupContext rollup() {
			return getRuleContext(RollupContext.class,0);
		}
		public StandardFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_standardFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterStandardFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitStandardFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitStandardFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final StandardFunctionContext standardFunction() throws RecognitionException {
		StandardFunctionContext _localctx = new StandardFunctionContext(_ctx, getState());
		enterRule(_localctx, 308, RULE_standardFunction);
		try {
			setState(1789);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,190,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1769);
				castFunction();
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1770);
				extractFunction();
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(1771);
				truncFunction();
				}
				break;
			case 4:
				enterOuterAlt(_localctx, 4);
				{
				setState(1772);
				formatFunction();
				}
				break;
			case 5:
				enterOuterAlt(_localctx, 5);
				{
				setState(1773);
				collateFunction();
				}
				break;
			case 6:
				enterOuterAlt(_localctx, 6);
				{
				setState(1774);
				substringFunction();
				}
				break;
			case 7:
				enterOuterAlt(_localctx, 7);
				{
				setState(1775);
				overlayFunction();
				}
				break;
			case 8:
				enterOuterAlt(_localctx, 8);
				{
				setState(1776);
				trimFunction();
				}
				break;
			case 9:
				enterOuterAlt(_localctx, 9);
				{
				setState(1777);
				padFunction();
				}
				break;
			case 10:
				enterOuterAlt(_localctx, 10);
				{
				setState(1778);
				positionFunction();
				}
				break;
			case 11:
				enterOuterAlt(_localctx, 11);
				{
				setState(1779);
				currentDateFunction();
				}
				break;
			case 12:
				enterOuterAlt(_localctx, 12);
				{
				setState(1780);
				currentTimeFunction();
				}
				break;
			case 13:
				enterOuterAlt(_localctx, 13);
				{
				setState(1781);
				currentTimestampFunction();
				}
				break;
			case 14:
				enterOuterAlt(_localctx, 14);
				{
				setState(1782);
				instantFunction();
				}
				break;
			case 15:
				enterOuterAlt(_localctx, 15);
				{
				setState(1783);
				localDateFunction();
				}
				break;
			case 16:
				enterOuterAlt(_localctx, 16);
				{
				setState(1784);
				localTimeFunction();
				}
				break;
			case 17:
				enterOuterAlt(_localctx, 17);
				{
				setState(1785);
				localDateTimeFunction();
				}
				break;
			case 18:
				enterOuterAlt(_localctx, 18);
				{
				setState(1786);
				offsetDateTimeFunction();
				}
				break;
			case 19:
				enterOuterAlt(_localctx, 19);
				{
				setState(1787);
				cube();
				}
				break;
			case 20:
				enterOuterAlt(_localctx, 20);
				{
				setState(1788);
				rollup();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class CastFunctionContext extends ParserRuleContext {
		public TerminalNode CAST() { return getToken(HqlParser.CAST, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode AS() { return getToken(HqlParser.AS, 0); }
		public CastTargetContext castTarget() {
			return getRuleContext(CastTargetContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public CastFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_castFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCastFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCastFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCastFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CastFunctionContext castFunction() throws RecognitionException {
		CastFunctionContext _localctx = new CastFunctionContext(_ctx, getState());
		enterRule(_localctx, 310, RULE_castFunction);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1791);
			match(CAST);
			setState(1792);
			match(LEFT_PAREN);
			setState(1793);
			expression(0);
			setState(1794);
			match(AS);
			setState(1795);
			castTarget();
			setState(1796);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class CastTargetContext extends ParserRuleContext {
		public CastTargetTypeContext castTargetType() {
			return getRuleContext(CastTargetTypeContext.class,0);
		}
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public List<TerminalNode> INTEGER_LITERAL() { return getTokens(HqlParser.INTEGER_LITERAL); }
		public TerminalNode INTEGER_LITERAL(int i) {
			return getToken(HqlParser.INTEGER_LITERAL, i);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode COMMA() { return getToken(HqlParser.COMMA, 0); }
		public CastTargetContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_castTarget; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCastTarget(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCastTarget(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCastTarget(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CastTargetContext castTarget() throws RecognitionException {
		CastTargetContext _localctx = new CastTargetContext(_ctx, getState());
		enterRule(_localctx, 312, RULE_castTarget);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1798);
			castTargetType();
			setState(1806);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==LEFT_PAREN) {
				{
				setState(1799);
				match(LEFT_PAREN);
				setState(1800);
				match(INTEGER_LITERAL);
				setState(1803);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==COMMA) {
					{
					setState(1801);
					match(COMMA);
					setState(1802);
					match(INTEGER_LITERAL);
					}
				}

				setState(1805);
				match(RIGHT_PAREN);
				}
			}

			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class CastTargetTypeContext extends ParserRuleContext {
		public String fullTargetName;
		public IdentifierContext i;
		public IdentifierContext c;
		public List<IdentifierContext> identifier() {
			return getRuleContexts(IdentifierContext.class);
		}
		public IdentifierContext identifier(int i) {
			return getRuleContext(IdentifierContext.class,i);
		}
		public List<TerminalNode> DOT() { return getTokens(HqlParser.DOT); }
		public TerminalNode DOT(int i) {
			return getToken(HqlParser.DOT, i);
		}
		public CastTargetTypeContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_castTargetType; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCastTargetType(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCastTargetType(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCastTargetType(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CastTargetTypeContext castTargetType() throws RecognitionException {
		CastTargetTypeContext _localctx = new CastTargetTypeContext(_ctx, getState());
		enterRule(_localctx, 314, RULE_castTargetType);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			{
			setState(1808);
			((CastTargetTypeContext)_localctx).i = identifier();
			 ((CastTargetTypeContext)_localctx).fullTargetName =  _localctx.i.getText(); 
			}
			setState(1817);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==DOT) {
				{
				{
				setState(1811);
				match(DOT);
				setState(1812);
				((CastTargetTypeContext)_localctx).c = identifier();
				 _localctx.fullTargetName += ("." + _localctx.c.getText() ); 
				}
				}
				setState(1819);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SubstringFunctionContext extends ParserRuleContext {
		public TerminalNode SUBSTRING() { return getToken(HqlParser.SUBSTRING, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public SubstringFunctionStartArgumentContext substringFunctionStartArgument() {
			return getRuleContext(SubstringFunctionStartArgumentContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public SubstringFunctionLengthArgumentContext substringFunctionLengthArgument() {
			return getRuleContext(SubstringFunctionLengthArgumentContext.class,0);
		}
		public TerminalNode FROM() { return getToken(HqlParser.FROM, 0); }
		public TerminalNode FOR() { return getToken(HqlParser.FOR, 0); }
		public SubstringFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_substringFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSubstringFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSubstringFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSubstringFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SubstringFunctionContext substringFunction() throws RecognitionException {
		SubstringFunctionContext _localctx = new SubstringFunctionContext(_ctx, getState());
		enterRule(_localctx, 316, RULE_substringFunction);
		int _la;
		try {
			setState(1842);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,196,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1820);
				match(SUBSTRING);
				setState(1821);
				match(LEFT_PAREN);
				setState(1822);
				expression(0);
				setState(1823);
				match(COMMA);
				setState(1824);
				substringFunctionStartArgument();
				setState(1827);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==COMMA) {
					{
					setState(1825);
					match(COMMA);
					setState(1826);
					substringFunctionLengthArgument();
					}
				}

				setState(1829);
				match(RIGHT_PAREN);
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1831);
				match(SUBSTRING);
				setState(1832);
				match(LEFT_PAREN);
				setState(1833);
				expression(0);
				setState(1834);
				match(FROM);
				setState(1835);
				substringFunctionStartArgument();
				setState(1838);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==FOR) {
					{
					setState(1836);
					match(FOR);
					setState(1837);
					substringFunctionLengthArgument();
					}
				}

				setState(1840);
				match(RIGHT_PAREN);
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SubstringFunctionStartArgumentContext extends ParserRuleContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public SubstringFunctionStartArgumentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_substringFunctionStartArgument; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSubstringFunctionStartArgument(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSubstringFunctionStartArgument(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSubstringFunctionStartArgument(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SubstringFunctionStartArgumentContext substringFunctionStartArgument() throws RecognitionException {
		SubstringFunctionStartArgumentContext _localctx = new SubstringFunctionStartArgumentContext(_ctx, getState());
		enterRule(_localctx, 318, RULE_substringFunctionStartArgument);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1844);
			expression(0);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class SubstringFunctionLengthArgumentContext extends ParserRuleContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public SubstringFunctionLengthArgumentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_substringFunctionLengthArgument; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSubstringFunctionLengthArgument(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSubstringFunctionLengthArgument(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSubstringFunctionLengthArgument(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SubstringFunctionLengthArgumentContext substringFunctionLengthArgument() throws RecognitionException {
		SubstringFunctionLengthArgumentContext _localctx = new SubstringFunctionLengthArgumentContext(_ctx, getState());
		enterRule(_localctx, 320, RULE_substringFunctionLengthArgument);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1846);
			expression(0);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class TrimFunctionContext extends ParserRuleContext {
		public TerminalNode TRIM() { return getToken(HqlParser.TRIM, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TrimSpecificationContext trimSpecification() {
			return getRuleContext(TrimSpecificationContext.class,0);
		}
		public TrimCharacterContext trimCharacter() {
			return getRuleContext(TrimCharacterContext.class,0);
		}
		public TerminalNode FROM() { return getToken(HqlParser.FROM, 0); }
		public TrimFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_trimFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterTrimFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitTrimFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitTrimFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final TrimFunctionContext trimFunction() throws RecognitionException {
		TrimFunctionContext _localctx = new TrimFunctionContext(_ctx, getState());
		enterRule(_localctx, 322, RULE_trimFunction);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1848);
			match(TRIM);
			setState(1849);
			match(LEFT_PAREN);
			setState(1851);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,197,_ctx) ) {
			case 1:
				{
				setState(1850);
				trimSpecification();
				}
				break;
			}
			setState(1854);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,198,_ctx) ) {
			case 1:
				{
				setState(1853);
				trimCharacter();
				}
				break;
			}
			setState(1857);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,199,_ctx) ) {
			case 1:
				{
				setState(1856);
				match(FROM);
				}
				break;
			}
			setState(1859);
			expression(0);
			setState(1860);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class TrimSpecificationContext extends ParserRuleContext {
		public TerminalNode LEADING() { return getToken(HqlParser.LEADING, 0); }
		public TerminalNode TRAILING() { return getToken(HqlParser.TRAILING, 0); }
		public TerminalNode BOTH() { return getToken(HqlParser.BOTH, 0); }
		public TrimSpecificationContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_trimSpecification; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterTrimSpecification(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitTrimSpecification(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitTrimSpecification(this);
			else return visitor.visitChildren(this);
		}
	}

	public final TrimSpecificationContext trimSpecification() throws RecognitionException {
		TrimSpecificationContext _localctx = new TrimSpecificationContext(_ctx, getState());
		enterRule(_localctx, 324, RULE_trimSpecification);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1862);
			_la = _input.LA(1);
			if ( !(_la==BOTH || _la==LEADING || _la==TRAILING) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class TrimCharacterContext extends ParserRuleContext {
		public TerminalNode STRING_LITERAL() { return getToken(HqlParser.STRING_LITERAL, 0); }
		public TrimCharacterContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_trimCharacter; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterTrimCharacter(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitTrimCharacter(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitTrimCharacter(this);
			else return visitor.visitChildren(this);
		}
	}

	public final TrimCharacterContext trimCharacter() throws RecognitionException {
		TrimCharacterContext _localctx = new TrimCharacterContext(_ctx, getState());
		enterRule(_localctx, 326, RULE_trimCharacter);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1864);
			match(STRING_LITERAL);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class PadFunctionContext extends ParserRuleContext {
		public TerminalNode PAD() { return getToken(HqlParser.PAD, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode WITH() { return getToken(HqlParser.WITH, 0); }
		public PadLengthContext padLength() {
			return getRuleContext(PadLengthContext.class,0);
		}
		public PadSpecificationContext padSpecification() {
			return getRuleContext(PadSpecificationContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public PadCharacterContext padCharacter() {
			return getRuleContext(PadCharacterContext.class,0);
		}
		public PadFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_padFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterPadFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitPadFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitPadFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final PadFunctionContext padFunction() throws RecognitionException {
		PadFunctionContext _localctx = new PadFunctionContext(_ctx, getState());
		enterRule(_localctx, 328, RULE_padFunction);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1866);
			match(PAD);
			setState(1867);
			match(LEFT_PAREN);
			setState(1868);
			expression(0);
			setState(1869);
			match(WITH);
			setState(1870);
			padLength();
			setState(1871);
			padSpecification();
			setState(1873);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==STRING_LITERAL) {
				{
				setState(1872);
				padCharacter();
				}
			}

			setState(1875);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class PadSpecificationContext extends ParserRuleContext {
		public TerminalNode LEADING() { return getToken(HqlParser.LEADING, 0); }
		public TerminalNode TRAILING() { return getToken(HqlParser.TRAILING, 0); }
		public PadSpecificationContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_padSpecification; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterPadSpecification(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitPadSpecification(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitPadSpecification(this);
			else return visitor.visitChildren(this);
		}
	}

	public final PadSpecificationContext padSpecification() throws RecognitionException {
		PadSpecificationContext _localctx = new PadSpecificationContext(_ctx, getState());
		enterRule(_localctx, 330, RULE_padSpecification);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1877);
			_la = _input.LA(1);
			if ( !(_la==LEADING || _la==TRAILING) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class PadCharacterContext extends ParserRuleContext {
		public TerminalNode STRING_LITERAL() { return getToken(HqlParser.STRING_LITERAL, 0); }
		public PadCharacterContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_padCharacter; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterPadCharacter(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitPadCharacter(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitPadCharacter(this);
			else return visitor.visitChildren(this);
		}
	}

	public final PadCharacterContext padCharacter() throws RecognitionException {
		PadCharacterContext _localctx = new PadCharacterContext(_ctx, getState());
		enterRule(_localctx, 332, RULE_padCharacter);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1879);
			match(STRING_LITERAL);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class PadLengthContext extends ParserRuleContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public PadLengthContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_padLength; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterPadLength(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitPadLength(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitPadLength(this);
			else return visitor.visitChildren(this);
		}
	}

	public final PadLengthContext padLength() throws RecognitionException {
		PadLengthContext _localctx = new PadLengthContext(_ctx, getState());
		enterRule(_localctx, 334, RULE_padLength);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1881);
			expression(0);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class OverlayFunctionContext extends ParserRuleContext {
		public TerminalNode OVERLAY() { return getToken(HqlParser.OVERLAY, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public OverlayFunctionStringArgumentContext overlayFunctionStringArgument() {
			return getRuleContext(OverlayFunctionStringArgumentContext.class,0);
		}
		public TerminalNode PLACING() { return getToken(HqlParser.PLACING, 0); }
		public OverlayFunctionReplacementArgumentContext overlayFunctionReplacementArgument() {
			return getRuleContext(OverlayFunctionReplacementArgumentContext.class,0);
		}
		public TerminalNode FROM() { return getToken(HqlParser.FROM, 0); }
		public OverlayFunctionStartArgumentContext overlayFunctionStartArgument() {
			return getRuleContext(OverlayFunctionStartArgumentContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode FOR() { return getToken(HqlParser.FOR, 0); }
		public OverlayFunctionLengthArgumentContext overlayFunctionLengthArgument() {
			return getRuleContext(OverlayFunctionLengthArgumentContext.class,0);
		}
		public OverlayFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_overlayFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOverlayFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOverlayFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOverlayFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OverlayFunctionContext overlayFunction() throws RecognitionException {
		OverlayFunctionContext _localctx = new OverlayFunctionContext(_ctx, getState());
		enterRule(_localctx, 336, RULE_overlayFunction);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1883);
			match(OVERLAY);
			setState(1884);
			match(LEFT_PAREN);
			setState(1885);
			overlayFunctionStringArgument();
			setState(1886);
			match(PLACING);
			setState(1887);
			overlayFunctionReplacementArgument();
			setState(1888);
			match(FROM);
			setState(1889);
			overlayFunctionStartArgument();
			setState(1892);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==FOR) {
				{
				setState(1890);
				match(FOR);
				setState(1891);
				overlayFunctionLengthArgument();
				}
			}

			setState(1894);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class OverlayFunctionStringArgumentContext extends ParserRuleContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public OverlayFunctionStringArgumentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_overlayFunctionStringArgument; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOverlayFunctionStringArgument(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOverlayFunctionStringArgument(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOverlayFunctionStringArgument(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OverlayFunctionStringArgumentContext overlayFunctionStringArgument() throws RecognitionException {
		OverlayFunctionStringArgumentContext _localctx = new OverlayFunctionStringArgumentContext(_ctx, getState());
		enterRule(_localctx, 338, RULE_overlayFunctionStringArgument);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1896);
			expression(0);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class OverlayFunctionReplacementArgumentContext extends ParserRuleContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public OverlayFunctionReplacementArgumentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_overlayFunctionReplacementArgument; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOverlayFunctionReplacementArgument(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOverlayFunctionReplacementArgument(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOverlayFunctionReplacementArgument(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OverlayFunctionReplacementArgumentContext overlayFunctionReplacementArgument() throws RecognitionException {
		OverlayFunctionReplacementArgumentContext _localctx = new OverlayFunctionReplacementArgumentContext(_ctx, getState());
		enterRule(_localctx, 340, RULE_overlayFunctionReplacementArgument);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1898);
			expression(0);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class OverlayFunctionStartArgumentContext extends ParserRuleContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public OverlayFunctionStartArgumentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_overlayFunctionStartArgument; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOverlayFunctionStartArgument(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOverlayFunctionStartArgument(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOverlayFunctionStartArgument(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OverlayFunctionStartArgumentContext overlayFunctionStartArgument() throws RecognitionException {
		OverlayFunctionStartArgumentContext _localctx = new OverlayFunctionStartArgumentContext(_ctx, getState());
		enterRule(_localctx, 342, RULE_overlayFunctionStartArgument);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1900);
			expression(0);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class OverlayFunctionLengthArgumentContext extends ParserRuleContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public OverlayFunctionLengthArgumentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_overlayFunctionLengthArgument; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOverlayFunctionLengthArgument(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOverlayFunctionLengthArgument(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOverlayFunctionLengthArgument(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OverlayFunctionLengthArgumentContext overlayFunctionLengthArgument() throws RecognitionException {
		OverlayFunctionLengthArgumentContext _localctx = new OverlayFunctionLengthArgumentContext(_ctx, getState());
		enterRule(_localctx, 344, RULE_overlayFunctionLengthArgument);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1902);
			expression(0);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class CurrentDateFunctionContext extends ParserRuleContext {
		public TerminalNode CURRENT_DATE() { return getToken(HqlParser.CURRENT_DATE, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode CURRENT() { return getToken(HqlParser.CURRENT, 0); }
		public TerminalNode DATE() { return getToken(HqlParser.DATE, 0); }
		public CurrentDateFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_currentDateFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCurrentDateFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCurrentDateFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCurrentDateFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CurrentDateFunctionContext currentDateFunction() throws RecognitionException {
		CurrentDateFunctionContext _localctx = new CurrentDateFunctionContext(_ctx, getState());
		enterRule(_localctx, 346, RULE_currentDateFunction);
		try {
			setState(1911);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case CURRENT_DATE:
				enterOuterAlt(_localctx, 1);
				{
				setState(1904);
				match(CURRENT_DATE);
				setState(1907);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,202,_ctx) ) {
				case 1:
					{
					setState(1905);
					match(LEFT_PAREN);
					setState(1906);
					match(RIGHT_PAREN);
					}
					break;
				}
				}
				break;
			case CURRENT:
				enterOuterAlt(_localctx, 2);
				{
				setState(1909);
				match(CURRENT);
				setState(1910);
				match(DATE);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class CurrentTimeFunctionContext extends ParserRuleContext {
		public TerminalNode CURRENT_TIME() { return getToken(HqlParser.CURRENT_TIME, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode CURRENT() { return getToken(HqlParser.CURRENT, 0); }
		public TerminalNode TIME() { return getToken(HqlParser.TIME, 0); }
		public CurrentTimeFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_currentTimeFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCurrentTimeFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCurrentTimeFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCurrentTimeFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CurrentTimeFunctionContext currentTimeFunction() throws RecognitionException {
		CurrentTimeFunctionContext _localctx = new CurrentTimeFunctionContext(_ctx, getState());
		enterRule(_localctx, 348, RULE_currentTimeFunction);
		try {
			setState(1920);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case CURRENT_TIME:
				enterOuterAlt(_localctx, 1);
				{
				setState(1913);
				match(CURRENT_TIME);
				setState(1916);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,204,_ctx) ) {
				case 1:
					{
					setState(1914);
					match(LEFT_PAREN);
					setState(1915);
					match(RIGHT_PAREN);
					}
					break;
				}
				}
				break;
			case CURRENT:
				enterOuterAlt(_localctx, 2);
				{
				setState(1918);
				match(CURRENT);
				setState(1919);
				match(TIME);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class CurrentTimestampFunctionContext extends ParserRuleContext {
		public TerminalNode CURRENT_TIMESTAMP() { return getToken(HqlParser.CURRENT_TIMESTAMP, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode CURRENT() { return getToken(HqlParser.CURRENT, 0); }
		public TerminalNode TIMESTAMP() { return getToken(HqlParser.TIMESTAMP, 0); }
		public CurrentTimestampFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_currentTimestampFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCurrentTimestampFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCurrentTimestampFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCurrentTimestampFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CurrentTimestampFunctionContext currentTimestampFunction() throws RecognitionException {
		CurrentTimestampFunctionContext _localctx = new CurrentTimestampFunctionContext(_ctx, getState());
		enterRule(_localctx, 350, RULE_currentTimestampFunction);
		try {
			setState(1929);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case CURRENT_TIMESTAMP:
				enterOuterAlt(_localctx, 1);
				{
				setState(1922);
				match(CURRENT_TIMESTAMP);
				setState(1925);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,206,_ctx) ) {
				case 1:
					{
					setState(1923);
					match(LEFT_PAREN);
					setState(1924);
					match(RIGHT_PAREN);
					}
					break;
				}
				}
				break;
			case CURRENT:
				enterOuterAlt(_localctx, 2);
				{
				setState(1927);
				match(CURRENT);
				setState(1928);
				match(TIMESTAMP);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class InstantFunctionContext extends ParserRuleContext {
		public TerminalNode CURRENT_INSTANT() { return getToken(HqlParser.CURRENT_INSTANT, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode INSTANT() { return getToken(HqlParser.INSTANT, 0); }
		public InstantFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_instantFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterInstantFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitInstantFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitInstantFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final InstantFunctionContext instantFunction() throws RecognitionException {
		InstantFunctionContext _localctx = new InstantFunctionContext(_ctx, getState());
		enterRule(_localctx, 352, RULE_instantFunction);
		try {
			setState(1937);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case CURRENT_INSTANT:
				enterOuterAlt(_localctx, 1);
				{
				setState(1931);
				match(CURRENT_INSTANT);
				setState(1934);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,208,_ctx) ) {
				case 1:
					{
					setState(1932);
					match(LEFT_PAREN);
					setState(1933);
					match(RIGHT_PAREN);
					}
					break;
				}
				}
				break;
			case INSTANT:
				enterOuterAlt(_localctx, 2);
				{
				setState(1936);
				match(INSTANT);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class LocalDateTimeFunctionContext extends ParserRuleContext {
		public TerminalNode LOCAL_DATETIME() { return getToken(HqlParser.LOCAL_DATETIME, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode LOCAL() { return getToken(HqlParser.LOCAL, 0); }
		public TerminalNode DATETIME() { return getToken(HqlParser.DATETIME, 0); }
		public LocalDateTimeFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_localDateTimeFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterLocalDateTimeFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitLocalDateTimeFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitLocalDateTimeFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final LocalDateTimeFunctionContext localDateTimeFunction() throws RecognitionException {
		LocalDateTimeFunctionContext _localctx = new LocalDateTimeFunctionContext(_ctx, getState());
		enterRule(_localctx, 354, RULE_localDateTimeFunction);
		try {
			setState(1946);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case LOCAL_DATETIME:
				enterOuterAlt(_localctx, 1);
				{
				setState(1939);
				match(LOCAL_DATETIME);
				setState(1942);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,210,_ctx) ) {
				case 1:
					{
					setState(1940);
					match(LEFT_PAREN);
					setState(1941);
					match(RIGHT_PAREN);
					}
					break;
				}
				}
				break;
			case LOCAL:
				enterOuterAlt(_localctx, 2);
				{
				setState(1944);
				match(LOCAL);
				setState(1945);
				match(DATETIME);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class OffsetDateTimeFunctionContext extends ParserRuleContext {
		public TerminalNode OFFSET_DATETIME() { return getToken(HqlParser.OFFSET_DATETIME, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode OFFSET() { return getToken(HqlParser.OFFSET, 0); }
		public TerminalNode DATETIME() { return getToken(HqlParser.DATETIME, 0); }
		public OffsetDateTimeFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_offsetDateTimeFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOffsetDateTimeFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOffsetDateTimeFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOffsetDateTimeFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OffsetDateTimeFunctionContext offsetDateTimeFunction() throws RecognitionException {
		OffsetDateTimeFunctionContext _localctx = new OffsetDateTimeFunctionContext(_ctx, getState());
		enterRule(_localctx, 356, RULE_offsetDateTimeFunction);
		try {
			setState(1955);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case OFFSET_DATETIME:
				enterOuterAlt(_localctx, 1);
				{
				setState(1948);
				match(OFFSET_DATETIME);
				setState(1951);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,212,_ctx) ) {
				case 1:
					{
					setState(1949);
					match(LEFT_PAREN);
					setState(1950);
					match(RIGHT_PAREN);
					}
					break;
				}
				}
				break;
			case OFFSET:
				enterOuterAlt(_localctx, 2);
				{
				setState(1953);
				match(OFFSET);
				setState(1954);
				match(DATETIME);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class LocalDateFunctionContext extends ParserRuleContext {
		public TerminalNode LOCAL_DATE() { return getToken(HqlParser.LOCAL_DATE, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode LOCAL() { return getToken(HqlParser.LOCAL, 0); }
		public TerminalNode DATE() { return getToken(HqlParser.DATE, 0); }
		public LocalDateFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_localDateFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterLocalDateFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitLocalDateFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitLocalDateFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final LocalDateFunctionContext localDateFunction() throws RecognitionException {
		LocalDateFunctionContext _localctx = new LocalDateFunctionContext(_ctx, getState());
		enterRule(_localctx, 358, RULE_localDateFunction);
		try {
			setState(1964);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case LOCAL_DATE:
				enterOuterAlt(_localctx, 1);
				{
				setState(1957);
				match(LOCAL_DATE);
				setState(1960);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,214,_ctx) ) {
				case 1:
					{
					setState(1958);
					match(LEFT_PAREN);
					setState(1959);
					match(RIGHT_PAREN);
					}
					break;
				}
				}
				break;
			case LOCAL:
				enterOuterAlt(_localctx, 2);
				{
				setState(1962);
				match(LOCAL);
				setState(1963);
				match(DATE);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class LocalTimeFunctionContext extends ParserRuleContext {
		public TerminalNode LOCAL_TIME() { return getToken(HqlParser.LOCAL_TIME, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode LOCAL() { return getToken(HqlParser.LOCAL, 0); }
		public TerminalNode TIME() { return getToken(HqlParser.TIME, 0); }
		public LocalTimeFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_localTimeFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterLocalTimeFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitLocalTimeFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitLocalTimeFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final LocalTimeFunctionContext localTimeFunction() throws RecognitionException {
		LocalTimeFunctionContext _localctx = new LocalTimeFunctionContext(_ctx, getState());
		enterRule(_localctx, 360, RULE_localTimeFunction);
		try {
			setState(1973);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case LOCAL_TIME:
				enterOuterAlt(_localctx, 1);
				{
				setState(1966);
				match(LOCAL_TIME);
				setState(1969);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,216,_ctx) ) {
				case 1:
					{
					setState(1967);
					match(LEFT_PAREN);
					setState(1968);
					match(RIGHT_PAREN);
					}
					break;
				}
				}
				break;
			case LOCAL:
				enterOuterAlt(_localctx, 2);
				{
				setState(1971);
				match(LOCAL);
				setState(1972);
				match(TIME);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class FormatFunctionContext extends ParserRuleContext {
		public TerminalNode FORMAT() { return getToken(HqlParser.FORMAT, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode AS() { return getToken(HqlParser.AS, 0); }
		public FormatContext format() {
			return getRuleContext(FormatContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public FormatFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_formatFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterFormatFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitFormatFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitFormatFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final FormatFunctionContext formatFunction() throws RecognitionException {
		FormatFunctionContext _localctx = new FormatFunctionContext(_ctx, getState());
		enterRule(_localctx, 362, RULE_formatFunction);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1975);
			match(FORMAT);
			setState(1976);
			match(LEFT_PAREN);
			setState(1977);
			expression(0);
			setState(1978);
			match(AS);
			setState(1979);
			format();
			setState(1980);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class FormatContext extends ParserRuleContext {
		public TerminalNode STRING_LITERAL() { return getToken(HqlParser.STRING_LITERAL, 0); }
		public FormatContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_format; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterFormat(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitFormat(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitFormat(this);
			else return visitor.visitChildren(this);
		}
	}

	public final FormatContext format() throws RecognitionException {
		FormatContext _localctx = new FormatContext(_ctx, getState());
		enterRule(_localctx, 364, RULE_format);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1982);
			match(STRING_LITERAL);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class ExtractFunctionContext extends ParserRuleContext {
		public TerminalNode EXTRACT() { return getToken(HqlParser.EXTRACT, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public ExtractFieldContext extractField() {
			return getRuleContext(ExtractFieldContext.class,0);
		}
		public TerminalNode FROM() { return getToken(HqlParser.FROM, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public DatetimeFieldContext datetimeField() {
			return getRuleContext(DatetimeFieldContext.class,0);
		}
		public ExtractFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_extractFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterExtractFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitExtractFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitExtractFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ExtractFunctionContext extractFunction() throws RecognitionException {
		ExtractFunctionContext _localctx = new ExtractFunctionContext(_ctx, getState());
		enterRule(_localctx, 366, RULE_extractFunction);
		try {
			setState(1996);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case EXTRACT:
				enterOuterAlt(_localctx, 1);
				{
				setState(1984);
				match(EXTRACT);
				setState(1985);
				match(LEFT_PAREN);
				setState(1986);
				extractField();
				setState(1987);
				match(FROM);
				setState(1988);
				expression(0);
				setState(1989);
				match(RIGHT_PAREN);
				}
				break;
			case DAY:
			case EPOCH:
			case HOUR:
			case MINUTE:
			case MONTH:
			case NANOSECOND:
			case QUARTER:
			case SECOND:
			case WEEK:
			case YEAR:
				enterOuterAlt(_localctx, 2);
				{
				setState(1991);
				datetimeField();
				setState(1992);
				match(LEFT_PAREN);
				setState(1993);
				expression(0);
				setState(1994);
				match(RIGHT_PAREN);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class TruncFunctionContext extends ParserRuleContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public List<ExpressionContext> expression() {
			return getRuleContexts(ExpressionContext.class);
		}
		public ExpressionContext expression(int i) {
			return getRuleContext(ExpressionContext.class,i);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode TRUNC() { return getToken(HqlParser.TRUNC, 0); }
		public TerminalNode TRUNCATE() { return getToken(HqlParser.TRUNCATE, 0); }
		public TerminalNode COMMA() { return getToken(HqlParser.COMMA, 0); }
		public DatetimeFieldContext datetimeField() {
			return getRuleContext(DatetimeFieldContext.class,0);
		}
		public TruncFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_truncFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterTruncFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitTruncFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitTruncFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final TruncFunctionContext truncFunction() throws RecognitionException {
		TruncFunctionContext _localctx = new TruncFunctionContext(_ctx, getState());
		enterRule(_localctx, 368, RULE_truncFunction);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1998);
			_la = _input.LA(1);
			if ( !(_la==TRUNC || _la==TRUNCATE) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			setState(1999);
			match(LEFT_PAREN);
			setState(2000);
			expression(0);
			setState(2006);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==COMMA) {
				{
				setState(2001);
				match(COMMA);
				setState(2004);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,219,_ctx) ) {
				case 1:
					{
					setState(2002);
					datetimeField();
					}
					break;
				case 2:
					{
					setState(2003);
					expression(0);
					}
					break;
				}
				}
			}

			setState(2008);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class ExtractFieldContext extends ParserRuleContext {
		public DatetimeFieldContext datetimeField() {
			return getRuleContext(DatetimeFieldContext.class,0);
		}
		public DayFieldContext dayField() {
			return getRuleContext(DayFieldContext.class,0);
		}
		public WeekFieldContext weekField() {
			return getRuleContext(WeekFieldContext.class,0);
		}
		public TimeZoneFieldContext timeZoneField() {
			return getRuleContext(TimeZoneFieldContext.class,0);
		}
		public DateOrTimeFieldContext dateOrTimeField() {
			return getRuleContext(DateOrTimeFieldContext.class,0);
		}
		public ExtractFieldContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_extractField; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterExtractField(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitExtractField(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitExtractField(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ExtractFieldContext extractField() throws RecognitionException {
		ExtractFieldContext _localctx = new ExtractFieldContext(_ctx, getState());
		enterRule(_localctx, 370, RULE_extractField);
		try {
			setState(2015);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,221,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(2010);
				datetimeField();
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(2011);
				dayField();
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(2012);
				weekField();
				}
				break;
			case 4:
				enterOuterAlt(_localctx, 4);
				{
				setState(2013);
				timeZoneField();
				}
				break;
			case 5:
				enterOuterAlt(_localctx, 5);
				{
				setState(2014);
				dateOrTimeField();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class DatetimeFieldContext extends ParserRuleContext {
		public TerminalNode YEAR() { return getToken(HqlParser.YEAR, 0); }
		public TerminalNode MONTH() { return getToken(HqlParser.MONTH, 0); }
		public TerminalNode DAY() { return getToken(HqlParser.DAY, 0); }
		public TerminalNode WEEK() { return getToken(HqlParser.WEEK, 0); }
		public TerminalNode QUARTER() { return getToken(HqlParser.QUARTER, 0); }
		public TerminalNode HOUR() { return getToken(HqlParser.HOUR, 0); }
		public TerminalNode MINUTE() { return getToken(HqlParser.MINUTE, 0); }
		public TerminalNode SECOND() { return getToken(HqlParser.SECOND, 0); }
		public TerminalNode NANOSECOND() { return getToken(HqlParser.NANOSECOND, 0); }
		public TerminalNode EPOCH() { return getToken(HqlParser.EPOCH, 0); }
		public DatetimeFieldContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_datetimeField; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterDatetimeField(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitDatetimeField(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitDatetimeField(this);
			else return visitor.visitChildren(this);
		}
	}

	public final DatetimeFieldContext datetimeField() throws RecognitionException {
		DatetimeFieldContext _localctx = new DatetimeFieldContext(_ctx, getState());
		enterRule(_localctx, 372, RULE_datetimeField);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(2017);
			_la = _input.LA(1);
			if ( !(((((_la - 71)) & ~0x3f) == 0 && ((1L << (_la - 71)) & ((1L << (DAY - 71)) | (1L << (EPOCH - 71)) | (1L << (HOUR - 71)))) != 0) || ((((_la - 140)) & ~0x3f) == 0 && ((1L << (_la - 140)) & ((1L << (MINUTE - 140)) | (1L << (MONTH - 140)) | (1L << (NANOSECOND - 140)) | (1L << (QUARTER - 140)) | (1L << (SECOND - 140)) | (1L << (WEEK - 140)))) != 0) || _la==YEAR) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class DayFieldContext extends ParserRuleContext {
		public TerminalNode DAY() { return getToken(HqlParser.DAY, 0); }
		public TerminalNode OF() { return getToken(HqlParser.OF, 0); }
		public TerminalNode MONTH() { return getToken(HqlParser.MONTH, 0); }
		public TerminalNode WEEK() { return getToken(HqlParser.WEEK, 0); }
		public TerminalNode YEAR() { return getToken(HqlParser.YEAR, 0); }
		public DayFieldContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_dayField; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterDayField(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitDayField(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitDayField(this);
			else return visitor.visitChildren(this);
		}
	}

	public final DayFieldContext dayField() throws RecognitionException {
		DayFieldContext _localctx = new DayFieldContext(_ctx, getState());
		enterRule(_localctx, 374, RULE_dayField);
		try {
			setState(2028);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,222,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(2019);
				match(DAY);
				setState(2020);
				match(OF);
				setState(2021);
				match(MONTH);
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(2022);
				match(DAY);
				setState(2023);
				match(OF);
				setState(2024);
				match(WEEK);
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(2025);
				match(DAY);
				setState(2026);
				match(OF);
				setState(2027);
				match(YEAR);
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class WeekFieldContext extends ParserRuleContext {
		public TerminalNode WEEK() { return getToken(HqlParser.WEEK, 0); }
		public TerminalNode OF() { return getToken(HqlParser.OF, 0); }
		public TerminalNode MONTH() { return getToken(HqlParser.MONTH, 0); }
		public TerminalNode YEAR() { return getToken(HqlParser.YEAR, 0); }
		public WeekFieldContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_weekField; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterWeekField(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitWeekField(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitWeekField(this);
			else return visitor.visitChildren(this);
		}
	}

	public final WeekFieldContext weekField() throws RecognitionException {
		WeekFieldContext _localctx = new WeekFieldContext(_ctx, getState());
		enterRule(_localctx, 376, RULE_weekField);
		try {
			setState(2036);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,223,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(2030);
				match(WEEK);
				setState(2031);
				match(OF);
				setState(2032);
				match(MONTH);
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(2033);
				match(WEEK);
				setState(2034);
				match(OF);
				setState(2035);
				match(YEAR);
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class TimeZoneFieldContext extends ParserRuleContext {
		public TerminalNode OFFSET() { return getToken(HqlParser.OFFSET, 0); }
		public TerminalNode HOUR() { return getToken(HqlParser.HOUR, 0); }
		public TerminalNode MINUTE() { return getToken(HqlParser.MINUTE, 0); }
		public TerminalNode TIMEZONE_HOUR() { return getToken(HqlParser.TIMEZONE_HOUR, 0); }
		public TerminalNode TIMEZONE_MINUTE() { return getToken(HqlParser.TIMEZONE_MINUTE, 0); }
		public TimeZoneFieldContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_timeZoneField; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterTimeZoneField(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitTimeZoneField(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitTimeZoneField(this);
			else return visitor.visitChildren(this);
		}
	}

	public final TimeZoneFieldContext timeZoneField() throws RecognitionException {
		TimeZoneFieldContext _localctx = new TimeZoneFieldContext(_ctx, getState());
		enterRule(_localctx, 378, RULE_timeZoneField);
		int _la;
		try {
			setState(2044);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case OFFSET:
				enterOuterAlt(_localctx, 1);
				{
				setState(2038);
				match(OFFSET);
				setState(2040);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==HOUR || _la==MINUTE) {
					{
					setState(2039);
					_la = _input.LA(1);
					if ( !(_la==HOUR || _la==MINUTE) ) {
					_errHandler.recoverInline(this);
					}
					else {
						if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
						_errHandler.reportMatch(this);
						consume();
					}
					}
				}

				}
				break;
			case TIMEZONE_HOUR:
				enterOuterAlt(_localctx, 2);
				{
				setState(2042);
				match(TIMEZONE_HOUR);
				}
				break;
			case TIMEZONE_MINUTE:
				enterOuterAlt(_localctx, 3);
				{
				setState(2043);
				match(TIMEZONE_MINUTE);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class DateOrTimeFieldContext extends ParserRuleContext {
		public TerminalNode DATE() { return getToken(HqlParser.DATE, 0); }
		public TerminalNode TIME() { return getToken(HqlParser.TIME, 0); }
		public DateOrTimeFieldContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_dateOrTimeField; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterDateOrTimeField(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitDateOrTimeField(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitDateOrTimeField(this);
			else return visitor.visitChildren(this);
		}
	}

	public final DateOrTimeFieldContext dateOrTimeField() throws RecognitionException {
		DateOrTimeFieldContext _localctx = new DateOrTimeFieldContext(_ctx, getState());
		enterRule(_localctx, 380, RULE_dateOrTimeField);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(2046);
			_la = _input.LA(1);
			if ( !(_la==DATE || _la==TIME) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class PositionFunctionContext extends ParserRuleContext {
		public TerminalNode POSITION() { return getToken(HqlParser.POSITION, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PositionFunctionPatternArgumentContext positionFunctionPatternArgument() {
			return getRuleContext(PositionFunctionPatternArgumentContext.class,0);
		}
		public TerminalNode IN() { return getToken(HqlParser.IN, 0); }
		public PositionFunctionStringArgumentContext positionFunctionStringArgument() {
			return getRuleContext(PositionFunctionStringArgumentContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public PositionFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_positionFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterPositionFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitPositionFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitPositionFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final PositionFunctionContext positionFunction() throws RecognitionException {
		PositionFunctionContext _localctx = new PositionFunctionContext(_ctx, getState());
		enterRule(_localctx, 382, RULE_positionFunction);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(2048);
			match(POSITION);
			setState(2049);
			match(LEFT_PAREN);
			setState(2050);
			positionFunctionPatternArgument();
			setState(2051);
			match(IN);
			setState(2052);
			positionFunctionStringArgument();
			setState(2053);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class PositionFunctionPatternArgumentContext extends ParserRuleContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public PositionFunctionPatternArgumentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_positionFunctionPatternArgument; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterPositionFunctionPatternArgument(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitPositionFunctionPatternArgument(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitPositionFunctionPatternArgument(this);
			else return visitor.visitChildren(this);
		}
	}

	public final PositionFunctionPatternArgumentContext positionFunctionPatternArgument() throws RecognitionException {
		PositionFunctionPatternArgumentContext _localctx = new PositionFunctionPatternArgumentContext(_ctx, getState());
		enterRule(_localctx, 384, RULE_positionFunctionPatternArgument);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(2055);
			expression(0);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class PositionFunctionStringArgumentContext extends ParserRuleContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public PositionFunctionStringArgumentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_positionFunctionStringArgument; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterPositionFunctionStringArgument(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitPositionFunctionStringArgument(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitPositionFunctionStringArgument(this);
			else return visitor.visitChildren(this);
		}
	}

	public final PositionFunctionStringArgumentContext positionFunctionStringArgument() throws RecognitionException {
		PositionFunctionStringArgumentContext _localctx = new PositionFunctionStringArgumentContext(_ctx, getState());
		enterRule(_localctx, 386, RULE_positionFunctionStringArgument);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(2057);
			expression(0);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class CubeContext extends ParserRuleContext {
		public TerminalNode CUBE() { return getToken(HqlParser.CUBE, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public List<ExpressionOrPredicateContext> expressionOrPredicate() {
			return getRuleContexts(ExpressionOrPredicateContext.class);
		}
		public ExpressionOrPredicateContext expressionOrPredicate(int i) {
			return getRuleContext(ExpressionOrPredicateContext.class,i);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public CubeContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_cube; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCube(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCube(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCube(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CubeContext cube() throws RecognitionException {
		CubeContext _localctx = new CubeContext(_ctx, getState());
		enterRule(_localctx, 388, RULE_cube);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(2059);
			match(CUBE);
			setState(2060);
			match(LEFT_PAREN);
			setState(2061);
			expressionOrPredicate();
			setState(2066);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(2062);
				match(COMMA);
				setState(2063);
				expressionOrPredicate();
				}
				}
				setState(2068);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			setState(2069);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class RollupContext extends ParserRuleContext {
		public TerminalNode ROLLUP() { return getToken(HqlParser.ROLLUP, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public List<ExpressionOrPredicateContext> expressionOrPredicate() {
			return getRuleContexts(ExpressionOrPredicateContext.class);
		}
		public ExpressionOrPredicateContext expressionOrPredicate(int i) {
			return getRuleContext(ExpressionOrPredicateContext.class,i);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public RollupContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_rollup; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterRollup(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitRollup(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitRollup(this);
			else return visitor.visitChildren(this);
		}
	}

	public final RollupContext rollup() throws RecognitionException {
		RollupContext _localctx = new RollupContext(_ctx, getState());
		enterRule(_localctx, 390, RULE_rollup);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(2071);
			match(ROLLUP);
			setState(2072);
			match(LEFT_PAREN);
			setState(2073);
			expressionOrPredicate();
			setState(2078);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(2074);
				match(COMMA);
				setState(2075);
				expressionOrPredicate();
				}
				}
				setState(2080);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			setState(2081);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class NakedIdentifierContext extends ParserRuleContext {
		public TerminalNode IDENTIFIER() { return getToken(HqlParser.IDENTIFIER, 0); }
		public TerminalNode QUOTED_IDENTIFIER() { return getToken(HqlParser.QUOTED_IDENTIFIER, 0); }
		public TerminalNode ALL() { return getToken(HqlParser.ALL, 0); }
		public TerminalNode AND() { return getToken(HqlParser.AND, 0); }
		public TerminalNode ANY() { return getToken(HqlParser.ANY, 0); }
		public TerminalNode AS() { return getToken(HqlParser.AS, 0); }
		public TerminalNode ASC() { return getToken(HqlParser.ASC, 0); }
		public TerminalNode AVG() { return getToken(HqlParser.AVG, 0); }
		public TerminalNode BETWEEN() { return getToken(HqlParser.BETWEEN, 0); }
		public TerminalNode BOTH() { return getToken(HqlParser.BOTH, 0); }
		public TerminalNode BREADTH() { return getToken(HqlParser.BREADTH, 0); }
		public TerminalNode BY() { return getToken(HqlParser.BY, 0); }
		public TerminalNode CASE() { return getToken(HqlParser.CASE, 0); }
		public TerminalNode CAST() { return getToken(HqlParser.CAST, 0); }
		public TerminalNode COLLATE() { return getToken(HqlParser.COLLATE, 0); }
		public TerminalNode COUNT() { return getToken(HqlParser.COUNT, 0); }
		public TerminalNode CROSS() { return getToken(HqlParser.CROSS, 0); }
		public TerminalNode CUBE() { return getToken(HqlParser.CUBE, 0); }
		public TerminalNode CURRENT() { return getToken(HqlParser.CURRENT, 0); }
		public TerminalNode CURRENT_DATE() { return getToken(HqlParser.CURRENT_DATE, 0); }
		public TerminalNode CURRENT_INSTANT() { return getToken(HqlParser.CURRENT_INSTANT, 0); }
		public TerminalNode CURRENT_TIME() { return getToken(HqlParser.CURRENT_TIME, 0); }
		public TerminalNode CURRENT_TIMESTAMP() { return getToken(HqlParser.CURRENT_TIMESTAMP, 0); }
		public TerminalNode CYCLE() { return getToken(HqlParser.CYCLE, 0); }
		public TerminalNode DATE() { return getToken(HqlParser.DATE, 0); }
		public TerminalNode DATETIME() { return getToken(HqlParser.DATETIME, 0); }
		public TerminalNode DAY() { return getToken(HqlParser.DAY, 0); }
		public TerminalNode DEFAULT() { return getToken(HqlParser.DEFAULT, 0); }
		public TerminalNode DELETE() { return getToken(HqlParser.DELETE, 0); }
		public TerminalNode DEPTH() { return getToken(HqlParser.DEPTH, 0); }
		public TerminalNode DESC() { return getToken(HqlParser.DESC, 0); }
		public TerminalNode DISTINCT() { return getToken(HqlParser.DISTINCT, 0); }
		public TerminalNode ELEMENT() { return getToken(HqlParser.ELEMENT, 0); }
		public TerminalNode ELEMENTS() { return getToken(HqlParser.ELEMENTS, 0); }
		public TerminalNode ELSE() { return getToken(HqlParser.ELSE, 0); }
		public TerminalNode EMPTY() { return getToken(HqlParser.EMPTY, 0); }
		public TerminalNode END() { return getToken(HqlParser.END, 0); }
		public TerminalNode ENTRY() { return getToken(HqlParser.ENTRY, 0); }
		public TerminalNode EPOCH() { return getToken(HqlParser.EPOCH, 0); }
		public TerminalNode ERROR() { return getToken(HqlParser.ERROR, 0); }
		public TerminalNode ESCAPE() { return getToken(HqlParser.ESCAPE, 0); }
		public TerminalNode EVERY() { return getToken(HqlParser.EVERY, 0); }
		public TerminalNode EXCEPT() { return getToken(HqlParser.EXCEPT, 0); }
		public TerminalNode EXCLUDE() { return getToken(HqlParser.EXCLUDE, 0); }
		public TerminalNode EXISTS() { return getToken(HqlParser.EXISTS, 0); }
		public TerminalNode EXTRACT() { return getToken(HqlParser.EXTRACT, 0); }
		public TerminalNode FETCH() { return getToken(HqlParser.FETCH, 0); }
		public TerminalNode FILTER() { return getToken(HqlParser.FILTER, 0); }
		public TerminalNode FIRST() { return getToken(HqlParser.FIRST, 0); }
		public TerminalNode FOLLOWING() { return getToken(HqlParser.FOLLOWING, 0); }
		public TerminalNode FOR() { return getToken(HqlParser.FOR, 0); }
		public TerminalNode FORMAT() { return getToken(HqlParser.FORMAT, 0); }
		public TerminalNode FROM() { return getToken(HqlParser.FROM, 0); }
		public TerminalNode FUNCTION() { return getToken(HqlParser.FUNCTION, 0); }
		public TerminalNode GROUP() { return getToken(HqlParser.GROUP, 0); }
		public TerminalNode GROUPS() { return getToken(HqlParser.GROUPS, 0); }
		public TerminalNode HAVING() { return getToken(HqlParser.HAVING, 0); }
		public TerminalNode HOUR() { return getToken(HqlParser.HOUR, 0); }
		public TerminalNode ID() { return getToken(HqlParser.ID, 0); }
		public TerminalNode IGNORE() { return getToken(HqlParser.IGNORE, 0); }
		public TerminalNode ILIKE() { return getToken(HqlParser.ILIKE, 0); }
		public TerminalNode IN() { return getToken(HqlParser.IN, 0); }
		public TerminalNode INDEX() { return getToken(HqlParser.INDEX, 0); }
		public TerminalNode INDICES() { return getToken(HqlParser.INDICES, 0); }
		public TerminalNode INSERT() { return getToken(HqlParser.INSERT, 0); }
		public TerminalNode INSTANT() { return getToken(HqlParser.INSTANT, 0); }
		public TerminalNode INTERSECT() { return getToken(HqlParser.INTERSECT, 0); }
		public TerminalNode INTO() { return getToken(HqlParser.INTO, 0); }
		public TerminalNode IS() { return getToken(HqlParser.IS, 0); }
		public TerminalNode JOIN() { return getToken(HqlParser.JOIN, 0); }
		public TerminalNode KEY() { return getToken(HqlParser.KEY, 0); }
		public TerminalNode LAST() { return getToken(HqlParser.LAST, 0); }
		public TerminalNode LEADING() { return getToken(HqlParser.LEADING, 0); }
		public TerminalNode LIKE() { return getToken(HqlParser.LIKE, 0); }
		public TerminalNode LIMIT() { return getToken(HqlParser.LIMIT, 0); }
		public TerminalNode LIST() { return getToken(HqlParser.LIST, 0); }
		public TerminalNode LISTAGG() { return getToken(HqlParser.LISTAGG, 0); }
		public TerminalNode LOCAL() { return getToken(HqlParser.LOCAL, 0); }
		public TerminalNode LOCAL_DATE() { return getToken(HqlParser.LOCAL_DATE, 0); }
		public TerminalNode LOCAL_DATETIME() { return getToken(HqlParser.LOCAL_DATETIME, 0); }
		public TerminalNode LOCAL_TIME() { return getToken(HqlParser.LOCAL_TIME, 0); }
		public TerminalNode MAP() { return getToken(HqlParser.MAP, 0); }
		public TerminalNode MATERIALIZED() { return getToken(HqlParser.MATERIALIZED, 0); }
		public TerminalNode MAX() { return getToken(HqlParser.MAX, 0); }
		public TerminalNode MAXELEMENT() { return getToken(HqlParser.MAXELEMENT, 0); }
		public TerminalNode MAXINDEX() { return getToken(HqlParser.MAXINDEX, 0); }
		public TerminalNode MEMBER() { return getToken(HqlParser.MEMBER, 0); }
		public TerminalNode MICROSECOND() { return getToken(HqlParser.MICROSECOND, 0); }
		public TerminalNode MILLISECOND() { return getToken(HqlParser.MILLISECOND, 0); }
		public TerminalNode MIN() { return getToken(HqlParser.MIN, 0); }
		public TerminalNode MINELEMENT() { return getToken(HqlParser.MINELEMENT, 0); }
		public TerminalNode MININDEX() { return getToken(HqlParser.MININDEX, 0); }
		public TerminalNode MINUTE() { return getToken(HqlParser.MINUTE, 0); }
		public TerminalNode MONTH() { return getToken(HqlParser.MONTH, 0); }
		public TerminalNode NANOSECOND() { return getToken(HqlParser.NANOSECOND, 0); }
		public TerminalNode NATURALID() { return getToken(HqlParser.NATURALID, 0); }
		public TerminalNode NEW() { return getToken(HqlParser.NEW, 0); }
		public TerminalNode NEXT() { return getToken(HqlParser.NEXT, 0); }
		public TerminalNode NO() { return getToken(HqlParser.NO, 0); }
		public TerminalNode NOT() { return getToken(HqlParser.NOT, 0); }
		public TerminalNode NULLS() { return getToken(HqlParser.NULLS, 0); }
		public TerminalNode OBJECT() { return getToken(HqlParser.OBJECT, 0); }
		public TerminalNode OF() { return getToken(HqlParser.OF, 0); }
		public TerminalNode OFFSET() { return getToken(HqlParser.OFFSET, 0); }
		public TerminalNode OFFSET_DATETIME() { return getToken(HqlParser.OFFSET_DATETIME, 0); }
		public TerminalNode ON() { return getToken(HqlParser.ON, 0); }
		public TerminalNode ONLY() { return getToken(HqlParser.ONLY, 0); }
		public TerminalNode OR() { return getToken(HqlParser.OR, 0); }
		public TerminalNode ORDER() { return getToken(HqlParser.ORDER, 0); }
		public TerminalNode OTHERS() { return getToken(HqlParser.OTHERS, 0); }
		public TerminalNode OVER() { return getToken(HqlParser.OVER, 0); }
		public TerminalNode OVERFLOW() { return getToken(HqlParser.OVERFLOW, 0); }
		public TerminalNode OVERLAY() { return getToken(HqlParser.OVERLAY, 0); }
		public TerminalNode PAD() { return getToken(HqlParser.PAD, 0); }
		public TerminalNode PARTITION() { return getToken(HqlParser.PARTITION, 0); }
		public TerminalNode PERCENT() { return getToken(HqlParser.PERCENT, 0); }
		public TerminalNode PLACING() { return getToken(HqlParser.PLACING, 0); }
		public TerminalNode POSITION() { return getToken(HqlParser.POSITION, 0); }
		public TerminalNode PRECEDING() { return getToken(HqlParser.PRECEDING, 0); }
		public TerminalNode QUARTER() { return getToken(HqlParser.QUARTER, 0); }
		public TerminalNode RANGE() { return getToken(HqlParser.RANGE, 0); }
		public TerminalNode RESPECT() { return getToken(HqlParser.RESPECT, 0); }
		public TerminalNode ROLLUP() { return getToken(HqlParser.ROLLUP, 0); }
		public TerminalNode ROW() { return getToken(HqlParser.ROW, 0); }
		public TerminalNode ROWS() { return getToken(HqlParser.ROWS, 0); }
		public TerminalNode SEARCH() { return getToken(HqlParser.SEARCH, 0); }
		public TerminalNode SECOND() { return getToken(HqlParser.SECOND, 0); }
		public TerminalNode SELECT() { return getToken(HqlParser.SELECT, 0); }
		public TerminalNode SET() { return getToken(HqlParser.SET, 0); }
		public TerminalNode SIZE() { return getToken(HqlParser.SIZE, 0); }
		public TerminalNode SOME() { return getToken(HqlParser.SOME, 0); }
		public TerminalNode SUBSTRING() { return getToken(HqlParser.SUBSTRING, 0); }
		public TerminalNode SUM() { return getToken(HqlParser.SUM, 0); }
		public TerminalNode THEN() { return getToken(HqlParser.THEN, 0); }
		public TerminalNode TIES() { return getToken(HqlParser.TIES, 0); }
		public TerminalNode TIME() { return getToken(HqlParser.TIME, 0); }
		public TerminalNode TIMESTAMP() { return getToken(HqlParser.TIMESTAMP, 0); }
		public TerminalNode TIMEZONE_HOUR() { return getToken(HqlParser.TIMEZONE_HOUR, 0); }
		public TerminalNode TIMEZONE_MINUTE() { return getToken(HqlParser.TIMEZONE_MINUTE, 0); }
		public TerminalNode TO() { return getToken(HqlParser.TO, 0); }
		public TerminalNode TRAILING() { return getToken(HqlParser.TRAILING, 0); }
		public TerminalNode TREAT() { return getToken(HqlParser.TREAT, 0); }
		public TerminalNode TRIM() { return getToken(HqlParser.TRIM, 0); }
		public TerminalNode TRUNC() { return getToken(HqlParser.TRUNC, 0); }
		public TerminalNode TRUNCATE() { return getToken(HqlParser.TRUNCATE, 0); }
		public TerminalNode TYPE() { return getToken(HqlParser.TYPE, 0); }
		public TerminalNode UNBOUNDED() { return getToken(HqlParser.UNBOUNDED, 0); }
		public TerminalNode UNION() { return getToken(HqlParser.UNION, 0); }
		public TerminalNode UPDATE() { return getToken(HqlParser.UPDATE, 0); }
		public TerminalNode USING() { return getToken(HqlParser.USING, 0); }
		public TerminalNode VALUE() { return getToken(HqlParser.VALUE, 0); }
		public TerminalNode VALUES() { return getToken(HqlParser.VALUES, 0); }
		public TerminalNode VERSION() { return getToken(HqlParser.VERSION, 0); }
		public TerminalNode VERSIONED() { return getToken(HqlParser.VERSIONED, 0); }
		public TerminalNode WEEK() { return getToken(HqlParser.WEEK, 0); }
		public TerminalNode WHEN() { return getToken(HqlParser.WHEN, 0); }
		public TerminalNode WHERE() { return getToken(HqlParser.WHERE, 0); }
		public TerminalNode WITH() { return getToken(HqlParser.WITH, 0); }
		public TerminalNode WITHIN() { return getToken(HqlParser.WITHIN, 0); }
		public TerminalNode WITHOUT() { return getToken(HqlParser.WITHOUT, 0); }
		public TerminalNode YEAR() { return getToken(HqlParser.YEAR, 0); }
		public NakedIdentifierContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_nakedIdentifier; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterNakedIdentifier(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitNakedIdentifier(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitNakedIdentifier(this);
			else return visitor.visitChildren(this);
		}
	}

	public final NakedIdentifierContext nakedIdentifier() throws RecognitionException {
		NakedIdentifierContext _localctx = new NakedIdentifierContext(_ctx, getState());
		enterRule(_localctx, 392, RULE_nakedIdentifier);
		int _la;
		try {
			setState(2087);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case IDENTIFIER:
				enterOuterAlt(_localctx, 1);
				{
				setState(2083);
				match(IDENTIFIER);
				}
				break;
			case QUOTED_IDENTIFIER:
				enterOuterAlt(_localctx, 2);
				{
				setState(2084);
				match(QUOTED_IDENTIFIER);
				}
				break;
			case ID:
			case VERSION:
			case VERSIONED:
			case NATURALID:
			case ALL:
			case AND:
			case ANY:
			case AS:
			case ASC:
			case AVG:
			case BETWEEN:
			case BOTH:
			case BREADTH:
			case BY:
			case CASE:
			case CAST:
			case COLLATE:
			case COUNT:
			case CROSS:
			case CUBE:
			case CURRENT:
			case CURRENT_DATE:
			case CURRENT_INSTANT:
			case CURRENT_TIME:
			case CURRENT_TIMESTAMP:
			case CYCLE:
			case DATE:
			case DATETIME:
			case DAY:
			case DEFAULT:
			case DELETE:
			case DEPTH:
			case DESC:
			case DISTINCT:
			case ELEMENT:
			case ELEMENTS:
			case ELSE:
			case EMPTY:
			case END:
			case ENTRY:
			case EPOCH:
			case ERROR:
			case ESCAPE:
			case EVERY:
			case EXCEPT:
			case EXCLUDE:
			case EXISTS:
			case EXTRACT:
			case FETCH:
			case FILTER:
			case FIRST:
			case FOLLOWING:
			case FOR:
			case FORMAT:
			case FROM:
			case FUNCTION:
			case GROUP:
			case GROUPS:
			case HAVING:
			case HOUR:
			case IGNORE:
			case ILIKE:
			case IN:
			case INDEX:
			case INDICES:
			case INSERT:
			case INSTANT:
			case INTERSECT:
			case INTO:
			case IS:
			case JOIN:
			case KEY:
			case LAST:
			case LEADING:
			case LIKE:
			case LIMIT:
			case LIST:
			case LISTAGG:
			case LOCAL:
			case LOCAL_DATE:
			case LOCAL_DATETIME:
			case LOCAL_TIME:
			case MAP:
			case MATERIALIZED:
			case MAX:
			case MAXELEMENT:
			case MAXINDEX:
			case MEMBER:
			case MICROSECOND:
			case MILLISECOND:
			case MIN:
			case MINELEMENT:
			case MININDEX:
			case MINUTE:
			case MONTH:
			case NANOSECOND:
			case NEW:
			case NEXT:
			case NO:
			case NOT:
			case NULLS:
			case OBJECT:
			case OF:
			case OFFSET:
			case OFFSET_DATETIME:
			case ON:
			case ONLY:
			case OR:
			case ORDER:
			case OTHERS:
			case OVER:
			case OVERFLOW:
			case OVERLAY:
			case PAD:
			case PARTITION:
			case PERCENT:
			case PLACING:
			case POSITION:
			case PRECEDING:
			case QUARTER:
			case RANGE:
			case RESPECT:
			case ROLLUP:
			case ROW:
			case ROWS:
			case SEARCH:
			case SECOND:
			case SELECT:
			case SET:
			case SIZE:
			case SOME:
			case SUBSTRING:
			case SUM:
			case THEN:
			case TIES:
			case TIME:
			case TIMESTAMP:
			case TIMEZONE_HOUR:
			case TIMEZONE_MINUTE:
			case TO:
			case TRAILING:
			case TREAT:
			case TRIM:
			case TRUNC:
			case TRUNCATE:
			case TYPE:
			case UNBOUNDED:
			case UNION:
			case UPDATE:
			case USING:
			case VALUE:
			case VALUES:
			case WEEK:
			case WHEN:
			case WHERE:
			case WITH:
			case WITHIN:
			case WITHOUT:
			case YEAR:
				enterOuterAlt(_localctx, 3);
				{
				setState(2085);
				_la = _input.LA(1);
				if ( !(((((_la - 42)) & ~0x3f) == 0 && ((1L << (_la - 42)) & ((1L << (ID - 42)) | (1L << (VERSION - 42)) | (1L << (VERSIONED - 42)) | (1L << (NATURALID - 42)) | (1L << (ALL - 42)) | (1L << (AND - 42)) | (1L << (ANY - 42)) | (1L << (AS - 42)) | (1L << (ASC - 42)) | (1L << (AVG - 42)) | (1L << (BETWEEN - 42)) | (1L << (BOTH - 42)) | (1L << (BREADTH - 42)) | (1L << (BY - 42)) | (1L << (CASE - 42)) | (1L << (CAST - 42)) | (1L << (COLLATE - 42)) | (1L << (COUNT - 42)) | (1L << (CROSS - 42)) | (1L << (CUBE - 42)) | (1L << (CURRENT - 42)) | (1L << (CURRENT_DATE - 42)) | (1L << (CURRENT_INSTANT - 42)) | (1L << (CURRENT_TIME - 42)) | (1L << (CURRENT_TIMESTAMP - 42)) | (1L << (CYCLE - 42)) | (1L << (DATE - 42)) | (1L << (DATETIME - 42)) | (1L << (DAY - 42)) | (1L << (DEFAULT - 42)) | (1L << (DELETE - 42)) | (1L << (DEPTH - 42)) | (1L << (DESC - 42)) | (1L << (DISTINCT - 42)) | (1L << (ELEMENT - 42)) | (1L << (ELEMENTS - 42)) | (1L << (ELSE - 42)) | (1L << (EMPTY - 42)) | (1L << (END - 42)) | (1L << (ENTRY - 42)) | (1L << (EPOCH - 42)) | (1L << (ERROR - 42)) | (1L << (ESCAPE - 42)) | (1L << (EVERY - 42)) | (1L << (EXCEPT - 42)) | (1L << (EXCLUDE - 42)) | (1L << (EXISTS - 42)) | (1L << (EXTRACT - 42)) | (1L << (FETCH - 42)) | (1L << (FILTER - 42)) | (1L << (FIRST - 42)) | (1L << (FOLLOWING - 42)) | (1L << (FOR - 42)) | (1L << (FORMAT - 42)) | (1L << (FROM - 42)) | (1L << (FUNCTION - 42)) | (1L << (GROUP - 42)) | (1L << (GROUPS - 42)) | (1L << (HAVING - 42)) | (1L << (HOUR - 42)) | (1L << (IGNORE - 42)) | (1L << (ILIKE - 42)))) != 0) || ((((_la - 106)) & ~0x3f) == 0 && ((1L << (_la - 106)) & ((1L << (IN - 106)) | (1L << (INDEX - 106)) | (1L << (INDICES - 106)) | (1L << (INSERT - 106)) | (1L << (INSTANT - 106)) | (1L << (INTERSECT - 106)) | (1L << (INTO - 106)) | (1L << (IS - 106)) | (1L << (JOIN - 106)) | (1L << (KEY - 106)) | (1L << (LAST - 106)) | (1L << (LEADING - 106)) | (1L << (LIKE - 106)) | (1L << (LIMIT - 106)) | (1L << (LIST - 106)) | (1L << (LISTAGG - 106)) | (1L << (LOCAL - 106)) | (1L << (LOCAL_DATE - 106)) | (1L << (LOCAL_DATETIME - 106)) | (1L << (LOCAL_TIME - 106)) | (1L << (MAP - 106)) | (1L << (MATERIALIZED - 106)) | (1L << (MAX - 106)) | (1L << (MAXELEMENT - 106)) | (1L << (MAXINDEX - 106)) | (1L << (MEMBER - 106)) | (1L << (MICROSECOND - 106)) | (1L << (MILLISECOND - 106)) | (1L << (MIN - 106)) | (1L << (MINELEMENT - 106)) | (1L << (MININDEX - 106)) | (1L << (MINUTE - 106)) | (1L << (MONTH - 106)) | (1L << (NANOSECOND - 106)) | (1L << (NEW - 106)) | (1L << (NEXT - 106)) | (1L << (NO - 106)) | (1L << (NOT - 106)) | (1L << (NULLS - 106)) | (1L << (OBJECT - 106)) | (1L << (OF - 106)) | (1L << (OFFSET - 106)) | (1L << (OFFSET_DATETIME - 106)) | (1L << (ON - 106)) | (1L << (ONLY - 106)) | (1L << (OR - 106)) | (1L << (ORDER - 106)) | (1L << (OTHERS - 106)) | (1L << (OVER - 106)) | (1L << (OVERFLOW - 106)) | (1L << (OVERLAY - 106)) | (1L << (PAD - 106)) | (1L << (PARTITION - 106)) | (1L << (PERCENT - 106)) | (1L << (PLACING - 106)) | (1L << (POSITION - 106)) | (1L << (PRECEDING - 106)) | (1L << (QUARTER - 106)) | (1L << (RANGE - 106)) | (1L << (RESPECT - 106)))) != 0) || ((((_la - 171)) & ~0x3f) == 0 && ((1L << (_la - 171)) & ((1L << (ROLLUP - 171)) | (1L << (ROW - 171)) | (1L << (ROWS - 171)) | (1L << (SEARCH - 171)) | (1L << (SECOND - 171)) | (1L << (SELECT - 171)) | (1L << (SET - 171)) | (1L << (SIZE - 171)) | (1L << (SOME - 171)) | (1L << (SUBSTRING - 171)) | (1L << (SUM - 171)) | (1L << (THEN - 171)) | (1L << (TIES - 171)) | (1L << (TIME - 171)) | (1L << (TIMESTAMP - 171)) | (1L << (TIMEZONE_HOUR - 171)) | (1L << (TIMEZONE_MINUTE - 171)) | (1L << (TO - 171)) | (1L << (TRAILING - 171)) | (1L << (TREAT - 171)) | (1L << (TRIM - 171)) | (1L << (TRUNC - 171)) | (1L << (TRUNCATE - 171)) | (1L << (TYPE - 171)) | (1L << (UNBOUNDED - 171)) | (1L << (UNION - 171)) | (1L << (UPDATE - 171)) | (1L << (USING - 171)) | (1L << (VALUE - 171)) | (1L << (VALUES - 171)) | (1L << (WEEK - 171)) | (1L << (WHEN - 171)) | (1L << (WHERE - 171)) | (1L << (WITH - 171)) | (1L << (WITHIN - 171)) | (1L << (WITHOUT - 171)) | (1L << (YEAR - 171)))) != 0)) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}

						logUseOfReservedWordAsIdentifier( getCurrentToken() );
					
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public static class IdentifierContext extends ParserRuleContext {
		public NakedIdentifierContext nakedIdentifier() {
			return getRuleContext(NakedIdentifierContext.class,0);
		}
		public TerminalNode FULL() { return getToken(HqlParser.FULL, 0); }
		public TerminalNode INNER() { return getToken(HqlParser.INNER, 0); }
		public TerminalNode LEFT() { return getToken(HqlParser.LEFT, 0); }
		public TerminalNode OUTER() { return getToken(HqlParser.OUTER, 0); }
		public TerminalNode RIGHT() { return getToken(HqlParser.RIGHT, 0); }
		public IdentifierContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_identifier; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterIdentifier(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitIdentifier(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitIdentifier(this);
			else return visitor.visitChildren(this);
		}
	}

	public final IdentifierContext identifier() throws RecognitionException {
		IdentifierContext _localctx = new IdentifierContext(_ctx, getState());
		enterRule(_localctx, 394, RULE_identifier);
		int _la;
		try {
			setState(2092);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case ID:
			case VERSION:
			case VERSIONED:
			case NATURALID:
			case ALL:
			case AND:
			case ANY:
			case AS:
			case ASC:
			case AVG:
			case BETWEEN:
			case BOTH:
			case BREADTH:
			case BY:
			case CASE:
			case CAST:
			case COLLATE:
			case COUNT:
			case CROSS:
			case CUBE:
			case CURRENT:
			case CURRENT_DATE:
			case CURRENT_INSTANT:
			case CURRENT_TIME:
			case CURRENT_TIMESTAMP:
			case CYCLE:
			case DATE:
			case DATETIME:
			case DAY:
			case DEFAULT:
			case DELETE:
			case DEPTH:
			case DESC:
			case DISTINCT:
			case ELEMENT:
			case ELEMENTS:
			case ELSE:
			case EMPTY:
			case END:
			case ENTRY:
			case EPOCH:
			case ERROR:
			case ESCAPE:
			case EVERY:
			case EXCEPT:
			case EXCLUDE:
			case EXISTS:
			case EXTRACT:
			case FETCH:
			case FILTER:
			case FIRST:
			case FOLLOWING:
			case FOR:
			case FORMAT:
			case FROM:
			case FUNCTION:
			case GROUP:
			case GROUPS:
			case HAVING:
			case HOUR:
			case IGNORE:
			case ILIKE:
			case IN:
			case INDEX:
			case INDICES:
			case INSERT:
			case INSTANT:
			case INTERSECT:
			case INTO:
			case IS:
			case JOIN:
			case KEY:
			case LAST:
			case LEADING:
			case LIKE:
			case LIMIT:
			case LIST:
			case LISTAGG:
			case LOCAL:
			case LOCAL_DATE:
			case LOCAL_DATETIME:
			case LOCAL_TIME:
			case MAP:
			case MATERIALIZED:
			case MAX:
			case MAXELEMENT:
			case MAXINDEX:
			case MEMBER:
			case MICROSECOND:
			case MILLISECOND:
			case MIN:
			case MINELEMENT:
			case MININDEX:
			case MINUTE:
			case MONTH:
			case NANOSECOND:
			case NEW:
			case NEXT:
			case NO:
			case NOT:
			case NULLS:
			case OBJECT:
			case OF:
			case OFFSET:
			case OFFSET_DATETIME:
			case ON:
			case ONLY:
			case OR:
			case ORDER:
			case OTHERS:
			case OVER:
			case OVERFLOW:
			case OVERLAY:
			case PAD:
			case PARTITION:
			case PERCENT:
			case PLACING:
			case POSITION:
			case PRECEDING:
			case QUARTER:
			case RANGE:
			case RESPECT:
			case ROLLUP:
			case ROW:
			case ROWS:
			case SEARCH:
			case SECOND:
			case SELECT:
			case SET:
			case SIZE:
			case SOME:
			case SUBSTRING:
			case SUM:
			case THEN:
			case TIES:
			case TIME:
			case TIMESTAMP:
			case TIMEZONE_HOUR:
			case TIMEZONE_MINUTE:
			case TO:
			case TRAILING:
			case TREAT:
			case TRIM:
			case TRUNC:
			case TRUNCATE:
			case TYPE:
			case UNBOUNDED:
			case UNION:
			case UPDATE:
			case USING:
			case VALUE:
			case VALUES:
			case WEEK:
			case WHEN:
			case WHERE:
			case WITH:
			case WITHIN:
			case WITHOUT:
			case YEAR:
			case IDENTIFIER:
			case QUOTED_IDENTIFIER:
				enterOuterAlt(_localctx, 1);
				{
				setState(2089);
				nakedIdentifier();
				}
				break;
			case FULL:
			case INNER:
			case LEFT:
			case OUTER:
			case RIGHT:
				enterOuterAlt(_localctx, 2);
				{
				setState(2090);
				_la = _input.LA(1);
				if ( !(((((_la - 98)) & ~0x3f) == 0 && ((1L << (_la - 98)) & ((1L << (FULL - 98)) | (1L << (INNER - 98)) | (1L << (LEFT - 98)) | (1L << (OUTER - 98)))) != 0) || _la==RIGHT) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}

						logUseOfReservedWordAsIdentifier( getCurrentToken() );
					
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public boolean sempred(RuleContext _localctx, int ruleIndex, int predIndex) {
		switch (ruleIndex) {
		case 73:
			return predicate_sempred((PredicateContext)_localctx, predIndex);
		case 77:
			return expression_sempred((ExpressionContext)_localctx, predIndex);
		}
		return true;
	}
	private boolean predicate_sempred(PredicateContext _localctx, int predIndex) {
		switch (predIndex) {
		case 0:
			return precpred(_ctx, 3);
		case 1:
			return precpred(_ctx, 2);
		}
		return true;
	}
	private boolean expression_sempred(ExpressionContext _localctx, int predIndex) {
		switch (predIndex) {
		case 2:
			return precpred(_ctx, 3);
		case 3:
			return precpred(_ctx, 2);
		case 4:
			return precpred(_ctx, 1);
		case 5:
			return precpred(_ctx, 5);
		case 6:
			return precpred(_ctx, 4);
		}
		return true;
	}

	public static final String _serializedATN =
		"\u0004\u0001\u00d5\u082f\u0002\u0000\u0007\u0000\u0002\u0001\u0007\u0001"+
		"\u0002\u0002\u0007\u0002\u0002\u0003\u0007\u0003\u0002\u0004\u0007\u0004"+
		"\u0002\u0005\u0007\u0005\u0002\u0006\u0007\u0006\u0002\u0007\u0007\u0007"+
		"\u0002\b\u0007\b\u0002\t\u0007\t\u0002\n\u0007\n\u0002\u000b\u0007\u000b"+
		"\u0002\f\u0007\f\u0002\r\u0007\r\u0002\u000e\u0007\u000e\u0002\u000f\u0007"+
		"\u000f\u0002\u0010\u0007\u0010\u0002\u0011\u0007\u0011\u0002\u0012\u0007"+
		"\u0012\u0002\u0013\u0007\u0013\u0002\u0014\u0007\u0014\u0002\u0015\u0007"+
		"\u0015\u0002\u0016\u0007\u0016\u0002\u0017\u0007\u0017\u0002\u0018\u0007"+
		"\u0018\u0002\u0019\u0007\u0019\u0002\u001a\u0007\u001a\u0002\u001b\u0007"+
		"\u001b\u0002\u001c\u0007\u001c\u0002\u001d\u0007\u001d\u0002\u001e\u0007"+
		"\u001e\u0002\u001f\u0007\u001f\u0002 \u0007 \u0002!\u0007!\u0002\"\u0007"+
		"\"\u0002#\u0007#\u0002$\u0007$\u0002%\u0007%\u0002&\u0007&\u0002\'\u0007"+
		"\'\u0002(\u0007(\u0002)\u0007)\u0002*\u0007*\u0002+\u0007+\u0002,\u0007"+
		",\u0002-\u0007-\u0002.\u0007.\u0002/\u0007/\u00020\u00070\u00021\u0007"+
		"1\u00022\u00072\u00023\u00073\u00024\u00074\u00025\u00075\u00026\u0007"+
		"6\u00027\u00077\u00028\u00078\u00029\u00079\u0002:\u0007:\u0002;\u0007"+
		";\u0002<\u0007<\u0002=\u0007=\u0002>\u0007>\u0002?\u0007?\u0002@\u0007"+
		"@\u0002A\u0007A\u0002B\u0007B\u0002C\u0007C\u0002D\u0007D\u0002E\u0007"+
		"E\u0002F\u0007F\u0002G\u0007G\u0002H\u0007H\u0002I\u0007I\u0002J\u0007"+
		"J\u0002K\u0007K\u0002L\u0007L\u0002M\u0007M\u0002N\u0007N\u0002O\u0007"+
		"O\u0002P\u0007P\u0002Q\u0007Q\u0002R\u0007R\u0002S\u0007S\u0002T\u0007"+
		"T\u0002U\u0007U\u0002V\u0007V\u0002W\u0007W\u0002X\u0007X\u0002Y\u0007"+
		"Y\u0002Z\u0007Z\u0002[\u0007[\u0002\\\u0007\\\u0002]\u0007]\u0002^\u0007"+
		"^\u0002_\u0007_\u0002`\u0007`\u0002a\u0007a\u0002b\u0007b\u0002c\u0007"+
		"c\u0002d\u0007d\u0002e\u0007e\u0002f\u0007f\u0002g\u0007g\u0002h\u0007"+
		"h\u0002i\u0007i\u0002j\u0007j\u0002k\u0007k\u0002l\u0007l\u0002m\u0007"+
		"m\u0002n\u0007n\u0002o\u0007o\u0002p\u0007p\u0002q\u0007q\u0002r\u0007"+
		"r\u0002s\u0007s\u0002t\u0007t\u0002u\u0007u\u0002v\u0007v\u0002w\u0007"+
		"w\u0002x\u0007x\u0002y\u0007y\u0002z\u0007z\u0002{\u0007{\u0002|\u0007"+
		"|\u0002}\u0007}\u0002~\u0007~\u0002\u007f\u0007\u007f\u0002\u0080\u0007"+
		"\u0080\u0002\u0081\u0007\u0081\u0002\u0082\u0007\u0082\u0002\u0083\u0007"+
		"\u0083\u0002\u0084\u0007\u0084\u0002\u0085\u0007\u0085\u0002\u0086\u0007"+
		"\u0086\u0002\u0087\u0007\u0087\u0002\u0088\u0007\u0088\u0002\u0089\u0007"+
		"\u0089\u0002\u008a\u0007\u008a\u0002\u008b\u0007\u008b\u0002\u008c\u0007"+
		"\u008c\u0002\u008d\u0007\u008d\u0002\u008e\u0007\u008e\u0002\u008f\u0007"+
		"\u008f\u0002\u0090\u0007\u0090\u0002\u0091\u0007\u0091\u0002\u0092\u0007"+
		"\u0092\u0002\u0093\u0007\u0093\u0002\u0094\u0007\u0094\u0002\u0095\u0007"+
		"\u0095\u0002\u0096\u0007\u0096\u0002\u0097\u0007\u0097\u0002\u0098\u0007"+
		"\u0098\u0002\u0099\u0007\u0099\u0002\u009a\u0007\u009a\u0002\u009b\u0007"+
		"\u009b\u0002\u009c\u0007\u009c\u0002\u009d\u0007\u009d\u0002\u009e\u0007"+
		"\u009e\u0002\u009f\u0007\u009f\u0002\u00a0\u0007\u00a0\u0002\u00a1\u0007"+
		"\u00a1\u0002\u00a2\u0007\u00a2\u0002\u00a3\u0007\u00a3\u0002\u00a4\u0007"+
		"\u00a4\u0002\u00a5\u0007\u00a5\u0002\u00a6\u0007\u00a6\u0002\u00a7\u0007"+
		"\u00a7\u0002\u00a8\u0007\u00a8\u0002\u00a9\u0007\u00a9\u0002\u00aa\u0007"+
		"\u00aa\u0002\u00ab\u0007\u00ab\u0002\u00ac\u0007\u00ac\u0002\u00ad\u0007"+
		"\u00ad\u0002\u00ae\u0007\u00ae\u0002\u00af\u0007\u00af\u0002\u00b0\u0007"+
		"\u00b0\u0002\u00b1\u0007\u00b1\u0002\u00b2\u0007\u00b2\u0002\u00b3\u0007"+
		"\u00b3\u0002\u00b4\u0007\u00b4\u0002\u00b5\u0007\u00b5\u0002\u00b6\u0007"+
		"\u00b6\u0002\u00b7\u0007\u00b7\u0002\u00b8\u0007\u00b8\u0002\u00b9\u0007"+
		"\u00b9\u0002\u00ba\u0007\u00ba\u0002\u00bb\u0007\u00bb\u0002\u00bc\u0007"+
		"\u00bc\u0002\u00bd\u0007\u00bd\u0002\u00be\u0007\u00be\u0002\u00bf\u0007"+
		"\u00bf\u0002\u00c0\u0007\u00c0\u0002\u00c1\u0007\u00c1\u0002\u00c2\u0007"+
		"\u00c2\u0002\u00c3\u0007\u00c3\u0002\u00c4\u0007\u00c4\u0002\u00c5\u0007"+
		"\u00c5\u0001\u0000\u0001\u0000\u0001\u0000\u0001\u0000\u0003\u0000\u0191"+
		"\b\u0000\u0001\u0000\u0001\u0000\u0001\u0001\u0001\u0001\u0001\u0002\u0001"+
		"\u0002\u0001\u0003\u0001\u0003\u0003\u0003\u019b\b\u0003\u0001\u0004\u0001"+
		"\u0004\u0003\u0004\u019f\b\u0004\u0001\u0004\u0001\u0004\u0003\u0004\u01a3"+
		"\b\u0004\u0001\u0005\u0001\u0005\u0003\u0005\u01a7\b\u0005\u0001\u0005"+
		"\u0001\u0005\u0001\u0005\u0003\u0005\u01ac\b\u0005\u0001\u0006\u0001\u0006"+
		"\u0001\u0006\u0001\u0006\u0005\u0006\u01b2\b\u0006\n\u0006\f\u0006\u01b5"+
		"\t\u0006\u0001\u0007\u0001\u0007\u0001\u0007\u0001\u0007\u0001\b\u0001"+
		"\b\u0003\b\u01bd\b\b\u0001\b\u0001\b\u0001\b\u0001\b\u0003\b\u01c3\b\b"+
		"\u0001\t\u0001\t\u0001\t\u0001\t\u0005\t\u01c9\b\t\n\t\f\t\u01cc\t\t\u0001"+
		"\t\u0001\t\u0001\n\u0001\n\u0001\n\u0001\n\u0005\n\u01d4\b\n\n\n\f\n\u01d7"+
		"\t\n\u0001\u000b\u0001\u000b\u0001\u000b\u0001\u000b\u0005\u000b\u01dd"+
		"\b\u000b\n\u000b\f\u000b\u01e0\t\u000b\u0001\u000b\u0001\u000b\u0001\f"+
		"\u0001\f\u0001\f\u0001\f\u0005\f\u01e8\b\f\n\f\f\f\u01eb\t\f\u0001\r\u0001"+
		"\r\u0001\r\u0003\r\u01f0\b\r\u0001\r\u0003\r\u01f3\b\r\u0001\r\u0001\r"+
		"\u0001\r\u0001\r\u0003\r\u01f9\b\r\u0001\r\u0003\r\u01fc\b\r\u0001\u000e"+
		"\u0001\u000e\u0001\u000e\u0005\u000e\u0201\b\u000e\n\u000e\f\u000e\u0204"+
		"\t\u000e\u0001\u000f\u0001\u000f\u0001\u000f\u0001\u000f\u0001\u000f\u0001"+
		"\u000f\u0001\u000f\u0001\u000f\u0001\u0010\u0001\u0010\u0001\u0010\u0005"+
		"\u0010\u0211\b\u0010\n\u0010\f\u0010\u0214\t\u0010\u0001\u0011\u0001\u0011"+
		"\u0003\u0011\u0218\b\u0011\u0001\u0011\u0003\u0011\u021b\b\u0011\u0001"+
		"\u0012\u0001\u0012\u0001\u0012\u0001\u0012\u0001\u0012\u0001\u0012\u0001"+
		"\u0012\u0001\u0012\u0001\u0012\u0003\u0012\u0226\b\u0012\u0001\u0012\u0001"+
		"\u0012\u0003\u0012\u022a\b\u0012\u0001\u0013\u0003\u0013\u022d\b\u0013"+
		"\u0001\u0013\u0001\u0013\u0003\u0013\u0231\b\u0013\u0001\u0013\u0001\u0013"+
		"\u0001\u0013\u0001\u0013\u0004\u0013\u0237\b\u0013\u000b\u0013\f\u0013"+
		"\u0238\u0003\u0013\u023b\b\u0013\u0001\u0014\u0001\u0014\u0003\u0014\u023f"+
		"\b\u0014\u0001\u0014\u0001\u0014\u0001\u0014\u0001\u0014\u0003\u0014\u0245"+
		"\b\u0014\u0003\u0014\u0247\b\u0014\u0001\u0015\u0001\u0015\u0003\u0015"+
		"\u024b\b\u0015\u0001\u0015\u0001\u0015\u0003\u0015\u024f\b\u0015\u0001"+
		"\u0015\u0001\u0015\u0003\u0015\u0253\b\u0015\u0003\u0015\u0255\b\u0015"+
		"\u0001\u0016\u0001\u0016\u0003\u0016\u0259\b\u0016\u0001\u0016\u0003\u0016"+
		"\u025c\b\u0016\u0001\u0016\u0003\u0016\u025f\b\u0016\u0001\u0017\u0001"+
		"\u0017\u0003\u0017\u0263\b\u0017\u0001\u0017\u0003\u0017\u0266\b\u0017"+
		"\u0001\u0017\u0001\u0017\u0003\u0017\u026a\b\u0017\u0003\u0017\u026c\b"+
		"\u0017\u0001\u0017\u0001\u0017\u0003\u0017\u0270\b\u0017\u0001\u0017\u0001"+
		"\u0017\u0003\u0017\u0274\b\u0017\u0003\u0017\u0276\b\u0017\u0001\u0017"+
		"\u0003\u0017\u0279\b\u0017\u0003\u0017\u027b\b\u0017\u0001\u0018\u0001"+
		"\u0018\u0001\u0018\u0001\u0018\u0005\u0018\u0281\b\u0018\n\u0018\f\u0018"+
		"\u0284\t\u0018\u0001\u0019\u0001\u0019\u0001\u0019\u0001\u0019\u0005\u0019"+
		"\u028a\b\u0019\n\u0019\f\u0019\u028d\t\u0019\u0001\u001a\u0001\u001a\u0003"+
		"\u001a\u0291\b\u001a\u0001\u001a\u0001\u001a\u0001\u001a\u0001\u001a\u0003"+
		"\u001a\u0297\b\u001a\u0003\u001a\u0299\b\u001a\u0001\u001b\u0001\u001b"+
		"\u0001\u001b\u0005\u001b\u029e\b\u001b\n\u001b\f\u001b\u02a1\t\u001b\u0001"+
		"\u001c\u0001\u001c\u0001\u001c\u0003\u001c\u02a6\b\u001c\u0001\u001d\u0001"+
		"\u001d\u0001\u001d\u0001\u001d\u0003\u001d\u02ac\b\u001d\u0001\u001e\u0001"+
		"\u001e\u0001\u001e\u0001\u001e\u0001\u001e\u0001\u001e\u0003\u001e\u02b4"+
		"\b\u001e\u0001\u001f\u0001\u001f\u0001\u001f\u0003\u001f\u02b9\b\u001f"+
		"\u0001\u001f\u0001\u001f\u0003\u001f\u02bd\b\u001f\u0001 \u0003 \u02c0"+
		"\b \u0001 \u0003 \u02c3\b \u0001 \u0003 \u02c6\b \u0003 \u02c8\b \u0001"+
		"!\u0001!\u0003!\u02cc\b!\u0001!\u0003!\u02cf\b!\u0001!\u0001!\u0001!\u0001"+
		"!\u0003!\u02d5\b!\u0003!\u02d7\b!\u0001\"\u0001\"\u0001\"\u0001#\u0001"+
		"#\u0003#\u02de\b#\u0001#\u0001#\u0001$\u0001$\u0001$\u0005$\u02e5\b$\n"+
		"$\f$\u02e8\t$\u0001%\u0001%\u0003%\u02ec\b%\u0001&\u0001&\u0001&\u0001"+
		"&\u0003&\u02f2\b&\u0001\'\u0001\'\u0001\'\u0001\'\u0001\'\u0001(\u0001"+
		"(\u0001(\u0001(\u0001(\u0001(\u0001)\u0001)\u0001)\u0003)\u0302\b)\u0001"+
		"*\u0001*\u0001*\u0005*\u0307\b*\n*\f*\u030a\t*\u0001+\u0001+\u0003+\u030e"+
		"\b+\u0001,\u0001,\u0003,\u0312\b,\u0001-\u0001-\u0001-\u0001-\u0001-\u0001"+
		".\u0001.\u0005.\u031b\b.\n.\f.\u031e\t.\u0001/\u0001/\u0001/\u00010\u0001"+
		"0\u00030\u0325\b0\u00010\u00030\u0328\b0\u00011\u00011\u00011\u00012\u0001"+
		"2\u00012\u00012\u00012\u00012\u00032\u0333\b2\u00013\u00013\u00033\u0337"+
		"\b3\u00014\u00014\u00014\u00014\u00014\u00034\u033e\b4\u00015\u00015\u0001"+
		"5\u00015\u00015\u00015\u00015\u00035\u0347\b5\u00016\u00016\u00016\u0001"+
		"6\u00016\u00036\u034e\b6\u00017\u00017\u00017\u00017\u00017\u00037\u0355"+
		"\b7\u00018\u00018\u00018\u00018\u00018\u00058\u035c\b8\n8\f8\u035f\t8"+
		"\u00019\u00019\u00019\u00039\u0364\b9\u0001:\u0001:\u0001:\u0001;\u0001"+
		";\u0001;\u0001;\u0001;\u0005;\u036e\b;\n;\f;\u0371\t;\u0001<\u0001<\u0001"+
		"<\u0005<\u0376\b<\n<\f<\u0379\t<\u0001=\u0001=\u0003=\u037d\b=\u0001="+
		"\u0003=\u0380\b=\u0001>\u0001>\u0001>\u0001?\u0001?\u0001?\u0003?\u0388"+
		"\b?\u0001@\u0001@\u0001A\u0001A\u0001A\u0001A\u0001A\u0001A\u0001A\u0001"+
		"B\u0001B\u0001C\u0001C\u0001C\u0001D\u0001D\u0001D\u0003D\u039b\bD\u0001"+
		"E\u0001E\u0001E\u0001E\u0001E\u0001E\u0003E\u03a3\bE\u0001E\u0001E\u0001"+
		"E\u0001E\u0003E\u03a9\bE\u0001F\u0001F\u0003F\u03ad\bF\u0001G\u0001G\u0001"+
		"G\u0001G\u0003G\u03b3\bG\u0001H\u0001H\u0001H\u0001I\u0001I\u0001I\u0001"+
		"I\u0001I\u0001I\u0001I\u0001I\u0003I\u03c0\bI\u0001I\u0001I\u0001I\u0001"+
		"I\u0001I\u0003I\u03c7\bI\u0001I\u0001I\u0001I\u0001I\u0003I\u03cd\bI\u0001"+
		"I\u0001I\u0001I\u0001I\u0001I\u0003I\u03d4\bI\u0001I\u0001I\u0001I\u0001"+
		"I\u0001I\u0001I\u0001I\u0003I\u03dd\bI\u0001I\u0001I\u0001I\u0003I\u03e2"+
		"\bI\u0001I\u0001I\u0001I\u0001I\u0001I\u0001I\u0001I\u0001I\u0001I\u0001"+
		"I\u0001I\u0001I\u0001I\u0001I\u0003I\u03f2\bI\u0001I\u0001I\u0003I\u03f6"+
		"\bI\u0001I\u0001I\u0001I\u0001I\u0001I\u0003I\u03fd\bI\u0001I\u0001I\u0001"+
		"I\u0001I\u0001I\u0001I\u0005I\u0405\bI\nI\fI\u0408\tI\u0001J\u0001J\u0001"+
		"J\u0001J\u0001J\u0001J\u0001J\u0001J\u0001J\u0001J\u0001J\u0001J\u0001"+
		"J\u0003J\u0417\bJ\u0001K\u0001K\u0001K\u0001K\u0001K\u0001K\u0001K\u0001"+
		"K\u0001K\u0005K\u0422\bK\nK\fK\u0425\tK\u0003K\u0427\bK\u0001K\u0001K"+
		"\u0001K\u0001K\u0001K\u0001K\u0003K\u042f\bK\u0001L\u0001L\u0001L\u0001"+
		"L\u0003L\u0435\bL\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001"+
		"M\u0001M\u0004M\u0440\bM\u000bM\fM\u0441\u0001M\u0001M\u0001M\u0001M\u0001"+
		"M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0003M\u0451"+
		"\bM\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001"+
		"M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0005M\u0463\bM\nM\fM\u0466"+
		"\tM\u0001N\u0001N\u0001N\u0001N\u0001N\u0001N\u0001N\u0001N\u0001N\u0001"+
		"N\u0003N\u0472\bN\u0001N\u0001N\u0003N\u0476\bN\u0001O\u0001O\u0003O\u047a"+
		"\bO\u0001P\u0001P\u0001Q\u0001Q\u0001R\u0001R\u0001S\u0001S\u0001S\u0001"+
		"S\u0003S\u0486\bS\u0001S\u0001S\u0001T\u0001T\u0001T\u0001T\u0001T\u0003"+
		"T\u048f\bT\u0001U\u0001U\u0001U\u0001U\u0001U\u0001V\u0001V\u0001V\u0001"+
		"V\u0001V\u0003V\u049b\bV\u0001W\u0001W\u0001W\u0001W\u0001W\u0001X\u0001"+
		"X\u0003X\u04a4\bX\u0001Y\u0001Y\u0001Y\u0004Y\u04a9\bY\u000bY\fY\u04aa"+
		"\u0001Y\u0003Y\u04ae\bY\u0001Y\u0001Y\u0001Z\u0001Z\u0001Z\u0001Z\u0001"+
		"Z\u0001[\u0001[\u0001[\u0001\\\u0001\\\u0004\\\u04bc\b\\\u000b\\\f\\\u04bd"+
		"\u0001\\\u0003\\\u04c1\b\\\u0001\\\u0001\\\u0001]\u0001]\u0001]\u0001"+
		"]\u0001]\u0001^\u0001^\u0001^\u0001^\u0001^\u0001^\u0001^\u0001^\u0003"+
		"^\u04d2\b^\u0001_\u0001_\u0001`\u0001`\u0001a\u0001a\u0001a\u0001a\u0001"+
		"a\u0005a\u04dd\ba\na\fa\u04e0\ta\u0001a\u0003a\u04e3\ba\u0001b\u0001b"+
		"\u0001b\u0001b\u0001b\u0001b\u0003b\u04eb\bb\u0001c\u0001c\u0001c\u0003"+
		"c\u04f0\bc\u0001d\u0001d\u0001d\u0001d\u0001d\u0003d\u04f7\bd\u0001d\u0001"+
		"d\u0003d\u04fb\bd\u0001e\u0001e\u0001e\u0001e\u0001e\u0003e\u0502\be\u0001"+
		"e\u0001e\u0003e\u0506\be\u0001f\u0001f\u0001f\u0001f\u0001f\u0003f\u050d"+
		"\bf\u0001f\u0001f\u0003f\u0511\bf\u0001g\u0001g\u0001g\u0001g\u0001g\u0003"+
		"g\u0518\bg\u0001g\u0001g\u0003g\u051c\bg\u0001h\u0001h\u0001h\u0001h\u0001"+
		"h\u0003h\u0523\bh\u0001h\u0001h\u0003h\u0527\bh\u0001i\u0001i\u0001i\u0003"+
		"i\u052c\bi\u0001j\u0001j\u0001j\u0001k\u0001k\u0001k\u0001k\u0001l\u0001"+
		"l\u0001l\u0001l\u0001m\u0001m\u0001m\u0001m\u0001n\u0001n\u0001n\u0001"+
		"n\u0001n\u0001n\u0001o\u0001o\u0001o\u0001o\u0001o\u0003o\u0548\bo\u0001"+
		"p\u0001p\u0001p\u0001p\u0003p\u054e\bp\u0001q\u0001q\u0001q\u0001q\u0001"+
		"q\u0001r\u0001r\u0001s\u0001s\u0001t\u0001t\u0001u\u0001u\u0001v\u0001"+
		"v\u0001w\u0001w\u0001x\u0001x\u0001x\u0003x\u0564\bx\u0001x\u0003x\u0567"+
		"\bx\u0001y\u0001y\u0001y\u0003y\u056c\by\u0001y\u0001y\u0001z\u0001z\u0001"+
		"z\u0003z\u0573\bz\u0001z\u0001z\u0001{\u0001{\u0001{\u0003{\u057a\b{\u0001"+
		"{\u0001{\u0001|\u0001|\u0001}\u0001}\u0001}\u0001}\u0001}\u0001}\u0001"+
		"~\u0001~\u0001\u007f\u0001\u007f\u0001\u0080\u0001\u0080\u0001\u0080\u0001"+
		"\u0080\u0003\u0080\u058e\b\u0080\u0003\u0080\u0590\b\u0080\u0001\u0081"+
		"\u0001\u0081\u0001\u0081\u0001\u0081\u0001\u0081\u0001\u0081\u0001\u0081"+
		"\u0001\u0081\u0003\u0081\u059a\b\u0081\u0001\u0082\u0001\u0082\u0001\u0082"+
		"\u0001\u0082\u0001\u0082\u0003\u0082\u05a1\b\u0082\u0001\u0082\u0001\u0082"+
		"\u0001\u0083\u0001\u0083\u0001\u0084\u0001\u0084\u0001\u0084\u0001\u0084"+
		"\u0003\u0084\u05ab\b\u0084\u0001\u0084\u0001\u0084\u0003\u0084\u05af\b"+
		"\u0084\u0001\u0084\u0003\u0084\u05b2\b\u0084\u0001\u0084\u0003\u0084\u05b5"+
		"\b\u0084\u0001\u0084\u0003\u0084\u05b8\b\u0084\u0001\u0084\u0003\u0084"+
		"\u05bb\b\u0084\u0001\u0085\u0001\u0085\u0001\u0086\u0001\u0086\u0001\u0086"+
		"\u0001\u0086\u0003\u0086\u05c3\b\u0086\u0001\u0086\u0001\u0086\u0001\u0086"+
		"\u0005\u0086\u05c8\b\u0086\n\u0086\f\u0086\u05cb\t\u0086\u0001\u0087\u0001"+
		"\u0087\u0001\u0087\u0001\u0087\u0001\u0087\u0001\u0088\u0001\u0088\u0001"+
		"\u0088\u0001\u0088\u0001\u0088\u0001\u0088\u0001\u0088\u0001\u0088\u0001"+
		"\u0088\u0001\u0088\u0001\u0088\u0001\u0088\u0001\u0088\u0001\u0088\u0001"+
		"\u0088\u0001\u0088\u0001\u0088\u0001\u0088\u0001\u0088\u0001\u0088\u0001"+
		"\u0088\u0001\u0088\u0001\u0088\u0001\u0088\u0001\u0088\u0001\u0088\u0001"+
		"\u0088\u0001\u0088\u0001\u0088\u0001\u0088\u0001\u0088\u0001\u0088\u0001"+
		"\u0088\u0001\u0088\u0001\u0088\u0001\u0088\u0001\u0088\u0001\u0088\u0001"+
		"\u0088\u0001\u0088\u0001\u0088\u0001\u0088\u0003\u0088\u05fc\b\u0088\u0001"+
		"\u0089\u0001\u0089\u0001\u0089\u0001\u0089\u0001\u0089\u0001\u0089\u0001"+
		"\u0089\u0001\u0089\u0001\u0089\u0001\u0089\u0001\u0089\u0001\u0089\u0001"+
		"\u0089\u0001\u0089\u0001\u0089\u0001\u0089\u0001\u0089\u0001\u0089\u0001"+
		"\u0089\u0001\u0089\u0001\u0089\u0001\u0089\u0001\u0089\u0001\u0089\u0001"+
		"\u0089\u0001\u0089\u0001\u0089\u0001\u0089\u0001\u0089\u0001\u0089\u0001"+
		"\u0089\u0001\u0089\u0001\u0089\u0001\u0089\u0001\u0089\u0001\u0089\u0001"+
		"\u0089\u0001\u0089\u0001\u0089\u0001\u0089\u0001\u0089\u0001\u0089\u0003"+
		"\u0089\u0628\b\u0089\u0001\u008a\u0001\u008a\u0001\u008a\u0001\u008a\u0001"+
		"\u008a\u0001\u008a\u0001\u008a\u0001\u008a\u0001\u008a\u0001\u008a\u0003"+
		"\u008a\u0634\b\u008a\u0001\u008b\u0001\u008b\u0001\u008b\u0003\u008b\u0639"+
		"\b\u008b\u0001\u008c\u0001\u008c\u0001\u008c\u0001\u008c\u0001\u008c\u0003"+
		"\u008c\u0640\b\u008c\u0001\u008c\u0003\u008c\u0643\b\u008c\u0001\u008c"+
		"\u0001\u008c\u0001\u008c\u0001\u008c\u0001\u008c\u0001\u008c\u0001\u008c"+
		"\u0001\u008c\u0001\u008c\u0001\u008c\u0001\u008c\u0003\u008c\u0650\b\u008c"+
		"\u0001\u008d\u0001\u008d\u0001\u008d\u0001\u008d\u0001\u008d\u0003\u008d"+
		"\u0657\b\u008d\u0001\u008d\u0003\u008d\u065a\b\u008d\u0001\u008d\u0001"+
		"\u008d\u0001\u008d\u0001\u008d\u0001\u008d\u0001\u008d\u0001\u008d\u0001"+
		"\u008d\u0001\u008d\u0001\u008d\u0001\u008d\u0003\u008d\u0667\b\u008d\u0001"+
		"\u008e\u0001\u008e\u0001\u008e\u0003\u008e\u066c\b\u008e\u0001\u008e\u0001"+
		"\u008e\u0001\u008e\u0001\u008e\u0003\u008e\u0672\b\u008e\u0001\u008e\u0001"+
		"\u008e\u0003\u008e\u0676\b\u008e\u0001\u008e\u0003\u008e\u0679\b\u008e"+
		"\u0001\u008e\u0003\u008e\u067c\b\u008e\u0001\u008f\u0001\u008f\u0001\u008f"+
		"\u0001\u008f\u0001\u008f\u0003\u008f\u0683\b\u008f\u0001\u008f\u0001\u008f"+
		"\u0003\u008f\u0687\b\u008f\u0001\u0090\u0001\u0090\u0001\u0090\u0001\u0090"+
		"\u0001\u0090\u0001\u0090\u0001\u0091\u0001\u0091\u0001\u0091\u0001\u0091"+
		"\u0001\u0091\u0001\u0092\u0001\u0092\u0001\u0092\u0001\u0092\u0003\u0092"+
		"\u0698\b\u0092\u0001\u0093\u0001\u0093\u0001\u0093\u0001\u0093\u0003\u0093"+
		"\u069e\b\u0093\u0001\u0094\u0001\u0094\u0001\u0094\u0003\u0094\u06a3\b"+
		"\u0094\u0001\u0094\u0003\u0094\u06a6\b\u0094\u0001\u0094\u0003\u0094\u06a9"+
		"\b\u0094\u0001\u0094\u0001\u0094\u0001\u0095\u0001\u0095\u0001\u0095\u0001"+
		"\u0095\u0001\u0095\u0005\u0095\u06b2\b\u0095\n\u0095\f\u0095\u06b5\t\u0095"+
		"\u0001\u0096\u0001\u0096\u0001\u0096\u0003\u0096\u06ba\b\u0096\u0001\u0096"+
		"\u0001\u0096\u0001\u0096\u0001\u0096\u0001\u0096\u0001\u0096\u0003\u0096"+
		"\u06c2\b\u0096\u0003\u0096\u06c4\b\u0096\u0001\u0097\u0001\u0097\u0001"+
		"\u0097\u0001\u0097\u0001\u0097\u0001\u0097\u0001\u0097\u0001\u0097\u0001"+
		"\u0097\u0001\u0097\u0003\u0097\u06d0\b\u0097\u0001\u0098\u0001\u0098\u0001"+
		"\u0098\u0001\u0098\u0001\u0098\u0001\u0098\u0001\u0098\u0001\u0098\u0001"+
		"\u0098\u0001\u0098\u0003\u0098\u06dc\b\u0098\u0001\u0099\u0001\u0099\u0001"+
		"\u0099\u0001\u0099\u0001\u0099\u0001\u0099\u0001\u0099\u0001\u0099\u0001"+
		"\u0099\u0001\u0099\u0003\u0099\u06e8\b\u0099\u0001\u009a\u0001\u009a\u0001"+
		"\u009a\u0001\u009a\u0001\u009a\u0001\u009a\u0001\u009a\u0001\u009a\u0001"+
		"\u009a\u0001\u009a\u0001\u009a\u0001\u009a\u0001\u009a\u0001\u009a\u0001"+
		"\u009a\u0001\u009a\u0001\u009a\u0001\u009a\u0001\u009a\u0001\u009a\u0003"+
		"\u009a\u06fe\b\u009a\u0001\u009b\u0001\u009b\u0001\u009b\u0001\u009b\u0001"+
		"\u009b\u0001\u009b\u0001\u009b\u0001\u009c\u0001\u009c\u0001\u009c\u0001"+
		"\u009c\u0001\u009c\u0003\u009c\u070c\b\u009c\u0001\u009c\u0003\u009c\u070f"+
		"\b\u009c\u0001\u009d\u0001\u009d\u0001\u009d\u0001\u009d\u0001\u009d\u0001"+
		"\u009d\u0001\u009d\u0005\u009d\u0718\b\u009d\n\u009d\f\u009d\u071b\t\u009d"+
		"\u0001\u009e\u0001\u009e\u0001\u009e\u0001\u009e\u0001\u009e\u0001\u009e"+
		"\u0001\u009e\u0003\u009e\u0724\b\u009e\u0001\u009e\u0001\u009e\u0001\u009e"+
		"\u0001\u009e\u0001\u009e\u0001\u009e\u0001\u009e\u0001\u009e\u0001\u009e"+
		"\u0003\u009e\u072f\b\u009e\u0001\u009e\u0001\u009e\u0003\u009e\u0733\b"+
		"\u009e\u0001\u009f\u0001\u009f\u0001\u00a0\u0001\u00a0\u0001\u00a1\u0001"+
		"\u00a1\u0001\u00a1\u0003\u00a1\u073c\b\u00a1\u0001\u00a1\u0003\u00a1\u073f"+
		"\b\u00a1\u0001\u00a1\u0003\u00a1\u0742\b\u00a1\u0001\u00a1\u0001\u00a1"+
		"\u0001\u00a1\u0001\u00a2\u0001\u00a2\u0001\u00a3\u0001\u00a3\u0001\u00a4"+
		"\u0001\u00a4\u0001\u00a4\u0001\u00a4\u0001\u00a4\u0001\u00a4\u0001\u00a4"+
		"\u0003\u00a4\u0752\b\u00a4\u0001\u00a4\u0001\u00a4\u0001\u00a5\u0001\u00a5"+
		"\u0001\u00a6\u0001\u00a6\u0001\u00a7\u0001\u00a7\u0001\u00a8\u0001\u00a8"+
		"\u0001\u00a8\u0001\u00a8\u0001\u00a8\u0001\u00a8\u0001\u00a8\u0001\u00a8"+
		"\u0001\u00a8\u0003\u00a8\u0765\b\u00a8\u0001\u00a8\u0001\u00a8\u0001\u00a9"+
		"\u0001\u00a9\u0001\u00aa\u0001\u00aa\u0001\u00ab\u0001\u00ab\u0001\u00ac"+
		"\u0001\u00ac\u0001\u00ad\u0001\u00ad\u0001\u00ad\u0003\u00ad\u0774\b\u00ad"+
		"\u0001\u00ad\u0001\u00ad\u0003\u00ad\u0778\b\u00ad\u0001\u00ae\u0001\u00ae"+
		"\u0001\u00ae\u0003\u00ae\u077d\b\u00ae\u0001\u00ae\u0001\u00ae\u0003\u00ae"+
		"\u0781\b\u00ae\u0001\u00af\u0001\u00af\u0001\u00af\u0003\u00af\u0786\b"+
		"\u00af\u0001\u00af\u0001\u00af\u0003\u00af\u078a\b\u00af\u0001\u00b0\u0001"+
		"\u00b0\u0001\u00b0\u0003\u00b0\u078f\b\u00b0\u0001\u00b0\u0003\u00b0\u0792"+
		"\b\u00b0\u0001\u00b1\u0001\u00b1\u0001\u00b1\u0003\u00b1\u0797\b\u00b1"+
		"\u0001\u00b1\u0001\u00b1\u0003\u00b1\u079b\b\u00b1\u0001\u00b2\u0001\u00b2"+
		"\u0001\u00b2\u0003\u00b2\u07a0\b\u00b2\u0001\u00b2\u0001\u00b2\u0003\u00b2"+
		"\u07a4\b\u00b2\u0001\u00b3\u0001\u00b3\u0001\u00b3\u0003\u00b3\u07a9\b"+
		"\u00b3\u0001\u00b3\u0001\u00b3\u0003\u00b3\u07ad\b\u00b3\u0001\u00b4\u0001"+
		"\u00b4\u0001\u00b4\u0003\u00b4\u07b2\b\u00b4\u0001\u00b4\u0001\u00b4\u0003"+
		"\u00b4\u07b6\b\u00b4\u0001\u00b5\u0001\u00b5\u0001\u00b5\u0001\u00b5\u0001"+
		"\u00b5\u0001\u00b5\u0001\u00b5\u0001\u00b6\u0001\u00b6\u0001\u00b7\u0001"+
		"\u00b7\u0001\u00b7\u0001\u00b7\u0001\u00b7\u0001\u00b7\u0001\u00b7\u0001"+
		"\u00b7\u0001\u00b7\u0001\u00b7\u0001\u00b7\u0001\u00b7\u0003\u00b7\u07cd"+
		"\b\u00b7\u0001\u00b8\u0001\u00b8\u0001\u00b8\u0001\u00b8\u0001\u00b8\u0001"+
		"\u00b8\u0003\u00b8\u07d5\b\u00b8\u0003\u00b8\u07d7\b\u00b8\u0001\u00b8"+
		"\u0001\u00b8\u0001\u00b9\u0001\u00b9\u0001\u00b9\u0001\u00b9\u0001\u00b9"+
		"\u0003\u00b9\u07e0\b\u00b9\u0001\u00ba\u0001\u00ba\u0001\u00bb\u0001\u00bb"+
		"\u0001\u00bb\u0001\u00bb\u0001\u00bb\u0001\u00bb\u0001\u00bb\u0001\u00bb"+
		"\u0001\u00bb\u0003\u00bb\u07ed\b\u00bb\u0001\u00bc\u0001\u00bc\u0001\u00bc"+
		"\u0001\u00bc\u0001\u00bc\u0001\u00bc\u0003\u00bc\u07f5\b\u00bc\u0001\u00bd"+
		"\u0001\u00bd\u0003\u00bd\u07f9\b\u00bd\u0001\u00bd\u0001\u00bd\u0003\u00bd"+
		"\u07fd\b\u00bd\u0001\u00be\u0001\u00be\u0001\u00bf\u0001\u00bf\u0001\u00bf"+
		"\u0001\u00bf\u0001\u00bf\u0001\u00bf\u0001\u00bf\u0001\u00c0\u0001\u00c0"+
		"\u0001\u00c1\u0001\u00c1\u0001\u00c2\u0001\u00c2\u0001\u00c2\u0001\u00c2"+
		"\u0001\u00c2\u0005\u00c2\u0811\b\u00c2\n\u00c2\f\u00c2\u0814\t\u00c2\u0001"+
		"\u00c2\u0001\u00c2\u0001\u00c3\u0001\u00c3\u0001\u00c3\u0001\u00c3\u0001"+
		"\u00c3\u0005\u00c3\u081d\b\u00c3\n\u00c3\f\u00c3\u0820\t\u00c3\u0001\u00c3"+
		"\u0001\u00c3\u0001\u00c4\u0001\u00c4\u0001\u00c4\u0001\u00c4\u0003\u00c4"+
		"\u0828\b\u00c4\u0001\u00c5\u0001\u00c5\u0001\u00c5\u0003\u00c5\u082d\b"+
		"\u00c5\u0001\u00c5\u0000\u0002\u0092\u009a\u00c6\u0000\u0002\u0004\u0006"+
		"\b\n\f\u000e\u0010\u0012\u0014\u0016\u0018\u001a\u001c\u001e \"$&(*,."+
		"02468:<>@BDFHJLNPRTVXZ\\^`bdfhjlnprtvxz|~\u0080\u0082\u0084\u0086\u0088"+
		"\u008a\u008c\u008e\u0090\u0092\u0094\u0096\u0098\u009a\u009c\u009e\u00a0"+
		"\u00a2\u00a4\u00a6\u00a8\u00aa\u00ac\u00ae\u00b0\u00b2\u00b4\u00b6\u00b8"+
		"\u00ba\u00bc\u00be\u00c0\u00c2\u00c4\u00c6\u00c8\u00ca\u00cc\u00ce\u00d0"+
		"\u00d2\u00d4\u00d6\u00d8\u00da\u00dc\u00de\u00e0\u00e2\u00e4\u00e6\u00e8"+
		"\u00ea\u00ec\u00ee\u00f0\u00f2\u00f4\u00f6\u00f8\u00fa\u00fc\u00fe\u0100"+
		"\u0102\u0104\u0106\u0108\u010a\u010c\u010e\u0110\u0112\u0114\u0116\u0118"+
		"\u011a\u011c\u011e\u0120\u0122\u0124\u0126\u0128\u012a\u012c\u012e\u0130"+
		"\u0132\u0134\u0136\u0138\u013a\u013c\u013e\u0140\u0142\u0144\u0146\u0148"+
		"\u014a\u014c\u014e\u0150\u0152\u0154\u0156\u0158\u015a\u015c\u015e\u0160"+
		"\u0162\u0164\u0166\u0168\u016a\u016c\u016e\u0170\u0172\u0174\u0176\u0178"+
		"\u017a\u017c\u017e\u0180\u0182\u0184\u0186\u0188\u018a\u0000\u001c\u0002"+
		"\u000077JJ\u0003\u0000bbxx\u00aa\u00aa\u0002\u0000\u0098\u0098\u00cc\u00cc"+
		"\u0002\u0000MM\u00c7\u00c7\u0002\u0000kktt\u0002\u0000]]uu\u0002\u0000"+
		"33KK\u0001\u0000\u00ac\u00ad\u0002\u0000]]\u0090\u0090\u0002\u0000iiy"+
		"y\u0002\u0000NNll\u0001\u0000 \"\u0001\u0000\u001e\u001f\u0001\u0000\u00d1"+
		"\u00d2\u0001\u0000\u0003\t\u0002\u0000\u0003\u0003\u0005\u0005\u0002\u0000"+
		"//VV\u0002\u000011\u00b3\u00b3\u0002\u0000\u00cc\u00cc\u00ce\u00ce\u0003"+
		"\u0000ee\u00a8\u00a8\u00ad\u00ad\u0003\u000066ww\u00bd\u00bd\u0002\u0000"+
		"ww\u00bd\u00bd\u0001\u0000\u00c0\u00c1\b\u0000GGSSgg\u008c\u008e\u00a7"+
		"\u00a7\u00af\u00af\u00c9\u00c9\u00cf\u00cf\u0002\u0000gg\u008c\u008c\u0002"+
		"\u0000EE\u00b8\u00b8\b\u0000*-/aclnuwwy\u009c\u009e\u00a9\u00ab\u00cf"+
		"\u0005\u0000bbmmxx\u009d\u009d\u00aa\u00aa\u08bb\u0000\u0190\u0001\u0000"+
		"\u0000\u0000\u0002\u0194\u0001\u0000\u0000\u0000\u0004\u0196\u0001\u0000"+
		"\u0000\u0000\u0006\u0198\u0001\u0000\u0000\u0000\b\u019c\u0001\u0000\u0000"+
		"\u0000\n\u01a4\u0001\u0000\u0000\u0000\f\u01ad\u0001\u0000\u0000\u0000"+
		"\u000e\u01b6\u0001\u0000\u0000\u0000\u0010\u01ba\u0001\u0000\u0000\u0000"+
		"\u0012\u01c4\u0001\u0000\u0000\u0000\u0014\u01cf\u0001\u0000\u0000\u0000"+
		"\u0016\u01d8\u0001\u0000\u0000\u0000\u0018\u01e3\u0001\u0000\u0000\u0000"+
		"\u001a\u01ec\u0001\u0000\u0000\u0000\u001c\u01fd\u0001\u0000\u0000\u0000"+
		"\u001e\u0205\u0001\u0000\u0000\u0000 \u020d\u0001\u0000\u0000\u0000\""+
		"\u0215\u0001\u0000\u0000\u0000$\u021c\u0001\u0000\u0000\u0000&\u023a\u0001"+
		"\u0000\u0000\u0000(\u0246\u0001\u0000\u0000\u0000*\u0254\u0001\u0000\u0000"+
		"\u0000,\u0256\u0001\u0000\u0000\u0000.\u027a\u0001\u0000\u0000\u00000"+
		"\u027c\u0001\u0000\u0000\u00002\u0285\u0001\u0000\u0000\u00004\u0298\u0001"+
		"\u0000\u0000\u00006\u029a\u0001\u0000\u0000\u00008\u02a5\u0001\u0000\u0000"+
		"\u0000:\u02a7\u0001\u0000\u0000\u0000<\u02ad\u0001\u0000\u0000\u0000>"+
		"\u02b5\u0001\u0000\u0000\u0000@\u02c7\u0001\u0000\u0000\u0000B\u02d6\u0001"+
		"\u0000\u0000\u0000D\u02d8\u0001\u0000\u0000\u0000F\u02db\u0001\u0000\u0000"+
		"\u0000H\u02e1\u0001\u0000\u0000\u0000J\u02e9\u0001\u0000\u0000\u0000L"+
		"\u02f1\u0001\u0000\u0000\u0000N\u02f3\u0001\u0000\u0000\u0000P\u02f8\u0001"+
		"\u0000\u0000\u0000R\u0301\u0001\u0000\u0000\u0000T\u0303\u0001\u0000\u0000"+
		"\u0000V\u030b\u0001\u0000\u0000\u0000X\u0311\u0001\u0000\u0000\u0000Z"+
		"\u0313\u0001\u0000\u0000\u0000\\\u0318\u0001\u0000\u0000\u0000^\u031f"+
		"\u0001\u0000\u0000\u0000`\u0327\u0001\u0000\u0000\u0000b\u0329\u0001\u0000"+
		"\u0000\u0000d\u0332\u0001\u0000\u0000\u0000f\u0334\u0001\u0000\u0000\u0000"+
		"h\u0338\u0001\u0000\u0000\u0000j\u033f\u0001\u0000\u0000\u0000l\u0348"+
		"\u0001\u0000\u0000\u0000n\u034f\u0001\u0000\u0000\u0000p\u0356\u0001\u0000"+
		"\u0000\u0000r\u0363\u0001\u0000\u0000\u0000t\u0365\u0001\u0000\u0000\u0000"+
		"v\u0368\u0001\u0000\u0000\u0000x\u0372\u0001\u0000\u0000\u0000z\u037a"+
		"\u0001\u0000\u0000\u0000|\u0381\u0001\u0000\u0000\u0000~\u0387\u0001\u0000"+
		"\u0000\u0000\u0080\u0389\u0001\u0000\u0000\u0000\u0082\u038b\u0001\u0000"+
		"\u0000\u0000\u0084\u0392\u0001\u0000\u0000\u0000\u0086\u0394\u0001\u0000"+
		"\u0000\u0000\u0088\u0397\u0001\u0000\u0000\u0000\u008a\u039c\u0001\u0000"+
		"\u0000\u0000\u008c\u03ac\u0001\u0000\u0000\u0000\u008e\u03b2\u0001\u0000"+
		"\u0000\u0000\u0090\u03b4\u0001\u0000\u0000\u0000\u0092\u03fc\u0001\u0000"+
		"\u0000\u0000\u0094\u0416\u0001\u0000\u0000\u0000\u0096\u042e\u0001\u0000"+
		"\u0000\u0000\u0098\u0430\u0001\u0000\u0000\u0000\u009a\u0450\u0001\u0000"+
		"\u0000\u0000\u009c\u0475\u0001\u0000\u0000\u0000\u009e\u0479\u0001\u0000"+
		"\u0000\u0000\u00a0\u047b\u0001\u0000\u0000\u0000\u00a2\u047d\u0001\u0000"+
		"\u0000\u0000\u00a4\u047f\u0001\u0000\u0000\u0000\u00a6\u0481\u0001\u0000"+
		"\u0000\u0000\u00a8\u0489\u0001\u0000\u0000\u0000\u00aa\u0490\u0001\u0000"+
		"\u0000\u0000\u00ac\u0495\u0001\u0000\u0000\u0000\u00ae\u049c\u0001\u0000"+
		"\u0000\u0000\u00b0\u04a3\u0001\u0000\u0000\u0000\u00b2\u04a5\u0001\u0000"+
		"\u0000\u0000\u00b4\u04b1\u0001\u0000\u0000\u0000\u00b6\u04b6\u0001\u0000"+
		"\u0000\u0000\u00b8\u04b9\u0001\u0000\u0000\u0000\u00ba\u04c4\u0001\u0000"+
		"\u0000\u0000\u00bc\u04d1\u0001\u0000\u0000\u0000\u00be\u04d3\u0001\u0000"+
		"\u0000\u0000\u00c0\u04d5\u0001\u0000\u0000\u0000\u00c2\u04e2\u0001\u0000"+
		"\u0000\u0000\u00c4\u04ea\u0001\u0000\u0000\u0000\u00c6\u04ef\u0001\u0000"+
		"\u0000\u0000\u00c8\u04fa\u0001\u0000\u0000\u0000\u00ca\u0505\u0001\u0000"+
		"\u0000\u0000\u00cc\u0510\u0001\u0000\u0000\u0000\u00ce\u051b\u0001\u0000"+
		"\u0000\u0000\u00d0\u0526\u0001\u0000\u0000\u0000\u00d2\u052b\u0001\u0000"+
		"\u0000\u0000\u00d4\u052d\u0001\u0000\u0000\u0000\u00d6\u0530\u0001\u0000"+
		"\u0000\u0000\u00d8\u0534\u0001\u0000\u0000\u0000\u00da\u0538\u0001\u0000"+
		"\u0000\u0000\u00dc\u053c\u0001\u0000\u0000\u0000\u00de\u0542\u0001\u0000"+
		"\u0000\u0000\u00e0\u0549\u0001\u0000\u0000\u0000\u00e2\u054f\u0001\u0000"+
		"\u0000\u0000\u00e4\u0554\u0001\u0000\u0000\u0000\u00e6\u0556\u0001\u0000"+
		"\u0000\u0000\u00e8\u0558\u0001\u0000\u0000\u0000\u00ea\u055a\u0001\u0000"+
		"\u0000\u0000\u00ec\u055c\u0001\u0000\u0000\u0000\u00ee\u055e\u0001\u0000"+
		"\u0000\u0000\u00f0\u0566\u0001\u0000\u0000\u0000\u00f2\u0568\u0001\u0000"+
		"\u0000\u0000\u00f4\u056f\u0001\u0000\u0000\u0000\u00f6\u0576\u0001\u0000"+
		"\u0000\u0000\u00f8\u057d\u0001\u0000\u0000\u0000\u00fa\u057f\u0001\u0000"+
		"\u0000\u0000\u00fc\u0585\u0001\u0000\u0000\u0000\u00fe\u0587\u0001\u0000"+
		"\u0000\u0000\u0100\u058f\u0001\u0000\u0000\u0000\u0102\u0599\u0001\u0000"+
		"\u0000\u0000\u0104\u059b\u0001\u0000\u0000\u0000\u0106\u05a4\u0001\u0000"+
		"\u0000\u0000\u0108\u05a6\u0001\u0000\u0000\u0000\u010a\u05bc\u0001\u0000"+
		"\u0000\u0000\u010c\u05c2\u0001\u0000\u0000\u0000\u010e\u05cc\u0001\u0000"+
		"\u0000\u0000\u0110\u05fb\u0001\u0000\u0000\u0000\u0112\u0627\u0001\u0000"+
		"\u0000\u0000\u0114\u0633\u0001\u0000\u0000\u0000\u0116\u0638\u0001\u0000"+
		"\u0000\u0000\u0118\u064f\u0001\u0000\u0000\u0000\u011a\u0666\u0001\u0000"+
		"\u0000\u0000\u011c\u0668\u0001\u0000\u0000\u0000\u011e\u067d\u0001\u0000"+
		"\u0000\u0000\u0120\u0688\u0001\u0000\u0000\u0000\u0122\u068e\u0001\u0000"+
		"\u0000\u0000\u0124\u0697\u0001\u0000\u0000\u0000\u0126\u069d\u0001\u0000"+
		"\u0000\u0000\u0128\u069f\u0001\u0000\u0000\u0000\u012a\u06ac\u0001\u0000"+
		"\u0000\u0000\u012c\u06c3\u0001\u0000\u0000\u0000\u012e\u06cf\u0001\u0000"+
		"\u0000\u0000\u0130\u06db\u0001\u0000\u0000\u0000\u0132\u06e7\u0001\u0000"+
		"\u0000\u0000\u0134\u06fd\u0001\u0000\u0000\u0000\u0136\u06ff\u0001\u0000"+
		"\u0000\u0000\u0138\u0706\u0001\u0000\u0000\u0000\u013a\u0710\u0001\u0000"+
		"\u0000\u0000\u013c\u0732\u0001\u0000\u0000\u0000\u013e\u0734\u0001\u0000"+
		"\u0000\u0000\u0140\u0736\u0001\u0000\u0000\u0000\u0142\u0738\u0001\u0000"+
		"\u0000\u0000\u0144\u0746\u0001\u0000\u0000\u0000\u0146\u0748\u0001\u0000"+
		"\u0000\u0000\u0148\u074a\u0001\u0000\u0000\u0000\u014a\u0755\u0001\u0000"+
		"\u0000\u0000\u014c\u0757\u0001\u0000\u0000\u0000\u014e\u0759\u0001\u0000"+
		"\u0000\u0000\u0150\u075b\u0001\u0000\u0000\u0000\u0152\u0768\u0001\u0000"+
		"\u0000\u0000\u0154\u076a\u0001\u0000\u0000\u0000\u0156\u076c\u0001\u0000"+
		"\u0000\u0000\u0158\u076e\u0001\u0000\u0000\u0000\u015a\u0777\u0001\u0000"+
		"\u0000\u0000\u015c\u0780\u0001\u0000\u0000\u0000\u015e\u0789\u0001\u0000"+
		"\u0000\u0000\u0160\u0791\u0001\u0000\u0000\u0000\u0162\u079a\u0001\u0000"+
		"\u0000\u0000\u0164\u07a3\u0001\u0000\u0000\u0000\u0166\u07ac\u0001\u0000"+
		"\u0000\u0000\u0168\u07b5\u0001\u0000\u0000\u0000\u016a\u07b7\u0001\u0000"+
		"\u0000\u0000\u016c\u07be\u0001\u0000\u0000\u0000\u016e\u07cc\u0001\u0000"+
		"\u0000\u0000\u0170\u07ce\u0001\u0000\u0000\u0000\u0172\u07df\u0001\u0000"+
		"\u0000\u0000\u0174\u07e1\u0001\u0000\u0000\u0000\u0176\u07ec\u0001\u0000"+
		"\u0000\u0000\u0178\u07f4\u0001\u0000\u0000\u0000\u017a\u07fc\u0001\u0000"+
		"\u0000\u0000\u017c\u07fe\u0001\u0000\u0000\u0000\u017e\u0800\u0001\u0000"+
		"\u0000\u0000\u0180\u0807\u0001\u0000\u0000\u0000\u0182\u0809\u0001\u0000"+
		"\u0000\u0000\u0184\u080b\u0001\u0000\u0000\u0000\u0186\u0817\u0001\u0000"+
		"\u0000\u0000\u0188\u0827\u0001\u0000\u0000\u0000\u018a\u082c\u0001\u0000"+
		"\u0000\u0000\u018c\u0191\u0003\u0002\u0001\u0000\u018d\u0191\u0003\n\u0005"+
		"\u0000\u018e\u0191\u0003\b\u0004\u0000\u018f\u0191\u0003\u0010\b\u0000"+
		"\u0190\u018c\u0001\u0000\u0000\u0000\u0190\u018d\u0001\u0000\u0000\u0000"+
		"\u0190\u018e\u0001\u0000\u0000\u0000\u0190\u018f\u0001\u0000\u0000\u0000"+
		"\u0191\u0192\u0001\u0000\u0000\u0000\u0192\u0193\u0005\u0000\u0000\u0001"+
		"\u0193\u0001\u0001\u0000\u0000\u0000\u0194\u0195\u0003&\u0013\u0000\u0195"+
		"\u0003\u0001\u0000\u0000\u0000\u0196\u0197\u0003&\u0013\u0000\u0197\u0005"+
		"\u0001\u0000\u0000\u0000\u0198\u019a\u00036\u001b\u0000\u0199\u019b\u0003"+
		"8\u001c\u0000\u019a\u0199\u0001\u0000\u0000\u0000\u019a\u019b\u0001\u0000"+
		"\u0000\u0000\u019b\u0007\u0001\u0000\u0000\u0000\u019c\u019e\u0005I\u0000"+
		"\u0000\u019d\u019f\u0005a\u0000\u0000\u019e\u019d\u0001\u0000\u0000\u0000"+
		"\u019e\u019f\u0001\u0000\u0000\u0000\u019f\u01a0\u0001\u0000\u0000\u0000"+
		"\u01a0\u01a2\u0003\u0006\u0003\u0000\u01a1\u01a3\u0003\u0090H\u0000\u01a2"+
		"\u01a1\u0001\u0000\u0000\u0000\u01a2\u01a3\u0001\u0000\u0000\u0000\u01a3"+
		"\t\u0001\u0000\u0000\u0000\u01a4\u01a6\u0005\u00c5\u0000\u0000\u01a5\u01a7"+
		"\u0005,\u0000\u0000\u01a6\u01a5\u0001\u0000\u0000\u0000\u01a6\u01a7\u0001"+
		"\u0000\u0000\u0000\u01a7\u01a8\u0001\u0000\u0000\u0000\u01a8\u01a9\u0003"+
		"\u0006\u0003\u0000\u01a9\u01ab\u0003\f\u0006\u0000\u01aa\u01ac\u0003\u0090"+
		"H\u0000\u01ab\u01aa\u0001\u0000\u0000\u0000\u01ab\u01ac\u0001\u0000\u0000"+
		"\u0000\u01ac\u000b\u0001\u0000\u0000\u0000\u01ad\u01ae\u0005\u00b1\u0000"+
		"\u0000\u01ae\u01b3\u0003\u000e\u0007\u0000\u01af\u01b0\u0005\u0016\u0000"+
		"\u0000\u01b0\u01b2\u0003\u000e\u0007\u0000\u01b1\u01af\u0001\u0000\u0000"+
		"\u0000\u01b2\u01b5\u0001\u0000\u0000\u0000\u01b3\u01b1\u0001\u0000\u0000"+
		"\u0000\u01b3\u01b4\u0001\u0000\u0000\u0000\u01b4\r\u0001\u0000\u0000\u0000"+
		"\u01b5\u01b3\u0001\u0000\u0000\u0000\u01b6\u01b7\u0003\\.\u0000\u01b7"+
		"\u01b8\u0005\u0010\u0000\u0000\u01b8\u01b9\u0003\u009eO\u0000\u01b9\u000f"+
		"\u0001\u0000\u0000\u0000\u01ba\u01bc\u0005n\u0000\u0000\u01bb\u01bd\u0005"+
		"q\u0000\u0000\u01bc\u01bb\u0001\u0000\u0000\u0000\u01bc\u01bd\u0001\u0000"+
		"\u0000\u0000\u01bd\u01be\u0001\u0000\u0000\u0000\u01be\u01bf\u0003\u0006"+
		"\u0003\u0000\u01bf\u01c2\u0003\u0012\t\u0000\u01c0\u01c3\u0003&\u0013"+
		"\u0000\u01c1\u01c3\u0003\u0014\n\u0000\u01c2\u01c0\u0001\u0000\u0000\u0000"+
		"\u01c2\u01c1\u0001\u0000\u0000\u0000\u01c3\u0011\u0001\u0000\u0000\u0000"+
		"\u01c4\u01c5\u0005\u0018\u0000\u0000\u01c5\u01ca\u0003\\.\u0000\u01c6"+
		"\u01c7\u0005\u0016\u0000\u0000\u01c7\u01c9\u0003\\.\u0000\u01c8\u01c6"+
		"\u0001\u0000\u0000\u0000\u01c9\u01cc\u0001\u0000\u0000\u0000\u01ca\u01c8"+
		"\u0001\u0000\u0000\u0000\u01ca\u01cb\u0001\u0000\u0000\u0000\u01cb\u01cd"+
		"\u0001\u0000\u0000\u0000\u01cc\u01ca\u0001\u0000\u0000\u0000\u01cd\u01ce"+
		"\u0005\u0019\u0000\u0000\u01ce\u0013\u0001\u0000\u0000\u0000\u01cf\u01d0"+
		"\u0005\u00c8\u0000\u0000\u01d0\u01d5\u0003\u0016\u000b\u0000\u01d1\u01d2"+
		"\u0005\u0016\u0000\u0000\u01d2\u01d4\u0003\u0016\u000b\u0000\u01d3\u01d1"+
		"\u0001\u0000\u0000\u0000\u01d4\u01d7\u0001\u0000\u0000\u0000\u01d5\u01d3"+
		"\u0001\u0000\u0000\u0000\u01d5\u01d6\u0001\u0000\u0000\u0000\u01d6\u0015"+
		"\u0001\u0000\u0000\u0000\u01d7\u01d5\u0001\u0000\u0000\u0000\u01d8\u01d9"+
		"\u0005\u0018\u0000\u0000\u01d9\u01de\u0003\u009eO\u0000\u01da\u01db\u0005"+
		"\u0016\u0000\u0000\u01db\u01dd\u0003\u009eO\u0000\u01dc\u01da\u0001\u0000"+
		"\u0000\u0000\u01dd\u01e0\u0001\u0000\u0000\u0000\u01de\u01dc\u0001\u0000"+
		"\u0000\u0000\u01de\u01df\u0001\u0000\u0000\u0000\u01df\u01e1\u0001\u0000"+
		"\u0000\u0000\u01e0\u01de\u0001\u0000\u0000\u0000\u01e1\u01e2\u0005\u0019"+
		"\u0000\u0000\u01e2\u0017\u0001\u0000\u0000\u0000\u01e3\u01e4\u0005\u00cc"+
		"\u0000\u0000\u01e4\u01e9\u0003\u001a\r\u0000\u01e5\u01e6\u0005\u0016\u0000"+
		"\u0000\u01e6\u01e8\u0003\u001a\r\u0000\u01e7\u01e5\u0001\u0000\u0000\u0000"+
		"\u01e8\u01eb\u0001\u0000\u0000\u0000\u01e9\u01e7\u0001\u0000\u0000\u0000"+
		"\u01e9\u01ea\u0001\u0000\u0000\u0000\u01ea\u0019\u0001\u0000\u0000\u0000"+
		"\u01eb\u01e9\u0001\u0000\u0000\u0000\u01ec\u01ed\u0003\u018a\u00c5\u0000"+
		"\u01ed\u01f2\u00052\u0000\u0000\u01ee\u01f0\u0005\u0092\u0000\u0000\u01ef"+
		"\u01ee\u0001\u0000\u0000\u0000\u01ef\u01f0\u0001\u0000\u0000\u0000\u01f0"+
		"\u01f1\u0001\u0000\u0000\u0000\u01f1\u01f3\u0005\u0082\u0000\u0000\u01f2"+
		"\u01ef\u0001\u0000\u0000\u0000\u01f2\u01f3\u0001\u0000\u0000\u0000\u01f3"+
		"\u01f4\u0001\u0000\u0000\u0000\u01f4\u01f5\u0005\u0018\u0000\u0000\u01f5"+
		"\u01f6\u0003&\u0013\u0000\u01f6\u01f8\u0005\u0019\u0000\u0000\u01f7\u01f9"+
		"\u0003\u001e\u000f\u0000\u01f8\u01f7\u0001\u0000\u0000\u0000\u01f8\u01f9"+
		"\u0001\u0000\u0000\u0000\u01f9\u01fb\u0001\u0000\u0000\u0000\u01fa\u01fc"+
		"\u0003$\u0012\u0000\u01fb\u01fa\u0001\u0000\u0000\u0000\u01fb\u01fc\u0001"+
		"\u0000\u0000\u0000\u01fc\u001b\u0001\u0000\u0000\u0000\u01fd\u0202\u0003"+
		"\u018a\u00c5\u0000\u01fe\u01ff\u0005\u0016\u0000\u0000\u01ff\u0201\u0003"+
		"\u018a\u00c5\u0000\u0200\u01fe\u0001\u0000\u0000\u0000\u0201\u0204\u0001"+
		"\u0000\u0000\u0000\u0202\u0200\u0001\u0000\u0000\u0000\u0202\u0203\u0001"+
		"\u0000\u0000\u0000\u0203\u001d\u0001\u0000\u0000\u0000\u0204\u0202\u0001"+
		"\u0000\u0000\u0000\u0205\u0206\u0005\u00ae\u0000\u0000\u0206\u0207\u0007"+
		"\u0000\u0000\u0000\u0207\u0208\u0005]\u0000\u0000\u0208\u0209\u00058\u0000"+
		"\u0000\u0209\u020a\u0003 \u0010\u0000\u020a\u020b\u0005\u00b1\u0000\u0000"+
		"\u020b\u020c\u0003\u018a\u00c5\u0000\u020c\u001f\u0001\u0000\u0000\u0000"+
		"\u020d\u0212\u0003\"\u0011\u0000\u020e\u020f\u0005\u0016\u0000\u0000\u020f"+
		"\u0211\u0003\"\u0011\u0000\u0210\u020e\u0001\u0000\u0000\u0000\u0211\u0214"+
		"\u0001\u0000\u0000\u0000\u0212\u0210\u0001\u0000\u0000\u0000\u0212\u0213"+
		"\u0001\u0000\u0000\u0000\u0213!\u0001\u0000\u0000\u0000\u0214\u0212\u0001"+
		"\u0000\u0000\u0000\u0215\u0217\u0003\u018a\u00c5\u0000\u0216\u0218\u0003"+
		"\u0080@\u0000\u0217\u0216\u0001\u0000\u0000\u0000\u0217\u0218\u0001\u0000"+
		"\u0000\u0000\u0218\u021a\u0001\u0000\u0000\u0000\u0219\u021b\u0003|>\u0000"+
		"\u021a\u0219\u0001\u0000\u0000\u0000\u021a\u021b\u0001\u0000\u0000\u0000"+
		"\u021b#\u0001\u0000\u0000\u0000\u021c\u021d\u0005D\u0000\u0000\u021d\u021e"+
		"\u0003\u001c\u000e\u0000\u021e\u021f\u0005\u00b1\u0000\u0000\u021f\u0225"+
		"\u0003\u018a\u00c5\u0000\u0220\u0221\u0005\u00bc\u0000\u0000\u0221\u0222"+
		"\u0003\u00bc^\u0000\u0222\u0223\u0005H\u0000\u0000\u0223\u0224\u0003\u00bc"+
		"^\u0000\u0224\u0226\u0001\u0000\u0000\u0000\u0225\u0220\u0001\u0000\u0000"+
		"\u0000\u0225\u0226\u0001\u0000\u0000\u0000\u0226\u0229\u0001\u0000\u0000"+
		"\u0000\u0227\u0228\u0005\u00c6\u0000\u0000\u0228\u022a\u0003\u018a\u00c5"+
		"\u0000\u0229\u0227\u0001\u0000\u0000\u0000\u0229\u022a\u0001\u0000\u0000"+
		"\u0000\u022a%\u0001\u0000\u0000\u0000\u022b\u022d\u0003\u0018\f\u0000"+
		"\u022c\u022b\u0001\u0000\u0000\u0000\u022c\u022d\u0001\u0000\u0000\u0000"+
		"\u022d\u022e\u0001\u0000\u0000\u0000\u022e\u023b\u0003(\u0014\u0000\u022f"+
		"\u0231\u0003\u0018\f\u0000\u0230\u022f\u0001\u0000\u0000\u0000\u0230\u0231"+
		"\u0001\u0000\u0000\u0000\u0231\u0232\u0001\u0000\u0000\u0000\u0232\u0236"+
		"\u0003(\u0014\u0000\u0233\u0234\u0003*\u0015\u0000\u0234\u0235\u0003("+
		"\u0014\u0000\u0235\u0237\u0001\u0000\u0000\u0000\u0236\u0233\u0001\u0000"+
		"\u0000\u0000\u0237\u0238\u0001\u0000\u0000\u0000\u0238\u0236\u0001\u0000"+
		"\u0000\u0000\u0238\u0239\u0001\u0000\u0000\u0000\u0239\u023b\u0001\u0000"+
		"\u0000\u0000\u023a\u022c\u0001\u0000\u0000\u0000\u023a\u0230\u0001\u0000"+
		"\u0000\u0000\u023b\'\u0001\u0000\u0000\u0000\u023c\u023e\u0003.\u0017"+
		"\u0000\u023d\u023f\u0003,\u0016\u0000\u023e\u023d\u0001\u0000\u0000\u0000"+
		"\u023e\u023f\u0001\u0000\u0000\u0000\u023f\u0247\u0001\u0000\u0000\u0000"+
		"\u0240\u0241\u0005\u0018\u0000\u0000\u0241\u0242\u0003&\u0013\u0000\u0242"+
		"\u0244\u0005\u0019\u0000\u0000\u0243\u0245\u0003,\u0016\u0000\u0244\u0243"+
		"\u0001\u0000\u0000\u0000\u0244\u0245\u0001\u0000\u0000\u0000\u0245\u0247"+
		"\u0001\u0000\u0000\u0000\u0246\u023c\u0001\u0000\u0000\u0000\u0246\u0240"+
		"\u0001\u0000\u0000\u0000\u0247)\u0001\u0000\u0000\u0000\u0248\u024a\u0005"+
		"\u00c4\u0000\u0000\u0249\u024b\u0005/\u0000\u0000\u024a\u0249\u0001\u0000"+
		"\u0000\u0000\u024a\u024b\u0001\u0000\u0000\u0000\u024b\u0255\u0001\u0000"+
		"\u0000\u0000\u024c\u024e\u0005p\u0000\u0000\u024d\u024f\u0005/\u0000\u0000"+
		"\u024e\u024d\u0001\u0000\u0000\u0000\u024e\u024f\u0001\u0000\u0000\u0000"+
		"\u024f\u0255\u0001\u0000\u0000\u0000\u0250\u0252\u0005W\u0000\u0000\u0251"+
		"\u0253\u0005/\u0000\u0000\u0252\u0251\u0001\u0000\u0000\u0000\u0252\u0253"+
		"\u0001\u0000\u0000\u0000\u0253\u0255\u0001\u0000\u0000\u0000\u0254\u0248"+
		"\u0001\u0000\u0000\u0000\u0254\u024c\u0001\u0000\u0000\u0000\u0254\u0250"+
		"\u0001\u0000\u0000\u0000\u0255+\u0001\u0000\u0000\u0000\u0256\u0258\u0003"+
		"v;\u0000\u0257\u0259\u0003\u0086C\u0000\u0258\u0257\u0001\u0000\u0000"+
		"\u0000\u0258\u0259\u0001\u0000\u0000\u0000\u0259\u025b\u0001\u0000\u0000"+
		"\u0000\u025a\u025c\u0003\u0088D\u0000\u025b\u025a\u0001\u0000\u0000\u0000"+
		"\u025b\u025c\u0001\u0000\u0000\u0000\u025c\u025e\u0001\u0000\u0000\u0000"+
		"\u025d\u025f\u0003\u008aE\u0000\u025e\u025d\u0001\u0000\u0000\u0000\u025e"+
		"\u025f\u0001\u0000\u0000\u0000\u025f-\u0001\u0000\u0000\u0000\u0260\u0262"+
		"\u0003F#\u0000\u0261\u0263\u00030\u0018\u0000\u0262\u0261\u0001\u0000"+
		"\u0000\u0000\u0262\u0263\u0001\u0000\u0000\u0000\u0263\u0265\u0001\u0000"+
		"\u0000\u0000\u0264\u0266\u0003\u0090H\u0000\u0265\u0264\u0001\u0000\u0000"+
		"\u0000\u0265\u0266\u0001\u0000\u0000\u0000\u0266\u026b\u0001\u0000\u0000"+
		"\u0000\u0267\u0269\u0003p8\u0000\u0268\u026a\u0003t:\u0000\u0269\u0268"+
		"\u0001\u0000\u0000\u0000\u0269\u026a\u0001\u0000\u0000\u0000\u026a\u026c"+
		"\u0001\u0000\u0000\u0000\u026b\u0267\u0001\u0000\u0000\u0000\u026b\u026c"+
		"\u0001\u0000\u0000\u0000\u026c\u027b\u0001\u0000\u0000\u0000\u026d\u026f"+
		"\u00030\u0018\u0000\u026e\u0270\u0003\u0090H\u0000\u026f\u026e\u0001\u0000"+
		"\u0000\u0000\u026f\u0270\u0001\u0000\u0000\u0000\u0270\u0275\u0001\u0000"+
		"\u0000\u0000\u0271\u0273\u0003p8\u0000\u0272\u0274\u0003t:\u0000\u0273"+
		"\u0272\u0001\u0000\u0000\u0000\u0273\u0274\u0001\u0000\u0000\u0000\u0274"+
		"\u0276\u0001\u0000\u0000\u0000\u0275\u0271\u0001\u0000\u0000\u0000\u0275"+
		"\u0276\u0001\u0000\u0000\u0000\u0276\u0278\u0001\u0000\u0000\u0000\u0277"+
		"\u0279\u0003F#\u0000\u0278\u0277\u0001\u0000\u0000\u0000\u0278\u0279\u0001"+
		"\u0000\u0000\u0000\u0279\u027b\u0001\u0000\u0000\u0000\u027a\u0260\u0001"+
		"\u0000\u0000\u0000\u027a\u026d\u0001\u0000\u0000\u0000\u027b/\u0001\u0000"+
		"\u0000\u0000\u027c\u027d\u0005a\u0000\u0000\u027d\u0282\u00032\u0019\u0000"+
		"\u027e\u027f\u0005\u0016\u0000\u0000\u027f\u0281\u00032\u0019\u0000\u0280"+
		"\u027e\u0001\u0000\u0000\u0000\u0281\u0284\u0001\u0000\u0000\u0000\u0282"+
		"\u0280\u0001\u0000\u0000\u0000\u0282\u0283\u0001\u0000\u0000\u0000\u0283"+
		"1\u0001\u0000\u0000\u0000\u0284\u0282\u0001\u0000\u0000\u0000\u0285\u028b"+
		"\u00034\u001a\u0000\u0286\u028a\u0003>\u001f\u0000\u0287\u028a\u0003:"+
		"\u001d\u0000\u0288\u028a\u0003<\u001e\u0000\u0289\u0286\u0001\u0000\u0000"+
		"\u0000\u0289\u0287\u0001\u0000\u0000\u0000\u0289\u0288\u0001\u0000\u0000"+
		"\u0000\u028a\u028d\u0001\u0000\u0000\u0000\u028b\u0289\u0001\u0000\u0000"+
		"\u0000\u028b\u028c\u0001\u0000\u0000\u0000\u028c3\u0001\u0000\u0000\u0000"+
		"\u028d\u028b\u0001\u0000\u0000\u0000\u028e\u0290\u00036\u001b\u0000\u028f"+
		"\u0291\u00038\u001c\u0000\u0290\u028f\u0001\u0000\u0000\u0000\u0290\u0291"+
		"\u0001\u0000\u0000\u0000\u0291\u0299\u0001\u0000\u0000\u0000\u0292\u0293"+
		"\u0005\u0018\u0000\u0000\u0293\u0294\u0003\u0004\u0002\u0000\u0294\u0296"+
		"\u0005\u0019\u0000\u0000\u0295\u0297\u00038\u001c\u0000\u0296\u0295\u0001"+
		"\u0000\u0000\u0000\u0296\u0297\u0001\u0000\u0000\u0000\u0297\u0299\u0001"+
		"\u0000\u0000\u0000\u0298\u028e\u0001\u0000\u0000\u0000\u0298\u0292\u0001"+
		"\u0000\u0000\u0000\u02995\u0001\u0000\u0000\u0000\u029a\u029f\u0003\u018a"+
		"\u00c5\u0000\u029b\u029c\u0005\u0017\u0000\u0000\u029c\u029e\u0003\u018a"+
		"\u00c5\u0000\u029d\u029b\u0001\u0000\u0000\u0000\u029e\u02a1\u0001\u0000"+
		"\u0000\u0000\u029f\u029d\u0001\u0000\u0000\u0000\u029f\u02a0\u0001\u0000"+
		"\u0000\u0000\u02a07\u0001\u0000\u0000\u0000\u02a1\u029f\u0001\u0000\u0000"+
		"\u0000\u02a2\u02a3\u00052\u0000\u0000\u02a3\u02a6\u0003\u018a\u00c5\u0000"+
		"\u02a4\u02a6\u0003\u0188\u00c4\u0000\u02a5\u02a2\u0001\u0000\u0000\u0000"+
		"\u02a5\u02a4\u0001\u0000\u0000\u0000\u02a69\u0001\u0000\u0000\u0000\u02a7"+
		"\u02a8\u0005=\u0000\u0000\u02a8\u02a9\u0005s\u0000\u0000\u02a9\u02ab\u0003"+
		"6\u001b\u0000\u02aa\u02ac\u00038\u001c\u0000\u02ab\u02aa\u0001\u0000\u0000"+
		"\u0000\u02ab\u02ac\u0001\u0000\u0000\u0000\u02ac;\u0001\u0000\u0000\u0000"+
		"\u02ad\u02ae\u0005\u0016\u0000\u0000\u02ae\u02af\u0005j\u0000\u0000\u02af"+
		"\u02b0\u0005\u0018\u0000\u0000\u02b0\u02b1\u0003`0\u0000\u02b1\u02b3\u0005"+
		"\u0019\u0000\u0000\u02b2\u02b4\u00038\u001c\u0000\u02b3\u02b2\u0001\u0000"+
		"\u0000\u0000\u02b3\u02b4\u0001\u0000\u0000\u0000\u02b4=\u0001\u0000\u0000"+
		"\u0000\u02b5\u02b6\u0003@ \u0000\u02b6\u02b8\u0005s\u0000\u0000\u02b7"+
		"\u02b9\u0005[\u0000\u0000\u02b8\u02b7\u0001\u0000\u0000\u0000\u02b8\u02b9"+
		"\u0001\u0000\u0000\u0000\u02b9\u02ba\u0001\u0000\u0000\u0000\u02ba\u02bc"+
		"\u0003B!\u0000\u02bb\u02bd\u0003D\"\u0000\u02bc\u02bb\u0001\u0000\u0000"+
		"\u0000\u02bc\u02bd\u0001\u0000\u0000\u0000\u02bd?\u0001\u0000\u0000\u0000"+
		"\u02be\u02c0\u0005m\u0000\u0000\u02bf\u02be\u0001\u0000\u0000\u0000\u02bf"+
		"\u02c0\u0001\u0000\u0000\u0000\u02c0\u02c8\u0001\u0000\u0000\u0000\u02c1"+
		"\u02c3\u0007\u0001\u0000\u0000\u02c2\u02c1\u0001\u0000\u0000\u0000\u02c2"+
		"\u02c3\u0001\u0000\u0000\u0000\u02c3\u02c5\u0001\u0000\u0000\u0000\u02c4"+
		"\u02c6\u0005\u009d\u0000\u0000\u02c5\u02c4\u0001\u0000\u0000\u0000\u02c5"+
		"\u02c6\u0001\u0000\u0000\u0000\u02c6\u02c8\u0001\u0000\u0000\u0000\u02c7"+
		"\u02bf\u0001\u0000\u0000\u0000\u02c7\u02c2\u0001\u0000\u0000\u0000\u02c8"+
		"A\u0001\u0000\u0000\u0000\u02c9\u02cb\u0003`0\u0000\u02ca\u02cc\u0003"+
		"8\u001c\u0000\u02cb\u02ca\u0001\u0000\u0000\u0000\u02cb\u02cc\u0001\u0000"+
		"\u0000\u0000\u02cc\u02d7\u0001\u0000\u0000\u0000\u02cd\u02cf\u0005v\u0000"+
		"\u0000\u02ce\u02cd\u0001\u0000\u0000\u0000\u02ce\u02cf\u0001\u0000\u0000"+
		"\u0000\u02cf\u02d0\u0001\u0000\u0000\u0000\u02d0\u02d1\u0005\u0018\u0000"+
		"\u0000\u02d1\u02d2\u0003\u0004\u0002\u0000\u02d2\u02d4\u0005\u0019\u0000"+
		"\u0000\u02d3\u02d5\u00038\u001c\u0000\u02d4\u02d3\u0001\u0000\u0000\u0000"+
		"\u02d4\u02d5\u0001\u0000\u0000\u0000\u02d5\u02d7\u0001\u0000\u0000\u0000"+
		"\u02d6\u02c9\u0001\u0000\u0000\u0000\u02d6\u02ce\u0001\u0000\u0000\u0000"+
		"\u02d7C\u0001\u0000\u0000\u0000\u02d8\u02d9\u0007\u0002\u0000\u0000\u02d9"+
		"\u02da\u0003\u0092I\u0000\u02daE\u0001\u0000\u0000\u0000\u02db\u02dd\u0005"+
		"\u00b0\u0000\u0000\u02dc\u02de\u0005L\u0000\u0000\u02dd\u02dc\u0001\u0000"+
		"\u0000\u0000\u02dd\u02de\u0001\u0000\u0000\u0000\u02de\u02df\u0001\u0000"+
		"\u0000\u0000\u02df\u02e0\u0003H$\u0000\u02e0G\u0001\u0000\u0000\u0000"+
		"\u02e1\u02e6\u0003J%\u0000\u02e2\u02e3\u0005\u0016\u0000\u0000\u02e3\u02e5"+
		"\u0003J%\u0000\u02e4\u02e2\u0001\u0000\u0000\u0000\u02e5\u02e8\u0001\u0000"+
		"\u0000\u0000\u02e6\u02e4\u0001\u0000\u0000\u0000\u02e6\u02e7\u0001\u0000"+
		"\u0000\u0000\u02e7I\u0001\u0000\u0000\u0000\u02e8\u02e6\u0001\u0000\u0000"+
		"\u0000\u02e9\u02eb\u0003L&\u0000\u02ea\u02ec\u00038\u001c\u0000\u02eb"+
		"\u02ea\u0001\u0000\u0000\u0000\u02eb\u02ec\u0001\u0000\u0000\u0000\u02ec"+
		"K\u0001\u0000\u0000\u0000\u02ed\u02f2\u0003P(\u0000\u02ee\u02f2\u0003"+
		"N\'\u0000\u02ef\u02f2\u0003Z-\u0000\u02f0\u02f2\u0003\u009eO\u0000\u02f1"+
		"\u02ed\u0001\u0000\u0000\u0000\u02f1\u02ee\u0001\u0000\u0000\u0000\u02f1"+
		"\u02ef\u0001\u0000\u0000\u0000\u02f1\u02f0\u0001\u0000\u0000\u0000\u02f2"+
		"M\u0001\u0000\u0000\u0000\u02f3\u02f4\u0005R\u0000\u0000\u02f4\u02f5\u0005"+
		"\u0018\u0000\u0000\u02f5\u02f6\u0003`0\u0000\u02f6\u02f7\u0005\u0019\u0000"+
		"\u0000\u02f7O\u0001\u0000\u0000\u0000\u02f8\u02f9\u0005\u008f\u0000\u0000"+
		"\u02f9\u02fa\u0003R)\u0000\u02fa\u02fb\u0005\u0018\u0000\u0000\u02fb\u02fc"+
		"\u0003T*\u0000\u02fc\u02fd\u0005\u0019\u0000\u0000\u02fdQ\u0001\u0000"+
		"\u0000\u0000\u02fe\u0302\u0005{\u0000\u0000\u02ff\u0302\u0005\u0081\u0000"+
		"\u0000\u0300\u0302\u0003\\.\u0000\u0301\u02fe\u0001\u0000\u0000\u0000"+
		"\u0301\u02ff\u0001\u0000\u0000\u0000\u0301\u0300\u0001\u0000\u0000\u0000"+
		"\u0302S\u0001\u0000\u0000\u0000\u0303\u0308\u0003V+\u0000\u0304\u0305"+
		"\u0005\u0016\u0000\u0000\u0305\u0307\u0003V+\u0000\u0306\u0304\u0001\u0000"+
		"\u0000\u0000\u0307\u030a\u0001\u0000\u0000\u0000\u0308\u0306\u0001\u0000"+
		"\u0000\u0000\u0308\u0309\u0001\u0000\u0000\u0000\u0309U\u0001\u0000\u0000"+
		"\u0000\u030a\u0308\u0001\u0000\u0000\u0000\u030b\u030d\u0003X,\u0000\u030c"+
		"\u030e\u00038\u001c\u0000\u030d\u030c\u0001\u0000\u0000\u0000\u030d\u030e"+
		"\u0001\u0000\u0000\u0000\u030eW\u0001\u0000\u0000\u0000\u030f\u0312\u0003"+
		"\u009eO\u0000\u0310\u0312\u0003P(\u0000\u0311\u030f\u0001\u0000\u0000"+
		"\u0000\u0311\u0310\u0001\u0000\u0000\u0000\u0312Y\u0001\u0000\u0000\u0000"+
		"\u0313\u0314\u0005\u0094\u0000\u0000\u0314\u0315\u0005\u0018\u0000\u0000"+
		"\u0315\u0316\u0003\u018a\u00c5\u0000\u0316\u0317\u0005\u0019\u0000\u0000"+
		"\u0317[\u0001\u0000\u0000\u0000\u0318\u031c\u0003\u018a\u00c5\u0000\u0319"+
		"\u031b\u0003^/\u0000\u031a\u0319\u0001\u0000\u0000\u0000\u031b\u031e\u0001"+
		"\u0000\u0000\u0000\u031c\u031a\u0001\u0000\u0000\u0000\u031c\u031d\u0001"+
		"\u0000\u0000\u0000\u031d]\u0001\u0000\u0000\u0000\u031e\u031c\u0001\u0000"+
		"\u0000\u0000\u031f\u0320\u0005\u0017\u0000\u0000\u0320\u0321\u0003\u018a"+
		"\u00c5\u0000\u0321_\u0001\u0000\u0000\u0000\u0322\u0324\u0003d2\u0000"+
		"\u0323\u0325\u0003b1\u0000\u0324\u0323\u0001\u0000\u0000\u0000\u0324\u0325"+
		"\u0001\u0000\u0000\u0000\u0325\u0328\u0001\u0000\u0000\u0000\u0326\u0328"+
		"\u0003f3\u0000\u0327\u0322\u0001\u0000\u0000\u0000\u0327\u0326\u0001\u0000"+
		"\u0000\u0000\u0328a\u0001\u0000\u0000\u0000\u0329\u032a\u0005\u0017\u0000"+
		"\u0000\u032a\u032b\u0003\\.\u0000\u032bc\u0001\u0000\u0000\u0000\u032c"+
		"\u0333\u0003j5\u0000\u032d\u0333\u0003l6\u0000\u032e\u0333\u0003n7\u0000"+
		"\u032f\u0330\u0003\\.\u0000\u0330\u0331\u0003h4\u0000\u0331\u0333\u0001"+
		"\u0000\u0000\u0000\u0332\u032c\u0001\u0000\u0000\u0000\u0332\u032d\u0001"+
		"\u0000\u0000\u0000\u0332\u032e\u0001\u0000\u0000\u0000\u0332\u032f\u0001"+
		"\u0000\u0000\u0000\u0333e\u0001\u0000\u0000\u0000\u0334\u0336\u0003\\"+
		".\u0000\u0335\u0337\u0003h4\u0000\u0336\u0335\u0001\u0000\u0000\u0000"+
		"\u0336\u0337\u0001\u0000\u0000\u0000\u0337g\u0001\u0000\u0000\u0000\u0338"+
		"\u0339\u0005\u001a\u0000\u0000\u0339\u033a\u0003\u009aM\u0000\u033a\u033d"+
		"\u0005\u001b\u0000\u0000\u033b\u033c\u0005\u0017\u0000\u0000\u033c\u033e"+
		"\u0003f3\u0000\u033d\u033b\u0001\u0000\u0000\u0000\u033d\u033e\u0001\u0000"+
		"\u0000\u0000\u033ei\u0001\u0000\u0000\u0000\u033f\u0340\u0005\u00be\u0000"+
		"\u0000\u0340\u0341\u0005\u0018\u0000\u0000\u0341\u0342\u0003`0\u0000\u0342"+
		"\u0343\u00052\u0000\u0000\u0343\u0344\u0003\\.\u0000\u0344\u0346\u0005"+
		"\u0019\u0000\u0000\u0345\u0347\u0003b1\u0000\u0346\u0345\u0001\u0000\u0000"+
		"\u0000\u0346\u0347\u0001\u0000\u0000\u0000\u0347k\u0001\u0000\u0000\u0000"+
		"\u0348\u0349\u0007\u0003\u0000\u0000\u0349\u034a\u0005\u0018\u0000\u0000"+
		"\u034a\u034b\u0003`0\u0000\u034b\u034d\u0005\u0019\u0000\u0000\u034c\u034e"+
		"\u0003b1\u0000\u034d\u034c\u0001\u0000\u0000\u0000\u034d\u034e\u0001\u0000"+
		"\u0000\u0000\u034em\u0001\u0000\u0000\u0000\u034f\u0350\u0007\u0004\u0000"+
		"\u0000\u0350\u0351\u0005\u0018\u0000\u0000\u0351\u0352\u0003`0\u0000\u0352"+
		"\u0354\u0005\u0019\u0000\u0000\u0353\u0355\u0003b1\u0000\u0354\u0353\u0001"+
		"\u0000\u0000\u0000\u0354\u0355\u0001\u0000\u0000\u0000\u0355o\u0001\u0000"+
		"\u0000\u0000\u0356\u0357\u0005d\u0000\u0000\u0357\u0358\u00058\u0000\u0000"+
		"\u0358\u035d\u0003r9\u0000\u0359\u035a\u0005\u0016\u0000\u0000\u035a\u035c"+
		"\u0003r9\u0000\u035b\u0359\u0001\u0000\u0000\u0000\u035c\u035f\u0001\u0000"+
		"\u0000\u0000\u035d\u035b\u0001\u0000\u0000\u0000\u035d\u035e\u0001\u0000"+
		"\u0000\u0000\u035eq\u0001\u0000\u0000\u0000\u035f\u035d\u0001\u0000\u0000"+
		"\u0000\u0360\u0364\u0003\u018a\u00c5\u0000\u0361\u0364\u0005\u0003\u0000"+
		"\u0000\u0362\u0364\u0003\u009aM\u0000\u0363\u0360\u0001\u0000\u0000\u0000"+
		"\u0363\u0361\u0001\u0000\u0000\u0000\u0363\u0362\u0001\u0000\u0000\u0000"+
		"\u0364s\u0001\u0000\u0000\u0000\u0365\u0366\u0005f\u0000\u0000\u0366\u0367"+
		"\u0003\u0092I\u0000\u0367u\u0001\u0000\u0000\u0000\u0368\u0369\u0005\u009b"+
		"\u0000\u0000\u0369\u036a\u00058\u0000\u0000\u036a\u036f\u0003z=\u0000"+
		"\u036b\u036c\u0005\u0016\u0000\u0000\u036c\u036e\u0003z=\u0000\u036d\u036b"+
		"\u0001\u0000\u0000\u0000\u036e\u0371\u0001\u0000\u0000\u0000\u036f\u036d"+
		"\u0001\u0000\u0000\u0000\u036f\u0370\u0001\u0000\u0000\u0000\u0370w\u0001"+
		"\u0000\u0000\u0000\u0371\u036f\u0001\u0000\u0000\u0000\u0372\u0377\u0003"+
		"z=\u0000\u0373\u0374\u0005\u0016\u0000\u0000\u0374\u0376\u0003z=\u0000"+
		"\u0375\u0373\u0001\u0000\u0000\u0000\u0376\u0379\u0001\u0000\u0000\u0000"+
		"\u0377\u0375\u0001\u0000\u0000\u0000\u0377\u0378\u0001\u0000\u0000\u0000"+
		"\u0378y\u0001\u0000\u0000\u0000\u0379\u0377\u0001\u0000\u0000\u0000\u037a"+
		"\u037c\u0003~?\u0000\u037b\u037d\u0003\u0080@\u0000\u037c\u037b\u0001"+
		"\u0000\u0000\u0000\u037c\u037d\u0001\u0000\u0000\u0000\u037d\u037f\u0001"+
		"\u0000\u0000\u0000\u037e\u0380\u0003|>\u0000\u037f\u037e\u0001\u0000\u0000"+
		"\u0000\u037f\u0380\u0001\u0000\u0000\u0000\u0380{\u0001\u0000\u0000\u0000"+
		"\u0381\u0382\u0005\u0093\u0000\u0000\u0382\u0383\u0007\u0005\u0000\u0000"+
		"\u0383}\u0001\u0000\u0000\u0000\u0384\u0388\u0003\u018a\u00c5\u0000\u0385"+
		"\u0388\u0005\u0003\u0000\u0000\u0386\u0388\u0003\u009aM\u0000\u0387\u0384"+
		"\u0001\u0000\u0000\u0000\u0387\u0385\u0001\u0000\u0000\u0000\u0387\u0386"+
		"\u0001\u0000\u0000\u0000\u0388\u007f\u0001\u0000\u0000\u0000\u0389\u038a"+
		"\u0007\u0006\u0000\u0000\u038a\u0081\u0001\u0000\u0000\u0000\u038b\u038c"+
		"\u0005;\u0000\u0000\u038c\u038d\u0005\u0018\u0000\u0000\u038d\u038e\u0003"+
		"\u009aM\u0000\u038e\u038f\u00052\u0000\u0000\u038f\u0390\u0003\u0084B"+
		"\u0000\u0390\u0391\u0005\u0019\u0000\u0000\u0391\u0083\u0001\u0000\u0000"+
		"\u0000\u0392\u0393\u0003\\.\u0000\u0393\u0085\u0001\u0000\u0000\u0000"+
		"\u0394\u0395\u0005z\u0000\u0000\u0395\u0396\u0003\u008cF\u0000\u0396\u0087"+
		"\u0001\u0000\u0000\u0000\u0397\u0398\u0005\u0096\u0000\u0000\u0398\u039a"+
		"\u0003\u008cF\u0000\u0399\u039b\u0007\u0007\u0000\u0000\u039a\u0399\u0001"+
		"\u0000\u0000\u0000\u039a\u039b\u0001\u0000\u0000\u0000\u039b\u0089\u0001"+
		"\u0000\u0000\u0000\u039c\u039d\u0005[\u0000\u0000\u039d\u03a2\u0007\b"+
		"\u0000\u0000\u039e\u03a3\u0003\u008cF\u0000\u039f\u03a0\u0003\u008eG\u0000"+
		"\u03a0\u03a1\u0005\u00a3\u0000\u0000\u03a1\u03a3\u0001\u0000\u0000\u0000"+
		"\u03a2\u039e\u0001\u0000\u0000\u0000\u03a2\u039f\u0001\u0000\u0000\u0000"+
		"\u03a3\u03a4\u0001\u0000\u0000\u0000\u03a4\u03a8\u0007\u0007\u0000\u0000"+
		"\u03a5\u03a9\u0005\u0099\u0000\u0000\u03a6\u03a7\u0005\u00cc\u0000\u0000"+
		"\u03a7\u03a9\u0005\u00b7\u0000\u0000\u03a8\u03a5\u0001\u0000\u0000\u0000"+
		"\u03a8\u03a6\u0001\u0000\u0000\u0000\u03a9\u008b\u0001\u0000\u0000\u0000"+
		"\u03aa\u03ad\u0003\u0100\u0080\u0000\u03ab\u03ad\u0005\u0003\u0000\u0000"+
		"\u03ac\u03aa\u0001\u0000\u0000\u0000\u03ac\u03ab\u0001\u0000\u0000\u0000"+
		"\u03ad\u008d\u0001\u0000\u0000\u0000\u03ae\u03b3\u0003\u0100\u0080\u0000"+
		"\u03af\u03b3\u0005\u0003\u0000\u0000\u03b0\u03b3\u0005\u0005\u0000\u0000"+
		"\u03b1\u03b3\u0005\u0006\u0000\u0000\u03b2\u03ae\u0001\u0000\u0000\u0000"+
		"\u03b2\u03af\u0001\u0000\u0000\u0000\u03b2\u03b0\u0001\u0000\u0000\u0000"+
		"\u03b2\u03b1\u0001\u0000\u0000\u0000\u03b3\u008f\u0001\u0000\u0000\u0000"+
		"\u03b4\u03b5\u0005\u00cb\u0000\u0000\u03b5\u03b6\u0003\u0092I\u0000\u03b6"+
		"\u0091\u0001\u0000\u0000\u0000\u03b7\u03b8\u0006I\uffff\uffff\u0000\u03b8"+
		"\u03b9\u0005\u0018\u0000\u0000\u03b9\u03ba\u0003\u0092I\u0000\u03ba\u03bb"+
		"\u0005\u0019\u0000\u0000\u03bb\u03fd\u0001\u0000\u0000\u0000\u03bc\u03bd"+
		"\u0003\u009aM\u0000\u03bd\u03bf\u0005r\u0000\u0000\u03be\u03c0\u0005\u0092"+
		"\u0000\u0000\u03bf\u03be\u0001\u0000\u0000\u0000\u03bf\u03c0\u0001\u0000"+
		"\u0000\u0000\u03c0\u03c1\u0001\u0000\u0000\u0000\u03c1\u03c2\u0005\u00d3"+
		"\u0000\u0000\u03c2\u03fd\u0001\u0000\u0000\u0000\u03c3\u03c4\u0003\u009a"+
		"M\u0000\u03c4\u03c6\u0005r\u0000\u0000\u03c5\u03c7\u0005\u0092\u0000\u0000"+
		"\u03c6\u03c5\u0001\u0000\u0000\u0000\u03c6\u03c7\u0001\u0000\u0000\u0000"+
		"\u03c7\u03c8\u0001\u0000\u0000\u0000\u03c8\u03c9\u0005P\u0000\u0000\u03c9"+
		"\u03fd\u0001\u0000\u0000\u0000\u03ca\u03cc\u0003\u009aM\u0000\u03cb\u03cd"+
		"\u0005\u0092\u0000\u0000\u03cc\u03cb\u0001\u0000\u0000\u0000\u03cc\u03cd"+
		"\u0001\u0000\u0000\u0000\u03cd\u03ce\u0001\u0000\u0000\u0000\u03ce\u03cf"+
		"\u0005j\u0000\u0000\u03cf\u03d0\u0003\u0096K\u0000\u03d0\u03fd\u0001\u0000"+
		"\u0000\u0000\u03d1\u03d3\u0003\u009aM\u0000\u03d2\u03d4\u0005\u0092\u0000"+
		"\u0000\u03d3\u03d2\u0001\u0000\u0000\u0000\u03d3\u03d4\u0001\u0000\u0000"+
		"\u0000\u03d4\u03d5\u0001\u0000\u0000\u0000\u03d5\u03d6\u00055\u0000\u0000"+
		"\u03d6\u03d7\u0003\u009aM\u0000\u03d7\u03d8\u00050\u0000\u0000\u03d8\u03d9"+
		"\u0003\u009aM\u0000\u03d9\u03fd\u0001\u0000\u0000\u0000\u03da\u03dc\u0003"+
		"\u009aM\u0000\u03db\u03dd\u0005\u0092\u0000\u0000\u03dc\u03db\u0001\u0000"+
		"\u0000\u0000\u03dc\u03dd\u0001\u0000\u0000\u0000\u03dd\u03de\u0001\u0000"+
		"\u0000\u0000\u03de\u03df\u0007\t\u0000\u0000\u03df\u03e1\u0003\u009aM"+
		"\u0000\u03e0\u03e2\u0003\u0098L\u0000\u03e1\u03e0\u0001\u0000\u0000\u0000"+
		"\u03e1\u03e2\u0001\u0000\u0000\u0000\u03e2\u03fd\u0001\u0000\u0000\u0000"+
		"\u03e3\u03e4\u0003\u009aM\u0000\u03e4\u03e5\u0003\u0094J\u0000\u03e5\u03e6"+
		"\u0003\u009aM\u0000\u03e6\u03fd\u0001\u0000\u0000\u0000\u03e7\u03e8\u0005"+
		"Y\u0000\u0000\u03e8\u03e9\u0007\n\u0000\u0000\u03e9\u03ea\u0005\u0018"+
		"\u0000\u0000\u03ea\u03eb\u0003\\.\u0000\u03eb\u03ec\u0005\u0019\u0000"+
		"\u0000\u03ec\u03fd\u0001\u0000\u0000\u0000\u03ed\u03ee\u0005Y\u0000\u0000"+
		"\u03ee\u03fd\u0003\u009aM\u0000\u03ef\u03f1\u0003\u009aM\u0000\u03f0\u03f2"+
		"\u0005\u0092\u0000\u0000\u03f1\u03f0\u0001\u0000\u0000\u0000\u03f1\u03f2"+
		"\u0001\u0000\u0000\u0000\u03f2\u03f3\u0001\u0000\u0000\u0000\u03f3\u03f5"+
		"\u0005\u0086\u0000\u0000\u03f4\u03f6\u0005\u0095\u0000\u0000\u03f5\u03f4"+
		"\u0001\u0000\u0000\u0000\u03f5\u03f6\u0001\u0000\u0000\u0000\u03f6\u03f7"+
		"\u0001\u0000\u0000\u0000\u03f7\u03f8\u0003`0\u0000\u03f8\u03fd\u0001\u0000"+
		"\u0000\u0000\u03f9\u03fa\u0005\u0092\u0000\u0000\u03fa\u03fd\u0003\u0092"+
		"I\u0004\u03fb\u03fd\u0003\u009aM\u0000\u03fc\u03b7\u0001\u0000\u0000\u0000"+
		"\u03fc\u03bc\u0001\u0000\u0000\u0000\u03fc\u03c3\u0001\u0000\u0000\u0000"+
		"\u03fc\u03ca\u0001\u0000\u0000\u0000\u03fc\u03d1\u0001\u0000\u0000\u0000"+
		"\u03fc\u03da\u0001\u0000\u0000\u0000\u03fc\u03e3\u0001\u0000\u0000\u0000"+
		"\u03fc\u03e7\u0001\u0000\u0000\u0000\u03fc\u03ed\u0001\u0000\u0000\u0000"+
		"\u03fc\u03ef\u0001\u0000\u0000\u0000\u03fc\u03f9\u0001\u0000\u0000\u0000"+
		"\u03fc\u03fb\u0001\u0000\u0000\u0000\u03fd\u0406\u0001\u0000\u0000\u0000"+
		"\u03fe\u03ff\n\u0003\u0000\u0000\u03ff\u0400\u00050\u0000\u0000\u0400"+
		"\u0405\u0003\u0092I\u0004\u0401\u0402\n\u0002\u0000\u0000\u0402\u0403"+
		"\u0005\u009a\u0000\u0000\u0403\u0405\u0003\u0092I\u0003\u0404\u03fe\u0001"+
		"\u0000\u0000\u0000\u0404\u0401\u0001\u0000\u0000\u0000\u0405\u0408\u0001"+
		"\u0000\u0000\u0000\u0406\u0404\u0001\u0000\u0000\u0000\u0406\u0407\u0001"+
		"\u0000\u0000\u0000\u0407\u0093\u0001\u0000\u0000\u0000\u0408\u0406\u0001"+
		"\u0000\u0000\u0000\u0409\u0417\u0005\u0010\u0000\u0000\u040a\u0417\u0005"+
		"\u0011\u0000\u0000\u040b\u0417\u0005\u0012\u0000\u0000\u040c\u0417\u0005"+
		"\u0013\u0000\u0000\u040d\u0417\u0005\u0014\u0000\u0000\u040e\u0417\u0005"+
		"\u0015\u0000\u0000\u040f\u0410\u0005r\u0000\u0000\u0410\u0411\u0005L\u0000"+
		"\u0000\u0411\u0417\u0005a\u0000\u0000\u0412\u0413\u0005r\u0000\u0000\u0413"+
		"\u0414\u0005\u0092\u0000\u0000\u0414\u0415\u0005L\u0000\u0000\u0415\u0417"+
		"\u0005a\u0000\u0000\u0416\u0409\u0001\u0000\u0000\u0000\u0416\u040a\u0001"+
		"\u0000\u0000\u0000\u0416\u040b\u0001\u0000\u0000\u0000\u0416\u040c\u0001"+
		"\u0000\u0000\u0000\u0416\u040d\u0001\u0000\u0000\u0000\u0416\u040e\u0001"+
		"\u0000\u0000\u0000\u0416\u040f\u0001\u0000\u0000\u0000\u0416\u0412\u0001"+
		"\u0000\u0000\u0000\u0417\u0095\u0001\u0000\u0000\u0000\u0418\u0419\u0007"+
		"\n\u0000\u0000\u0419\u041a\u0005\u0018\u0000\u0000\u041a\u041b\u0003\\"+
		".\u0000\u041b\u041c\u0005\u0019\u0000\u0000\u041c\u042f\u0001\u0000\u0000"+
		"\u0000\u041d\u0426\u0005\u0018\u0000\u0000\u041e\u0423\u0003\u009eO\u0000"+
		"\u041f\u0420\u0005\u0016\u0000\u0000\u0420\u0422\u0003\u009eO\u0000\u0421"+
		"\u041f\u0001\u0000\u0000\u0000\u0422\u0425\u0001\u0000\u0000\u0000\u0423"+
		"\u0421\u0001\u0000\u0000\u0000\u0423\u0424\u0001\u0000\u0000\u0000\u0424"+
		"\u0427\u0001\u0000\u0000\u0000\u0425\u0423\u0001\u0000\u0000\u0000\u0426"+
		"\u041e\u0001\u0000\u0000\u0000\u0426\u0427\u0001\u0000\u0000\u0000\u0427"+
		"\u0428\u0001\u0000\u0000\u0000\u0428\u042f\u0005\u0019\u0000\u0000\u0429"+
		"\u042a\u0005\u0018\u0000\u0000\u042a\u042b\u0003\u0004\u0002\u0000\u042b"+
		"\u042c\u0005\u0019\u0000\u0000\u042c\u042f\u0001\u0000\u0000\u0000\u042d"+
		"\u042f\u0003\u0100\u0080\u0000\u042e\u0418\u0001\u0000\u0000\u0000\u042e"+
		"\u041d\u0001\u0000\u0000\u0000\u042e\u0429\u0001\u0000\u0000\u0000\u042e"+
		"\u042d\u0001\u0000\u0000\u0000\u042f\u0097\u0001\u0000\u0000\u0000\u0430"+
		"\u0434\u0005U\u0000\u0000\u0431\u0435\u0005\n\u0000\u0000\u0432\u0435"+
		"\u0005\u000b\u0000\u0000\u0433\u0435\u0003\u0100\u0080\u0000\u0434\u0431"+
		"\u0001\u0000\u0000\u0000\u0434\u0432\u0001\u0000\u0000\u0000\u0434\u0433"+
		"\u0001\u0000\u0000\u0000\u0435\u0099\u0001\u0000\u0000\u0000\u0436\u0437"+
		"\u0006M\uffff\uffff\u0000\u0437\u0438\u0005\u0018\u0000\u0000\u0438\u0439"+
		"\u0003\u009aM\u0000\u0439\u043a\u0005\u0019\u0000\u0000\u043a\u0451\u0001"+
		"\u0000\u0000\u0000\u043b\u043c\u0005\u0018\u0000\u0000\u043c\u043f\u0003"+
		"\u009eO\u0000\u043d\u043e\u0005\u0016\u0000\u0000\u043e\u0440\u0003\u009e"+
		"O\u0000\u043f\u043d\u0001\u0000\u0000\u0000\u0440\u0441\u0001\u0000\u0000"+
		"\u0000\u0441\u043f\u0001\u0000\u0000\u0000\u0441\u0442\u0001\u0000\u0000"+
		"\u0000\u0442\u0443\u0001\u0000\u0000\u0000\u0443\u0444\u0005\u0019\u0000"+
		"\u0000\u0444\u0451\u0001\u0000\u0000\u0000\u0445\u0446\u0005\u0018\u0000"+
		"\u0000\u0446\u0447\u0003\u0004\u0002\u0000\u0447\u0448\u0005\u0019\u0000"+
		"\u0000\u0448\u0451\u0001\u0000\u0000\u0000\u0449\u0451\u0003\u009cN\u0000"+
		"\u044a\u044b\u0003\u00a4R\u0000\u044b\u044c\u0003\u00c0`\u0000\u044c\u0451"+
		"\u0001\u0000\u0000\u0000\u044d\u044e\u0003\u00a4R\u0000\u044e\u044f\u0003"+
		"\u009aM\u0006\u044f\u0451\u0001\u0000\u0000\u0000\u0450\u0436\u0001\u0000"+
		"\u0000\u0000\u0450\u043b\u0001\u0000\u0000\u0000\u0450\u0445\u0001\u0000"+
		"\u0000\u0000\u0450\u0449\u0001\u0000\u0000\u0000\u0450\u044a\u0001\u0000"+
		"\u0000\u0000\u0450\u044d\u0001\u0000\u0000\u0000\u0451\u0464\u0001\u0000"+
		"\u0000\u0000\u0452\u0453\n\u0003\u0000\u0000\u0453\u0454\u0003\u00a0P"+
		"\u0000\u0454\u0455\u0003\u009aM\u0004\u0455\u0463\u0001\u0000\u0000\u0000"+
		"\u0456\u0457\n\u0002\u0000\u0000\u0457\u0458\u0003\u00a2Q\u0000\u0458"+
		"\u0459\u0003\u009aM\u0003\u0459\u0463\u0001\u0000\u0000\u0000\u045a\u045b"+
		"\n\u0001\u0000\u0000\u045b\u045c\u0005\'\u0000\u0000\u045c\u0463\u0003"+
		"\u009aM\u0002\u045d\u045e\n\u0005\u0000\u0000\u045e\u0463\u0003\u0174"+
		"\u00ba\u0000\u045f\u0460\n\u0004\u0000\u0000\u0460\u0461\u00058\u0000"+
		"\u0000\u0461\u0463\u0003\u0174\u00ba\u0000\u0462\u0452\u0001\u0000\u0000"+
		"\u0000\u0462\u0456\u0001\u0000\u0000\u0000\u0462\u045a\u0001\u0000\u0000"+
		"\u0000\u0462\u045d\u0001\u0000\u0000\u0000\u0462\u045f\u0001\u0000\u0000"+
		"\u0000\u0463\u0466\u0001\u0000\u0000\u0000\u0464\u0462\u0001\u0000\u0000"+
		"\u0000\u0464\u0465\u0001\u0000\u0000\u0000\u0465\u009b\u0001\u0000\u0000"+
		"\u0000\u0466\u0464\u0001\u0000\u0000\u0000\u0467\u0476\u0003\u00b0X\u0000"+
		"\u0468\u0476\u0003\u00bc^\u0000\u0469\u0476\u0003\u0100\u0080\u0000\u046a"+
		"\u0476\u0003\u00a6S\u0000\u046b\u0476\u0003\u00a8T\u0000\u046c\u0476\u0003"+
		"\u00aaU\u0000\u046d\u0476\u0003\u00acV\u0000\u046e\u0476\u0003\u00aeW"+
		"\u0000\u046f\u0471\u0003d2\u0000\u0470\u0472\u0003b1\u0000\u0471\u0470"+
		"\u0001\u0000\u0000\u0000\u0471\u0472\u0001\u0000\u0000\u0000\u0472\u0476"+
		"\u0001\u0000\u0000\u0000\u0473\u0476\u0003\u0102\u0081\u0000\u0474\u0476"+
		"\u0003f3\u0000\u0475\u0467\u0001\u0000\u0000\u0000\u0475\u0468\u0001\u0000"+
		"\u0000\u0000\u0475\u0469\u0001\u0000\u0000\u0000\u0475\u046a\u0001\u0000"+
		"\u0000\u0000\u0475\u046b\u0001\u0000\u0000\u0000\u0475\u046c\u0001\u0000"+
		"\u0000\u0000\u0475\u046d\u0001\u0000\u0000\u0000\u0475\u046e\u0001\u0000"+
		"\u0000\u0000\u0475\u046f\u0001\u0000\u0000\u0000\u0475\u0473\u0001\u0000"+
		"\u0000\u0000\u0475\u0474\u0001\u0000\u0000\u0000\u0476\u009d\u0001\u0000"+
		"\u0000\u0000\u0477\u047a\u0003\u009aM\u0000\u0478\u047a\u0003\u0092I\u0000"+
		"\u0479\u0477\u0001\u0000\u0000\u0000\u0479\u0478\u0001\u0000\u0000\u0000"+
		"\u047a\u009f\u0001\u0000\u0000\u0000\u047b\u047c\u0007\u000b\u0000\u0000"+
		"\u047c\u00a1\u0001\u0000\u0000\u0000\u047d\u047e\u0007\f\u0000\u0000\u047e"+
		"\u00a3\u0001\u0000\u0000\u0000\u047f\u0480\u0007\f\u0000\u0000\u0480\u00a5"+
		"\u0001\u0000\u0000\u0000\u0481\u0482\u0005\u00c2\u0000\u0000\u0482\u0485"+
		"\u0005\u0018\u0000\u0000\u0483\u0486\u0003`0\u0000\u0484\u0486\u0003\u0100"+
		"\u0080\u0000\u0485\u0483\u0001\u0000\u0000\u0000\u0485\u0484\u0001\u0000"+
		"\u0000\u0000\u0486\u0487\u0001\u0000\u0000\u0000\u0487\u0488\u0005\u0019"+
		"\u0000\u0000\u0488\u00a7\u0001\u0000\u0000\u0000\u0489\u048a\u0005*\u0000"+
		"\u0000\u048a\u048b\u0005\u0018\u0000\u0000\u048b\u048c\u0003`0\u0000\u048c"+
		"\u048e\u0005\u0019\u0000\u0000\u048d\u048f\u0003b1\u0000\u048e\u048d\u0001"+
		"\u0000\u0000\u0000\u048e\u048f\u0001\u0000\u0000\u0000\u048f\u00a9\u0001"+
		"\u0000\u0000\u0000\u0490\u0491\u0005+\u0000\u0000\u0491\u0492\u0005\u0018"+
		"\u0000\u0000\u0492\u0493\u0003`0\u0000\u0493\u0494\u0005\u0019\u0000\u0000"+
		"\u0494\u00ab\u0001\u0000\u0000\u0000\u0495\u0496\u0005-\u0000\u0000\u0496"+
		"\u0497\u0005\u0018\u0000\u0000\u0497\u0498\u0003`0\u0000\u0498\u049a\u0005"+
		"\u0019\u0000\u0000\u0499\u049b\u0003b1\u0000\u049a\u0499\u0001\u0000\u0000"+
		"\u0000\u049a\u049b\u0001\u0000\u0000\u0000\u049b\u00ad\u0001\u0000\u0000"+
		"\u0000\u049c\u049d\u0005.\u0000\u0000\u049d\u049e\u0005\u0018\u0000\u0000"+
		"\u049e\u049f\u0003`0\u0000\u049f\u04a0\u0005\u0019\u0000\u0000\u04a0\u00af"+
		"\u0001\u0000\u0000\u0000\u04a1\u04a4\u0003\u00b2Y\u0000\u04a2\u04a4\u0003"+
		"\u00b8\\\u0000\u04a3\u04a1\u0001\u0000\u0000\u0000\u04a3\u04a2\u0001\u0000"+
		"\u0000\u0000\u04a4\u00b1\u0001\u0000\u0000\u0000\u04a5\u04a6\u00059\u0000"+
		"\u0000\u04a6\u04a8\u0003\u009eO\u0000\u04a7\u04a9\u0003\u00b4Z\u0000\u04a8"+
		"\u04a7\u0001\u0000\u0000\u0000\u04a9\u04aa\u0001\u0000\u0000\u0000\u04aa"+
		"\u04a8\u0001\u0000\u0000\u0000\u04aa\u04ab\u0001\u0000\u0000\u0000\u04ab"+
		"\u04ad\u0001\u0000\u0000\u0000\u04ac\u04ae\u0003\u00b6[\u0000\u04ad\u04ac"+
		"\u0001\u0000\u0000\u0000\u04ad\u04ae\u0001\u0000\u0000\u0000\u04ae\u04af"+
		"\u0001\u0000\u0000\u0000\u04af\u04b0\u0005Q\u0000\u0000\u04b0\u00b3\u0001"+
		"\u0000\u0000\u0000\u04b1\u04b2\u0005\u00ca\u0000\u0000\u04b2\u04b3\u0003"+
		"\u009aM\u0000\u04b3\u04b4\u0005\u00b6\u0000\u0000\u04b4\u04b5\u0003\u009e"+
		"O\u0000\u04b5\u00b5\u0001\u0000\u0000\u0000\u04b6\u04b7\u0005O\u0000\u0000"+
		"\u04b7\u04b8\u0003\u009eO\u0000\u04b8\u00b7\u0001\u0000\u0000\u0000\u04b9"+
		"\u04bb\u00059\u0000\u0000\u04ba\u04bc\u0003\u00ba]\u0000\u04bb\u04ba\u0001"+
		"\u0000\u0000\u0000\u04bc\u04bd\u0001\u0000\u0000\u0000\u04bd\u04bb\u0001"+
		"\u0000\u0000\u0000\u04bd\u04be\u0001\u0000\u0000\u0000\u04be\u04c0\u0001"+
		"\u0000\u0000\u0000\u04bf\u04c1\u0003\u00b6[\u0000\u04c0\u04bf\u0001\u0000"+
		"\u0000\u0000\u04c0\u04c1\u0001\u0000\u0000\u0000\u04c1\u04c2\u0001\u0000"+
		"\u0000\u0000\u04c2\u04c3\u0005Q\u0000\u0000\u04c3\u00b9\u0001\u0000\u0000"+
		"\u0000\u04c4\u04c5\u0005\u00ca\u0000\u0000\u04c5\u04c6\u0003\u0092I\u0000"+
		"\u04c6\u04c7\u0005\u00b6\u0000\u0000\u04c7\u04c8\u0003\u009eO\u0000\u04c8"+
		"\u00bb\u0001\u0000\u0000\u0000\u04c9\u04d2\u0005\n\u0000\u0000\u04ca\u04d2"+
		"\u0005\u000b\u0000\u0000\u04cb\u04d2\u0005\u00d3\u0000\u0000\u04cc\u04d2"+
		"\u0003\u00be_\u0000\u04cd\u04d2\u0003\u00c0`\u0000\u04ce\u04d2\u0003\u00c2"+
		"a\u0000\u04cf\u04d2\u0003\u00c4b\u0000\u04d0\u04d2\u0003\u00fa}\u0000"+
		"\u04d1\u04c9\u0001\u0000\u0000\u0000\u04d1\u04ca\u0001\u0000\u0000\u0000"+
		"\u04d1\u04cb\u0001\u0000\u0000\u0000\u04d1\u04cc\u0001\u0000\u0000\u0000"+
		"\u04d1\u04cd\u0001\u0000\u0000\u0000\u04d1\u04ce\u0001\u0000\u0000\u0000"+
		"\u04d1\u04cf\u0001\u0000\u0000\u0000\u04d1\u04d0\u0001\u0000\u0000\u0000"+
		"\u04d2\u00bd\u0001\u0000\u0000\u0000\u04d3\u04d4\u0007\r\u0000\u0000\u04d4"+
		"\u00bf\u0001\u0000\u0000\u0000\u04d5\u04d6\u0007\u000e\u0000\u0000\u04d6"+
		"\u00c1\u0001\u0000\u0000\u0000\u04d7\u04e3\u0005\f\u0000\u0000\u04d8\u04d9"+
		"\u0005\u001c\u0000\u0000\u04d9\u04de\u0005\t\u0000\u0000\u04da\u04db\u0005"+
		"\u0016\u0000\u0000\u04db\u04dd\u0005\t\u0000\u0000\u04dc\u04da\u0001\u0000"+
		"\u0000\u0000\u04dd\u04e0\u0001\u0000\u0000\u0000\u04de\u04dc\u0001\u0000"+
		"\u0000\u0000\u04de\u04df\u0001\u0000\u0000\u0000\u04df\u04e1\u0001\u0000"+
		"\u0000\u0000\u04e0\u04de\u0001\u0000\u0000\u0000\u04e1\u04e3\u0005\u001d"+
		"\u0000\u0000\u04e2\u04d7\u0001\u0000\u0000\u0000\u04e2\u04d8\u0001\u0000"+
		"\u0000\u0000\u04e3\u00c3\u0001\u0000\u0000\u0000\u04e4\u04eb\u0003\u00c6"+
		"c\u0000\u04e5\u04eb\u0003\u00ceg\u0000\u04e6\u04eb\u0003\u00d0h\u0000"+
		"\u04e7\u04eb\u0003\u00f2y\u0000\u04e8\u04eb\u0003\u00f4z\u0000\u04e9\u04eb"+
		"\u0003\u00f6{\u0000\u04ea\u04e4\u0001\u0000\u0000\u0000\u04ea\u04e5\u0001"+
		"\u0000\u0000\u0000\u04ea\u04e6\u0001\u0000\u0000\u0000\u04ea\u04e7\u0001"+
		"\u0000\u0000\u0000\u04ea\u04e8\u0001\u0000\u0000\u0000\u04ea\u04e9\u0001"+
		"\u0000\u0000\u0000\u04eb\u00c5\u0001\u0000\u0000\u0000\u04ec\u04f0\u0003"+
		"\u00c8d\u0000\u04ed\u04f0\u0003\u00cae\u0000\u04ee\u04f0\u0003\u00ccf"+
		"\u0000\u04ef\u04ec\u0001\u0000\u0000\u0000\u04ef\u04ed\u0001\u0000\u0000"+
		"\u0000\u04ef\u04ee\u0001\u0000\u0000\u0000\u04f0\u00c7\u0001\u0000\u0000"+
		"\u0000\u04f1\u04f2\u0005\u001c\u0000\u0000\u04f2\u04f3\u0003\u00d4j\u0000"+
		"\u04f3\u04f4\u0005\u001d\u0000\u0000\u04f4\u04fb\u0001\u0000\u0000\u0000"+
		"\u04f5\u04f7\u0005}\u0000\u0000\u04f6\u04f5\u0001\u0000\u0000\u0000\u04f6"+
		"\u04f7\u0001\u0000\u0000\u0000\u04f7\u04f8\u0001\u0000\u0000\u0000\u04f8"+
		"\u04f9\u0005F\u0000\u0000\u04f9\u04fb\u0003\u00d4j\u0000\u04fa\u04f1\u0001"+
		"\u0000\u0000\u0000\u04fa\u04f6\u0001\u0000\u0000\u0000\u04fb\u00c9\u0001"+
		"\u0000\u0000\u0000\u04fc\u04fd\u0005\u001c\u0000\u0000\u04fd\u04fe\u0003"+
		"\u00d6k\u0000\u04fe\u04ff\u0005\u001d\u0000\u0000\u04ff\u0506\u0001\u0000"+
		"\u0000\u0000\u0500\u0502\u0005\u00d0\u0000\u0000\u0501\u0500\u0001\u0000"+
		"\u0000\u0000\u0501\u0502\u0001\u0000\u0000\u0000\u0502\u0503\u0001\u0000"+
		"\u0000\u0000\u0503\u0504\u0005F\u0000\u0000\u0504\u0506\u0003\u00d6k\u0000"+
		"\u0505\u04fc\u0001\u0000\u0000\u0000\u0505\u0501\u0001\u0000\u0000\u0000"+
		"\u0506\u00cb\u0001\u0000\u0000\u0000\u0507\u0508\u0005\u001c\u0000\u0000"+
		"\u0508\u0509\u0003\u00d8l\u0000\u0509\u050a\u0005\u001d\u0000\u0000\u050a"+
		"\u0511\u0001\u0000\u0000\u0000\u050b\u050d\u0005\u0096\u0000\u0000\u050c"+
		"\u050b\u0001\u0000\u0000\u0000\u050c\u050d\u0001\u0000\u0000\u0000\u050d"+
		"\u050e\u0001\u0000\u0000\u0000\u050e\u050f\u0005F\u0000\u0000\u050f\u0511"+
		"\u0003\u00dam\u0000\u0510\u0507\u0001\u0000\u0000\u0000\u0510\u050c\u0001"+
		"\u0000\u0000\u0000\u0511\u00cd\u0001\u0000\u0000\u0000\u0512\u0513\u0005"+
		"\u001c\u0000\u0000\u0513\u0514\u0003\u00dcn\u0000\u0514\u0515\u0005\u001d"+
		"\u0000\u0000\u0515\u051c\u0001\u0000\u0000\u0000\u0516\u0518\u0005}\u0000"+
		"\u0000\u0517\u0516\u0001\u0000\u0000\u0000\u0517\u0518\u0001\u0000\u0000"+
		"\u0000\u0518\u0519\u0001\u0000\u0000\u0000\u0519\u051a\u0005E\u0000\u0000"+
		"\u051a\u051c\u0003\u00dcn\u0000\u051b\u0512\u0001\u0000\u0000\u0000\u051b"+
		"\u0517\u0001\u0000\u0000\u0000\u051c\u00cf\u0001\u0000\u0000\u0000\u051d"+
		"\u051e\u0005\u001c\u0000\u0000\u051e\u051f\u0003\u00deo\u0000\u051f\u0520"+
		"\u0005\u001d\u0000\u0000\u0520\u0527\u0001\u0000\u0000\u0000\u0521\u0523"+
		"\u0005}\u0000\u0000\u0522\u0521\u0001\u0000\u0000\u0000\u0522\u0523\u0001"+
		"\u0000\u0000\u0000\u0523\u0524\u0001\u0000\u0000\u0000\u0524\u0525\u0005"+
		"\u00b8\u0000\u0000\u0525\u0527\u0003\u00deo\u0000\u0526\u051d\u0001\u0000"+
		"\u0000\u0000\u0526\u0522\u0001\u0000\u0000\u0000\u0527\u00d1\u0001\u0000"+
		"\u0000\u0000\u0528\u052c\u0003\u00d4j\u0000\u0529\u052c\u0003\u00d6k\u0000"+
		"\u052a\u052c\u0003\u00d8l\u0000\u052b\u0528\u0001\u0000\u0000\u0000\u052b"+
		"\u0529\u0001\u0000\u0000\u0000\u052b\u052a\u0001\u0000\u0000\u0000\u052c"+
		"\u00d3\u0001\u0000\u0000\u0000\u052d\u052e\u0003\u00dcn\u0000\u052e\u052f"+
		"\u0003\u00deo\u0000\u052f\u00d5\u0001\u0000\u0000\u0000\u0530\u0531\u0003"+
		"\u00dcn\u0000\u0531\u0532\u0003\u00deo\u0000\u0532\u0533\u0003\u00f0x"+
		"\u0000\u0533\u00d7\u0001\u0000\u0000\u0000\u0534\u0535\u0003\u00dcn\u0000"+
		"\u0535\u0536\u0003\u00deo\u0000\u0536\u0537\u0003\u00e0p\u0000\u0537\u00d9"+
		"\u0001\u0000\u0000\u0000\u0538\u0539\u0003\u00dcn\u0000\u0539\u053a\u0003"+
		"\u00deo\u0000\u053a\u053b\u0003\u00e2q\u0000\u053b\u00db\u0001\u0000\u0000"+
		"\u0000\u053c\u053d\u0003\u00e4r\u0000\u053d\u053e\u0005\u001f\u0000\u0000"+
		"\u053e\u053f\u0003\u00e6s\u0000\u053f\u0540\u0005\u001f\u0000\u0000\u0540"+
		"\u0541\u0003\u00e8t\u0000\u0541\u00dd\u0001\u0000\u0000\u0000\u0542\u0543"+
		"\u0003\u00eau\u0000\u0543\u0544\u0005%\u0000\u0000\u0544\u0547\u0003\u00ec"+
		"v\u0000\u0545\u0546\u0005%\u0000\u0000\u0546\u0548\u0003\u00eew\u0000"+
		"\u0547\u0545\u0001\u0000\u0000\u0000\u0547\u0548\u0001\u0000\u0000\u0000"+
		"\u0548\u00df\u0001\u0000\u0000\u0000\u0549\u054a\u0007\f\u0000\u0000\u054a"+
		"\u054d\u0003\u00eau\u0000\u054b\u054c\u0005%\u0000\u0000\u054c\u054e\u0003"+
		"\u00ecv\u0000\u054d\u054b\u0001\u0000\u0000\u0000\u054d\u054e\u0001\u0000"+
		"\u0000\u0000\u054e\u00e1\u0001\u0000\u0000\u0000\u054f\u0550\u0007\f\u0000"+
		"\u0000\u0550\u0551\u0003\u00eau\u0000\u0551\u0552\u0005%\u0000\u0000\u0552"+
		"\u0553\u0003\u00ecv\u0000\u0553\u00e3\u0001\u0000\u0000\u0000\u0554\u0555"+
		"\u0005\u0003\u0000\u0000\u0555\u00e5\u0001\u0000\u0000\u0000\u0556\u0557"+
		"\u0005\u0003\u0000\u0000\u0557\u00e7\u0001\u0000\u0000\u0000\u0558\u0559"+
		"\u0005\u0003\u0000\u0000\u0559\u00e9\u0001\u0000\u0000\u0000\u055a\u055b"+
		"\u0005\u0003\u0000\u0000\u055b\u00eb\u0001\u0000\u0000\u0000\u055c\u055d"+
		"\u0005\u0003\u0000\u0000\u055d\u00ed\u0001\u0000\u0000\u0000\u055e\u055f"+
		"\u0007\u000f\u0000\u0000\u055f\u00ef\u0001\u0000\u0000\u0000\u0560\u0563"+
		"\u0005\u00d4\u0000\u0000\u0561\u0562\u0005!\u0000\u0000\u0562\u0564\u0005"+
		"\u00d4\u0000\u0000\u0563\u0561\u0001\u0000\u0000\u0000\u0563\u0564\u0001"+
		"\u0000\u0000\u0000\u0564\u0567\u0001\u0000\u0000\u0000\u0565\u0567\u0005"+
		"\n\u0000\u0000\u0566\u0560\u0001\u0000\u0000\u0000\u0566\u0565\u0001\u0000"+
		"\u0000\u0000\u0567\u00f1\u0001\u0000\u0000\u0000\u0568\u056b\u0005\r\u0000"+
		"\u0000\u0569\u056c\u0003\u00d2i\u0000\u056a\u056c\u0003\u00f8|\u0000\u056b"+
		"\u0569\u0001\u0000\u0000\u0000\u056b\u056a\u0001\u0000\u0000\u0000\u056c"+
		"\u056d\u0001\u0000\u0000\u0000\u056d\u056e\u0005\u001d\u0000\u0000\u056e"+
		"\u00f3\u0001\u0000\u0000\u0000\u056f\u0572\u0005\u000e\u0000\u0000\u0570"+
		"\u0573\u0003\u00dcn\u0000\u0571\u0573\u0003\u00f8|\u0000\u0572\u0570\u0001"+
		"\u0000\u0000\u0000\u0572\u0571\u0001\u0000\u0000\u0000\u0573\u0574\u0001"+
		"\u0000\u0000\u0000\u0574\u0575\u0005\u001d\u0000\u0000\u0575\u00f5\u0001"+
		"\u0000\u0000\u0000\u0576\u0579\u0005\u000f\u0000\u0000\u0577\u057a\u0003"+
		"\u00deo\u0000\u0578\u057a\u0003\u00f8|\u0000\u0579\u0577\u0001\u0000\u0000"+
		"\u0000\u0579\u0578\u0001\u0000\u0000\u0000\u057a\u057b\u0001\u0000\u0000"+
		"\u0000\u057b\u057c\u0005\u001d\u0000\u0000\u057c\u00f7\u0001\u0000\u0000"+
		"\u0000\u057d\u057e\u0005\n\u0000\u0000\u057e\u00f9\u0001\u0000\u0000\u0000"+
		"\u057f\u0580\u0005\u001c\u0000\u0000\u0580\u0581\u0003\u00fc~\u0000\u0581"+
		"\u0582\u0005%\u0000\u0000\u0582\u0583\u0003\u00fe\u007f\u0000\u0583\u0584"+
		"\u0005\u001d\u0000\u0000\u0584\u00fb\u0001\u0000\u0000\u0000\u0585\u0586"+
		"\u0005\n\u0000\u0000\u0586\u00fd\u0001\u0000\u0000\u0000\u0587\u0588\u0005"+
		"\n\u0000\u0000\u0588\u00ff\u0001\u0000\u0000\u0000\u0589\u058a\u0005%"+
		"\u0000\u0000\u058a\u0590\u0003\u018a\u00c5\u0000\u058b\u058d\u0005(\u0000"+
		"\u0000\u058c\u058e\u0005\u0003\u0000\u0000\u058d\u058c\u0001\u0000\u0000"+
		"\u0000\u058d\u058e\u0001\u0000\u0000\u0000\u058e\u0590\u0001\u0000\u0000"+
		"\u0000\u058f\u0589\u0001\u0000\u0000\u0000\u058f\u058b\u0001\u0000\u0000"+
		"\u0000\u0590\u0101\u0001\u0000\u0000\u0000\u0591\u059a\u0003\u0134\u009a"+
		"\u0000\u0592\u059a\u0003\u0116\u008b\u0000\u0593\u059a\u0003\u010e\u0087"+
		"\u0000\u0594\u059a\u0003\u0110\u0088\u0000\u0595\u059a\u0003\u0112\u0089"+
		"\u0000\u0596\u059a\u0003\u0114\u008a\u0000\u0597\u059a\u0003\u0104\u0082"+
		"\u0000\u0598\u059a\u0003\u0108\u0084\u0000\u0599\u0591\u0001\u0000\u0000"+
		"\u0000\u0599\u0592\u0001\u0000\u0000\u0000\u0599\u0593\u0001\u0000\u0000"+
		"\u0000\u0599\u0594\u0001\u0000\u0000\u0000\u0599\u0595\u0001\u0000\u0000"+
		"\u0000\u0599\u0596\u0001\u0000\u0000\u0000\u0599\u0597\u0001\u0000\u0000"+
		"\u0000\u0599\u0598\u0001\u0000\u0000\u0000\u059a\u0103\u0001\u0000\u0000"+
		"\u0000\u059b\u059c\u0005c\u0000\u0000\u059c\u059d\u0005\u0018\u0000\u0000"+
		"\u059d\u05a0\u0003\u0106\u0083\u0000\u059e\u059f\u0005\u0016\u0000\u0000"+
		"\u059f\u05a1\u0003\u010c\u0086\u0000\u05a0\u059e\u0001\u0000\u0000\u0000"+
		"\u05a0\u05a1\u0001\u0000\u0000\u0000\u05a1\u05a2\u0001\u0000\u0000\u0000"+
		"\u05a2\u05a3\u0005\u0019\u0000\u0000\u05a3\u0105\u0001\u0000\u0000\u0000"+
		"\u05a4\u05a5\u0005\n\u0000\u0000\u05a5\u0107\u0001\u0000\u0000\u0000\u05a6"+
		"\u05a7\u0003\u010a\u0085\u0000\u05a7\u05aa\u0005\u0018\u0000\u0000\u05a8"+
		"\u05ab\u0003\u010c\u0086\u0000\u05a9\u05ab\u0005 \u0000\u0000\u05aa\u05a8"+
		"\u0001\u0000\u0000\u0000\u05aa\u05a9\u0001\u0000\u0000\u0000\u05aa\u05ab"+
		"\u0001\u0000\u0000\u0000\u05ab\u05ac\u0001\u0000\u0000\u0000\u05ac\u05ae"+
		"\u0005\u0019\u0000\u0000\u05ad\u05af\u0003\u0126\u0093\u0000\u05ae\u05ad"+
		"\u0001\u0000\u0000\u0000\u05ae\u05af\u0001\u0000\u0000\u0000\u05af\u05b1"+
		"\u0001\u0000\u0000\u0000\u05b0\u05b2\u0003\u0124\u0092\u0000\u05b1\u05b0"+
		"\u0001\u0000\u0000\u0000\u05b1\u05b2\u0001\u0000\u0000\u0000\u05b2\u05b4"+
		"\u0001\u0000\u0000\u0000\u05b3\u05b5\u0003\u0120\u0090\u0000\u05b4\u05b3"+
		"\u0001\u0000\u0000\u0000\u05b4\u05b5\u0001\u0000\u0000\u0000\u05b5\u05b7"+
		"\u0001\u0000\u0000\u0000\u05b6\u05b8\u0003\u0122\u0091\u0000\u05b7\u05b6"+
		"\u0001\u0000\u0000\u0000\u05b7\u05b8\u0001\u0000\u0000\u0000\u05b8\u05ba"+
		"\u0001\u0000\u0000\u0000\u05b9\u05bb\u0003\u0128\u0094\u0000\u05ba\u05b9"+
		"\u0001\u0000\u0000\u0000\u05ba\u05bb\u0001\u0000\u0000\u0000\u05bb\u0109"+
		"\u0001\u0000\u0000\u0000\u05bc\u05bd\u0003\\.\u0000\u05bd\u010b\u0001"+
		"\u0000\u0000\u0000\u05be\u05c3\u0005L\u0000\u0000\u05bf\u05c0\u0003\u0174"+
		"\u00ba\u0000\u05c0\u05c1\u0005\u0016\u0000\u0000\u05c1\u05c3\u0001\u0000"+
		"\u0000\u0000\u05c2\u05be\u0001\u0000\u0000\u0000\u05c2\u05bf\u0001\u0000"+
		"\u0000\u0000\u05c2\u05c3\u0001\u0000\u0000\u0000\u05c3\u05c4\u0001\u0000"+
		"\u0000\u0000\u05c4\u05c9\u0003\u009eO\u0000\u05c5\u05c6\u0005\u0016\u0000"+
		"\u0000\u05c6\u05c8\u0003\u009eO\u0000\u05c7\u05c5\u0001\u0000\u0000\u0000"+
		"\u05c8\u05cb\u0001\u0000\u0000\u0000\u05c9\u05c7\u0001\u0000\u0000\u0000"+
		"\u05c9\u05ca\u0001\u0000\u0000\u0000\u05ca\u010d\u0001\u0000\u0000\u0000"+
		"\u05cb\u05c9\u0001\u0000\u0000\u0000\u05cc\u05cd\u0005\u00b2\u0000\u0000"+
		"\u05cd\u05ce\u0005\u0018\u0000\u0000\u05ce\u05cf\u0003`0\u0000\u05cf\u05d0"+
		"\u0005\u0019\u0000\u0000\u05d0\u010f\u0001\u0000\u0000\u0000\u05d1\u05d2"+
		"\u0005\u0085\u0000\u0000\u05d2\u05d3\u0005\u0018\u0000\u0000\u05d3\u05d4"+
		"\u0003`0\u0000\u05d4\u05d5\u0005\u0019\u0000\u0000\u05d5\u05fc\u0001\u0000"+
		"\u0000\u0000\u05d6\u05d7\u0005\u008b\u0000\u0000\u05d7\u05d8\u0005\u0018"+
		"\u0000\u0000\u05d8\u05d9\u0003`0\u0000\u05d9\u05da\u0005\u0019\u0000\u0000"+
		"\u05da\u05fc\u0001\u0000\u0000\u0000\u05db\u05dc\u0005\u0083\u0000\u0000"+
		"\u05dc\u05dd\u0005\u0018\u0000\u0000\u05dd\u05de\u0005l\u0000\u0000\u05de"+
		"\u05df\u0005\u0018\u0000\u0000\u05df\u05e0\u0003`0\u0000\u05e0\u05e1\u0005"+
		"\u0019\u0000\u0000\u05e1\u05e2\u0005\u0019\u0000\u0000\u05e2\u05fc\u0001"+
		"\u0000\u0000\u0000\u05e3\u05e4\u0005\u0089\u0000\u0000\u05e4\u05e5\u0005"+
		"\u0018\u0000\u0000\u05e5\u05e6\u0005l\u0000\u0000\u05e6\u05e7\u0005\u0018"+
		"\u0000\u0000\u05e7\u05e8\u0003`0\u0000\u05e8\u05e9\u0005\u0019\u0000\u0000"+
		"\u05e9\u05ea\u0005\u0019\u0000\u0000\u05ea\u05fc\u0001\u0000\u0000\u0000"+
		"\u05eb\u05ec\u0005\u00b5\u0000\u0000\u05ec\u05ed\u0005\u0018\u0000\u0000"+
		"\u05ed\u05ee\u0005l\u0000\u0000\u05ee\u05ef\u0005\u0018\u0000\u0000\u05ef"+
		"\u05f0\u0003`0\u0000\u05f0\u05f1\u0005\u0019\u0000\u0000\u05f1\u05f2\u0005"+
		"\u0019\u0000\u0000\u05f2\u05fc\u0001\u0000\u0000\u0000\u05f3\u05f4\u0005"+
		"4\u0000\u0000\u05f4\u05f5\u0005\u0018\u0000\u0000\u05f5\u05f6\u0005l\u0000"+
		"\u0000\u05f6\u05f7\u0005\u0018\u0000\u0000\u05f7\u05f8\u0003`0\u0000\u05f8"+
		"\u05f9\u0005\u0019\u0000\u0000\u05f9\u05fa\u0005\u0019\u0000\u0000\u05fa"+
		"\u05fc\u0001\u0000\u0000\u0000\u05fb\u05d1\u0001\u0000\u0000\u0000\u05fb"+
		"\u05d6\u0001\u0000\u0000\u0000\u05fb\u05db\u0001\u0000\u0000\u0000\u05fb"+
		"\u05e3\u0001\u0000\u0000\u0000\u05fb\u05eb\u0001\u0000\u0000\u0000\u05fb"+
		"\u05f3\u0001\u0000\u0000\u0000\u05fc\u0111\u0001\u0000\u0000\u0000\u05fd"+
		"\u05fe\u0005\u0084\u0000\u0000\u05fe\u05ff\u0005\u0018\u0000\u0000\u05ff"+
		"\u0600\u0003`0\u0000\u0600\u0601\u0005\u0019\u0000\u0000\u0601\u0628\u0001"+
		"\u0000\u0000\u0000\u0602\u0603\u0005\u008a\u0000\u0000\u0603\u0604\u0005"+
		"\u0018\u0000\u0000\u0604\u0605\u0003`0\u0000\u0605\u0606\u0005\u0019\u0000"+
		"\u0000\u0606\u0628\u0001\u0000\u0000\u0000\u0607\u0608\u0005\u0083\u0000"+
		"\u0000\u0608\u0609\u0005\u0018\u0000\u0000\u0609\u060a\u0005N\u0000\u0000"+
		"\u060a\u060b\u0005\u0018\u0000\u0000\u060b\u060c\u0003`0\u0000\u060c\u060d"+
		"\u0005\u0019\u0000\u0000\u060d\u060e\u0005\u0019\u0000\u0000\u060e\u0628"+
		"\u0001\u0000\u0000\u0000\u060f\u0610\u0005\u0089\u0000\u0000\u0610\u0611"+
		"\u0005\u0018\u0000\u0000\u0611\u0612\u0005N\u0000\u0000\u0612\u0613\u0005"+
		"\u0018\u0000\u0000\u0613\u0614\u0003`0\u0000\u0614\u0615\u0005\u0019\u0000"+
		"\u0000\u0615\u0616\u0005\u0019\u0000\u0000\u0616\u0628\u0001\u0000\u0000"+
		"\u0000\u0617\u0618\u0005\u00b5\u0000\u0000\u0618\u0619\u0005\u0018\u0000"+
		"\u0000\u0619\u061a\u0005N\u0000\u0000\u061a\u061b\u0005\u0018\u0000\u0000"+
		"\u061b\u061c\u0003`0\u0000\u061c\u061d\u0005\u0019\u0000\u0000\u061d\u061e"+
		"\u0005\u0019\u0000\u0000\u061e\u0628\u0001\u0000\u0000\u0000\u061f\u0620"+
		"\u00054\u0000\u0000\u0620\u0621\u0005\u0018\u0000\u0000\u0621\u0622\u0005"+
		"N\u0000\u0000\u0622\u0623\u0005\u0018\u0000\u0000\u0623\u0624\u0003`0"+
		"\u0000\u0624\u0625\u0005\u0019\u0000\u0000\u0625\u0626\u0005\u0019\u0000"+
		"\u0000\u0626\u0628\u0001\u0000\u0000\u0000\u0627\u05fd\u0001\u0000\u0000"+
		"\u0000\u0627\u0602\u0001\u0000\u0000\u0000\u0627\u0607\u0001\u0000\u0000"+
		"\u0000\u0627\u060f\u0001\u0000\u0000\u0000\u0627\u0617\u0001\u0000\u0000"+
		"\u0000\u0627\u061f\u0001\u0000\u0000\u0000\u0628\u0113\u0001\u0000\u0000"+
		"\u0000\u0629\u062a\u0005N\u0000\u0000\u062a\u062b\u0005\u0018\u0000\u0000"+
		"\u062b\u062c\u0003`0\u0000\u062c\u062d\u0005\u0019\u0000\u0000\u062d\u0634"+
		"\u0001\u0000\u0000\u0000\u062e\u062f\u0005l\u0000\u0000\u062f\u0630\u0005"+
		"\u0018\u0000\u0000\u0630\u0631\u0003`0\u0000\u0631\u0632\u0005\u0019\u0000"+
		"\u0000\u0632\u0634\u0001\u0000\u0000\u0000\u0633\u0629\u0001\u0000\u0000"+
		"\u0000\u0633\u062e\u0001\u0000\u0000\u0000\u0634\u0115\u0001\u0000\u0000"+
		"\u0000\u0635\u0639\u0003\u0118\u008c\u0000\u0636\u0639\u0003\u011a\u008d"+
		"\u0000\u0637\u0639\u0003\u011c\u008e\u0000\u0638\u0635\u0001\u0000\u0000"+
		"\u0000\u0638\u0636\u0001\u0000\u0000\u0000\u0638\u0637\u0001\u0000\u0000"+
		"\u0000\u0639\u0117\u0001\u0000\u0000\u0000\u063a\u063b\u0007\u0010\u0000"+
		"\u0000\u063b\u063c\u0005\u0018\u0000\u0000\u063c\u063d\u0003\u0092I\u0000"+
		"\u063d\u063f\u0005\u0019\u0000\u0000\u063e\u0640\u0003\u0122\u0091\u0000"+
		"\u063f\u063e\u0001\u0000\u0000\u0000\u063f\u0640\u0001\u0000\u0000\u0000"+
		"\u0640\u0642\u0001\u0000\u0000\u0000\u0641\u0643\u0003\u0128\u0094\u0000"+
		"\u0642\u0641\u0001\u0000\u0000\u0000\u0642\u0643\u0001\u0000\u0000\u0000"+
		"\u0643\u0650\u0001\u0000\u0000\u0000\u0644\u0645\u0007\u0010\u0000\u0000"+
		"\u0645\u0646\u0005\u0018\u0000\u0000\u0646\u0647\u0003\u0004\u0002\u0000"+
		"\u0647\u0648\u0005\u0019\u0000\u0000\u0648\u0650\u0001\u0000\u0000\u0000"+
		"\u0649\u064a\u0007\u0010\u0000\u0000\u064a\u064b\u0007\n\u0000\u0000\u064b"+
		"\u064c\u0005\u0018\u0000\u0000\u064c\u064d\u0003\\.\u0000\u064d\u064e"+
		"\u0005\u0019\u0000\u0000\u064e\u0650\u0001\u0000\u0000\u0000\u064f\u063a"+
		"\u0001\u0000\u0000\u0000\u064f\u0644\u0001\u0000\u0000\u0000\u064f\u0649"+
		"\u0001\u0000\u0000\u0000\u0650\u0119\u0001\u0000\u0000\u0000\u0651\u0652"+
		"\u0007\u0011\u0000\u0000\u0652\u0653\u0005\u0018\u0000\u0000\u0653\u0654"+
		"\u0003\u0092I\u0000\u0654\u0656\u0005\u0019\u0000\u0000\u0655\u0657\u0003"+
		"\u0122\u0091\u0000\u0656\u0655\u0001\u0000\u0000\u0000\u0656\u0657\u0001"+
		"\u0000\u0000\u0000\u0657\u0659\u0001\u0000\u0000\u0000\u0658\u065a\u0003"+
		"\u0128\u0094\u0000\u0659\u0658\u0001\u0000\u0000\u0000\u0659\u065a\u0001"+
		"\u0000\u0000\u0000\u065a\u0667\u0001\u0000\u0000\u0000\u065b\u065c\u0007"+
		"\u0011\u0000\u0000\u065c\u065d\u0005\u0018\u0000\u0000\u065d\u065e\u0003"+
		"\u0004\u0002\u0000\u065e\u065f\u0005\u0019\u0000\u0000\u065f\u0667\u0001"+
		"\u0000\u0000\u0000\u0660\u0661\u0007\u0011\u0000\u0000\u0661\u0662\u0007"+
		"\n\u0000\u0000\u0662\u0663\u0005\u0018\u0000\u0000\u0663\u0664\u0003\\"+
		".\u0000\u0664\u0665\u0005\u0019\u0000\u0000\u0665\u0667\u0001\u0000\u0000"+
		"\u0000\u0666\u0651\u0001\u0000\u0000\u0000\u0666\u065b\u0001\u0000\u0000"+
		"\u0000\u0666\u0660\u0001\u0000\u0000\u0000\u0667\u011b\u0001\u0000\u0000"+
		"\u0000\u0668\u0669\u0005|\u0000\u0000\u0669\u066b\u0005\u0018\u0000\u0000"+
		"\u066a\u066c\u0005L\u0000\u0000\u066b\u066a\u0001\u0000\u0000\u0000\u066b"+
		"\u066c\u0001\u0000\u0000\u0000\u066c\u066d\u0001\u0000\u0000\u0000\u066d"+
		"\u066e\u0003\u009eO\u0000\u066e\u066f\u0005\u0016\u0000\u0000\u066f\u0671"+
		"\u0003\u009eO\u0000\u0670\u0672\u0003\u011e\u008f\u0000\u0671\u0670\u0001"+
		"\u0000\u0000\u0000\u0671\u0672\u0001\u0000\u0000\u0000\u0672\u0673\u0001"+
		"\u0000\u0000\u0000\u0673\u0675\u0005\u0019\u0000\u0000\u0674\u0676\u0003"+
		"\u0120\u0090\u0000\u0675\u0674\u0001\u0000\u0000\u0000\u0675\u0676\u0001"+
		"\u0000\u0000\u0000\u0676\u0678\u0001\u0000\u0000\u0000\u0677\u0679\u0003"+
		"\u0122\u0091\u0000\u0678\u0677\u0001\u0000\u0000\u0000\u0678\u0679\u0001"+
		"\u0000\u0000\u0000\u0679\u067b\u0001\u0000\u0000\u0000\u067a\u067c\u0003"+
		"\u0128\u0094\u0000\u067b\u067a\u0001\u0000\u0000\u0000\u067b\u067c\u0001"+
		"\u0000\u0000\u0000\u067c\u011d\u0001\u0000\u0000\u0000\u067d\u067e\u0005"+
		"\u0098\u0000\u0000\u067e\u0686\u0005\u009f\u0000\u0000\u067f\u0687\u0005"+
		"T\u0000\u0000\u0680\u0682\u0005\u00c1\u0000\u0000\u0681\u0683\u0003\u009a"+
		"M\u0000\u0682\u0681\u0001\u0000\u0000\u0000\u0682\u0683\u0001\u0000\u0000"+
		"\u0000\u0683\u0684\u0001\u0000\u0000\u0000\u0684\u0685\u0007\u0012\u0000"+
		"\u0000\u0685\u0687\u0005<\u0000\u0000\u0686\u067f\u0001\u0000\u0000\u0000"+
		"\u0686\u0680\u0001\u0000\u0000\u0000\u0687\u011f\u0001\u0000\u0000\u0000"+
		"\u0688\u0689\u0005\u00cd\u0000\u0000\u0689\u068a\u0005d\u0000\u0000\u068a"+
		"\u068b\u0005\u0018\u0000\u0000\u068b\u068c\u0003v;\u0000\u068c\u068d\u0005"+
		"\u0019\u0000\u0000\u068d\u0121\u0001\u0000\u0000\u0000\u068e\u068f\u0005"+
		"\\\u0000\u0000\u068f\u0690\u0005\u0018\u0000\u0000\u0690\u0691\u0003\u0090"+
		"H\u0000\u0691\u0692\u0005\u0019\u0000\u0000\u0692\u0123\u0001\u0000\u0000"+
		"\u0000\u0693\u0694\u0005\u00a9\u0000\u0000\u0694\u0698\u0005\u0093\u0000"+
		"\u0000\u0695\u0696\u0005h\u0000\u0000\u0696\u0698\u0005\u0093\u0000\u0000"+
		"\u0697\u0693\u0001\u0000\u0000\u0000\u0697\u0695\u0001\u0000\u0000\u0000"+
		"\u0698\u0125\u0001\u0000\u0000\u0000\u0699\u069a\u0005a\u0000\u0000\u069a"+
		"\u069e\u0005]\u0000\u0000\u069b\u069c\u0005a\u0000\u0000\u069c\u069e\u0005"+
		"u\u0000\u0000\u069d\u0699\u0001\u0000\u0000\u0000\u069d\u069b\u0001\u0000"+
		"\u0000\u0000\u069e\u0127\u0001\u0000\u0000\u0000\u069f\u06a0\u0005\u009e"+
		"\u0000\u0000\u06a0\u06a2\u0005\u0018\u0000\u0000\u06a1\u06a3\u0003\u012a"+
		"\u0095\u0000\u06a2\u06a1\u0001\u0000\u0000\u0000\u06a2\u06a3\u0001\u0000"+
		"\u0000\u0000\u06a3\u06a5\u0001\u0000\u0000\u0000\u06a4\u06a6\u0003v;\u0000"+
		"\u06a5\u06a4\u0001\u0000\u0000\u0000\u06a5\u06a6\u0001\u0000\u0000\u0000"+
		"\u06a6\u06a8\u0001\u0000\u0000\u0000\u06a7\u06a9\u0003\u012c\u0096\u0000"+
		"\u06a8\u06a7\u0001\u0000\u0000\u0000\u06a8\u06a9\u0001\u0000\u0000\u0000"+
		"\u06a9\u06aa\u0001\u0000\u0000\u0000\u06aa\u06ab\u0005\u0019\u0000\u0000"+
		"\u06ab\u0129\u0001\u0000\u0000\u0000\u06ac\u06ad\u0005\u00a2\u0000\u0000"+
		"\u06ad\u06ae\u00058\u0000\u0000\u06ae\u06b3\u0003\u009aM\u0000\u06af\u06b0"+
		"\u0005\u0016\u0000\u0000\u06b0\u06b2\u0003\u009aM\u0000\u06b1\u06af\u0001"+
		"\u0000\u0000\u0000\u06b2\u06b5\u0001\u0000\u0000\u0000\u06b3\u06b1\u0001"+
		"\u0000\u0000\u0000\u06b3\u06b4\u0001\u0000\u0000\u0000\u06b4\u012b\u0001"+
		"\u0000\u0000\u0000\u06b5\u06b3\u0001\u0000\u0000\u0000\u06b6\u06b7\u0007"+
		"\u0013\u0000\u0000\u06b7\u06b9\u0003\u012e\u0097\u0000\u06b8\u06ba\u0003"+
		"\u0132\u0099\u0000\u06b9\u06b8\u0001\u0000\u0000\u0000\u06b9\u06ba\u0001"+
		"\u0000\u0000\u0000\u06ba\u06c4\u0001\u0000\u0000\u0000\u06bb\u06bc\u0007"+
		"\u0013\u0000\u0000\u06bc\u06bd\u00055\u0000\u0000\u06bd\u06be\u0003\u012e"+
		"\u0097\u0000\u06be\u06bf\u00050\u0000\u0000\u06bf\u06c1\u0003\u0130\u0098"+
		"\u0000\u06c0\u06c2\u0003\u0132\u0099\u0000\u06c1\u06c0\u0001\u0000\u0000"+
		"\u0000\u06c1\u06c2\u0001\u0000\u0000\u0000\u06c2\u06c4\u0001\u0000\u0000"+
		"\u0000\u06c3\u06b6\u0001\u0000\u0000\u0000\u06c3\u06bb\u0001\u0000\u0000"+
		"\u0000\u06c4\u012d\u0001\u0000\u0000\u0000\u06c5\u06c6\u0005?\u0000\u0000"+
		"\u06c6\u06d0\u0005\u00ac\u0000\u0000\u06c7\u06c8\u0005\u00c3\u0000\u0000"+
		"\u06c8\u06d0\u0005\u00a6\u0000\u0000\u06c9\u06ca\u0003\u009aM\u0000\u06ca"+
		"\u06cb\u0005\u00a6\u0000\u0000\u06cb\u06d0\u0001\u0000\u0000\u0000\u06cc"+
		"\u06cd\u0003\u009aM\u0000\u06cd\u06ce\u0005^\u0000\u0000\u06ce\u06d0\u0001"+
		"\u0000\u0000\u0000\u06cf\u06c5\u0001\u0000\u0000\u0000\u06cf\u06c7\u0001"+
		"\u0000\u0000\u0000\u06cf\u06c9\u0001\u0000\u0000\u0000\u06cf\u06cc\u0001"+
		"\u0000\u0000\u0000\u06d0\u012f\u0001\u0000\u0000\u0000\u06d1\u06d2\u0005"+
		"?\u0000\u0000\u06d2\u06dc\u0005\u00ac\u0000\u0000\u06d3\u06d4\u0005\u00c3"+
		"\u0000\u0000\u06d4\u06dc\u0005^\u0000\u0000\u06d5\u06d6\u0003\u009aM\u0000"+
		"\u06d6\u06d7\u0005\u00a6\u0000\u0000\u06d7\u06dc\u0001\u0000\u0000\u0000"+
		"\u06d8\u06d9\u0003\u009aM\u0000\u06d9\u06da\u0005^\u0000\u0000\u06da\u06dc"+
		"\u0001\u0000\u0000\u0000\u06db\u06d1\u0001\u0000\u0000\u0000\u06db\u06d3"+
		"\u0001\u0000\u0000\u0000\u06db\u06d5\u0001\u0000\u0000\u0000\u06db\u06d8"+
		"\u0001\u0000\u0000\u0000\u06dc\u0131\u0001\u0000\u0000\u0000\u06dd\u06de"+
		"\u0005X\u0000\u0000\u06de\u06df\u0005?\u0000\u0000\u06df\u06e8\u0005\u00ac"+
		"\u0000\u0000\u06e0\u06e1\u0005X\u0000\u0000\u06e1\u06e8\u0005d\u0000\u0000"+
		"\u06e2\u06e3\u0005X\u0000\u0000\u06e3\u06e8\u0005\u00b7\u0000\u0000\u06e4"+
		"\u06e5\u0005X\u0000\u0000\u06e5\u06e6\u0005\u0091\u0000\u0000\u06e6\u06e8"+
		"\u0005\u009c\u0000\u0000\u06e7\u06dd\u0001\u0000\u0000\u0000\u06e7\u06e0"+
		"\u0001\u0000\u0000\u0000\u06e7\u06e2\u0001\u0000\u0000\u0000\u06e7\u06e4"+
		"\u0001\u0000\u0000\u0000\u06e8\u0133\u0001\u0000\u0000\u0000\u06e9\u06fe"+
		"\u0003\u0136\u009b\u0000\u06ea\u06fe\u0003\u016e\u00b7\u0000\u06eb\u06fe"+
		"\u0003\u0170\u00b8\u0000\u06ec\u06fe\u0003\u016a\u00b5\u0000\u06ed\u06fe"+
		"\u0003\u0082A\u0000\u06ee\u06fe\u0003\u013c\u009e\u0000\u06ef\u06fe\u0003"+
		"\u0150\u00a8\u0000\u06f0\u06fe\u0003\u0142\u00a1\u0000\u06f1\u06fe\u0003"+
		"\u0148\u00a4\u0000\u06f2\u06fe\u0003\u017e\u00bf\u0000\u06f3\u06fe\u0003"+
		"\u015a\u00ad\u0000\u06f4\u06fe\u0003\u015c\u00ae\u0000\u06f5\u06fe\u0003"+
		"\u015e\u00af\u0000\u06f6\u06fe\u0003\u0160\u00b0\u0000\u06f7\u06fe\u0003"+
		"\u0166\u00b3\u0000\u06f8\u06fe\u0003\u0168\u00b4\u0000\u06f9\u06fe\u0003"+
		"\u0162\u00b1\u0000\u06fa\u06fe\u0003\u0164\u00b2\u0000\u06fb\u06fe\u0003"+
		"\u0184\u00c2\u0000\u06fc\u06fe\u0003\u0186\u00c3\u0000\u06fd\u06e9\u0001"+
		"\u0000\u0000\u0000\u06fd\u06ea\u0001\u0000\u0000\u0000\u06fd\u06eb\u0001"+
		"\u0000\u0000\u0000\u06fd\u06ec\u0001\u0000\u0000\u0000\u06fd\u06ed\u0001"+
		"\u0000\u0000\u0000\u06fd\u06ee\u0001\u0000\u0000\u0000\u06fd\u06ef\u0001"+
		"\u0000\u0000\u0000\u06fd\u06f0\u0001\u0000\u0000\u0000\u06fd\u06f1\u0001"+
		"\u0000\u0000\u0000\u06fd\u06f2\u0001\u0000\u0000\u0000\u06fd\u06f3\u0001"+
		"\u0000\u0000\u0000\u06fd\u06f4\u0001\u0000\u0000\u0000\u06fd\u06f5\u0001"+
		"\u0000\u0000\u0000\u06fd\u06f6\u0001\u0000\u0000\u0000\u06fd\u06f7\u0001"+
		"\u0000\u0000\u0000\u06fd\u06f8\u0001\u0000\u0000\u0000\u06fd\u06f9\u0001"+
		"\u0000\u0000\u0000\u06fd\u06fa\u0001\u0000\u0000\u0000\u06fd\u06fb\u0001"+
		"\u0000\u0000\u0000\u06fd\u06fc\u0001\u0000\u0000\u0000\u06fe\u0135\u0001"+
		"\u0000\u0000\u0000\u06ff\u0700\u0005:\u0000\u0000\u0700\u0701\u0005\u0018"+
		"\u0000\u0000\u0701\u0702\u0003\u009aM\u0000\u0702\u0703\u00052\u0000\u0000"+
		"\u0703\u0704\u0003\u0138\u009c\u0000\u0704\u0705\u0005\u0019\u0000\u0000"+
		"\u0705\u0137\u0001\u0000\u0000\u0000\u0706\u070e\u0003\u013a\u009d\u0000"+
		"\u0707\u0708\u0005\u0018\u0000\u0000\u0708\u070b\u0005\u0003\u0000\u0000"+
		"\u0709\u070a\u0005\u0016\u0000\u0000\u070a\u070c\u0005\u0003\u0000\u0000"+
		"\u070b\u0709\u0001\u0000\u0000\u0000\u070b\u070c\u0001\u0000\u0000\u0000"+
		"\u070c\u070d\u0001\u0000\u0000\u0000\u070d\u070f\u0005\u0019\u0000\u0000"+
		"\u070e\u0707\u0001\u0000\u0000\u0000\u070e\u070f\u0001\u0000\u0000\u0000"+
		"\u070f\u0139\u0001\u0000\u0000\u0000\u0710\u0711\u0003\u018a\u00c5\u0000"+
		"\u0711\u0712\u0006\u009d\uffff\uffff\u0000\u0712\u0719\u0001\u0000\u0000"+
		"\u0000\u0713\u0714\u0005\u0017\u0000\u0000\u0714\u0715\u0003\u018a\u00c5"+
		"\u0000\u0715\u0716\u0006\u009d\uffff\uffff\u0000\u0716\u0718\u0001\u0000"+
		"\u0000\u0000\u0717\u0713\u0001\u0000\u0000\u0000\u0718\u071b\u0001\u0000"+
		"\u0000\u0000\u0719\u0717\u0001\u0000\u0000\u0000\u0719\u071a\u0001\u0000"+
		"\u0000\u0000\u071a\u013b\u0001\u0000\u0000\u0000\u071b\u0719\u0001\u0000"+
		"\u0000\u0000\u071c\u071d\u0005\u00b4\u0000\u0000\u071d\u071e\u0005\u0018"+
		"\u0000\u0000\u071e\u071f\u0003\u009aM\u0000\u071f\u0720\u0005\u0016\u0000"+
		"\u0000\u0720\u0723\u0003\u013e\u009f\u0000\u0721\u0722\u0005\u0016\u0000"+
		"\u0000\u0722\u0724\u0003\u0140\u00a0\u0000\u0723\u0721\u0001\u0000\u0000"+
		"\u0000\u0723\u0724\u0001\u0000\u0000\u0000\u0724\u0725\u0001\u0000\u0000"+
		"\u0000\u0725\u0726\u0005\u0019\u0000\u0000\u0726\u0733\u0001\u0000\u0000"+
		"\u0000\u0727\u0728\u0005\u00b4\u0000\u0000\u0728\u0729\u0005\u0018\u0000"+
		"\u0000\u0729\u072a\u0003\u009aM\u0000\u072a\u072b\u0005a\u0000\u0000\u072b"+
		"\u072e\u0003\u013e\u009f\u0000\u072c\u072d\u0005_\u0000\u0000\u072d\u072f"+
		"\u0003\u0140\u00a0\u0000\u072e\u072c\u0001\u0000\u0000\u0000\u072e\u072f"+
		"\u0001\u0000\u0000\u0000\u072f\u0730\u0001\u0000\u0000\u0000\u0730\u0731"+
		"\u0005\u0019\u0000\u0000\u0731\u0733\u0001\u0000\u0000\u0000\u0732\u071c"+
		"\u0001\u0000\u0000\u0000\u0732\u0727\u0001\u0000\u0000\u0000\u0733\u013d"+
		"\u0001\u0000\u0000\u0000\u0734\u0735\u0003\u009aM\u0000\u0735\u013f\u0001"+
		"\u0000\u0000\u0000\u0736\u0737\u0003\u009aM\u0000\u0737\u0141\u0001\u0000"+
		"\u0000\u0000\u0738\u0739\u0005\u00bf\u0000\u0000\u0739\u073b\u0005\u0018"+
		"\u0000\u0000\u073a\u073c\u0003\u0144\u00a2\u0000\u073b\u073a\u0001\u0000"+
		"\u0000\u0000\u073b\u073c\u0001\u0000\u0000\u0000\u073c\u073e\u0001\u0000"+
		"\u0000\u0000\u073d\u073f\u0003\u0146\u00a3\u0000\u073e\u073d\u0001\u0000"+
		"\u0000\u0000\u073e\u073f\u0001\u0000\u0000\u0000\u073f\u0741\u0001\u0000"+
		"\u0000\u0000\u0740\u0742\u0005a\u0000\u0000\u0741\u0740\u0001\u0000\u0000"+
		"\u0000\u0741\u0742\u0001\u0000\u0000\u0000\u0742\u0743\u0001\u0000\u0000"+
		"\u0000\u0743\u0744\u0003\u009aM\u0000\u0744\u0745\u0005\u0019\u0000\u0000"+
		"\u0745\u0143\u0001\u0000\u0000\u0000\u0746\u0747\u0007\u0014\u0000\u0000"+
		"\u0747\u0145\u0001\u0000\u0000\u0000\u0748\u0749\u0005\n\u0000\u0000\u0749"+
		"\u0147\u0001\u0000\u0000\u0000\u074a\u074b\u0005\u00a1\u0000\u0000\u074b"+
		"\u074c\u0005\u0018\u0000\u0000\u074c\u074d\u0003\u009aM\u0000\u074d\u074e"+
		"\u0005\u00cc\u0000\u0000\u074e\u074f\u0003\u014e\u00a7\u0000\u074f\u0751"+
		"\u0003\u014a\u00a5\u0000\u0750\u0752\u0003\u014c\u00a6\u0000\u0751\u0750"+
		"\u0001\u0000\u0000\u0000\u0751\u0752\u0001\u0000\u0000\u0000\u0752\u0753"+
		"\u0001\u0000\u0000\u0000\u0753\u0754\u0005\u0019\u0000\u0000\u0754\u0149"+
		"\u0001\u0000\u0000\u0000\u0755\u0756\u0007\u0015\u0000\u0000\u0756\u014b"+
		"\u0001\u0000\u0000\u0000\u0757\u0758\u0005\n\u0000\u0000\u0758\u014d\u0001"+
		"\u0000\u0000\u0000\u0759\u075a\u0003\u009aM\u0000\u075a\u014f\u0001\u0000"+
		"\u0000\u0000\u075b\u075c\u0005\u00a0\u0000\u0000\u075c\u075d\u0005\u0018"+
		"\u0000\u0000\u075d\u075e\u0003\u0152\u00a9\u0000\u075e\u075f\u0005\u00a4"+
		"\u0000\u0000\u075f\u0760\u0003\u0154\u00aa\u0000\u0760\u0761\u0005a\u0000"+
		"\u0000\u0761\u0764\u0003\u0156\u00ab\u0000\u0762\u0763\u0005_\u0000\u0000"+
		"\u0763\u0765\u0003\u0158\u00ac\u0000\u0764\u0762\u0001\u0000\u0000\u0000"+
		"\u0764\u0765\u0001\u0000\u0000\u0000\u0765\u0766\u0001\u0000\u0000\u0000"+
		"\u0766\u0767\u0005\u0019\u0000\u0000\u0767\u0151\u0001\u0000\u0000\u0000"+
		"\u0768\u0769\u0003\u009aM\u0000\u0769\u0153\u0001\u0000\u0000\u0000\u076a"+
		"\u076b\u0003\u009aM\u0000\u076b\u0155\u0001\u0000\u0000\u0000\u076c\u076d"+
		"\u0003\u009aM\u0000\u076d\u0157\u0001\u0000\u0000\u0000\u076e\u076f\u0003"+
		"\u009aM\u0000\u076f\u0159\u0001\u0000\u0000\u0000\u0770\u0773\u0005@\u0000"+
		"\u0000\u0771\u0772\u0005\u0018\u0000\u0000\u0772\u0774\u0005\u0019\u0000"+
		"\u0000\u0773\u0771\u0001\u0000\u0000\u0000\u0773\u0774\u0001\u0000\u0000"+
		"\u0000\u0774\u0778\u0001\u0000\u0000\u0000\u0775\u0776\u0005?\u0000\u0000"+
		"\u0776\u0778\u0005E\u0000\u0000\u0777\u0770\u0001\u0000\u0000\u0000\u0777"+
		"\u0775\u0001\u0000\u0000\u0000\u0778\u015b\u0001\u0000\u0000\u0000\u0779"+
		"\u077c\u0005B\u0000\u0000\u077a\u077b\u0005\u0018\u0000\u0000\u077b\u077d"+
		"\u0005\u0019\u0000\u0000\u077c\u077a\u0001\u0000\u0000\u0000\u077c\u077d"+
		"\u0001\u0000\u0000\u0000\u077d\u0781\u0001\u0000\u0000\u0000\u077e\u077f"+
		"\u0005?\u0000\u0000\u077f\u0781\u0005\u00b8\u0000\u0000\u0780\u0779\u0001"+
		"\u0000\u0000\u0000\u0780\u077e\u0001\u0000\u0000\u0000\u0781\u015d\u0001"+
		"\u0000\u0000\u0000\u0782\u0785\u0005C\u0000\u0000\u0783\u0784\u0005\u0018"+
		"\u0000\u0000\u0784\u0786\u0005\u0019\u0000\u0000\u0785\u0783\u0001\u0000"+
		"\u0000\u0000\u0785\u0786\u0001\u0000\u0000\u0000\u0786\u078a\u0001\u0000"+
		"\u0000\u0000\u0787\u0788\u0005?\u0000\u0000\u0788\u078a\u0005\u00b9\u0000"+
		"\u0000\u0789\u0782\u0001\u0000\u0000\u0000\u0789\u0787\u0001\u0000\u0000"+
		"\u0000\u078a\u015f\u0001\u0000\u0000\u0000\u078b\u078e\u0005A\u0000\u0000"+
		"\u078c\u078d\u0005\u0018\u0000\u0000\u078d\u078f\u0005\u0019\u0000\u0000"+
		"\u078e\u078c\u0001\u0000\u0000\u0000\u078e\u078f\u0001\u0000\u0000\u0000"+
		"\u078f\u0792\u0001\u0000\u0000\u0000\u0790\u0792\u0005o\u0000\u0000\u0791"+
		"\u078b\u0001\u0000\u0000\u0000\u0791\u0790\u0001\u0000\u0000\u0000\u0792"+
		"\u0161\u0001\u0000\u0000\u0000\u0793\u0796\u0005\u007f\u0000\u0000\u0794"+
		"\u0795\u0005\u0018\u0000\u0000\u0795\u0797\u0005\u0019\u0000\u0000\u0796"+
		"\u0794\u0001\u0000\u0000\u0000\u0796\u0797\u0001\u0000\u0000\u0000\u0797"+
		"\u079b\u0001\u0000\u0000\u0000\u0798\u0799\u0005}\u0000\u0000\u0799\u079b"+
		"\u0005F\u0000\u0000\u079a\u0793\u0001\u0000\u0000\u0000\u079a\u0798\u0001"+
		"\u0000\u0000\u0000\u079b\u0163\u0001\u0000\u0000\u0000\u079c\u079f\u0005"+
		"\u0097\u0000\u0000\u079d\u079e\u0005\u0018\u0000\u0000\u079e\u07a0\u0005"+
		"\u0019\u0000\u0000\u079f\u079d\u0001\u0000\u0000\u0000\u079f\u07a0\u0001"+
		"\u0000\u0000\u0000\u07a0\u07a4\u0001\u0000\u0000\u0000\u07a1\u07a2\u0005"+
		"\u0096\u0000\u0000\u07a2\u07a4\u0005F\u0000\u0000\u07a3\u079c\u0001\u0000"+
		"\u0000\u0000\u07a3\u07a1\u0001\u0000\u0000\u0000\u07a4\u0165\u0001\u0000"+
		"\u0000\u0000\u07a5\u07a8\u0005~\u0000\u0000\u07a6\u07a7\u0005\u0018\u0000"+
		"\u0000\u07a7\u07a9\u0005\u0019\u0000\u0000\u07a8\u07a6\u0001\u0000\u0000"+
		"\u0000\u07a8\u07a9\u0001\u0000\u0000\u0000\u07a9\u07ad\u0001\u0000\u0000"+
		"\u0000\u07aa\u07ab\u0005}\u0000\u0000\u07ab\u07ad\u0005E\u0000\u0000\u07ac"+
		"\u07a5\u0001\u0000\u0000\u0000\u07ac\u07aa\u0001\u0000\u0000\u0000\u07ad"+
		"\u0167\u0001\u0000\u0000\u0000\u07ae\u07b1\u0005\u0080\u0000\u0000\u07af"+
		"\u07b0\u0005\u0018\u0000\u0000\u07b0\u07b2\u0005\u0019\u0000\u0000\u07b1"+
		"\u07af\u0001\u0000\u0000\u0000\u07b1\u07b2\u0001\u0000\u0000\u0000\u07b2"+
		"\u07b6\u0001\u0000\u0000\u0000\u07b3\u07b4\u0005}\u0000\u0000\u07b4\u07b6"+
		"\u0005\u00b8\u0000\u0000\u07b5\u07ae\u0001\u0000\u0000\u0000\u07b5\u07b3"+
		"\u0001\u0000\u0000\u0000\u07b6\u0169\u0001\u0000\u0000\u0000\u07b7\u07b8"+
		"\u0005`\u0000\u0000\u07b8\u07b9\u0005\u0018\u0000\u0000\u07b9\u07ba\u0003"+
		"\u009aM\u0000\u07ba\u07bb\u00052\u0000\u0000\u07bb\u07bc\u0003\u016c\u00b6"+
		"\u0000\u07bc\u07bd\u0005\u0019\u0000\u0000\u07bd\u016b\u0001\u0000\u0000"+
		"\u0000\u07be\u07bf\u0005\n\u0000\u0000\u07bf\u016d\u0001\u0000\u0000\u0000"+
		"\u07c0\u07c1\u0005Z\u0000\u0000\u07c1\u07c2\u0005\u0018\u0000\u0000\u07c2"+
		"\u07c3\u0003\u0172\u00b9\u0000\u07c3\u07c4\u0005a\u0000\u0000\u07c4\u07c5"+
		"\u0003\u009aM\u0000\u07c5\u07c6\u0005\u0019\u0000\u0000\u07c6\u07cd\u0001"+
		"\u0000\u0000\u0000\u07c7\u07c8\u0003\u0174\u00ba\u0000\u07c8\u07c9\u0005"+
		"\u0018\u0000\u0000\u07c9\u07ca\u0003\u009aM\u0000\u07ca\u07cb\u0005\u0019"+
		"\u0000\u0000\u07cb\u07cd\u0001\u0000\u0000\u0000\u07cc\u07c0\u0001\u0000"+
		"\u0000\u0000\u07cc\u07c7\u0001\u0000\u0000\u0000\u07cd\u016f\u0001\u0000"+
		"\u0000\u0000\u07ce\u07cf\u0007\u0016\u0000\u0000\u07cf\u07d0\u0005\u0018"+
		"\u0000\u0000\u07d0\u07d6\u0003\u009aM\u0000\u07d1\u07d4\u0005\u0016\u0000"+
		"\u0000\u07d2\u07d5\u0003\u0174\u00ba\u0000\u07d3\u07d5\u0003\u009aM\u0000"+
		"\u07d4\u07d2\u0001\u0000\u0000\u0000\u07d4\u07d3\u0001\u0000\u0000\u0000"+
		"\u07d5\u07d7\u0001\u0000\u0000\u0000\u07d6\u07d1\u0001\u0000\u0000\u0000"+
		"\u07d6\u07d7\u0001\u0000\u0000\u0000\u07d7\u07d8\u0001\u0000\u0000\u0000"+
		"\u07d8\u07d9\u0005\u0019\u0000\u0000\u07d9\u0171\u0001\u0000\u0000\u0000"+
		"\u07da\u07e0\u0003\u0174\u00ba\u0000\u07db\u07e0\u0003\u0176\u00bb\u0000"+
		"\u07dc\u07e0\u0003\u0178\u00bc\u0000\u07dd\u07e0\u0003\u017a\u00bd\u0000"+
		"\u07de\u07e0\u0003\u017c\u00be\u0000\u07df\u07da\u0001\u0000\u0000\u0000"+
		"\u07df\u07db\u0001\u0000\u0000\u0000\u07df\u07dc\u0001\u0000\u0000\u0000"+
		"\u07df\u07dd\u0001\u0000\u0000\u0000\u07df\u07de\u0001\u0000\u0000\u0000"+
		"\u07e0\u0173\u0001\u0000\u0000\u0000\u07e1\u07e2\u0007\u0017\u0000\u0000"+
		"\u07e2\u0175\u0001\u0000\u0000\u0000\u07e3\u07e4\u0005G\u0000\u0000\u07e4"+
		"\u07e5\u0005\u0095\u0000\u0000\u07e5\u07ed\u0005\u008d\u0000\u0000\u07e6"+
		"\u07e7\u0005G\u0000\u0000\u07e7\u07e8\u0005\u0095\u0000\u0000\u07e8\u07ed"+
		"\u0005\u00c9\u0000\u0000\u07e9\u07ea\u0005G\u0000\u0000\u07ea\u07eb\u0005"+
		"\u0095\u0000\u0000\u07eb\u07ed\u0005\u00cf\u0000\u0000\u07ec\u07e3\u0001"+
		"\u0000\u0000\u0000\u07ec\u07e6\u0001\u0000\u0000\u0000\u07ec\u07e9\u0001"+
		"\u0000\u0000\u0000\u07ed\u0177\u0001\u0000\u0000\u0000\u07ee\u07ef\u0005"+
		"\u00c9\u0000\u0000\u07ef\u07f0\u0005\u0095\u0000\u0000\u07f0\u07f5\u0005"+
		"\u008d\u0000\u0000\u07f1\u07f2\u0005\u00c9\u0000\u0000\u07f2\u07f3\u0005"+
		"\u0095\u0000\u0000\u07f3\u07f5\u0005\u00cf\u0000\u0000\u07f4\u07ee\u0001"+
		"\u0000\u0000\u0000\u07f4\u07f1\u0001\u0000\u0000\u0000\u07f5\u0179\u0001"+
		"\u0000\u0000\u0000\u07f6\u07f8\u0005\u0096\u0000\u0000\u07f7\u07f9\u0007"+
		"\u0018\u0000\u0000\u07f8\u07f7\u0001\u0000\u0000\u0000\u07f8\u07f9\u0001"+
		"\u0000\u0000\u0000\u07f9\u07fd\u0001\u0000\u0000\u0000\u07fa\u07fd\u0005"+
		"\u00ba\u0000\u0000\u07fb\u07fd\u0005\u00bb\u0000\u0000\u07fc\u07f6\u0001"+
		"\u0000\u0000\u0000\u07fc\u07fa\u0001\u0000\u0000\u0000\u07fc\u07fb\u0001"+
		"\u0000\u0000\u0000\u07fd\u017b\u0001\u0000\u0000\u0000\u07fe\u07ff\u0007"+
		"\u0019\u0000\u0000\u07ff\u017d\u0001\u0000\u0000\u0000\u0800\u0801\u0005"+
		"\u00a5\u0000\u0000\u0801\u0802\u0005\u0018\u0000\u0000\u0802\u0803\u0003"+
		"\u0180\u00c0\u0000\u0803\u0804\u0005j\u0000\u0000\u0804\u0805\u0003\u0182"+
		"\u00c1\u0000\u0805\u0806\u0005\u0019\u0000\u0000\u0806\u017f\u0001\u0000"+
		"\u0000\u0000\u0807\u0808\u0003\u009aM\u0000\u0808\u0181\u0001\u0000\u0000"+
		"\u0000\u0809\u080a\u0003\u009aM\u0000\u080a\u0183\u0001\u0000\u0000\u0000"+
		"\u080b\u080c\u0005>\u0000\u0000\u080c\u080d\u0005\u0018\u0000\u0000\u080d"+
		"\u0812\u0003\u009eO\u0000\u080e\u080f\u0005\u0016\u0000\u0000\u080f\u0811"+
		"\u0003\u009eO\u0000\u0810\u080e\u0001\u0000\u0000\u0000\u0811\u0814\u0001"+
		"\u0000\u0000\u0000\u0812\u0810\u0001\u0000\u0000\u0000\u0812\u0813\u0001"+
		"\u0000\u0000\u0000\u0813\u0815\u0001\u0000\u0000\u0000\u0814\u0812\u0001"+
		"\u0000\u0000\u0000\u0815\u0816\u0005\u0019\u0000\u0000\u0816\u0185\u0001"+
		"\u0000\u0000\u0000\u0817\u0818\u0005\u00ab\u0000\u0000\u0818\u0819\u0005"+
		"\u0018\u0000\u0000\u0819\u081e\u0003\u009eO\u0000\u081a\u081b\u0005\u0016"+
		"\u0000\u0000\u081b\u081d\u0003\u009eO\u0000\u081c\u081a\u0001\u0000\u0000"+
		"\u0000\u081d\u0820\u0001\u0000\u0000\u0000\u081e\u081c\u0001\u0000\u0000"+
		"\u0000\u081e\u081f\u0001\u0000\u0000\u0000\u081f\u0821\u0001\u0000\u0000"+
		"\u0000\u0820\u081e\u0001\u0000\u0000\u0000\u0821\u0822\u0005\u0019\u0000"+
		"\u0000\u0822\u0187\u0001\u0000\u0000\u0000\u0823\u0828\u0005\u00d4\u0000"+
		"\u0000\u0824\u0828\u0005\u00d5\u0000\u0000\u0825\u0826\u0007\u001a\u0000"+
		"\u0000\u0826\u0828\u0006\u00c4\uffff\uffff\u0000\u0827\u0823\u0001\u0000"+
		"\u0000\u0000\u0827\u0824\u0001\u0000\u0000\u0000\u0827\u0825\u0001\u0000"+
		"\u0000\u0000\u0828\u0189\u0001\u0000\u0000\u0000\u0829\u082d\u0003\u0188"+
		"\u00c4\u0000\u082a\u082b\u0007\u001b\u0000\u0000\u082b\u082d\u0006\u00c5"+
		"\uffff\uffff\u0000\u082c\u0829\u0001\u0000\u0000\u0000\u082c\u082a\u0001"+
		"\u0000\u0000\u0000\u082d\u018b\u0001\u0000\u0000\u0000\u00e6\u0190\u019a"+
		"\u019e\u01a2\u01a6\u01ab\u01b3\u01bc\u01c2\u01ca\u01d5\u01de\u01e9\u01ef"+
		"\u01f2\u01f8\u01fb\u0202\u0212\u0217\u021a\u0225\u0229\u022c\u0230\u0238"+
		"\u023a\u023e\u0244\u0246\u024a\u024e\u0252\u0254\u0258\u025b\u025e\u0262"+
		"\u0265\u0269\u026b\u026f\u0273\u0275\u0278\u027a\u0282\u0289\u028b\u0290"+
		"\u0296\u0298\u029f\u02a5\u02ab\u02b3\u02b8\u02bc\u02bf\u02c2\u02c5\u02c7"+
		"\u02cb\u02ce\u02d4\u02d6\u02dd\u02e6\u02eb\u02f1\u0301\u0308\u030d\u0311"+
		"\u031c\u0324\u0327\u0332\u0336\u033d\u0346\u034d\u0354\u035d\u0363\u036f"+
		"\u0377\u037c\u037f\u0387\u039a\u03a2\u03a8\u03ac\u03b2\u03bf\u03c6\u03cc"+
		"\u03d3\u03dc\u03e1\u03f1\u03f5\u03fc\u0404\u0406\u0416\u0423\u0426\u042e"+
		"\u0434\u0441\u0450\u0462\u0464\u0471\u0475\u0479\u0485\u048e\u049a\u04a3"+
		"\u04aa\u04ad\u04bd\u04c0\u04d1\u04de\u04e2\u04ea\u04ef\u04f6\u04fa\u0501"+
		"\u0505\u050c\u0510\u0517\u051b\u0522\u0526\u052b\u0547\u054d\u0563\u0566"+
		"\u056b\u0572\u0579\u058d\u058f\u0599\u05a0\u05aa\u05ae\u05b1\u05b4\u05b7"+
		"\u05ba\u05c2\u05c9\u05fb\u0627\u0633\u0638\u063f\u0642\u064f\u0656\u0659"+
		"\u0666\u066b\u0671\u0675\u0678\u067b\u0682\u0686\u0697\u069d\u06a2\u06a5"+
		"\u06a8\u06b3\u06b9\u06c1\u06c3\u06cf\u06db\u06e7\u06fd\u070b\u070e\u0719"+
		"\u0723\u072e\u0732\u073b\u073e\u0741\u0751\u0764\u0773\u0777\u077c\u0780"+
		"\u0785\u0789\u078e\u0791\u0796\u079a\u079f\u07a3\u07a8\u07ac\u07b1\u07b5"+
		"\u07cc\u07d4\u07d6\u07df\u07ec\u07f4\u07f8\u07fc\u0812\u081e\u0827\u082c";
	public static final ATN _ATN =
		new ATNDeserializer().deserialize(_serializedATN.toCharArray());
	static {
		_decisionToDFA = new DFA[_ATN.getNumberOfDecisions()];
		for (int i = 0; i < _ATN.getNumberOfDecisions(); i++) {
			_decisionToDFA[i] = new DFA(_ATN.getDecisionState(i), i);
		}
	}
}
