
/*
 * Hibernate, Relational Persistence for Idiomatic Java
 *
 * License: GNU Lesser General Public License (LGPL), version 2.1 or later.
 * See the lgpl.txt file in the root directory or <http://www.gnu.org/licenses/lgpl-2.1.html>.
 */
package org.hibernate.grammars.importsql;

import org.antlr.v4.runtime.tree.ParseTreeListener;

/**
 * This interface defines a complete listener for a parse tree produced by
 * {@link SqlScriptParser}.
 */
public interface SqlScriptParserListener extends ParseTreeListener {
	/**
	 * Enter a parse tree produced by {@link SqlScriptParser#script}.
	 * @param ctx the parse tree
	 */
	void enterScript(SqlScriptParser.ScriptContext ctx);
	/**
	 * Exit a parse tree produced by {@link SqlScriptParser#script}.
	 * @param ctx the parse tree
	 */
	void exitScript(SqlScriptParser.ScriptContext ctx);
	/**
	 * Enter a parse tree produced by {@link SqlScriptParser#commandBlock}.
	 * @param ctx the parse tree
	 */
	void enterCommandBlock(SqlScriptParser.CommandBlockContext ctx);
	/**
	 * Exit a parse tree produced by {@link SqlScriptParser#commandBlock}.
	 * @param ctx the parse tree
	 */
	void exitCommandBlock(SqlScriptParser.CommandBlockContext ctx);
	/**
	 * Enter a parse tree produced by {@link SqlScriptParser#command}.
	 * @param ctx the parse tree
	 */
	void enterCommand(SqlScriptParser.CommandContext ctx);
	/**
	 * Exit a parse tree produced by {@link SqlScriptParser#command}.
	 * @param ctx the parse tree
	 */
	void exitCommand(SqlScriptParser.CommandContext ctx);
}
