/*
 * Hibernate, Relational Persistence for Idiomatic Java
 *
 * License: GNU Lesser General Public License (LGPL), version 2.1 or later
 * See the lgpl.txt file in the root directory or http://www.gnu.org/licenses/lgpl-2.1.html
 */
package org.hibernate.query.criteria;

import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.PluralPersistentAttribute;

import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.PluralJoin;
import jakarta.persistence.criteria.Predicate;

/**
 * Specialization of {@link JpaJoin} for {@link java.util.Set} typed attribute joins
 *
 * @author Steve Ebersole
 */
public interface JpaPluralJoin<O, C, E> extends JpaJoin<O, E>, PluralJoin<O, C, E> {
	@Override
	PluralPersistentAttribute<? super O, C, E> getAttribute();

	JpaPluralJoin<O, ? extends C, E> on(JpaExpression<Boolean> restriction);

	JpaPluralJoin<O, ? extends C, E> on(Expression<Boolean> restriction);

	JpaPluralJoin<O, ? extends C, E> on(JpaPredicate... restrictions);

	JpaPluralJoin<O, ? extends C, E> on(Predicate... restrictions);

	<S extends E> JpaPluralJoin<O, ?, S> treatAs(Class<S> treatAsType);

	<S extends E> JpaPluralJoin<O, ?, S> treatAs(EntityDomainType<S> treatAsType);
}
