/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal;

import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.model.domain.DiscriminatorSqmPath;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.internal.DiscriminatorSqmPathSource;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.domain.AbstractSqmPath;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.expression.SqmLiteralEntityType;
import org.hibernate.spi.NavigablePath;

public class EntityDiscriminatorSqmPath
extends AbstractSqmPath
implements DiscriminatorSqmPath {
    private final EntityDomainType entityDomainType;
    private final EntityMappingType entityDescriptor;

    protected EntityDiscriminatorSqmPath(NavigablePath navigablePath, SqmPathSource referencedPathSource, SqmPath<?> lhs, EntityDomainType entityDomainType, EntityMappingType entityDescriptor, NodeBuilder nodeBuilder) {
        super(navigablePath, referencedPathSource, lhs, nodeBuilder);
        this.entityDomainType = entityDomainType;
        this.entityDescriptor = entityDescriptor;
    }

    public EntityDomainType getEntityDomainType() {
        return this.entityDomainType;
    }

    public EntityMappingType getEntityDescriptor() {
        return this.entityDescriptor;
    }

    public DiscriminatorSqmPathSource getExpressible() {
        return (DiscriminatorSqmPathSource)this.getNodeType();
    }

    @Override
    public EntityDiscriminatorSqmPath copy(SqmCopyContext context) {
        EntityDiscriminatorSqmPath existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        return context.registerCopy(this, (EntityDiscriminatorSqmPath)this.getLhs().copy(context).type());
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        if (!this.entityDescriptor.hasSubclasses()) {
            return walker.visitEntityTypeLiteralExpression(new SqmLiteralEntityType(this.entityDomainType, (NodeBuilder)this.nodeBuilder()));
        }
        return walker.visitDiscriminatorPath(this);
    }
}

