/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.dialect.function.DateTruncEmulation;
import org.hibernate.query.ReturnableType;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.TemporalUnit;
import org.hibernate.query.sqm.function.AbstractSqmFunctionDescriptor;
import org.hibernate.query.sqm.function.FunctionRenderingSupport;
import org.hibernate.query.sqm.function.SelfRenderingSqmFunction;
import org.hibernate.query.sqm.internal.SqmCriteriaNodeBuilder;
import org.hibernate.query.sqm.produce.function.ArgumentTypesValidator;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionArgumentTypeResolvers;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.query.sqm.produce.function.internal.PatternRenderer;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.expression.SqmExtractUnit;
import org.hibernate.query.sqm.tree.expression.SqmLiteral;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.type.spi.TypeConfiguration;

public class TruncFunction
extends AbstractSqmFunctionDescriptor {
    protected final TruncRenderingSupport numericRenderingSupport;
    protected final TruncRenderingSupport datetimeRenderingSupport;
    private final DatetimeTrunc datetimeTrunc;
    private final DateTruncEmulation dateTruncEmulation;

    public TruncFunction(String truncPattern, String twoArgTruncPattern, DatetimeTrunc datetimeTrunc, String toDateFunction, TypeConfiguration typeConfiguration) {
        super("trunc", new TruncArgumentsValidator(), StandardFunctionReturnTypeResolvers.useArgType(1), StandardFunctionArgumentTypeResolvers.ARGUMENT_OR_IMPLIED_RESULT_TYPE);
        this.numericRenderingSupport = new TruncRenderingSupport(new PatternRenderer(truncPattern), twoArgTruncPattern != null ? new PatternRenderer(twoArgTruncPattern) : null);
        this.datetimeTrunc = datetimeTrunc;
        TruncRenderingSupport renderingSupport = null;
        DateTruncEmulation emulation = null;
        if (datetimeTrunc != null) {
            if (datetimeTrunc.getPattern() != null) {
                renderingSupport = new TruncRenderingSupport(new PatternRenderer(datetimeTrunc.getPattern()), null);
            } else {
                emulation = new DateTruncEmulation(toDateFunction, typeConfiguration);
            }
        }
        this.datetimeRenderingSupport = renderingSupport;
        this.dateTruncEmulation = emulation;
    }

    @Override
    protected <T> SelfRenderingSqmFunction<T> generateSqmFunctionExpression(List<? extends SqmTypedNode<?>> arguments, ReturnableType<T> impliedResultType, QueryEngine queryEngine, TypeConfiguration typeConfiguration) {
        ArgumentTypesValidator argumentsValidator;
        TruncRenderingSupport renderingSupport;
        SqmCriteriaNodeBuilder nodeBuilder = queryEngine.getCriteriaBuilder();
        ArrayList args = new ArrayList(arguments);
        if (arguments.size() == 2 && arguments.get(1) instanceof SqmExtractUnit) {
            renderingSupport = this.datetimeRenderingSupport;
            argumentsValidator = TruncArgumentsValidator.DATETIME_VALIDATOR;
            if (this.datetimeTrunc == null) {
                throw new UnsupportedOperationException("Datetime truncation is not supported for this database");
            }
            if (this.datetimeTrunc.getPattern() == null) {
                return this.dateTruncEmulation.generateSqmFunctionExpression(arguments, impliedResultType, queryEngine, typeConfiguration);
            }
            if (this.datetimeTrunc == DatetimeTrunc.TRUNC) {
                String pattern;
                TemporalUnit temporalUnit = ((SqmExtractUnit)arguments.get(1)).getUnit();
                switch (temporalUnit) {
                    case YEAR: {
                        pattern = "YYYY";
                        break;
                    }
                    case MONTH: {
                        pattern = "MM";
                        break;
                    }
                    case WEEK: {
                        pattern = "IW";
                        break;
                    }
                    case DAY: {
                        pattern = "DD";
                        break;
                    }
                    case HOUR: {
                        pattern = "HH";
                        break;
                    }
                    case MINUTE: {
                        pattern = "MI";
                        break;
                    }
                    case SECOND: {
                        pattern = "SS";
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Temporal unit not supported [" + temporalUnit + "]");
                    }
                }
                args.set(1, new SqmLiteral<String>(pattern, typeConfiguration.getBasicTypeForJavaType(String.class), nodeBuilder));
            }
        } else {
            renderingSupport = this.numericRenderingSupport;
            argumentsValidator = TruncArgumentsValidator.NUMERIC_VALIDATOR;
        }
        return new SelfRenderingSqmFunction<T>(this, renderingSupport, args, impliedResultType, argumentsValidator, this.getReturnTypeResolver(), queryEngine.getCriteriaBuilder(), this.getName());
    }

    protected static class TruncArgumentsValidator
    implements ArgumentsValidator {
        protected static final ArgumentTypesValidator DATETIME_VALIDATOR = new ArgumentTypesValidator(StandardArgumentsValidators.exactly(2), FunctionParameterType.TEMPORAL, FunctionParameterType.TEMPORAL_UNIT);
        protected static final ArgumentTypesValidator NUMERIC_VALIDATOR = new ArgumentTypesValidator(StandardArgumentsValidators.between(1, 2), FunctionParameterType.NUMERIC, FunctionParameterType.NUMERIC);

        protected TruncArgumentsValidator() {
        }

        @Override
        public void validate(List<? extends SqmTypedNode<?>> arguments, String functionName, TypeConfiguration typeConfiguration) {
            if (arguments.size() == 2 && arguments.get(1) instanceof SqmExtractUnit) {
                DATETIME_VALIDATOR.validate(arguments, functionName, typeConfiguration);
            } else {
                NUMERIC_VALIDATOR.validate(arguments, functionName, typeConfiguration);
            }
        }
    }

    private static class TruncRenderingSupport
    implements FunctionRenderingSupport {
        private final PatternRenderer truncPattern;
        private final PatternRenderer twoArgTruncPattern;

        public TruncRenderingSupport(PatternRenderer truncPattern, PatternRenderer twoArgTruncPattern) {
            this.truncPattern = truncPattern;
            this.twoArgTruncPattern = twoArgTruncPattern;
        }

        @Override
        public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, SqlAstTranslator<?> walker) {
            PatternRenderer pattern = this.twoArgTruncPattern != null && sqlAstArguments.size() == 2 ? this.twoArgTruncPattern : this.truncPattern;
            pattern.render(sqlAppender, sqlAstArguments, walker);
        }
    }

    public static enum DatetimeTrunc {
        DATE_TRUNC("date_trunc('?2',?1)"),
        DATETRUNC("datetrunc(?2,?1)"),
        TRUNC("trunc(?1,?2)"),
        FORMAT(null);

        private final String pattern;

        private DatetimeTrunc(String pattern) {
            this.pattern = pattern;
        }

        public String getPattern() {
            return this.pattern;
        }
    }
}

