
package org.hibernate.boot.jaxb.mapping;

import java.io.Serializable;
import jakarta.persistence.DiscriminatorType;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;


/**
 * 
 *                 See `@jakarta.persistence.DiscriminatorColumn`
 *                 See `@org.hibernate.annotations.DiscriminatorOptions`
 *             
 * 
 * <p>Java class for discriminator-column complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="discriminator-column">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <attribute name="name" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       <attribute name="discriminator-type" type="{http://www.hibernate.org/xsd/orm/mapping}discriminator-type" />
 *       <attribute name="column-definition" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       <attribute name="length" type="{http://www.w3.org/2001/XMLSchema}int" />
 *       <attribute name="force-selection" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "discriminator-column", namespace = "http://www.hibernate.org/xsd/orm/mapping")
public class JaxbDiscriminatorColumn
    implements Serializable
{

    @XmlAttribute(name = "name")
    protected String name;
    @XmlAttribute(name = "discriminator-type")
    @XmlJavaTypeAdapter(Adapter6 .class)
    protected DiscriminatorType discriminatorType;
    @XmlAttribute(name = "column-definition")
    protected String columnDefinition;
    @XmlAttribute(name = "length")
    protected Integer length;
    @XmlAttribute(name = "force-selection")
    protected Boolean forceSelection;

    /**
     * Gets the value of the name property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getName() {
        return name;
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setName(String value) {
        this.name = value;
    }

    /**
     * Gets the value of the discriminatorType property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public DiscriminatorType getDiscriminatorType() {
        return discriminatorType;
    }

    /**
     * Sets the value of the discriminatorType property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setDiscriminatorType(DiscriminatorType value) {
        this.discriminatorType = value;
    }

    /**
     * Gets the value of the columnDefinition property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getColumnDefinition() {
        return columnDefinition;
    }

    /**
     * Sets the value of the columnDefinition property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setColumnDefinition(String value) {
        this.columnDefinition = value;
    }

    /**
     * Gets the value of the length property.
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public Integer getLength() {
        return length;
    }

    /**
     * Sets the value of the length property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     */
    public void setLength(Integer value) {
        this.length = value;
    }

    /**
     * Gets the value of the forceSelection property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isForceSelection() {
        if (forceSelection == null) {
            return false;
        } else {
            return forceSelection;
        }
    }

    /**
     * Sets the value of the forceSelection property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setForceSelection(Boolean value) {
        this.forceSelection = value;
    }

}
