
package org.hibernate.boot.jaxb.hbm.spi;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for LazyWithNoProxyEnum.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="LazyWithNoProxyEnum">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}token">
 *     <enumeration value="false"/>
 *     <enumeration value="no-proxy"/>
 *     <enumeration value="proxy"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "LazyWithNoProxyEnum", namespace = "http://www.hibernate.org/xsd/orm/hbm")
@XmlEnum
public enum JaxbHbmLazyWithNoProxyEnum {

    @XmlEnumValue("false")
    FALSE("false"),
    @XmlEnumValue("no-proxy")
    NO_PROXY("no-proxy"),
    @XmlEnumValue("proxy")
    PROXY("proxy");
    private final String value;

    JaxbHbmLazyWithNoProxyEnum(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static JaxbHbmLazyWithNoProxyEnum fromValue(String v) {
        for (JaxbHbmLazyWithNoProxyEnum c: JaxbHbmLazyWithNoProxyEnum.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
