
package org.hibernate.boot.jaxb.hbm.spi;

import java.io.Serializable;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * 
 *                 Optimistic locking attribute based on a (last-updated) timestamp.
 *             
 * 
 * <p>Java class for TimestampAttributeType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="TimestampAttributeType">
 *   <complexContent>
 *     <extension base="{http://www.hibernate.org/xsd/orm/hbm}BaseVersionAttributeType">
 *       <attribute name="source" type="{http://www.hibernate.org/xsd/orm/hbm}TimestampSourceEnum" default="vm" />
 *       <attribute name="unsaved-value" type="{http://www.hibernate.org/xsd/orm/hbm}UnsavedValueTimestampEnum" default="null" />
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "TimestampAttributeType", namespace = "http://www.hibernate.org/xsd/orm/hbm")
public class JaxbHbmTimestampAttributeType
    extends JaxbHbmBaseVersionAttributeType
    implements Serializable, SingularAttributeInfo, ToolingHintContainer
{

    @XmlAttribute(name = "source")
    protected JaxbHbmTimestampSourceEnum source;
    @XmlAttribute(name = "unsaved-value")
    protected JaxbHbmUnsavedValueTimestampEnum unsavedValue;

    /**
     * Gets the value of the source property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbHbmTimestampSourceEnum }
     *     
     */
    public JaxbHbmTimestampSourceEnum getSource() {
        if (source == null) {
            return JaxbHbmTimestampSourceEnum.VM;
        } else {
            return source;
        }
    }

    /**
     * Sets the value of the source property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbHbmTimestampSourceEnum }
     *     
     */
    public void setSource(JaxbHbmTimestampSourceEnum value) {
        this.source = value;
    }

    /**
     * Gets the value of the unsavedValue property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbHbmUnsavedValueTimestampEnum }
     *     
     */
    public JaxbHbmUnsavedValueTimestampEnum getUnsavedValue() {
        if (unsavedValue == null) {
            return JaxbHbmUnsavedValueTimestampEnum.NULL;
        } else {
            return unsavedValue;
        }
    }

    /**
     * Sets the value of the unsavedValue property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbHbmUnsavedValueTimestampEnum }
     *     
     */
    public void setUnsavedValue(JaxbHbmUnsavedValueTimestampEnum value) {
        this.unsavedValue = value;
    }

}
