
package org.hibernate.boot.jaxb.mapping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import jakarta.persistence.LockModeType;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;


/**
 * 
 * 
 *                 @Target({TYPE}) @Retention(RUNTIME)
 *                 public @interface NamedQuery {
 *                 String name();
 *                 String query();
 *                 LockModeType lockMode() default NONE;
 *                 QueryHint[] hints() default {};
 *                 }
 * 
 *             
 * 
 * <p>Java class for named-query complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="named-query">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="description" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         <element name="query" type="{http://www.w3.org/2001/XMLSchema}string"/>
 *         <element name="lock-mode" type="{http://www.hibernate.org/xsd/orm/mapping}lock-mode-type" minOccurs="0"/>
 *         <element name="hint" type="{http://www.hibernate.org/xsd/orm/mapping}query-hint" maxOccurs="unbounded" minOccurs="0"/>
 *         <group ref="{http://www.hibernate.org/xsd/orm/mapping}hbm-common-named-query-elements"/>
 *       </sequence>
 *       <attribute name="name" use="required" type="{http://www.w3.org/2001/XMLSchema}string" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "named-query", namespace = "http://www.hibernate.org/xsd/orm/mapping", propOrder = {
    "description",
    "query",
    "lockMode",
    "hint",
    "comment",
    "timeout",
    "flushMode",
    "cacheable",
    "cacheMode",
    "cacheRegion",
    "fetchSize",
    "readOnly",
    "queryParam"
})
public class JaxbNamedQuery
    implements Serializable
{

    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected String description;
    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping", required = true)
    protected String query;
    @XmlElement(name = "lock-mode", namespace = "http://www.hibernate.org/xsd/orm/mapping", type = String.class)
    @XmlJavaTypeAdapter(Adapter11 .class)
    @XmlSchemaType(name = "token")
    protected LockModeType lockMode;
    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected List<JaxbQueryHint> hint;
    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected String comment;
    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected Integer timeout;
    @XmlElement(name = "flush-mode", namespace = "http://www.hibernate.org/xsd/orm/mapping", type = String.class)
    @XmlJavaTypeAdapter(Adapter18 .class)
    @XmlSchemaType(name = "token")
    protected FlushMode flushMode;
    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected Boolean cacheable;
    @XmlElement(name = "cache-mode", namespace = "http://www.hibernate.org/xsd/orm/mapping", type = String.class)
    @XmlJavaTypeAdapter(Adapter15 .class)
    @XmlSchemaType(name = "token")
    protected CacheMode cacheMode;
    @XmlElement(name = "cache-region", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected String cacheRegion;
    @XmlElement(name = "fetch-size", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected Integer fetchSize;
    @XmlElement(name = "read-only", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected Boolean readOnly;
    @XmlElement(name = "query-param", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected List<JaxbQueryParamType> queryParam;
    @XmlAttribute(name = "name", required = true)
    protected String name;

    /**
     * Gets the value of the description property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDescription() {
        return description;
    }

    /**
     * Sets the value of the description property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setDescription(String value) {
        this.description = value;
    }

    /**
     * Gets the value of the query property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getQuery() {
        return query;
    }

    /**
     * Sets the value of the query property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setQuery(String value) {
        this.query = value;
    }

    /**
     * Gets the value of the lockMode property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public LockModeType getLockMode() {
        return lockMode;
    }

    /**
     * Sets the value of the lockMode property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setLockMode(LockModeType value) {
        this.lockMode = value;
    }

    /**
     * Gets the value of the hint property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the hint property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getHint().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbQueryHint }
     * 
     * 
     * @return
     *     The value of the hint property.
     */
    public List<JaxbQueryHint> getHint() {
        if (hint == null) {
            hint = new ArrayList<>();
        }
        return this.hint;
    }

    /**
     * Gets the value of the comment property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getComment() {
        return comment;
    }

    /**
     * Sets the value of the comment property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setComment(String value) {
        this.comment = value;
    }

    /**
     * Gets the value of the timeout property.
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public Integer getTimeout() {
        return timeout;
    }

    /**
     * Sets the value of the timeout property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     */
    public void setTimeout(Integer value) {
        this.timeout = value;
    }

    /**
     * Gets the value of the flushMode property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public FlushMode getFlushMode() {
        return flushMode;
    }

    /**
     * Sets the value of the flushMode property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setFlushMode(FlushMode value) {
        this.flushMode = value;
    }

    /**
     * Gets the value of the cacheable property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean isCacheable() {
        return cacheable;
    }

    /**
     * Sets the value of the cacheable property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setCacheable(Boolean value) {
        this.cacheable = value;
    }

    /**
     * Gets the value of the cacheMode property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public CacheMode getCacheMode() {
        return cacheMode;
    }

    /**
     * Sets the value of the cacheMode property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setCacheMode(CacheMode value) {
        this.cacheMode = value;
    }

    /**
     * Gets the value of the cacheRegion property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCacheRegion() {
        return cacheRegion;
    }

    /**
     * Sets the value of the cacheRegion property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setCacheRegion(String value) {
        this.cacheRegion = value;
    }

    /**
     * Gets the value of the fetchSize property.
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public Integer getFetchSize() {
        return fetchSize;
    }

    /**
     * Sets the value of the fetchSize property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     */
    public void setFetchSize(Integer value) {
        this.fetchSize = value;
    }

    /**
     * Gets the value of the readOnly property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean isReadOnly() {
        return readOnly;
    }

    /**
     * Sets the value of the readOnly property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setReadOnly(Boolean value) {
        this.readOnly = value;
    }

    /**
     * Gets the value of the queryParam property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the queryParam property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getQueryParam().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbQueryParamType }
     * 
     * 
     * @return
     *     The value of the queryParam property.
     */
    public List<JaxbQueryParamType> getQueryParam() {
        if (queryParam == null) {
            queryParam = new ArrayList<>();
        }
        return this.queryParam;
    }

    /**
     * Gets the value of the name property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getName() {
        return name;
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setName(String value) {
        this.name = value;
    }

}
