/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.internal;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import org.hibernate.Internal;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.bytecode.internal.bytebuddy.BytecodeProviderImpl;
import org.hibernate.bytecode.spi.BytecodeProvider;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.NullnessUtil;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.jboss.logging.Logger;

public final class BytecodeProviderInitiator
implements StandardServiceInitiator<BytecodeProvider> {
    @Deprecated(forRemoval=true)
    public static final String BYTECODE_PROVIDER_NAME_BYTEBUDDY = "bytebuddy";
    @Deprecated(forRemoval=true)
    public static final String BYTECODE_PROVIDER_NAME_NONE = "none";
    @Deprecated(forRemoval=true)
    public static final String BYTECODE_PROVIDER_NAME_DEFAULT = "bytebuddy";
    public static final StandardServiceInitiator<BytecodeProvider> INSTANCE = new BytecodeProviderInitiator();

    @Override
    public BytecodeProvider initiateService(Map<String, Object> configurationValues, ServiceRegistryImplementor registry) {
        ClassLoaderService classLoaderService = NullnessUtil.castNonNull(registry.getService(ClassLoaderService.class));
        Collection<BytecodeProvider> bytecodeProviders = classLoaderService.loadJavaServices(BytecodeProvider.class);
        return BytecodeProviderInitiator.getBytecodeProvider(bytecodeProviders);
    }

    @Override
    public Class<BytecodeProvider> getServiceInitiated() {
        return BytecodeProvider.class;
    }

    @Internal
    public static BytecodeProvider buildDefaultBytecodeProvider() {
        return BytecodeProviderInitiator.getBytecodeProvider(ServiceLoader.load(BytecodeProvider.class));
    }

    @Internal
    public static BytecodeProvider getBytecodeProvider(Iterable<BytecodeProvider> bytecodeProviders) {
        Iterator<BytecodeProvider> iterator = bytecodeProviders.iterator();
        if (!iterator.hasNext()) {
            return new org.hibernate.bytecode.internal.none.BytecodeProviderImpl();
        }
        BytecodeProvider provider = iterator.next();
        if (iterator.hasNext()) {
            throw new IllegalStateException("Found multiple BytecodeProvider service registrations, cannot determine which one to use");
        }
        return provider;
    }

    @Internal
    public static BytecodeProvider buildBytecodeProvider(String providerName) {
        CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)BytecodeProviderInitiator.class.getName());
        LOG.bytecodeProvider(providerName);
        if (BYTECODE_PROVIDER_NAME_NONE.equals(providerName)) {
            return new org.hibernate.bytecode.internal.none.BytecodeProviderImpl();
        }
        if ("bytebuddy".equals(providerName)) {
            return new BytecodeProviderImpl();
        }
        LOG.unknownBytecodeProvider(providerName, "bytebuddy");
        return new BytecodeProviderImpl();
    }
}

