/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.Arrays;
import java.util.List;
import org.hibernate.Internal;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Constraint;
import org.hibernate.mapping.Table;
import org.jboss.logging.Logger;

public class PrimaryKey
extends Constraint {
    private static final Logger log = Logger.getLogger(PrimaryKey.class);
    private int[] originalOrder;

    public PrimaryKey(Table table) {
        this.setTable(table);
    }

    @Override
    public void addColumn(Column column) {
        for (Column next : this.getTable().getColumns()) {
            if (!next.getCanonicalName().equals(column.getCanonicalName())) continue;
            next.setNullable(false);
            if (!log.isDebugEnabled()) continue;
            log.debugf("Forcing column [%s] to be non-null as it is part of the primary key for table [%s]", (Object)column.getCanonicalName(), (Object)this.getTableNameForLogging(column));
        }
        super.addColumn(column);
    }

    protected String getTableNameForLogging(Column column) {
        if (this.getTable() != null) {
            if (this.getTable().getNameIdentifier() != null) {
                return this.getTable().getNameIdentifier().getCanonicalName();
            }
            return "<unknown>";
        }
        if (column.getValue() != null && column.getValue().getTable() != null) {
            return column.getValue().getTable().getNameIdentifier().getCanonicalName();
        }
        return "<unknown>";
    }

    public String sqlConstraintString(Dialect dialect) {
        StringBuilder buf = new StringBuilder("primary key (");
        boolean first = true;
        for (Column column : this.getColumns()) {
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            buf.append(column.getQuotedName(dialect));
        }
        return buf.append(')').toString();
    }

    @Override
    @Deprecated(since="6.2", forRemoval=true)
    public String sqlConstraintString(SqlStringGenerationContext context, String constraintName, String defaultCatalog, String defaultSchema) {
        Dialect dialect = context.getDialect();
        StringBuilder buf = new StringBuilder();
        buf.append(dialect.getAddPrimaryKeyConstraintString(constraintName)).append('(');
        boolean first = true;
        for (Column column : this.getColumns()) {
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            buf.append(column.getQuotedName(dialect));
        }
        return buf.append(')').toString();
    }

    @Override
    public String generatedConstraintNamePrefix() {
        return "PK_";
    }

    @Override
    public String getExportIdentifier() {
        return StringHelper.qualify(this.getTable().getExportIdentifier(), "PK-" + this.getName());
    }

    public List<Column> getColumnsInOriginalOrder() {
        if (this.originalOrder == null) {
            return this.getColumns();
        }
        List<Column> columns = this.getColumns();
        Column[] columnsInOriginalOrder = new Column[columns.size()];
        for (int i = 0; i < columnsInOriginalOrder.length; ++i) {
            columnsInOriginalOrder[this.originalOrder[i]] = columns.get(i);
        }
        return Arrays.asList(columnsInOriginalOrder);
    }

    @Internal
    public void reorderColumns(List<Column> reorderedColumns) {
        if (this.originalOrder != null) {
            assert (this.getColumns().equals(reorderedColumns));
            return;
        }
        assert (this.getColumns().size() == reorderedColumns.size() && this.getColumns().containsAll(reorderedColumns));
        List<Column> columns = this.getColumns();
        this.originalOrder = new int[columns.size()];
        for (int i = 0; i < reorderedColumns.size(); ++i) {
            Column reorderedColumn = reorderedColumns.get(i);
            this.originalOrder[i] = columns.indexOf(reorderedColumn);
        }
        columns.clear();
        columns.addAll(reorderedColumns);
    }

    @Internal
    public int[] getOriginalOrder() {
        return this.originalOrder;
    }
}

