/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results.dynamic;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import org.hibernate.engine.FetchTiming;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.mapping.ValuedModelPart;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.results.DomainResultCreationStateImpl;
import org.hibernate.query.results.ResultsHelper;
import org.hibernate.query.results.dynamic.DynamicFetchBuilder;
import org.hibernate.query.results.dynamic.DynamicFetchBuilderContainer;
import org.hibernate.query.results.dynamic.DynamicFetchBuilderLegacy;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.embeddable.EmbeddableValuedFetchable;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;

public class DynamicFetchBuilderStandard
implements DynamicFetchBuilder,
NativeQuery.ReturnProperty {
    private final String fetchableName;
    private final List<String> columnNames;

    public DynamicFetchBuilderStandard(String fetchableName) {
        this.fetchableName = fetchableName;
        this.columnNames = new ArrayList<String>();
    }

    private DynamicFetchBuilderStandard(String fetchableName, List<String> columnNames) {
        this.fetchableName = fetchableName;
        this.columnNames = columnNames;
    }

    @Override
    public DynamicFetchBuilderStandard cacheKeyInstance() {
        return new DynamicFetchBuilderStandard(this.fetchableName, List.copyOf(this.columnNames));
    }

    public DynamicFetchBuilderStandard cacheKeyInstance(DynamicFetchBuilderContainer container) {
        return new DynamicFetchBuilderStandard(this.fetchableName, List.copyOf(this.columnNames));
    }

    @Override
    public Fetch buildFetch(FetchParent parent, NavigablePath fetchPath, JdbcValuesMetadata jdbcResultsMetadata, BiFunction<String, String, DynamicFetchBuilderLegacy> legacyFetchResolver, DomainResultCreationState domainResultCreationState) {
        DomainResultCreationStateImpl creationStateImpl = ResultsHelper.impl(domainResultCreationState);
        TableGroup ownerTableGroup = creationStateImpl.getFromClauseAccess().getTableGroup(parent.getNavigablePath());
        Fetchable attributeMapping = (Fetchable)parent.getReferencedMappingContainer().findSubPart(this.fetchableName, null);
        SqlExpressionResolver sqlExpressionResolver = domainResultCreationState.getSqlAstCreationState().getSqlExpressionResolver();
        if (attributeMapping instanceof BasicValuedModelPart) {
            attributeMapping.forEachSelectable(this.getSelectableConsumer(fetchPath, jdbcResultsMetadata, domainResultCreationState, creationStateImpl, ownerTableGroup, sqlExpressionResolver, (BasicValuedModelPart)attributeMapping));
            return parent.generateFetchableFetch(attributeMapping, fetchPath, FetchTiming.IMMEDIATE, true, null, creationStateImpl);
        }
        if (attributeMapping instanceof EmbeddableValuedFetchable) {
            attributeMapping.forEachSelectable(this.getSelectableConsumer(fetchPath, jdbcResultsMetadata, domainResultCreationState, creationStateImpl, ownerTableGroup, sqlExpressionResolver, (EmbeddableValuedFetchable)attributeMapping));
            return parent.generateFetchableFetch(attributeMapping, fetchPath, FetchTiming.IMMEDIATE, false, null, creationStateImpl);
        }
        if (attributeMapping instanceof ToOneAttributeMapping) {
            ToOneAttributeMapping toOneAttributeMapping = (ToOneAttributeMapping)attributeMapping;
            toOneAttributeMapping.getForeignKeyDescriptor().getPart(toOneAttributeMapping.getSideNature()).forEachSelectable(this.getSelectableConsumer(fetchPath, jdbcResultsMetadata, domainResultCreationState, creationStateImpl, ownerTableGroup, sqlExpressionResolver, toOneAttributeMapping.getForeignKeyDescriptor()));
            return parent.generateFetchableFetch(attributeMapping, fetchPath, FetchTiming.DELAYED, false, null, creationStateImpl);
        }
        assert (attributeMapping instanceof PluralAttributeMapping);
        PluralAttributeMapping pluralAttributeMapping = (PluralAttributeMapping)attributeMapping;
        pluralAttributeMapping.getKeyDescriptor().visitTargetSelectables(this.getSelectableConsumer(fetchPath, jdbcResultsMetadata, domainResultCreationState, creationStateImpl, ownerTableGroup, sqlExpressionResolver, pluralAttributeMapping.getKeyDescriptor()));
        return parent.generateFetchableFetch(attributeMapping, fetchPath, FetchTiming.DELAYED, false, null, creationStateImpl);
    }

    private SelectableConsumer getSelectableConsumer(NavigablePath fetchPath, JdbcValuesMetadata jdbcResultsMetadata, DomainResultCreationState domainResultCreationState, DomainResultCreationStateImpl creationStateImpl, TableGroup ownerTableGroup, SqlExpressionResolver sqlExpressionResolver, ValuedModelPart valuedModelPart) {
        return (selectionIndex, selectableMapping) -> {
            TableReference tableReference = ownerTableGroup.resolveTableReference(fetchPath, valuedModelPart, selectableMapping.getContainingTableExpression());
            String columnAlias = this.columnNames.get(selectionIndex);
            sqlExpressionResolver.resolveSqlSelection(ResultsHelper.resolveSqlExpression(creationStateImpl, jdbcResultsMetadata, tableReference, selectableMapping, columnAlias), selectableMapping.getJdbcMapping().getJdbcJavaType(), null, domainResultCreationState.getSqlAstCreationState().getCreationContext().getSessionFactory().getTypeConfiguration());
        };
    }

    @Override
    public NativeQuery.ReturnProperty addColumnAlias(String columnAlias) {
        this.columnNames.add(columnAlias);
        return this;
    }

    @Override
    public List<String> getColumnAliases() {
        return this.columnNames;
    }

    public int hashCode() {
        int result = this.fetchableName.hashCode();
        result = 31 * result + this.columnNames.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DynamicFetchBuilderStandard that = (DynamicFetchBuilderStandard)o;
        return this.fetchableName.equals(that.fetchableName) && this.columnNames.equals(that.columnNames);
    }
}

