/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.entity;

import java.util.Collection;
import java.util.function.Consumer;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.StaleObjectStateException;
import org.hibernate.WrongClassException;
import org.hibernate.bytecode.enhance.spi.LazyPropertyInitializer;
import org.hibernate.bytecode.enhance.spi.interceptor.EnhancementAsProxyLazinessInterceptor;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.entry.CacheEntry;
import org.hibernate.engine.internal.ManagedTypeHelper;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.EntityUniqueKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.engine.spi.SessionEventListenerManager;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.spi.PreLoadEvent;
import org.hibernate.event.spi.PreLoadEventListener;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.loader.ast.internal.CacheEntityLoaderHelper;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.AttributeMetadata;
import org.hibernate.metamodel.mapping.DiscriminatorValueDetails;
import org.hibernate.metamodel.mapping.EntityDiscriminatorMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.metamodel.mapping.EntityVersionMapping;
import org.hibernate.metamodel.mapping.ManagedMappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.property.access.internal.PropertyAccessStrategyBackRefImpl;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.proxy.map.MapProxy;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.results.graph.AbstractFetchParentAccess;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.basic.BasicResultAssembler;
import org.hibernate.sql.results.graph.embeddable.internal.EmbeddableAssembler;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.graph.entity.EntityLoadingLogging;
import org.hibernate.sql.results.graph.entity.EntityResultGraphNode;
import org.hibernate.sql.results.graph.entity.LoadingEntityEntry;
import org.hibernate.sql.results.internal.NullValueAssembler;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingState;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.hibernate.type.AssociationType;
import org.hibernate.type.Type;

public abstract class AbstractEntityInitializer
extends AbstractFetchParentAccess
implements EntityInitializer {
    private final EntityValuedModelPart referencedModelPart;
    private final EntityPersister entityDescriptor;
    private final EntityPersister rootEntityDescriptor;
    private final NavigablePath navigablePath;
    private final LockMode lockMode;
    private final DomainResultAssembler<?> identifierAssembler;
    private final BasicResultAssembler<?> discriminatorAssembler;
    private final DomainResultAssembler<?> versionAssembler;
    private final DomainResultAssembler<Object> rowIdAssembler;
    private final DomainResultAssembler<?>[][] assemblers;
    private EntityPersister concreteDescriptor;
    private EntityKey entityKey;
    private Object version;
    private Object entityInstance;
    private Object entityInstanceForNotify;
    protected boolean missing;
    boolean isInitialized;
    private boolean isOwningInitializer;
    private Object[] resolvedEntityState;

    protected AbstractEntityInitializer(EntityResultGraphNode resultDescriptor, NavigablePath navigablePath, LockMode lockMode, Fetch identifierFetch, Fetch discriminatorFetch, DomainResult<Object> rowIdResult, AssemblerCreationState creationState) {
        this.referencedModelPart = resultDescriptor.getEntityValuedModelPart();
        this.entityDescriptor = (EntityPersister)this.referencedModelPart.getEntityMappingType();
        String rootEntityName = this.entityDescriptor.getRootEntityName();
        this.rootEntityDescriptor = rootEntityName == null || rootEntityName.equals(this.entityDescriptor.getEntityName()) ? this.entityDescriptor : this.entityDescriptor.getRootEntityDescriptor().getEntityPersister();
        this.navigablePath = navigablePath;
        this.lockMode = lockMode;
        assert (lockMode != null);
        this.identifierAssembler = identifierFetch != null ? identifierFetch.createAssembler(this, creationState) : null;
        this.discriminatorAssembler = discriminatorFetch != null ? (BasicResultAssembler)discriminatorFetch.createAssembler(this, creationState) : null;
        EntityVersionMapping versionMapping = this.entityDescriptor.getVersionMapping();
        if (versionMapping != null) {
            Fetch versionFetch = resultDescriptor.findFetch(versionMapping);
            assert (versionFetch != null);
            this.versionAssembler = versionFetch.createAssembler(this, creationState);
        } else {
            this.versionAssembler = null;
        }
        this.rowIdAssembler = rowIdResult != null ? rowIdResult.createResultAssembler(this, creationState) : null;
        Collection<EntityMappingType> subMappingTypes = this.rootEntityDescriptor.getSubMappingTypes();
        this.assemblers = new DomainResultAssembler[subMappingTypes.size() + 1][];
        this.assemblers[this.rootEntityDescriptor.getSubclassId()] = new DomainResultAssembler[this.rootEntityDescriptor.getNumberOfFetchables()];
        for (EntityMappingType subMappingType : subMappingTypes) {
            this.assemblers[subMappingType.getSubclassId()] = new DomainResultAssembler[subMappingType.getNumberOfFetchables()];
        }
        int size = this.entityDescriptor.getNumberOfFetchables();
        for (int i = 0; i < size; ++i) {
            AttributeMapping attributeMapping = this.entityDescriptor.getFetchable(i).asAttributeMapping();
            Fetch fetch = resultDescriptor.findFetch(attributeMapping);
            DomainResultAssembler<?> stateAssembler = fetch == null ? new NullValueAssembler(attributeMapping.getMappedType().getMappedJavaType()) : fetch.createAssembler(this, creationState);
            int stateArrayPosition = attributeMapping.getStateArrayPosition();
            EntityMappingType declaringType = attributeMapping.getDeclaringType().asEntityMappingType();
            this.assemblers[declaringType.getSubclassId()][stateArrayPosition] = stateAssembler;
            for (EntityMappingType subMappingType : declaringType.getSubMappingTypes()) {
                this.assemblers[subMappingType.getSubclassId()][stateArrayPosition] = stateAssembler;
            }
        }
    }

    private static void deepCopy(ManagedMappingType containerDescriptor, Object[] source, Object[] target) {
        int numberOfAttributeMappings = containerDescriptor.getNumberOfAttributeMappings();
        for (int i = 0; i < numberOfAttributeMappings; ++i) {
            AttributeMapping attributeMapping = containerDescriptor.getAttributeMapping(i);
            AttributeMetadata attributeMetadata = attributeMapping.getAttributeMetadata();
            if (!attributeMetadata.isUpdatable()) continue;
            int position = attributeMapping.getStateArrayPosition();
            target[position] = AbstractEntityInitializer.copy(attributeMetadata, source[position]);
        }
    }

    private static Object copy(AttributeMetadata attributeMetadata, Object sourceValue) {
        return sourceValue == LazyPropertyInitializer.UNFETCHED_PROPERTY || sourceValue == PropertyAccessStrategyBackRefImpl.UNKNOWN ? sourceValue : attributeMetadata.getMutabilityPlan().deepCopy(sourceValue);
    }

    @Override
    public ModelPart getInitializedPart() {
        return this.referencedModelPart;
    }

    protected abstract String getSimpleConcreteImplName();

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    protected DomainResultAssembler<?> getIdentifierAssembler() {
        return this.identifierAssembler;
    }

    protected boolean isMissing() {
        return this.missing;
    }

    protected void setMissing(boolean missing) {
        this.missing = missing;
    }

    protected abstract boolean isEntityReturn();

    @Override
    public EntityPersister getEntityDescriptor() {
        return this.entityDescriptor;
    }

    @Override
    public Object getEntityInstance() {
        return this.entityInstance;
    }

    public Object getKeyValue() {
        return this.entityKey == null ? null : this.entityKey.getIdentifier();
    }

    @Override
    public EntityKey getEntityKey() {
        return this.entityKey;
    }

    @Override
    public Object getParentKey() {
        return this.getKeyValue();
    }

    @Override
    public void registerResolutionListener(Consumer<Object> listener) {
        if (this.entityInstanceForNotify != null) {
            listener.accept(this.entityInstanceForNotify);
        } else {
            super.registerResolutionListener(listener);
        }
    }

    @Override
    public void resolveKey(RowProcessingState rowProcessingState) {
        if (this.entityKey == null) {
            if (EntityLoadingLogging.ENTITY_LOADING_LOGGER.isTraceEnabled()) {
                EntityLoadingLogging.ENTITY_LOADING_LOGGER.tracef("(%s) Beginning Initializer#resolveKey process for entity : %s", (Object)StringHelper.collapse(this.getClass().getName()), (Object)this.getNavigablePath());
            }
            this.concreteDescriptor = this.determineConcreteEntityDescriptor(rowProcessingState);
            if (this.concreteDescriptor == null) {
                this.missing = true;
            } else {
                this.resolveEntityKey(rowProcessingState);
                if (this.entityKey == null) {
                    EntityLoadingLogging.ENTITY_LOADING_LOGGER.debugf("(%s) EntityKey (%s) is null", (Object)this.getSimpleConcreteImplName(), (Object)this.getNavigablePath());
                    assert (this.missing);
                } else if (EntityLoadingLogging.ENTITY_LOADING_LOGGER.isDebugEnabled()) {
                    EntityLoadingLogging.ENTITY_LOADING_LOGGER.debugf("(%s) Hydrated EntityKey (%s): %s", (Object)this.getSimpleConcreteImplName(), (Object)this.getNavigablePath(), this.entityKey.getIdentifier());
                }
            }
        }
    }

    private EntityPersister determineConcreteEntityDescriptor(RowProcessingState rowProcessingState) throws WrongClassException {
        if (this.discriminatorAssembler == null) {
            return this.entityDescriptor;
        }
        EntityDiscriminatorMapping discriminatorMapping = this.entityDescriptor.getDiscriminatorMapping();
        assert (discriminatorMapping != null);
        Object discriminator = this.discriminatorAssembler.extractRawValue(rowProcessingState);
        DiscriminatorValueDetails discriminatorDetails = discriminatorMapping.resolveDiscriminatorValue(discriminator);
        if (discriminatorDetails == null) {
            return this.entityDescriptor;
        }
        EntityMappingType indicatedEntity = discriminatorDetails.getIndicatedEntity();
        if (indicatedEntity.isTypeOrSuperType(this.entityDescriptor)) {
            return indicatedEntity.getEntityPersister();
        }
        throw new WrongClassException(indicatedEntity.getEntityName(), null, this.entityDescriptor.getEntityName(), discriminator);
    }

    protected void resolveEntityKey(RowProcessingState rowProcessingState) {
        if (this.entityKey == null) {
            Object id = this.initializeIdentifier(rowProcessingState);
            if (id == null) {
                this.missing = true;
            } else {
                this.entityKey = new EntityKey(id, this.concreteDescriptor);
            }
        }
    }

    private Object initializeIdentifier(RowProcessingState rowProcessingState) {
        JdbcValuesSourceProcessingState jdbcValuesSourceProcessingState = rowProcessingState.getJdbcValuesSourceProcessingState();
        Object id = jdbcValuesSourceProcessingState.getProcessingOptions().getEffectiveOptionalId();
        if (this.useEmbeddedIdentifierInstanceAsEntity(id)) {
            this.entityInstance = id;
            return id;
        }
        if (this.identifierAssembler == null) {
            return id;
        }
        return this.identifierAssembler.assemble(rowProcessingState, jdbcValuesSourceProcessingState.getProcessingOptions());
    }

    private boolean useEmbeddedIdentifierInstanceAsEntity(Object id) {
        return id != null && id.getClass().equals(this.concreteDescriptor.getJavaType().getJavaType());
    }

    @Override
    public void resolveInstance(RowProcessingState rowProcessingState) {
        if (!this.missing && !this.isInitialized) {
            if (this.shouldSkipResolveInstance(rowProcessingState)) {
                this.missing = true;
                return;
            }
            LoadingEntityEntry existingLoadingEntry = rowProcessingState.getSession().getPersistenceContextInternal().getLoadContexts().findLoadingEntityEntry(this.entityKey);
            this.setIsOwningInitializer(this.entityKey.getIdentifier(), existingLoadingEntry);
            if (this.entityInstance == null) {
                this.resolveEntityInstance(rowProcessingState, existingLoadingEntry, this.entityKey.getIdentifier());
            } else if (existingLoadingEntry != null && existingLoadingEntry.getEntityInitializer() != this) {
                this.isInitialized = true;
            }
        }
    }

    protected boolean shouldSkipResolveInstance(RowProcessingState rowProcessingState) {
        Initializer parentInitializer;
        if (this.navigablePath.getParent() != null && (parentInitializer = rowProcessingState.resolveInitializer(this.navigablePath.getParent())) != null) {
            ModelPart modelPart = this.referencedModelPart;
            NavigablePath currentNavigablePath = this.navigablePath;
            while (parentInitializer != null && !parentInitializer.isEntityInitializer()) {
                modelPart = parentInitializer.getInitializedPart();
                currentNavigablePath = currentNavigablePath.getParent();
                parentInitializer = rowProcessingState.resolveInitializer(currentNavigablePath.getParent());
            }
            if (parentInitializer != null && parentInitializer.asEntityInitializer().getEntityDescriptor().getEntityMetamodel().isPolymorphic()) {
                parentInitializer.resolveKey(rowProcessingState);
                return !this.isReferencedModelPartInConcreteParent(modelPart, currentNavigablePath, parentInitializer);
            }
        }
        return false;
    }

    private boolean isReferencedModelPartInConcreteParent(ModelPart modelPart, NavigablePath partNavigablePath, Initializer parentInitializer) {
        EntityPersister parentConcreteDescriptor = parentInitializer.asEntityInitializer().getConcreteDescriptor();
        if (parentConcreteDescriptor != null && parentConcreteDescriptor.getEntityMetamodel().isPolymorphic()) {
            EntityMappingType entityType = modelPart.asAttributeMapping() != null ? modelPart.asAttributeMapping().getDeclaringType().findContainingEntityMapping() : modelPart.asEntityMappingType();
            ModelPart concreteModelPart = parentConcreteDescriptor.findSubPart(partNavigablePath.getLocalName(), entityType);
            if (concreteModelPart == null || !modelPart.getJavaType().getJavaTypeClass().isAssignableFrom(concreteModelPart.getJavaType().getJavaTypeClass())) {
                return false;
            }
        }
        return true;
    }

    protected void resolveEntityInstance(RowProcessingState rowProcessingState, LoadingEntityEntry existingLoadingEntry, Object entityIdentifier) {
        if (EntityLoadingLogging.ENTITY_LOADING_LOGGER.isTraceEnabled()) {
            EntityLoadingLogging.ENTITY_LOADING_LOGGER.tracef("(%s) Beginning Initializer#resolveInstance process for entity (%s) : %s", (Object)StringHelper.collapse(this.getClass().getName()), (Object)this.getNavigablePath(), entityIdentifier);
        }
        PersistenceContext persistenceContext = rowProcessingState.getSession().getPersistenceContextInternal();
        Object proxy = this.getProxy(persistenceContext);
        Object entityInstanceFromExecutionContext = this.getEntityInstanceFromExecutionContext(rowProcessingState);
        if (this.isProxyInstance(proxy)) {
            if (entityInstanceFromExecutionContext != null) {
                this.entityInstance = entityInstanceFromExecutionContext;
                this.registerLoadingEntityInstanceFromExecutionContext(rowProcessingState, this.entityInstance);
            } else {
                this.entityInstance = proxy;
                if (Hibernate.isInitialized(this.entityInstance)) {
                    this.isInitialized = true;
                    this.registerReloadedEntity(rowProcessingState, this.entityInstance);
                    if (rowProcessingState.getQueryOptions().isResultCachingEnabled() == Boolean.TRUE) {
                        this.resolveState(rowProcessingState);
                    }
                }
            }
        } else {
            Object existingEntity = persistenceContext.getEntity(this.entityKey);
            if (existingEntity != null) {
                this.entityInstance = existingEntity;
                if (existingLoadingEntry == null) {
                    if (this.isExistingEntityInitialized(existingEntity)) {
                        this.isInitialized = true;
                        this.registerReloadedEntity(rowProcessingState, existingEntity);
                        this.notifyResolutionListeners(this.entityInstance);
                        if (rowProcessingState.getQueryOptions().isResultCachingEnabled() == Boolean.TRUE) {
                            this.resolveState(rowProcessingState);
                        }
                    } else {
                        this.registerLoadingEntityInstanceFromExecutionContext(rowProcessingState, this.entityInstance);
                    }
                }
            } else if (entityInstanceFromExecutionContext != null) {
                this.entityInstance = entityInstanceFromExecutionContext;
                this.registerLoadingEntityInstanceFromExecutionContext(rowProcessingState, this.entityInstance);
            } else {
                this.entityInstance = this.resolveInstance(entityIdentifier, existingLoadingEntry, rowProcessingState);
                if (this.isOwningInitializer && !this.isInitialized && this.identifierAssembler instanceof EmbeddableAssembler) {
                    this.identifierAssembler.assemble(rowProcessingState);
                }
            }
            this.upgradeLockMode(rowProcessingState);
        }
    }

    protected abstract void registerLoadingEntityInstanceFromExecutionContext(RowProcessingState var1, Object var2);

    protected Object getEntityInstanceFromExecutionContext(RowProcessingState rowProcessingState) {
        ExecutionContext executionContext = rowProcessingState.getJdbcValuesSourceProcessingState().getExecutionContext();
        if (this.rootEntityDescriptor == executionContext.getRootEntityDescriptor() && this.getEntityKey().getIdentifier().equals(executionContext.getEntityId())) {
            return executionContext.getEntityInstance();
        }
        return null;
    }

    private void upgradeLockMode(RowProcessingState rowProcessingState) {
        EntityEntry entry;
        if (this.lockMode != LockMode.NONE && rowProcessingState.upgradeLocks() && (entry = rowProcessingState.getSession().getPersistenceContextInternal().getEntry(this.entityInstance)) != null && entry.getLockMode().lessThan(this.lockMode)) {
            if (this.versionAssembler != null && entry.getLockMode() != LockMode.NONE) {
                this.checkVersion(entry, rowProcessingState);
            }
            entry.setLockMode(this.lockMode);
        }
    }

    private boolean isProxyInstance(Object proxy) {
        return proxy != null && (proxy instanceof MapProxy || this.entityDescriptor.getJavaType().getJavaTypeClass().isInstance(proxy));
    }

    private boolean isExistingEntityInitialized(Object existingEntity) {
        return Hibernate.isInitialized(existingEntity);
    }

    private void checkVersion(EntityEntry entry, RowProcessingState rowProcessingState) throws HibernateException {
        Object version = entry.getVersion();
        if (version != null) {
            Object currentVersion = this.versionAssembler.assemble(rowProcessingState);
            if (!this.concreteDescriptor.getVersionType().isEqual(version, currentVersion)) {
                StatisticsImplementor statistics = rowProcessingState.getSession().getFactory().getStatistics();
                if (statistics.isStatisticsEnabled()) {
                    statistics.optimisticFailure(this.concreteDescriptor.getEntityName());
                }
                throw new StaleObjectStateException(this.concreteDescriptor.getEntityName(), entry.getId());
            }
        }
    }

    protected Object getProxy(PersistenceContext persistenceContext) {
        return persistenceContext.getProxy(this.entityKey);
    }

    private void setIsOwningInitializer(Object entityIdentifier, LoadingEntityEntry existingLoadingEntry) {
        if (existingLoadingEntry != null) {
            if (EntityLoadingLogging.ENTITY_LOADING_LOGGER.isDebugEnabled()) {
                EntityLoadingLogging.ENTITY_LOADING_LOGGER.debugf("(%s) Found existing loading entry [%s] - using loading instance", (Object)this.getSimpleConcreteImplName(), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), entityIdentifier));
            }
            if (existingLoadingEntry.getEntityInitializer() == this) {
                this.isOwningInitializer = true;
            } else {
                this.isInitialized = true;
            }
        } else {
            this.isOwningInitializer = true;
        }
    }

    protected boolean isOwningInitializer() {
        return this.isOwningInitializer;
    }

    private Object resolveInstance(Object entityIdentifier, LoadingEntityEntry existingLoadingEntry, RowProcessingState rowProcessingState) {
        if (this.isOwningInitializer) {
            assert (existingLoadingEntry == null || existingLoadingEntry.getEntityInstance() == null);
            return this.resolveEntityInstance(entityIdentifier, rowProcessingState);
        }
        if (EntityLoadingLogging.ENTITY_LOADING_LOGGER.isDebugEnabled()) {
            EntityLoadingLogging.ENTITY_LOADING_LOGGER.debugf("(%s) Entity [%s] being loaded by another initializer [%s] - skipping processing", (Object)this.getSimpleConcreteImplName(), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), entityIdentifier), (Object)existingLoadingEntry.getEntityInitializer());
        }
        return existingLoadingEntry.getEntityInstance();
    }

    protected Object resolveEntityInstance(Object entityIdentifier, RowProcessingState rowProcessingState) {
        Object cached;
        Object resolved = this.resolveToOptionalInstance(rowProcessingState);
        if (resolved != null) {
            this.registerLoadingEntity(rowProcessingState, resolved);
            return resolved;
        }
        if (this.entityDescriptor.canUseReferenceCacheEntries() && (cached = this.resolveInstanceFromCache(rowProcessingState)) != null) {
            this.isInitialized = true;
            this.registerReloadedEntity(rowProcessingState, cached);
            return cached;
        }
        Object instance = this.instantiateEntity(entityIdentifier, rowProcessingState.getSession());
        this.registerLoadingEntity(rowProcessingState, instance);
        return instance;
    }

    protected Object instantiateEntity(Object entityIdentifier, SharedSessionContractImplementor session) {
        Object instance = session.instantiate(this.concreteDescriptor, this.entityKey.getIdentifier());
        if (EntityLoadingLogging.ENTITY_LOADING_LOGGER.isDebugEnabled()) {
            EntityLoadingLogging.ENTITY_LOADING_LOGGER.debugf("(%s) Created new entity instance [%s] : %s", (Object)this.getSimpleConcreteImplName(), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), entityIdentifier), (Object)System.identityHashCode(instance));
        }
        return instance;
    }

    private Object resolveToOptionalInstance(RowProcessingState rowProcessingState) {
        if (this.isEntityReturn()) {
            JdbcValuesSourceProcessingOptions processingOptions = rowProcessingState.getJdbcValuesSourceProcessingState().getProcessingOptions();
            return this.matchesOptionalInstance(processingOptions) ? processingOptions.getEffectiveOptionalObject() : null;
        }
        return null;
    }

    private boolean matchesOptionalInstance(JdbcValuesSourceProcessingOptions processingOptions) {
        Object optionalEntityInstance = processingOptions.getEffectiveOptionalObject();
        Object requestedEntityId = processingOptions.getEffectiveOptionalId();
        return requestedEntityId != null && optionalEntityInstance != null && requestedEntityId.equals(this.entityKey.getIdentifier());
    }

    private Object resolveInstanceFromCache(RowProcessingState rowProcessingState) {
        return CacheEntityLoaderHelper.INSTANCE.loadFromSecondLevelCache(rowProcessingState.getSession().asEventSource(), null, this.lockMode, this.entityDescriptor, this.entityKey);
    }

    protected void registerLoadingEntity(RowProcessingState rowProcessingState, Object instance) {
        rowProcessingState.getJdbcValuesSourceProcessingState().registerLoadingEntity(this.entityKey, new LoadingEntityEntry(this, this.entityKey, this.concreteDescriptor, instance));
    }

    protected void registerReloadedEntity(RowProcessingState rowProcessingState, Object instance) {
        if (rowProcessingState.hasCallbackActions()) {
            rowProcessingState.getJdbcValuesSourceProcessingState().registerReloadedEntity(this.entityKey, new LoadingEntityEntry(this, this.entityKey, this.concreteDescriptor, instance));
        }
    }

    @Override
    public void initializeInstance(RowProcessingState rowProcessingState) {
        if (!this.missing && !this.isInitialized) {
            LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(this.entityInstance);
            SharedSessionContractImplementor session = rowProcessingState.getSession();
            PersistenceContext persistenceContext = session.getPersistenceContextInternal();
            if (lazyInitializer != null) {
                Object instance = persistenceContext.getEntity(this.entityKey);
                if (instance == null) {
                    instance = this.resolveInstance(this.entityKey.getIdentifier(), persistenceContext.getLoadContexts().findLoadingEntityEntry(this.entityKey), rowProcessingState);
                    this.initializeEntity(instance, rowProcessingState);
                }
                lazyInitializer.setImplementation(instance);
                this.entityInstanceForNotify = instance;
            } else if (this.entityDescriptor.canReadFromCache()) {
                Object entity = persistenceContext.getEntity(this.entityKey);
                if (entity != null) {
                    this.entityInstance = entity;
                    this.registerLoadingEntity(rowProcessingState, this.entityInstance);
                    this.initializeEntityInstance(this.entityInstance, rowProcessingState);
                } else {
                    this.initializeEntity(this.entityInstance, rowProcessingState);
                }
                this.entityInstanceForNotify = this.entityInstance;
            } else {
                this.initializeEntity(this.entityInstance, rowProcessingState);
                this.entityInstanceForNotify = this.entityInstance;
            }
            this.notifyResolutionListeners(this.entityInstanceForNotify);
            this.isInitialized = true;
        }
    }

    private void initializeEntity(Object toInitialize, RowProcessingState rowProcessingState) {
        if (!this.skipInitialization(toInitialize, rowProcessingState)) {
            assert (this.consistentInstance(toInitialize, rowProcessingState));
            this.initializeEntityInstance(toInitialize, rowProcessingState);
        }
    }

    protected boolean consistentInstance(Object toInitialize, RowProcessingState rowProcessingState) {
        PersistenceContext persistenceContextInternal = rowProcessingState.getSession().getPersistenceContextInternal();
        return !persistenceContextInternal.containsEntity(this.entityKey) || persistenceContextInternal.getEntity(this.entityKey) == toInitialize;
    }

    private void initializeEntityInstance(Object toInitialize, RowProcessingState rowProcessingState) {
        PersistentAttributeInterceptor persistentAttributeInterceptor;
        Object entityIdentifier = this.entityKey.getIdentifier();
        SharedSessionContractImplementor session = rowProcessingState.getSession();
        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
        if (EntityLoadingLogging.ENTITY_LOADING_LOGGER.isTraceEnabled()) {
            EntityLoadingLogging.ENTITY_LOADING_LOGGER.tracef("(%s) Beginning Initializer#initializeInstance process for entity %s", (Object)this.getSimpleConcreteImplName(), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), entityIdentifier));
        }
        this.resolvedEntityState = this.extractConcreteTypeStateValues(rowProcessingState);
        this.preLoad(rowProcessingState);
        if (ManagedTypeHelper.isPersistentAttributeInterceptable(toInitialize) && ((persistentAttributeInterceptor = ManagedTypeHelper.asPersistentAttributeInterceptable(toInitialize).$$_hibernate_getInterceptor()) == null || persistentAttributeInterceptor instanceof EnhancementAsProxyLazinessInterceptor)) {
            this.concreteDescriptor.getBytecodeEnhancementMetadata().injectInterceptor(toInitialize, entityIdentifier, session);
        }
        this.concreteDescriptor.setPropertyValues(toInitialize, this.resolvedEntityState);
        persistenceContext.addEntity(this.entityKey, toInitialize);
        this.registerPossibleUniqueKeyEntries(toInitialize, session);
        this.version = this.versionAssembler != null ? this.versionAssembler.assemble(rowProcessingState) : null;
        Object rowId = this.rowIdAssembler != null ? this.rowIdAssembler.assemble(rowProcessingState) : null;
        LockMode lockModeToAcquire = this.lockMode == LockMode.NONE ? LockMode.READ : this.lockMode;
        EntityEntry entityEntry = persistenceContext.addEntry(toInitialize, Status.LOADING, this.resolvedEntityState, rowId, this.entityKey.getIdentifier(), this.version, lockModeToAcquire, true, this.concreteDescriptor, false);
        this.registerNaturalIdResolution(persistenceContext, entityIdentifier);
        this.takeSnapshot(rowProcessingState, session, persistenceContext, entityEntry);
        this.concreteDescriptor.afterInitialize(toInitialize, session);
        if (EntityLoadingLogging.ENTITY_LOADING_LOGGER.isDebugEnabled()) {
            EntityLoadingLogging.ENTITY_LOADING_LOGGER.debugf("(%s) Done materializing entityInstance : %s", (Object)this.getSimpleConcreteImplName(), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), entityIdentifier));
        }
        assert (this.concreteDescriptor.getIdentifier(toInitialize, session) != null);
        StatisticsImplementor statistics = session.getFactory().getStatistics();
        if (statistics.isStatisticsEnabled() && !rowProcessingState.isQueryCacheHit()) {
            statistics.loadEntity(this.concreteDescriptor.getEntityName());
        }
    }

    protected void updateCaches(Object toInitialize, RowProcessingState rowProcessingState, SharedSessionContractImplementor session, PersistenceContext persistenceContext, Object entityIdentifier, Object version) {
        EntityDataAccess cacheAccess = this.concreteDescriptor.getCacheAccessStrategy();
        if (!rowProcessingState.isQueryCacheHit() && cacheAccess != null && session.getCacheMode().isPutEnabled()) {
            this.putInCache(toInitialize, session, persistenceContext, entityIdentifier, version, cacheAccess);
        }
    }

    protected void registerNaturalIdResolution(PersistenceContext persistenceContext, Object entityIdentifier) {
        if (this.entityDescriptor.getNaturalIdMapping() != null) {
            Object naturalId = this.entityDescriptor.getNaturalIdMapping().extractNaturalIdFromEntityState(this.resolvedEntityState);
            persistenceContext.getNaturalIdResolutions().cacheResolutionFromLoad(entityIdentifier, naturalId, this.entityDescriptor);
        }
    }

    protected void takeSnapshot(RowProcessingState rowProcessingState, SharedSessionContractImplementor session, PersistenceContext persistenceContext, EntityEntry entityEntry) {
        if (this.isReallyReadOnly(rowProcessingState, session)) {
            persistenceContext.setEntryStatus(entityEntry, Status.READ_ONLY);
        } else {
            AbstractEntityInitializer.deepCopy(this.concreteDescriptor, this.resolvedEntityState, this.resolvedEntityState);
            persistenceContext.setEntryStatus(entityEntry, Status.MANAGED);
        }
    }

    private boolean isReallyReadOnly(RowProcessingState rowProcessingState, SharedSessionContractImplementor session) {
        if (!this.concreteDescriptor.isMutable()) {
            return true;
        }
        LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(this.entityInstance);
        if (lazyInitializer != null) {
            return lazyInitializer.isReadOnly();
        }
        return this.isReadOnly(rowProcessingState, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putInCache(Object toInitialize, SharedSessionContractImplementor session, PersistenceContext persistenceContext, Object entityIdentifier, Object version, EntityDataAccess cacheAccess) {
        SessionFactoryImplementor factory = session.getFactory();
        if (EntityLoadingLogging.ENTITY_LOADING_LOGGER.isDebugEnabled()) {
            EntityLoadingLogging.ENTITY_LOADING_LOGGER.debugf("(%S) Adding entityInstance to second-level cache: %s", (Object)this.getSimpleConcreteImplName(), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), entityIdentifier));
        }
        CacheEntry cacheEntry = this.concreteDescriptor.buildCacheEntry(toInitialize, this.resolvedEntityState, version, session);
        Object cacheKey = cacheAccess.generateCacheKey(entityIdentifier, this.rootEntityDescriptor, factory, session.getTenantIdentifier());
        if (persistenceContext.wasInsertedDuringTransaction(this.concreteDescriptor, entityIdentifier)) {
            cacheAccess.update(session, cacheKey, this.concreteDescriptor.getCacheEntryStructure().structure(cacheEntry), version, version);
        } else {
            SessionEventListenerManager eventListenerManager = session.getEventListenerManager();
            try {
                eventListenerManager.cachePutStart();
                boolean put = cacheAccess.putFromLoad(session, cacheKey, this.concreteDescriptor.getCacheEntryStructure().structure(cacheEntry), version, false);
                StatisticsImplementor statistics = factory.getStatistics();
                if (put && statistics.isStatisticsEnabled()) {
                    statistics.entityCachePut(this.rootEntityDescriptor.getNavigableRole(), cacheAccess.getRegion().getName());
                }
            }
            finally {
                eventListenerManager.cachePutEnd();
            }
        }
    }

    protected void registerPossibleUniqueKeyEntries(Object toInitialize, SharedSessionContractImplementor session) {
        for (Type propertyType : this.concreteDescriptor.getPropertyTypes()) {
            AssociationType associationType;
            String ukName;
            if (!(propertyType instanceof AssociationType) || (ukName = (associationType = (AssociationType)propertyType).getLHSPropertyName()) == null) continue;
            int index = this.concreteDescriptor.findAttributeMapping(ukName).getStateArrayPosition();
            Type type = this.concreteDescriptor.getPropertyTypes()[index];
            if (this.resolvedEntityState[index] == null) continue;
            EntityUniqueKey euk = new EntityUniqueKey(this.concreteDescriptor.getRootEntityDescriptor().getEntityName(), ukName, this.resolvedEntityState[index], type, session.getFactory());
            session.getPersistenceContextInternal().addEntity(euk, toInitialize);
        }
    }

    protected Object[] extractConcreteTypeStateValues(RowProcessingState rowProcessingState) {
        Object[] values = new Object[this.concreteDescriptor.getNumberOfAttributeMappings()];
        DomainResultAssembler<?>[] concreteAssemblers = this.assemblers[this.concreteDescriptor.getSubclassId()];
        for (int i = 0; i < values.length; ++i) {
            DomainResultAssembler<?> assembler = concreteAssemblers[i];
            values[i] = assembler == null ? LazyPropertyInitializer.UNFETCHED_PROPERTY : assembler.assemble(rowProcessingState);
        }
        return values;
    }

    private void resolveState(RowProcessingState rowProcessingState) {
        for (DomainResultAssembler<?> assembler : this.assemblers[this.concreteDescriptor.getSubclassId()]) {
            if (assembler == null) continue;
            assembler.resolveState(rowProcessingState);
        }
    }

    protected boolean skipInitialization(Object toInitialize, RowProcessingState rowProcessingState) {
        PersistentAttributeInterceptor interceptor;
        if (!this.isOwningInitializer) {
            return true;
        }
        EntityEntry entry = rowProcessingState.getSession().getPersistenceContextInternal().getEntry(toInitialize);
        if (entry == null) {
            return false;
        }
        if (entry.getStatus().isDeletedOrGone()) {
            return true;
        }
        if (ManagedTypeHelper.isPersistentAttributeInterceptable(toInitialize) && (interceptor = ManagedTypeHelper.asPersistentAttributeInterceptable(toInitialize).$$_hibernate_getInterceptor()) instanceof EnhancementAsProxyLazinessInterceptor) {
            return entry.getStatus() == Status.LOADING;
        }
        if (entry.getStatus() != Status.LOADING) {
            return !this.isEntityReturn() || rowProcessingState.getJdbcValuesSourceProcessingState().getProcessingOptions().getEffectiveOptionalObject() != toInitialize;
        }
        return false;
    }

    private boolean isReadOnly(RowProcessingState rowProcessingState, SharedSessionContractImplementor persistenceContext) {
        Boolean readOnly = rowProcessingState.getQueryOptions().isReadOnly();
        return readOnly == null ? persistenceContext.isDefaultReadOnly() : readOnly.booleanValue();
    }

    protected void preLoad(RowProcessingState rowProcessingState) {
        SharedSessionContractImplementor session = rowProcessingState.getSession();
        if (session.isEventSource()) {
            PreLoadEvent preLoadEvent = rowProcessingState.getJdbcValuesSourceProcessingState().getPreLoadEvent();
            assert (preLoadEvent != null);
            preLoadEvent.reset();
            preLoadEvent.setEntity(this.entityInstance).setState(this.resolvedEntityState).setId(this.entityKey.getIdentifier()).setPersister(this.concreteDescriptor);
            session.getFactory().getFastSessionServices().eventListenerGroup_PRE_LOAD.fireEventOnEachListener(preLoadEvent, PreLoadEventListener::onPreLoad);
        }
    }

    @Override
    public boolean isEntityInitialized() {
        return this.isInitialized;
    }

    protected void setEntityInitialized(boolean isInitialized) {
        this.isInitialized = isInitialized;
    }

    protected void setEntityInstanceForNotify(Object entityInstanceForNotify) {
        this.entityInstanceForNotify = entityInstanceForNotify;
    }

    protected Object getEntityInstanceForNotify() {
        return this.entityInstanceForNotify;
    }

    protected void setResolvedEntityState(Object[] resolvedEntityState) {
        this.resolvedEntityState = resolvedEntityState;
    }

    protected Object[] getResolvedEntityState() {
        return this.resolvedEntityState;
    }

    @Override
    public EntityPersister getConcreteDescriptor() {
        return this.concreteDescriptor == null ? this.entityDescriptor : this.concreteDescriptor;
    }

    protected DomainResultAssembler<?> getVersionAssembler() {
        return this.versionAssembler;
    }

    protected DomainResultAssembler<Object> getRowIdAssembler() {
        return this.rowIdAssembler;
    }

    protected LockMode getLockMode() {
        return this.lockMode;
    }

    protected DomainResultAssembler<?>[][] getAssemblers() {
        return this.assemblers;
    }

    @Override
    public void finishUpRow(RowProcessingState rowProcessingState) {
        SharedSessionContractImplementor session = rowProcessingState.getSession();
        if (this.resolvedEntityState != null) {
            this.updateCaches(this.entityInstanceForNotify, rowProcessingState, session, session.getPersistenceContext(), this.entityKey.getIdentifier(), this.version);
        }
        this.isOwningInitializer = false;
        this.concreteDescriptor = null;
        this.entityKey = null;
        this.version = null;
        this.entityInstance = null;
        this.entityInstanceForNotify = null;
        this.missing = false;
        this.resolvedEntityState = null;
        this.isInitialized = false;
        this.clearResolutionListeners();
    }
}

