/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import jakarta.persistence.Enumerated;
import jakarta.persistence.MapKeyEnumerated;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.annotations.Nationalized;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.converter.internal.NamedEnumValueConverter;
import org.hibernate.type.descriptor.converter.internal.OrdinalEnumValueConverter;
import org.hibernate.type.descriptor.converter.spi.BasicValueConverter;
import org.hibernate.type.descriptor.converter.spi.EnumValueConverter;
import org.hibernate.type.descriptor.java.EnumJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.type.spi.TypeConfigurationAware;
import org.hibernate.usertype.DynamicParameterizedType;
import org.hibernate.usertype.EnhancedUserType;
import org.hibernate.usertype.LoggableUserType;
import org.jboss.logging.Logger;

@Deprecated(since="6.2", forRemoval=true)
public class EnumType<T extends Enum<T>>
implements EnhancedUserType<T>,
DynamicParameterizedType,
LoggableUserType,
TypeConfigurationAware,
Serializable {
    private static final Logger LOG = CoreLogging.logger(EnumType.class);
    public static final String ENUM = "enumClass";
    public static final String NAMED = "useNamed";
    public static final String TYPE = "type";
    private Class<T> enumClass;
    private EnumValueConverter<T, Object> enumValueConverter;
    private JdbcType jdbcType;
    private ValueExtractor<Object> jdbcValueExtractor;
    private ValueBinder<Object> jdbcValueBinder;
    private TypeConfiguration typeConfiguration;

    public EnumType() {
    }

    public EnumType(Class<T> enumClass, EnumValueConverter<T, ?> enumValueConverter, TypeConfiguration typeConfiguration) {
        this.enumClass = enumClass;
        this.typeConfiguration = typeConfiguration;
        this.enumValueConverter = enumValueConverter;
        this.jdbcType = typeConfiguration.getJdbcTypeRegistry().getDescriptor(enumValueConverter.getJdbcTypeCode());
        this.jdbcValueExtractor = this.jdbcType.getExtractor(enumValueConverter.getRelationalJavaType());
        this.jdbcValueBinder = this.jdbcType.getBinder(enumValueConverter.getRelationalJavaType());
    }

    public EnumValueConverter<T, ?> getEnumValueConverter() {
        return this.enumValueConverter;
    }

    @Override
    public JdbcType getJdbcType(TypeConfiguration typeConfiguration) {
        return this.jdbcType;
    }

    @Override
    public BasicValueConverter<T, Object> getValueConverter() {
        return this.enumValueConverter;
    }

    @Override
    public void setParameterValues(Properties parameters) {
        DynamicParameterizedType.ParameterType reader = (DynamicParameterizedType.ParameterType)parameters.get("org.hibernate.type.ParameterType");
        if (reader != null) {
            this.configureUsingReader(reader);
        } else {
            this.configureUsingParameters(parameters);
        }
        this.jdbcValueExtractor = this.jdbcType.getExtractor(this.enumValueConverter.getRelationalJavaType());
        this.jdbcValueBinder = this.jdbcType.getBinder(this.enumValueConverter.getRelationalJavaType());
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Using %s-based conversion for Enum %s", (Object)(this.isOrdinal() ? "ORDINAL" : "NAMED"), (Object)this.enumClass.getName());
        }
    }

    private void configureUsingParameters(Properties parameters) {
        String enumClassName = (String)parameters.get(ENUM);
        try {
            this.enumClass = ReflectHelper.classForName(enumClassName, this.getClass()).asSubclass(Enum.class);
        }
        catch (ClassNotFoundException exception) {
            throw new HibernateException("Enum class not found: " + enumClassName, exception);
        }
        this.enumValueConverter = this.interpretParameters(parameters);
        this.jdbcType = this.typeConfiguration.getJdbcTypeRegistry().getDescriptor(this.enumValueConverter.getJdbcTypeCode());
    }

    private void configureUsingReader(DynamicParameterizedType.ParameterType reader) {
        this.enumClass = reader.getReturnedClass().asSubclass(Enum.class);
        jakarta.persistence.EnumType enumType = this.getEnumType(reader);
        JavaType descriptor = this.typeConfiguration.getJavaTypeRegistry().getDescriptor(this.enumClass);
        EnumJavaType enumJavaType = (EnumJavaType)descriptor;
        LocalJdbcTypeIndicators indicators = new LocalJdbcTypeIndicators(enumType, reader);
        JavaType<Number> relationalJavaType = this.resolveRelationalJavaType(indicators, enumJavaType);
        this.jdbcType = relationalJavaType.getRecommendedJdbcType(indicators);
        this.enumValueConverter = EnumType.isOrdinal(enumType) ? new OrdinalEnumValueConverter(enumJavaType, this.jdbcType, relationalJavaType) : new NamedEnumValueConverter(enumJavaType, this.jdbcType, relationalJavaType);
    }

    private static boolean isOrdinal(jakarta.persistence.EnumType enumType) {
        if (enumType == null) {
            return true;
        }
        switch (enumType) {
            case ORDINAL: {
                return true;
            }
            case STRING: {
                return false;
            }
        }
        throw new AssertionFailure("Unknown EnumType: " + enumType);
    }

    private JavaType<? extends Number> resolveRelationalJavaType(LocalJdbcTypeIndicators indicators, EnumJavaType<?> enumJavaType) {
        return enumJavaType.getRecommendedJdbcType(indicators).getJdbcRecommendedJavaTypeMapping(null, null, this.typeConfiguration);
    }

    private jakarta.persistence.EnumType getEnumType(DynamicParameterizedType.ParameterType reader) {
        MapKeyEnumerated enumAnn;
        if (reader == null) {
            return null;
        }
        if (reader.isPrimaryKey() && (enumAnn = this.getAnnotation(reader.getAnnotationsMethod(), MapKeyEnumerated.class)) != null) {
            return enumAnn.value();
        }
        enumAnn = this.getAnnotation(reader.getAnnotationsMethod(), Enumerated.class);
        if (enumAnn != null) {
            return enumAnn.value();
        }
        return null;
    }

    private <A extends Annotation> A getAnnotation(Annotation[] annotations, Class<A> annotationType) {
        for (Annotation annotation : annotations) {
            if (!annotationType.isInstance(annotation)) continue;
            return (A)annotation;
        }
        return null;
    }

    private EnumValueConverter<T, ?> interpretParameters(Properties parameters) {
        JavaType javaType = this.typeConfiguration.getJavaTypeRegistry().getDescriptor(this.enumClass);
        EnumJavaType enumJavaType = (EnumJavaType)javaType;
        assert (parameters.get("org.hibernate.type.ParameterType") == null);
        LocalJdbcTypeIndicators localIndicators = new LocalJdbcTypeIndicators(jakarta.persistence.EnumType.ORDINAL, -1L, null);
        if (parameters.containsKey(NAMED)) {
            boolean useNamed = ConfigurationHelper.getBoolean(NAMED, parameters);
            return this.getConverter(enumJavaType, localIndicators, useNamed);
        }
        if (parameters.containsKey(TYPE)) {
            int type = Integer.decode((String)parameters.get(TYPE));
            return this.getConverterForType(enumJavaType, localIndicators, type);
        }
        JavaType<Number> relationalJavaType = this.resolveRelationalJavaType(localIndicators, enumJavaType);
        return new OrdinalEnumValueConverter(enumJavaType, relationalJavaType.getRecommendedJdbcType(localIndicators), relationalJavaType);
    }

    private JavaType<Object> namedJavaType(JdbcTypeIndicators stdIndicators) {
        return this.typeConfiguration.getJavaTypeRegistry().getDescriptor((Type)((Object)(stdIndicators.getColumnLength() == 1L ? Character.class : String.class)));
    }

    private EnumValueConverter<T, ?> getConverter(EnumJavaType<T> enumJavaType, LocalJdbcTypeIndicators localIndicators, boolean useNamed) {
        if (useNamed) {
            JavaType<Object> relationalJavaType = this.namedJavaType(localIndicators);
            return new NamedEnumValueConverter<T>(enumJavaType, relationalJavaType.getRecommendedJdbcType(localIndicators), relationalJavaType);
        }
        JavaType<Number> relationalJavaType = this.resolveRelationalJavaType(localIndicators, enumJavaType);
        return new OrdinalEnumValueConverter<T, Number>(enumJavaType, relationalJavaType.getRecommendedJdbcType(localIndicators), relationalJavaType);
    }

    private EnumValueConverter<T, ?> getConverterForType(EnumJavaType<T> enumJavaType, LocalJdbcTypeIndicators localIndicators, int type) {
        if (this.isNumericType(type)) {
            JavaType<Number> relationalJavaType = this.resolveRelationalJavaType(localIndicators, enumJavaType);
            return new OrdinalEnumValueConverter<T, Number>(enumJavaType, relationalJavaType.getRecommendedJdbcType(localIndicators), relationalJavaType);
        }
        if (this.isCharacterType(type)) {
            JavaType<Object> relationalJavaType = this.namedJavaType(localIndicators);
            return new NamedEnumValueConverter<T>(enumJavaType, relationalJavaType.getRecommendedJdbcType(localIndicators), relationalJavaType);
        }
        throw new HibernateException(String.format("Passed JDBC type code [%s] not recognized as numeric nor character", type));
    }

    private boolean isCharacterType(int jdbcTypeCode) {
        switch (jdbcTypeCode) {
            case -1: 
            case 1: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    private boolean isNumericType(int jdbcTypeCode) {
        switch (jdbcTypeCode) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getSqlType() {
        this.verifyConfigured();
        return this.enumValueConverter.getJdbcTypeCode();
    }

    @Override
    public Class<T> returnedClass() {
        return this.enumClass;
    }

    @Override
    public boolean equals(T x, T y) throws HibernateException {
        return x == y;
    }

    @Override
    public int hashCode(T x) throws HibernateException {
        return x == null ? 0 : ((Enum)x).hashCode();
    }

    @Override
    public T nullSafeGet(ResultSet rs, int position, SharedSessionContractImplementor session, Object owner) throws SQLException {
        this.verifyConfigured();
        return (T)((Enum)this.enumValueConverter.toDomainValue(this.jdbcValueExtractor.extract(rs, position, (WrapperOptions)session)));
    }

    private void verifyConfigured() {
        if (this.enumValueConverter == null || this.jdbcValueBinder == null || this.jdbcValueExtractor == null) {
            throw new AssertionFailure("EnumType (" + this.enumClass.getName() + ") not properly, fully configured");
        }
    }

    @Override
    public void nullSafeSet(PreparedStatement st, T value, int index, SharedSessionContractImplementor session) throws HibernateException, SQLException {
        this.verifyConfigured();
        this.jdbcValueBinder.bind(st, this.enumValueConverter.toRelationalValue(value), index, (WrapperOptions)session);
    }

    @Override
    public T deepCopy(T value) throws HibernateException {
        return value;
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public Serializable disassemble(T value) throws HibernateException {
        return (Serializable)this.enumValueConverter.toRelationalValue(value);
    }

    @Override
    public T assemble(Serializable cached, Object owner) throws HibernateException {
        return (T)((Enum)this.enumValueConverter.toDomainValue(cached));
    }

    @Override
    public T replace(T original, T target, Object owner) throws HibernateException {
        return original;
    }

    @Override
    public TypeConfiguration getTypeConfiguration() {
        return this.typeConfiguration;
    }

    @Override
    public void setTypeConfiguration(TypeConfiguration typeConfiguration) {
        this.typeConfiguration = typeConfiguration;
    }

    @Override
    public String toSqlLiteral(T value) {
        this.verifyConfigured();
        return this.enumValueConverter.toSqlLiteral(value);
    }

    @Override
    public String toString(T value) {
        this.verifyConfigured();
        return this.enumValueConverter.getRelationalJavaType().toString(this.enumValueConverter.toRelationalValue(value));
    }

    @Override
    public T fromStringValue(CharSequence sequence) {
        this.verifyConfigured();
        return (T)((Enum)this.enumValueConverter.toDomainValue(this.enumValueConverter.getRelationalJavaType().fromString(sequence)));
    }

    @Override
    public String toLoggableString(Object value, SessionFactoryImplementor factory) {
        this.verifyConfigured();
        return ((EnumJavaType)this.enumValueConverter.getDomainJavaType()).toString((Enum)value);
    }

    public boolean isOrdinal() {
        this.verifyConfigured();
        return this.enumValueConverter instanceof OrdinalEnumValueConverter;
    }

    private class LocalJdbcTypeIndicators
    implements JdbcTypeIndicators {
        private final jakarta.persistence.EnumType enumType;
        private final Long columnLength;
        private final DynamicParameterizedType.ParameterType reader;

        private LocalJdbcTypeIndicators(jakarta.persistence.EnumType enumType2, DynamicParameterizedType.ParameterType reader) {
            this(enumType2, reader.getColumnLengths()[0], reader);
        }

        private LocalJdbcTypeIndicators(jakarta.persistence.EnumType enumType2, Long columnLength, DynamicParameterizedType.ParameterType reader) {
            this.enumType = enumType2;
            this.columnLength = columnLength;
            this.reader = reader;
        }

        @Override
        public TypeConfiguration getTypeConfiguration() {
            return EnumType.this.typeConfiguration;
        }

        @Override
        public jakarta.persistence.EnumType getEnumeratedType() {
            if (this.enumType != null) {
                return this.enumType;
            }
            return EnumType.this.typeConfiguration.getCurrentBaseSqlTypeIndicators().getEnumeratedType();
        }

        @Override
        public boolean isNationalized() {
            return this.isNationalized(this.reader);
        }

        private boolean isNationalized(DynamicParameterizedType.ParameterType reader) {
            if (EnumType.this.typeConfiguration.getCurrentBaseSqlTypeIndicators().isNationalized()) {
                return true;
            }
            if (reader != null) {
                for (Annotation annotation : reader.getAnnotationsMethod()) {
                    if (!(annotation instanceof Nationalized)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public long getColumnLength() {
            return this.columnLength == null ? -1L : this.columnLength;
        }

        @Override
        public Dialect getDialect() {
            return EnumType.this.typeConfiguration.getCurrentBaseSqlTypeIndicators().getDialect();
        }
    }
}

