/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.entity;

import org.hibernate.Incubating;

@Incubating
public final class EntityNameUse {
    public static final EntityNameUse PROJECTION = new EntityNameUse(UseKind.PROJECTION, true);
    public static final EntityNameUse EXPRESSION = new EntityNameUse(UseKind.EXPRESSION, true);
    public static final EntityNameUse TREAT = new EntityNameUse(UseKind.TREAT, true);
    public static final EntityNameUse OPTIONAL_TREAT = new EntityNameUse(UseKind.TREAT, false);
    public static final EntityNameUse FILTER = new EntityNameUse(UseKind.FILTER, true);
    private final UseKind kind;
    private final boolean requiresRestriction;

    private EntityNameUse(UseKind kind, boolean requiresRestriction) {
        this.kind = kind;
        this.requiresRestriction = requiresRestriction;
    }

    private static EntityNameUse get(UseKind kind) {
        switch (kind) {
            case PROJECTION: {
                return PROJECTION;
            }
            case EXPRESSION: {
                return EXPRESSION;
            }
            case TREAT: {
                return TREAT;
            }
            case FILTER: {
                return FILTER;
            }
        }
        throw new IllegalArgumentException("Unknown kind: " + kind);
    }

    public UseKind getKind() {
        return this.kind;
    }

    public boolean requiresRestriction() {
        return this.requiresRestriction;
    }

    public EntityNameUse stronger(EntityNameUse other) {
        return other == null || this.kind.isStrongerThan(other.kind) ? this : EntityNameUse.get(other.kind);
    }

    public EntityNameUse weaker(EntityNameUse other) {
        return other == null || this.kind.isWeakerThan(other.kind) ? this : EntityNameUse.get(other.kind);
    }

    public static enum UseKind {
        PROJECTION,
        EXPRESSION,
        TREAT,
        FILTER;


        public boolean isStrongerThan(UseKind other) {
            return this.ordinal() > other.ordinal();
        }

        public UseKind stronger(UseKind other) {
            return other == null || this.isStrongerThan(other) ? this : other;
        }

        public boolean isWeakerThan(UseKind other) {
            return this.ordinal() < other.ordinal();
        }

        public UseKind weaker(UseKind other) {
            return other == null || this.isWeakerThan(other) ? this : other;
        }
    }
}

