/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.sql.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.query.sqm.sql.internal.SqlAstProcessingStateImpl;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlAstProcessingState;
import org.hibernate.sql.ast.spi.SqlAstQueryPartProcessingState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectClause;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.spi.TypeConfiguration;

public class SqlAstQueryPartProcessingStateImpl
extends SqlAstProcessingStateImpl
implements SqlAstQueryPartProcessingState {
    private final QueryPart queryPart;
    private final Map<TableGroup, Map<EntityDomainType<?>, Boolean>> treatRegistrations = new HashMap();
    private final boolean deduplicateSelectionItems;
    private FetchParent nestingFetchParent;
    private Map<?, ?> sqlSelectionMap;

    public SqlAstQueryPartProcessingStateImpl(QueryPart queryPart, SqlAstProcessingState parent, SqlAstCreationState creationState, Supplier<Clause> currentClauseAccess, boolean deduplicateSelectionItems) {
        super(parent, creationState, currentClauseAccess);
        this.queryPart = queryPart;
        this.deduplicateSelectionItems = deduplicateSelectionItems;
    }

    public SqlAstQueryPartProcessingStateImpl(QueryPart queryPart, SqlAstProcessingState parent, SqlAstCreationState creationState, Function<SqlExpressionResolver, SqlExpressionResolver> expressionResolverDecorator, Supplier<Clause> currentClauseAccess, boolean deduplicateSelectionItems) {
        super(parent, creationState, expressionResolverDecorator, currentClauseAccess);
        this.queryPart = queryPart;
        this.deduplicateSelectionItems = deduplicateSelectionItems;
    }

    public FetchParent getNestingFetchParent() {
        return this.nestingFetchParent;
    }

    public void setNestingFetchParent(FetchParent nestedParent) {
        this.nestingFetchParent = nestedParent;
    }

    @Override
    public QueryPart getInflightQueryPart() {
        return this.queryPart;
    }

    @Override
    public void registerTreat(TableGroup tableGroup, EntityDomainType<?> treatType) {
        this.treatRegistrations.computeIfAbsent(tableGroup, tg -> new HashMap()).put(treatType, Boolean.FALSE);
    }

    @Override
    public void registerTreatUsage(TableGroup tableGroup, EntityDomainType<?> treatType) {
        Map<EntityDomainType<?>, Boolean> treatUses = this.treatRegistrations.get(tableGroup);
        if (treatUses == null) {
            SqlAstProcessingState parentState = this.getParentState();
            if (parentState instanceof SqlAstQueryPartProcessingState) {
                ((SqlAstQueryPartProcessingState)parentState).registerTreatUsage(tableGroup, treatType);
            }
        } else {
            treatUses.put(treatType, Boolean.TRUE);
        }
    }

    @Override
    public Map<TableGroup, Map<EntityDomainType<?>, Boolean>> getTreatRegistrations() {
        return this.treatRegistrations;
    }

    @Override
    public SqlSelection resolveSqlSelection(Expression expression, JavaType<?> javaType, FetchParent fetchParent, TypeConfiguration typeConfiguration) {
        SqlSelection sqlSelection;
        HashMap<Expression, SqlSelection> selectionMap;
        if (this.nestingFetchParent != null) {
            if (!(expression instanceof ColumnReference)) {
                throw new IllegalArgumentException("Illegal expression passed for nested fetching: " + expression);
            }
            String selectableName = ((ColumnReference)expression).getSelectableName();
            return expression.createSqlSelection(-1, this.nestingFetchParent.getReferencedMappingType().getSelectableIndex(selectableName), javaType, typeConfiguration);
        }
        if (this.deduplicateSelectionItems) {
            SqlSelection existing;
            if (this.sqlSelectionMap == null) {
                this.sqlSelectionMap = new HashMap();
                existing = null;
            } else {
                existing = (SqlSelection)this.sqlSelectionMap.get(expression);
            }
            if (existing != null) {
                return existing;
            }
            selectionMap = this.sqlSelectionMap;
        } else if (fetchParent != null) {
            Map<?, ?> fetchParentSqlSelectionMap;
            FetchParent root = fetchParent.getRoot();
            if (this.sqlSelectionMap == null) {
                fetchParentSqlSelectionMap = new HashMap();
                this.sqlSelectionMap = fetchParentSqlSelectionMap;
                selectionMap = new HashMap<Expression, SqlSelection>();
                fetchParentSqlSelectionMap.put(root, selectionMap);
            } else {
                fetchParentSqlSelectionMap = this.sqlSelectionMap;
                HashMap<Expression, SqlSelection> map = (HashMap<Expression, SqlSelection>)fetchParentSqlSelectionMap.get(root);
                if (map == null) {
                    selectionMap = new HashMap();
                    fetchParentSqlSelectionMap.put(root, selectionMap);
                } else {
                    selectionMap = map;
                }
            }
            sqlSelection = (SqlSelection)selectionMap.get(expression);
            if (sqlSelection != null) {
                return sqlSelection;
            }
        } else {
            selectionMap = null;
        }
        SelectClause selectClause = ((QuerySpec)this.queryPart).getSelectClause();
        int valuesArrayPosition = selectClause.getSqlSelections().size();
        sqlSelection = this.isTopLevel() ? expression.createDomainResultSqlSelection(valuesArrayPosition + 1, valuesArrayPosition, javaType, typeConfiguration) : expression.createSqlSelection(valuesArrayPosition + 1, valuesArrayPosition, javaType, typeConfiguration);
        selectClause.addSqlSelection(sqlSelection);
        if (selectionMap != null) {
            selectionMap.put(expression, sqlSelection);
        }
        return sqlSelection;
    }
}

