/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import jakarta.persistence.TemporalType;
import java.lang.reflect.Type;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.hibernate.PessimisticLockException;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.cfg.Environment;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.InnoDBStorageEngine;
import org.hibernate.dialect.MyISAMStorageEngine;
import org.hibernate.dialect.MySQLCastingJsonJdbcType;
import org.hibernate.dialect.MySQLServerConfiguration;
import org.hibernate.dialect.MySQLSqlAstTranslator;
import org.hibernate.dialect.MySQLStorageEngine;
import org.hibernate.dialect.Replacer;
import org.hibernate.dialect.RowLockStrategy;
import org.hibernate.dialect.SelectItemReferenceStrategy;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.hint.IndexQueryHintHandler;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.identity.MySQLIdentityColumnSupport;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.LimitLimitHandler;
import org.hibernate.dialect.sequence.NoSequenceSupport;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.dialect.temptable.TemporaryTable;
import org.hibernate.dialect.temptable.TemporaryTableKind;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.env.spi.IdentifierCaseStrategy;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelper;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelperBuilder;
import org.hibernate.engine.jdbc.env.spi.NameQualifierSupport;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.exception.LockTimeoutException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.exception.spi.TemplatedViolatedConstraintNameExtractor;
import org.hibernate.exception.spi.ViolatedConstraintNameExtractor;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.query.sqm.CastType;
import org.hibernate.query.sqm.IntervalType;
import org.hibernate.query.sqm.NullOrdering;
import org.hibernate.query.sqm.TemporalUnit;
import org.hibernate.query.sqm.function.SqmFunctionRegistry;
import org.hibernate.query.sqm.mutation.internal.temptable.AfterUseAction;
import org.hibernate.query.sqm.mutation.internal.temptable.BeforeUseAction;
import org.hibernate.query.sqm.mutation.internal.temptable.LocalTemporaryTableInsertStrategy;
import org.hibernate.query.sqm.mutation.internal.temptable.LocalTemporaryTableMutationStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableInsertStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.NullType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.DateTimeUtils;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.NullJdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;
import org.hibernate.type.descriptor.sql.internal.CapacityDependentDdlType;
import org.hibernate.type.descriptor.sql.internal.DdlTypeImpl;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;

public class MySQLDialect
extends Dialect {
    private static final DatabaseVersion MINIMUM_VERSION = DatabaseVersion.make(5, 7);
    private final MySQLStorageEngine storageEngine = this.createStorageEngine();
    private final Dialect.SizeStrategy sizeStrategy = new Dialect.SizeStrategyImpl(){

        @Override
        public Size resolveSize(JdbcType jdbcType, JavaType<?> javaType, Integer precision, Integer scale, Long length) {
            switch (jdbcType.getDdlTypeCode()) {
                case -7: {
                    if (length == null) break;
                    return Size.length(Math.min(Math.max(length, 1L), 64L));
                }
            }
            return super.resolveSize(jdbcType, javaType, precision, scale, length);
        }
    };
    private final int maxVarcharLength;
    private final int maxVarbinaryLength;
    private final boolean noBackslashEscapesEnabled;
    private static final ViolatedConstraintNameExtractor EXTRACTOR = new TemplatedViolatedConstraintNameExtractor(sqle -> {
        String sqlState = JdbcExceptionHelper.extractSqlState(sqle);
        if (sqlState != null) {
            switch (Integer.parseInt(sqlState)) {
                case 23000: {
                    return TemplatedViolatedConstraintNameExtractor.extractUsingTemplate(" for key '", "'", sqle.getMessage());
                }
            }
        }
        return null;
    });

    public MySQLDialect() {
        this(MINIMUM_VERSION);
    }

    public MySQLDialect(DatabaseVersion version) {
        this(version, 4);
    }

    public MySQLDialect(DatabaseVersion version, int bytesPerCharacter) {
        this(version, bytesPerCharacter, false);
    }

    public MySQLDialect(DatabaseVersion version, MySQLServerConfiguration serverConfiguration) {
        this(version, serverConfiguration.getBytesPerCharacter(), serverConfiguration.isNoBackslashEscapesEnabled());
    }

    public MySQLDialect(DatabaseVersion version, int bytesPerCharacter, boolean noBackslashEscapes) {
        super(version);
        this.maxVarcharLength = MySQLDialect.maxVarcharLength(this.getMySQLVersion(), bytesPerCharacter);
        this.maxVarbinaryLength = MySQLDialect.maxVarbinaryLength(this.getMySQLVersion());
        this.noBackslashEscapesEnabled = noBackslashEscapes;
    }

    public MySQLDialect(DialectResolutionInfo info) {
        this(MySQLDialect.createVersion(info), MySQLServerConfiguration.fromDatabaseMetadata(info.getDatabaseMetadata()));
        this.registerKeywords(info);
    }

    protected static DatabaseVersion createVersion(DialectResolutionInfo info) {
        String[] components;
        String versionString = info.getDatabaseVersion();
        if (versionString != null && (components = versionString.split("\\.")).length >= 3) {
            try {
                int majorVersion = Integer.parseInt(components[0]);
                int minorVersion = Integer.parseInt(components[1]);
                int patchLevel = Integer.parseInt(components[2]);
                return DatabaseVersion.make(majorVersion, minorVersion, patchLevel);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return info.makeCopy();
    }

    @Override
    protected DatabaseVersion getMinimumSupportedVersion() {
        return MINIMUM_VERSION;
    }

    @Override
    protected void initDefaultProperties() {
        super.initDefaultProperties();
        this.getDefaultProperties().setProperty("hibernate.max_fetch_depth", "2");
    }

    private MySQLStorageEngine createStorageEngine() {
        String storageEngine = Environment.getProperties().getProperty("hibernate.dialect.storage_engine");
        if (storageEngine == null) {
            storageEngine = System.getProperty("hibernate.dialect.storage_engine");
        }
        if (storageEngine == null) {
            return this.getDefaultMySQLStorageEngine();
        }
        if ("innodb".equalsIgnoreCase(storageEngine)) {
            return InnoDBStorageEngine.INSTANCE;
        }
        if ("myisam".equalsIgnoreCase(storageEngine)) {
            return MyISAMStorageEngine.INSTANCE;
        }
        throw new UnsupportedOperationException("The " + storageEngine + " storage engine is not supported");
    }

    @Override
    protected String columnType(int sqlTypeCode) {
        switch (sqlTypeCode) {
            case 16: {
                return "bit";
            }
            case 93: {
                return "datetime($p)";
            }
            case 2014: {
                return "timestamp($p)";
            }
            case 2: {
                return this.columnType(3);
            }
            case 2004: {
                return "longblob";
            }
            case 2005: 
            case 2011: {
                return "longtext";
            }
        }
        return super.columnType(sqlTypeCode);
    }

    @Override
    public boolean useMaterializedLobWhenCapacityExceeded() {
        return false;
    }

    @Override
    protected String castType(int sqlTypeCode) {
        switch (sqlTypeCode) {
            case -7: 
            case 16: {
                return "unsigned";
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return "signed";
            }
            case 6: 
            case 7: 
            case 8: {
                return "decimal($p,$s)";
            }
            case -15: 
            case -9: 
            case 1: 
            case 12: 
            case 4001: 
            case 4002: {
                return "char";
            }
            case -3: 
            case -2: 
            case 4003: {
                return "binary";
            }
        }
        return super.castType(sqlTypeCode);
    }

    @Override
    protected void registerColumnTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.registerColumnTypes(typeContributions, serviceRegistry);
        DdlTypeRegistry ddlTypeRegistry = typeContributions.getTypeConfiguration().getDdlTypeRegistry();
        ddlTypeRegistry.addDescriptor(new DdlTypeImpl(3001, "json", this));
        ddlTypeRegistry.addDescriptor(new DdlTypeImpl(3200, "geometry", this));
        int maxTinyLobLen = 255;
        int maxLobLen = 65535;
        int maxMediumLobLen = 0xFFFFFF;
        CapacityDependentDdlType.Builder varcharBuilder = CapacityDependentDdlType.builder(12, CapacityDependentDdlType.LobKind.BIGGEST_LOB, this.columnType(2005), "char", (Dialect)this).withTypeCapacity(this.getMaxVarcharLength(), "varchar($l)").withTypeCapacity(0xFFFFFFL, "mediumtext");
        if (this.getMaxVarcharLength() < 65535) {
            varcharBuilder.withTypeCapacity(65535L, "text");
        }
        ddlTypeRegistry.addDescriptor(varcharBuilder.build());
        CapacityDependentDdlType.Builder nvarcharBuilder = CapacityDependentDdlType.builder(-9, CapacityDependentDdlType.LobKind.BIGGEST_LOB, this.columnType(2011), "char", (Dialect)this).withTypeCapacity(this.getMaxVarcharLength(), "varchar($l)").withTypeCapacity(0xFFFFFFL, "mediumtext");
        if (this.getMaxVarcharLength() < 65535) {
            nvarcharBuilder.withTypeCapacity(65535L, "text");
        }
        ddlTypeRegistry.addDescriptor(nvarcharBuilder.build());
        CapacityDependentDdlType.Builder varbinaryBuilder = CapacityDependentDdlType.builder(-3, CapacityDependentDdlType.LobKind.BIGGEST_LOB, this.columnType(2004), "binary", (Dialect)this).withTypeCapacity(this.getMaxVarbinaryLength(), "varbinary($l)").withTypeCapacity(0xFFFFFFL, "mediumblob");
        if (this.getMaxVarbinaryLength() < 65535) {
            varbinaryBuilder.withTypeCapacity(65535L, "blob");
        }
        ddlTypeRegistry.addDescriptor(varbinaryBuilder.build());
        ddlTypeRegistry.addDescriptor(new DdlTypeImpl(4003, this.columnType(2004), "binary", this));
        ddlTypeRegistry.addDescriptor(new DdlTypeImpl(4001, this.columnType(2005), "char", this));
        ddlTypeRegistry.addDescriptor(new DdlTypeImpl(4002, this.columnType(2005), "char", this));
        ddlTypeRegistry.addDescriptor(CapacityDependentDdlType.builder(2004, this.columnType(2004), "binary", (Dialect)this).withTypeCapacity(255L, "tinyblob").withTypeCapacity(0xFFFFFFL, "mediumblob").withTypeCapacity(65535L, "blob").build());
        ddlTypeRegistry.addDescriptor(CapacityDependentDdlType.builder(2005, this.columnType(2005), "char", (Dialect)this).withTypeCapacity(255L, "tinytext").withTypeCapacity(0xFFFFFFL, "mediumtext").withTypeCapacity(65535L, "text").build());
        ddlTypeRegistry.addDescriptor(CapacityDependentDdlType.builder(2011, this.columnType(2011), "char", (Dialect)this).withTypeCapacity(255L, "tinytext").withTypeCapacity(0xFFFFFFL, "mediumtext").withTypeCapacity(65535L, "text").build());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    protected static int getCharacterSetBytesPerCharacter(DatabaseMetaData databaseMetaData) {
        if (databaseMetaData == null) return 4;
        try (Statement s = databaseMetaData.getConnection().createStatement();){
            ResultSet rs = s.executeQuery("SELECT @@character_set_database");
            if (!rs.next()) return 4;
            String characterSet = rs.getString(1);
            int collationIndex = characterSet.indexOf(95);
            switch (collationIndex == -1 ? characterSet : characterSet.substring(0, collationIndex)) {
                case "utf16": 
                case "utf16le": 
                case "utf32": 
                case "utf8mb4": 
                case "gb18030": {
                    int n = 4;
                    return n;
                }
                case "utf8": 
                case "utf8mb3": 
                case "eucjpms": 
                case "ujis": {
                    int n = 3;
                    return n;
                }
                case "ucs2": 
                case "cp932": 
                case "big5": 
                case "euckr": 
                case "gb2312": 
                case "gbk": 
                case "sjis": {
                    int n = 2;
                    return n;
                }
            }
            int n = 1;
            return n;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return 4;
    }

    private static int maxVarbinaryLength(DatabaseVersion version) {
        return 65535;
    }

    private static int maxVarcharLength(DatabaseVersion version, int bytesPerCharacter) {
        switch (bytesPerCharacter) {
            case 1: {
                return 65535;
            }
            case 2: {
                return Short.MAX_VALUE;
            }
            case 3: {
                return 21844;
            }
        }
        return 16383;
    }

    @Override
    public int getMaxVarcharLength() {
        return this.maxVarcharLength;
    }

    @Override
    public int getMaxVarbinaryLength() {
        return this.maxVarbinaryLength;
    }

    public boolean isNoBackslashEscapesEnabled() {
        return this.noBackslashEscapesEnabled;
    }

    @Override
    public String getNullColumnString(String columnType) {
        if (columnType.regionMatches(true, 0, "timestamp", 0, "timestamp".length())) {
            return " null";
        }
        return super.getNullColumnString(columnType);
    }

    public DatabaseVersion getMySQLVersion() {
        return super.getVersion();
    }

    @Override
    public Dialect.SizeStrategy getSizeStrategy() {
        return this.sizeStrategy;
    }

    @Override
    public long getDefaultLobLength() {
        return 0xFFFFFFL;
    }

    @Override
    public JdbcType resolveSqlTypeDescriptor(String columnTypeName, int jdbcTypeCode, int precision, int scale, JdbcTypeRegistry jdbcTypeRegistry) {
        switch (jdbcTypeCode) {
            case -7: {
                return jdbcTypeRegistry.getDescriptor(16);
            }
            case -2: {
                if (!"GEOMETRY".equals(columnTypeName)) break;
                jdbcTypeCode = 3200;
            }
        }
        return super.resolveSqlTypeDescriptor(columnTypeName, jdbcTypeCode, precision, scale, jdbcTypeRegistry);
    }

    @Override
    public int getPreferredSqlTypeCodeForBoolean() {
        return -7;
    }

    @Override
    public void initializeFunctionRegistry(FunctionContributions functionContributions) {
        super.initializeFunctionRegistry(functionContributions);
        CommonFunctionFactory functionFactory = new CommonFunctionFactory(functionContributions);
        functionFactory.soundex();
        functionFactory.radians();
        functionFactory.degrees();
        functionFactory.cot();
        functionFactory.log();
        functionFactory.log2();
        functionFactory.log10();
        functionFactory.trim2();
        functionFactory.octetLength();
        functionFactory.reverse();
        functionFactory.space();
        functionFactory.repeat();
        functionFactory.pad_space();
        functionFactory.md5();
        functionFactory.yearMonthDay();
        functionFactory.hourMinuteSecond();
        functionFactory.dayofweekmonthyear();
        functionFactory.weekQuarter();
        functionFactory.daynameMonthname();
        functionFactory.lastDay();
        functionFactory.date();
        functionFactory.timestamp();
        this.time(functionContributions);
        functionFactory.utcDateTimeTimestamp();
        functionFactory.rand();
        functionFactory.crc32();
        functionFactory.sha1();
        functionFactory.sha2();
        functionFactory.sha();
        functionFactory.bitLength();
        functionFactory.octetLength();
        functionFactory.ascii();
        functionFactory.instr();
        functionFactory.substr();
        functionFactory.position();
        functionFactory.nowCurdateCurtime();
        functionFactory.trunc_truncate();
        functionFactory.insert();
        functionFactory.bitandorxornot_operator();
        functionFactory.bitAndOr();
        functionFactory.stddev();
        functionFactory.stddevPopSamp();
        functionFactory.variance();
        functionFactory.varPopSamp();
        functionFactory.datediff();
        functionFactory.adddateSubdateAddtimeSubtime();
        functionFactory.format_dateFormat();
        functionFactory.makedateMaketime();
        functionFactory.localtimeLocaltimestamp();
        BasicTypeRegistry basicTypeRegistry = functionContributions.getTypeConfiguration().getBasicTypeRegistry();
        SqmFunctionRegistry functionRegistry = functionContributions.getFunctionRegistry();
        functionRegistry.noArgsBuilder("localtime").setInvariantType(basicTypeRegistry.resolve(StandardBasicTypes.TIMESTAMP)).setUseParenthesesWhenNoArgs(false).register();
        if (this.getMySQLVersion().isSameOrAfter(8)) {
            functionRegistry.patternDescriptorBuilder("pi", "cast(pi() as double)").setInvariantType(basicTypeRegistry.resolve(StandardBasicTypes.DOUBLE)).setExactArgumentCount(0).setArgumentListSignature("").register();
        } else {
            functionRegistry.patternDescriptorBuilder("pi", "cast(pi() as decimal(53,15))").setInvariantType(basicTypeRegistry.resolve(StandardBasicTypes.DOUBLE)).setExactArgumentCount(0).setArgumentListSignature("").register();
        }
        functionRegistry.patternDescriptorBuilder("chr", "char(?1 using ascii)").setInvariantType(basicTypeRegistry.resolve(StandardBasicTypes.CHARACTER)).setExactArgumentCount(1).setParameterTypes(FunctionParameterType.INTEGER).register();
        functionRegistry.registerAlternateKey("char", "chr");
        functionFactory.sysdateExplicitMicros();
        if (this.getMySQLVersion().isSameOrAfter(8, 0, 2)) {
            functionFactory.windowFunctions();
            if (this.getMySQLVersion().isSameOrAfter(8, 0, 11)) {
                functionFactory.hypotheticalOrderedSetAggregates_windowEmulation();
            }
        }
        functionFactory.listagg_groupConcat();
    }

    @Override
    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.contributeTypes(typeContributions, serviceRegistry);
        JdbcTypeRegistry jdbcTypeRegistry = typeContributions.getTypeConfiguration().getJdbcTypeRegistry();
        jdbcTypeRegistry.addDescriptorIfAbsent(3001, MySQLCastingJsonJdbcType.INSTANCE);
        typeContributions.contributeJdbcType(NullJdbcType.INSTANCE);
        typeContributions.contributeType(new NullType((JdbcType)NullJdbcType.INSTANCE, typeContributions.getTypeConfiguration().getJavaTypeRegistry().getDescriptor((Type)((Object)Object.class))));
    }

    @Override
    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            @Override
            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, org.hibernate.sql.ast.tree.Statement statement) {
                return new MySQLSqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    @Override
    public String castPattern(CastType from, CastType to) {
        if (to == CastType.INTEGER_BOOLEAN) {
            switch (from) {
                case STRING: 
                case INTEGER: 
                case LONG: 
                case YN_BOOLEAN: 
                case TF_BOOLEAN: 
                case BOOLEAN: {
                    break;
                }
                default: {
                    return "abs(sign(?1))";
                }
            }
        }
        return super.castPattern(from, to);
    }

    private void time(FunctionContributions queryEngine) {
        queryEngine.getFunctionRegistry().namedDescriptorBuilder("time").setExactArgumentCount(1).setInvariantType(queryEngine.getTypeConfiguration().getBasicTypeRegistry().resolve(StandardBasicTypes.STRING)).register();
    }

    @Override
    public int getFloatPrecision() {
        return 23;
    }

    @Override
    public String currentTimestamp() {
        return "current_timestamp(6)";
    }

    @Override
    public long getFractionalSecondPrecisionInNanos() {
        return 1000L;
    }

    @Override
    public String extractPattern(TemporalUnit unit) {
        switch (unit) {
            case SECOND: {
                return "(second(?2)+microsecond(?2)/1e6)";
            }
            case WEEK: {
                return "weekofyear(?2)";
            }
            case DAY_OF_WEEK: {
                return "dayofweek(?2)";
            }
            case DAY_OF_MONTH: {
                return "dayofmonth(?2)";
            }
            case DAY_OF_YEAR: {
                return "dayofyear(?2)";
            }
            case EPOCH: {
                return "unix_timestamp(?2)";
            }
        }
        return "?1(?2)";
    }

    @Override
    public String timestampaddPattern(TemporalUnit unit, TemporalType temporalType, IntervalType intervalType) {
        switch (unit) {
            case NANOSECOND: {
                return "timestampadd(microsecond,(?2)/1e3,?3)";
            }
            case NATIVE: {
                return "timestampadd(microsecond,?2,?3)";
            }
        }
        return "timestampadd(?1,?2,?3)";
    }

    @Override
    public String timestampdiffPattern(TemporalUnit unit, TemporalType fromTemporalType, TemporalType toTemporalType) {
        switch (unit) {
            case NANOSECOND: {
                return "timestampdiff(microsecond,?2,?3)*1e3";
            }
            case NATIVE: {
                return "timestampdiff(microsecond,?2,?3)";
            }
        }
        return "timestampdiff(?1,?2,?3)";
    }

    @Override
    public boolean supportsTemporalLiteralOffset() {
        return this.getMySQLVersion().isSameOrAfter(8, 0, 19);
    }

    @Override
    public void appendDateTimeLiteral(SqlAppender appender, TemporalAccessor temporalAccessor, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("date '");
                DateTimeUtils.appendAsDate(appender, temporalAccessor);
                appender.appendSql('\'');
                break;
            }
            case TIME: {
                appender.appendSql("time '");
                DateTimeUtils.appendAsLocalTime(appender, temporalAccessor);
                appender.appendSql('\'');
                break;
            }
            case TIMESTAMP: {
                if (temporalAccessor instanceof ZonedDateTime) {
                    temporalAccessor = ((ZonedDateTime)temporalAccessor).toOffsetDateTime();
                }
                appender.appendSql("timestamp '");
                DateTimeUtils.appendAsTimestampWithMicros(appender, temporalAccessor, this.supportsTemporalLiteralOffset(), jdbcTimeZone, false);
                appender.appendSql('\'');
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void appendDateTimeLiteral(SqlAppender appender, Date date, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("date '");
                DateTimeUtils.appendAsDate(appender, date);
                appender.appendSql('\'');
                break;
            }
            case TIME: {
                appender.appendSql("time '");
                DateTimeUtils.appendAsLocalTime(appender, date);
                appender.appendSql('\'');
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("timestamp '");
                DateTimeUtils.appendAsTimestampWithMicros(appender, date, jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void appendDateTimeLiteral(SqlAppender appender, Calendar calendar, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("date '");
                DateTimeUtils.appendAsDate(appender, calendar);
                appender.appendSql('\'');
                break;
            }
            case TIME: {
                appender.appendSql("time '");
                DateTimeUtils.appendAsLocalTime(appender, calendar);
                appender.appendSql('\'');
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("timestamp '");
                DateTimeUtils.appendAsTimestampWithMillis(appender, calendar, jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public SelectItemReferenceStrategy getGroupBySelectItemReferenceStrategy() {
        return SelectItemReferenceStrategy.POSITION;
    }

    @Override
    public boolean supportsColumnCheck() {
        return this.getMySQLVersion().isSameOrAfter(8, 0, 16);
    }

    @Override
    public String getEnumTypeDeclaration(String[] values) {
        StringBuilder type = new StringBuilder();
        type.append("enum (");
        String separator = "";
        for (String value : values) {
            type.append(separator).append('\'').append(value).append('\'');
            separator = ",";
        }
        return type.append(')').toString();
    }

    @Override
    public String getCheckCondition(String columnName, String[] values) {
        return null;
    }

    @Override
    public String getQueryHintString(String query, String hints) {
        return IndexQueryHintHandler.INSTANCE.addQueryHints(query, hints);
    }

    @Override
    public SequenceSupport getSequenceSupport() {
        return NoSequenceSupport.INSTANCE;
    }

    @Override
    public ViolatedConstraintNameExtractor getViolatedConstraintNameExtractor() {
        return EXTRACTOR;
    }

    @Override
    public boolean qualifyIndexName() {
        return false;
    }

    @Override
    public String getAddForeignKeyConstraintString(String constraintName, String[] foreignKey, String referencedTable, String[] primaryKey, boolean referencesPrimaryKey) {
        String cols = String.join((CharSequence)", ", foreignKey);
        String referencedCols = String.join((CharSequence)", ", primaryKey);
        return String.format(" add constraint %s foreign key (%s) references %s (%s)", constraintName, cols, referencedTable, referencedCols);
    }

    @Override
    public String getDropForeignKeyString() {
        return "drop foreign key";
    }

    @Override
    public String getDropUniqueKeyString() {
        return "drop index";
    }

    @Override
    public String getAlterColumnTypeString(String columnName, String columnType, String columnDefinition) {
        return "modify column " + columnName + " " + columnDefinition.trim();
    }

    @Override
    public boolean supportsAlterColumnType() {
        return true;
    }

    @Override
    public LimitHandler getLimitHandler() {
        return LimitLimitHandler.INSTANCE;
    }

    @Override
    public char closeQuote() {
        return '`';
    }

    @Override
    public char openQuote() {
        return '`';
    }

    @Override
    public boolean canCreateCatalog() {
        return true;
    }

    @Override
    public String[] getCreateCatalogCommand(String catalogName) {
        return new String[]{"create database " + catalogName};
    }

    @Override
    public String[] getDropCatalogCommand(String catalogName) {
        return new String[]{"drop database " + catalogName};
    }

    @Override
    public boolean canCreateSchema() {
        return false;
    }

    @Override
    public String[] getCreateSchemaCommand(String schemaName) {
        throw new UnsupportedOperationException("MySQL does not support dropping creating/dropping schemas in the JDBC sense");
    }

    @Override
    public String[] getDropSchemaCommand(String schemaName) {
        throw new UnsupportedOperationException("MySQL does not support dropping creating/dropping schemas in the JDBC sense");
    }

    @Override
    public boolean supportsIfExistsBeforeTableName() {
        return true;
    }

    @Override
    public String getSelectGUIDString() {
        return "select uuid()";
    }

    @Override
    public String getTableComment(String comment) {
        return " comment='" + comment + "'";
    }

    @Override
    public String getColumnComment(String comment) {
        return " comment '" + comment + "'";
    }

    @Override
    public NullOrdering getNullOrdering() {
        return NullOrdering.SMALLEST;
    }

    @Override
    public SqmMultiTableMutationStrategy getFallbackSqmMutationStrategy(EntityMappingType rootEntityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new LocalTemporaryTableMutationStrategy(TemporaryTable.createIdTable(rootEntityDescriptor, basename -> "HT_" + basename, this, runtimeModelCreationContext), runtimeModelCreationContext.getSessionFactory());
    }

    @Override
    public SqmMultiTableInsertStrategy getFallbackSqmInsertStrategy(EntityMappingType rootEntityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new LocalTemporaryTableInsertStrategy(TemporaryTable.createEntityTable(rootEntityDescriptor, name -> "HTE_" + name, this, runtimeModelCreationContext), runtimeModelCreationContext.getSessionFactory());
    }

    @Override
    public TemporaryTableKind getSupportedTemporaryTableKind() {
        return TemporaryTableKind.LOCAL;
    }

    @Override
    public String getTemporaryTableCreateCommand() {
        return "create temporary table if not exists";
    }

    @Override
    public String getTemporaryTableDropCommand() {
        return "drop temporary table";
    }

    @Override
    public AfterUseAction getTemporaryTableAfterUseAction() {
        return AfterUseAction.DROP;
    }

    @Override
    public BeforeUseAction getTemporaryTableBeforeUseAction() {
        return BeforeUseAction.CREATE;
    }

    @Override
    public int getMaxAliasLength() {
        return 246;
    }

    @Override
    public int getMaxIdentifierLength() {
        return 64;
    }

    @Override
    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    @Override
    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    @Override
    public String getCurrentTimestampSelectString() {
        return "select now()";
    }

    @Override
    public int registerResultSetOutParameter(CallableStatement statement, int col) throws SQLException {
        return col;
    }

    @Override
    public ResultSet getResultSet(CallableStatement ps) throws SQLException {
        boolean isResultSet = ps.execute();
        while (!isResultSet && ps.getUpdateCount() != -1) {
            isResultSet = ps.getMoreResults();
        }
        return ps.getResultSet();
    }

    @Override
    public boolean supportsNullPrecedence() {
        return false;
    }

    @Override
    public boolean supportsLobValueChangePropagation() {
        return false;
    }

    @Override
    public boolean supportsSubqueryOnMutatingTable() {
        return false;
    }

    @Override
    public boolean supportsLockTimeouts() {
        return false;
    }

    @Override
    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        return (sqlException, message, sql) -> {
            switch (sqlException.getErrorCode()) {
                case 1205: 
                case 3572: {
                    return new PessimisticLockException(message, sqlException, sql);
                }
                case 1206: 
                case 1207: {
                    return new LockAcquisitionException(message, sqlException, sql);
                }
            }
            String sqlState = JdbcExceptionHelper.extractSqlState(sqlException);
            if (sqlState != null) {
                switch (sqlState) {
                    case "41000": {
                        return new LockTimeoutException(message, sqlException, sql);
                    }
                    case "40001": {
                        return new LockAcquisitionException(message, sqlException, sql);
                    }
                }
            }
            return null;
        };
    }

    @Override
    public NameQualifierSupport getNameQualifierSupport() {
        return NameQualifierSupport.CATALOG;
    }

    @Override
    public IdentifierHelper buildIdentifierHelper(IdentifierHelperBuilder builder, DatabaseMetaData dbMetaData) throws SQLException {
        if (dbMetaData == null) {
            builder.setUnquotedCaseStrategy(IdentifierCaseStrategy.MIXED);
            builder.setQuotedCaseStrategy(IdentifierCaseStrategy.MIXED);
        }
        return super.buildIdentifierHelper(builder, dbMetaData);
    }

    @Override
    public IdentityColumnSupport getIdentityColumnSupport() {
        return MySQLIdentityColumnSupport.INSTANCE;
    }

    @Override
    public boolean isJdbcLogWarningsEnabledByDefault() {
        return false;
    }

    @Override
    public boolean supportsCascadeDelete() {
        return this.storageEngine.supportsCascadeDelete();
    }

    @Override
    public String getTableTypeString() {
        return this.storageEngine.getTableTypeString("engine");
    }

    @Override
    public boolean hasSelfReferentialForeignKeyBug() {
        return this.storageEngine.hasSelfReferentialForeignKeyBug();
    }

    @Override
    public boolean dropConstraints() {
        return this.storageEngine.dropConstraints();
    }

    protected MySQLStorageEngine getDefaultMySQLStorageEngine() {
        return InnoDBStorageEngine.INSTANCE;
    }

    @Override
    public void appendLiteral(SqlAppender appender, String literal) {
        appender.appendSql('\'');
        for (int i = 0; i < literal.length(); ++i) {
            char c = literal.charAt(i);
            switch (c) {
                case '\'': {
                    appender.appendSql('\'');
                    break;
                }
                case '\\': {
                    if (this.noBackslashEscapesEnabled) break;
                    appender.appendSql('\\');
                }
            }
            appender.appendSql(c);
        }
        appender.appendSql('\'');
    }

    @Override
    public void appendDatetimeFormat(SqlAppender appender, String format) {
        appender.appendSql(MySQLDialect.datetimeFormat(format).result());
    }

    public static Replacer datetimeFormat(String format) {
        return new Replacer(format, "'", "").replace("%", "%%").replace("yyyy", "%Y").replace("yyy", "%Y").replace("yy", "%y").replace("y", "%Y").replace("MMMM", "%M").replace("MMM", "%b").replace("MM", "%m").replace("M", "%c").replace("ww", "%v").replace("w", "%v").replace("YYYY", "%x").replace("YYY", "%x").replace("YY", "%x").replace("Y", "%x").replace("EEEE", "%W").replace("EEE", "%a").replace("ee", "%w").replace("e", "%w").replace("dd", "%d").replace("d", "%e").replace("DDD", "%j").replace("DD", "%j").replace("D", "%j").replace("a", "%p").replace("hh", "%I").replace("HH", "%H").replace("h", "%l").replace("H", "%k").replace("mm", "%i").replace("m", "%i").replace("ss", "%S").replace("s", "%S").replace("SSSSSS", "%f").replace("SSSSS", "%f").replace("SSSS", "%f").replace("SSS", "%f").replace("SS", "%f").replace("S", "%f");
    }

    private String withTimeout(String lockString, int timeout) {
        switch (timeout) {
            case 0: {
                return this.supportsNoWait() ? lockString + " nowait" : lockString;
            }
            case -2: {
                return this.supportsSkipLocked() ? lockString + " skip locked" : lockString;
            }
            case -1: {
                return lockString;
            }
        }
        return this.supportsWait() ? lockString + " wait " + this.getTimeoutInSeconds(timeout) : lockString;
    }

    @Override
    public String getWriteLockString(int timeout) {
        return this.withTimeout(this.getForUpdateString(), timeout);
    }

    @Override
    public String getWriteLockString(String aliases, int timeout) {
        return this.withTimeout(this.getForUpdateString(aliases), timeout);
    }

    @Override
    public String getReadLockString(int timeout) {
        return this.withTimeout(this.supportsForShare() ? " for share" : " lock in share mode", timeout);
    }

    @Override
    public String getReadLockString(String aliases, int timeout) {
        if (this.supportsAliasLocks() && this.supportsForShare()) {
            return this.withTimeout(" for share of " + aliases, timeout);
        }
        return this.getReadLockString(timeout);
    }

    @Override
    public String getForUpdateSkipLockedString() {
        return this.supportsSkipLocked() ? " for update skip locked" : this.getForUpdateString();
    }

    @Override
    public String getForUpdateSkipLockedString(String aliases) {
        return this.supportsSkipLocked() && this.supportsAliasLocks() ? this.getForUpdateString(aliases) + " skip locked" : this.getForUpdateSkipLockedString();
    }

    @Override
    public String getForUpdateNowaitString() {
        return this.supportsNoWait() ? " for update nowait" : this.getForUpdateString();
    }

    @Override
    public String getForUpdateNowaitString(String aliases) {
        return this.supportsNoWait() && this.supportsAliasLocks() ? this.getForUpdateString(aliases) + " nowait" : this.getForUpdateNowaitString();
    }

    @Override
    public String getForUpdateString(String aliases) {
        return this.supportsAliasLocks() ? " for update of " + aliases : this.getForUpdateString();
    }

    @Override
    public boolean supportsOffsetInSubquery() {
        return true;
    }

    @Override
    public boolean supportsWindowFunctions() {
        return this.getMySQLVersion().isSameOrAfter(8, 0, 2);
    }

    @Override
    public boolean supportsLateral() {
        return this.getMySQLVersion().isSameOrAfter(8, 0, 14);
    }

    @Override
    public boolean supportsRecursiveCTE() {
        return this.getMySQLVersion().isSameOrAfter(8, 0, 14);
    }

    @Override
    public boolean supportsSkipLocked() {
        return this.getMySQLVersion().isSameOrAfter(8);
    }

    @Override
    public boolean supportsNoWait() {
        return this.getMySQLVersion().isSameOrAfter(8);
    }

    @Override
    public boolean supportsWait() {
        return false;
    }

    @Override
    public RowLockStrategy getWriteRowLockStrategy() {
        return this.supportsAliasLocks() ? RowLockStrategy.TABLE : RowLockStrategy.NONE;
    }

    @Override
    protected void registerDefaultKeywords() {
        super.registerDefaultKeywords();
        this.registerKeyword("key");
    }

    boolean supportsForShare() {
        return this.getMySQLVersion().isSameOrAfter(8);
    }

    boolean supportsAliasLocks() {
        return this.getMySQLVersion().isSameOrAfter(8);
    }

    @Override
    public boolean canDisableConstraints() {
        return true;
    }

    @Override
    public String getDisableConstraintsStatement() {
        return "set foreign_key_checks = 0";
    }

    @Override
    public String getEnableConstraintsStatement() {
        return "set foreign_key_checks = 1";
    }
}

