/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import java.util.Map;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.ObjectDeletedException;
import org.hibernate.StaleObjectStateException;
import org.hibernate.WrongClassException;
import org.hibernate.bytecode.enhance.spi.interceptor.EnhancementAsProxyLazinessInterceptor;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.internal.Cascade;
import org.hibernate.engine.internal.CascadePoint;
import org.hibernate.engine.internal.ManagedTypeHelper;
import org.hibernate.engine.spi.CascadingAction;
import org.hibernate.engine.spi.CascadingActions;
import org.hibernate.engine.spi.CollectionEntry;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.engine.spi.SelfDirtinessTracker;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.internal.AbstractSaveEventListener;
import org.hibernate.event.internal.EntityState;
import org.hibernate.event.internal.EventUtil;
import org.hibernate.event.internal.WrapVisitor;
import org.hibernate.event.spi.EntityCopyObserver;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.MergeContext;
import org.hibernate.event.spi.MergeEvent;
import org.hibernate.event.spi.MergeEventListener;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.loader.ast.spi.CascadingFetchProfile;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.hibernate.type.CollectionType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.EntityType;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.Type;
import org.hibernate.type.TypeHelper;

public class DefaultMergeEventListener
extends AbstractSaveEventListener<MergeContext>
implements MergeEventListener {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(DefaultMergeEventListener.class);

    @Override
    protected Map<Object, Object> getMergeMap(MergeContext context) {
        return context.invertMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMerge(MergeEvent event) throws HibernateException {
        EventSource session = event.getSession();
        EntityCopyObserver entityCopyObserver = this.createEntityCopyObserver(session);
        MergeContext mergeContext = new MergeContext(session, entityCopyObserver);
        try {
            this.onMerge(event, mergeContext);
            entityCopyObserver.topLevelMergeComplete(session);
        }
        finally {
            entityCopyObserver.clear();
            mergeContext.clear();
        }
    }

    private EntityCopyObserver createEntityCopyObserver(EventSource session) {
        return session.getFactory().getFastSessionServices().entityCopyObserverFactory.createEntityCopyObserver();
    }

    @Override
    public void onMerge(MergeEvent event, MergeContext copiedAlready) throws HibernateException {
        Object original = event.getOriginal();
        if (original != null) {
            EventSource source = event.getSession();
            LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(original);
            if (lazyInitializer != null) {
                if (lazyInitializer.isUninitialized()) {
                    LOG.trace("Ignoring uninitialized proxy");
                    event.setResult(source.load(lazyInitializer.getEntityName(), lazyInitializer.getInternalIdentifier()));
                } else {
                    this.doMerge(event, copiedAlready, lazyInitializer.getImplementation());
                }
            } else if (ManagedTypeHelper.isPersistentAttributeInterceptable(original)) {
                PersistentAttributeInterceptor interceptor = ManagedTypeHelper.asPersistentAttributeInterceptable(original).$$_hibernate_getInterceptor();
                if (interceptor instanceof EnhancementAsProxyLazinessInterceptor) {
                    EnhancementAsProxyLazinessInterceptor proxyInterceptor = (EnhancementAsProxyLazinessInterceptor)interceptor;
                    LOG.trace("Ignoring uninitialized enhanced-proxy");
                    event.setResult(source.load(proxyInterceptor.getEntityName(), proxyInterceptor.getIdentifier()));
                } else {
                    this.doMerge(event, copiedAlready, original);
                }
            } else {
                this.doMerge(event, copiedAlready, original);
            }
        }
    }

    private void doMerge(MergeEvent event, MergeContext copiedAlready, Object entity) {
        if (copiedAlready.containsKey(entity) && copiedAlready.isOperatedOn(entity)) {
            LOG.trace("Already in merge process");
            event.setResult(entity);
        } else {
            if (copiedAlready.containsKey(entity)) {
                LOG.trace("Already in copyCache; setting in merge process");
                copiedAlready.setOperatedOn(entity, true);
            }
            event.setEntity(entity);
            this.merge(event, copiedAlready, entity);
        }
    }

    private void merge(MergeEvent event, MergeContext copiedAlready, Object entity) {
        EntityState entityState;
        Object copiedId;
        Object originalId;
        EventSource source = event.getSession();
        PersistenceContext persistenceContext = source.getPersistenceContextInternal();
        EntityEntry entry = persistenceContext.getEntry(entity);
        if (entry == null) {
            EntityPersister persister = source.getEntityPersister(event.getEntityName(), entity);
            originalId = persister.getIdentifier(entity, source);
            if (originalId != null) {
                EntityKey entityKey;
                if (persister.getIdentifierType().isComponentType()) {
                    copiedId = DefaultMergeEventListener.copyCompositeTypeId(originalId, (CompositeType)persister.getIdentifierType(), source, copiedAlready);
                    entityKey = source.generateEntityKey(copiedId, persister);
                } else {
                    copiedId = null;
                    entityKey = source.generateEntityKey(originalId, persister);
                }
                Object managedEntity = persistenceContext.getEntity(entityKey);
                entry = persistenceContext.getEntry(managedEntity);
                entityState = entry != null ? EntityState.DETACHED : EntityState.getEntityState(entity, event.getEntityName(), entry, source, false);
            } else {
                copiedId = null;
                entityState = EntityState.getEntityState(entity, event.getEntityName(), entry, source, false);
            }
        } else {
            copiedId = null;
            originalId = null;
            entityState = EntityState.getEntityState(entity, event.getEntityName(), entry, source, false);
        }
        switch (entityState) {
            case DETACHED: {
                this.entityIsDetached(event, copiedId, originalId, copiedAlready);
                break;
            }
            case TRANSIENT: {
                this.entityIsTransient(event, copiedId != null ? copiedId : originalId, copiedAlready);
                break;
            }
            case PERSISTENT: {
                this.entityIsPersistent(event, copiedAlready);
                break;
            }
            default: {
                if (event.getSession().getPersistenceContext().getEntry(entity) == null) {
                    assert (event.getSession().getPersistenceContext().containsDeletedUnloadedEntityKey(event.getSession().generateEntityKey(event.getSession().getEntityPersister(event.getEntityName(), entity).getIdentifier(entity, event.getSession()), event.getSession().getEntityPersister(event.getEntityName(), entity))));
                    event.getSession().getActionQueue().unScheduleUnloadedDeletion(entity);
                    this.entityIsDetached(event, copiedId, originalId, copiedAlready);
                    break;
                }
                throw new ObjectDeletedException("deleted instance passed to merge", null, EventUtil.getLoggableName(event.getEntityName(), entity));
            }
        }
    }

    private static Object copyCompositeTypeId(Object id, CompositeType compositeType, EventSource session, MergeContext mergeContext) {
        SessionFactoryImplementor sessionFactory = session.getSessionFactory();
        Object idCopy = compositeType.deepCopy(id, sessionFactory);
        Type[] subtypes = compositeType.getSubtypes();
        Object[] propertyValues = compositeType.getPropertyValues(id);
        Object[] copyValues = compositeType.getPropertyValues(idCopy);
        for (int i = 0; i < subtypes.length; ++i) {
            Type subtype = subtypes[i];
            if (subtype.isEntityType()) {
                Object o = mergeContext.get(propertyValues[i]);
                if (o != null) {
                    copyValues[i] = o;
                    continue;
                }
                copyValues[i] = subtype.deepCopy(propertyValues[i], sessionFactory);
                continue;
            }
            copyValues[i] = subtype.isComponentType() ? DefaultMergeEventListener.copyCompositeTypeId(propertyValues[i], (CompositeType)subtype, session, mergeContext) : subtype.deepCopy(propertyValues[i], sessionFactory);
        }
        compositeType.setPropertyValues(idCopy, copyValues);
        return idCopy;
    }

    protected void entityIsPersistent(MergeEvent event, MergeContext copyCache) {
        LOG.trace("Ignoring persistent instance");
        Object entity = event.getEntity();
        EventSource source = event.getSession();
        EntityPersister persister = source.getEntityPersister(event.getEntityName(), entity);
        copyCache.put(entity, entity, true);
        this.cascadeOnMerge(source, persister, entity, copyCache);
        this.copyValues(persister, entity, entity, source, copyCache);
        event.setResult(entity);
    }

    protected void entityIsTransient(MergeEvent event, Object id, MergeContext copyCache) {
        PersistentAttributeInterceptor interceptor;
        LOG.trace("Merging transient instance");
        Object entity = event.getEntity();
        EventSource session = event.getSession();
        String entityName = event.getEntityName();
        EntityPersister persister = session.getEntityPersister(entityName, entity);
        Object copy = DefaultMergeEventListener.copyEntity(copyCache, entity, session, persister, id);
        super.cascadeBeforeSave(session, persister, entity, copyCache);
        this.copyValues(persister, entity, copy, session, copyCache, ForeignKeyDirection.FROM_PARENT);
        this.saveTransientEntity(copy, entityName, event.getRequestedId(), session, copyCache);
        super.cascadeAfterSave(session, persister, entity, copyCache);
        this.copyValues(persister, entity, copy, session, copyCache, ForeignKeyDirection.TO_PARENT);
        new CollectionVisitor(copy, id, session).processEntityPropertyValues(persister.getPropertyValuesToInsert(copy, this.getMergeMap(copyCache), session), persister.getPropertyTypes());
        event.setResult(copy);
        if (ManagedTypeHelper.isPersistentAttributeInterceptable(copy) && (interceptor = ManagedTypeHelper.asPersistentAttributeInterceptable(copy).$$_hibernate_getInterceptor()) == null) {
            persister.getBytecodeEnhancementMetadata().injectInterceptor(copy, id, (SharedSessionContractImplementor)session);
        }
    }

    private static Object copyEntity(MergeContext copyCache, Object entity, EventSource session, EntityPersister persister, Object id) {
        Object existingCopy = copyCache.get(entity);
        if (existingCopy != null) {
            persister.setIdentifier(existingCopy, id, session);
            return existingCopy;
        }
        Object copy = session.instantiate(persister, id);
        copyCache.put(entity, copy, true);
        return copy;
    }

    private void saveTransientEntity(Object entity, String entityName, Object requestedId, EventSource source, MergeContext copyCache) {
        if (requestedId == null) {
            this.saveWithGeneratedId(entity, entityName, copyCache, source, false);
        } else {
            this.saveWithRequestedId(entity, requestedId, entityName, copyCache, source);
        }
    }

    protected void entityIsDetached(MergeEvent event, Object copiedId, Object originalId, MergeContext copyCache) {
        LOG.trace("Merging detached instance");
        Object entity = event.getEntity();
        EventSource source = event.getSession();
        EntityPersister persister = source.getEntityPersister(event.getEntityName(), entity);
        String entityName = persister.getEntityName();
        if (originalId == null) {
            originalId = persister.getIdentifier(entity, source);
        }
        Object clonedIdentifier = copiedId == null ? persister.getIdentifierType().deepCopy(originalId, source.getFactory()) : copiedId;
        Object id = DefaultMergeEventListener.getDetachedEntityId(event, originalId, persister);
        Object result = source.getLoadQueryInfluencers().fromInternalFetchProfile(CascadingFetchProfile.MERGE, () -> source.get(entityName, clonedIdentifier));
        if (result == null) {
            this.entityIsTransient(event, clonedIdentifier, copyCache);
        } else {
            copyCache.put(entity, result, true);
            Object target = DefaultMergeEventListener.targetEntity(event, entity, persister, id, result);
            this.cascadeOnMerge(source, persister, entity, copyCache);
            this.copyValues(persister, entity, target, source, copyCache);
            DefaultMergeEventListener.markInterceptorDirty(entity, target);
            event.setResult(result);
        }
    }

    private static Object targetEntity(MergeEvent event, Object entity, EntityPersister persister, Object id, Object result) {
        EventSource source = event.getSession();
        String entityName = persister.getEntityName();
        Object target = DefaultMergeEventListener.unproxyManagedForDetachedMerging(entity, result, persister, source);
        if (target == entity) {
            throw new AssertionFailure("entity was not detached");
        }
        if (!source.getEntityName(target).equals(entityName)) {
            throw new WrongClassException("class of the given object did not match class of persistent copy", event.getRequestedId(), entityName);
        }
        if (DefaultMergeEventListener.isVersionChanged(entity, source, persister, target)) {
            StatisticsImplementor statistics = source.getFactory().getStatistics();
            if (statistics.isStatisticsEnabled()) {
                statistics.optimisticFailure(entityName);
            }
            throw new StaleObjectStateException(entityName, id);
        }
        return target;
    }

    private static Object getDetachedEntityId(MergeEvent event, Object originalId, EntityPersister persister) {
        EventSource source = event.getSession();
        Object id = event.getRequestedId();
        if (id == null) {
            return originalId;
        }
        Object entityId = originalId;
        if (!persister.getIdentifierType().isEqual(id, entityId, source.getFactory())) {
            throw new HibernateException("merge requested with id not matching id of passed entity");
        }
        return id;
    }

    private static Object unproxyManagedForDetachedMerging(Object incoming, Object managed, EntityPersister persister, EventSource source) {
        if (ManagedTypeHelper.isHibernateProxy(managed)) {
            return source.getPersistenceContextInternal().unproxy(managed);
        }
        if (ManagedTypeHelper.isPersistentAttributeInterceptable(incoming) && persister.getBytecodeEnhancementMetadata().isEnhancedForLazyLoading()) {
            PersistentAttributeInterceptor incomingInterceptor = ManagedTypeHelper.asPersistentAttributeInterceptable(incoming).$$_hibernate_getInterceptor();
            PersistentAttributeInterceptor managedInterceptor = ManagedTypeHelper.asPersistentAttributeInterceptable(managed).$$_hibernate_getInterceptor();
            if (!(managedInterceptor instanceof EnhancementAsProxyLazinessInterceptor)) {
                return managed;
            }
            if (incomingInterceptor instanceof EnhancementAsProxyLazinessInterceptor) {
                return managed;
            }
            persister.initializeEnhancedEntityUsedAsProxy(managed, null, source);
        }
        return managed;
    }

    private static void markInterceptorDirty(Object entity, Object target) {
        if (ManagedTypeHelper.isSelfDirtinessTracker(entity) && ManagedTypeHelper.isSelfDirtinessTracker(target)) {
            SelfDirtinessTracker selfDirtinessTrackerTarget = ManagedTypeHelper.asSelfDirtinessTracker(target);
            selfDirtinessTrackerTarget.$$_hibernate_clearDirtyAttributes();
            for (String fieldName : ManagedTypeHelper.asSelfDirtinessTracker(entity).$$_hibernate_getDirtyAttributes()) {
                selfDirtinessTrackerTarget.$$_hibernate_trackChange(fieldName);
            }
        }
    }

    private static boolean isVersionChanged(Object entity, EventSource source, EntityPersister persister, Object target) {
        if (persister.isVersioned()) {
            boolean changed = !persister.getVersionType().isSame(persister.getVersion(target), persister.getVersion(entity));
            return changed && DefaultMergeEventListener.existsInDatabase(target, source, persister);
        }
        return false;
    }

    private static boolean existsInDatabase(Object entity, EventSource source, EntityPersister persister) {
        Object id;
        PersistenceContext persistenceContext = source.getPersistenceContextInternal();
        EntityEntry entry = persistenceContext.getEntry(entity);
        if (entry == null && (id = persister.getIdentifier(entity, source)) != null) {
            EntityKey key = source.generateEntityKey(id, persister);
            Object managedEntity = persistenceContext.getEntity(key);
            entry = persistenceContext.getEntry(managedEntity);
        }
        return entry != null && entry.isExistsInDatabase();
    }

    protected void copyValues(EntityPersister persister, Object entity, Object target, SessionImplementor source, MergeContext copyCache) {
        if (entity == target) {
            TypeHelper.replace(persister, entity, source, entity, copyCache);
        } else {
            Object[] copiedValues = TypeHelper.replace(persister.getValues(entity), persister.getValues(target), persister.getPropertyTypes(), source, target, copyCache);
            persister.setValues(target, copiedValues);
        }
    }

    protected void copyValues(EntityPersister persister, Object entity, Object target, SessionImplementor source, MergeContext copyCache, ForeignKeyDirection foreignKeyDirection) {
        Object[] copiedValues = foreignKeyDirection == ForeignKeyDirection.TO_PARENT ? TypeHelper.replaceAssociations(persister.getValues(entity), persister.getValues(target), persister.getPropertyTypes(), source, target, copyCache, foreignKeyDirection) : TypeHelper.replace(persister.getValues(entity), persister.getValues(target), persister.getPropertyTypes(), source, target, copyCache, foreignKeyDirection);
        persister.setValues(target, copiedValues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cascadeOnMerge(EventSource source, EntityPersister persister, Object entity, MergeContext copyCache) {
        PersistenceContext persistenceContext = source.getPersistenceContextInternal();
        persistenceContext.incrementCascadeLevel();
        try {
            Cascade.cascade(this.getCascadeAction(), CascadePoint.BEFORE_MERGE, source, persister, entity, copyCache);
        }
        finally {
            persistenceContext.decrementCascadeLevel();
        }
    }

    @Override
    protected CascadingAction<MergeContext> getCascadeAction() {
        return CascadingActions.MERGE;
    }

    @Override
    protected void cascadeAfterSave(EventSource source, EntityPersister persister, Object entity, MergeContext anything) throws HibernateException {
    }

    @Override
    protected void cascadeBeforeSave(EventSource source, EntityPersister persister, Object entity, MergeContext anything) throws HibernateException {
    }

    private static class CollectionVisitor
    extends WrapVisitor {
        CollectionVisitor(Object entity, Object id, EventSource session) {
            super(entity, id, session);
        }

        @Override
        protected Object processCollection(Object collection, CollectionType collectionType) throws HibernateException {
            if (collection instanceof PersistentCollection) {
                PersistentCollection coll = (PersistentCollection)collection;
                CollectionPersister persister = this.getSession().getFactory().getRuntimeMetamodels().getMappingMetamodel().getCollectionDescriptor(collectionType.getRole());
                CollectionEntry collectionEntry = this.getSession().getPersistenceContextInternal().getCollectionEntry(coll);
                if (!coll.equalsSnapshot(persister)) {
                    collectionEntry.resetStoredSnapshot(coll, coll.getSnapshot(persister));
                }
            }
            return null;
        }

        @Override
        Object processEntity(Object value, EntityType entityType) throws HibernateException {
            return null;
        }
    }
}

