/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.type.descriptor.java.JavaType;

public class Compatibility {
    private static final Map<Class, Class> primitiveToWrapper = new ConcurrentHashMap<Class, Class>();
    private static final Map<Class, Class> wrapperToPrimitive = new ConcurrentHashMap<Class, Class>();

    private Compatibility() {
    }

    private static void map(Class primitive, Class wrapper) {
        primitiveToWrapper.put(primitive, wrapper);
        wrapperToPrimitive.put(wrapper, primitive);
    }

    public static boolean isWrapper(Class potentialWrapper) {
        return wrapperToPrimitive.containsKey(potentialWrapper);
    }

    public static Class primitiveEquivalent(Class potentialWrapper) {
        assert (Compatibility.isWrapper(potentialWrapper));
        return wrapperToPrimitive.get(potentialWrapper);
    }

    public static Class wrapperEquivalent(Class primitive) {
        assert (primitive.isPrimitive());
        return primitiveToWrapper.get(primitive);
    }

    public static boolean areAssignmentCompatible(Class to, Class from) {
        assert (to != null);
        assert (from != null);
        if (to.isAssignableFrom(from)) {
            return true;
        }
        if (to.isPrimitive()) {
            if (from.isPrimitive()) {
                return Compatibility.areAssignmentCompatiblePrimitive(to, from);
            }
            if (Compatibility.isWrapper(from)) {
                return Compatibility.areAssignmentCompatiblePrimitive(to, Compatibility.primitiveEquivalent(from));
            }
        } else if (Compatibility.isWrapper(to)) {
            if (from.isPrimitive()) {
                return Compatibility.areAssignmentCompatiblePrimitive(Compatibility.primitiveEquivalent(to), from);
            }
            if (Compatibility.isWrapper(from)) {
                return Compatibility.areAssignmentCompatiblePrimitive(Compatibility.primitiveEquivalent(to), Compatibility.primitiveEquivalent(from));
            }
        }
        return false;
    }

    private static boolean areAssignmentCompatiblePrimitive(Class to, Class from) {
        assert (to != null);
        assert (from != null);
        assert (to.isPrimitive());
        assert (from.isPrimitive());
        if (to == Boolean.TYPE) {
            return from == Boolean.TYPE;
        }
        if (to == Character.TYPE) {
            return from == Character.TYPE;
        }
        if (to == Byte.TYPE) {
            return from == Byte.TYPE;
        }
        if (Compatibility.isIntegralTypePrimitive(to)) {
            return from == Byte.TYPE || Compatibility.isCompatibleIntegralTypePrimitive(to, from) || Compatibility.isFloatingTypePrimitive(from);
        }
        if (Compatibility.isFloatingTypePrimitive(to)) {
            return from == Byte.TYPE || Compatibility.isIntegralTypePrimitive(from) || Compatibility.isCompatibleFloatingTypePrimitive(to, from);
        }
        return false;
    }

    public static boolean isIntegralType(Class potentialIntegral) {
        if (potentialIntegral.isPrimitive()) {
            return Compatibility.isIntegralTypePrimitive(potentialIntegral);
        }
        return Compatibility.isWrapper(potentialIntegral) && Compatibility.isIntegralTypePrimitive(Compatibility.primitiveEquivalent(potentialIntegral));
    }

    private static boolean isIntegralTypePrimitive(Class potentialIntegral) {
        assert (potentialIntegral.isPrimitive());
        return potentialIntegral == Short.TYPE || potentialIntegral == Integer.TYPE || potentialIntegral == Long.TYPE;
    }

    private static boolean isCompatibleIntegralTypePrimitive(Class to, Class from) {
        assert (Compatibility.isIntegralTypePrimitive(to));
        assert (from.isPrimitive());
        if (to == Short.TYPE) {
            return from == Short.TYPE;
        }
        if (to == Integer.TYPE) {
            return from == Short.TYPE || from == Integer.TYPE;
        }
        return Compatibility.isIntegralTypePrimitive(from);
    }

    public static boolean isFloatingType(Class potentialFloating) {
        if (potentialFloating.isPrimitive()) {
            return Compatibility.isFloatingTypePrimitive(potentialFloating);
        }
        return Compatibility.isWrapper(potentialFloating) && Compatibility.isFloatingTypePrimitive(Compatibility.primitiveEquivalent(potentialFloating));
    }

    private static boolean isFloatingTypePrimitive(Class potentialFloating) {
        assert (potentialFloating.isPrimitive());
        return potentialFloating == Float.TYPE || potentialFloating == Double.TYPE;
    }

    private static boolean isCompatibleFloatingTypePrimitive(Class to, Class from) {
        assert (Compatibility.isFloatingTypePrimitive(to));
        assert (from.isPrimitive());
        if (to == Float.TYPE) {
            return from == Float.TYPE;
        }
        return Compatibility.isFloatingTypePrimitive(from);
    }

    public static boolean areAssignmentCompatible(JavaType to, JavaType from) {
        return Compatibility.areAssignmentCompatible(to.getJavaTypeClass(), from.getJavaTypeClass());
    }

    static {
        Compatibility.map(Boolean.TYPE, Boolean.class);
        Compatibility.map(Character.TYPE, Character.class);
        Compatibility.map(Byte.TYPE, Byte.class);
        Compatibility.map(Short.TYPE, Short.class);
        Compatibility.map(Integer.TYPE, Integer.class);
        Compatibility.map(Long.TYPE, Long.class);
        Compatibility.map(Float.TYPE, Float.class);
        Compatibility.map(Double.TYPE, Double.class);
    }
}

