/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.from;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.from.OneToManyTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableJoin;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;
import org.hibernate.sql.ast.tree.from.VirtualTableGroup;

public class FromClause
implements SqlAstNode {
    private final List<TableGroup> roots;

    public FromClause() {
        this.roots = new ArrayList<TableGroup>();
    }

    public FromClause(int expectedNumberOfRoots) {
        this.roots = CollectionHelper.arrayList(expectedNumberOfRoots);
    }

    public List<TableGroup> getRoots() {
        return this.roots;
    }

    public void addRoot(TableGroup tableGroup) {
        this.roots.add(tableGroup);
    }

    public void visitRoots(Consumer<TableGroup> action) {
        this.roots.forEach(action);
    }

    public void visitTableGroups(Consumer<TableGroup> action) {
        this.queryTableGroups(tableGroup -> {
            action.accept((TableGroup)tableGroup);
            return null;
        });
    }

    public <T> T queryTableGroups(Function<TableGroup, T> action) {
        for (int i = 0; i < this.roots.size(); ++i) {
            T result = this.queryTableGroups(this.roots.get(i), action);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private <T> T queryTableGroups(TableGroup tableGroup, Function<TableGroup, T> action) {
        T result = action.apply(tableGroup);
        if (result != null) {
            return result;
        }
        List<TableGroupJoin> tableGroupJoins = tableGroup.getTableGroupJoins();
        for (int i = 0; i < tableGroupJoins.size(); ++i) {
            T nestedResult = this.queryTableGroups(tableGroupJoins.get(i).getJoinedGroup(), action);
            if (nestedResult == null) continue;
            return nestedResult;
        }
        List<TableGroupJoin> nestedTableGroupJoins = tableGroup.getNestedTableGroupJoins();
        for (int i = 0; i < nestedTableGroupJoins.size(); ++i) {
            T nestedResult = this.queryTableGroups(nestedTableGroupJoins.get(i).getJoinedGroup(), action);
            if (nestedResult == null) continue;
            return nestedResult;
        }
        return null;
    }

    public void visitTableJoins(Consumer<TableJoin> action) {
        this.queryTableJoins(tableGroupJoin -> {
            action.accept((TableJoin)tableGroupJoin);
            return null;
        });
    }

    public <T> T queryTableJoins(Function<TableJoin, T> action) {
        for (int i = 0; i < this.roots.size(); ++i) {
            T result = this.queryTableJoins(this.roots.get(i), action);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private <T> T queryTableJoins(TableGroup tableGroup, Function<TableJoin, T> action) {
        for (TableReferenceJoin tableReferenceJoin : tableGroup.getTableReferenceJoins()) {
            T result = action.apply(tableReferenceJoin);
            if (result == null) continue;
            return result;
        }
        T result = this.queryTableJoins(tableGroup.getTableGroupJoins(), action);
        if (result != null) {
            return result;
        }
        return this.queryTableJoins(tableGroup.getNestedTableGroupJoins(), action);
    }

    private <T> T queryTableJoins(List<TableGroupJoin> tableGroupJoins, Function<TableJoin, T> action) {
        for (int i = 0; i < tableGroupJoins.size(); ++i) {
            TableGroupJoin tableGroupJoin = tableGroupJoins.get(i);
            T result = action.apply(tableGroupJoin);
            if (result != null) {
                return result;
            }
            result = this.queryTableJoins(tableGroupJoin.getJoinedGroup(), action);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public void visitTableGroupJoins(Consumer<TableGroupJoin> action) {
        this.queryTableGroupJoins(tableGroupJoin -> {
            action.accept((TableGroupJoin)tableGroupJoin);
            return null;
        });
    }

    public <T> T queryTableGroupJoins(Function<TableGroupJoin, T> action) {
        for (int i = 0; i < this.roots.size(); ++i) {
            T result = this.queryTableGroupJoins(this.roots.get(i), action);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private <T> T queryTableGroupJoins(TableGroup tableGroup, Function<TableGroupJoin, T> action) {
        T result = this.queryTableGroupJoins(tableGroup.getTableGroupJoins(), action);
        if (result != null) {
            return result;
        }
        return this.queryTableGroupJoins(tableGroup.getNestedTableGroupJoins(), action);
    }

    private <T> T queryTableGroupJoins(List<TableGroupJoin> tableGroupJoins, Function<TableGroupJoin, T> action) {
        for (int i = 0; i < tableGroupJoins.size(); ++i) {
            TableGroupJoin tableGroupJoin = tableGroupJoins.get(i);
            T result = action.apply(tableGroupJoin);
            if (result != null) {
                return result;
            }
            result = this.queryTableGroupJoins(tableGroupJoin.getJoinedGroup(), action);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public void visitTableReferences(Consumer<TableReference> action) {
        this.queryTableReferences(tableGroupJoin -> {
            action.accept((TableReference)tableGroupJoin);
            return null;
        });
    }

    public <T> T queryTableReferences(Function<TableReference, T> action) {
        for (int i = 0; i < this.roots.size(); ++i) {
            T result = this.queryTableReferences(this.roots.get(i), action);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private <T> T queryTableReferences(TableGroup tableGroup, Function<TableReference, T> action) {
        T result = action.apply(tableGroup.getPrimaryTableReference());
        if (result != null) {
            return result;
        }
        for (TableReferenceJoin tableReferenceJoin : tableGroup.getTableReferenceJoins()) {
            T nestedResult = action.apply(tableReferenceJoin.getJoinedTableReference());
            if (nestedResult == null) continue;
            return nestedResult;
        }
        T nestedResult = this.queryTableReferences(tableGroup.getTableGroupJoins(), action);
        if (nestedResult != null) {
            return nestedResult;
        }
        return this.queryTableReferences(tableGroup.getNestedTableGroupJoins(), action);
    }

    private <T> T queryTableReferences(List<TableGroupJoin> tableGroupJoins, Function<TableReference, T> action) {
        for (int i = 0; i < tableGroupJoins.size(); ++i) {
            TableGroupJoin tableGroupJoin = tableGroupJoins.get(i);
            T result = this.queryTableReferences(tableGroupJoin.getJoinedGroup(), action);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public TableGroup findTableGroup(NavigablePath navigablePath) {
        return this.queryTableGroups(tg -> {
            if (navigablePath.equals(tg.getNavigablePath())) {
                return tg;
            }
            if (tg instanceof OneToManyTableGroup && tg.getNavigablePath().equals(navigablePath.getParent())) {
                return ((OneToManyTableGroup)tg).getTableGroup(CollectionPart.Nature.fromName(navigablePath.getLocalName()));
            }
            return null;
        });
    }

    @Override
    public void accept(SqlAstWalker sqlTreeWalker) {
        sqlTreeWalker.visitFromClause(this);
    }

    public boolean hasJoins() {
        for (int i = 0; i < this.roots.size(); ++i) {
            TableGroup tableGroup = this.roots.get(i);
            if (!tableGroup.getTableReferenceJoins().isEmpty()) {
                return true;
            }
            if (this.hasJoins(tableGroup.getTableGroupJoins())) {
                return true;
            }
            if (!this.hasJoins(tableGroup.getNestedTableGroupJoins())) continue;
            return true;
        }
        return false;
    }

    private boolean hasJoins(List<TableGroupJoin> tableGroupJoins) {
        for (TableGroupJoin tableGroupJoin : tableGroupJoins) {
            TableGroup joinedGroup = tableGroupJoin.getJoinedGroup();
            if (joinedGroup instanceof VirtualTableGroup) {
                if (this.hasJoins(joinedGroup.getTableGroupJoins())) {
                    return true;
                }
                if (!this.hasJoins(joinedGroup.getNestedTableGroupJoins())) continue;
                return true;
            }
            if (!joinedGroup.isInitialized()) continue;
            return true;
        }
        return false;
    }
}

