/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.converter.internal;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import org.hibernate.dialect.Dialect;
import org.hibernate.type.descriptor.converter.internal.EnumHelper;
import org.hibernate.type.descriptor.converter.spi.EnumValueConverter;
import org.hibernate.type.descriptor.java.AbstractClassJavaType;
import org.hibernate.type.descriptor.java.EnumJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public class NamedEnumValueConverter<E extends Enum<E>>
implements EnumValueConverter<E, Object>,
Serializable {
    private final EnumJavaType<E> domainTypeDescriptor;
    private final JdbcType jdbcType;
    private final JavaType<Object> relationalTypeDescriptor;

    public NamedEnumValueConverter(EnumJavaType<E> domainTypeDescriptor, JdbcType jdbcType, JavaType<?> relationalTypeDescriptor) {
        this.domainTypeDescriptor = domainTypeDescriptor;
        this.jdbcType = jdbcType;
        this.relationalTypeDescriptor = relationalTypeDescriptor;
    }

    @Override
    public EnumJavaType<E> getDomainJavaType() {
        return this.domainTypeDescriptor;
    }

    @Override
    public JavaType<Object> getRelationalJavaType() {
        return this.relationalTypeDescriptor;
    }

    @Override
    public E toDomainValue(Object relationalForm) {
        return relationalForm == null ? null : (E)this.domainTypeDescriptor.fromName(this.relationalTypeDescriptor.toString(relationalForm));
    }

    @Override
    public Object toRelationalValue(E domainForm) {
        String name = this.domainTypeDescriptor.toName(domainForm);
        return name == null ? null : this.relationalTypeDescriptor.fromString(name);
    }

    @Override
    public int getJdbcTypeCode() {
        return this.jdbcType.getDefaultSqlTypeCode();
    }

    @Override
    public String toSqlLiteral(Object value) {
        return String.format(Locale.ROOT, "'%s'", ((Enum)value).name());
    }

    @Override
    public String getCheckCondition(String columnName, JdbcType jdbcType, Dialect dialect) {
        return dialect.getCheckCondition(columnName, EnumHelper.getEnumeratedValues(((AbstractClassJavaType)this.getDomainJavaType()).getJavaTypeClass()));
    }

    @Override
    public String getSpecializedTypeDeclaration(JdbcType jdbcType, Dialect dialect) {
        Object[] values = EnumHelper.getEnumeratedValues(((AbstractClassJavaType)this.getDomainJavaType()).getJavaTypeClass());
        Arrays.sort(values);
        return dialect.getEnumTypeDeclaration((String[])values);
    }
}

