/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.internal;

import java.util.function.Supplier;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.metamodel.RepresentationMode;
import org.hibernate.metamodel.internal.EmbeddableCompositeUserTypeInstantiator;
import org.hibernate.metamodel.internal.EmbeddableInstantiatorPojoIndirecting;
import org.hibernate.metamodel.internal.EmbeddableInstantiatorRecordIndirecting;
import org.hibernate.metamodel.internal.EmbeddableInstantiatorRecordStandard;
import org.hibernate.metamodel.internal.EmbeddableRepresentationStrategyMap;
import org.hibernate.metamodel.internal.EmbeddableRepresentationStrategyPojo;
import org.hibernate.metamodel.internal.EntityRepresentationStrategyMap;
import org.hibernate.metamodel.internal.EntityRepresentationStrategyPojoStandard;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.spi.EmbeddableInstantiator;
import org.hibernate.metamodel.spi.EmbeddableRepresentationStrategy;
import org.hibernate.metamodel.spi.EntityRepresentationStrategy;
import org.hibernate.metamodel.spi.ManagedTypeRepresentationResolver;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.resource.beans.internal.FallbackBeanInstanceProducer;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;
import org.hibernate.usertype.CompositeUserType;

public class ManagedTypeRepresentationResolverStandard
implements ManagedTypeRepresentationResolver {
    public static final ManagedTypeRepresentationResolverStandard INSTANCE = new ManagedTypeRepresentationResolverStandard();

    @Override
    public EntityRepresentationStrategy resolveStrategy(PersistentClass bootDescriptor, EntityPersister runtimeDescriptor, RuntimeModelCreationContext creationContext) {
        RepresentationMode representation = null;
        if (representation == null) {
            representation = bootDescriptor.getMappedClass() == null ? RepresentationMode.MAP : RepresentationMode.POJO;
        }
        if (representation == RepresentationMode.MAP) {
            return new EntityRepresentationStrategyMap(bootDescriptor, creationContext);
        }
        return new EntityRepresentationStrategyPojoStandard(bootDescriptor, runtimeDescriptor, creationContext);
    }

    @Override
    public EmbeddableRepresentationStrategy resolveStrategy(Component bootDescriptor, Supplier<EmbeddableMappingType> runtimeDescriptorAccess, RuntimeModelCreationContext creationContext) {
        EmbeddableInstantiator customInstantiator;
        CompositeUserType compositeUserType;
        RepresentationMode representation = bootDescriptor.getComponentClassName() == null ? RepresentationMode.MAP : RepresentationMode.POJO;
        if (bootDescriptor.getTypeName() != null) {
            Class userTypeClass = creationContext.getBootstrapContext().getClassLoaderAccess().classForName(bootDescriptor.getTypeName());
            compositeUserType = !creationContext.getBootModel().getMetadataBuildingOptions().isAllowExtensionsInCdi() ? (CompositeUserType)FallbackBeanInstanceProducer.INSTANCE.produceBeanInstance(userTypeClass) : (CompositeUserType)creationContext.getBootstrapContext().getServiceRegistry().getService(ManagedBeanRegistry.class).getBean(userTypeClass).getBeanInstance();
        } else {
            compositeUserType = null;
        }
        if (bootDescriptor.getCustomInstantiator() != null) {
            Class<? extends EmbeddableInstantiator> instantiatorClass = bootDescriptor.getCustomInstantiator();
            customInstantiator = !creationContext.getBootModel().getMetadataBuildingOptions().isAllowExtensionsInCdi() ? FallbackBeanInstanceProducer.INSTANCE.produceBeanInstance(instantiatorClass) : creationContext.getBootstrapContext().getServiceRegistry().getService(ManagedBeanRegistry.class).getBean(instantiatorClass).getBeanInstance();
        } else if (compositeUserType != null) {
            customInstantiator = new EmbeddableCompositeUserTypeInstantiator(compositeUserType);
        } else if (bootDescriptor.getComponentClassName() != null && ReflectHelper.isRecord(bootDescriptor.getComponentClass())) {
            customInstantiator = bootDescriptor.sortProperties() == null ? new EmbeddableInstantiatorRecordStandard(bootDescriptor.getComponentClass()) : EmbeddableInstantiatorRecordIndirecting.of(bootDescriptor.getComponentClass(), bootDescriptor.getPropertyNames());
        } else if (bootDescriptor.getInstantiator() != null) {
            bootDescriptor.sortProperties();
            customInstantiator = EmbeddableInstantiatorPojoIndirecting.of(bootDescriptor.getPropertyNames(), bootDescriptor.getInstantiator(), bootDescriptor.getInstantiatorPropertyNames());
        } else {
            customInstantiator = null;
        }
        if (representation == RepresentationMode.MAP) {
            return new EmbeddableRepresentationStrategyMap(bootDescriptor, runtimeDescriptorAccess, customInstantiator, creationContext);
        }
        return new EmbeddableRepresentationStrategyPojo(bootDescriptor, runtimeDescriptorAccess, customInstantiator, compositeUserType, creationContext);
    }
}

