/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.ArrayList;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.ordering.ast.DomainPath;
import org.hibernate.metamodel.mapping.ordering.ast.OrderingExpression;
import org.hibernate.query.sqm.NullPrecedence;
import org.hibernate.query.sqm.SortOrder;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectClause;
import org.hibernate.sql.ast.tree.select.SortSpecification;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.internal.SqlSelectionImpl;

public abstract class AbstractDomainPath
implements DomainPath {
    public static final String ELEMENT_TOKEN = "$element$";

    @Override
    public SqlAstNode resolve(QuerySpec ast, TableGroup tableGroup, String modelPartName, SqlAstCreationState creationState) {
        return this.resolve(this.getReferenceModelPart(), ast, tableGroup, modelPartName, creationState);
    }

    public Expression resolve(ModelPart referenceModelPart, QuerySpec ast, TableGroup tableGroup, String modelPartName, SqlAstCreationState creationState) {
        if (referenceModelPart instanceof BasicValuedModelPart) {
            BasicValuedModelPart selection = (BasicValuedModelPart)referenceModelPart;
            TableReference tableReference = tableGroup.resolveTableReference(null, selection, selection.getContainingTableExpression());
            return creationState.getSqlExpressionResolver().resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, selection.getSelectionExpression(), selection.getJdbcMapping()), processingState -> new ColumnReference(tableReference, (SelectableMapping)selection));
        }
        if (referenceModelPart instanceof EntityValuedModelPart) {
            ModelPart subPart = ELEMENT_TOKEN.equals(modelPartName) ? ((EntityValuedModelPart)referenceModelPart).getEntityMappingType().getIdentifierMapping() : ((EntityValuedModelPart)referenceModelPart).findSubPart(modelPartName);
            return this.resolve(subPart, ast, tableGroup, modelPartName, creationState);
        }
        if (referenceModelPart instanceof EmbeddableValuedModelPart) {
            EmbeddableValuedModelPart embeddableValuedModelPart = (EmbeddableValuedModelPart)referenceModelPart;
            if (embeddableValuedModelPart.getFetchableName().equals(modelPartName) || ELEMENT_TOKEN.equals(modelPartName)) {
                int size = embeddableValuedModelPart.getNumberOfFetchables();
                ArrayList<Expression> expressions = new ArrayList<Expression>(size);
                for (int i = 0; i < size; ++i) {
                    Fetchable fetchable = embeddableValuedModelPart.getFetchable(i);
                    expressions.add(this.resolve(fetchable, ast, tableGroup, modelPartName, creationState));
                }
                return new SqlTuple(expressions, embeddableValuedModelPart);
            }
            ModelPart subPart = embeddableValuedModelPart.findSubPart(modelPartName, null);
            assert (subPart instanceof BasicValuedModelPart);
            return this.resolve(subPart, ast, tableGroup, modelPartName, creationState);
        }
        throw new UnsupportedOperationException("Ordering for " + referenceModelPart + " not supported");
    }

    @Override
    public void apply(QuerySpec ast, TableGroup tableGroup, String collation, String modelPartName, SortOrder sortOrder, NullPrecedence nullPrecedence, SqlAstCreationState creationState) {
        this.apply(this.getReferenceModelPart(), ast, tableGroup, collation, modelPartName, sortOrder, nullPrecedence, creationState);
    }

    public void apply(ModelPart referenceModelPart, QuerySpec ast, TableGroup tableGroup, String collation, String modelPartName, SortOrder sortOrder, NullPrecedence nullPrecedence, SqlAstCreationState creationState) {
        if (referenceModelPart instanceof BasicValuedModelPart) {
            this.addSortSpecification((BasicValuedModelPart)referenceModelPart, ast, tableGroup, collation, sortOrder, nullPrecedence, creationState);
        } else if (referenceModelPart instanceof EntityValuedModelPart) {
            ModelPart subPart = ELEMENT_TOKEN.equals(modelPartName) ? ((EntityValuedModelPart)referenceModelPart).getEntityMappingType().getIdentifierMapping() : ((EntityValuedModelPart)referenceModelPart).findSubPart("{fk}");
            this.apply(subPart, ast, tableGroup, collation, modelPartName, sortOrder, nullPrecedence, creationState);
        } else if (referenceModelPart instanceof EmbeddableValuedModelPart) {
            this.addSortSpecification((EmbeddableValuedModelPart)referenceModelPart, ast, tableGroup, collation, modelPartName, sortOrder, nullPrecedence, creationState);
        } else {
            throw new UnsupportedOperationException("Ordering for " + this.getReferenceModelPart() + " not supported");
        }
    }

    private void addSortSpecification(EmbeddableValuedModelPart embeddableValuedModelPart, QuerySpec ast, TableGroup tableGroup, String collation, String modelPartName, SortOrder sortOrder, NullPrecedence nullPrecedence, SqlAstCreationState creationState) {
        if (embeddableValuedModelPart.getFetchableName().equals(modelPartName) || ELEMENT_TOKEN.equals(modelPartName)) {
            embeddableValuedModelPart.forEachSelectable((columnIndex, selection) -> this.addSortSpecification(selection, ast, tableGroup, collation, sortOrder, nullPrecedence, creationState));
        } else {
            ModelPart subPart = embeddableValuedModelPart.findSubPart(modelPartName, null);
            assert (subPart instanceof BasicValuedModelPart);
            this.addSortSpecification((BasicValuedModelPart)subPart, ast, tableGroup, collation, sortOrder, nullPrecedence, creationState);
        }
    }

    private void addSortSpecification(SelectableMapping selection, QuerySpec ast, TableGroup tableGroup, String collation, SortOrder sortOrder, NullPrecedence nullPrecedence, SqlAstCreationState creationState) {
        SelectClause selectClause;
        TableReference tableReference = tableGroup.resolveTableReference(null, selection.getContainingTableExpression());
        Expression expression = creationState.getSqlExpressionResolver().resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, selection.getSelectionExpression(), selection.getJdbcMapping()), processingState -> new ColumnReference(tableReference, selection));
        if (ast.hasSortSpecifications()) {
            for (SortSpecification sortSpecification : ast.getSortSpecifications()) {
                if (sortSpecification.getSortExpression() != expression) continue;
                return;
            }
        }
        if ((selectClause = ast.getSelectClause()).isDistinct() && AbstractDomainPath.selectClauseDoesNotContainOrderExpression(expression, selectClause)) {
            int valuesArrayPosition = selectClause.getSqlSelections().size();
            SqlSelectionImpl sqlSelection = new SqlSelectionImpl(valuesArrayPosition, expression);
            selectClause.addSqlSelection(sqlSelection);
        }
        Expression sortExpression = OrderingExpression.applyCollation(expression, collation, creationState);
        ast.addSortSpecification(new SortSpecification(sortExpression, sortOrder, nullPrecedence));
    }

    private static boolean selectClauseDoesNotContainOrderExpression(Expression expression, SelectClause selectClause) {
        for (SqlSelection sqlSelection : selectClause.getSqlSelections()) {
            if (!sqlSelection.getExpression().equals(expression)) continue;
            return false;
        }
        return true;
    }
}

