/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.internal;

import java.util.List;
import java.util.Map;
import org.hibernate.action.internal.BulkOperationCleanupAction;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationHelper;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.spi.NonSelectQueryPlan;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.SqmJdbcExecutionContextAdapter;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.mutation.internal.SqmMutationStrategyHelper;
import org.hibernate.query.sqm.spi.SqmParameterMappingModelResolutionAccess;
import org.hibernate.query.sqm.sql.SqmTranslation;
import org.hibernate.query.sqm.sql.SqmTranslator;
import org.hibernate.query.sqm.sql.SqmTranslatorFactory;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.tree.delete.DeleteStatement;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.from.MutatingTableReferenceGroupWrapper;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.predicate.InSubQueryPredicate;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.exec.spi.JdbcOperationQueryDelete;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcParametersList;
import org.hibernate.sql.results.internal.SqlSelectionImpl;

public class SimpleDeleteQueryPlan
implements NonSelectQueryPlan {
    private final EntityMappingType entityDescriptor;
    private final SqmDeleteStatement<?> sqmDelete;
    private final DomainParameterXref domainParameterXref;
    private JdbcOperationQueryDelete jdbcDelete;
    private SqmTranslation<DeleteStatement> sqmInterpretation;
    private Map<QueryParameterImplementor<?>, Map<SqmParameter<?>, List<JdbcParametersList>>> jdbcParamsXref;

    public SimpleDeleteQueryPlan(EntityMappingType entityDescriptor, SqmDeleteStatement<?> sqmDelete, DomainParameterXref domainParameterXref) {
        assert (entityDescriptor.getEntityName().equals(((SqmRoot)sqmDelete.getTarget()).getEntityName()));
        this.entityDescriptor = entityDescriptor;
        this.sqmDelete = sqmDelete;
        this.domainParameterXref = domainParameterXref;
    }

    protected SqlAstTranslator<JdbcOperationQueryDelete> createDeleteTranslator(DomainQueryExecutionContext executionContext) {
        SessionFactoryImplementor factory = executionContext.getSession().getFactory();
        QueryEngine queryEngine = factory.getQueryEngine();
        SqmTranslatorFactory translatorFactory = queryEngine.getSqmTranslatorFactory();
        SqmTranslator<DeleteStatement> translator = translatorFactory.createSimpleDeleteTranslator(this.sqmDelete, executionContext.getQueryOptions(), this.domainParameterXref, executionContext.getQueryParameterBindings(), executionContext.getSession().getLoadQueryInfluencers(), factory);
        this.sqmInterpretation = translator.translate();
        this.jdbcParamsXref = SqmUtil.generateJdbcParamsXref(this.domainParameterXref, this.sqmInterpretation::getJdbcParamsBySqmParam);
        return factory.getJdbcServices().getJdbcEnvironment().getSqlAstTranslatorFactory().buildDeleteTranslator(factory, this.sqmInterpretation.getSqlAst());
    }

    @Override
    public int executeUpdate(DomainQueryExecutionContext executionContext) {
        boolean missingRestriction;
        BulkOperationCleanupAction.schedule(executionContext.getSession(), this.sqmDelete);
        SharedSessionContractImplementor session = executionContext.getSession();
        SessionFactoryImplementor factory = session.getFactory();
        JdbcServices jdbcServices = factory.getJdbcServices();
        SqlAstTranslator<JdbcOperationQueryDelete> deleteTranslator = null;
        if (this.jdbcDelete == null) {
            deleteTranslator = this.createDeleteTranslator(executionContext);
        }
        JdbcParameterBindings jdbcParameterBindings = SqmUtil.createJdbcParameterBindings(executionContext.getQueryParameterBindings(), this.domainParameterXref, this.jdbcParamsXref, factory.getRuntimeMetamodels().getMappingMetamodel(), this.sqmInterpretation.getFromClauseAccess()::findTableGroup, new SqmParameterMappingModelResolutionAccess(){

            @Override
            public <T> MappingModelExpressible<T> getResolvedMappingModelType(SqmParameter<T> parameter) {
                return SimpleDeleteQueryPlan.this.sqmInterpretation.getSqmParameterMappingModelTypeResolutions().get(parameter);
            }
        }, session);
        if (this.jdbcDelete != null && !this.jdbcDelete.isCompatibleWith(jdbcParameterBindings, executionContext.getQueryOptions())) {
            deleteTranslator = this.createDeleteTranslator(executionContext);
        }
        if (deleteTranslator != null) {
            this.jdbcDelete = deleteTranslator.translate(jdbcParameterBindings, executionContext.getQueryOptions());
        }
        boolean bl = missingRestriction = this.sqmInterpretation.getSqlAst().getRestriction() == null;
        if (missingRestriction) {
            assert (this.domainParameterXref.getSqmParameterCount() == 0);
            assert (this.jdbcParamsXref.isEmpty());
        }
        SqmJdbcExecutionContextAdapter executionContextAdapter = SqmJdbcExecutionContextAdapter.usingLockingAndPaging(executionContext);
        SqmMutationStrategyHelper.cleanUpCollectionTables(this.entityDescriptor, (tableReference, attributeMapping) -> {
            if (missingRestriction) {
                return null;
            }
            ForeignKeyDescriptor fkDescriptor = attributeMapping.getKeyDescriptor();
            Expression fkColumnExpression = MappingModelCreationHelper.buildColumnReferenceExpression(new MutatingTableReferenceGroupWrapper(new NavigablePath(attributeMapping.getRootPathName()), (ModelPartContainer)attributeMapping, (NamedTableReference)tableReference), fkDescriptor.getKeyPart(), null, factory);
            QuerySpec matchingIdSubQuery = new QuerySpec(false);
            MutatingTableReferenceGroupWrapper tableGroup = new MutatingTableReferenceGroupWrapper(new NavigablePath(attributeMapping.getRootPathName()), (ModelPartContainer)attributeMapping, this.sqmInterpretation.getSqlAst().getTargetTable());
            Expression fkTargetColumnExpression = MappingModelCreationHelper.buildColumnReferenceExpression(tableGroup, fkDescriptor.getTargetPart(), this.sqmInterpretation.getSqlExpressionResolver(), factory);
            matchingIdSubQuery.getSelectClause().addSqlSelection(new SqlSelectionImpl(1, 0, fkTargetColumnExpression));
            matchingIdSubQuery.getFromClause().addRoot(tableGroup);
            matchingIdSubQuery.applyPredicate(SqmMutationStrategyHelper.getIdSubqueryPredicate(this.sqmInterpretation.getSqlAst().getRestriction(), this.entityDescriptor, tableGroup, session));
            return new InSubQueryPredicate(fkColumnExpression, matchingIdSubQuery, false);
        }, missingRestriction ? JdbcParameterBindings.NO_BINDINGS : jdbcParameterBindings, executionContextAdapter);
        return jdbcServices.getJdbcMutationExecutor().execute(this.jdbcDelete, jdbcParameterBindings, sql -> session.getJdbcCoordinator().getStatementPreparer().prepareStatement((String)sql), (integer, preparedStatement) -> {}, executionContextAdapter);
    }
}

