/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.jdbc.internal;

import org.hibernate.dialect.Dialect;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.spi.BasicJdbcLiteralFormatter;

public class JdbcLiteralFormatterCharacterData<T>
extends BasicJdbcLiteralFormatter<T> {
    public static final String NATIONALIZED_PREFIX = "n";
    private final boolean isNationalized;

    public JdbcLiteralFormatterCharacterData(JavaType<T> javaType) {
        this(javaType, false);
    }

    public JdbcLiteralFormatterCharacterData(JavaType<T> javaType, boolean isNationalized) {
        super(javaType);
        this.isNationalized = isNationalized;
    }

    @Override
    public void appendJdbcLiteral(SqlAppender appender, Object value, Dialect dialect, WrapperOptions wrapperOptions) {
        String literalValue = this.unwrap(value, String.class, wrapperOptions);
        if (this.isNationalized) {
            appender.appendSql(NATIONALIZED_PREFIX);
        }
        dialect.appendLiteral(appender, literalValue);
    }
}

