
package org.hibernate.boot.jaxb.mapping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import jakarta.persistence.AccessType;
import jakarta.persistence.EnumType;
import jakarta.persistence.FetchType;
import jakarta.persistence.TemporalType;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.hibernate.annotations.OnDeleteAction;


/**
 * 
 * 
 *                 @Target({METHOD, FIELD}) @Retention(RUNTIME)
 *                 public @interface OneToMany {
 *                 Class targetEntity() default void.class;
 *                 CascadeType[] cascade() default {};
 *                 FetchType fetch() default LAZY;
 *                 String mappedBy() default "";
 *                 }
 * 
 *             
 * 
 * <p>Java class for one-to-many complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="one-to-many">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <choice>
 *           <element name="order-by" type="{http://www.hibernate.org/xsd/orm/mapping}order-by" minOccurs="0"/>
 *           <element name="order-column" type="{http://www.hibernate.org/xsd/orm/mapping}order-column" minOccurs="0"/>
 *           <element name="sort" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         </choice>
 *         <choice>
 *           <element name="map-key" type="{http://www.hibernate.org/xsd/orm/mapping}map-key" minOccurs="0"/>
 *           <sequence>
 *             <element name="map-key-class" type="{http://www.hibernate.org/xsd/orm/mapping}map-key-class" minOccurs="0"/>
 *             <choice>
 *               <element name="map-key-temporal" type="{http://www.hibernate.org/xsd/orm/mapping}temporal" minOccurs="0"/>
 *               <element name="map-key-enumerated" type="{http://www.hibernate.org/xsd/orm/mapping}enumerated" minOccurs="0"/>
 *               <sequence>
 *                 <element name="map-key-attribute-override" type="{http://www.hibernate.org/xsd/orm/mapping}attribute-override" maxOccurs="unbounded" minOccurs="0"/>
 *                 <element name="map-key-convert" type="{http://www.hibernate.org/xsd/orm/mapping}convert" maxOccurs="unbounded" minOccurs="0"/>
 *               </sequence>
 *             </choice>
 *             <choice>
 *               <element name="map-key-column" type="{http://www.hibernate.org/xsd/orm/mapping}map-key-column" minOccurs="0"/>
 *               <sequence>
 *                 <element name="map-key-join-column" type="{http://www.hibernate.org/xsd/orm/mapping}map-key-join-column" maxOccurs="unbounded" minOccurs="0"/>
 *                 <element name="map-key-foreign-key" type="{http://www.hibernate.org/xsd/orm/mapping}foreign-key" minOccurs="0"/>
 *               </sequence>
 *             </choice>
 *           </sequence>
 *         </choice>
 *         <choice>
 *           <element name="join-table" type="{http://www.hibernate.org/xsd/orm/mapping}join-table" minOccurs="0"/>
 *           <sequence>
 *             <element name="join-column" type="{http://www.hibernate.org/xsd/orm/mapping}join-column" maxOccurs="unbounded" minOccurs="0"/>
 *             <element name="foreign-key" type="{http://www.hibernate.org/xsd/orm/mapping}foreign-key" minOccurs="0"/>
 *           </sequence>
 *         </choice>
 *         <element name="cascade" type="{http://www.hibernate.org/xsd/orm/mapping}cascade-type" minOccurs="0"/>
 *         <element name="on-delete" type="{http://www.hibernate.org/xsd/orm/mapping}on-delete-type" minOccurs="0"/>
 *       </sequence>
 *       <attribute name="name" use="required" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       <attribute name="target-entity" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       <attribute name="fetch" type="{http://www.hibernate.org/xsd/orm/mapping}fetch-type" />
 *       <attribute name="fetch-mode" type="{http://www.hibernate.org/xsd/orm/mapping}plural-fetch-mode" />
 *       <attribute name="access" type="{http://www.hibernate.org/xsd/orm/mapping}access-type" />
 *       <attribute name="attribute-accessor" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       <attribute name="mapped-by" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       <attribute name="orphan-removal" type="{http://www.w3.org/2001/XMLSchema}boolean" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "one-to-many", namespace = "http://www.hibernate.org/xsd/orm/mapping", propOrder = {
    "orderBy",
    "orderColumn",
    "sort",
    "mapKey",
    "mapKeyClass",
    "mapKeyTemporal",
    "mapKeyEnumerated",
    "mapKeyAttributeOverride",
    "mapKeyConvert",
    "mapKeyColumn",
    "mapKeyJoinColumn",
    "mapKeyForeignKey",
    "joinTable",
    "joinColumn",
    "foreignKey",
    "cascade",
    "onDelete"
})
public class JaxbOneToMany
    implements Serializable, AssociationAttribute, CollectionAttribute
{

    @XmlElement(name = "order-by", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected String orderBy;
    @XmlElement(name = "order-column", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected JaxbOrderColumn orderColumn;
    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected String sort;
    @XmlElement(name = "map-key", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected JaxbMapKey mapKey;
    @XmlElement(name = "map-key-class", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected JaxbMapKeyClass mapKeyClass;
    @XmlElement(name = "map-key-temporal", namespace = "http://www.hibernate.org/xsd/orm/mapping", type = String.class)
    @XmlJavaTypeAdapter(Adapter13 .class)
    @XmlSchemaType(name = "token")
    protected TemporalType mapKeyTemporal;
    @XmlElement(name = "map-key-enumerated", namespace = "http://www.hibernate.org/xsd/orm/mapping", type = String.class)
    @XmlJavaTypeAdapter(Adapter7 .class)
    @XmlSchemaType(name = "token")
    protected EnumType mapKeyEnumerated;
    @XmlElement(name = "map-key-attribute-override", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected List<JaxbAttributeOverride> mapKeyAttributeOverride;
    @XmlElement(name = "map-key-convert", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected List<JaxbConvert> mapKeyConvert;
    @XmlElement(name = "map-key-column", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected JaxbMapKeyColumn mapKeyColumn;
    @XmlElement(name = "map-key-join-column", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected List<JaxbMapKeyJoinColumn> mapKeyJoinColumn;
    @XmlElement(name = "map-key-foreign-key", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected JaxbForeignKey mapKeyForeignKey;
    @XmlElement(name = "join-table", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected JaxbJoinTable joinTable;
    @XmlElement(name = "join-column", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected List<JaxbJoinColumn> joinColumn;
    @XmlElement(name = "foreign-key", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected JaxbForeignKey foreignKey;
    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected JaxbCascadeType cascade;
    @XmlElement(name = "on-delete", namespace = "http://www.hibernate.org/xsd/orm/mapping", type = String.class)
    @XmlJavaTypeAdapter(Adapter17 .class)
    @XmlSchemaType(name = "token")
    protected OnDeleteAction onDelete;
    @XmlAttribute(name = "name", required = true)
    protected String name;
    @XmlAttribute(name = "target-entity")
    protected String targetEntity;
    @XmlAttribute(name = "fetch")
    @XmlJavaTypeAdapter(Adapter8 .class)
    protected FetchType fetch;
    @XmlAttribute(name = "fetch-mode")
    protected JaxbPluralFetchMode fetchMode;
    @XmlAttribute(name = "access")
    @XmlJavaTypeAdapter(Adapter1 .class)
    protected AccessType access;
    @XmlAttribute(name = "attribute-accessor")
    protected String attributeAccessor;
    @XmlAttribute(name = "mapped-by")
    protected String mappedBy;
    @XmlAttribute(name = "orphan-removal")
    protected Boolean orphanRemoval;

    /**
     * Gets the value of the orderBy property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getOrderBy() {
        return orderBy;
    }

    /**
     * Sets the value of the orderBy property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setOrderBy(String value) {
        this.orderBy = value;
    }

    /**
     * Gets the value of the orderColumn property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbOrderColumn }
     *     
     */
    public JaxbOrderColumn getOrderColumn() {
        return orderColumn;
    }

    /**
     * Sets the value of the orderColumn property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbOrderColumn }
     *     
     */
    public void setOrderColumn(JaxbOrderColumn value) {
        this.orderColumn = value;
    }

    /**
     * Gets the value of the sort property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getSort() {
        return sort;
    }

    /**
     * Sets the value of the sort property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setSort(String value) {
        this.sort = value;
    }

    /**
     * Gets the value of the mapKey property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbMapKey }
     *     
     */
    public JaxbMapKey getMapKey() {
        return mapKey;
    }

    /**
     * Sets the value of the mapKey property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbMapKey }
     *     
     */
    public void setMapKey(JaxbMapKey value) {
        this.mapKey = value;
    }

    /**
     * Gets the value of the mapKeyClass property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbMapKeyClass }
     *     
     */
    public JaxbMapKeyClass getMapKeyClass() {
        return mapKeyClass;
    }

    /**
     * Sets the value of the mapKeyClass property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbMapKeyClass }
     *     
     */
    public void setMapKeyClass(JaxbMapKeyClass value) {
        this.mapKeyClass = value;
    }

    /**
     * Gets the value of the mapKeyTemporal property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public TemporalType getMapKeyTemporal() {
        return mapKeyTemporal;
    }

    /**
     * Sets the value of the mapKeyTemporal property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setMapKeyTemporal(TemporalType value) {
        this.mapKeyTemporal = value;
    }

    /**
     * Gets the value of the mapKeyEnumerated property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public EnumType getMapKeyEnumerated() {
        return mapKeyEnumerated;
    }

    /**
     * Sets the value of the mapKeyEnumerated property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setMapKeyEnumerated(EnumType value) {
        this.mapKeyEnumerated = value;
    }

    /**
     * Gets the value of the mapKeyAttributeOverride property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the mapKeyAttributeOverride property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getMapKeyAttributeOverride().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbAttributeOverride }
     * 
     * 
     * @return
     *     The value of the mapKeyAttributeOverride property.
     */
    public List<JaxbAttributeOverride> getMapKeyAttributeOverride() {
        if (mapKeyAttributeOverride == null) {
            mapKeyAttributeOverride = new ArrayList<>();
        }
        return this.mapKeyAttributeOverride;
    }

    /**
     * Gets the value of the mapKeyConvert property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the mapKeyConvert property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getMapKeyConvert().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbConvert }
     * 
     * 
     * @return
     *     The value of the mapKeyConvert property.
     */
    public List<JaxbConvert> getMapKeyConvert() {
        if (mapKeyConvert == null) {
            mapKeyConvert = new ArrayList<>();
        }
        return this.mapKeyConvert;
    }

    /**
     * Gets the value of the mapKeyColumn property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbMapKeyColumn }
     *     
     */
    public JaxbMapKeyColumn getMapKeyColumn() {
        return mapKeyColumn;
    }

    /**
     * Sets the value of the mapKeyColumn property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbMapKeyColumn }
     *     
     */
    public void setMapKeyColumn(JaxbMapKeyColumn value) {
        this.mapKeyColumn = value;
    }

    /**
     * Gets the value of the mapKeyJoinColumn property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the mapKeyJoinColumn property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getMapKeyJoinColumn().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbMapKeyJoinColumn }
     * 
     * 
     * @return
     *     The value of the mapKeyJoinColumn property.
     */
    public List<JaxbMapKeyJoinColumn> getMapKeyJoinColumn() {
        if (mapKeyJoinColumn == null) {
            mapKeyJoinColumn = new ArrayList<>();
        }
        return this.mapKeyJoinColumn;
    }

    /**
     * Gets the value of the mapKeyForeignKey property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbForeignKey }
     *     
     */
    public JaxbForeignKey getMapKeyForeignKey() {
        return mapKeyForeignKey;
    }

    /**
     * Sets the value of the mapKeyForeignKey property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbForeignKey }
     *     
     */
    public void setMapKeyForeignKey(JaxbForeignKey value) {
        this.mapKeyForeignKey = value;
    }

    /**
     * Gets the value of the joinTable property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbJoinTable }
     *     
     */
    public JaxbJoinTable getJoinTable() {
        return joinTable;
    }

    /**
     * Sets the value of the joinTable property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbJoinTable }
     *     
     */
    public void setJoinTable(JaxbJoinTable value) {
        this.joinTable = value;
    }

    /**
     * Gets the value of the joinColumn property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the joinColumn property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getJoinColumn().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbJoinColumn }
     * 
     * 
     * @return
     *     The value of the joinColumn property.
     */
    public List<JaxbJoinColumn> getJoinColumn() {
        if (joinColumn == null) {
            joinColumn = new ArrayList<>();
        }
        return this.joinColumn;
    }

    /**
     * Gets the value of the foreignKey property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbForeignKey }
     *     
     */
    public JaxbForeignKey getForeignKey() {
        return foreignKey;
    }

    /**
     * Sets the value of the foreignKey property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbForeignKey }
     *     
     */
    public void setForeignKey(JaxbForeignKey value) {
        this.foreignKey = value;
    }

    /**
     * Gets the value of the cascade property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbCascadeType }
     *     
     */
    public JaxbCascadeType getCascade() {
        return cascade;
    }

    /**
     * Sets the value of the cascade property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbCascadeType }
     *     
     */
    public void setCascade(JaxbCascadeType value) {
        this.cascade = value;
    }

    /**
     * Gets the value of the onDelete property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public OnDeleteAction getOnDelete() {
        return onDelete;
    }

    /**
     * Sets the value of the onDelete property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setOnDelete(OnDeleteAction value) {
        this.onDelete = value;
    }

    /**
     * Gets the value of the name property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getName() {
        return name;
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setName(String value) {
        this.name = value;
    }

    /**
     * Gets the value of the targetEntity property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getTargetEntity() {
        return targetEntity;
    }

    /**
     * Sets the value of the targetEntity property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTargetEntity(String value) {
        this.targetEntity = value;
    }

    /**
     * Gets the value of the fetch property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public FetchType getFetch() {
        return fetch;
    }

    /**
     * Sets the value of the fetch property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setFetch(FetchType value) {
        this.fetch = value;
    }

    /**
     * Gets the value of the fetchMode property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbPluralFetchMode }
     *     
     */
    public JaxbPluralFetchMode getFetchMode() {
        return fetchMode;
    }

    /**
     * Sets the value of the fetchMode property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbPluralFetchMode }
     *     
     */
    public void setFetchMode(JaxbPluralFetchMode value) {
        this.fetchMode = value;
    }

    /**
     * Gets the value of the access property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public AccessType getAccess() {
        return access;
    }

    /**
     * Sets the value of the access property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAccess(AccessType value) {
        this.access = value;
    }

    /**
     * Gets the value of the attributeAccessor property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAttributeAccessor() {
        return attributeAccessor;
    }

    /**
     * Sets the value of the attributeAccessor property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAttributeAccessor(String value) {
        this.attributeAccessor = value;
    }

    /**
     * Gets the value of the mappedBy property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getMappedBy() {
        return mappedBy;
    }

    /**
     * Sets the value of the mappedBy property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setMappedBy(String value) {
        this.mappedBy = value;
    }

    /**
     * Gets the value of the orphanRemoval property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean isOrphanRemoval() {
        return orphanRemoval;
    }

    /**
     * Sets the value of the orphanRemoval property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setOrphanRemoval(Boolean value) {
        this.orphanRemoval = value;
    }

}
