/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.from;

import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.SqlAstTreeHelper;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.TableJoin;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.predicate.PredicateContainer;

public class TableReferenceJoin
implements TableJoin,
PredicateContainer {
    private final boolean innerJoin;
    private final NamedTableReference joinedTableBinding;
    private Predicate predicate;

    public TableReferenceJoin(boolean innerJoin, NamedTableReference joinedTableBinding, Predicate predicate) {
        this.innerJoin = innerJoin;
        this.joinedTableBinding = joinedTableBinding;
        this.predicate = predicate;
    }

    @Override
    public SqlAstJoinType getJoinType() {
        return this.innerJoin ? SqlAstJoinType.INNER : SqlAstJoinType.LEFT;
    }

    public NamedTableReference getJoinedTableReference() {
        return this.joinedTableBinding;
    }

    @Override
    public SqlAstNode getJoinedNode() {
        return this.joinedTableBinding;
    }

    @Override
    public Predicate getPredicate() {
        return this.predicate;
    }

    @Override
    public void accept(SqlAstWalker sqlTreeWalker) {
        sqlTreeWalker.visitTableReferenceJoin(this);
    }

    public String toString() {
        return this.getJoinType().getText() + " join " + this.getJoinedTableReference().toString();
    }

    @Override
    public boolean isInitialized() {
        return true;
    }

    @Override
    public void applyPredicate(Predicate newPredicate) {
        this.predicate = SqlAstTreeHelper.combinePredicates(this.predicate, newPredicate);
    }
}

