/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import java.lang.reflect.Array;
import org.hibernate.LockOptions;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.SubselectFetch;
import org.hibernate.loader.ast.internal.AbstractCollectionBatchLoader;
import org.hibernate.loader.ast.internal.ExecutionContextWithSubselectFetchHandler;
import org.hibernate.loader.ast.internal.LoaderSelectBuilder;
import org.hibernate.loader.ast.internal.MultiKeyLoadHelper;
import org.hibernate.loader.ast.internal.MultiKeyLoadLogging;
import org.hibernate.loader.ast.spi.CollectionBatchLoader;
import org.hibernate.loader.ast.spi.SqlArrayMultiKeyLoader;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.JdbcParameterBindingImpl;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.internal.JdbcParameterImpl;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcParametersList;
import org.hibernate.sql.results.internal.RowTransformerStandardImpl;
import org.hibernate.sql.results.spi.ListResultsConsumer;
import org.hibernate.type.BasicType;

public class CollectionBatchLoaderArrayParam
extends AbstractCollectionBatchLoader
implements CollectionBatchLoader,
SqlArrayMultiKeyLoader {
    private final Class<?> arrayElementType;
    private final JdbcMapping arrayJdbcMapping;
    private final JdbcParameter jdbcParameter;
    private final SelectStatement sqlSelect;
    private final JdbcOperationQuerySelect jdbcSelectOperation;

    public CollectionBatchLoaderArrayParam(int domainBatchSize, LoadQueryInfluencers loadQueryInfluencers, PluralAttributeMapping attributeMapping, SessionFactoryImplementor sessionFactory) {
        super(domainBatchSize, loadQueryInfluencers, attributeMapping, sessionFactory);
        if (MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.isDebugEnabled()) {
            MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.debugf("Using ARRAY batch fetching strategy for collection `%s` : %s", (Object)attributeMapping.getNavigableRole().getFullPath(), (Object)domainBatchSize);
        }
        ForeignKeyDescriptor keyDescriptor = this.getLoadable().getKeyDescriptor();
        this.arrayElementType = keyDescriptor.getJavaType().getJavaTypeClass();
        Class<?> arrayClass = Array.newInstance(this.arrayElementType, 0).getClass();
        BasicType<?> arrayBasicType = this.getSessionFactory().getTypeConfiguration().getBasicTypeRegistry().getRegisteredType(arrayClass);
        this.arrayJdbcMapping = MultiKeyLoadHelper.resolveArrayJdbcMapping(arrayBasicType, keyDescriptor.getSingleJdbcMapping(), arrayClass, this.getSessionFactory());
        this.jdbcParameter = new JdbcParameterImpl(this.arrayJdbcMapping);
        this.sqlSelect = LoaderSelectBuilder.createSelectBySingleArrayParameter(this.getLoadable(), keyDescriptor.getKeyPart(), this.getInfluencers(), LockOptions.NONE, this.jdbcParameter, this.getSessionFactory());
        this.jdbcSelectOperation = this.getSessionFactory().getJdbcServices().getJdbcEnvironment().getSqlAstTranslatorFactory().buildSelectTranslator(this.getSessionFactory(), this.sqlSelect).translate(JdbcParameterBindings.NO_BINDINGS, QueryOptions.NONE);
    }

    @Override
    public PersistentCollection<?> load(Object key, SharedSessionContractImplementor session) {
        ForeignKeyDescriptor keyDescriptor;
        if (MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.isDebugEnabled()) {
            MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.debugf("Batch loading entity `%s#%s`", (Object)this.getLoadable().getNavigableRole().getFullPath(), key);
        }
        if ((keyDescriptor = this.getLoadable().getKeyDescriptor()).isEmbedded()) {
            assert (keyDescriptor.getJdbcTypeCount() == 1);
            return this.loadEmbeddable(key, session, keyDescriptor);
        }
        Object[] keysToInitialize = this.resolveKeysToInitialize(key, session);
        this.initializeKeys(keysToInitialize, session);
        for (int i = 0; i < keysToInitialize.length; ++i) {
            this.finishInitializingKey(keysToInitialize[i], session);
        }
        CollectionKey collectionKey = new CollectionKey(this.getLoadable().getCollectionDescriptor(), key);
        return session.getPersistenceContext().getCollection(collectionKey);
    }

    private PersistentCollection<?> loadEmbeddable(Object keyBeingLoaded, SharedSessionContractImplementor session, ForeignKeyDescriptor keyDescriptor) {
        int length = this.getDomainBatchSize();
        Object[] keysToInitialize = (Object[])Array.newInstance(keyDescriptor.getSingleJdbcMapping().getJdbcJavaType().getJavaTypeClass(), length);
        Object[] embeddedKeys = (Object[])Array.newInstance(this.arrayElementType, length);
        session.getPersistenceContextInternal().getBatchFetchQueue().collectBatchLoadableCollectionKeys(length, (index, key) -> keyDescriptor.forEachJdbcValue(key, (i, value, jdbcMapping) -> {
            keysToInitialize[index] = value;
            embeddedKeys[index] = key;
        }, session), keyBeingLoaded, this.getLoadable());
        this.initializeKeys(keysToInitialize, session);
        for (Object initializedKey : embeddedKeys) {
            this.finishInitializingKey(initializedKey, session);
        }
        CollectionKey collectionKey = new CollectionKey(this.getLoadable().getCollectionDescriptor(), keysToInitialize);
        return session.getPersistenceContext().getCollection(collectionKey);
    }

    private Object[] resolveKeysToInitialize(Object keyBeingLoaded, SharedSessionContractImplementor session) {
        Object[] keysToInitialize = (Object[])Array.newInstance(this.arrayElementType, this.getDomainBatchSize());
        session.getPersistenceContextInternal().getBatchFetchQueue().collectBatchLoadableCollectionKeys(this.getDomainBatchSize(), (index, value) -> {
            keysToInitialize[index] = value;
        }, keyBeingLoaded, this.getLoadable());
        return keysToInitialize;
    }

    private void initializeKeys(Object[] keysToInitialize, SharedSessionContractImplementor session) {
        assert (this.jdbcSelectOperation != null);
        assert (this.jdbcParameter != null);
        JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl(1);
        jdbcParameterBindings.addBinding(this.jdbcParameter, new JdbcParameterBindingImpl(this.arrayJdbcMapping, keysToInitialize));
        SubselectFetch.RegistrationHandler subSelectFetchableKeysHandler = SubselectFetch.createRegistrationHandler(session.getPersistenceContext().getBatchFetchQueue(), this.sqlSelect, JdbcParametersList.singleton(this.jdbcParameter), jdbcParameterBindings);
        session.getJdbcServices().getJdbcSelectExecutor().list(this.jdbcSelectOperation, jdbcParameterBindings, new ExecutionContextWithSubselectFetchHandler(session, subSelectFetchableKeysHandler), RowTransformerStandardImpl.instance(), ListResultsConsumer.UniqueSemantic.FILTER);
    }

    public void prepare() {
    }
}

