/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.env.internal;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Map;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.jdbc.connections.spi.JdbcConnectionAccess;
import org.hibernate.engine.jdbc.connections.spi.MultiTenantConnectionProvider;
import org.hibernate.engine.jdbc.dialect.spi.DialectFactory;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.env.internal.JdbcEnvironmentImpl;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.log.DeprecationLogger;
import org.hibernate.internal.util.NullnessHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.jboss.logging.Logger;

public class JdbcEnvironmentInitiator
implements StandardServiceInitiator<JdbcEnvironment> {
    private static final CoreMessageLogger log = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)JdbcEnvironmentInitiator.class.getName());
    public static final JdbcEnvironmentInitiator INSTANCE = new JdbcEnvironmentInitiator();

    @Override
    public Class<JdbcEnvironment> getServiceInitiated() {
        return JdbcEnvironment.class;
    }

    @Override
    public JdbcEnvironment initiateService(Map<String, Object> configurationValues, ServiceRegistryImplementor registry) {
        DialectFactory dialectFactory = registry.getService(DialectFactory.class);
        String explicitDatabaseName = JdbcEnvironmentInitiator.getExplicitDatabaseName(configurationValues);
        Integer explicitDatabaseMajorVersion = JdbcEnvironmentInitiator.getExplicitDatabaseMajorVersion(configurationValues);
        Integer explicitDatabaseMinorVersion = JdbcEnvironmentInitiator.getExplicitDatabaseMinorVersion(configurationValues);
        String explicitDatabaseVersion = JdbcEnvironmentInitiator.getExplicitDatabaseVersion(configurationValues, explicitDatabaseMajorVersion, explicitDatabaseMinorVersion);
        if (explicitDatabaseMajorVersion == null && explicitDatabaseMinorVersion == null && explicitDatabaseVersion != null) {
            String[] parts = explicitDatabaseVersion.split("\\.");
            try {
                int potentialMajor = Integer.parseInt(parts[0]);
                if (parts.length > 1) {
                    explicitDatabaseMinorVersion = Integer.parseInt(parts[1]);
                }
                explicitDatabaseMajorVersion = potentialMajor;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (JdbcEnvironmentInitiator.useJdbcMetadata(configurationValues)) {
            return this.getJdbcEnvironmentUsingJdbcMetadata(configurationValues, registry, dialectFactory, explicitDatabaseName, explicitDatabaseMajorVersion, explicitDatabaseMinorVersion, explicitDatabaseVersion);
        }
        if (JdbcEnvironmentInitiator.explicitDialectConfiguration(configurationValues, explicitDatabaseName, explicitDatabaseMajorVersion, explicitDatabaseMinorVersion, explicitDatabaseVersion)) {
            return JdbcEnvironmentInitiator.getJdbcEnvironmentWithExplicitConfiguration(configurationValues, registry, dialectFactory, explicitDatabaseName, explicitDatabaseMajorVersion, explicitDatabaseMinorVersion, explicitDatabaseVersion);
        }
        return JdbcEnvironmentInitiator.getJdbcEnvironmentWithDefaults(configurationValues, registry, dialectFactory);
    }

    private static JdbcEnvironmentImpl getJdbcEnvironmentWithDefaults(Map<String, Object> configurationValues, ServiceRegistryImplementor registry, DialectFactory dialectFactory) {
        return new JdbcEnvironmentImpl(registry, dialectFactory.buildDialect(configurationValues, null));
    }

    private static JdbcEnvironmentImpl getJdbcEnvironmentWithExplicitConfiguration(Map<String, Object> configurationValues, ServiceRegistryImplementor registry, DialectFactory dialectFactory, String explicitDatabaseName, Integer explicitDatabaseMajorVersion, Integer explicitDatabaseMinorVersion, String explicitDatabaseVersion) {
        DialectResolutionInfoImpl dialectResolutionInfo = new DialectResolutionInfoImpl(null, explicitDatabaseName, explicitDatabaseVersion != null ? explicitDatabaseVersion : "0", explicitDatabaseMajorVersion != null ? explicitDatabaseMajorVersion : 0, explicitDatabaseMinorVersion != null ? explicitDatabaseMinorVersion : 0, null, 0, 0, null);
        return new JdbcEnvironmentImpl(registry, dialectFactory.buildDialect(configurationValues, () -> dialectResolutionInfo));
    }

    private static boolean useJdbcMetadata(Map<String, Object> configurationValues) {
        return ConfigurationHelper.getBoolean("hibernate.temp.use_jdbc_metadata_defaults", configurationValues, true);
    }

    private static String getExplicitDatabaseVersion(Map<String, Object> configurationValues, Integer configuredDatabaseMajorVersion, Integer configuredDatabaseMinorVersion) {
        return (String)NullnessHelper.coalesceSuppliedValues(() -> (String)configurationValues.get("jakarta.persistence.database-product-version"), () -> {
            Object value = configurationValues.get("javax.persistence.database-product-version");
            if (value != null) {
                DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.database-product-version", "jakarta.persistence.database-product-version");
            }
            return (String)value;
        }, () -> {
            if (configuredDatabaseMajorVersion != null) {
                return configuredDatabaseMinorVersion == null ? configuredDatabaseMajorVersion.toString() : configuredDatabaseMajorVersion + "." + configuredDatabaseMinorVersion;
            }
            return null;
        });
    }

    private static Integer getExplicitDatabaseMinorVersion(Map<String, Object> configurationValues) {
        return (Integer)NullnessHelper.coalesceSuppliedValues(() -> ConfigurationHelper.getInteger("jakarta.persistence.database-minor-version", configurationValues), () -> {
            Integer value = ConfigurationHelper.getInteger("javax.persistence.database-minor-version", configurationValues);
            if (value != null) {
                DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.database-minor-version", "jakarta.persistence.database-minor-version");
            }
            return value;
        });
    }

    private static Integer getExplicitDatabaseMajorVersion(Map<String, Object> configurationValues) {
        return (Integer)NullnessHelper.coalesceSuppliedValues(() -> ConfigurationHelper.getInteger("jakarta.persistence.database-major-version", configurationValues), () -> {
            Integer value = ConfigurationHelper.getInteger("javax.persistence.database-major-version", configurationValues);
            if (value != null) {
                DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.database-major-version", "jakarta.persistence.database-major-version");
            }
            return value;
        });
    }

    private static String getExplicitDatabaseName(Map<String, Object> configurationValues) {
        return (String)NullnessHelper.coalesceSuppliedValues(() -> (String)configurationValues.get("jakarta.persistence.database-product-name"), () -> {
            Object value = configurationValues.get("javax.persistence.database-product-name");
            if (value != null) {
                DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.database-product-name", "jakarta.persistence.database-product-name");
            }
            return (String)value;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JdbcEnvironmentImpl getJdbcEnvironmentUsingJdbcMetadata(Map<String, Object> configurationValues, ServiceRegistryImplementor registry, DialectFactory dialectFactory, String explicitDatabaseName, Integer explicitDatabaseMajorVersion, Integer explicitDatabaseMinorVersion, String explicitDatabaseVersion) {
        JdbcConnectionAccess jdbcConnectionAccess = this.buildJdbcConnectionAccess(registry);
        try {
            Connection connection = jdbcConnectionAccess.obtainConnection();
            try {
                DatabaseMetaData dbmd = connection.getMetaData();
                JdbcEnvironmentInitiator.logDatabaseAndDriver(dbmd);
                String databaseName = explicitDatabaseName == null ? dbmd.getDatabaseProductName() : explicitDatabaseName;
                String databaseVersion = explicitDatabaseVersion == null ? dbmd.getDatabaseProductVersion() : explicitDatabaseVersion;
                int databaseMajorVersion = explicitDatabaseMajorVersion == null ? dbmd.getDatabaseMajorVersion() : explicitDatabaseMajorVersion.intValue();
                int databaseMinorVersion = explicitDatabaseMinorVersion == null ? dbmd.getDatabaseMinorVersion() : explicitDatabaseMinorVersion.intValue();
                DialectResolutionInfoImpl dialectResolutionInfo = new DialectResolutionInfoImpl(dbmd, databaseName, databaseVersion, databaseMajorVersion, databaseMinorVersion, dbmd.getDriverName(), dbmd.getDriverMajorVersion(), dbmd.getDriverMinorVersion(), dbmd.getSQLKeywords());
                JdbcEnvironmentImpl jdbcEnvironmentImpl = new JdbcEnvironmentImpl(registry, dialectFactory.buildDialect(configurationValues, () -> dialectResolutionInfo), dbmd, jdbcConnectionAccess);
                return jdbcEnvironmentImpl;
            }
            catch (SQLException e) {
                log.unableToObtainConnectionMetadata(e);
                return JdbcEnvironmentInitiator.getJdbcEnvironmentWithDefaults(configurationValues, registry, dialectFactory);
            }
            finally {
                try {
                    jdbcConnectionAccess.releaseConnection(connection);
                }
                catch (SQLException sQLException) {}
            }
        }
        catch (Exception e2) {
            log.unableToObtainConnectionToQueryMetadata(e2);
        }
        return JdbcEnvironmentInitiator.getJdbcEnvironmentWithDefaults(configurationValues, registry, dialectFactory);
    }

    private static void logDatabaseAndDriver(DatabaseMetaData dbmd) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debugf("Database ->\n       name : %s\n    version : %s\n      major : %s\n      minor : %s", new Object[]{dbmd.getDatabaseProductName(), dbmd.getDatabaseProductVersion(), dbmd.getDatabaseMajorVersion(), dbmd.getDatabaseMinorVersion()});
            log.debugf("Driver ->\n       name : %s\n    version : %s\n      major : %s\n      minor : %s", new Object[]{dbmd.getDriverName(), dbmd.getDriverVersion(), dbmd.getDriverMajorVersion(), dbmd.getDriverMinorVersion()});
            log.debugf("JDBC version : %s.%s", dbmd.getJDBCMajorVersion(), dbmd.getJDBCMinorVersion());
        }
    }

    private static boolean explicitDialectConfiguration(Map<String, Object> configurationValues, String explicitDatabaseName, Integer explicitDatabaseMajorVersion, Integer explicitDatabaseMinorVersion, String explicitDatabaseVersion) {
        return !(!StringHelper.isNotEmpty(explicitDatabaseVersion) && explicitDatabaseMajorVersion == null && explicitDatabaseMinorVersion == null || !StringHelper.isNotEmpty(explicitDatabaseName) && !JdbcEnvironmentInitiator.isNotNullAndNotEmpty(configurationValues.get("hibernate.dialect")));
    }

    private static boolean isNotNullAndNotEmpty(Object o) {
        return o != null && (!(o instanceof String) || !((String)o).isEmpty());
    }

    private JdbcConnectionAccess buildJdbcConnectionAccess(ServiceRegistryImplementor registry) {
        if (!JdbcEnvironmentImpl.isMultiTenancyEnabled(registry)) {
            ConnectionProvider connectionProvider = registry.getService(ConnectionProvider.class);
            return new ConnectionProviderJdbcConnectionAccess(connectionProvider);
        }
        MultiTenantConnectionProvider multiTenantConnectionProvider = registry.getService(MultiTenantConnectionProvider.class);
        return new MultiTenantConnectionProviderJdbcConnectionAccess(multiTenantConnectionProvider);
    }

    public static JdbcConnectionAccess buildBootstrapJdbcConnectionAccess(ServiceRegistryImplementor registry) {
        if (!JdbcEnvironmentImpl.isMultiTenancyEnabled(registry)) {
            ConnectionProvider connectionProvider = registry.getService(ConnectionProvider.class);
            return new ConnectionProviderJdbcConnectionAccess(connectionProvider);
        }
        MultiTenantConnectionProvider multiTenantConnectionProvider = registry.getService(MultiTenantConnectionProvider.class);
        return new MultiTenantConnectionProviderJdbcConnectionAccess(multiTenantConnectionProvider);
    }

    private static class DialectResolutionInfoImpl
    implements DialectResolutionInfo {
        private final DatabaseMetaData databaseMetadata;
        private final String databaseName;
        private final String databaseVersion;
        private final int databaseMajorVersion;
        private final int databaseMinorVersion;
        private final String driverName;
        private final int driverMajorVersion;
        private final int driverMinorVersion;
        private final String sqlKeywords;

        public DialectResolutionInfoImpl(DatabaseMetaData databaseMetadata, String databaseName, String databaseVersion, int databaseMajorVersion, int databaseMinorVersion, String driverName, int driverMajorVersion, int driverMinorVersion, String sqlKeywords) {
            this.databaseMetadata = databaseMetadata;
            this.databaseName = databaseName;
            this.databaseVersion = databaseVersion;
            this.databaseMajorVersion = databaseMajorVersion;
            this.databaseMinorVersion = databaseMinorVersion;
            this.driverName = driverName;
            this.driverMajorVersion = driverMajorVersion;
            this.driverMinorVersion = driverMinorVersion;
            this.sqlKeywords = sqlKeywords;
        }

        @Override
        public String getSQLKeywords() {
            return this.sqlKeywords;
        }

        @Override
        public String getDatabaseName() {
            return this.databaseName;
        }

        @Override
        public String getDatabaseVersion() {
            return this.databaseVersion;
        }

        @Override
        public int getDatabaseMajorVersion() {
            return this.databaseMajorVersion;
        }

        @Override
        public int getDatabaseMinorVersion() {
            return this.databaseMinorVersion;
        }

        @Override
        public String getDriverName() {
            return this.driverName;
        }

        @Override
        public int getDriverMajorVersion() {
            return this.driverMajorVersion;
        }

        @Override
        public int getDriverMinorVersion() {
            return this.driverMinorVersion;
        }

        @Override
        public DatabaseMetaData getDatabaseMetadata() {
            return this.databaseMetadata;
        }

        public String toString() {
            return this.getMajor() + "." + this.getMinor();
        }
    }

    public static class MultiTenantConnectionProviderJdbcConnectionAccess
    implements JdbcConnectionAccess {
        private final MultiTenantConnectionProvider connectionProvider;

        public MultiTenantConnectionProviderJdbcConnectionAccess(MultiTenantConnectionProvider connectionProvider) {
            this.connectionProvider = connectionProvider;
        }

        public MultiTenantConnectionProvider getConnectionProvider() {
            return this.connectionProvider;
        }

        @Override
        public Connection obtainConnection() throws SQLException {
            return this.connectionProvider.getAnyConnection();
        }

        @Override
        public void releaseConnection(Connection connection) throws SQLException {
            this.connectionProvider.releaseAnyConnection(connection);
        }

        @Override
        public boolean supportsAggressiveRelease() {
            return this.connectionProvider.supportsAggressiveRelease();
        }
    }

    public static class ConnectionProviderJdbcConnectionAccess
    implements JdbcConnectionAccess {
        private final ConnectionProvider connectionProvider;

        public ConnectionProviderJdbcConnectionAccess(ConnectionProvider connectionProvider) {
            this.connectionProvider = connectionProvider;
        }

        public ConnectionProvider getConnectionProvider() {
            return this.connectionProvider;
        }

        @Override
        public Connection obtainConnection() throws SQLException {
            return this.connectionProvider.getConnection();
        }

        @Override
        public void releaseConnection(Connection connection) throws SQLException {
            this.connectionProvider.closeConnection(connection);
        }

        @Override
        public boolean supportsAggressiveRelease() {
            return this.connectionProvider.supportsAggressiveRelease();
        }
    }
}

