/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.PropertyValueException;
import org.hibernate.action.internal.AbstractEntityInsertAction;
import org.hibernate.action.internal.BulkOperationCleanupAction;
import org.hibernate.action.internal.CollectionRecreateAction;
import org.hibernate.action.internal.CollectionRemoveAction;
import org.hibernate.action.internal.CollectionUpdateAction;
import org.hibernate.action.internal.EntityActionVetoException;
import org.hibernate.action.internal.EntityDeleteAction;
import org.hibernate.action.internal.EntityIdentityInsertAction;
import org.hibernate.action.internal.EntityInsertAction;
import org.hibernate.action.internal.EntityUpdateAction;
import org.hibernate.action.internal.OrphanRemovalAction;
import org.hibernate.action.internal.QueuedOperationCollectionAction;
import org.hibernate.action.internal.UnresolvedEntityInsertActions;
import org.hibernate.action.spi.AfterTransactionCompletionProcess;
import org.hibernate.action.spi.BeforeTransactionCompletionProcess;
import org.hibernate.action.spi.Executable;
import org.hibernate.cache.CacheException;
import org.hibernate.engine.internal.NonNullableTransientDependencies;
import org.hibernate.engine.spi.ComparableExecutable;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ExecutableList;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.internal.EntityCollectionPart;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.type.CollectionType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.EntityType;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.OneToOneType;
import org.hibernate.type.Type;

public class ActionQueue {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(ActionQueue.class);
    private final SessionImplementor session;
    private UnresolvedEntityInsertActions unresolvedInsertions;
    private ExecutableList<AbstractEntityInsertAction> insertions;
    private ExecutableList<EntityDeleteAction> deletions;
    private ExecutableList<EntityUpdateAction> updates;
    private ExecutableList<CollectionRecreateAction> collectionCreations;
    private ExecutableList<CollectionUpdateAction> collectionUpdates;
    private ExecutableList<QueuedOperationCollectionAction> collectionQueuedOps;
    private ExecutableList<CollectionRemoveAction> collectionRemovals;
    private ExecutableList<CollectionRemoveAction> orphanCollectionRemovals;
    private ExecutableList<OrphanRemovalAction> orphanRemovals;
    private transient boolean isTransactionCoordinatorShared;
    private AfterTransactionCompletionProcessQueue afterTransactionProcesses;
    private BeforeTransactionCompletionProcessQueue beforeTransactionProcesses;
    private static final OrderedActions[] ORDERED_OPERATIONS = OrderedActions.values();

    public ActionQueue(SessionImplementor session) {
        this.session = session;
        this.isTransactionCoordinatorShared = false;
    }

    public void clear() {
        for (OrderedActions value : ORDERED_OPERATIONS) {
            ExecutableList<?> list = value.getActions(this);
            if (list == null) continue;
            list.clear();
        }
        if (this.unresolvedInsertions != null) {
            this.unresolvedInsertions.clear();
        }
    }

    public void addAction(EntityInsertAction action) {
        LOG.tracev("Adding an EntityInsertAction for [{0}] object", action.getEntityName());
        this.addInsertAction(action);
    }

    private void addInsertAction(AbstractEntityInsertAction insert) {
        NonNullableTransientDependencies nonNullableTransientDependencies;
        if (insert.isEarlyInsert()) {
            LOG.tracev("Executing inserts before finding non-nullable transient entities for early insert: [{0}]", insert);
            this.executeInserts();
        }
        if ((nonNullableTransientDependencies = insert.findNonNullableTransientEntities()) == null) {
            LOG.tracev("Adding insert with no non-nullable, transient entities: [{0}]", insert);
            this.addResolvedEntityInsertAction(insert);
        } else {
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Adding insert with non-nullable, transient entities; insert=[{0}], dependencies=[{1}]", insert, nonNullableTransientDependencies.toLoggableString(insert.getSession()));
            }
            if (this.unresolvedInsertions == null) {
                this.unresolvedInsertions = new UnresolvedEntityInsertActions();
            }
            this.unresolvedInsertions.addUnresolvedEntityInsertAction(insert, nonNullableTransientDependencies);
        }
    }

    private void addResolvedEntityInsertAction(AbstractEntityInsertAction insert) {
        if (insert.isEarlyInsert()) {
            LOG.trace("Executing insertions before resolved early-insert");
            this.executeInserts();
            LOG.debug("Executing identity-insert immediately");
            this.execute(insert);
        } else {
            LOG.trace("Adding resolved non-early insert action.");
            OrderedActions.EntityInsertAction.ensureInitialized(this);
            this.insertions.add(insert);
        }
        if (!insert.isVeto()) {
            insert.makeEntityManaged();
            if (this.unresolvedInsertions != null) {
                for (AbstractEntityInsertAction resolvedAction : this.unresolvedInsertions.resolveDependentActions(insert.getInstance(), this.session)) {
                    this.addResolvedEntityInsertAction(resolvedAction);
                }
            }
        } else {
            throw new EntityActionVetoException("The EntityInsertAction was vetoed.", insert);
        }
    }

    public void addAction(EntityIdentityInsertAction action) {
        LOG.tracev("Adding an EntityIdentityInsertAction for [{0}] object", action.getEntityName());
        this.addInsertAction(action);
    }

    public void addAction(EntityDeleteAction action) {
        OrderedActions.EntityDeleteAction.ensureInitialized(this);
        this.deletions.add(action);
    }

    public void addAction(OrphanRemovalAction action) {
        OrderedActions.OrphanRemovalAction.ensureInitialized(this);
        this.orphanRemovals.add(action);
    }

    public void addAction(EntityUpdateAction action) {
        OrderedActions.EntityUpdateAction.ensureInitialized(this);
        this.updates.add(action);
    }

    public void addAction(CollectionRecreateAction action) {
        OrderedActions.CollectionRecreateAction.ensureInitialized(this);
        this.collectionCreations.add(action);
    }

    public void addAction(CollectionRemoveAction action) {
        if (this.orphanRemovals != null && action.getAffectedOwner() != null && this.session.getPersistenceContextInternal().getEntry(action.getAffectedOwner()).getStatus().isDeletedOrGone()) {
            for (OrphanRemovalAction orphanRemoval : this.orphanRemovals) {
                if (orphanRemoval.getInstance() != action.getAffectedOwner()) continue;
                OrderedActions.OrphanCollectionRemoveAction.ensureInitialized(this);
                this.orphanCollectionRemovals.add(action);
                return;
            }
        }
        OrderedActions.CollectionRemoveAction.ensureInitialized(this);
        this.collectionRemovals.add(action);
    }

    public void addAction(CollectionUpdateAction action) {
        OrderedActions.CollectionUpdateAction.ensureInitialized(this);
        this.collectionUpdates.add(action);
    }

    public void addAction(QueuedOperationCollectionAction action) {
        OrderedActions.QueuedOperationCollectionAction.ensureInitialized(this);
        this.collectionQueuedOps.add(action);
    }

    public void addAction(BulkOperationCleanupAction action) {
        this.registerCleanupActions(action);
    }

    private void registerCleanupActions(Executable executable) {
        if (executable.getBeforeTransactionCompletionProcess() != null) {
            if (this.beforeTransactionProcesses == null) {
                this.beforeTransactionProcesses = new BeforeTransactionCompletionProcessQueue(this.session);
            }
            this.beforeTransactionProcesses.register(executable.getBeforeTransactionCompletionProcess());
        }
        if (this.session.getFactory().getSessionFactoryOptions().isQueryCacheEnabled()) {
            this.invalidateSpaces(ActionQueue.convertTimestampSpaces(executable.getPropertySpaces()));
        }
        if (executable.getAfterTransactionCompletionProcess() != null) {
            if (this.afterTransactionProcesses == null) {
                this.afterTransactionProcesses = new AfterTransactionCompletionProcessQueue(this.session);
            }
            this.afterTransactionProcesses.register(executable.getAfterTransactionCompletionProcess());
        }
    }

    private static String[] convertTimestampSpaces(Serializable[] spaces) {
        return (String[])spaces;
    }

    public boolean hasUnresolvedEntityInsertActions() {
        return this.unresolvedInsertions != null && !this.unresolvedInsertions.isEmpty();
    }

    public void checkNoUnresolvedActionsAfterOperation() throws PropertyValueException {
        if (this.unresolvedInsertions != null) {
            this.unresolvedInsertions.checkNoUnresolvedActionsAfterOperation();
        }
    }

    public void registerProcess(AfterTransactionCompletionProcess process) {
        if (this.afterTransactionProcesses == null) {
            this.afterTransactionProcesses = new AfterTransactionCompletionProcessQueue(this.session);
        }
        this.afterTransactionProcesses.register(process);
    }

    public void registerProcess(BeforeTransactionCompletionProcess process) {
        if (this.beforeTransactionProcesses == null) {
            this.beforeTransactionProcesses = new BeforeTransactionCompletionProcessQueue(this.session);
        }
        this.beforeTransactionProcesses.register(process);
    }

    public void executeInserts() throws HibernateException {
        if (this.insertions != null && !this.insertions.isEmpty()) {
            this.executeActions(this.insertions);
        }
    }

    public void executeActions() throws HibernateException {
        if (this.hasUnresolvedEntityInsertActions()) {
            throw new IllegalStateException("About to execute actions, but there are unresolved entity insert actions.");
        }
        for (OrderedActions action : ORDERED_OPERATIONS) {
            this.executeActions(action.getActions(this));
        }
    }

    public void prepareActions() throws HibernateException {
        this.prepareActions(this.collectionRemovals);
        this.prepareActions(this.collectionUpdates);
        this.prepareActions(this.collectionCreations);
        this.prepareActions(this.collectionQueuedOps);
    }

    private void prepareActions(ExecutableList<?> queue) throws HibernateException {
        if (queue == null) {
            return;
        }
        for (Executable executable : queue) {
            executable.beforeExecutions();
        }
    }

    public void afterTransactionCompletion(boolean success) {
        if (!this.isTransactionCoordinatorShared && this.afterTransactionProcesses != null) {
            this.afterTransactionProcesses.afterTransactionCompletion(success);
        }
    }

    public void beforeTransactionCompletion() {
        if (!this.isTransactionCoordinatorShared && this.beforeTransactionProcesses != null) {
            this.beforeTransactionProcesses.beforeTransactionCompletion();
        }
    }

    public boolean areInsertionsOrDeletionsQueued() {
        return this.insertions != null && !this.insertions.isEmpty() || this.hasUnresolvedEntityInsertActions() || this.deletions != null && !this.deletions.isEmpty() || this.orphanRemovals != null && !this.orphanRemovals.isEmpty();
    }

    public boolean areTablesToBeUpdated(Set<? extends Serializable> tables) {
        if (tables.isEmpty()) {
            return false;
        }
        for (OrderedActions action : ORDERED_OPERATIONS) {
            ExecutableList<?> list = action.getActions(this);
            if (!ActionQueue.areTablesToBeUpdated(list, tables)) continue;
            return true;
        }
        if (this.unresolvedInsertions == null) {
            return false;
        }
        return ActionQueue.areTablesToBeUpdated(this.unresolvedInsertions, tables);
    }

    private static boolean areTablesToBeUpdated(ExecutableList<?> actions, Set<? extends Serializable> tableSpaces) {
        if (actions == null || actions.isEmpty()) {
            return false;
        }
        for (Serializable actionSpace : actions.getQuerySpaces()) {
            if (!tableSpaces.contains(actionSpace)) continue;
            LOG.debugf("Changes must be flushed to space: %s", actionSpace);
            return true;
        }
        return false;
    }

    private static boolean areTablesToBeUpdated(UnresolvedEntityInsertActions actions, Set<? extends Serializable> tableSpaces) {
        for (Executable executable : actions.getDependentEntityInsertActions()) {
            Serializable[] spaces;
            for (Serializable space : spaces = executable.getPropertySpaces()) {
                if (!tableSpaces.contains(space)) continue;
                LOG.debugf("Changes must be flushed to space: %s", space);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <E extends ComparableExecutable> void executeActions(ExecutableList<E> list) throws HibernateException {
        if (list == null || list.isEmpty()) {
            return;
        }
        try {
            for (ComparableExecutable e : list) {
                try {
                    e.execute();
                }
                finally {
                    if (e.getBeforeTransactionCompletionProcess() != null) {
                        if (this.beforeTransactionProcesses == null) {
                            this.beforeTransactionProcesses = new BeforeTransactionCompletionProcessQueue(this.session);
                        }
                        this.beforeTransactionProcesses.register(e.getBeforeTransactionCompletionProcess());
                    }
                    if (e.getAfterTransactionCompletionProcess() == null) continue;
                    if (this.afterTransactionProcesses == null) {
                        this.afterTransactionProcesses = new AfterTransactionCompletionProcessQueue(this.session);
                    }
                    this.afterTransactionProcesses.register(e.getAfterTransactionCompletionProcess());
                }
            }
        }
        finally {
            if (this.session.getFactory().getSessionFactoryOptions().isQueryCacheEnabled()) {
                Set<Serializable> propertySpaces = list.getQuerySpaces();
                this.invalidateSpaces(ActionQueue.convertTimestampSpaces(propertySpaces));
            }
        }
        list.clear();
        this.session.getJdbcCoordinator().executeBatch();
    }

    private static String[] convertTimestampSpaces(Set<String> spaces) {
        return spaces.toArray(StringHelper.EMPTY_STRINGS);
    }

    public <E extends Executable & Comparable<?>> void execute(E executable) {
        try {
            executable.execute();
        }
        finally {
            this.registerCleanupActions(executable);
        }
    }

    private void invalidateSpaces(String ... spaces) {
        if (spaces != null && spaces.length > 0) {
            for (String space : spaces) {
                if (this.afterTransactionProcesses == null) {
                    this.afterTransactionProcesses = new AfterTransactionCompletionProcessQueue(this.session);
                }
                this.afterTransactionProcesses.addSpaceToInvalidate(space);
            }
            this.session.getFactory().getCache().getTimestampsCache().preInvalidate(spaces, this.session);
        }
    }

    public String toString() {
        return "ActionQueue[insertions=" + ActionQueue.toString(this.insertions) + " updates=" + ActionQueue.toString(this.updates) + " deletions=" + ActionQueue.toString(this.deletions) + " orphanRemovals=" + ActionQueue.toString(this.orphanRemovals) + " collectionCreations=" + ActionQueue.toString(this.collectionCreations) + " collectionRemovals=" + ActionQueue.toString(this.collectionRemovals) + " collectionUpdates=" + ActionQueue.toString(this.collectionUpdates) + " collectionQueuedOps=" + ActionQueue.toString(this.collectionQueuedOps) + " unresolvedInsertDependencies=" + this.unresolvedInsertions + "]";
    }

    private static String toString(ExecutableList<?> q) {
        return q == null ? "ExecutableList{size=0}" : q.toString();
    }

    public int numberOfCollectionRemovals() {
        if (this.collectionRemovals == null) {
            return 0;
        }
        return this.collectionRemovals.size();
    }

    public int numberOfCollectionUpdates() {
        if (this.collectionUpdates == null) {
            return 0;
        }
        return this.collectionUpdates.size();
    }

    public int numberOfCollectionCreations() {
        if (this.collectionCreations == null) {
            return 0;
        }
        return this.collectionCreations.size();
    }

    public int numberOfDeletions() {
        int del = this.deletions == null ? 0 : this.deletions.size();
        int orph = this.orphanRemovals == null ? 0 : this.orphanRemovals.size();
        return del + orph;
    }

    public int numberOfUpdates() {
        if (this.updates == null) {
            return 0;
        }
        return this.updates.size();
    }

    public int numberOfInsertions() {
        if (this.insertions == null) {
            return 0;
        }
        return this.insertions.size();
    }

    public TransactionCompletionProcesses getTransactionCompletionProcesses() {
        if (this.beforeTransactionProcesses == null) {
            this.beforeTransactionProcesses = new BeforeTransactionCompletionProcessQueue(this.session);
        }
        if (this.afterTransactionProcesses == null) {
            this.afterTransactionProcesses = new AfterTransactionCompletionProcessQueue(this.session);
        }
        return new TransactionCompletionProcesses(this.beforeTransactionProcesses, this.afterTransactionProcesses);
    }

    public void setTransactionCompletionProcesses(TransactionCompletionProcesses processes, boolean isTransactionCoordinatorShared) {
        this.isTransactionCoordinatorShared = isTransactionCoordinatorShared;
        this.beforeTransactionProcesses = processes.beforeTransactionCompletionProcesses;
        this.afterTransactionProcesses = processes.afterTransactionCompletionProcesses;
    }

    public void sortCollectionActions() {
        if (this.isOrderUpdatesEnabled()) {
            if (this.collectionCreations != null) {
                this.collectionCreations.sort();
            }
            if (this.collectionUpdates != null) {
                this.collectionUpdates.sort();
            }
            if (this.collectionQueuedOps != null) {
                this.collectionQueuedOps.sort();
            }
            if (this.collectionRemovals != null) {
                this.collectionRemovals.sort();
            }
        }
    }

    public void sortActions() {
        if (this.isOrderUpdatesEnabled() && this.updates != null) {
            this.updates.sort();
        }
        if (this.isOrderInsertsEnabled() && this.insertions != null) {
            this.insertions.sort();
        }
    }

    private boolean isOrderUpdatesEnabled() {
        return this.session.getFactory().getSessionFactoryOptions().isOrderUpdatesEnabled();
    }

    private boolean isOrderInsertsEnabled() {
        return this.session.getFactory().getSessionFactoryOptions().isOrderInsertsEnabled();
    }

    public void clearFromFlushNeededCheck(int previousCollectionRemovalSize) {
        if (this.collectionCreations != null) {
            this.collectionCreations.clear();
        }
        if (this.collectionUpdates != null) {
            this.collectionUpdates.clear();
        }
        if (this.collectionQueuedOps != null) {
            this.collectionQueuedOps.clear();
        }
        if (this.updates != null) {
            this.updates.clear();
        }
        if (this.collectionRemovals != null && this.collectionRemovals.size() > previousCollectionRemovalSize) {
            this.collectionRemovals.removeLastN(this.collectionRemovals.size() - previousCollectionRemovalSize);
        }
    }

    public boolean hasAfterTransactionActions() {
        return this.isTransactionCoordinatorShared ? false : this.afterTransactionProcesses != null && this.afterTransactionProcesses.hasActions();
    }

    public boolean hasBeforeTransactionActions() {
        return this.isTransactionCoordinatorShared ? false : this.beforeTransactionProcesses != null && this.beforeTransactionProcesses.hasActions();
    }

    public boolean hasAnyQueuedActions() {
        return this.updates != null && !this.updates.isEmpty() || this.insertions != null && !this.insertions.isEmpty() || this.hasUnresolvedEntityInsertActions() || this.deletions != null && !this.deletions.isEmpty() || this.collectionUpdates != null && !this.collectionUpdates.isEmpty() || this.collectionQueuedOps != null && !this.collectionQueuedOps.isEmpty() || this.collectionRemovals != null && !this.collectionRemovals.isEmpty() || this.collectionCreations != null && !this.collectionCreations.isEmpty();
    }

    public void unScheduleUnloadedDeletion(Object newEntity) {
        EntityPersister entityPersister = this.session.getEntityPersister(null, newEntity);
        Object identifier = entityPersister.getIdentifier(newEntity, this.session);
        if (this.deletions != null) {
            for (int i = 0; i < this.deletions.size(); ++i) {
                EntityDeleteAction action = this.deletions.get(i);
                if (action.getInstance() != null || !action.getEntityName().equals(entityPersister.getEntityName()) || !entityPersister.getIdentifierMapping().areEqual(action.getId(), identifier, this.session)) continue;
                this.session.getPersistenceContextInternal().removeDeletedUnloadedEntityKey(this.session.generateEntityKey(identifier, entityPersister));
                this.deletions.remove(i);
                return;
            }
        }
        throw new AssertionFailure("Unable to perform un-delete for unloaded entity delete " + entityPersister.getEntityName());
    }

    public void unScheduleDeletion(EntityEntry entry, Object rescuedEntity) {
        EntityDeleteAction action;
        int i;
        LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(rescuedEntity);
        if (lazyInitializer != null && !lazyInitializer.isUninitialized()) {
            rescuedEntity = lazyInitializer.getImplementation(this.session);
        }
        if (this.deletions != null) {
            for (i = 0; i < this.deletions.size(); ++i) {
                action = this.deletions.get(i);
                if (action.getInstance() != rescuedEntity) continue;
                this.deletions.remove(i);
                return;
            }
        }
        if (this.orphanRemovals != null) {
            for (i = 0; i < this.orphanRemovals.size(); ++i) {
                action = this.orphanRemovals.get(i);
                if (action.getInstance() != rescuedEntity) continue;
                this.orphanRemovals.remove(i);
                return;
            }
        }
        throw new AssertionFailure("Unable to perform un-delete for instance " + entry.getEntityName());
    }

    public void serialize(ObjectOutputStream oos) throws IOException {
        LOG.trace("Serializing action-queue");
        if (this.unresolvedInsertions == null) {
            this.unresolvedInsertions = new UnresolvedEntityInsertActions();
        }
        this.unresolvedInsertions.serialize(oos);
        for (OrderedActions action : ORDERED_OPERATIONS) {
            ExecutableList<?> l = action.getActions(this);
            if (l == null) {
                oos.writeBoolean(false);
                continue;
            }
            oos.writeBoolean(true);
            l.writeExternal(oos);
        }
    }

    public static ActionQueue deserialize(ObjectInputStream ois, EventSource session) throws IOException, ClassNotFoundException {
        boolean traceEnabled = LOG.isTraceEnabled();
        if (traceEnabled) {
            LOG.trace("Deserializing action-queue");
        }
        ActionQueue rtn = new ActionQueue(session);
        rtn.unresolvedInsertions = UnresolvedEntityInsertActions.deserialize(ois, session);
        for (OrderedActions action : ORDERED_OPERATIONS) {
            ExecutableList<?> l = action.getActions(rtn);
            boolean notNull = ois.readBoolean();
            if (!notNull) continue;
            if (l == null) {
                action.ensureInitialized(rtn);
                l = action.getActions(rtn);
            }
            l.readExternal(ois);
            if (traceEnabled) {
                LOG.tracev("Deserialized [{0}] entries", l.size());
            }
            l.afterDeserialize(session);
        }
        return rtn;
    }

    private static class InsertActionSorter
    implements ExecutableList.Sorter<AbstractEntityInsertAction> {
        public static final InsertActionSorter INSTANCE = new InsertActionSorter();

        @Override
        public void sort(List<AbstractEntityInsertAction> insertions) {
            int lastScheduleSize;
            int i;
            int insertInfoCount = insertions.size();
            InsertInfo[] insertInfos = new InsertInfo[insertInfoCount];
            IdentityHashMap<Object, InsertInfo> insertInfosByEntity = new IdentityHashMap<Object, InsertInfo>(insertInfos.length);
            for (i = 0; i < insertInfoCount; ++i) {
                AbstractEntityInsertAction insertAction = insertions.get(i);
                InsertInfo insertInfo = new InsertInfo(insertAction, i);
                insertInfosByEntity.put(insertAction.getInstance(), insertInfo);
                insertInfos[i] = insertInfo;
            }
            for (i = 0; i < insertInfoCount; ++i) {
                insertInfos[i].buildDirectDependencies(insertInfosByEntity);
            }
            for (i = 0; i < insertInfoCount; ++i) {
                insertInfos[i].propagateChildDependencies();
            }
            HashSet<InsertInfo> visited = new HashSet<InsertInfo>();
            LinkedHashMap<String, EntityInsertGroup> insertInfosByEntityName = new LinkedHashMap<String, EntityInsertGroup>();
            for (int i2 = 0; i2 < insertInfoCount; ++i2) {
                InsertInfo insertInfo = insertInfos[i2];
                insertInfo.buildTransitiveDependencies(visited);
                String entityName = insertInfo.insertAction.getPersister().getEntityName();
                EntityInsertGroup entityInsertGroup = (EntityInsertGroup)insertInfosByEntityName.get(entityName);
                if (entityInsertGroup == null) {
                    entityInsertGroup = new EntityInsertGroup(entityName);
                    insertInfosByEntityName.put(entityName, entityInsertGroup);
                }
                entityInsertGroup.add(insertInfo);
            }
            HashSet<String> scheduledEntityNames = new HashSet<String>(insertInfosByEntityName.size());
            int schedulePosition = 0;
            do {
                lastScheduleSize = scheduledEntityNames.size();
                Iterator iterator = insertInfosByEntityName.values().iterator();
                while (iterator.hasNext()) {
                    EntityInsertGroup insertGroup = (EntityInsertGroup)iterator.next();
                    if (!scheduledEntityNames.containsAll(insertGroup.dependentEntityNames)) continue;
                    schedulePosition = this.schedule(insertInfos, insertGroup.insertInfos, schedulePosition);
                    scheduledEntityNames.add(insertGroup.entityName);
                    iterator.remove();
                }
            } while (lastScheduleSize != scheduledEntityNames.size());
            if (!insertInfosByEntityName.isEmpty()) {
                LOG.warn("The batch containing " + insertions.size() + " statements could not be sorted. This might indicate a circular entity relationship.");
            }
            insertions.clear();
            for (InsertInfo insertInfo : insertInfos) {
                insertions.add(insertInfo.insertAction);
            }
        }

        private int schedule(InsertInfo[] insertInfos, List<InsertInfo> insertInfosToSchedule, int schedulePosition) {
            int i;
            InsertInfo[] newInsertInfos = new InsertInfo[insertInfos.length];
            BitSet bitSet = new BitSet(insertInfos.length);
            int smallestScheduledIndex = -1;
            int biggestScheduledIndex = -1;
            for (int i2 = 0; i2 < insertInfosToSchedule.size(); ++i2) {
                int index = insertInfosToSchedule.get((int)i2).index;
                bitSet.set(index);
                smallestScheduledIndex = Math.min(smallestScheduledIndex, index);
                biggestScheduledIndex = Math.max(biggestScheduledIndex, index);
            }
            int nextSchedulePosition = schedulePosition + insertInfosToSchedule.size();
            if (smallestScheduledIndex == schedulePosition && biggestScheduledIndex == nextSchedulePosition) {
                return nextSchedulePosition;
            }
            int shiftSchedulePosition = nextSchedulePosition;
            for (i = 0; i < insertInfosToSchedule.size(); ++i) {
                InsertInfo insertInfoToSchedule = insertInfosToSchedule.get(i);
                int targetSchedulePosition = schedulePosition + i;
                newInsertInfos[targetSchedulePosition] = insertInfoToSchedule;
                insertInfoToSchedule.index = targetSchedulePosition;
                InsertInfo oldInsertInfo = insertInfos[targetSchedulePosition];
                if (bitSet.get(targetSchedulePosition)) continue;
                oldInsertInfo.index = shiftSchedulePosition;
                bitSet.set(targetSchedulePosition);
                newInsertInfos[shiftSchedulePosition++] = oldInsertInfo;
            }
            ++biggestScheduledIndex;
            for (i = bitSet.nextClearBit(schedulePosition); i < biggestScheduledIndex; ++i) {
                if (bitSet.get(i)) continue;
                InsertInfo insertInfo = insertInfos[i];
                insertInfo.index = shiftSchedulePosition;
                newInsertInfos[shiftSchedulePosition++] = insertInfo;
            }
            System.arraycopy(newInsertInfos, schedulePosition, insertInfos, schedulePosition, biggestScheduledIndex - schedulePosition);
            return nextSchedulePosition;
        }

        public static class EntityInsertGroup {
            private final String entityName;
            private final List<InsertInfo> insertInfos = new ArrayList<InsertInfo>();
            private final Set<String> dependentEntityNames = new HashSet<String>();

            public EntityInsertGroup(String entityName) {
                this.entityName = entityName;
            }

            public void add(InsertInfo insertInfo) {
                this.insertInfos.add(insertInfo);
                if (insertInfo.transitiveIncomingDependencies != null) {
                    for (InsertInfo dependency : insertInfo.transitiveIncomingDependencies) {
                        this.dependentEntityNames.add(dependency.insertAction.getEntityName());
                    }
                }
            }

            public String toString() {
                return "EntityInsertGroup{entityName='" + this.entityName + "'}";
            }
        }

        private static class InsertInfo {
            private final AbstractEntityInsertAction insertAction;
            private Set<InsertInfo> transitiveIncomingDependencies;
            private Set<InsertInfo> outgoingDependencies;
            private int index;

            public InsertInfo(AbstractEntityInsertAction insertAction, int index) {
                this.insertAction = insertAction;
                this.index = index;
            }

            public void buildDirectDependencies(IdentityHashMap<Object, InsertInfo> insertInfosByEntity) {
                Object[] propertyValues = this.insertAction.getState();
                Type[] propertyTypes = this.insertAction.getPersister().getPropertyTypes();
                int propertyTypesLength = propertyTypes.length;
                for (int i = 0; i < propertyTypesLength; ++i) {
                    this.addDirectDependency(propertyTypes[i], propertyValues[i], insertInfosByEntity);
                }
            }

            public void propagateChildDependencies() {
                if (this.outgoingDependencies != null) {
                    for (InsertInfo childDependency : this.outgoingDependencies) {
                        if (childDependency.transitiveIncomingDependencies == null) {
                            childDependency.transitiveIncomingDependencies = new HashSet<InsertInfo>();
                        }
                        childDependency.transitiveIncomingDependencies.add(this);
                    }
                }
            }

            public void buildTransitiveDependencies(Set<InsertInfo> visited) {
                if (this.transitiveIncomingDependencies != null) {
                    visited.addAll(this.transitiveIncomingDependencies);
                    for (InsertInfo insertInfo : this.transitiveIncomingDependencies.toArray(new InsertInfo[0])) {
                        insertInfo.addTransitiveDependencies(this, visited);
                    }
                    visited.clear();
                }
            }

            public void addTransitiveDependencies(InsertInfo origin, Set<InsertInfo> visited) {
                if (this.transitiveIncomingDependencies != null) {
                    for (InsertInfo insertInfo : this.transitiveIncomingDependencies) {
                        if (!visited.add(insertInfo)) continue;
                        origin.transitiveIncomingDependencies.add(insertInfo);
                        insertInfo.addTransitiveDependencies(origin, visited);
                    }
                }
            }

            private void addDirectDependency(Type type, Object value, IdentityHashMap<Object, InsertInfo> insertInfosByEntity) {
                block7: {
                    block9: {
                        block6: {
                            InsertInfo insertInfo;
                            block8: {
                                if (!type.isEntityType() || value == null) break block6;
                                EntityType entityType = (EntityType)type;
                                insertInfo = insertInfosByEntity.get(value);
                                if (insertInfo == null) break block7;
                                if (!entityType.isOneToOne() || ((OneToOneType)OneToOneType.class.cast(entityType)).getForeignKeyDirection() != ForeignKeyDirection.TO_PARENT) break block8;
                                if (entityType.isReferenceToPrimaryKey()) break block7;
                                if (this.outgoingDependencies == null) {
                                    this.outgoingDependencies = new HashSet<InsertInfo>();
                                }
                                this.outgoingDependencies.add(insertInfo);
                                break block7;
                            }
                            if (this.transitiveIncomingDependencies == null) {
                                this.transitiveIncomingDependencies = new HashSet<InsertInfo>();
                            }
                            this.transitiveIncomingDependencies.add(insertInfo);
                            break block7;
                        }
                        if (!type.isCollectionType() || value == null) break block9;
                        CollectionType collectionType = (CollectionType)type;
                        PluralAttributeMapping pluralAttributeMapping = this.insertAction.getSession().getFactory().getMappingMetamodel().getCollectionDescriptor(collectionType.getRole()).getAttributeMapping();
                        if (!pluralAttributeMapping.getCollectionDescriptor().isOneToMany() || !(pluralAttributeMapping.getElementDescriptor() instanceof EntityCollectionPart)) break block7;
                        Iterator<?> elementsIterator = collectionType.getElementsIterator(value);
                        while (elementsIterator.hasNext()) {
                            Object element = elementsIterator.next();
                            InsertInfo insertInfo = insertInfosByEntity.get(element);
                            if (insertInfo == null) continue;
                            if (this.outgoingDependencies == null) {
                                this.outgoingDependencies = new HashSet<InsertInfo>();
                            }
                            this.outgoingDependencies.add(insertInfo);
                        }
                        break block7;
                    }
                    if (type.isComponentType() && value != null) {
                        CompositeType compositeType = (CompositeType)type;
                        EventSource session = this.insertAction.getSession();
                        Object[] componentValues = compositeType.getPropertyValues(value, session);
                        for (int j = 0; j < componentValues.length; ++j) {
                            Type componentValueType = compositeType.getSubtypes()[j];
                            Object componentValue = componentValues[j];
                            this.addDirectDependency(componentValueType, componentValue, insertInfosByEntity);
                        }
                    }
                }
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                InsertInfo that = (InsertInfo)o;
                return this.insertAction.equals(that.insertAction);
            }

            public int hashCode() {
                return this.insertAction.hashCode();
            }

            public String toString() {
                return "InsertInfo{insertAction=" + this.insertAction + "}";
            }
        }
    }

    public static class TransactionCompletionProcesses {
        private final BeforeTransactionCompletionProcessQueue beforeTransactionCompletionProcesses;
        private final AfterTransactionCompletionProcessQueue afterTransactionCompletionProcesses;

        private TransactionCompletionProcesses(BeforeTransactionCompletionProcessQueue beforeTransactionCompletionProcessQueue, AfterTransactionCompletionProcessQueue afterTransactionCompletionProcessQueue) {
            this.beforeTransactionCompletionProcesses = beforeTransactionCompletionProcessQueue;
            this.afterTransactionCompletionProcesses = afterTransactionCompletionProcessQueue;
        }
    }

    private static class AfterTransactionCompletionProcessQueue
    extends AbstractTransactionCompletionProcessQueue<AfterTransactionCompletionProcess> {
        private final Set<String> querySpacesToInvalidate = new HashSet<String>();

        private AfterTransactionCompletionProcessQueue(SessionImplementor session) {
            super(session);
        }

        public void addSpaceToInvalidate(String space) {
            this.querySpacesToInvalidate.add(space);
        }

        public void afterTransactionCompletion(boolean success) {
            while (!this.processes.isEmpty()) {
                try {
                    ((AfterTransactionCompletionProcess)this.processes.poll()).doAfterTransactionCompletion(success, this.session);
                }
                catch (CacheException ce) {
                    LOG.unableToReleaseCacheLock(ce);
                }
                catch (Exception e) {
                    throw new HibernateException("Unable to perform afterTransactionCompletion callback: " + e.getMessage(), e);
                }
            }
            if (this.session.getFactory().getSessionFactoryOptions().isQueryCacheEnabled()) {
                this.session.getFactory().getCache().getTimestampsCache().invalidate(this.querySpacesToInvalidate.toArray(StringHelper.EMPTY_STRINGS), this.session);
            }
            this.querySpacesToInvalidate.clear();
        }
    }

    private static class BeforeTransactionCompletionProcessQueue
    extends AbstractTransactionCompletionProcessQueue<BeforeTransactionCompletionProcess> {
        private BeforeTransactionCompletionProcessQueue(SessionImplementor session) {
            super(session);
        }

        public void beforeTransactionCompletion() {
            while (!this.processes.isEmpty()) {
                try {
                    ((BeforeTransactionCompletionProcess)this.processes.poll()).doBeforeTransactionCompletion(this.session);
                }
                catch (HibernateException he) {
                    throw he;
                }
                catch (Exception e) {
                    throw new HibernateException("Unable to perform beforeTransactionCompletion callback: " + e.getMessage(), e);
                }
            }
        }
    }

    private static abstract class AbstractTransactionCompletionProcessQueue<T> {
        protected SessionImplementor session;
        protected Queue<T> processes = new ConcurrentLinkedQueue<T>();

        private AbstractTransactionCompletionProcessQueue(SessionImplementor session) {
            this.session = session;
        }

        public void register(T process) {
            if (process == null) {
                return;
            }
            this.processes.add(process);
        }

        public boolean hasActions() {
            return !this.processes.isEmpty();
        }
    }

    private static enum OrderedActions {
        OrphanCollectionRemoveAction{

            @Override
            public ExecutableList<?> getActions(ActionQueue instance) {
                return instance.orphanCollectionRemovals;
            }

            @Override
            public void ensureInitialized(ActionQueue instance) {
                if (instance.orphanCollectionRemovals == null) {
                    instance.orphanCollectionRemovals = new ExecutableList(instance.isOrderUpdatesEnabled());
                }
            }
        }
        ,
        OrphanRemovalAction{

            @Override
            public ExecutableList<?> getActions(ActionQueue instance) {
                return instance.orphanRemovals;
            }

            @Override
            public void ensureInitialized(ActionQueue instance) {
                if (instance.orphanRemovals == null) {
                    instance.orphanRemovals = new ExecutableList(false);
                }
            }
        }
        ,
        EntityInsertAction{

            @Override
            public ExecutableList<?> getActions(ActionQueue instance) {
                return instance.insertions;
            }

            @Override
            public void ensureInitialized(ActionQueue instance) {
                if (instance.insertions == null) {
                    instance.insertions = instance.isOrderInsertsEnabled() ? new ExecutableList<AbstractEntityInsertAction>(InsertActionSorter.INSTANCE) : new ExecutableList(false);
                }
            }
        }
        ,
        EntityUpdateAction{

            @Override
            public ExecutableList<?> getActions(ActionQueue instance) {
                return instance.updates;
            }

            @Override
            public void ensureInitialized(ActionQueue instance) {
                if (instance.updates == null) {
                    instance.updates = new ExecutableList(instance.isOrderUpdatesEnabled());
                }
            }
        }
        ,
        QueuedOperationCollectionAction{

            @Override
            public ExecutableList<?> getActions(ActionQueue instance) {
                return instance.collectionQueuedOps;
            }

            @Override
            public void ensureInitialized(ActionQueue instance) {
                if (instance.collectionQueuedOps == null) {
                    instance.collectionQueuedOps = new ExecutableList(instance.isOrderUpdatesEnabled());
                }
            }
        }
        ,
        CollectionRemoveAction{

            @Override
            public ExecutableList<?> getActions(ActionQueue instance) {
                return instance.collectionRemovals;
            }

            @Override
            public void ensureInitialized(ActionQueue instance) {
                if (instance.collectionRemovals == null) {
                    instance.collectionRemovals = new ExecutableList(instance.isOrderUpdatesEnabled());
                }
            }
        }
        ,
        CollectionUpdateAction{

            @Override
            public ExecutableList<?> getActions(ActionQueue instance) {
                return instance.collectionUpdates;
            }

            @Override
            public void ensureInitialized(ActionQueue instance) {
                if (instance.collectionUpdates == null) {
                    instance.collectionUpdates = new ExecutableList(instance.isOrderUpdatesEnabled());
                }
            }
        }
        ,
        CollectionRecreateAction{

            @Override
            public ExecutableList<?> getActions(ActionQueue instance) {
                return instance.collectionCreations;
            }

            @Override
            public void ensureInitialized(ActionQueue instance) {
                if (instance.collectionCreations == null) {
                    instance.collectionCreations = new ExecutableList(instance.isOrderUpdatesEnabled());
                }
            }
        }
        ,
        EntityDeleteAction{

            @Override
            public ExecutableList<?> getActions(ActionQueue instance) {
                return instance.deletions;
            }

            @Override
            public void ensureInitialized(ActionQueue instance) {
                if (instance.deletions == null) {
                    instance.deletions = new ExecutableList(false);
                }
            }
        };


        public abstract ExecutableList<?> getActions(ActionQueue var1);

        public abstract void ensureInitialized(ActionQueue var1);
    }
}

