/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import java.util.EnumMap;
import org.hibernate.Internal;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.loader.ast.internal.LoaderSelectBuilder;
import org.hibernate.loader.ast.internal.SingleIdEntityLoaderSupport;
import org.hibernate.loader.ast.internal.SingleIdLoadPlan;
import org.hibernate.loader.ast.spi.CascadingFetchProfile;
import org.hibernate.loader.ast.spi.Loadable;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.spi.JdbcParametersList;

public class SingleIdEntityLoaderStandardImpl<T>
extends SingleIdEntityLoaderSupport<T> {
    private final EnumMap<LockMode, SingleIdLoadPlan<T>> selectByLockMode = new EnumMap(LockMode.class);
    private EnumMap<CascadingFetchProfile, SingleIdLoadPlan<T>> selectByInternalCascadeProfile;

    public SingleIdEntityLoaderStandardImpl(EntityMappingType entityDescriptor, SessionFactoryImplementor sessionFactory) {
        super(entityDescriptor, sessionFactory);
        LockOptions lockOptions = LockOptions.NONE;
        LoadQueryInfluencers influencers = new LoadQueryInfluencers(sessionFactory);
        SingleIdLoadPlan<T> plan = this.createLoadPlan(lockOptions, influencers, sessionFactory);
        if (this.isLoadPlanReusable(lockOptions, influencers)) {
            this.selectByLockMode.put(lockOptions.getLockMode(), plan);
        }
    }

    @Override
    public T load(Object key, LockOptions lockOptions, Boolean readOnly, SharedSessionContractImplementor session) {
        SingleIdLoadPlan<T> loadPlan = this.resolveLoadPlan(lockOptions, session.getLoadQueryInfluencers(), session.getFactory());
        return loadPlan.load(key, readOnly, true, session);
    }

    @Override
    public T load(Object key, Object entityInstance, LockOptions lockOptions, Boolean readOnly, SharedSessionContractImplementor session) {
        SingleIdLoadPlan<T> loadPlan = this.resolveLoadPlan(lockOptions, session.getLoadQueryInfluencers(), session.getFactory());
        return loadPlan.load(key, entityInstance, readOnly, false, session);
    }

    @Internal
    public SingleIdLoadPlan<T> resolveLoadPlan(LockOptions lockOptions, LoadQueryInfluencers loadQueryInfluencers, SessionFactoryImplementor sessionFactory) {
        if (this.getLoadable().isAffectedByEnabledFilters(loadQueryInfluencers)) {
            return this.createLoadPlan(lockOptions, loadQueryInfluencers, sessionFactory);
        }
        if (loadQueryInfluencers.hasEnabledCascadingFetchProfile() && LockMode.WRITE.greaterThan(lockOptions.getLockMode())) {
            return this.getInternalCascadeLoadPlan(lockOptions, loadQueryInfluencers, sessionFactory);
        }
        return this.getRegularLoadPlan(lockOptions, loadQueryInfluencers, sessionFactory);
    }

    private SingleIdLoadPlan<T> getRegularLoadPlan(LockOptions lockOptions, LoadQueryInfluencers loadQueryInfluencers, SessionFactoryImplementor sessionFactory) {
        if (this.isLoadPlanReusable(lockOptions, loadQueryInfluencers)) {
            SingleIdLoadPlan<T> existing = this.selectByLockMode.get((Object)lockOptions.getLockMode());
            if (existing != null) {
                return existing;
            }
            SingleIdLoadPlan<T> plan = this.createLoadPlan(lockOptions, loadQueryInfluencers, sessionFactory);
            this.selectByLockMode.put(lockOptions.getLockMode(), plan);
            return plan;
        }
        return this.createLoadPlan(lockOptions, loadQueryInfluencers, sessionFactory);
    }

    private SingleIdLoadPlan<T> getInternalCascadeLoadPlan(LockOptions lockOptions, LoadQueryInfluencers loadQueryInfluencers, SessionFactoryImplementor sessionFactory) {
        CascadingFetchProfile fetchProfile = loadQueryInfluencers.getEnabledCascadingFetchProfile();
        if (this.selectByInternalCascadeProfile == null) {
            this.selectByInternalCascadeProfile = new EnumMap(CascadingFetchProfile.class);
        } else {
            SingleIdLoadPlan<T> existing = this.selectByInternalCascadeProfile.get((Object)fetchProfile);
            if (existing != null) {
                return existing;
            }
        }
        SingleIdLoadPlan<T> plan = this.createLoadPlan(lockOptions, loadQueryInfluencers, sessionFactory);
        this.selectByInternalCascadeProfile.put(fetchProfile, plan);
        return plan;
    }

    private boolean isLoadPlanReusable(LockOptions lockOptions, LoadQueryInfluencers loadQueryInfluencers) {
        return lockOptions.getTimeOut() == -1 && !this.getLoadable().isAffectedByEntityGraph(loadQueryInfluencers) && !this.getLoadable().isAffectedByEnabledFetchProfiles(loadQueryInfluencers);
    }

    private SingleIdLoadPlan<T> createLoadPlan(LockOptions lockOptions, LoadQueryInfluencers queryInfluencers, SessionFactoryImplementor sessionFactory) {
        JdbcParametersList.Builder jdbcParametersBuilder = JdbcParametersList.newBuilder();
        SelectStatement sqlAst = LoaderSelectBuilder.createSelect((Loadable)this.getLoadable(), null, this.getLoadable().getIdentifierMapping(), null, 1, queryInfluencers, lockOptions, jdbcParametersBuilder::add, sessionFactory);
        return new SingleIdLoadPlan(this.getLoadable(), this.getLoadable().getIdentifierMapping(), sqlAst, jdbcParametersBuilder.build(), lockOptions, sessionFactory);
    }
}

