/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.collection.mutation;

import java.util.Iterator;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.jdbc.batch.internal.BasicBatchKey;
import org.hibernate.engine.jdbc.mutation.JdbcValueBindings;
import org.hibernate.engine.jdbc.mutation.MutationExecutor;
import org.hibernate.engine.jdbc.mutation.spi.MutationExecutorService;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.collection.mutation.CollectionMutationTarget;
import org.hibernate.persister.collection.mutation.DeleteRowsCoordinator;
import org.hibernate.persister.collection.mutation.RowMutationOperations;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.model.ModelMutationLogging;
import org.hibernate.sql.model.MutationOperationGroup;
import org.hibernate.sql.model.MutationType;
import org.hibernate.sql.model.internal.MutationOperationGroupFactory;
import org.hibernate.sql.model.jdbc.JdbcMutationOperation;

public class DeleteRowsCoordinatorStandard
implements DeleteRowsCoordinator {
    private final CollectionMutationTarget mutationTarget;
    private final RowMutationOperations rowMutationOperations;
    private final boolean deleteByIndex;
    private final BasicBatchKey batchKey;
    private final MutationExecutorService mutationExecutorService;
    private MutationOperationGroup operationGroup;

    public DeleteRowsCoordinatorStandard(CollectionMutationTarget mutationTarget, RowMutationOperations rowMutationOperations, boolean deleteByIndex, ServiceRegistry serviceRegistry) {
        this.mutationTarget = mutationTarget;
        this.rowMutationOperations = rowMutationOperations;
        this.deleteByIndex = deleteByIndex;
        this.batchKey = new BasicBatchKey(mutationTarget.getRolePath() + "#DELETE");
        this.mutationExecutorService = serviceRegistry.getService(MutationExecutorService.class);
    }

    @Override
    public CollectionMutationTarget getMutationTarget() {
        return this.mutationTarget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteRows(PersistentCollection<?> collection, Object key, SharedSessionContractImplementor session) {
        if (this.operationGroup == null) {
            this.operationGroup = this.createOperationGroup();
        }
        if (ModelMutationLogging.MODEL_MUTATION_LOGGER_DEBUG_ENABLED) {
            ModelMutationLogging.MODEL_MUTATION_LOGGER.debugf("Deleting removed collection rows - %s : %s", (Object)this.mutationTarget.getRolePath(), key);
        }
        MutationExecutor mutationExecutor = this.mutationExecutorService.createExecutor(() -> this.batchKey, this.operationGroup, session);
        JdbcValueBindings jdbcValueBindings = mutationExecutor.getJdbcValueBindings();
        try {
            PluralAttributeMapping pluralAttribute = this.mutationTarget.getTargetPart();
            CollectionPersister collectionDescriptor = pluralAttribute.getCollectionDescriptor();
            Iterator<?> deletes = collection.getDeletes(collectionDescriptor, !this.deleteByIndex);
            if (!deletes.hasNext()) {
                ModelMutationLogging.MODEL_MUTATION_LOGGER.debug((Object)"No rows to delete");
                return;
            }
            int deletionCount = 0;
            RowMutationOperations.Restrictions restrictions = this.rowMutationOperations.getDeleteRowRestrictions();
            while (deletes.hasNext()) {
                Object removal = deletes.next();
                restrictions.applyRestrictions(collection, key, removal, deletionCount, session, jdbcValueBindings);
                mutationExecutor.execute(removal, null, null, null, session);
                ++deletionCount;
            }
            ModelMutationLogging.MODEL_MUTATION_LOGGER.debugf("Done deleting `%s` collection rows : %s", deletionCount, (Object)this.mutationTarget.getRolePath());
        }
        finally {
            mutationExecutor.release();
        }
    }

    private MutationOperationGroup createOperationGroup() {
        assert (this.mutationTarget.getTargetPart() != null);
        assert (this.mutationTarget.getTargetPart().getKeyDescriptor() != null);
        JdbcMutationOperation operation = this.rowMutationOperations.getDeleteRowOperation();
        return MutationOperationGroupFactory.singleOperation(MutationType.DELETE, this.mutationTarget, operation);
    }
}

