/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.internal;

import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.spi.SqlOmittingQueryOptions;
import org.hibernate.sql.exec.internal.BaseExecutionContext;
import org.hibernate.sql.exec.spi.Callback;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;

public class SqmJdbcExecutionContextAdapter
extends BaseExecutionContext {
    private final DomainQueryExecutionContext sqmExecutionContext;
    private final QueryOptions queryOptions;

    public static SqmJdbcExecutionContextAdapter omittingLockingAndPaging(DomainQueryExecutionContext sqmExecutionContext) {
        return new SqmJdbcExecutionContextAdapter(sqmExecutionContext);
    }

    public static SqmJdbcExecutionContextAdapter usingLockingAndPaging(DomainQueryExecutionContext sqmExecutionContext) {
        return new SqmJdbcExecutionContextAdapter(sqmExecutionContext, sqmExecutionContext.getQueryOptions());
    }

    private SqmJdbcExecutionContextAdapter(DomainQueryExecutionContext sqmExecutionContext) {
        this(sqmExecutionContext, SqlOmittingQueryOptions.omitSqlQueryOptions(sqmExecutionContext.getQueryOptions()));
    }

    private SqmJdbcExecutionContextAdapter(DomainQueryExecutionContext sqmExecutionContext, QueryOptions queryOptions) {
        super(sqmExecutionContext.getSession());
        this.sqmExecutionContext = sqmExecutionContext;
        this.queryOptions = queryOptions;
    }

    public SqmJdbcExecutionContextAdapter(DomainQueryExecutionContext sqmExecutionContext, JdbcOperationQuerySelect jdbcSelect) {
        this(sqmExecutionContext, SqlOmittingQueryOptions.omitSqlQueryOptions(sqmExecutionContext.getQueryOptions(), jdbcSelect));
    }

    @Override
    public QueryOptions getQueryOptions() {
        return this.queryOptions;
    }

    @Override
    public QueryParameterBindings getQueryParameterBindings() {
        return this.sqmExecutionContext.getQueryParameterBindings();
    }

    @Override
    public Callback getCallback() {
        return this.sqmExecutionContext.getCallback();
    }

    @Override
    public boolean hasQueryExecutionToBeAddedToStatistics() {
        return true;
    }

    @Override
    public boolean upgradeLocks() {
        return true;
    }
}

