/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import jakarta.persistence.metamodel.MapAttribute;
import jakarta.persistence.metamodel.PluralAttribute;
import jakarta.persistence.metamodel.SingularAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.hibernate.internal.util.NullnessUtil;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.ManagedDomainType;
import org.hibernate.metamodel.model.domain.PersistentAttribute;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmPolymorphicRootDescriptor;
import org.hibernate.query.sqm.tree.domain.SqmTreatedPath;
import org.hibernate.query.sqm.tree.domain.SqmTreatedSimplePath;
import org.hibernate.query.sqm.tree.expression.AbstractSqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmLiteral;
import org.hibernate.spi.EntityIdentifierNavigablePath;
import org.hibernate.spi.NavigablePath;

public abstract class AbstractSqmPath<T>
extends AbstractSqmExpression<T>
implements SqmPath<T> {
    private final NavigablePath navigablePath;
    private final SqmPath<?> lhs;
    private Map<String, SqmPath<?>> reusablePaths;

    protected AbstractSqmPath(NavigablePath navigablePath, SqmPathSource<T> referencedPathSource, SqmPath<?> lhs, NodeBuilder nodeBuilder) {
        super(referencedPathSource, nodeBuilder);
        this.navigablePath = navigablePath;
        this.lhs = lhs;
    }

    @Override
    protected void copyTo(AbstractSqmPath<T> target, SqmCopyContext context) {
        assert (this.lhs == null || this.lhs.getNavigablePath() == target.getLhs().getNavigablePath() || this.getRoot(this.lhs).getNodeType() instanceof SqmPolymorphicRootDescriptor);
        super.copyTo(target, context);
        if (this.reusablePaths != null) {
            target.reusablePaths = new HashMap(this.reusablePaths.size());
            for (Map.Entry<String, SqmPath<?>> entry : this.reusablePaths.entrySet()) {
                target.reusablePaths.put(entry.getKey(), (SqmPath<?>)entry.getValue().copy(context));
            }
        }
    }

    private SqmPath<?> getRoot(SqmPath<?> lhs) {
        return lhs.getLhs() == null ? lhs : this.getRoot((SqmPath<?>)lhs.getLhs());
    }

    @Override
    public SqmPathSource<T> getNodeType() {
        return (SqmPathSource)super.getNodeType();
    }

    @Override
    public SqmPathSource<T> getReferencedPathSource() {
        return (SqmPathSource)super.getNodeType();
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public SqmPath<?> getLhs() {
        return this.lhs;
    }

    @Override
    public List<SqmPath<?>> getReusablePaths() {
        if (this.reusablePaths == null) {
            return Collections.emptyList();
        }
        return new ArrayList(this.reusablePaths.values());
    }

    @Override
    public void visitReusablePaths(Consumer<SqmPath<?>> consumer) {
        if (this.reusablePaths != null) {
            this.reusablePaths.values().forEach(consumer);
        }
    }

    @Override
    public void registerReusablePath(SqmPath<?> path) {
        String relativeName;
        SqmPath<?> previous;
        assert (path.getLhs() == this);
        if (this.reusablePaths == null) {
            this.reusablePaths = new HashMap();
        }
        if ((previous = this.reusablePaths.put(relativeName = path.getNavigablePath().getLocalName(), path)) != null && previous != path) {
            throw new IllegalStateException("Implicit-join path registration unexpectedly overrode previous registration - " + relativeName);
        }
    }

    @Override
    public SqmPath<?> getReusablePath(String name) {
        if (this.reusablePaths == null) {
            return null;
        }
        return this.reusablePaths.get(name);
    }

    @Override
    public String getExplicitAlias() {
        return this.getAlias();
    }

    @Override
    public void setExplicitAlias(String explicitAlias) {
        this.setAlias(explicitAlias);
    }

    public SqmPathSource<T> getModel() {
        return this.getReferencedPathSource();
    }

    @Override
    public SqmPathSource<?> getResolvedModel() {
        PersistentAttribute concreteAttribute;
        DomainType<?> lhsType;
        SqmPathSource<T> pathSource = this.getReferencedPathSource();
        if (pathSource.isGeneric() && (lhsType = this.getLhs().getReferencedPathSource().getSqmPathType()) instanceof ManagedDomainType && (concreteAttribute = ((ManagedDomainType)lhsType).findConcreteGenericAttribute(pathSource.getPathName())) != null) {
            return (SqmPathSource)((Object)concreteAttribute);
        }
        return this.getModel();
    }

    @Override
    public SqmExpression<Class<? extends T>> type() {
        SqmPathSource<T> referencedPathSource = this.getReferencedPathSource();
        SqmPathSource<?> subPathSource = referencedPathSource.findSubPathSource("{discriminator}");
        if (subPathSource == null) {
            return new SqmLiteral<Class<? extends T>>(referencedPathSource.getBindableJavaType(), this.nodeBuilder().getTypeConfiguration().getBasicTypeForJavaType(Class.class), this.nodeBuilder());
        }
        return this.resolvePath("{discriminator}", subPathSource);
    }

    @Override
    public SqmPath<?> get(String attributeName) {
        SqmPathSource<?> subNavigable = this.getResolvedModel().getSubPathSource(attributeName, this.nodeBuilder().getSessionFactory().getJpaMetamodel());
        return this.resolvePath(attributeName, subNavigable);
    }

    protected <X> SqmPath<X> resolvePath(PersistentAttribute<?, X> attribute) {
        return this.resolvePath(attribute.getName(), (SqmPathSource)((Object)attribute));
    }

    protected <X> SqmPath<X> resolvePath(String attributeName, SqmPathSource<X> pathSource) {
        if (this.reusablePaths == null) {
            this.reusablePaths = new HashMap();
            SqmPath<X> path = pathSource.createSqmPath(this, this.getResolvedModel().getIntermediatePathSource(pathSource));
            this.reusablePaths.put(attributeName, path);
            return path;
        }
        return this.reusablePaths.computeIfAbsent(attributeName, name -> pathSource.createSqmPath(this, this.getResolvedModel().getIntermediatePathSource(pathSource)));
    }

    protected <S extends T> SqmTreatedPath<T, S> getTreatedPath(EntityDomainType<S> treatTarget) {
        NavigablePath treat = this.getNavigablePath().treatAs(treatTarget.getHibernateEntityName());
        SqmTreatedSimplePath path = (SqmTreatedSimplePath)this.getLhs().getReusablePath(treat.getLocalName());
        if (path == null) {
            path = new SqmTreatedSimplePath(this, treatTarget, (NodeBuilder)this.nodeBuilder());
            this.getLhs().registerReusablePath(path);
        }
        return path;
    }

    protected NavigablePath getNavigablePathCopy(SqmPath<?> parent) {
        return this.getNavigablePathCopy(NullnessUtil.castNonNull(this.navigablePath.getRealParent()), parent.getNavigablePath(), false, null);
    }

    private NavigablePath getNavigablePathCopy(NavigablePath realParent, NavigablePath parent, boolean isId, String identifierAttributeName) {
        if (parent == realParent) {
            return this.navigablePath;
        }
        if (!isId && realParent instanceof EntityIdentifierNavigablePath) {
            return this.getNavigablePathCopy(NullnessUtil.castNonNull(realParent.getRealParent()), parent, true, ((EntityIdentifierNavigablePath)realParent).getIdentifierAttributeName());
        }
        if (CollectionPart.Nature.fromNameExact(realParent.getLocalName()) != null) {
            if (parent == realParent.getRealParent()) {
                return this.navigablePath;
            }
            parent = parent.append(realParent.getLocalName());
        }
        if (isId) {
            parent = new EntityIdentifierNavigablePath(parent, identifierAttributeName);
        }
        return parent.append(this.navigablePath.getLocalName(), this.navigablePath.getAlias());
    }

    @Override
    public <Y> SqmPath<Y> get(SingularAttribute<? super T, Y> jpaAttribute) {
        return this.resolvePath((PersistentAttribute)jpaAttribute);
    }

    @Override
    public <E, C extends Collection<E>> SqmPath<C> get(PluralAttribute<T, C, E> attribute) {
        return this.resolvePath((PersistentAttribute)attribute);
    }

    @Override
    public <K, V, M extends Map<K, V>> SqmPath<M> get(MapAttribute<T, K, V> map) {
        return this.resolvePath((PersistentAttribute)map);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.navigablePath + ")";
    }
}

