/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.update;

import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.metamodel.SingularAttribute;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.query.criteria.JpaCriteriaUpdate;
import org.hibernate.query.criteria.JpaPath;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmQuerySource;
import org.hibernate.query.sqm.internal.SqmCriteriaNodeBuilder;
import org.hibernate.query.sqm.tree.AbstractSqmRestrictedDmlStatement;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmDeleteOrUpdateStatement;
import org.hibernate.query.sqm.tree.cte.SqmCteStatement;
import org.hibernate.query.sqm.tree.domain.AbstractSqmPath;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.update.SqmAssignment;
import org.hibernate.query.sqm.tree.update.SqmSetClause;

public class SqmUpdateStatement<T>
extends AbstractSqmRestrictedDmlStatement<T>
implements SqmDeleteOrUpdateStatement<T>,
JpaCriteriaUpdate<T> {
    private boolean versioned;
    private SqmSetClause setClause;

    public SqmUpdateStatement(SqmRoot<T> target, NodeBuilder nodeBuilder) {
        this(target, SqmQuerySource.HQL, nodeBuilder);
    }

    public SqmUpdateStatement(SqmRoot<T> target, SqmQuerySource querySource, NodeBuilder nodeBuilder) {
        super(target, querySource, nodeBuilder);
    }

    public SqmUpdateStatement(Class<T> targetEntity, SqmCriteriaNodeBuilder nodeBuilder) {
        this(new SqmRoot(nodeBuilder.getDomainModel().entity(targetEntity), null, false, (NodeBuilder)nodeBuilder), SqmQuerySource.CRITERIA, (NodeBuilder)nodeBuilder);
    }

    public SqmUpdateStatement(NodeBuilder builder, SqmQuerySource querySource, Set<SqmParameter<?>> parameters, Map<String, SqmCteStatement<?>> cteStatements, SqmRoot<T> target) {
        super(builder, querySource, parameters, cteStatements, target);
    }

    @Override
    public SqmUpdateStatement<T> copy(SqmCopyContext context) {
        SqmUpdateStatement existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmUpdateStatement<T> statement = context.registerCopy(this, new SqmUpdateStatement<T>(this.nodeBuilder(), this.getQuerySource(), this.copyParameters(context), this.copyCteStatements(context), ((SqmRoot)this.getTarget()).copy(context)));
        statement.setWhereClause(this.copyWhereClause(context));
        statement.versioned = this.versioned;
        if (this.setClause != null) {
            statement.setClause = this.setClause.copy(context);
        }
        return statement;
    }

    public SqmSetClause getSetClause() {
        return this.setClause;
    }

    public void setSetClause(SqmSetClause setClause) {
        this.setClause = setClause;
    }

    public <Y, X extends Y> SqmUpdateStatement<T> set(SingularAttribute<? super T, Y> attribute, X value) {
        this.applyAssignment((SqmPath<Y>)((AbstractSqmPath)((Object)this.getTarget())).get((SingularAttribute)attribute), (SqmExpression)this.nodeBuilder().value(value));
        return this;
    }

    public <Y> SqmUpdateStatement<T> set(SingularAttribute<? super T, Y> attribute, Expression<? extends Y> value) {
        this.applyAssignment((SqmPath<Y>)((AbstractSqmPath)((Object)this.getTarget())).get((SingularAttribute)attribute), (SqmExpression)value);
        return this;
    }

    public <Y, X extends Y> SqmUpdateStatement<T> set(Path<Y> attribute, X value) {
        this.applyAssignment((SqmPath)attribute, (SqmExpression)this.nodeBuilder().value(value));
        return this;
    }

    public <Y> SqmUpdateStatement<T> set(Path<Y> attribute, Expression<? extends Y> value) {
        this.applyAssignment((SqmPath)attribute, (SqmExpression)value);
        return this;
    }

    public SqmUpdateStatement<T> set(String attributeName, Object value) {
        JpaPath sqmPath = ((AbstractSqmPath)((Object)this.getTarget())).get(attributeName);
        this.applyAssignment((SqmPath)sqmPath, (SqmExpression)this.nodeBuilder().value(value));
        return this;
    }

    @Override
    public boolean isVersioned() {
        return this.versioned;
    }

    @Override
    public SqmUpdateStatement<T> versioned() {
        this.versioned = true;
        return this;
    }

    @Override
    public SqmUpdateStatement<T> versioned(boolean versioned) {
        this.versioned = versioned;
        return this;
    }

    public SqmUpdateStatement<T> where(Expression<Boolean> restriction) {
        this.setWhere(restriction);
        return this;
    }

    public SqmUpdateStatement<T> where(Predicate ... restrictions) {
        this.setWhere(restrictions);
        return this;
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitUpdateStatement(this);
    }

    public <Y> void applyAssignment(SqmPath<Y> targetPath, SqmExpression<? extends Y> value) {
        if (this.setClause == null) {
            this.setClause = new SqmSetClause();
        }
        this.setClause.addAssignment(new SqmAssignment<Y>(targetPath, value));
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        this.appendHqlCteString(sb);
        sb.append("update ");
        if (this.versioned) {
            sb.append("versioned ");
        }
        sb.append(((SqmRoot)this.getTarget()).getEntityName());
        sb.append(' ').append(this.getTarget().resolveAlias());
        sb.append(" set ");
        List<SqmAssignment<?>> assignments = this.setClause.getAssignments();
        SqmUpdateStatement.appendAssignment(assignments.get(0), sb);
        for (int i = 1; i < assignments.size(); ++i) {
            sb.append(", ");
            SqmUpdateStatement.appendAssignment(assignments.get(i), sb);
        }
        super.appendHqlString(sb);
    }

    private static void appendAssignment(SqmAssignment<?> sqmAssignment, StringBuilder sb) {
        sqmAssignment.getTargetPath().appendHqlString(sb);
        sb.append(" = ");
        sqmAssignment.getValue().appendHqlString(sb);
    }
}

