/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.embeddable.internal;

import org.hibernate.engine.FetchTiming;
import org.hibernate.graph.spi.GraphImplementor;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.model.domain.JpaMetamodel;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableGroupProducer;
import org.hibernate.sql.results.graph.AbstractFetchParent;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.embeddable.EmbeddableInitializer;
import org.hibernate.sql.results.graph.embeddable.EmbeddableResultGraphNode;
import org.hibernate.sql.results.graph.embeddable.EmbeddableValuedFetchable;
import org.hibernate.sql.results.graph.embeddable.internal.EmbeddableAssembler;
import org.hibernate.sql.results.graph.embeddable.internal.EmbeddableFetchInitializer;

public class EmbeddableFetchImpl
extends AbstractFetchParent
implements EmbeddableResultGraphNode,
Fetch {
    private final FetchParent fetchParent;
    private final FetchTiming fetchTiming;
    private final TableGroup tableGroup;
    private final boolean hasTableGroup;

    public EmbeddableFetchImpl(NavigablePath navigablePath, EmbeddableValuedFetchable embeddedPartDescriptor, FetchParent fetchParent, FetchTiming fetchTiming, boolean hasTableGroup, DomainResultCreationState creationState) {
        super(embeddedPartDescriptor.getEmbeddableTypeDescriptor(), navigablePath);
        this.fetchParent = fetchParent;
        this.fetchTiming = fetchTiming;
        this.hasTableGroup = hasTableGroup;
        this.tableGroup = creationState.getSqlAstCreationState().getFromClauseAccess().resolveTableGroup(this.getNavigablePath(), np -> {
            TableGroup lhsTableGroup = creationState.getSqlAstCreationState().getFromClauseAccess().findTableGroup(fetchParent.getNavigablePath());
            TableGroupJoin tableGroupJoin = this.getReferencedMappingContainer().createTableGroupJoin(this.getNavigablePath(), lhsTableGroup, null, null, SqlAstJoinType.INNER, true, false, creationState.getSqlAstCreationState());
            lhsTableGroup.addTableGroupJoin(tableGroupJoin);
            return tableGroupJoin.getJoinedGroup();
        });
        this.afterInitialize(this, creationState);
    }

    protected EmbeddableFetchImpl(EmbeddableFetchImpl original) {
        super(original.getFetchContainer(), original.getNavigablePath());
        this.fetchParent = original.fetchParent;
        this.fetchTiming = original.fetchTiming;
        this.tableGroup = original.tableGroup;
        this.hasTableGroup = original.hasTableGroup;
    }

    @Override
    public FetchTiming getTiming() {
        return this.fetchTiming;
    }

    @Override
    public boolean hasTableGroup() {
        return this.hasTableGroup;
    }

    @Override
    public FetchParent getFetchParent() {
        return this.fetchParent;
    }

    @Override
    public EmbeddableMappingType getFetchContainer() {
        return (EmbeddableMappingType)super.getFetchContainer();
    }

    @Override
    public EmbeddableValuedModelPart getReferencedMappingContainer() {
        return this.getFetchContainer().getEmbeddedValueMapping();
    }

    @Override
    public Fetchable getFetchedMapping() {
        return this.getReferencedMappingContainer();
    }

    @Override
    public NavigablePath resolveNavigablePath(Fetchable fetchable) {
        if (fetchable instanceof TableGroupProducer) {
            for (TableGroupJoin tableGroupJoin : this.tableGroup.getTableGroupJoins()) {
                NavigablePath navigablePath = tableGroupJoin.getNavigablePath();
                if (!tableGroupJoin.getJoinedGroup().isFetched() || !fetchable.getFetchableName().equals(navigablePath.getLocalName()) || tableGroupJoin.getJoinedGroup().getModelPart() != fetchable) continue;
                return navigablePath;
            }
        }
        return super.resolveNavigablePath(fetchable);
    }

    @Override
    public EmbeddableMappingType getReferencedMappingType() {
        return this.getFetchContainer();
    }

    public DomainResultAssembler createAssembler(FetchParentAccess parentAccess, AssemblerCreationState creationState) {
        EmbeddableInitializer initializer = creationState.resolveInitializer(this.getNavigablePath(), this.getReferencedModePart(), () -> this.buildEmbeddableFetchInitializer(parentAccess, this, creationState)).asEmbeddableInitializer();
        assert (initializer != null);
        return new EmbeddableAssembler(initializer);
    }

    protected Initializer buildEmbeddableFetchInitializer(FetchParentAccess parentAccess, EmbeddableResultGraphNode embeddableFetch, AssemblerCreationState creationState) {
        return new EmbeddableFetchInitializer(parentAccess, this, creationState);
    }

    @Override
    public boolean appliesTo(GraphImplementor<?> graphImplementor, JpaMetamodel metamodel) {
        return this.getFetchParent().appliesTo(graphImplementor, metamodel);
    }
}

