/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.hibernate.Filter;
import org.hibernate.Internal;
import org.hibernate.UnknownProfileException;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.profile.Fetch;
import org.hibernate.engine.profile.FetchProfile;
import org.hibernate.engine.spi.EffectiveEntityGraph;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.graph.GraphSemantic;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.internal.FilterImpl;
import org.hibernate.internal.SessionCreationOptions;
import org.hibernate.loader.ast.spi.CascadingFetchProfile;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;

public class LoadQueryInfluencers
implements Serializable {
    @Deprecated(forRemoval=true)
    public static final LoadQueryInfluencers NONE = new LoadQueryInfluencers();
    private final SessionFactoryImplementor sessionFactory;
    private CascadingFetchProfile enabledCascadingFetchProfile;
    private HashSet<String> enabledFetchProfileNames;
    private HashMap<String, Filter> enabledFilters;
    private boolean subselectFetchEnabled;
    private int batchSize = -1;
    private final EffectiveEntityGraph effectiveEntityGraph = new EffectiveEntityGraph();
    private Boolean readOnly;

    public LoadQueryInfluencers() {
        this.sessionFactory = null;
    }

    public LoadQueryInfluencers(SessionFactoryImplementor sessionFactory) {
        this.sessionFactory = sessionFactory;
        this.batchSize = sessionFactory.getSessionFactoryOptions().getDefaultBatchFetchSize();
        this.subselectFetchEnabled = sessionFactory.getSessionFactoryOptions().isSubselectFetchEnabled();
    }

    public LoadQueryInfluencers(SessionFactoryImplementor sessionFactory, SessionCreationOptions options) {
        this.sessionFactory = sessionFactory;
        this.batchSize = options.getDefaultBatchFetchSize();
        this.subselectFetchEnabled = options.isSubselectFetchEnabled();
    }

    public EffectiveEntityGraph applyEntityGraph(RootGraphImplementor<?> rootGraph, GraphSemantic graphSemantic) {
        EffectiveEntityGraph effectiveEntityGraph = this.getEffectiveEntityGraph();
        if (graphSemantic != null) {
            if (rootGraph == null) {
                throw new IllegalArgumentException("Graph semantic specified, but no RootGraph was supplied");
            }
            effectiveEntityGraph.applyGraph(rootGraph, graphSemantic);
        }
        return effectiveEntityGraph;
    }

    public SessionFactoryImplementor getSessionFactory() {
        return this.sessionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T fromInternalFetchProfile(CascadingFetchProfile profile, Supplier<T> supplier) {
        CascadingFetchProfile previous = this.enabledCascadingFetchProfile;
        this.enabledCascadingFetchProfile = profile;
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            this.enabledCascadingFetchProfile = previous;
        }
    }

    public CascadingFetchProfile getEnabledCascadingFetchProfile() {
        return this.enabledCascadingFetchProfile;
    }

    public boolean hasEnabledCascadingFetchProfile() {
        return this.enabledCascadingFetchProfile != null;
    }

    public void setEnabledCascadingFetchProfile(CascadingFetchProfile enabledCascadingFetchProfile) {
        this.checkMutability();
        this.enabledCascadingFetchProfile = enabledCascadingFetchProfile;
    }

    @Deprecated(since="6.0")
    public String getInternalFetchProfile() {
        return this.getEnabledCascadingFetchProfile().getLegacyName();
    }

    @Deprecated(since="6.0")
    public void setInternalFetchProfile(String internalFetchProfile) {
        this.setEnabledCascadingFetchProfile(CascadingFetchProfile.fromLegacyName(internalFetchProfile));
    }

    public boolean hasEnabledFilters() {
        return this.enabledFilters != null && !this.enabledFilters.isEmpty();
    }

    public Map<String, Filter> getEnabledFilters() {
        if (this.enabledFilters == null) {
            return Collections.emptyMap();
        }
        for (Filter filter : this.enabledFilters.values()) {
            filter.validate();
        }
        return this.enabledFilters;
    }

    public Set<String> getEnabledFilterNames() {
        if (this.enabledFilters == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.enabledFilters.keySet());
    }

    public Filter getEnabledFilter(String filterName) {
        if (this.enabledFilters == null) {
            return null;
        }
        return this.enabledFilters.get(filterName);
    }

    public Filter enableFilter(String filterName) {
        this.checkMutability();
        FilterImpl filter = new FilterImpl(this.sessionFactory.getFilterDefinition(filterName));
        if (this.enabledFilters == null) {
            this.enabledFilters = new HashMap();
        }
        this.enabledFilters.put(filterName, filter);
        return filter;
    }

    public void disableFilter(String filterName) {
        if (this.enabledFilters != null) {
            this.enabledFilters.remove(filterName);
        }
    }

    public Object getFilterParameterValue(String filterParameterName) {
        String[] parsed = LoadQueryInfluencers.parseFilterParameterName(filterParameterName);
        if (this.enabledFilters == null) {
            throw new IllegalArgumentException("Filter [" + parsed[0] + "] currently not enabled");
        }
        FilterImpl filter = (FilterImpl)this.enabledFilters.get(parsed[0]);
        if (filter == null) {
            throw new IllegalArgumentException("Filter [" + parsed[0] + "] currently not enabled");
        }
        return filter.getParameter(parsed[1]);
    }

    public static String[] parseFilterParameterName(String filterParameterName) {
        int dot = filterParameterName.lastIndexOf(46);
        if (dot <= 0) {
            throw new IllegalArgumentException("Invalid filter-parameter name format [" + filterParameterName + "]; expecting {filter-name}.{param-name}");
        }
        String filterName = filterParameterName.substring(0, dot);
        String parameterName = filterParameterName.substring(dot + 1);
        return new String[]{filterName, parameterName};
    }

    public boolean hasEnabledFetchProfiles() {
        return this.enabledFetchProfileNames != null && !this.enabledFetchProfileNames.isEmpty();
    }

    public Set<String> getEnabledFetchProfileNames() {
        return this.enabledFetchProfileNames == null ? Collections.emptySet() : this.enabledFetchProfileNames;
    }

    private void checkFetchProfileName(String name) {
        if (this.sessionFactory != null && !this.sessionFactory.containsFetchProfileDefinition(name)) {
            throw new UnknownProfileException(name);
        }
    }

    public boolean isFetchProfileEnabled(String name) throws UnknownProfileException {
        this.checkFetchProfileName(name);
        return this.enabledFetchProfileNames != null && this.enabledFetchProfileNames.contains(name);
    }

    public void enableFetchProfile(String name) throws UnknownProfileException {
        this.checkMutability();
        this.checkFetchProfileName(name);
        if (this.enabledFetchProfileNames == null) {
            this.enabledFetchProfileNames = new HashSet();
        }
        this.enabledFetchProfileNames.add(name);
    }

    public void disableFetchProfile(String name) throws UnknownProfileException {
        this.checkFetchProfileName(name);
        if (this.enabledFetchProfileNames != null) {
            this.enabledFetchProfileNames.remove(name);
        }
    }

    @Internal
    public HashSet<String> adjustFetchProfiles(Set<String> disabledFetchProfiles, Set<String> enabledFetchProfiles) {
        HashSet<String> oldFetchProfiles;
        HashSet<String> hashSet = oldFetchProfiles = this.hasEnabledFetchProfiles() ? new HashSet<String>(this.enabledFetchProfileNames) : null;
        if (disabledFetchProfiles != null && this.enabledFetchProfileNames != null) {
            this.enabledFetchProfileNames.removeAll(disabledFetchProfiles);
        }
        if (enabledFetchProfiles != null) {
            if (this.enabledFetchProfileNames == null) {
                this.enabledFetchProfileNames = new HashSet();
            }
            this.enabledFetchProfileNames.addAll(enabledFetchProfiles);
        }
        return oldFetchProfiles;
    }

    @Internal
    public void setEnabledFetchProfileNames(HashSet<String> enabledFetchProfileNames) {
        this.enabledFetchProfileNames = enabledFetchProfileNames;
    }

    public EffectiveEntityGraph getEffectiveEntityGraph() {
        return this.effectiveEntityGraph;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public int effectiveBatchSize(CollectionPersister persister) {
        int persisterBatchSize = persister.getBatchSize();
        return persisterBatchSize >= 0 ? persisterBatchSize : this.batchSize;
    }

    public boolean effectivelyBatchLoadable(CollectionPersister persister) {
        return this.batchSize > 1 || persister.isBatchLoadable();
    }

    public int effectiveBatchSize(EntityPersister persister) {
        int persisterBatchSize = persister.getBatchSize();
        return persisterBatchSize >= 0 ? persisterBatchSize : this.batchSize;
    }

    public boolean effectivelyBatchLoadable(EntityPersister persister) {
        return this.batchSize > 1 || persister.isBatchLoadable();
    }

    public boolean getSubselectFetchEnabled() {
        return this.subselectFetchEnabled;
    }

    public void setSubselectFetchEnabled(boolean subselectFetchEnabled) {
        this.subselectFetchEnabled = subselectFetchEnabled;
    }

    public boolean effectiveSubselectFetchEnabled(CollectionPersister persister) {
        return this.subselectFetchEnabled || persister.isSubselectLoadable() || this.isSubselectFetchEnabledInProfile(persister);
    }

    private boolean isSubselectFetchEnabledInProfile(CollectionPersister persister) {
        if (this.hasEnabledFetchProfiles()) {
            for (String profile : this.getEnabledFetchProfileNames()) {
                Fetch fetch;
                FetchProfile fetchProfile = this.sessionFactory.getFetchProfile(profile);
                if (fetchProfile == null || (fetch = fetchProfile.getFetchByRole(persister.getRole())) == null || fetch.getMethod() != FetchStyle.SUBSELECT) continue;
                return true;
            }
        }
        return false;
    }

    private void checkMutability() {
        if (this.sessionFactory == null) {
            throw new IllegalStateException("Cannot modify context-less LoadQueryInfluencers");
        }
    }

    public boolean hasSubselectLoadableCollections(EntityPersister persister) {
        return persister.hasSubselectLoadableCollections() || this.subselectFetchEnabled && persister.hasCollections() || this.hasSubselectLoadableCollectionsEnabledInProfile(persister);
    }

    private boolean hasSubselectLoadableCollectionsEnabledInProfile(EntityPersister persister) {
        if (this.hasEnabledFetchProfiles()) {
            for (String profile : this.getEnabledFetchProfileNames()) {
                if (!this.sessionFactory.getFetchProfile(profile).hasSubselectLoadableCollectionsEnabled(persister)) continue;
                return true;
            }
        }
        return false;
    }
}

