/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal;

import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.graph.internal.SubGraphImpl;
import org.hibernate.graph.spi.SubGraphImplementor;
import org.hibernate.metamodel.MappingMetamodel;
import org.hibernate.metamodel.mapping.MappingModelHelper;
import org.hibernate.metamodel.model.domain.EmbeddableDomainType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.JpaMetamodel;
import org.hibernate.metamodel.model.domain.ManagedDomainType;
import org.hibernate.metamodel.model.domain.PersistentAttribute;
import org.hibernate.metamodel.model.domain.spi.JpaMetamodelImplementor;
import org.hibernate.persister.entity.EntityPersister;

public class DomainModelHelper {
    public static <T, S extends T> ManagedDomainType<S> resolveSubType(ManagedDomainType<T> baseType, String subTypeName, JpaMetamodel jpaMetamodel) {
        if (baseType instanceof EmbeddableDomainType) {
            return baseType;
        }
        EntityDomainType subManagedType = jpaMetamodel.resolveHqlEntityReference(subTypeName);
        if (subManagedType != null) {
            return subManagedType;
        }
        try {
            Class javaType = jpaMetamodel.getServiceRegistry().getService(ClassLoaderService.class).classForName(subTypeName);
            return jpaMetamodel.managedType(javaType);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Unknown subtype name (" + baseType.getTypeName() + ") : " + subTypeName);
        }
    }

    static boolean isCompatible(PersistentAttribute<?, ?> attribute1, PersistentAttribute<?, ?> attribute2, JpaMetamodelImplementor jpaMetamodel) {
        if (attribute1 == attribute2) {
            return true;
        }
        MappingMetamodel mappingMetamodel = jpaMetamodel.getMappingMetamodel();
        EntityPersister entity1 = mappingMetamodel.getEntityDescriptor(attribute1.getDeclaringType().getTypeName());
        EntityPersister entity2 = mappingMetamodel.getEntityDescriptor(attribute2.getDeclaringType().getTypeName());
        return entity1 != null && entity2 != null && MappingModelHelper.isCompatibleModelPart(entity1.findSubPart(attribute1.getName()), entity2.findSubPart(attribute2.getName()));
    }

    public static <J, S> ManagedDomainType<S> findSubType(ManagedDomainType<J> type, Class<S> subtype) {
        if (type.getBindableJavaType() == subtype) {
            ManagedDomainType<J> result = type;
            return result;
        }
        for (ManagedDomainType<J> candidate : type.getSubTypes()) {
            if (candidate.getBindableJavaType() != subtype) continue;
            ManagedDomainType<J> result = candidate;
            return result;
        }
        for (ManagedDomainType<J> candidate : type.getSubTypes()) {
            ManagedDomainType<S> candidateSubtype = DomainModelHelper.findSubType(candidate, subtype);
            if (candidateSubtype == null) continue;
            return candidateSubtype;
        }
        throw new IllegalArgumentException("The class '" + subtype.getName() + "' is not a mapped subtype of '" + type.getTypeName() + "'");
    }

    public static <J, S> SubGraphImplementor<S> makeSubGraph(ManagedDomainType<J> type, Class<S> subtype) {
        if (type.getBindableJavaType().isAssignableFrom(subtype)) {
            return new SubGraphImpl<J>(type, true);
        }
        throw new IllegalArgumentException(String.format("Type '%s' cannot be treated as subtype '%s'", type.getTypeName(), subtype.getName()));
    }
}

