/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.collection;

import org.hibernate.HibernateException;
import org.hibernate.Internal;
import org.hibernate.MappingException;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.access.CollectionDataAccess;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.jdbc.mutation.JdbcValueBindings;
import org.hibernate.engine.jdbc.mutation.ParameterUsage;
import org.hibernate.engine.jdbc.mutation.internal.MutationQueryOptions;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.FilterAliasGenerator;
import org.hibernate.internal.StaticFilterAliasGenerator;
import org.hibernate.internal.util.MutableInteger;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.mapping.Collection;
import org.hibernate.metamodel.mapping.CollectionIdentifierDescriptor;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.collection.AbstractCollectionPersister;
import org.hibernate.persister.collection.mutation.CollectionTableMapping;
import org.hibernate.persister.collection.mutation.DeleteRowsCoordinator;
import org.hibernate.persister.collection.mutation.DeleteRowsCoordinatorNoOp;
import org.hibernate.persister.collection.mutation.DeleteRowsCoordinatorStandard;
import org.hibernate.persister.collection.mutation.InsertRowsCoordinator;
import org.hibernate.persister.collection.mutation.InsertRowsCoordinatorNoOp;
import org.hibernate.persister.collection.mutation.InsertRowsCoordinatorStandard;
import org.hibernate.persister.collection.mutation.OperationProducer;
import org.hibernate.persister.collection.mutation.RemoveCoordinator;
import org.hibernate.persister.collection.mutation.RemoveCoordinatorNoOp;
import org.hibernate.persister.collection.mutation.RemoveCoordinatorStandard;
import org.hibernate.persister.collection.mutation.RowMutationOperations;
import org.hibernate.persister.collection.mutation.UpdateRowsCoordinator;
import org.hibernate.persister.collection.mutation.UpdateRowsCoordinatorNoOp;
import org.hibernate.persister.collection.mutation.UpdateRowsCoordinatorStandard;
import org.hibernate.persister.spi.PersisterCreationContext;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.model.ModelMutationLogging;
import org.hibernate.sql.model.ast.ColumnValueParameterList;
import org.hibernate.sql.model.ast.MutatingTableReference;
import org.hibernate.sql.model.ast.RestrictedTableMutation;
import org.hibernate.sql.model.ast.TableInsert;
import org.hibernate.sql.model.ast.TableMutation;
import org.hibernate.sql.model.ast.builder.TableDeleteBuilderStandard;
import org.hibernate.sql.model.ast.builder.TableInsertBuilderStandard;
import org.hibernate.sql.model.ast.builder.TableUpdateBuilderStandard;
import org.hibernate.sql.model.jdbc.JdbcDeleteMutation;
import org.hibernate.sql.model.jdbc.JdbcMutationOperation;
import org.hibernate.sql.model.jdbc.JdbcUpdateMutation;

@Internal
public class BasicCollectionPersister
extends AbstractCollectionPersister {
    private final RowMutationOperations rowMutationOperations = this.buildRowMutationOperations();
    private final InsertRowsCoordinator insertRowsCoordinator = this.buildInsertRowCoordinator();
    private final UpdateRowsCoordinator updateCoordinator = this.buildUpdateRowCoordinator();
    private final DeleteRowsCoordinator deleteRowsCoordinator = this.buildDeleteRowCoordinator();
    private final RemoveCoordinator removeCoordinator = this.buildDeleteAllCoordinator();

    @Override
    public boolean isCascadeDeleteEnabled() {
        return false;
    }

    @Deprecated(since="6.0")
    public BasicCollectionPersister(Collection collectionBinding, CollectionDataAccess cacheAccessStrategy, PersisterCreationContext creationContext) throws MappingException, CacheException {
        this(collectionBinding, cacheAccessStrategy, (RuntimeModelCreationContext)creationContext);
    }

    public BasicCollectionPersister(Collection collectionBinding, CollectionDataAccess cacheAccessStrategy, RuntimeModelCreationContext creationContext) throws MappingException, CacheException {
        super(collectionBinding, cacheAccessStrategy, creationContext);
    }

    @Override
    protected RowMutationOperations getRowMutationOperations() {
        return this.rowMutationOperations;
    }

    protected InsertRowsCoordinator getCreateEntryCoordinator() {
        return this.insertRowsCoordinator;
    }

    @Override
    public void recreate(PersistentCollection<?> collection, Object id, SharedSessionContractImplementor session) {
        this.getCreateEntryCoordinator().insertRows(collection, id, collection::includeInRecreate, session);
    }

    @Override
    public void insertRows(PersistentCollection<?> collection, Object id, SharedSessionContractImplementor session) throws HibernateException {
        this.getCreateEntryCoordinator().insertRows(collection, id, collection::includeInInsert, session);
    }

    protected UpdateRowsCoordinator getUpdateEntryCoordinator() {
        return this.updateCoordinator;
    }

    @Override
    public void updateRows(PersistentCollection<?> collection, Object id, SharedSessionContractImplementor session) {
        this.getUpdateEntryCoordinator().updateRows(id, collection, session);
    }

    protected DeleteRowsCoordinator getRemoveEntryCoordinator() {
        return this.deleteRowsCoordinator;
    }

    @Override
    public void deleteRows(PersistentCollection<?> collection, Object id, SharedSessionContractImplementor session) {
        this.getRemoveEntryCoordinator().deleteRows(collection, id, session);
    }

    @Override
    protected RemoveCoordinator getRemoveCoordinator() {
        return this.removeCoordinator;
    }

    @Override
    protected void doProcessQueuedOps(PersistentCollection<?> collection, Object id, SharedSessionContractImplementor session) {
    }

    private UpdateRowsCoordinator buildUpdateRowCoordinator() {
        boolean performUpdates;
        boolean bl = performUpdates = this.getCollectionSemantics().getCollectionClassification().isRowUpdatePossible() && ArrayHelper.isAnyTrue(this.elementColumnIsSettable) && !this.isInverse();
        if (!performUpdates) {
            if (ModelMutationLogging.MODEL_MUTATION_LOGGER.isDebugEnabled()) {
                ModelMutationLogging.MODEL_MUTATION_LOGGER.debugf("Skipping collection row updates - %s", (Object)this.getRolePath());
            }
            return new UpdateRowsCoordinatorNoOp(this);
        }
        return new UpdateRowsCoordinatorStandard(this, this.rowMutationOperations, this.getFactory());
    }

    private InsertRowsCoordinator buildInsertRowCoordinator() {
        if (this.isInverse() || !this.isRowInsertEnabled()) {
            if (ModelMutationLogging.MODEL_MUTATION_LOGGER.isDebugEnabled()) {
                ModelMutationLogging.MODEL_MUTATION_LOGGER.debugf("Skipping collection inserts - %s", (Object)this.getRolePath());
            }
            return new InsertRowsCoordinatorNoOp(this);
        }
        return new InsertRowsCoordinatorStandard(this, this.rowMutationOperations, this.getFactory().getServiceRegistry());
    }

    private DeleteRowsCoordinator buildDeleteRowCoordinator() {
        if (!this.needsRemove()) {
            if (ModelMutationLogging.MODEL_MUTATION_LOGGER.isDebugEnabled()) {
                ModelMutationLogging.MODEL_MUTATION_LOGGER.debugf("Skipping collection row deletions - %s", (Object)this.getRolePath());
            }
            return new DeleteRowsCoordinatorNoOp(this);
        }
        return new DeleteRowsCoordinatorStandard(this, this.rowMutationOperations, this.hasPhysicalIndexColumn(), this.getFactory().getServiceRegistry());
    }

    private RemoveCoordinator buildDeleteAllCoordinator() {
        if (!this.needsRemove()) {
            if (ModelMutationLogging.MODEL_MUTATION_LOGGER.isDebugEnabled()) {
                ModelMutationLogging.MODEL_MUTATION_LOGGER.debugf("Skipping collection removals - %s", (Object)this.getRolePath());
            }
            return new RemoveCoordinatorNoOp(this);
        }
        return new RemoveCoordinatorStandard(this, this::buildDeleteAllOperation, this.getFactory().getServiceRegistry());
    }

    protected RowMutationOperations buildRowMutationOperations() {
        RowMutationOperations.Restrictions deleteRowRestrictions;
        OperationProducer deleteRowOperationProducer;
        RowMutationOperations.Restrictions updateRowRestrictions;
        RowMutationOperations.Values updateRowValues;
        OperationProducer updateRowOperationProducer;
        RowMutationOperations.Values insertRowValues;
        OperationProducer insertRowOperationProducer;
        if (!this.isInverse() && this.isRowInsertEnabled()) {
            insertRowOperationProducer = this::generateInsertRowOperation;
            insertRowValues = this::applyInsertRowValues;
        } else {
            insertRowOperationProducer = null;
            insertRowValues = null;
        }
        if (this.getCollectionSemantics().getCollectionClassification().isRowUpdatePossible() && ArrayHelper.isAnyTrue(this.elementColumnIsSettable) && !this.isInverse()) {
            updateRowOperationProducer = this::generateUpdateRowOperation;
            updateRowValues = this::applyUpdateRowValues;
            updateRowRestrictions = this::applyUpdateRowRestrictions;
        } else {
            updateRowOperationProducer = null;
            updateRowValues = null;
            updateRowRestrictions = null;
        }
        if (!this.isInverse() && this.isRowDeleteEnabled()) {
            deleteRowOperationProducer = this::generateDeleteRowOperation;
            deleteRowRestrictions = this::applyDeleteRowRestrictions;
        } else {
            deleteRowOperationProducer = null;
            deleteRowRestrictions = null;
        }
        return new RowMutationOperations(this, insertRowOperationProducer, insertRowValues, updateRowOperationProducer, updateRowValues, updateRowRestrictions, deleteRowOperationProducer, deleteRowRestrictions);
    }

    private JdbcMutationOperation generateInsertRowOperation(MutatingTableReference tableReference) {
        if (this.getIdentifierTableMapping().getInsertDetails().getCustomSql() != null) {
            return this.buildCustomSqlInsertRowOperation(tableReference);
        }
        return this.buildGeneratedInsertRowOperation(tableReference);
    }

    private JdbcMutationOperation buildCustomSqlInsertRowOperation(MutatingTableReference tableReference) {
        TableInsertBuilderStandard insertBuilder = new TableInsertBuilderStandard(this, tableReference, this.getFactory());
        this.applyInsertDetails(insertBuilder);
        TableInsert tableInsert = insertBuilder.buildMutation();
        return (JdbcMutationOperation)tableInsert.createMutationOperation(null, this.getFactory());
    }

    private void applyInsertDetails(TableInsertBuilderStandard insertBuilder) {
        PluralAttributeMapping attributeMapping = this.getAttributeMapping();
        ForeignKeyDescriptor foreignKey = attributeMapping.getKeyDescriptor();
        foreignKey.getKeyPart().forEachSelectable(insertBuilder);
        CollectionIdentifierDescriptor identifierDescriptor = attributeMapping.getIdentifierDescriptor();
        CollectionPart indexDescriptor = attributeMapping.getIndexDescriptor();
        if (identifierDescriptor != null) {
            identifierDescriptor.forEachSelectable(insertBuilder);
        } else if (indexDescriptor != null) {
            indexDescriptor.forEachInsertable(insertBuilder);
        }
        attributeMapping.getElementDescriptor().forEachInsertable(insertBuilder);
    }

    private JdbcMutationOperation buildGeneratedInsertRowOperation(MutatingTableReference tableReference) {
        TableMutation<JdbcMutationOperation> sqlAst = this.generateInsertRowAst(tableReference);
        SqlAstTranslator<JdbcMutationOperation> translator = this.getFactory().getJdbcServices().getDialect().getSqlAstTranslatorFactory().buildModelMutationTranslator(sqlAst, this.getFactory());
        return translator.translate(null, MutationQueryOptions.INSTANCE);
    }

    private TableMutation<JdbcMutationOperation> generateInsertRowAst(MutatingTableReference tableReference) {
        PluralAttributeMapping pluralAttribute = this.getAttributeMapping();
        assert (pluralAttribute != null);
        ForeignKeyDescriptor fkDescriptor = pluralAttribute.getKeyDescriptor();
        assert (fkDescriptor != null);
        TableInsertBuilderStandard insertBuilder = new TableInsertBuilderStandard(this, tableReference, this.getFactory());
        this.applyInsertDetails(insertBuilder);
        return insertBuilder.buildMutation();
    }

    private void applyInsertRowValues(PersistentCollection<?> collection, Object key, Object rowValue, int rowPosition, SharedSessionContractImplementor session, JdbcValueBindings jdbcValueBindings) {
        PluralAttributeMapping attributeMapping = this.getAttributeMapping();
        if (key == null) {
            throw new IllegalArgumentException("null key for collection: " + this.getNavigableRole().getFullPath());
        }
        ForeignKeyDescriptor foreignKey = attributeMapping.getKeyDescriptor();
        foreignKey.getKeyPart().decompose(key, 0, jdbcValueBindings, null, RowMutationOperations.DEFAULT_VALUE_SETTER, session);
        MutableInteger columnPositionCount = new MutableInteger();
        if (attributeMapping.getIdentifierDescriptor() != null) {
            this.getAttributeMapping().getIdentifierDescriptor().decompose(collection.getIdentifier(rowValue, rowPosition), 0, jdbcValueBindings, null, RowMutationOperations.DEFAULT_VALUE_SETTER, session);
        } else if (attributeMapping.getIndexDescriptor() != null) {
            this.getAttributeMapping().getIndexDescriptor().decompose(this.incrementIndexByBase(collection.getIndex(rowValue, rowPosition, this)), 0, this.indexColumnIsSettable, jdbcValueBindings, (valueIndex, settable, bindings, jdbcValue, jdbcValueMapping) -> {
                if (!jdbcValueMapping.getContainingTableExpression().equals(this.getTableName())) {
                    return;
                }
                if (settable[valueIndex]) {
                    bindings.bindValue(jdbcValue, jdbcValueMapping, ParameterUsage.SET);
                }
            }, session);
            columnPositionCount.set(0);
        }
        attributeMapping.getElementDescriptor().decompose(collection.getElement(rowValue), 0, this.elementColumnIsSettable, jdbcValueBindings, (valueIndex, settable, bindings, jdbcValue, jdbcValueMapping) -> {
            if (settable[valueIndex]) {
                bindings.bindValue(jdbcValue, jdbcValueMapping, ParameterUsage.SET);
            }
        }, session);
    }

    private JdbcMutationOperation generateUpdateRowOperation(MutatingTableReference tableReference) {
        if (this.getIdentifierTableMapping().getUpdateDetails().getCustomSql() != null) {
            return this.buildCustomSqlUpdateRowOperation(tableReference);
        }
        return this.buildGeneratedUpdateRowOperation(tableReference);
    }

    private JdbcMutationOperation buildCustomSqlUpdateRowOperation(MutatingTableReference tableReference) {
        PluralAttributeMapping attribute = this.getAttributeMapping();
        assert (attribute != null);
        ForeignKeyDescriptor foreignKey = attribute.getKeyDescriptor();
        assert (foreignKey != null);
        int keyColumnCount = foreignKey.getJdbcTypeCount();
        ColumnValueParameterList parameterBinders = new ColumnValueParameterList(tableReference, ParameterUsage.RESTRICT, keyColumnCount);
        foreignKey.getKeyPart().forEachSelectable(parameterBinders);
        return new JdbcUpdateMutation(this.getCollectionTableMapping(), this, this.getCollectionTableMapping().getUpdateDetails().getCustomSql(), this.getCollectionTableMapping().getUpdateDetails().isCallable(), this.getCollectionTableMapping().getUpdateDetails().getExpectation(), parameterBinders);
    }

    private JdbcMutationOperation buildGeneratedUpdateRowOperation(MutatingTableReference tableReference) {
        RestrictedTableMutation<JdbcMutationOperation> sqlAst = this.generateUpdateRowAst(tableReference);
        SqlAstTranslator<JdbcMutationOperation> translator = this.getFactory().getJdbcServices().getDialect().getSqlAstTranslatorFactory().buildModelMutationTranslator(sqlAst, this.getFactory());
        return translator.translate(null, MutationQueryOptions.INSTANCE);
    }

    private RestrictedTableMutation<JdbcMutationOperation> generateUpdateRowAst(MutatingTableReference tableReference) {
        PluralAttributeMapping attribute = this.getAttributeMapping();
        assert (attribute != null);
        TableUpdateBuilderStandard updateBuilder = new TableUpdateBuilderStandard(this, tableReference, this.getFactory());
        if (this.hasIndex()) {
            attribute.getElementDescriptor().forEachNonFormula(updateBuilder);
        } else {
            attribute.getElementDescriptor().forEachUpdatable(updateBuilder);
        }
        if (attribute.getIdentifierDescriptor() != null) {
            updateBuilder.addKeyRestrictionsLeniently(attribute.getIdentifierDescriptor());
        } else {
            updateBuilder.addKeyRestrictionsLeniently(attribute.getKeyDescriptor().getKeyPart());
            if (attribute.getIndexDescriptor() != null && !this.indexContainsFormula) {
                updateBuilder.addKeyRestrictionsLeniently(attribute.getIndexDescriptor());
            } else {
                updateBuilder.addKeyRestrictions(attribute.getElementDescriptor());
            }
        }
        return updateBuilder.buildMutation();
    }

    private void applyUpdateRowValues(PersistentCollection<?> collection, Object key, Object entry, int entryPosition, SharedSessionContractImplementor session, JdbcValueBindings jdbcValueBindings) {
        Object element = collection.getElement(entry);
        CollectionPart elementDescriptor = this.getAttributeMapping().getElementDescriptor();
        elementDescriptor.decompose(element, 0, jdbcValueBindings, null, this.hasIndex() ? (valueIndex, bindings, y, jdbcValue, jdbcValueMapping) -> {
            if (jdbcValueMapping.isFormula()) {
                return;
            }
            bindings.bindValue(jdbcValue, jdbcValueMapping, ParameterUsage.SET);
        } : (valueIndex, bindings, y, jdbcValue, jdbcValueMapping) -> {
            if (!jdbcValueMapping.isUpdateable() || jdbcValueMapping.isFormula()) {
                return;
            }
            bindings.bindValue(jdbcValue, jdbcValueMapping, ParameterUsage.SET);
        }, session);
    }

    private void applyUpdateRowRestrictions(PersistentCollection<?> collection, Object key, Object entry, int entryPosition, SharedSessionContractImplementor session, JdbcValueBindings jdbcValueBindings) {
        if (this.getAttributeMapping().getIdentifierDescriptor() != null) {
            CollectionIdentifierDescriptor identifierDescriptor = this.getAttributeMapping().getIdentifierDescriptor();
            Object identifier = collection.getIdentifier(entry, entryPosition);
            identifierDescriptor.decompose(identifier, 0, jdbcValueBindings, null, RowMutationOperations.DEFAULT_RESTRICTOR, session);
        } else {
            this.getAttributeMapping().getKeyDescriptor().getKeyPart().decompose(key, 0, jdbcValueBindings, null, RowMutationOperations.DEFAULT_RESTRICTOR, session);
            if (this.getAttributeMapping().getIndexDescriptor() != null && !this.indexContainsFormula) {
                Object index = collection.getIndex(entry, entryPosition, this.getAttributeMapping().getCollectionDescriptor());
                Object adjustedIndex = this.incrementIndexByBase(index);
                this.getAttributeMapping().getIndexDescriptor().decompose(adjustedIndex, 0, jdbcValueBindings, null, RowMutationOperations.DEFAULT_RESTRICTOR, session);
            } else {
                Object snapshotElement = collection.getSnapshotElement(entry, entryPosition);
                this.getAttributeMapping().getElementDescriptor().decompose(snapshotElement, 0, jdbcValueBindings, null, (valueIndex, bindings, noop, jdbcValue, jdbcValueMapping) -> {
                    if (jdbcValueMapping.isNullable() || jdbcValueMapping.isFormula()) {
                        return;
                    }
                    bindings.bindValue(jdbcValue, jdbcValueMapping, ParameterUsage.RESTRICT);
                }, session);
            }
        }
    }

    private JdbcMutationOperation generateDeleteRowOperation(MutatingTableReference tableReference) {
        if (this.getIdentifierTableMapping().getDeleteRowDetails().getCustomSql() != null) {
            return this.buildCustomSqlDeleteRowOperation(tableReference);
        }
        return this.buildGeneratedDeleteRowOperation(tableReference);
    }

    private JdbcMutationOperation buildCustomSqlDeleteRowOperation(MutatingTableReference tableReference) {
        PluralAttributeMapping attribute = this.getAttributeMapping();
        assert (attribute != null);
        ForeignKeyDescriptor foreignKey = attribute.getKeyDescriptor();
        assert (foreignKey != null);
        CollectionTableMapping tableMapping = (CollectionTableMapping)tableReference.getTableMapping();
        int keyColumnCount = foreignKey.getJdbcTypeCount();
        ColumnValueParameterList parameterBinders = new ColumnValueParameterList(tableReference, ParameterUsage.RESTRICT, keyColumnCount);
        foreignKey.getKeyPart().forEachSelectable(parameterBinders);
        return new JdbcDeleteMutation(tableMapping, this, tableMapping.getDeleteDetails().getCustomSql(), tableMapping.getDeleteDetails().isCallable(), tableMapping.getDeleteDetails().getExpectation(), parameterBinders);
    }

    private JdbcMutationOperation buildGeneratedDeleteRowOperation(MutatingTableReference tableReference) {
        RestrictedTableMutation<JdbcMutationOperation> sqlAst = this.generateDeleteRowAst(tableReference);
        SqlAstTranslator<JdbcMutationOperation> translator = this.getFactory().getJdbcServices().getDialect().getSqlAstTranslatorFactory().buildModelMutationTranslator(sqlAst, this.getFactory());
        return translator.translate(null, MutationQueryOptions.INSTANCE);
    }

    private RestrictedTableMutation<JdbcMutationOperation> generateDeleteRowAst(MutatingTableReference tableReference) {
        PluralAttributeMapping pluralAttribute = this.getAttributeMapping();
        assert (pluralAttribute != null);
        ForeignKeyDescriptor fkDescriptor = pluralAttribute.getKeyDescriptor();
        assert (fkDescriptor != null);
        TableDeleteBuilderStandard deleteBuilder = new TableDeleteBuilderStandard(this, tableReference, this.getFactory());
        if (pluralAttribute.getIdentifierDescriptor() != null) {
            deleteBuilder.addKeyRestrictionsLeniently(pluralAttribute.getIdentifierDescriptor());
        } else {
            deleteBuilder.addKeyRestrictionsLeniently(pluralAttribute.getKeyDescriptor().getKeyPart());
            if (this.hasIndex() && !this.indexContainsFormula) {
                assert (pluralAttribute.getIndexDescriptor() != null);
                deleteBuilder.addKeyRestrictionsLeniently(pluralAttribute.getIndexDescriptor());
            } else {
                deleteBuilder.addKeyRestrictions(pluralAttribute.getElementDescriptor());
            }
        }
        return deleteBuilder.buildMutation();
    }

    private void applyDeleteRowRestrictions(PersistentCollection<?> collection, Object keyValue, Object rowValue, int rowPosition, SharedSessionContractImplementor session, JdbcValueBindings jdbcValueBindings) {
        PluralAttributeMapping attributeMapping = this.getAttributeMapping();
        if (attributeMapping.getIdentifierDescriptor() != null) {
            attributeMapping.getIdentifierDescriptor().decompose(rowValue, 0, jdbcValueBindings, null, RowMutationOperations.DEFAULT_RESTRICTOR, session);
        } else {
            this.getAttributeMapping().getKeyDescriptor().getKeyPart().decompose(keyValue, 0, jdbcValueBindings, null, RowMutationOperations.DEFAULT_RESTRICTOR, session);
            if (this.hasPhysicalIndexColumn()) {
                attributeMapping.getIndexDescriptor().decompose(this.incrementIndexByBase(rowValue), 0, jdbcValueBindings, null, RowMutationOperations.DEFAULT_RESTRICTOR, session);
            } else {
                attributeMapping.getElementDescriptor().decompose(rowValue, 0, jdbcValueBindings, null, (valueIndex, bindings, noop, jdbcValue, jdbcValueMapping) -> {
                    if (jdbcValueMapping.isNullable() || jdbcValueMapping.isFormula()) {
                        return;
                    }
                    bindings.bindValue(jdbcValue, jdbcValueMapping, ParameterUsage.RESTRICT);
                }, session);
            }
        }
    }

    @Override
    public boolean consumesEntityAlias() {
        return false;
    }

    @Override
    public boolean consumesCollectionAlias() {
        return true;
    }

    @Override
    public boolean isOneToMany() {
        return false;
    }

    @Override
    public boolean isManyToMany() {
        return this.elementType.isEntityType();
    }

    @Override
    public FilterAliasGenerator getFilterAliasGenerator(String rootAlias) {
        return new StaticFilterAliasGenerator(rootAlias);
    }

    @Override
    public FilterAliasGenerator getFilterAliasGenerator(TableGroup tableGroup) {
        return this.getFilterAliasGenerator(tableGroup.getPrimaryTableReference().getIdentificationVariable());
    }
}

