
package org.hibernate.boot.jaxb.mapping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;


/**
 * 
 *                 Entity-defined attributes
 * 
 *                 This element contains the entity field or property mappings.
 *                 It may be sparsely populated to include only a subset of the
 *                 fields or properties. If metadata-complete for the entity is true
 *                 then the remainder of the attributes will be defaulted according
 *                 to the default rules.
 * 
 *             
 * 
 * <p>Java class for attributes complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="attributes">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="description" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         <choice>
 *           <element name="id" type="{http://www.hibernate.org/xsd/orm/mapping}id" maxOccurs="unbounded" minOccurs="0"/>
 *           <element name="embedded-id" type="{http://www.hibernate.org/xsd/orm/mapping}embedded-id" minOccurs="0"/>
 *         </choice>
 *         <element name="natural-id" type="{http://www.hibernate.org/xsd/orm/mapping}natural-id" minOccurs="0"/>
 *         <element name="basic" type="{http://www.hibernate.org/xsd/orm/mapping}basic" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="version" type="{http://www.hibernate.org/xsd/orm/mapping}version" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="many-to-one" type="{http://www.hibernate.org/xsd/orm/mapping}many-to-one" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="one-to-many" type="{http://www.hibernate.org/xsd/orm/mapping}one-to-many" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="one-to-one" type="{http://www.hibernate.org/xsd/orm/mapping}one-to-one" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="many-to-many" type="{http://www.hibernate.org/xsd/orm/mapping}many-to-many" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="element-collection" type="{http://www.hibernate.org/xsd/orm/mapping}element-collection" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="embedded" type="{http://www.hibernate.org/xsd/orm/mapping}embedded" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="transient" type="{http://www.hibernate.org/xsd/orm/mapping}transient" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="any" type="{http://www.hibernate.org/xsd/orm/mapping}hbm-any-mapping" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="many-to-any" type="{http://www.hibernate.org/xsd/orm/mapping}hbm-many-to-any" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "attributes", namespace = "http://www.hibernate.org/xsd/orm/mapping", propOrder = {
    "description",
    "id",
    "embeddedId",
    "naturalId",
    "basicAttributes",
    "version",
    "manyToOneAttributes",
    "oneToManyAttributes",
    "oneToOneAttributes",
    "manyToManyAttributes",
    "elementCollectionAttributes",
    "embeddedAttributes",
    "transients",
    "discriminatedAssociations",
    "pluralDiscriminatedAssociations"
})
public class JaxbAttributes
    implements Serializable, AttributesContainer
{

    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected String description;
    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected List<JaxbId> id;
    @XmlElement(name = "embedded-id", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected JaxbEmbeddedId embeddedId;
    @XmlElement(name = "natural-id", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected JaxbNaturalId naturalId;
    @XmlElement(name = "basic", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected List<JaxbBasic> basicAttributes;
    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected List<JaxbVersion> version;
    @XmlElement(name = "many-to-one", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected List<JaxbManyToOne> manyToOneAttributes;
    @XmlElement(name = "one-to-many", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected List<JaxbOneToMany> oneToManyAttributes;
    @XmlElement(name = "one-to-one", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected List<JaxbOneToOne> oneToOneAttributes;
    @XmlElement(name = "many-to-many", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected List<JaxbManyToMany> manyToManyAttributes;
    @XmlElement(name = "element-collection", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected List<JaxbElementCollection> elementCollectionAttributes;
    @XmlElement(name = "embedded", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected List<JaxbEmbedded> embeddedAttributes;
    @XmlElement(name = "transient", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected List<JaxbTransient> transients;
    @XmlElement(name = "any", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected List<JaxbHbmAnyMapping> discriminatedAssociations;
    @XmlElement(name = "many-to-any", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected List<JaxbHbmManyToAny> pluralDiscriminatedAssociations;

    /**
     * Gets the value of the description property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDescription() {
        return description;
    }

    /**
     * Sets the value of the description property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setDescription(String value) {
        this.description = value;
    }

    /**
     * Gets the value of the id property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the id property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getId().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbId }
     * 
     * 
     * @return
     *     The value of the id property.
     */
    public List<JaxbId> getId() {
        if (id == null) {
            id = new ArrayList<>();
        }
        return this.id;
    }

    /**
     * Gets the value of the embeddedId property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbEmbeddedId }
     *     
     */
    public JaxbEmbeddedId getEmbeddedId() {
        return embeddedId;
    }

    /**
     * Sets the value of the embeddedId property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbEmbeddedId }
     *     
     */
    public void setEmbeddedId(JaxbEmbeddedId value) {
        this.embeddedId = value;
    }

    /**
     * Gets the value of the naturalId property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbNaturalId }
     *     
     */
    public JaxbNaturalId getNaturalId() {
        return naturalId;
    }

    /**
     * Sets the value of the naturalId property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbNaturalId }
     *     
     */
    public void setNaturalId(JaxbNaturalId value) {
        this.naturalId = value;
    }

    /**
     * Gets the value of the basicAttributes property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the basicAttributes property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getBasicAttributes().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbBasic }
     * 
     * 
     * @return
     *     The value of the basicAttributes property.
     */
    public List<JaxbBasic> getBasicAttributes() {
        if (basicAttributes == null) {
            basicAttributes = new ArrayList<>();
        }
        return this.basicAttributes;
    }

    /**
     * Gets the value of the version property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the version property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getVersion().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbVersion }
     * 
     * 
     * @return
     *     The value of the version property.
     */
    public List<JaxbVersion> getVersion() {
        if (version == null) {
            version = new ArrayList<>();
        }
        return this.version;
    }

    /**
     * Gets the value of the manyToOneAttributes property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the manyToOneAttributes property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getManyToOneAttributes().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbManyToOne }
     * 
     * 
     * @return
     *     The value of the manyToOneAttributes property.
     */
    public List<JaxbManyToOne> getManyToOneAttributes() {
        if (manyToOneAttributes == null) {
            manyToOneAttributes = new ArrayList<>();
        }
        return this.manyToOneAttributes;
    }

    /**
     * Gets the value of the oneToManyAttributes property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the oneToManyAttributes property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getOneToManyAttributes().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbOneToMany }
     * 
     * 
     * @return
     *     The value of the oneToManyAttributes property.
     */
    public List<JaxbOneToMany> getOneToManyAttributes() {
        if (oneToManyAttributes == null) {
            oneToManyAttributes = new ArrayList<>();
        }
        return this.oneToManyAttributes;
    }

    /**
     * Gets the value of the oneToOneAttributes property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the oneToOneAttributes property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getOneToOneAttributes().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbOneToOne }
     * 
     * 
     * @return
     *     The value of the oneToOneAttributes property.
     */
    public List<JaxbOneToOne> getOneToOneAttributes() {
        if (oneToOneAttributes == null) {
            oneToOneAttributes = new ArrayList<>();
        }
        return this.oneToOneAttributes;
    }

    /**
     * Gets the value of the manyToManyAttributes property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the manyToManyAttributes property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getManyToManyAttributes().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbManyToMany }
     * 
     * 
     * @return
     *     The value of the manyToManyAttributes property.
     */
    public List<JaxbManyToMany> getManyToManyAttributes() {
        if (manyToManyAttributes == null) {
            manyToManyAttributes = new ArrayList<>();
        }
        return this.manyToManyAttributes;
    }

    /**
     * Gets the value of the elementCollectionAttributes property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the elementCollectionAttributes property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getElementCollectionAttributes().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbElementCollection }
     * 
     * 
     * @return
     *     The value of the elementCollectionAttributes property.
     */
    public List<JaxbElementCollection> getElementCollectionAttributes() {
        if (elementCollectionAttributes == null) {
            elementCollectionAttributes = new ArrayList<>();
        }
        return this.elementCollectionAttributes;
    }

    /**
     * Gets the value of the embeddedAttributes property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the embeddedAttributes property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getEmbeddedAttributes().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbEmbedded }
     * 
     * 
     * @return
     *     The value of the embeddedAttributes property.
     */
    public List<JaxbEmbedded> getEmbeddedAttributes() {
        if (embeddedAttributes == null) {
            embeddedAttributes = new ArrayList<>();
        }
        return this.embeddedAttributes;
    }

    /**
     * Gets the value of the transients property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the transients property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getTransients().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbTransient }
     * 
     * 
     * @return
     *     The value of the transients property.
     */
    public List<JaxbTransient> getTransients() {
        if (transients == null) {
            transients = new ArrayList<>();
        }
        return this.transients;
    }

    /**
     * Gets the value of the discriminatedAssociations property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the discriminatedAssociations property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getDiscriminatedAssociations().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbHbmAnyMapping }
     * 
     * 
     * @return
     *     The value of the discriminatedAssociations property.
     */
    public List<JaxbHbmAnyMapping> getDiscriminatedAssociations() {
        if (discriminatedAssociations == null) {
            discriminatedAssociations = new ArrayList<>();
        }
        return this.discriminatedAssociations;
    }

    /**
     * Gets the value of the pluralDiscriminatedAssociations property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the pluralDiscriminatedAssociations property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPluralDiscriminatedAssociations().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbHbmManyToAny }
     * 
     * 
     * @return
     *     The value of the pluralDiscriminatedAssociations property.
     */
    public List<JaxbHbmManyToAny> getPluralDiscriminatedAssociations() {
        if (pluralDiscriminatedAssociations == null) {
            pluralDiscriminatedAssociations = new ArrayList<>();
        }
        return this.pluralDiscriminatedAssociations;
    }

}
