
package org.hibernate.boot.jaxb.hbm.spi;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.hibernate.boot.jaxb.spi.BindableMappingDescriptor;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType>
 *   <complexContent>
 *     <extension base="{http://www.hibernate.org/xsd/orm/hbm}ToolingHintContainer">
 *       <choice maxOccurs="unbounded">
 *         <element name="identifier-generator" type="{http://www.hibernate.org/xsd/orm/hbm}IdentifierGeneratorDefinitionType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="typedef" type="{http://www.hibernate.org/xsd/orm/hbm}TypeDefinitionType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="filter-def" type="{http://www.hibernate.org/xsd/orm/hbm}FilterDefinitionType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="import" type="{http://www.hibernate.org/xsd/orm/hbm}ClassRenameType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="class" type="{http://www.hibernate.org/xsd/orm/hbm}RootEntityType"/>
 *         <element name="subclass" type="{http://www.hibernate.org/xsd/orm/hbm}DiscriminatorSubclassEntityType"/>
 *         <element name="joined-subclass" type="{http://www.hibernate.org/xsd/orm/hbm}JoinedSubclassEntityType"/>
 *         <element name="union-subclass" type="{http://www.hibernate.org/xsd/orm/hbm}UnionSubclassEntityType"/>
 *         <element name="resultset" type="{http://www.hibernate.org/xsd/orm/hbm}ResultSetMappingType" maxOccurs="unbounded" minOccurs="0"/>
 *         <group ref="{http://www.hibernate.org/xsd/orm/hbm}NamedQueryGroup" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="fetch-profile" type="{http://www.hibernate.org/xsd/orm/hbm}FetchProfileType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="database-object" type="{http://www.hibernate.org/xsd/orm/hbm}AuxiliaryDatabaseObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *       </choice>
 *       <attribute name="auto-import" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *       <attribute name="catalog" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       <attribute name="default-access" type="{http://www.w3.org/2001/XMLSchema}string" default="property" />
 *       <attribute name="default-cascade" type="{http://www.w3.org/2001/XMLSchema}string" default="none" />
 *       <attribute name="default-lazy" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *       <attribute name="package" type="{http://www.hibernate.org/xsd/orm/hbm}ClassNameType" />
 *       <attribute name="schema" type="{http://www.w3.org/2001/XMLSchema}string" />
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "identifierGenerator",
    "typedef",
    "filterDef",
    "_import",
    "clazz",
    "subclass",
    "joinedSubclass",
    "unionSubclass",
    "resultset",
    "query",
    "sqlQuery",
    "fetchProfile",
    "databaseObject"
})
@XmlRootElement(name = "hibernate-mapping", namespace = "http://www.hibernate.org/xsd/orm/hbm")
public class JaxbHbmHibernateMapping
    extends JaxbHbmToolingHintContainer
    implements Serializable, BindableMappingDescriptor
{

    @XmlElement(name = "identifier-generator", namespace = "http://www.hibernate.org/xsd/orm/hbm")
    protected List<JaxbHbmIdentifierGeneratorDefinitionType> identifierGenerator;
    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/hbm")
    protected List<JaxbHbmTypeDefinitionType> typedef;
    @XmlElement(name = "filter-def", namespace = "http://www.hibernate.org/xsd/orm/hbm")
    protected List<JaxbHbmFilterDefinitionType> filterDef;
    @XmlElement(name = "import", namespace = "http://www.hibernate.org/xsd/orm/hbm")
    protected List<JaxbHbmClassRenameType> _import;
    @XmlElement(name = "class", namespace = "http://www.hibernate.org/xsd/orm/hbm")
    protected List<JaxbHbmRootEntityType> clazz;
    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/hbm")
    protected List<JaxbHbmDiscriminatorSubclassEntityType> subclass;
    @XmlElement(name = "joined-subclass", namespace = "http://www.hibernate.org/xsd/orm/hbm")
    protected List<JaxbHbmJoinedSubclassEntityType> joinedSubclass;
    @XmlElement(name = "union-subclass", namespace = "http://www.hibernate.org/xsd/orm/hbm")
    protected List<JaxbHbmUnionSubclassEntityType> unionSubclass;
    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/hbm")
    protected List<JaxbHbmResultSetMappingType> resultset;
    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/hbm")
    protected List<JaxbHbmNamedQueryType> query;
    @XmlElement(name = "sql-query", namespace = "http://www.hibernate.org/xsd/orm/hbm")
    protected List<JaxbHbmNamedNativeQueryType> sqlQuery;
    @XmlElement(name = "fetch-profile", namespace = "http://www.hibernate.org/xsd/orm/hbm")
    protected List<JaxbHbmFetchProfileType> fetchProfile;
    @XmlElement(name = "database-object", namespace = "http://www.hibernate.org/xsd/orm/hbm")
    protected List<JaxbHbmAuxiliaryDatabaseObjectType> databaseObject;
    @XmlAttribute(name = "auto-import")
    protected Boolean autoImport;
    @XmlAttribute(name = "catalog")
    protected String catalog;
    @XmlAttribute(name = "default-access")
    protected String defaultAccess;
    @XmlAttribute(name = "default-cascade")
    protected String defaultCascade;
    @XmlAttribute(name = "default-lazy")
    protected Boolean defaultLazy;
    @XmlAttribute(name = "package")
    protected String _package;
    @XmlAttribute(name = "schema")
    protected String schema;

    /**
     * Gets the value of the identifierGenerator property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the identifierGenerator property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getIdentifierGenerator().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbHbmIdentifierGeneratorDefinitionType }
     * 
     * 
     * @return
     *     The value of the identifierGenerator property.
     */
    public List<JaxbHbmIdentifierGeneratorDefinitionType> getIdentifierGenerator() {
        if (identifierGenerator == null) {
            identifierGenerator = new ArrayList<>();
        }
        return this.identifierGenerator;
    }

    /**
     * Gets the value of the typedef property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the typedef property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getTypedef().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbHbmTypeDefinitionType }
     * 
     * 
     * @return
     *     The value of the typedef property.
     */
    public List<JaxbHbmTypeDefinitionType> getTypedef() {
        if (typedef == null) {
            typedef = new ArrayList<>();
        }
        return this.typedef;
    }

    /**
     * Gets the value of the filterDef property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the filterDef property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getFilterDef().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbHbmFilterDefinitionType }
     * 
     * 
     * @return
     *     The value of the filterDef property.
     */
    public List<JaxbHbmFilterDefinitionType> getFilterDef() {
        if (filterDef == null) {
            filterDef = new ArrayList<>();
        }
        return this.filterDef;
    }

    /**
     * Gets the value of the import property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the import property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getImport().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbHbmClassRenameType }
     * 
     * 
     * @return
     *     The value of the import property.
     */
    public List<JaxbHbmClassRenameType> getImport() {
        if (_import == null) {
            _import = new ArrayList<>();
        }
        return this._import;
    }

    /**
     * Gets the value of the clazz property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the clazz property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getClazz().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbHbmRootEntityType }
     * 
     * 
     * @return
     *     The value of the clazz property.
     */
    public List<JaxbHbmRootEntityType> getClazz() {
        if (clazz == null) {
            clazz = new ArrayList<>();
        }
        return this.clazz;
    }

    /**
     * Gets the value of the subclass property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the subclass property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSubclass().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbHbmDiscriminatorSubclassEntityType }
     * 
     * 
     * @return
     *     The value of the subclass property.
     */
    public List<JaxbHbmDiscriminatorSubclassEntityType> getSubclass() {
        if (subclass == null) {
            subclass = new ArrayList<>();
        }
        return this.subclass;
    }

    /**
     * Gets the value of the joinedSubclass property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the joinedSubclass property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getJoinedSubclass().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbHbmJoinedSubclassEntityType }
     * 
     * 
     * @return
     *     The value of the joinedSubclass property.
     */
    public List<JaxbHbmJoinedSubclassEntityType> getJoinedSubclass() {
        if (joinedSubclass == null) {
            joinedSubclass = new ArrayList<>();
        }
        return this.joinedSubclass;
    }

    /**
     * Gets the value of the unionSubclass property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the unionSubclass property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getUnionSubclass().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbHbmUnionSubclassEntityType }
     * 
     * 
     * @return
     *     The value of the unionSubclass property.
     */
    public List<JaxbHbmUnionSubclassEntityType> getUnionSubclass() {
        if (unionSubclass == null) {
            unionSubclass = new ArrayList<>();
        }
        return this.unionSubclass;
    }

    /**
     * Gets the value of the resultset property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the resultset property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getResultset().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbHbmResultSetMappingType }
     * 
     * 
     * @return
     *     The value of the resultset property.
     */
    public List<JaxbHbmResultSetMappingType> getResultset() {
        if (resultset == null) {
            resultset = new ArrayList<>();
        }
        return this.resultset;
    }

    /**
     * Gets the value of the query property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the query property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getQuery().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbHbmNamedQueryType }
     * 
     * 
     * @return
     *     The value of the query property.
     */
    public List<JaxbHbmNamedQueryType> getQuery() {
        if (query == null) {
            query = new ArrayList<>();
        }
        return this.query;
    }

    /**
     * Gets the value of the sqlQuery property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the sqlQuery property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSqlQuery().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbHbmNamedNativeQueryType }
     * 
     * 
     * @return
     *     The value of the sqlQuery property.
     */
    public List<JaxbHbmNamedNativeQueryType> getSqlQuery() {
        if (sqlQuery == null) {
            sqlQuery = new ArrayList<>();
        }
        return this.sqlQuery;
    }

    /**
     * Gets the value of the fetchProfile property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the fetchProfile property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getFetchProfile().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbHbmFetchProfileType }
     * 
     * 
     * @return
     *     The value of the fetchProfile property.
     */
    public List<JaxbHbmFetchProfileType> getFetchProfile() {
        if (fetchProfile == null) {
            fetchProfile = new ArrayList<>();
        }
        return this.fetchProfile;
    }

    /**
     * Gets the value of the databaseObject property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the databaseObject property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getDatabaseObject().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbHbmAuxiliaryDatabaseObjectType }
     * 
     * 
     * @return
     *     The value of the databaseObject property.
     */
    public List<JaxbHbmAuxiliaryDatabaseObjectType> getDatabaseObject() {
        if (databaseObject == null) {
            databaseObject = new ArrayList<>();
        }
        return this.databaseObject;
    }

    /**
     * Gets the value of the autoImport property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isAutoImport() {
        if (autoImport == null) {
            return true;
        } else {
            return autoImport;
        }
    }

    /**
     * Sets the value of the autoImport property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setAutoImport(Boolean value) {
        this.autoImport = value;
    }

    /**
     * Gets the value of the catalog property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCatalog() {
        return catalog;
    }

    /**
     * Sets the value of the catalog property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setCatalog(String value) {
        this.catalog = value;
    }

    /**
     * Gets the value of the defaultAccess property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDefaultAccess() {
        if (defaultAccess == null) {
            return "property";
        } else {
            return defaultAccess;
        }
    }

    /**
     * Sets the value of the defaultAccess property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setDefaultAccess(String value) {
        this.defaultAccess = value;
    }

    /**
     * Gets the value of the defaultCascade property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDefaultCascade() {
        if (defaultCascade == null) {
            return "none";
        } else {
            return defaultCascade;
        }
    }

    /**
     * Sets the value of the defaultCascade property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setDefaultCascade(String value) {
        this.defaultCascade = value;
    }

    /**
     * Gets the value of the defaultLazy property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isDefaultLazy() {
        if (defaultLazy == null) {
            return true;
        } else {
            return defaultLazy;
        }
    }

    /**
     * Sets the value of the defaultLazy property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setDefaultLazy(Boolean value) {
        this.defaultLazy = value;
    }

    /**
     * Gets the value of the package property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPackage() {
        return _package;
    }

    /**
     * Sets the value of the package property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setPackage(String value) {
        this._package = value;
    }

    /**
     * Gets the value of the schema property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getSchema() {
        return schema;
    }

    /**
     * Sets the value of the schema property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setSchema(String value) {
        this.schema = value;
    }

}
