/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import jakarta.persistence.CacheRetrieveMode;
import jakarta.persistence.CacheStoreMode;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityNotFoundException;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.LockModeType;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.TransactionRequiredException;
import jakarta.persistence.metamodel.Metamodel;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.NClob;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.hibernate.CacheMode;
import org.hibernate.ConnectionAcquisitionMode;
import org.hibernate.FetchNotFoundException;
import org.hibernate.Filter;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.JDBCException;
import org.hibernate.LobHelper;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.MappingException;
import org.hibernate.MultiIdentifierLoadAccess;
import org.hibernate.NaturalIdLoadAccess;
import org.hibernate.NaturalIdMultiLoadAccess;
import org.hibernate.ObjectDeletedException;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.ReplicationMode;
import org.hibernate.Session;
import org.hibernate.SessionEventListener;
import org.hibernate.SessionException;
import org.hibernate.SharedSessionBuilder;
import org.hibernate.SimpleNaturalIdLoadAccess;
import org.hibernate.Transaction;
import org.hibernate.TransientObjectException;
import org.hibernate.TypeMismatchException;
import org.hibernate.UnknownProfileException;
import org.hibernate.UnresolvableObjectException;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.context.spi.CurrentTenantIdentifierResolver;
import org.hibernate.engine.internal.StatefulPersistenceContext;
import org.hibernate.engine.jdbc.LobCreator;
import org.hibernate.engine.jdbc.NonContextualLobCreator;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.engine.spi.ActionQueue;
import org.hibernate.engine.spi.EffectiveEntityGraph;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.engine.transaction.spi.TransactionImplementor;
import org.hibernate.engine.transaction.spi.TransactionObserver;
import org.hibernate.event.spi.AutoFlushEvent;
import org.hibernate.event.spi.AutoFlushEventListener;
import org.hibernate.event.spi.ClearEvent;
import org.hibernate.event.spi.ClearEventListener;
import org.hibernate.event.spi.DeleteContext;
import org.hibernate.event.spi.DeleteEvent;
import org.hibernate.event.spi.DeleteEventListener;
import org.hibernate.event.spi.DirtyCheckEvent;
import org.hibernate.event.spi.DirtyCheckEventListener;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.EvictEvent;
import org.hibernate.event.spi.EvictEventListener;
import org.hibernate.event.spi.FlushEvent;
import org.hibernate.event.spi.FlushEventListener;
import org.hibernate.event.spi.InitializeCollectionEvent;
import org.hibernate.event.spi.InitializeCollectionEventListener;
import org.hibernate.event.spi.LoadEvent;
import org.hibernate.event.spi.LoadEventListener;
import org.hibernate.event.spi.LockEvent;
import org.hibernate.event.spi.LockEventListener;
import org.hibernate.event.spi.MergeContext;
import org.hibernate.event.spi.MergeEvent;
import org.hibernate.event.spi.MergeEventListener;
import org.hibernate.event.spi.PersistContext;
import org.hibernate.event.spi.PersistEvent;
import org.hibernate.event.spi.PersistEventListener;
import org.hibernate.event.spi.RefreshContext;
import org.hibernate.event.spi.RefreshEvent;
import org.hibernate.event.spi.RefreshEventListener;
import org.hibernate.event.spi.ReplicateEvent;
import org.hibernate.event.spi.ReplicateEventListener;
import org.hibernate.event.spi.ResolveNaturalIdEvent;
import org.hibernate.event.spi.ResolveNaturalIdEventListener;
import org.hibernate.event.spi.SaveOrUpdateEvent;
import org.hibernate.event.spi.SaveOrUpdateEventListener;
import org.hibernate.graph.GraphSemantic;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.internal.AbstractSharedSessionContract;
import org.hibernate.internal.EntityManagerMessageLogger;
import org.hibernate.internal.ExceptionMapperStandardImpl;
import org.hibernate.internal.FilterImpl;
import org.hibernate.internal.HEMLogging;
import org.hibernate.internal.MultiIdentifierLoadAccessImpl;
import org.hibernate.internal.NaturalIdMultiLoadAccessStandard;
import org.hibernate.internal.SessionCreationOptions;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.internal.SharedSessionCreationOptions;
import org.hibernate.internal.util.ExceptionHelper;
import org.hibernate.jpa.internal.LegacySpecHelper;
import org.hibernate.jpa.internal.util.CacheModeHelper;
import org.hibernate.jpa.internal.util.ConfigurationHelper;
import org.hibernate.jpa.internal.util.FlushModeTypeHelper;
import org.hibernate.jpa.internal.util.LockModeTypeHelper;
import org.hibernate.jpa.internal.util.LockOptionsHelper;
import org.hibernate.loader.internal.IdentifierLoadAccessImpl;
import org.hibernate.loader.internal.LoadAccessContext;
import org.hibernate.loader.internal.NaturalIdLoadAccessImpl;
import org.hibernate.loader.internal.SimpleNaturalIdLoadAccessImpl;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.procedure.ProcedureCall;
import org.hibernate.procedure.spi.NamedCallableQueryMemento;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.query.Query;
import org.hibernate.query.SelectionQuery;
import org.hibernate.query.UnknownSqlResultSetMappingException;
import org.hibernate.resource.jdbc.spi.JdbcSessionOwner;
import org.hibernate.resource.jdbc.spi.PhysicalConnectionHandlingMode;
import org.hibernate.resource.transaction.backend.jta.internal.JtaTransactionCoordinatorImpl;
import org.hibernate.resource.transaction.spi.TransactionCoordinator;
import org.hibernate.resource.transaction.spi.TransactionCoordinatorBuilder;
import org.hibernate.resource.transaction.spi.TransactionStatus;
import org.hibernate.stat.SessionStatistics;
import org.hibernate.stat.internal.SessionStatisticsImpl;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.hibernate.type.descriptor.WrapperOptions;

public class SessionImpl
extends AbstractSharedSessionContract
implements Serializable,
SharedSessionContractImplementor,
JdbcSessionOwner,
SessionImplementor,
EventSource,
TransactionCoordinatorBuilder.Options,
WrapperOptions,
LoadAccessContext {
    private static final EntityManagerMessageLogger log = HEMLogging.messageLogger(SessionImpl.class);
    private Map<String, Object> properties;
    private transient ActionQueue actionQueue;
    private transient StatefulPersistenceContext persistenceContext = this.createPersistenceContext();
    private transient LoadQueryInfluencers loadQueryInfluencers;
    private LockOptions lockOptions;
    private boolean autoClear;
    private final boolean autoClose;
    private transient LoadEvent loadEvent;
    private transient TransactionObserver transactionObserver;
    private transient boolean isEnforcingFetchGraph;
    private transient LobHelperImpl lobHelper;

    public SessionImpl(SessionFactoryImpl factory, SessionCreationOptions options) {
        super(factory, options);
        this.actionQueue = this.createActionQueue();
        this.autoClear = options.shouldAutoClear();
        this.autoClose = options.shouldAutoClose();
        if (options instanceof SharedSessionCreationOptions) {
            SharedSessionCreationOptions sharedOptions = (SharedSessionCreationOptions)options;
            ActionQueue.TransactionCompletionProcesses transactionCompletionProcesses = sharedOptions.getTransactionCompletionProcesses();
            if (sharedOptions.isTransactionCoordinatorShared() && transactionCompletionProcesses != null) {
                this.actionQueue.setTransactionCompletionProcesses(transactionCompletionProcesses, true);
            }
        }
        this.loadQueryInfluencers = new LoadQueryInfluencers(factory, options);
        StatisticsImplementor statistics = factory.getStatistics();
        if (statistics.isStatisticsEnabled()) {
            statistics.openSession();
        }
        if (this.properties != null) {
            LockOptionsHelper.applyPropertiesToLockOptions(this.properties, this::getLockOptionsForWrite);
        }
        this.setCacheMode(this.fastSessionServices.initialSessionCacheMode);
        this.getTransactionCoordinator().pulse();
        if (this.getHibernateFlushMode() == null) {
            this.setHibernateFlushMode(this.getInitialFlushMode());
        }
        this.setUpMultitenancy(factory);
        if (log.isTraceEnabled()) {
            log.tracef("Opened Session [%s] at timestamp: %s", this.getSessionIdentifier(), System.currentTimeMillis());
        }
    }

    private FlushMode getInitialFlushMode() {
        return this.properties == null ? this.fastSessionServices.initialSessionFlushMode : ConfigurationHelper.getFlushMode(this.getSessionProperty("org.hibernate.flushMode"), FlushMode.AUTO);
    }

    private void setUpMultitenancy(SessionFactoryImplementor factory) {
        if (factory.getDefinedFilterNames().contains("_tenantId")) {
            String tenantIdentifier = this.getTenantIdentifier();
            if (tenantIdentifier == null) {
                throw new HibernateException("SessionFactory configured for multi-tenancy, but no tenant identifier specified");
            }
            CurrentTenantIdentifierResolver resolver = factory.getCurrentTenantIdentifierResolver();
            if (resolver == null || !resolver.isRoot(tenantIdentifier)) {
                this.loadQueryInfluencers.enableFilter("_tenantId").setParameter("tenantId", tenantIdentifier);
            }
        }
    }

    protected StatefulPersistenceContext createPersistenceContext() {
        return new StatefulPersistenceContext(this);
    }

    protected ActionQueue createActionQueue() {
        return new ActionQueue(this);
    }

    private LockOptions getLockOptionsForRead() {
        return this.lockOptions == null ? this.fastSessionServices.defaultLockOptions : this.lockOptions;
    }

    private LockOptions getLockOptionsForWrite() {
        if (this.lockOptions == null) {
            this.lockOptions = new LockOptions();
        }
        return this.lockOptions;
    }

    @Override
    protected void applyQuerySettingsAndHints(SelectionQuery<?> query) {
        this.applyLockOptionsHint(query);
    }

    protected void applyLockOptionsHint(SelectionQuery<?> query) {
        Integer specQueryTimeout;
        LockOptions lockOptionsForRead = this.getLockOptionsForRead();
        if (lockOptionsForRead.getLockMode() != LockMode.NONE) {
            query.setLockMode(this.getLockMode((Object)lockOptionsForRead.getLockMode()));
        }
        if ((specQueryTimeout = LegacySpecHelper.getInteger("jakarta.persistence.query.timeout", "javax.persistence.query.timeout", this::getSessionProperty)) != null) {
            query.setHint("jakarta.persistence.query.timeout", specQueryTimeout);
        }
    }

    @Override
    protected void applyQuerySettingsAndHints(Query<?> query) {
        this.applyQuerySettingsAndHints((SelectionQuery<?>)query);
        Integer specLockTimeout = LegacySpecHelper.getInteger("jakarta.persistence.lock.timeout", "javax.persistence.lock.timeout", this::getSessionProperty, value -> !Integer.valueOf(-1).equals(value));
        if (specLockTimeout != null) {
            query.setHint("jakarta.persistence.lock.timeout", specLockTimeout);
        }
    }

    private Object getSessionProperty(String name) {
        if (this.properties == null) {
            return this.fastSessionServices.defaultSessionProperties.get(name);
        }
        return this.properties.get(name);
    }

    @Override
    public SharedSessionBuilder sessionWithOptions() {
        return new SharedSessionBuilderImpl(this);
    }

    @Override
    public void clear() {
        this.checkOpen();
        this.pulseTransactionCoordinator();
        try {
            this.internalClear();
        }
        catch (RuntimeException e) {
            throw this.getExceptionConverter().convert(e);
        }
    }

    private void internalClear() {
        this.persistenceContext.clear();
        this.actionQueue.clear();
        this.fastSessionServices.eventListenerGroup_CLEAR.fireLazyEventOnEachListener(this::createClearEvent, ClearEventListener::onClear);
    }

    private ClearEvent createClearEvent() {
        return new ClearEvent(this);
    }

    @Override
    public void close() throws HibernateException {
        if (this.isClosed()) {
            if (this.getFactory().getSessionFactoryOptions().getJpaCompliance().isJpaClosedComplianceEnabled()) {
                throw new IllegalStateException("Illegal call to #close() on already closed Session/EntityManager");
            }
            log.trace("Already closed");
            return;
        }
        this.closeWithoutOpenChecks();
    }

    public void closeWithoutOpenChecks() throws HibernateException {
        SessionFactoryImplementor sessionFactory;
        if (log.isTraceEnabled()) {
            log.tracef("Closing session [%s]", this.getSessionIdentifier());
        }
        if ((sessionFactory = this.getSessionFactory()).getSessionFactoryOptions().isJpaBootstrap()) {
            this.checkSessionFactoryOpen();
            this.checkOpenOrWaitingForAutoClose();
            if (this.fastSessionServices.discardOnClose || !this.isTransactionInProgressAndNotMarkedForRollback()) {
                super.close();
            } else {
                this.prepareForAutoClose();
            }
        } else {
            super.close();
        }
        StatisticsImplementor statistics = sessionFactory.getStatistics();
        if (statistics.isStatisticsEnabled()) {
            statistics.closeSession();
        }
    }

    private boolean isTransactionInProgressAndNotMarkedForRollback() {
        if (this.waitingForAutoClose) {
            return this.getSessionFactory().isOpen() && this.getTransactionCoordinator().isTransactionActive(false);
        }
        return !this.isClosed() && this.getTransactionCoordinator().isTransactionActive(false);
    }

    @Override
    protected boolean shouldCloseJdbcCoordinatorOnClose(boolean isTransactionCoordinatorShared) {
        if (!isTransactionCoordinatorShared) {
            return super.shouldCloseJdbcCoordinatorOnClose(isTransactionCoordinatorShared);
        }
        ActionQueue actionQueue = this.getActionQueue();
        if (actionQueue.hasBeforeTransactionActions() || actionQueue.hasAfterTransactionActions()) {
            log.warn("On close, shared Session had before/after transaction actions that have not yet been processed");
        }
        return false;
    }

    @Override
    public boolean isAutoCloseSessionEnabled() {
        return this.autoClose;
    }

    @Override
    public boolean isOpen() {
        this.checkSessionFactoryOpen();
        this.checkTransactionSynchStatus();
        try {
            return !this.isClosed();
        }
        catch (HibernateException he) {
            throw this.getExceptionConverter().convert(he);
        }
    }

    protected void checkSessionFactoryOpen() {
        if (!this.getFactory().isOpen()) {
            log.debug("Forcing Session/EntityManager closed as SessionFactory/EntityManagerFactory has been closed");
            this.setClosed();
        }
    }

    private void managedFlush() {
        if (this.isClosed() && !this.waitingForAutoClose) {
            log.trace("Skipping auto-flush due to session closed");
            return;
        }
        log.trace("Automatically flushing session");
        this.doFlush();
    }

    @Override
    public boolean shouldAutoClose() {
        if (this.waitingForAutoClose) {
            return true;
        }
        if (this.isClosed()) {
            return false;
        }
        return this.isAutoCloseSessionEnabled();
    }

    private void managedClose() {
        log.trace("Automatically closing session");
        this.closeWithoutOpenChecks();
    }

    @Override
    public void setAutoClear(boolean enabled) {
        this.checkOpenOrWaitingForAutoClose();
        this.autoClear = enabled;
    }

    @Override
    public void afterOperation(boolean success) {
        if (!this.isTransactionInProgress()) {
            this.getJdbcCoordinator().afterTransaction();
        }
    }

    @Override
    public void addEventListeners(SessionEventListener ... listeners) {
        this.getEventListenerManager().addListener(listeners);
    }

    @Override
    protected void cleanupOnClose() {
        this.persistenceContext.clear();
    }

    @Override
    public LockMode getCurrentLockMode(Object object) throws HibernateException {
        this.checkOpen();
        this.checkTransactionSynchStatus();
        if (object == null) {
            throw new NullPointerException("null object passed to getCurrentLockMode()");
        }
        LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(object);
        if (lazyInitializer != null && (object = lazyInitializer.getImplementation(this)) == null) {
            return LockMode.NONE;
        }
        EntityEntry e = this.persistenceContext.getEntry(object);
        if (e == null) {
            throw new TransientObjectException("Given object not associated with the session");
        }
        if (e.getStatus() != Status.MANAGED) {
            throw new ObjectDeletedException("The given object was deleted", e.getId(), e.getPersister().getEntityName());
        }
        return e.getLockMode();
    }

    @Override
    public Object getEntityUsingInterceptor(EntityKey key) throws HibernateException {
        this.checkOpenOrWaitingForAutoClose();
        Object result = this.persistenceContext.getEntity(key);
        if (result == null) {
            Object newObject = this.getInterceptor().getEntity(key.getEntityName(), key.getIdentifier());
            if (newObject != null) {
                this.lock(newObject, LockMode.NONE);
            }
            return newObject;
        }
        return result;
    }

    protected void checkNoUnresolvedActionsBeforeOperation() {
        if (this.persistenceContext.getCascadeLevel() == 0 && this.actionQueue.hasUnresolvedEntityInsertActions()) {
            throw new IllegalStateException("There are delayed insert actions before operation as cascade level 0.");
        }
    }

    protected void checkNoUnresolvedActionsAfterOperation() {
        if (this.persistenceContext.getCascadeLevel() == 0) {
            this.actionQueue.checkNoUnresolvedActionsAfterOperation();
        }
        this.delayedAfterCompletion();
    }

    @Override
    public void delayedAfterCompletion() {
        TransactionCoordinator coordinator = this.getTransactionCoordinator();
        if (coordinator instanceof JtaTransactionCoordinatorImpl) {
            ((JtaTransactionCoordinatorImpl)coordinator).getSynchronizationCallbackCoordinator().processAnyDelayedAfterCompletion();
        }
    }

    @Override
    public void pulseTransactionCoordinator() {
        super.pulseTransactionCoordinator();
    }

    @Override
    public void checkOpenOrWaitingForAutoClose() {
        super.checkOpenOrWaitingForAutoClose();
    }

    @Override
    @Deprecated
    public void saveOrUpdate(Object object) throws HibernateException {
        this.saveOrUpdate(null, object);
    }

    @Override
    @Deprecated
    public void saveOrUpdate(String entityName, Object obj) throws HibernateException {
        this.fireSaveOrUpdate(new SaveOrUpdateEvent(entityName, obj, this));
    }

    private void fireSaveOrUpdate(SaveOrUpdateEvent event) {
        this.checkOpen();
        this.checkTransactionSynchStatus();
        this.checkNoUnresolvedActionsBeforeOperation();
        this.fastSessionServices.eventListenerGroup_SAVE_UPDATE.fireEventOnEachListener(event, SaveOrUpdateEventListener::onSaveOrUpdate);
        this.checkNoUnresolvedActionsAfterOperation();
    }

    @Override
    @Deprecated
    public Object save(Object obj) throws HibernateException {
        return this.save(null, obj);
    }

    @Override
    @Deprecated
    public Object save(String entityName, Object object) throws HibernateException {
        return this.fireSave(new SaveOrUpdateEvent(entityName, object, this));
    }

    private Object fireSave(SaveOrUpdateEvent event) {
        this.checkOpen();
        this.checkTransactionSynchStatus();
        this.checkNoUnresolvedActionsBeforeOperation();
        this.fastSessionServices.eventListenerGroup_SAVE.fireEventOnEachListener(event, SaveOrUpdateEventListener::onSaveOrUpdate);
        this.checkNoUnresolvedActionsAfterOperation();
        return event.getResultId();
    }

    @Override
    @Deprecated
    public void update(Object obj) throws HibernateException {
        this.update(null, obj);
    }

    @Override
    @Deprecated
    public void update(String entityName, Object object) throws HibernateException {
        this.fireUpdate(new SaveOrUpdateEvent(entityName, object, this));
    }

    private void fireUpdate(SaveOrUpdateEvent event) {
        this.checkOpen();
        this.checkTransactionSynchStatus();
        this.checkNoUnresolvedActionsBeforeOperation();
        this.fastSessionServices.eventListenerGroup_UPDATE.fireEventOnEachListener(event, SaveOrUpdateEventListener::onSaveOrUpdate);
        this.checkNoUnresolvedActionsAfterOperation();
    }

    @Override
    public void lock(Object object, LockOptions lockOptions) {
        this.fireLock(new LockEvent(object, lockOptions, (EventSource)this));
    }

    @Override
    public void lock(String entityName, Object object, LockOptions lockOptions) {
        this.fireLock(new LockEvent(entityName, object, lockOptions, (EventSource)this));
    }

    @Override
    public void lock(String entityName, Object object, LockMode lockMode) throws HibernateException {
        this.fireLock(new LockEvent(entityName, object, lockMode, (EventSource)this));
    }

    @Override
    @Deprecated
    public Session.LockRequest buildLockRequest(LockOptions lockOptions) {
        return new LockRequestImpl(lockOptions);
    }

    @Override
    public void lock(Object object, LockMode lockMode) throws HibernateException {
        this.fireLock(new LockEvent(object, lockMode, (EventSource)this));
    }

    private void fireLock(String entityName, Object object, LockOptions options) {
        this.fireLock(new LockEvent(entityName, object, options, (EventSource)this));
    }

    private void fireLock(Object object, LockOptions options) {
        this.fireLock(new LockEvent(object, options, (EventSource)this));
    }

    private void fireLock(LockEvent event) {
        this.checkOpen();
        this.pulseTransactionCoordinator();
        this.fastSessionServices.eventListenerGroup_LOCK.fireEventOnEachListener(event, LockEventListener::onLock);
        this.delayedAfterCompletion();
    }

    @Override
    public void persist(String entityName, Object object) throws HibernateException {
        this.checkOpen();
        this.firePersist(new PersistEvent(entityName, object, this));
    }

    @Override
    public void persist(Object object) throws HibernateException {
        this.checkOpen();
        this.firePersist(new PersistEvent(null, object, this));
    }

    @Override
    public void persist(String entityName, Object object, PersistContext copiedAlready) throws HibernateException {
        this.checkOpenOrWaitingForAutoClose();
        this.firePersist(copiedAlready, new PersistEvent(entityName, object, this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePersist(PersistEvent event) {
        Throwable originalException = null;
        try {
            this.checkTransactionSynchStatus();
            this.checkNoUnresolvedActionsBeforeOperation();
            this.fastSessionServices.eventListenerGroup_PERSIST.fireEventOnEachListener(event, PersistEventListener::onPersist);
        }
        catch (MappingException e) {
            originalException = this.getExceptionConverter().convert(new IllegalArgumentException(e.getMessage(), (Throwable)((Object)e)));
        }
        catch (RuntimeException e) {
            originalException = this.getExceptionConverter().convert(e);
        }
        catch (Throwable t1) {
            originalException = t1;
        }
        finally {
            Throwable suppressed = null;
            try {
                this.checkNoUnresolvedActionsAfterOperation();
            }
            catch (RuntimeException e) {
                suppressed = this.getExceptionConverter().convert(e);
            }
            catch (Throwable t2) {
                suppressed = t2;
            }
            if (suppressed != null) {
                if (originalException == null) {
                    originalException = suppressed;
                } else {
                    originalException.addSuppressed(suppressed);
                }
            }
        }
        if (originalException != null) {
            ExceptionHelper.doThrow(originalException);
        }
    }

    private void firePersist(PersistContext copiedAlready, PersistEvent event) {
        this.pulseTransactionCoordinator();
        try {
            this.fastSessionServices.eventListenerGroup_PERSIST.fireEventOnEachListener(event, copiedAlready, PersistEventListener::onPersist);
        }
        catch (MappingException e) {
            throw this.getExceptionConverter().convert(new IllegalArgumentException(e.getMessage()));
        }
        catch (RuntimeException e) {
            throw this.getExceptionConverter().convert(e);
        }
        finally {
            this.delayedAfterCompletion();
        }
    }

    @Override
    public void persistOnFlush(String entityName, Object object, PersistContext copiedAlready) {
        this.checkOpenOrWaitingForAutoClose();
        this.pulseTransactionCoordinator();
        PersistEvent event = new PersistEvent(entityName, object, this);
        this.fastSessionServices.eventListenerGroup_PERSIST_ONFLUSH.fireEventOnEachListener(event, copiedAlready, PersistEventListener::onPersist);
        this.delayedAfterCompletion();
    }

    @Override
    public <T> T merge(String entityName, T object) throws HibernateException {
        this.checkOpen();
        return (T)this.fireMerge(new MergeEvent(entityName, object, this));
    }

    @Override
    public <T> T merge(T object) throws HibernateException {
        this.checkOpen();
        return (T)this.fireMerge(new MergeEvent(null, object, this));
    }

    @Override
    public void merge(String entityName, Object object, MergeContext copiedAlready) throws HibernateException {
        this.checkOpenOrWaitingForAutoClose();
        this.fireMerge(copiedAlready, new MergeEvent(entityName, object, this));
    }

    private Object fireMerge(MergeEvent event) {
        try {
            this.checkTransactionSynchStatus();
            this.checkNoUnresolvedActionsBeforeOperation();
            this.fastSessionServices.eventListenerGroup_MERGE.fireEventOnEachListener(event, MergeEventListener::onMerge);
            this.checkNoUnresolvedActionsAfterOperation();
        }
        catch (ObjectDeletedException sse) {
            throw this.getExceptionConverter().convert(new IllegalArgumentException((Throwable)((Object)sse)));
        }
        catch (MappingException e) {
            throw this.getExceptionConverter().convert(new IllegalArgumentException(e.getMessage(), (Throwable)((Object)e)));
        }
        catch (RuntimeException e) {
            throw this.getExceptionConverter().convert(e);
        }
        return event.getResult();
    }

    private void fireMerge(MergeContext mergeContext, MergeEvent event) {
        try {
            this.pulseTransactionCoordinator();
            this.fastSessionServices.eventListenerGroup_MERGE.fireEventOnEachListener(event, mergeContext, MergeEventListener::onMerge);
        }
        catch (ObjectDeletedException sse) {
            throw this.getExceptionConverter().convert(new IllegalArgumentException((Throwable)((Object)sse)));
        }
        catch (MappingException e) {
            throw this.getExceptionConverter().convert(new IllegalArgumentException(e.getMessage(), (Throwable)((Object)e)));
        }
        catch (RuntimeException e) {
            throw this.getExceptionConverter().convert(e);
        }
        finally {
            this.delayedAfterCompletion();
        }
    }

    @Override
    @Deprecated
    public void delete(Object object) throws HibernateException {
        this.checkOpen();
        this.fireDelete(new DeleteEvent(object, this));
    }

    @Override
    @Deprecated
    public void delete(String entityName, Object object) throws HibernateException {
        this.checkOpen();
        this.fireDelete(new DeleteEvent(entityName, object, this));
    }

    @Override
    public void delete(String entityName, Object object, boolean isCascadeDeleteEnabled, DeleteContext transientEntities) throws HibernateException {
        this.checkOpenOrWaitingForAutoClose();
        boolean removingOrphanBeforeUpates = this.persistenceContext.isRemovingOrphanBeforeUpates();
        boolean traceEnabled = log.isTraceEnabled();
        if (traceEnabled && removingOrphanBeforeUpates) {
            this.logRemoveOrphanBeforeUpdates("before continuing", entityName, object);
        }
        this.fireDelete(new DeleteEvent(entityName, object, isCascadeDeleteEnabled, removingOrphanBeforeUpates, this), transientEntities);
        if (traceEnabled && removingOrphanBeforeUpates) {
            this.logRemoveOrphanBeforeUpdates("after continuing", entityName, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeOrphanBeforeUpdates(String entityName, Object child) {
        boolean traceEnabled = log.isTraceEnabled();
        if (traceEnabled) {
            this.logRemoveOrphanBeforeUpdates("begin", entityName, child);
        }
        this.persistenceContext.beginRemoveOrphanBeforeUpdates();
        try {
            this.checkOpenOrWaitingForAutoClose();
            this.fireDelete(new DeleteEvent(entityName, child, false, true, this));
        }
        finally {
            this.persistenceContext.endRemoveOrphanBeforeUpdates();
            if (traceEnabled) {
                this.logRemoveOrphanBeforeUpdates("end", entityName, child);
            }
        }
    }

    private void logRemoveOrphanBeforeUpdates(String timing, String entityName, Object entity) {
        if (log.isTraceEnabled()) {
            EntityEntry entityEntry = this.persistenceContext.getEntry(entity);
            log.tracef("%s remove orphan before updates: [%s]", timing, entityEntry == null ? entityName : MessageHelper.infoString(entityName, entityEntry.getId()));
        }
    }

    private void fireDelete(DeleteEvent event) {
        try {
            this.pulseTransactionCoordinator();
            this.fastSessionServices.eventListenerGroup_DELETE.fireEventOnEachListener(event, DeleteEventListener::onDelete);
        }
        catch (ObjectDeletedException sse) {
            throw this.getExceptionConverter().convert(new IllegalArgumentException((Throwable)((Object)sse)));
        }
        catch (MappingException e) {
            throw this.getExceptionConverter().convert(new IllegalArgumentException(e.getMessage(), (Throwable)((Object)e)));
        }
        catch (RuntimeException e) {
            throw this.getExceptionConverter().convert(e);
        }
        finally {
            this.delayedAfterCompletion();
        }
    }

    private void fireDelete(DeleteEvent event, DeleteContext transientEntities) {
        try {
            this.pulseTransactionCoordinator();
            this.fastSessionServices.eventListenerGroup_DELETE.fireEventOnEachListener(event, transientEntities, DeleteEventListener::onDelete);
        }
        catch (ObjectDeletedException sse) {
            throw this.getExceptionConverter().convert(new IllegalArgumentException((Throwable)((Object)sse)));
        }
        catch (MappingException e) {
            throw this.getExceptionConverter().convert(new IllegalArgumentException(e.getMessage(), (Throwable)((Object)e)));
        }
        catch (RuntimeException e) {
            throw this.getExceptionConverter().convert(e);
        }
        finally {
            this.delayedAfterCompletion();
        }
    }

    @Override
    public void load(Object object, Object id) throws HibernateException {
        this.fireLoad(new LoadEvent(id, object, this, this.getReadOnlyFromLoadQueryInfluencers()), LoadEventListener.RELOAD);
    }

    @Override
    @Deprecated
    public <T> T load(Class<T> entityClass, Object id) throws HibernateException {
        return ((IdentifierLoadAccessImpl)this.byId((Class)entityClass)).getReference(id);
    }

    @Override
    @Deprecated
    public Object load(String entityName, Object id) throws HibernateException {
        return ((IdentifierLoadAccessImpl)this.byId(entityName)).getReference(id);
    }

    @Override
    public <T> T get(Class<T> entityClass, Object id) throws HibernateException {
        return ((IdentifierLoadAccessImpl)this.byId((Class)entityClass)).load(id);
    }

    @Override
    public Object get(String entityName, Object id) throws HibernateException {
        return ((IdentifierLoadAccessImpl)this.byId(entityName)).load(id);
    }

    @Override
    public Object immediateLoad(String entityName, Object id) throws HibernateException {
        if (log.isDebugEnabled()) {
            EntityPersister persister = this.getFactory().getMappingMetamodel().getEntityDescriptor(entityName);
            log.debugf("Initializing proxy: %s", MessageHelper.infoString(persister, id, this.getFactory()));
        }
        LoadEvent event = this.loadEvent;
        this.loadEvent = null;
        event = this.recycleEventInstance(event, id, entityName);
        this.fireLoadNoChecks(event, LoadEventListener.IMMEDIATE_LOAD);
        Object result = event.getResult();
        this.finishWithEventInstance(event);
        LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(result);
        return lazyInitializer != null ? lazyInitializer.getImplementation() : result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object internalLoad(String entityName, Object id, boolean eager, boolean nullable) {
        boolean clearedEffectiveGraph;
        LoadEventListener.LoadType type = SessionImpl.internalLoadType(eager, nullable);
        EffectiveEntityGraph effectiveEntityGraph = this.loadQueryInfluencers.getEffectiveEntityGraph();
        GraphSemantic semantic = effectiveEntityGraph.getSemantic();
        RootGraphImplementor graph = effectiveEntityGraph.getGraph();
        if (semantic == null || graph.appliesTo(this.getFactory().getJpaMetamodel().entity(entityName))) {
            clearedEffectiveGraph = false;
        } else {
            log.debug("Clearing effective entity graph for subsequent-select");
            clearedEffectiveGraph = true;
            effectiveEntityGraph.clear();
        }
        try {
            LoadEvent event = this.loadEvent;
            this.loadEvent = null;
            event = this.recycleEventInstance(event, id, entityName);
            this.fireLoadNoChecks(event, type);
            Object result = event.getResult();
            if (!nullable) {
                UnresolvableObjectException.throwIfNull(result, id, entityName);
            }
            this.finishWithEventInstance(event);
            Object object = result;
            return object;
        }
        finally {
            if (clearedEffectiveGraph) {
                effectiveEntityGraph.applyGraph(graph, semantic);
            }
        }
    }

    protected static LoadEventListener.LoadType internalLoadType(boolean eager, boolean nullable) {
        if (nullable) {
            return LoadEventListener.INTERNAL_LOAD_NULLABLE;
        }
        return eager ? LoadEventListener.INTERNAL_LOAD_EAGER : LoadEventListener.INTERNAL_LOAD_LAZY;
    }

    private LoadEvent recycleEventInstance(LoadEvent event, Object id, String entityName) {
        if (event == null) {
            return new LoadEvent(id, entityName, true, (EventSource)this, this.getReadOnlyFromLoadQueryInfluencers());
        }
        event.setEntityClassName(entityName);
        event.setEntityId(id);
        event.setInstanceToLoad(null);
        return event;
    }

    private void finishWithEventInstance(LoadEvent event) {
        if (this.loadEvent == null) {
            event.setEntityClassName(null);
            event.setEntityId(null);
            event.setInstanceToLoad(null);
            event.setResult(null);
            this.loadEvent = event;
        }
    }

    @Override
    @Deprecated
    public <T> T load(Class<T> entityClass, Object id, LockMode lockMode) throws HibernateException {
        return ((IdentifierLoadAccessImpl)((IdentifierLoadAccessImpl)this.byId((Class)entityClass)).with(new LockOptions(lockMode))).getReference(id);
    }

    @Override
    @Deprecated
    public <T> T load(Class<T> entityClass, Object id, LockOptions lockOptions) throws HibernateException {
        return ((IdentifierLoadAccessImpl)((IdentifierLoadAccessImpl)this.byId((Class)entityClass)).with(lockOptions)).getReference(id);
    }

    @Override
    @Deprecated
    public Object load(String entityName, Object id, LockMode lockMode) throws HibernateException {
        return ((IdentifierLoadAccessImpl)((IdentifierLoadAccessImpl)this.byId(entityName)).with(new LockOptions(lockMode))).getReference(id);
    }

    @Override
    @Deprecated
    public Object load(String entityName, Object id, LockOptions lockOptions) throws HibernateException {
        return ((IdentifierLoadAccessImpl)((IdentifierLoadAccessImpl)this.byId(entityName)).with(lockOptions)).getReference(id);
    }

    @Override
    public <T> T get(Class<T> entityClass, Object id, LockMode lockMode) throws HibernateException {
        return ((IdentifierLoadAccessImpl)((IdentifierLoadAccessImpl)this.byId((Class)entityClass)).with(new LockOptions(lockMode))).load(id);
    }

    @Override
    public <T> T get(Class<T> entityClass, Object id, LockOptions lockOptions) throws HibernateException {
        return ((IdentifierLoadAccessImpl)((IdentifierLoadAccessImpl)this.byId((Class)entityClass)).with(lockOptions)).load(id);
    }

    @Override
    public Object get(String entityName, Object id, LockMode lockMode) throws HibernateException {
        return ((IdentifierLoadAccessImpl)((IdentifierLoadAccessImpl)this.byId(entityName)).with(new LockOptions(lockMode))).load(id);
    }

    @Override
    public Object get(String entityName, Object id, LockOptions lockOptions) throws HibernateException {
        return ((IdentifierLoadAccessImpl)((IdentifierLoadAccessImpl)this.byId(entityName)).with(lockOptions)).load(id);
    }

    public <T> IdentifierLoadAccessImpl<T> byId(String entityName) {
        return new IdentifierLoadAccessImpl(this, this.requireEntityPersister(entityName));
    }

    public <T> IdentifierLoadAccessImpl<T> byId(Class<T> entityClass) {
        return new IdentifierLoadAccessImpl(this, this.requireEntityPersister(entityClass));
    }

    @Override
    public <T> MultiIdentifierLoadAccess<T> byMultipleIds(Class<T> entityClass) {
        return new MultiIdentifierLoadAccessImpl(this, this.requireEntityPersister(entityClass));
    }

    @Override
    public <T> MultiIdentifierLoadAccess<T> byMultipleIds(String entityName) {
        return new MultiIdentifierLoadAccessImpl(this, this.requireEntityPersister(entityName));
    }

    @Override
    public <T> NaturalIdLoadAccess<T> byNaturalId(String entityName) {
        return new NaturalIdLoadAccessImpl(this, this.requireEntityPersister(entityName));
    }

    @Override
    public <T> NaturalIdLoadAccess<T> byNaturalId(Class<T> entityClass) {
        return new NaturalIdLoadAccessImpl(this, this.requireEntityPersister(entityClass));
    }

    @Override
    public <T> SimpleNaturalIdLoadAccess<T> bySimpleNaturalId(String entityName) {
        return new SimpleNaturalIdLoadAccessImpl(this, this.requireEntityPersister(entityName));
    }

    @Override
    public <T> SimpleNaturalIdLoadAccess<T> bySimpleNaturalId(Class<T> entityClass) {
        return new SimpleNaturalIdLoadAccessImpl(this, this.requireEntityPersister(entityClass));
    }

    @Override
    public <T> NaturalIdMultiLoadAccess<T> byMultipleNaturalId(Class<T> entityClass) {
        return new NaturalIdMultiLoadAccessStandard(this.requireEntityPersister(entityClass), this);
    }

    @Override
    public <T> NaturalIdMultiLoadAccess<T> byMultipleNaturalId(String entityName) {
        return new NaturalIdMultiLoadAccessStandard(this.requireEntityPersister(entityName), this);
    }

    @Override
    public void fireLoad(LoadEvent event, LoadEventListener.LoadType loadType) {
        this.checkOpenOrWaitingForAutoClose();
        this.fireLoadNoChecks(event, loadType);
        this.delayedAfterCompletion();
    }

    private void fireLoadNoChecks(LoadEvent event, LoadEventListener.LoadType loadType) {
        this.pulseTransactionCoordinator();
        this.fastSessionServices.eventListenerGroup_LOAD.fireEventOnEachListener(event, loadType, LoadEventListener::onLoad);
    }

    private void fireResolveNaturalId(ResolveNaturalIdEvent event) {
        this.checkOpenOrWaitingForAutoClose();
        this.pulseTransactionCoordinator();
        this.fastSessionServices.eventListenerGroup_RESOLVE_NATURAL_ID.fireEventOnEachListener(event, ResolveNaturalIdEventListener::onResolveNaturalId);
        this.delayedAfterCompletion();
    }

    @Override
    public void refresh(Object object) throws HibernateException {
        this.checkOpen();
        this.fireRefresh(new RefreshEvent(null, object, (EventSource)this));
    }

    @Override
    @Deprecated
    public void refresh(String entityName, Object object) throws HibernateException {
        this.checkOpen();
        this.fireRefresh(new RefreshEvent(entityName, object, (EventSource)this));
    }

    @Override
    public void refresh(Object object, LockMode lockMode) throws HibernateException {
        this.checkOpen();
        this.fireRefresh(new RefreshEvent(object, lockMode, (EventSource)this));
    }

    @Override
    public void refresh(Object object, LockOptions lockOptions) throws HibernateException {
        this.checkOpen();
        this.refresh(null, object, lockOptions);
    }

    @Override
    @Deprecated
    public void refresh(String entityName, Object object, LockOptions lockOptions) throws HibernateException {
        this.checkOpen();
        this.fireRefresh(new RefreshEvent(entityName, object, lockOptions, this));
    }

    @Override
    public void refresh(String entityName, Object object, RefreshContext refreshedAlready) throws HibernateException {
        this.checkOpenOrWaitingForAutoClose();
        this.fireRefresh(refreshedAlready, new RefreshEvent(entityName, object, (EventSource)this));
    }

    private void fireRefresh(RefreshEvent event) {
        try {
            if (!this.getSessionFactory().getSessionFactoryOptions().isAllowRefreshDetachedEntity() && (event.getEntityName() != null ? !this.contains(event.getEntityName(), event.getObject()) : !this.contains(event.getObject()))) {
                throw new IllegalArgumentException("Entity not managed");
            }
            this.pulseTransactionCoordinator();
            this.fastSessionServices.eventListenerGroup_REFRESH.fireEventOnEachListener(event, RefreshEventListener::onRefresh);
        }
        catch (RuntimeException e) {
            if (!this.getSessionFactory().getSessionFactoryOptions().isJpaBootstrap() && e instanceof HibernateException) {
                throw e;
            }
            throw this.getExceptionConverter().convert(e);
        }
        finally {
            this.delayedAfterCompletion();
        }
    }

    private void fireRefresh(RefreshContext refreshedAlready, RefreshEvent event) {
        try {
            this.pulseTransactionCoordinator();
            this.fastSessionServices.eventListenerGroup_REFRESH.fireEventOnEachListener(event, refreshedAlready, RefreshEventListener::onRefresh);
        }
        catch (RuntimeException e) {
            throw this.getExceptionConverter().convert(e);
        }
        finally {
            this.delayedAfterCompletion();
        }
    }

    @Override
    public void replicate(Object obj, ReplicationMode replicationMode) throws HibernateException {
        this.fireReplicate(new ReplicateEvent(obj, replicationMode, this));
    }

    @Override
    public void replicate(String entityName, Object obj, ReplicationMode replicationMode) throws HibernateException {
        this.fireReplicate(new ReplicateEvent(entityName, obj, replicationMode, this));
    }

    private void fireReplicate(ReplicateEvent event) {
        this.checkOpen();
        this.pulseTransactionCoordinator();
        this.fastSessionServices.eventListenerGroup_REPLICATE.fireEventOnEachListener(event, ReplicateEventListener::onReplicate);
        this.delayedAfterCompletion();
    }

    @Override
    public void evict(Object object) throws HibernateException {
        this.checkOpen();
        this.pulseTransactionCoordinator();
        EvictEvent event = new EvictEvent(object, this);
        this.fastSessionServices.eventListenerGroup_EVICT.fireEventOnEachListener(event, EvictEventListener::onEvict);
        this.delayedAfterCompletion();
    }

    @Override
    public boolean autoFlushIfRequired(Set<String> querySpaces) throws HibernateException {
        this.checkOpen();
        if (!this.isTransactionInProgress()) {
            return false;
        }
        AutoFlushEvent event = new AutoFlushEvent(querySpaces, this);
        this.fastSessionServices.eventListenerGroup_AUTO_FLUSH.fireEventOnEachListener(event, AutoFlushEventListener::onAutoFlush);
        return event.isFlushRequired();
    }

    @Override
    public boolean isDirty() throws HibernateException {
        this.checkOpen();
        this.pulseTransactionCoordinator();
        log.debug("Checking session dirtiness");
        if (this.actionQueue.areInsertionsOrDeletionsQueued()) {
            log.debug("Session dirty (scheduled updates and insertions)");
            return true;
        }
        DirtyCheckEvent event = new DirtyCheckEvent(this);
        this.fastSessionServices.eventListenerGroup_DIRTY_CHECK.fireEventOnEachListener(event, DirtyCheckEventListener::onDirtyCheck);
        this.delayedAfterCompletion();
        return event.isDirty();
    }

    @Override
    public void flush() throws HibernateException {
        this.checkOpen();
        this.doFlush();
    }

    private void doFlush() {
        this.pulseTransactionCoordinator();
        this.checkTransactionNeededForUpdateOperation();
        try {
            if (this.persistenceContext.getCascadeLevel() > 0) {
                throw new HibernateException("Flush during cascade is dangerous");
            }
            FlushEvent event = new FlushEvent(this);
            this.fastSessionServices.eventListenerGroup_FLUSH.fireEventOnEachListener(event, FlushEventListener::onFlush);
            this.delayedAfterCompletion();
        }
        catch (RuntimeException e) {
            throw this.getExceptionConverter().convert(e);
        }
    }

    @Override
    public void setFlushMode(FlushModeType flushModeType) {
        this.checkOpen();
        this.setHibernateFlushMode(FlushModeTypeHelper.getFlushMode(flushModeType));
    }

    @Override
    public void forceFlush(EntityEntry entityEntry) throws HibernateException {
        this.forceFlush(entityEntry.getEntityKey());
    }

    @Override
    public void forceFlush(EntityKey key) throws HibernateException {
        if (log.isDebugEnabled()) {
            log.debugf("Flushing to force deletion of re-saved object: %s", MessageHelper.infoString(key.getPersister(), key.getIdentifier(), this.getFactory()));
        }
        if (this.persistenceContext.getCascadeLevel() > 0) {
            throw new ObjectDeletedException("deleted object would be re-saved by cascade (remove deleted object from associations)", key.getIdentifier(), key.getPersister().getEntityName());
        }
        this.checkOpenOrWaitingForAutoClose();
        this.doFlush();
    }

    @Override
    public Object instantiate(String entityName, Object id) throws HibernateException {
        EntityPersister persister = this.getFactory().getRuntimeMetamodels().getMappingMetamodel().getEntityDescriptor(entityName);
        return this.instantiate(persister, id);
    }

    @Override
    public Object instantiate(EntityPersister persister, Object id) throws HibernateException {
        this.checkOpenOrWaitingForAutoClose();
        this.pulseTransactionCoordinator();
        Object result = this.getInterceptor().instantiate(persister.getEntityName(), persister.getRepresentationStrategy(), id);
        if (result == null) {
            result = persister.instantiate(id, this);
        }
        this.delayedAfterCompletion();
        return result;
    }

    @Override
    public EntityPersister getEntityPersister(String entityName, Object object) {
        this.checkOpenOrWaitingForAutoClose();
        if (entityName == null) {
            return this.getFactory().getRuntimeMetamodels().getMappingMetamodel().getEntityDescriptor(this.guessEntityName(object));
        }
        try {
            return this.getFactory().getRuntimeMetamodels().getMappingMetamodel().getEntityDescriptor(entityName).getSubclassEntityPersister(object, this.getFactory());
        }
        catch (HibernateException e) {
            try {
                return this.getEntityPersister(null, object);
            }
            catch (HibernateException e2) {
                throw e;
            }
        }
    }

    @Override
    public Object getIdentifier(Object object) throws HibernateException {
        this.checkOpen();
        this.checkTransactionSynchStatus();
        LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(object);
        if (lazyInitializer != null) {
            if (lazyInitializer.getSession() != this) {
                throw new TransientObjectException("The proxy was not associated with this session");
            }
            return lazyInitializer.getInternalIdentifier();
        }
        EntityEntry entry = this.persistenceContext.getEntry(object);
        if (entry == null) {
            throw new TransientObjectException("The instance was not associated with this session");
        }
        return entry.getId();
    }

    @Override
    public Object getContextEntityIdentifier(Object object) {
        this.checkOpenOrWaitingForAutoClose();
        LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(object);
        if (lazyInitializer != null) {
            return lazyInitializer.getInternalIdentifier();
        }
        EntityEntry entry = this.persistenceContext.getEntry(object);
        return entry != null ? entry.getId() : null;
    }

    public boolean contains(Object object) {
        this.checkOpen();
        this.pulseTransactionCoordinator();
        if (object == null) {
            return false;
        }
        try {
            LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(object);
            if (lazyInitializer != null) {
                if (lazyInitializer.isUninitialized()) {
                    return lazyInitializer.getSession() == this;
                }
                object = lazyInitializer.getImplementation();
            }
            EntityEntry entry = this.persistenceContext.getEntry(object);
            this.delayedAfterCompletion();
            if (entry == null) {
                if (lazyInitializer == null && this.persistenceContext.getEntry(object) == null) {
                    try {
                        String entityName = this.getEntityNameResolver().resolveEntityName(object);
                        if (entityName == null) {
                            throw new IllegalArgumentException("Could not resolve entity name for class '" + object.getClass() + "'");
                        }
                        this.getFactory().getRuntimeMetamodels().getMappingMetamodel().getEntityDescriptor(entityName);
                    }
                    catch (HibernateException e) {
                        throw new IllegalArgumentException("Class '" + object.getClass() + "' is not an entity class", (Throwable)((Object)e));
                    }
                }
                return false;
            }
            return !entry.getStatus().isDeletedOrGone();
        }
        catch (MappingException e) {
            throw new IllegalArgumentException(e.getMessage(), (Throwable)((Object)e));
        }
        catch (RuntimeException e) {
            throw this.getExceptionConverter().convert(e);
        }
    }

    @Override
    public boolean contains(String entityName, Object object) {
        this.checkOpenOrWaitingForAutoClose();
        this.pulseTransactionCoordinator();
        if (object == null) {
            return false;
        }
        try {
            LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(object);
            if (lazyInitializer == null && this.persistenceContext.getEntry(object) == null) {
                try {
                    this.getFactory().getMappingMetamodel().getEntityDescriptor(entityName);
                }
                catch (HibernateException e) {
                    throw new IllegalArgumentException("Not an entity [" + entityName + "] : " + object);
                }
            }
            if (lazyInitializer != null) {
                if (lazyInitializer.isUninitialized()) {
                    return lazyInitializer.getSession() == this;
                }
                object = lazyInitializer.getImplementation();
            }
            EntityEntry entry = this.persistenceContext.getEntry(object);
            this.delayedAfterCompletion();
            return entry != null && !entry.getStatus().isDeletedOrGone();
        }
        catch (MappingException e) {
            throw new IllegalArgumentException(e.getMessage(), (Throwable)((Object)e));
        }
        catch (RuntimeException e) {
            throw this.getExceptionConverter().convert(e);
        }
    }

    @Override
    public ProcedureCall createStoredProcedureCall(String procedureName) {
        this.checkOpen();
        return super.createStoredProcedureCall(procedureName);
    }

    @Override
    public ProcedureCall createStoredProcedureCall(String procedureName, String ... resultSetMappings) {
        this.checkOpen();
        return super.createStoredProcedureCall(procedureName, resultSetMappings);
    }

    @Override
    public ProcedureCall createStoredProcedureCall(String procedureName, Class<?> ... resultClasses) {
        this.checkOpen();
        return super.createStoredProcedureCall(procedureName, resultClasses);
    }

    @Override
    public SessionFactoryImplementor getSessionFactory() {
        return this.getFactory();
    }

    @Override
    public void initializeCollection(PersistentCollection<?> collection, boolean writing) {
        this.checkOpenOrWaitingForAutoClose();
        this.pulseTransactionCoordinator();
        InitializeCollectionEvent event = new InitializeCollectionEvent(collection, this);
        this.fastSessionServices.eventListenerGroup_INIT_COLLECTION.fireEventOnEachListener(event, InitializeCollectionEventListener::onInitializeCollection);
        this.delayedAfterCompletion();
    }

    @Override
    public String bestGuessEntityName(Object object) {
        EntityEntry entry;
        LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(object);
        if (lazyInitializer != null) {
            if (lazyInitializer.isUninitialized()) {
                return lazyInitializer.getEntityName();
            }
            object = lazyInitializer.getImplementation();
        }
        if ((entry = this.persistenceContext.getEntry(object)) == null) {
            return this.guessEntityName(object);
        }
        return entry.getPersister().getEntityName();
    }

    @Override
    public String bestGuessEntityName(Object object, EntityEntry entry) {
        LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(object);
        if (lazyInitializer != null) {
            if (lazyInitializer.isUninitialized()) {
                return lazyInitializer.getEntityName();
            }
            object = lazyInitializer.getImplementation();
        }
        if (entry == null) {
            return this.guessEntityName(object);
        }
        return entry.getPersister().getEntityName();
    }

    @Override
    public String getEntityName(Object object) {
        EntityEntry entry;
        this.checkOpen();
        LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(object);
        if (lazyInitializer != null) {
            if (!this.persistenceContext.containsProxy(object)) {
                throw new TransientObjectException("proxy was not associated with the session");
            }
            object = lazyInitializer.getImplementation();
        }
        if ((entry = this.persistenceContext.getEntry(object)) == null) {
            this.throwTransientObjectException(object);
        }
        return entry.getPersister().getEntityName();
    }

    @Override
    public <T> T getReference(T object) {
        this.checkOpen();
        LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(object);
        if (lazyInitializer != null) {
            return (T)this.getReference(lazyInitializer.getPersistentClass(), lazyInitializer.getIdentifier());
        }
        EntityPersister persister = this.getEntityPersister(null, object);
        return (T)this.getReference(persister.getMappedClass(), persister.getIdentifier(object, this));
    }

    private void throwTransientObjectException(Object object) throws HibernateException {
        throw new TransientObjectException("object references an unsaved transient instance - save the transient instance before flushing: " + this.guessEntityName(object));
    }

    @Override
    public String guessEntityName(Object object) throws HibernateException {
        this.checkOpenOrWaitingForAutoClose();
        return this.getEntityNameResolver().resolveEntityName(object);
    }

    @Override
    public void cancelQuery() throws HibernateException {
        this.checkOpen();
        this.getJdbcCoordinator().cancelLastQuery();
    }

    public String toString() {
        StringBuilder string = new StringBuilder(500).append("SessionImpl(").append(System.identityHashCode(this));
        if (!this.isClosed()) {
            if (log.isTraceEnabled()) {
                string.append(this.persistenceContext).append(";").append(this.actionQueue);
            } else {
                string.append("<open>");
            }
        } else {
            string.append("<closed>");
        }
        return string.append(')').toString();
    }

    @Override
    public ActionQueue getActionQueue() {
        this.checkOpenOrWaitingForAutoClose();
        return this.actionQueue;
    }

    @Override
    public PersistenceContext getPersistenceContext() {
        this.checkOpenOrWaitingForAutoClose();
        return this.persistenceContext;
    }

    @Override
    public PersistenceContext getPersistenceContextInternal() {
        return this.persistenceContext;
    }

    @Override
    public SessionStatistics getStatistics() {
        this.pulseTransactionCoordinator();
        return new SessionStatisticsImpl(this);
    }

    @Override
    public boolean isEventSource() {
        this.pulseTransactionCoordinator();
        return true;
    }

    @Override
    public EventSource asEventSource() {
        return this;
    }

    @Override
    public boolean isDefaultReadOnly() {
        return this.persistenceContext.isDefaultReadOnly();
    }

    @Override
    public void setDefaultReadOnly(boolean defaultReadOnly) {
        this.persistenceContext.setDefaultReadOnly(defaultReadOnly);
    }

    @Override
    public boolean isReadOnly(Object entityOrProxy) {
        this.checkOpen();
        return this.persistenceContext.isReadOnly(entityOrProxy);
    }

    @Override
    public void setReadOnly(Object entity, boolean readOnly) {
        this.checkOpen();
        this.persistenceContext.setReadOnly(entity, readOnly);
    }

    @Override
    public CacheStoreMode getCacheStoreMode() {
        return this.getCacheMode().getJpaStoreMode();
    }

    @Override
    public CacheRetrieveMode getCacheRetrieveMode() {
        return this.getCacheMode().getJpaRetrieveMode();
    }

    @Override
    public void setCacheStoreMode(CacheStoreMode cacheStoreMode) {
        this.setCacheMode(CacheMode.fromJpaModes(this.getCacheMode().getJpaRetrieveMode(), cacheStoreMode));
    }

    @Override
    public void setCacheRetrieveMode(CacheRetrieveMode cacheRetrieveMode) {
        this.setCacheMode(CacheMode.fromJpaModes(cacheRetrieveMode, this.getCacheMode().getJpaStoreMode()));
    }

    @Override
    public void afterScrollOperation() {
    }

    @Override
    public LoadQueryInfluencers getLoadQueryInfluencers() {
        return this.loadQueryInfluencers;
    }

    @Override
    public Filter getEnabledFilter(String filterName) {
        this.pulseTransactionCoordinator();
        return this.loadQueryInfluencers.getEnabledFilter(filterName);
    }

    @Override
    public Filter enableFilter(String filterName) {
        this.checkOpen();
        this.pulseTransactionCoordinator();
        return this.loadQueryInfluencers.enableFilter(filterName);
    }

    @Override
    public void disableFilter(String filterName) {
        this.checkOpen();
        this.pulseTransactionCoordinator();
        this.loadQueryInfluencers.disableFilter(filterName);
    }

    @Override
    public boolean isFetchProfileEnabled(String name) throws UnknownProfileException {
        return this.loadQueryInfluencers.isFetchProfileEnabled(name);
    }

    @Override
    public void enableFetchProfile(String name) throws UnknownProfileException {
        this.loadQueryInfluencers.enableFetchProfile(name);
    }

    @Override
    public void disableFetchProfile(String name) throws UnknownProfileException {
        this.loadQueryInfluencers.disableFetchProfile(name);
    }

    @Override
    public void setSubselectFetchingEnabled(boolean enabled) {
        this.loadQueryInfluencers.setSubselectFetchEnabled(enabled);
    }

    @Override
    public boolean isSubselectFetchingEnabled() {
        return this.loadQueryInfluencers.getSubselectFetchEnabled();
    }

    @Override
    public void setFetchBatchSize(int batchSize) {
        this.loadQueryInfluencers.setBatchSize(batchSize);
    }

    @Override
    public int getFetchBatchSize() {
        return this.loadQueryInfluencers.getBatchSize();
    }

    @Override
    public LobHelper getLobHelper() {
        if (this.lobHelper == null) {
            this.lobHelper = new LobHelperImpl();
        }
        return this.lobHelper;
    }

    private Transaction getTransactionIfAccessible() {
        return this.fastSessionServices.isJtaTransactionAccessible ? this.accessTransaction() : null;
    }

    @Override
    public void beforeTransactionCompletion() {
        log.trace("SessionImpl#beforeTransactionCompletion()");
        this.flushBeforeTransactionCompletion();
        this.actionQueue.beforeTransactionCompletion();
        try {
            this.getInterceptor().beforeTransactionCompletion(this.getTransactionIfAccessible());
        }
        catch (Throwable t) {
            log.exceptionInBeforeTransactionCompletionInterceptor(t);
        }
        super.beforeTransactionCompletion();
    }

    @Override
    public void afterTransactionCompletion(boolean successful, boolean delayed) {
        if (log.isTraceEnabled()) {
            log.tracef("SessionImpl#afterTransactionCompletion(successful=%s, delayed=%s)", successful, delayed);
        }
        if (!(this.isClosed() && !this.waitingForAutoClose || !this.autoClear && successful)) {
            this.internalClear();
        }
        this.persistenceContext.afterTransactionCompletion();
        this.actionQueue.afterTransactionCompletion(successful);
        this.getEventListenerManager().transactionCompletion(successful);
        StatisticsImplementor statistics = this.getFactory().getStatistics();
        if (statistics.isStatisticsEnabled()) {
            statistics.endTransaction(successful);
        }
        try {
            this.getInterceptor().afterTransactionCompletion(this.getTransactionIfAccessible());
        }
        catch (Throwable t) {
            log.exceptionInAfterTransactionCompletionInterceptor(t);
        }
        if (!delayed && this.shouldAutoClose() && (!this.isClosed() || this.waitingForAutoClose)) {
            this.managedClose();
        }
        super.afterTransactionCompletion(successful, delayed);
    }

    @Override
    protected void addSharedSessionTransactionObserver(TransactionCoordinator transactionCoordinator) {
        this.transactionObserver = new TransactionObserver(){

            @Override
            public void afterBegin() {
            }

            @Override
            public void beforeCompletion() {
                if (SessionImpl.this.isOpen() && SessionImpl.this.getHibernateFlushMode() != FlushMode.MANUAL) {
                    SessionImpl.this.managedFlush();
                }
                SessionImpl.this.actionQueue.beforeTransactionCompletion();
                try {
                    SessionImpl.this.getInterceptor().beforeTransactionCompletion(SessionImpl.this.getTransactionIfAccessible());
                }
                catch (Throwable t) {
                    log.exceptionInBeforeTransactionCompletionInterceptor(t);
                }
            }

            @Override
            public void afterCompletion(boolean successful, boolean delayed) {
                SessionImpl.this.afterTransactionCompletion(successful, delayed);
                if (!SessionImpl.this.isClosed() && SessionImpl.this.autoClose) {
                    SessionImpl.this.managedClose();
                }
            }
        };
        transactionCoordinator.addObserver(this.transactionObserver);
    }

    @Override
    protected void removeSharedSessionTransactionObserver(TransactionCoordinator transactionCoordinator) {
        super.removeSharedSessionTransactionObserver(transactionCoordinator);
        transactionCoordinator.removeObserver(this.transactionObserver);
    }

    private EntityPersister requireEntityPersister(Class<?> entityClass) {
        return this.getFactory().getRuntimeMetamodels().getMappingMetamodel().getEntityDescriptor(entityClass);
    }

    private EntityPersister requireEntityPersister(String entityName) {
        return this.getFactory().getRuntimeMetamodels().getMappingMetamodel().getEntityDescriptor(entityName);
    }

    @Override
    public void startTransactionBoundary() {
        this.checkOpenOrWaitingForAutoClose();
        super.startTransactionBoundary();
    }

    @Override
    public void afterTransactionBegin() {
        this.checkOpenOrWaitingForAutoClose();
        this.getInterceptor().afterTransactionBegin(this.getTransactionIfAccessible());
    }

    @Override
    public void flushBeforeTransactionCompletion() {
        if (this.mustFlushBeforeCompletion()) {
            try {
                this.managedFlush();
            }
            catch (RuntimeException re) {
                throw ExceptionMapperStandardImpl.INSTANCE.mapManagedFlushFailure("error during managed flush", re, this);
            }
        }
    }

    private boolean mustFlushBeforeCompletion() {
        return this.isTransactionFlushable() && this.getHibernateFlushMode() != FlushMode.MANUAL;
    }

    private boolean isTransactionFlushable() {
        if (this.getCurrentTransaction() == null) {
            return true;
        }
        TransactionStatus status = this.getCurrentTransaction().getStatus();
        return status == TransactionStatus.ACTIVE || status == TransactionStatus.COMMITTING;
    }

    @Override
    public SessionImplementor getSession() {
        return this;
    }

    @Override
    public void remove(Object entity) {
        this.checkOpen();
        try {
            this.delete(entity);
        }
        catch (MappingException e) {
            throw this.getExceptionConverter().convert(new IllegalArgumentException(e.getMessage(), (Throwable)((Object)e)));
        }
        catch (RuntimeException e) {
            throw this.getExceptionConverter().convert(e);
        }
    }

    public <T> T find(Class<T> entityClass, Object primaryKey) {
        return this.find(entityClass, primaryKey, null, null);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, Map<String, Object> properties) {
        return this.find(entityClass, primaryKey, null, properties);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockModeType) {
        return this.find(entityClass, primaryKey, lockModeType, null);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockModeType, Map<String, Object> properties) {
        this.checkOpen();
        LockOptions lockOptions = null;
        try {
            if (lockModeType != null) {
                this.checkTransactionNeededForLock(lockModeType);
                lockOptions = this.buildLockOptions(lockModeType, properties);
            }
            EffectiveEntityGraph effectiveEntityGraph = this.loadQueryInfluencers.getEffectiveEntityGraph();
            effectiveEntityGraph.applyConfiguredGraph(properties);
            this.loadQueryInfluencers.setReadOnly(SessionImpl.getReadOnlyHint(properties));
            if (effectiveEntityGraph.getSemantic() == GraphSemantic.FETCH) {
                this.setEnforcingFetchGraph(true);
            }
            Object t = ((IdentifierLoadAccessImpl)this.byId((Class)entityClass)).with(this.determineAppropriateLocalCacheMode(properties)).with(lockOptions).load(primaryKey);
            return t;
        }
        catch (EntityNotFoundException enfe) {
            if (enfe instanceof FetchNotFoundException) {
                throw enfe;
            }
            if (log.isDebugEnabled()) {
                String entityName = entityClass != null ? entityClass.getName() : null;
                String identifierValue = primaryKey != null ? primaryKey.toString() : null;
                log.ignoringEntityNotFound(entityName, identifierValue);
            }
            T t = null;
            return t;
        }
        catch (ObjectDeletedException e) {
            T t = null;
            return t;
        }
        catch (ObjectNotFoundException e) {
            throw new IllegalArgumentException(e.getMessage(), (Throwable)((Object)e));
        }
        catch (ClassCastException | MappingException | TypeMismatchException e) {
            throw this.getExceptionConverter().convert(new IllegalArgumentException(((Throwable)e).getMessage(), (Throwable)e));
        }
        catch (JDBCException e) {
            if (this.accessTransaction().isActive() && this.accessTransaction().getRollbackOnly()) {
                if (log.isDebugEnabled()) {
                    log.debug("JDBCException was thrown for a transaction marked for rollback; this is probably due to an operation failing fast due to the transaction marked for rollback.", (Throwable)((Object)e));
                }
                T t = null;
                return t;
            }
            throw this.getExceptionConverter().convert(e, lockOptions);
        }
        catch (RuntimeException e) {
            throw this.getExceptionConverter().convert(e, lockOptions);
        }
        finally {
            this.loadQueryInfluencers.getEffectiveEntityGraph().clear();
            this.loadQueryInfluencers.setReadOnly(null);
            this.setEnforcingFetchGraph(false);
        }
    }

    private void checkTransactionNeededForLock(LockModeType lockModeType) {
        if (lockModeType != LockModeType.NONE) {
            this.checkTransactionNeededForUpdateOperation();
        }
    }

    private static Boolean getReadOnlyHint(Map<String, Object> properties) {
        return properties == null ? null : (Boolean)properties.get("org.hibernate.readOnly");
    }

    protected CacheMode determineAppropriateLocalCacheMode(Map<String, Object> localProperties) {
        CacheRetrieveMode retrieveMode = null;
        CacheStoreMode storeMode = null;
        if (localProperties != null) {
            retrieveMode = SessionImpl.determineCacheRetrieveMode(localProperties);
            storeMode = SessionImpl.determineCacheStoreMode(localProperties);
        }
        if (retrieveMode == null) {
            retrieveMode = this.fastSessionServices.getCacheRetrieveMode(this.properties);
        }
        if (storeMode == null) {
            storeMode = this.fastSessionServices.getCacheStoreMode(this.properties);
        }
        return CacheModeHelper.interpretCacheMode(storeMode, retrieveMode);
    }

    private static CacheRetrieveMode determineCacheRetrieveMode(Map<String, Object> settings) {
        CacheRetrieveMode cacheRetrieveMode = (CacheRetrieveMode)settings.get("javax.persistence.cache.retrieveMode");
        return cacheRetrieveMode == null ? (CacheRetrieveMode)settings.get("jakarta.persistence.cache.retrieveMode") : cacheRetrieveMode;
    }

    private static CacheStoreMode determineCacheStoreMode(Map<String, Object> settings) {
        CacheStoreMode cacheStoreMode = (CacheStoreMode)settings.get("javax.persistence.cache.storeMode");
        return cacheStoreMode == null ? (CacheStoreMode)settings.get("jakarta.persistence.cache.storeMode") : cacheStoreMode;
    }

    private void checkTransactionNeededForUpdateOperation() {
        this.checkTransactionNeededForUpdateOperation("no transaction is in progress");
    }

    @Override
    public <T> T getReference(Class<T> entityClass, Object id) {
        this.checkOpen();
        try {
            return ((IdentifierLoadAccessImpl)this.byId((Class)entityClass)).getReference(id);
        }
        catch (ClassCastException | MappingException | TypeMismatchException e) {
            throw this.getExceptionConverter().convert(new IllegalArgumentException(((Throwable)e).getMessage(), (Throwable)e));
        }
        catch (RuntimeException e) {
            throw this.getExceptionConverter().convert(e);
        }
    }

    @Override
    public Object getReference(String entityName, Object id) {
        this.checkOpen();
        try {
            return ((IdentifierLoadAccessImpl)this.byId(entityName)).getReference(id);
        }
        catch (ClassCastException | MappingException | TypeMismatchException e) {
            throw this.getExceptionConverter().convert(new IllegalArgumentException(((Throwable)e).getMessage(), (Throwable)e));
        }
        catch (RuntimeException e) {
            throw this.getExceptionConverter().convert(e);
        }
    }

    public void lock(Object entity, LockModeType lockModeType) {
        this.lock(entity, lockModeType, null);
    }

    public void lock(Object entity, LockModeType lockModeType, Map<String, Object> properties) {
        this.checkOpen();
        this.checkTransactionNeededForUpdateOperation();
        if (!this.contains(entity)) {
            throw new IllegalArgumentException("entity not in the persistence context");
        }
        LockOptions lockOptions = this.buildLockOptions(lockModeType, properties);
        try {
            this.buildLockRequest(lockOptions).lock(entity);
        }
        catch (RuntimeException e) {
            throw this.getExceptionConverter().convert(e, lockOptions);
        }
    }

    public void refresh(Object entity, Map<String, Object> properties) {
        this.refresh(entity, null, properties);
    }

    public void refresh(Object entity, LockModeType lockModeType) {
        this.refresh(entity, lockModeType, null);
    }

    public void refresh(Object entity, LockModeType lockModeType, Map<String, Object> properties) {
        this.checkOpen();
        CacheMode previousCacheMode = this.getCacheMode();
        CacheMode refreshCacheMode = this.determineAppropriateLocalCacheMode(properties);
        LockOptions lockOptions = null;
        try {
            this.setCacheMode(refreshCacheMode);
            if (!this.contains(entity)) {
                throw this.getExceptionConverter().convert(new IllegalArgumentException("Entity not managed"));
            }
            if (lockModeType != null) {
                this.checkTransactionNeededForLock(lockModeType);
                lockOptions = this.buildLockOptions(lockModeType, properties);
                this.refresh(entity, lockOptions);
            } else {
                this.refresh(entity);
            }
        }
        catch (MappingException e) {
            throw this.getExceptionConverter().convert(new IllegalArgumentException(e.getMessage(), (Throwable)((Object)e)));
        }
        catch (RuntimeException e) {
            throw this.getExceptionConverter().convert(e, lockOptions);
        }
        finally {
            this.setCacheMode(previousCacheMode);
        }
    }

    private LockOptions buildLockOptions(LockModeType lockModeType, Map<String, Object> properties) {
        LockOptions lockOptions = new LockOptions();
        if (this.lockOptions != null) {
            LockOptions.copy(this.lockOptions, lockOptions);
        }
        lockOptions.setLockMode(LockModeTypeHelper.getLockMode(lockModeType));
        if (properties != null) {
            LockOptionsHelper.applyPropertiesToLockOptions(properties, () -> lockOptions);
        }
        return lockOptions;
    }

    @Override
    public void detach(Object entity) {
        this.checkOpen();
        try {
            this.evict(entity);
        }
        catch (RuntimeException e) {
            throw this.getExceptionConverter().convert(e);
        }
    }

    public LockModeType getLockMode(Object entity) {
        this.checkOpen();
        if (!this.isTransactionInProgress()) {
            throw new TransactionRequiredException("Call to EntityManager#getLockMode should occur within transaction according to spec");
        }
        if (!this.contains(entity)) {
            throw this.getExceptionConverter().convert(new IllegalArgumentException("entity not in the persistence context"));
        }
        return LockModeTypeHelper.getLockModeType(this.getCurrentLockMode(entity));
    }

    public void setProperty(String propertyName, Object value) {
        this.checkOpen();
        if (!(value instanceof Serializable)) {
            log.warnf("Property '%s' is not serializable, value won't be set", propertyName);
            return;
        }
        if (propertyName == null) {
            log.warn("Property having key null is illegal, value won't be set");
            return;
        }
        if (this.properties == null) {
            this.properties = this.computeCurrentSessionProperties();
        }
        this.properties.put(propertyName, value);
        this.interpretProperty(propertyName, value);
    }

    private void interpretProperty(String propertyName, Object value) {
        switch (propertyName) {
            case "org.hibernate.flushMode": {
                this.setHibernateFlushMode(ConfigurationHelper.getFlushMode(value, FlushMode.AUTO));
                break;
            }
            case "javax.persistence.lock.scope": 
            case "jakarta.persistence.lock.scope": {
                this.properties.put("javax.persistence.lock.scope", value);
                this.properties.put("jakarta.persistence.lock.scope", value);
                LockOptionsHelper.applyPropertiesToLockOptions(this.properties, this::getLockOptionsForWrite);
                break;
            }
            case "javax.persistence.lock.timeout": 
            case "jakarta.persistence.lock.timeout": {
                this.properties.put("javax.persistence.lock.timeout", value);
                this.properties.put("jakarta.persistence.lock.timeout", value);
                LockOptionsHelper.applyPropertiesToLockOptions(this.properties, this::getLockOptionsForWrite);
                break;
            }
            case "javax.persistence.cache.retrieveMode": 
            case "jakarta.persistence.cache.retrieveMode": {
                this.properties.put("javax.persistence.cache.retrieveMode", value);
                this.properties.put("jakarta.persistence.cache.retrieveMode", value);
                this.setCacheMode(CacheModeHelper.interpretCacheMode(SessionImpl.determineCacheStoreMode(this.properties), (CacheRetrieveMode)value));
                break;
            }
            case "javax.persistence.cache.storeMode": 
            case "jakarta.persistence.cache.storeMode": {
                this.properties.put("javax.persistence.cache.storeMode", value);
                this.properties.put("jakarta.persistence.cache.storeMode", value);
                this.setCacheMode(CacheModeHelper.interpretCacheMode((CacheStoreMode)value, SessionImpl.determineCacheRetrieveMode(this.properties)));
                break;
            }
            case "hibernate.criteria.copy_tree": {
                this.setCriteriaCopyTreeEnabled(Boolean.parseBoolean(value.toString()));
                break;
            }
            case "org.hibernate.fetchProfile": {
                this.enableFetchProfile((String)value);
                break;
            }
            case "hibernate.use_subselect_fetch": 
            case "org.hibernate.enableSubselectFetch": {
                this.setSubselectFetchingEnabled(Boolean.parseBoolean(value.toString()));
                break;
            }
            case "hibernate.default_batch_fetch_size": 
            case "org.hibernate.batchFetchSize": {
                this.setFetchBatchSize(Integer.parseInt(value.toString()));
                break;
            }
            case "hibernate.jdbc.batch_size": 
            case "org.hibernate.jdbcBatchSize": {
                this.setJdbcBatchSize(Integer.parseInt(value.toString()));
            }
        }
    }

    private Map<String, Object> computeCurrentSessionProperties() {
        HashMap<String, Object> map = new HashMap<String, Object>(this.fastSessionServices.defaultSessionProperties);
        map.put("org.hibernate.flushMode", this.getHibernateFlushMode().name());
        return map;
    }

    public Map<String, Object> getProperties() {
        if (this.properties == null) {
            this.properties = this.computeCurrentSessionProperties();
        }
        return Collections.unmodifiableMap(this.properties);
    }

    @Override
    public ProcedureCall createNamedStoredProcedureQuery(String name) {
        this.checkOpen();
        try {
            NamedCallableQueryMemento memento = this.getFactory().getQueryEngine().getNamedObjectRepository().getCallableQueryMemento(name);
            if (memento == null) {
                throw new IllegalArgumentException("No @NamedStoredProcedureQuery was found with that name : " + name);
            }
            return memento.makeProcedureCall(this);
        }
        catch (RuntimeException e) {
            throw this.getExceptionConverter().convert(e);
        }
    }

    @Override
    public ProcedureCall createStoredProcedureQuery(String procedureName) {
        try {
            return this.createStoredProcedureCall(procedureName);
        }
        catch (RuntimeException e) {
            throw this.getExceptionConverter().convert(e);
        }
    }

    public ProcedureCall createStoredProcedureQuery(String procedureName, Class ... resultClasses) {
        try {
            return this.createStoredProcedureCall(procedureName, resultClasses);
        }
        catch (RuntimeException e) {
            throw this.getExceptionConverter().convert(e);
        }
    }

    @Override
    public ProcedureCall createStoredProcedureQuery(String procedureName, String ... resultSetMappings) {
        this.checkOpen();
        try {
            try {
                return this.createStoredProcedureCall(procedureName, resultSetMappings);
            }
            catch (UnknownSqlResultSetMappingException e) {
                throw new IllegalArgumentException(e.getMessage(), (Throwable)((Object)e));
            }
        }
        catch (RuntimeException e) {
            throw this.getExceptionConverter().convert(e);
        }
    }

    public <T> T unwrap(Class<T> clazz) {
        this.checkOpen();
        if (Session.class.isAssignableFrom(clazz)) {
            return (T)this;
        }
        if (SessionImplementor.class.isAssignableFrom(clazz)) {
            return (T)this;
        }
        if (SharedSessionContractImplementor.class.isAssignableFrom(clazz)) {
            return (T)this;
        }
        if (EntityManager.class.isAssignableFrom(clazz)) {
            return (T)this;
        }
        if (PersistenceContext.class.isAssignableFrom(clazz)) {
            return (T)this;
        }
        throw new PersistenceException("Hibernate cannot unwrap " + clazz);
    }

    public Object getDelegate() {
        this.checkOpen();
        return this;
    }

    public SessionFactoryImplementor getEntityManagerFactory() {
        this.checkOpen();
        return this.getFactory();
    }

    public Metamodel getMetamodel() {
        this.checkOpen();
        return this.getFactory().getJpaMetamodel();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        if (log.isTraceEnabled()) {
            log.tracef("Serializing Session [%s]", this.getSessionIdentifier());
        }
        oos.defaultWriteObject();
        this.persistenceContext.serialize(oos);
        this.actionQueue.serialize(oos);
        oos.writeObject(this.loadQueryInfluencers);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException, SQLException {
        if (log.isTraceEnabled()) {
            log.tracef("Deserializing Session [%s]", this.getSessionIdentifier());
        }
        ois.defaultReadObject();
        this.persistenceContext = StatefulPersistenceContext.deserialize(ois, this);
        this.actionQueue = ActionQueue.deserialize(ois, this);
        this.loadQueryInfluencers = (LoadQueryInfluencers)ois.readObject();
        for (String filterName : this.loadQueryInfluencers.getEnabledFilterNames()) {
            ((FilterImpl)this.loadQueryInfluencers.getEnabledFilter(filterName)).afterDeserialize(this.getFactory());
        }
    }

    private Boolean getReadOnlyFromLoadQueryInfluencers() {
        return this.loadQueryInfluencers != null ? this.loadQueryInfluencers.getReadOnly() : null;
    }

    @Override
    @Deprecated(forRemoval=true)
    public boolean isEnforcingFetchGraph() {
        return this.isEnforcingFetchGraph;
    }

    @Override
    @Deprecated(forRemoval=true)
    public void setEnforcingFetchGraph(boolean isEnforcingFetchGraph) {
        this.isEnforcingFetchGraph = isEnforcingFetchGraph;
    }

    @Deprecated
    private class LockRequestImpl
    implements Session.LockRequest {
        private final LockOptions lockOptions = new LockOptions();

        private LockRequestImpl(LockOptions lockOptions) {
            LockOptions.copy(lockOptions, this.lockOptions);
        }

        @Override
        public LockMode getLockMode() {
            return this.lockOptions.getLockMode();
        }

        @Override
        public Session.LockRequest setLockMode(LockMode lockMode) {
            this.lockOptions.setLockMode(lockMode);
            return this;
        }

        @Override
        public int getTimeOut() {
            return this.lockOptions.getTimeOut();
        }

        @Override
        public Session.LockRequest setTimeOut(int timeout) {
            this.lockOptions.setTimeOut(timeout);
            return this;
        }

        @Override
        @Deprecated
        public boolean getScope() {
            return this.lockOptions.getScope();
        }

        @Override
        @Deprecated
        public Session.LockRequest setScope(boolean scope) {
            this.lockOptions.setScope(scope);
            return this;
        }

        @Override
        @Deprecated
        public void lock(String entityName, Object object) throws HibernateException {
            SessionImpl.this.fireLock(entityName, object, this.lockOptions);
        }

        @Override
        public void lock(Object object) throws HibernateException {
            SessionImpl.this.fireLock(object, this.lockOptions);
        }
    }

    private static class SharedSessionBuilderImpl
    extends SessionFactoryImpl.SessionBuilderImpl
    implements SharedSessionBuilder,
    SharedSessionCreationOptions {
        private final SessionImpl session;
        private boolean shareTransactionContext;

        private SharedSessionBuilderImpl(SessionImpl session) {
            super((SessionFactoryImpl)session.getFactory());
            this.session = session;
            super.tenantIdentifier(session.getTenantIdentifier());
        }

        @Override
        public SharedSessionBuilderImpl tenantIdentifier(String tenantIdentifier) {
            throw new SessionException("Cannot redefine tenant identifier on child session");
        }

        @Override
        public SharedSessionBuilderImpl interceptor() {
            super.interceptor(this.session.getInterceptor());
            return this;
        }

        @Override
        public SharedSessionBuilderImpl interceptor(Interceptor interceptor) {
            super.interceptor(interceptor);
            return this;
        }

        @Override
        public SharedSessionBuilderImpl noInterceptor() {
            super.noInterceptor();
            return this;
        }

        @Override
        public SharedSessionBuilderImpl connection() {
            this.shareTransactionContext = true;
            return this;
        }

        @Override
        public SharedSessionBuilderImpl connection(Connection connection) {
            super.connection(connection);
            return this;
        }

        @Override
        @Deprecated(since="6.0")
        public SharedSessionBuilderImpl connectionReleaseMode() {
            PhysicalConnectionHandlingMode handlingMode = PhysicalConnectionHandlingMode.interpret(ConnectionAcquisitionMode.AS_NEEDED, this.session.getJdbcCoordinator().getLogicalConnection().getConnectionHandlingMode().getReleaseMode());
            this.connectionHandlingMode(handlingMode);
            return this;
        }

        @Override
        public SharedSessionBuilderImpl connectionHandlingMode() {
            this.connectionHandlingMode(this.session.getJdbcCoordinator().getLogicalConnection().getConnectionHandlingMode());
            return this;
        }

        @Override
        public SharedSessionBuilderImpl autoJoinTransactions() {
            super.autoJoinTransactions(this.session.isAutoCloseSessionEnabled());
            return this;
        }

        @Override
        public SharedSessionBuilderImpl autoJoinTransactions(boolean autoJoinTransactions) {
            super.autoJoinTransactions(autoJoinTransactions);
            return this;
        }

        @Override
        public SharedSessionBuilderImpl autoClose(boolean autoClose) {
            super.autoClose(autoClose);
            return this;
        }

        @Override
        public SharedSessionBuilderImpl flushMode() {
            this.flushMode(this.session.getHibernateFlushMode());
            return this;
        }

        @Override
        public SharedSessionBuilderImpl autoClose() {
            this.autoClose(this.session.autoClose);
            return this;
        }

        @Override
        public boolean isTransactionCoordinatorShared() {
            return this.shareTransactionContext;
        }

        @Override
        public TransactionCoordinator getTransactionCoordinator() {
            return this.shareTransactionContext ? this.session.getTransactionCoordinator() : null;
        }

        @Override
        public JdbcCoordinator getJdbcCoordinator() {
            return this.shareTransactionContext ? this.session.getJdbcCoordinator() : null;
        }

        @Override
        public TransactionImplementor getTransaction() {
            return this.shareTransactionContext ? this.session.getCurrentTransaction() : null;
        }

        @Override
        public ActionQueue.TransactionCompletionProcesses getTransactionCompletionProcesses() {
            return this.shareTransactionContext ? this.session.getActionQueue().getTransactionCompletionProcesses() : null;
        }
    }

    private static class LobHelperImpl
    implements LobHelper {
        private LobHelperImpl() {
        }

        @Override
        public Blob createBlob(byte[] bytes) {
            return this.lobCreator().createBlob(bytes);
        }

        private LobCreator lobCreator() {
            return NonContextualLobCreator.INSTANCE;
        }

        @Override
        public Blob createBlob(InputStream stream, long length) {
            return this.lobCreator().createBlob(stream, length);
        }

        @Override
        public Clob createClob(String string) {
            return this.lobCreator().createClob(string);
        }

        @Override
        public Clob createClob(Reader reader, long length) {
            return this.lobCreator().createClob(reader, length);
        }

        @Override
        public NClob createNClob(String string) {
            return this.lobCreator().createNClob(string);
        }

        @Override
        public NClob createNClob(Reader reader, long length) {
            return this.lobCreator().createNClob(reader, length);
        }
    }
}

