/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.hql.internal;

import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.metamodel.Bindable;
import jakarta.persistence.metamodel.SingularAttribute;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.grammars.hql.HqlParser;
import org.hibernate.grammars.hql.HqlParserBaseVisitor;
import org.hibernate.internal.util.CharSequenceHelper;
import org.hibernate.internal.util.QuotingHelper;
import org.hibernate.internal.util.collections.Stack;
import org.hibernate.internal.util.collections.StandardStack;
import org.hibernate.metamodel.CollectionClassification;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.model.domain.BasicDomainType;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.IdentifiableDomainType;
import org.hibernate.metamodel.model.domain.ManagedDomainType;
import org.hibernate.metamodel.model.domain.PluralPersistentAttribute;
import org.hibernate.metamodel.model.domain.SingularPersistentAttribute;
import org.hibernate.metamodel.model.domain.internal.AnyDiscriminatorSqmPath;
import org.hibernate.metamodel.model.domain.internal.AnyDiscriminatorSqmPathSource;
import org.hibernate.metamodel.model.domain.internal.EntitySqmPathSource;
import org.hibernate.metamodel.model.domain.spi.JpaMetamodelImplementor;
import org.hibernate.query.NullPrecedence;
import org.hibernate.query.ParameterLabelException;
import org.hibernate.query.PathException;
import org.hibernate.query.ReturnableType;
import org.hibernate.query.SemanticException;
import org.hibernate.query.SortDirection;
import org.hibernate.query.SyntaxException;
import org.hibernate.query.criteria.JpaCteCriteria;
import org.hibernate.query.criteria.JpaCteCriteriaAttribute;
import org.hibernate.query.criteria.JpaCteCriteriaType;
import org.hibernate.query.criteria.JpaFrom;
import org.hibernate.query.criteria.JpaJoin;
import org.hibernate.query.criteria.JpaPath;
import org.hibernate.query.criteria.JpaQueryPart;
import org.hibernate.query.criteria.JpaQueryStructure;
import org.hibernate.query.criteria.JpaSearchOrder;
import org.hibernate.query.hql.HqlLogging;
import org.hibernate.query.hql.internal.BasicDotIdentifierConsumer;
import org.hibernate.query.hql.internal.DomainPathPart;
import org.hibernate.query.hql.internal.QualifiedJoinPathConsumer;
import org.hibernate.query.hql.internal.QualifiedJoinPredicatePathConsumer;
import org.hibernate.query.hql.internal.SqmTreeCreationHelper;
import org.hibernate.query.hql.spi.DotIdentifierConsumer;
import org.hibernate.query.hql.spi.SemanticPathPart;
import org.hibernate.query.hql.spi.SqmCreationOptions;
import org.hibernate.query.hql.spi.SqmCreationProcessingState;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.hql.spi.SqmPathRegistry;
import org.hibernate.query.sqm.BinaryArithmeticOperator;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.query.sqm.FetchClauseType;
import org.hibernate.query.sqm.FrameExclusion;
import org.hibernate.query.sqm.FrameKind;
import org.hibernate.query.sqm.FrameMode;
import org.hibernate.query.sqm.LiteralNumberFormatException;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.ParsingException;
import org.hibernate.query.sqm.SetOperator;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.SqmQuerySource;
import org.hibernate.query.sqm.SqmTreeCreationLogger;
import org.hibernate.query.sqm.StrictJpaComplianceViolation;
import org.hibernate.query.sqm.TemporalUnit;
import org.hibernate.query.sqm.TerminalPathException;
import org.hibernate.query.sqm.TrimSpec;
import org.hibernate.query.sqm.UnaryArithmeticOperator;
import org.hibernate.query.sqm.UnknownEntityException;
import org.hibernate.query.sqm.function.FunctionKind;
import org.hibernate.query.sqm.function.NamedSqmFunctionDescriptor;
import org.hibernate.query.sqm.function.SelfRenderingSqmFunction;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.internal.ParameterCollector;
import org.hibernate.query.sqm.internal.SqmCreationProcessingStateImpl;
import org.hibernate.query.sqm.internal.SqmDmlCreationProcessingState;
import org.hibernate.query.sqm.internal.SqmQueryPartCreationProcessingStateStandardImpl;
import org.hibernate.query.sqm.internal.TypecheckUtil;
import org.hibernate.query.sqm.produce.function.FunctionArgumentException;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.query.sqm.spi.ParameterDeclarationContext;
import org.hibernate.query.sqm.spi.SqmCreationContext;
import org.hibernate.query.sqm.tree.SqmJoinType;
import org.hibernate.query.sqm.tree.SqmQuery;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.cte.SqmCteContainer;
import org.hibernate.query.sqm.tree.cte.SqmCteStatement;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.domain.AbstractSqmFrom;
import org.hibernate.query.sqm.tree.domain.SqmAnyValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmCorrelation;
import org.hibernate.query.sqm.tree.domain.SqmCteRoot;
import org.hibernate.query.sqm.tree.domain.SqmDerivedRoot;
import org.hibernate.query.sqm.tree.domain.SqmElementAggregateFunction;
import org.hibernate.query.sqm.tree.domain.SqmEntityValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmFkExpression;
import org.hibernate.query.sqm.tree.domain.SqmIndexAggregateFunction;
import org.hibernate.query.sqm.tree.domain.SqmListJoin;
import org.hibernate.query.sqm.tree.domain.SqmMapEntryReference;
import org.hibernate.query.sqm.tree.domain.SqmMapJoin;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmPluralValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmPolymorphicRootDescriptor;
import org.hibernate.query.sqm.tree.expression.AbstractSqmParameter;
import org.hibernate.query.sqm.tree.expression.SqmAliasedNodeRef;
import org.hibernate.query.sqm.tree.expression.SqmAny;
import org.hibernate.query.sqm.tree.expression.SqmAnyDiscriminatorValue;
import org.hibernate.query.sqm.tree.expression.SqmBinaryArithmetic;
import org.hibernate.query.sqm.tree.expression.SqmByUnit;
import org.hibernate.query.sqm.tree.expression.SqmCaseSearched;
import org.hibernate.query.sqm.tree.expression.SqmCaseSimple;
import org.hibernate.query.sqm.tree.expression.SqmCastTarget;
import org.hibernate.query.sqm.tree.expression.SqmCollation;
import org.hibernate.query.sqm.tree.expression.SqmCollectionSize;
import org.hibernate.query.sqm.tree.expression.SqmDistinct;
import org.hibernate.query.sqm.tree.expression.SqmDurationUnit;
import org.hibernate.query.sqm.tree.expression.SqmEvery;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmExtractUnit;
import org.hibernate.query.sqm.tree.expression.SqmFormat;
import org.hibernate.query.sqm.tree.expression.SqmFunction;
import org.hibernate.query.sqm.tree.expression.SqmHqlNumericLiteral;
import org.hibernate.query.sqm.tree.expression.SqmLiteral;
import org.hibernate.query.sqm.tree.expression.SqmLiteralEntityType;
import org.hibernate.query.sqm.tree.expression.SqmLiteralNull;
import org.hibernate.query.sqm.tree.expression.SqmNamedParameter;
import org.hibernate.query.sqm.tree.expression.SqmOver;
import org.hibernate.query.sqm.tree.expression.SqmOverflow;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.expression.SqmParameterizedEntityType;
import org.hibernate.query.sqm.tree.expression.SqmPositionalParameter;
import org.hibernate.query.sqm.tree.expression.SqmStar;
import org.hibernate.query.sqm.tree.expression.SqmSummarization;
import org.hibernate.query.sqm.tree.expression.SqmToDuration;
import org.hibernate.query.sqm.tree.expression.SqmTrimSpecification;
import org.hibernate.query.sqm.tree.expression.SqmTuple;
import org.hibernate.query.sqm.tree.expression.SqmUnaryOperation;
import org.hibernate.query.sqm.tree.from.SqmAttributeJoin;
import org.hibernate.query.sqm.tree.from.SqmCrossJoin;
import org.hibernate.query.sqm.tree.from.SqmCteJoin;
import org.hibernate.query.sqm.tree.from.SqmDerivedJoin;
import org.hibernate.query.sqm.tree.from.SqmEntityJoin;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.query.sqm.tree.from.SqmFromClause;
import org.hibernate.query.sqm.tree.from.SqmJoin;
import org.hibernate.query.sqm.tree.from.SqmQualifiedJoin;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.insert.SqmInsertSelectStatement;
import org.hibernate.query.sqm.tree.insert.SqmInsertStatement;
import org.hibernate.query.sqm.tree.insert.SqmInsertValuesStatement;
import org.hibernate.query.sqm.tree.insert.SqmValues;
import org.hibernate.query.sqm.tree.predicate.SqmBetweenPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmBooleanExpressionPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmComparisonPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmEmptinessPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmExistsPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmGroupedPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmInListPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmInSubQueryPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmJunctionPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmLikePredicate;
import org.hibernate.query.sqm.tree.predicate.SqmMemberOfPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmNegatablePredicate;
import org.hibernate.query.sqm.tree.predicate.SqmNegatedPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmNullnessPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmTruthnessPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmWhereClause;
import org.hibernate.query.sqm.tree.select.AbstractSqmSelectQuery;
import org.hibernate.query.sqm.tree.select.SqmAliasedNode;
import org.hibernate.query.sqm.tree.select.SqmDynamicInstantiation;
import org.hibernate.query.sqm.tree.select.SqmDynamicInstantiationArgument;
import org.hibernate.query.sqm.tree.select.SqmOrderByClause;
import org.hibernate.query.sqm.tree.select.SqmQueryGroup;
import org.hibernate.query.sqm.tree.select.SqmQueryPart;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectClause;
import org.hibernate.query.sqm.tree.select.SqmSelectQuery;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.query.sqm.tree.select.SqmSelectableNode;
import org.hibernate.query.sqm.tree.select.SqmSelection;
import org.hibernate.query.sqm.tree.select.SqmSortSpecification;
import org.hibernate.query.sqm.tree.select.SqmSubQuery;
import org.hibernate.query.sqm.tree.update.SqmUpdateStatement;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.tree.cte.CteMaterialization;
import org.hibernate.sql.ast.tree.cte.CteSearchClauseKind;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.DateTimeUtils;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.PrimitiveByteArrayJavaType;
import org.hibernate.type.descriptor.java.spi.JavaTypeRegistry;
import org.hibernate.type.descriptor.java.spi.UnknownBasicJavaType;
import org.hibernate.type.descriptor.jdbc.ObjectJdbcType;
import org.hibernate.type.internal.BasicTypeImpl;
import org.hibernate.type.spi.TypeConfiguration;
import org.jboss.logging.Logger;

public class SemanticQueryBuilder<R>
extends HqlParserBaseVisitor<Object>
implements SqmCreationState {
    private static final Logger log = Logger.getLogger(SemanticQueryBuilder.class);
    private static final Set<String> JPA_STANDARD_FUNCTIONS;
    private final Class<R> expectedResultType;
    private final String expectedResultEntity;
    private final SqmCreationOptions creationOptions;
    private final SqmCreationContext creationContext;
    private final Stack<DotIdentifierConsumer> dotIdentifierConsumerStack;
    private final Stack<ParameterDeclarationContext> parameterDeclarationContextStack = new StandardStack<ParameterDeclarationContext>(ParameterDeclarationContext.class);
    private final Stack<SqmCreationProcessingState> processingStateStack = new StandardStack<SqmCreationProcessingState>(SqmCreationProcessingState.class);
    private final BasicDomainType<Integer> integerDomainType;
    private final JavaType<List<?>> listJavaType;
    private final JavaType<Map<?, ?>> mapJavaType;
    private ParameterCollector parameterCollector;
    private ParameterStyle parameterStyle;
    private Map<Object, AbstractSqmParameter<?>> parameters;
    private boolean isExtractingJdbcTemporalType;
    private JpaCteCriteria<?> currentPotentialRecursiveCte;

    public static <R> SqmStatement<R> buildSemanticModel(HqlParser.StatementContext hqlParseTree, Class<R> expectedResultType, SqmCreationOptions creationOptions, SqmCreationContext creationContext) {
        return new SemanticQueryBuilder<R>(expectedResultType, creationOptions, creationContext).visitStatement(hqlParseTree);
    }

    public SemanticQueryBuilder(Class<R> expectedResultType, SqmCreationOptions creationOptions, SqmCreationContext creationContext) {
        this(expectedResultType, null, creationOptions, creationContext);
    }

    public SemanticQueryBuilder(String expectedResultEntity, SqmCreationOptions creationOptions, SqmCreationContext creationContext) {
        this(null, expectedResultEntity, creationOptions, creationContext);
    }

    private SemanticQueryBuilder(Class<R> expectedResultType, String expectedResultEntity, SqmCreationOptions creationOptions, SqmCreationContext creationContext) {
        this.expectedResultType = expectedResultType;
        this.expectedResultEntity = expectedResultEntity;
        this.creationOptions = creationOptions;
        this.creationContext = creationContext;
        this.dotIdentifierConsumerStack = new StandardStack<BasicDotIdentifierConsumer>(DotIdentifierConsumer.class, new BasicDotIdentifierConsumer(this));
        this.parameterStyle = creationOptions.useStrictJpaCompliance() ? ParameterStyle.UNKNOWN : ParameterStyle.MIXED;
        TypeConfiguration typeConfiguration = creationContext.getNodeBuilder().getTypeConfiguration();
        JavaTypeRegistry javaTypeRegistry = typeConfiguration.getJavaTypeRegistry();
        this.integerDomainType = typeConfiguration.standardBasicTypeForJavaType(Integer.class);
        this.listJavaType = javaTypeRegistry.resolveDescriptor((Type)((Object)List.class));
        this.mapJavaType = javaTypeRegistry.resolveDescriptor((Type)((Object)Map.class));
    }

    @Override
    public SqmCreationContext getCreationContext() {
        return this.creationContext;
    }

    @Override
    public SqmCreationOptions getCreationOptions() {
        return this.creationOptions;
    }

    @Override
    public Stack<SqmCreationProcessingState> getProcessingStateStack() {
        return this.processingStateStack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqmStatement<R> visitStatement(HqlParser.StatementContext ctx) {
        this.parameterDeclarationContextStack.push(() -> false);
        try {
            ParseTree parseTree = ctx.getChild(0);
            if (parseTree instanceof HqlParser.SelectStatementContext) {
                Object selectStatement = this.visitSelectStatement((HqlParser.SelectStatementContext)parseTree);
                ((SqmQueryPart)((AbstractSqmSelectQuery)selectStatement).getQueryPart()).validateQueryStructureAndFetchOwners();
                Object object = selectStatement;
                return object;
            }
            if (parseTree instanceof HqlParser.InsertStatementContext) {
                Object object = this.visitInsertStatement((HqlParser.InsertStatementContext)parseTree);
                return object;
            }
            if (parseTree instanceof HqlParser.UpdateStatementContext) {
                Object object = this.visitUpdateStatement((HqlParser.UpdateStatementContext)parseTree);
                return object;
            }
            if (parseTree instanceof HqlParser.DeleteStatementContext) {
                Object object = this.visitDeleteStatement((HqlParser.DeleteStatementContext)parseTree);
                return object;
            }
        }
        finally {
            this.parameterDeclarationContextStack.pop();
        }
        throw new ParsingException("Unexpected statement type [not INSERT, UPDATE, DELETE or SELECT] : " + ctx.getText());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqmSelectStatement<R> visitSelectStatement(HqlParser.SelectStatementContext ctx) {
        SqmSelectStatement selectStatement;
        HqlParser.QueryExpressionContext queryExpressionContext = ctx.queryExpression();
        this.parameterCollector = selectStatement = new SqmSelectStatement(this.creationContext.getNodeBuilder());
        this.processingStateStack.push(new SqmQueryPartCreationProcessingStateStandardImpl(this.processingStateStack.getCurrent(), selectStatement, this));
        try {
            queryExpressionContext.accept(this);
        }
        finally {
            this.processingStateStack.pop();
        }
        return selectStatement;
    }

    @Override
    public SqmRoot<R> visitTargetEntity(HqlParser.TargetEntityContext dmlTargetContext) {
        return new SqmRoot(this.visitEntityName(dmlTargetContext.entityName()), this.extractAlias(dmlTargetContext.variable()), false, this.creationContext.getNodeBuilder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqmInsertStatement<R> visitInsertStatement(HqlParser.InsertStatementContext ctx) {
        SqmInsertValuesStatement insertStatement;
        HqlParser.TargetEntityContext dmlTargetContext = ctx.targetEntity();
        HqlParser.TargetFieldsContext targetFieldsSpecContext = ctx.targetFields();
        Object root = this.visitTargetEntity(dmlTargetContext);
        if (((SqmRoot)root).getModel() instanceof SqmPolymorphicRootDescriptor) {
            throw new SemanticException(String.format("Target type '%s' in 'insert' statement is not an entity", ((SqmRoot)root).getModel().getHibernateEntityName()));
        }
        HqlParser.QueryExpressionContext queryExpressionContext = ctx.queryExpression();
        if (queryExpressionContext != null) {
            SqmInsertSelectStatement insertStatement2;
            this.parameterCollector = insertStatement2 = new SqmInsertSelectStatement(root, this.creationContext.getNodeBuilder());
            SqmDmlCreationProcessingState processingState = new SqmDmlCreationProcessingState(insertStatement2, this);
            this.processingStateStack.push(processingState);
            try {
                queryExpressionContext.accept(this);
                SqmCreationProcessingStateImpl stateFieldsProcessingState = new SqmCreationProcessingStateImpl(insertStatement2, this);
                stateFieldsProcessingState.getPathRegistry().register((SqmPath<?>)root);
                this.processingStateStack.push(stateFieldsProcessingState);
                try {
                    for (HqlParser.SimplePathContext stateFieldCtx : targetFieldsSpecContext.simplePath()) {
                        SqmPath stateField = (SqmPath)this.visitSimplePath(stateFieldCtx);
                        insertStatement2.addInsertTargetStateField(stateField);
                    }
                }
                finally {
                    this.processingStateStack.pop();
                }
                SqmInsertSelectStatement sqmInsertSelectStatement = insertStatement2;
                return sqmInsertSelectStatement;
            }
            finally {
                this.processingStateStack.pop();
            }
        }
        this.parameterCollector = insertStatement = new SqmInsertValuesStatement(root, this.creationContext.getNodeBuilder());
        SqmDmlCreationProcessingState processingState = new SqmDmlCreationProcessingState(insertStatement, this);
        this.processingStateStack.push(processingState);
        processingState.getPathRegistry().register((SqmPath<?>)root);
        try {
            HqlParser.ValuesListContext valuesListContext = ctx.valuesList();
            for (int i = 1; i < valuesListContext.getChildCount(); i += 2) {
                ParseTree values = valuesListContext.getChild(i);
                SqmValues sqmValues = new SqmValues();
                for (int j = 1; j < values.getChildCount(); j += 2) {
                    sqmValues.getExpressions().add((SqmExpression)values.getChild(j).accept((ParseTreeVisitor)this));
                }
                insertStatement.getValuesList().add(sqmValues);
            }
            for (HqlParser.SimplePathContext stateFieldCtx : targetFieldsSpecContext.simplePath()) {
                SqmPath stateField = (SqmPath)this.visitSimplePath(stateFieldCtx);
                insertStatement.addInsertTargetStateField(stateField);
            }
            SqmInsertValuesStatement sqmInsertValuesStatement = insertStatement;
            return sqmInsertValuesStatement;
        }
        finally {
            this.processingStateStack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqmUpdateStatement<R> visitUpdateStatement(HqlParser.UpdateStatementContext ctx) {
        SqmUpdateStatement updateStatement;
        boolean versioned = ctx.VERSIONED() != null;
        HqlParser.TargetEntityContext dmlTargetContext = ctx.targetEntity();
        Object root = this.visitTargetEntity(dmlTargetContext);
        if (((SqmRoot)root).getModel() instanceof SqmPolymorphicRootDescriptor) {
            throw new SemanticException(String.format("Target type '%s' in 'update' statement is not an entity", ((SqmRoot)root).getModel().getHibernateEntityName()));
        }
        this.parameterCollector = updateStatement = new SqmUpdateStatement(root, this.creationContext.getNodeBuilder());
        SqmDmlCreationProcessingState processingState = new SqmDmlCreationProcessingState(updateStatement, this);
        this.processingStateStack.push(processingState);
        processingState.getPathRegistry().register((SqmPath<?>)root);
        try {
            updateStatement.versioned(versioned);
            HqlParser.SetClauseContext setClauseCtx = ctx.setClause();
            for (ParseTree subCtx : setClauseCtx.children) {
                HqlParser.ExpressionContext expressionContext;
                Map<Class<?>, Enum<?>> possibleEnumValues;
                if (!(subCtx instanceof HqlParser.AssignmentContext)) continue;
                HqlParser.AssignmentContext assignmentContext = (HqlParser.AssignmentContext)subCtx;
                SqmPath<?> targetPath = this.consumeDomainPath(assignmentContext.simplePath());
                Class targetPathJavaType = targetPath.getJavaType();
                boolean isEnum = targetPathJavaType != null && targetPathJavaType.isEnum();
                ParseTree rightSide = assignmentContext.getChild(2);
                SqmExpression<?> value = isEnum && rightSide.getChild(0) instanceof HqlParser.ExpressionContext && (possibleEnumValues = this.getPossibleEnumValues(expressionContext = (HqlParser.ExpressionContext)rightSide.getChild(0))) != null ? this.resolveEnumShorthandLiteral(expressionContext, possibleEnumValues, targetPathJavaType) : (SqmExpression<?>)rightSide.accept((ParseTreeVisitor)this);
                updateStatement.applyAssignment(targetPath, value);
            }
            HqlParser.WhereClauseContext whereClauseContext = ctx.whereClause();
            if (whereClauseContext != null) {
                updateStatement.applyPredicate(this.visitWhereClause(whereClauseContext));
            }
            SqmUpdateStatement sqmUpdateStatement = updateStatement;
            return sqmUpdateStatement;
        }
        finally {
            this.processingStateStack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqmDeleteStatement<R> visitDeleteStatement(HqlParser.DeleteStatementContext ctx) {
        SqmDeleteStatement deleteStatement;
        HqlParser.TargetEntityContext dmlTargetContext = ctx.targetEntity();
        Object root = this.visitTargetEntity(dmlTargetContext);
        this.parameterCollector = deleteStatement = new SqmDeleteStatement(root, SqmQuerySource.HQL, this.creationContext.getNodeBuilder());
        SqmDmlCreationProcessingState sqmDeleteCreationState = new SqmDmlCreationProcessingState(deleteStatement, this);
        sqmDeleteCreationState.getPathRegistry().register((SqmPath<?>)root);
        this.processingStateStack.push(sqmDeleteCreationState);
        try {
            HqlParser.WhereClauseContext whereClauseContext = ctx.whereClause();
            if (whereClauseContext != null) {
                deleteStatement.applyPredicate(this.visitWhereClause(whereClauseContext));
            }
            SqmDeleteStatement sqmDeleteStatement = deleteStatement;
            return sqmDeleteStatement;
        }
        finally {
            this.processingStateStack.pop();
        }
    }

    @Override
    public Object visitWithClause(HqlParser.WithClauseContext ctx) {
        if (this.creationOptions.useStrictJpaCompliance()) {
            throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.CTES);
        }
        List children = ctx.children;
        for (int i = 1; i < children.size(); i += 2) {
            this.visitCte((HqlParser.CteContext)((Object)children.get(i)));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitCte(HqlParser.CteContext ctx) {
        int queryExpressionIndex;
        CteMaterialization materialization;
        SqmCteContainer cteContainer = (SqmCteContainer)((Object)this.processingStateStack.getCurrent().getProcessingQuery());
        String name = this.visitIdentifier((HqlParser.IdentifierContext)((Object)ctx.children.get(0)));
        TerminalNode thirdChild = (TerminalNode)ctx.getChild(2);
        switch (thirdChild.getSymbol().getType()) {
            case 147: {
                materialization = CteMaterialization.NOT_MATERIALIZED;
                queryExpressionIndex = 5;
                break;
            }
            case 131: {
                materialization = CteMaterialization.MATERIALIZED;
                queryExpressionIndex = 4;
                break;
            }
            default: {
                materialization = null;
                queryExpressionIndex = 3;
            }
        }
        HqlParser.QueryExpressionContext queryExpressionContext = (HqlParser.QueryExpressionContext)ctx.getChild(queryExpressionIndex);
        AbstractSqmSelectQuery cte = cteContainer instanceof SqmSubQuery ? new SqmSubQuery(this.processingStateStack.getCurrent().getProcessingQuery(), this.creationContext.getNodeBuilder()) : new SqmSelectStatement(this.creationContext.getNodeBuilder());
        this.processingStateStack.push(new SqmQueryPartCreationProcessingStateStandardImpl(this.processingStateStack.getCurrent(), cte, this));
        JpaCteCriteria<?> oldCte = this.currentPotentialRecursiveCte;
        try {
            HqlParser.SetQueryGroupContext setContext;
            this.currentPotentialRecursiveCte = null;
            if (queryExpressionContext instanceof HqlParser.SetQueryGroupContext && (setContext = (HqlParser.SetQueryGroupContext)queryExpressionContext).getChildCount() < 5) {
                SetOperator setOperator = (SetOperator)((Object)setContext.getChild(setContext.getChildCount() - 2).accept((ParseTreeVisitor)this));
                switch (setOperator) {
                    case UNION: 
                    case UNION_ALL: {
                        ParseTree potentialSearchClause;
                        ParseTree lastChild;
                        HqlParser.OrderedQueryContext recursiveQueryContext;
                        HqlParser.OrderedQueryContext nonRecursiveQueryContext;
                        if (setContext.getChildCount() == 4) {
                            nonRecursiveQueryContext = (HqlParser.OrderedQueryContext)setContext.getChild(1);
                            recursiveQueryContext = (HqlParser.OrderedQueryContext)setContext.getChild(3);
                        } else {
                            nonRecursiveQueryContext = (HqlParser.OrderedQueryContext)setContext.getChild(0);
                            recursiveQueryContext = (HqlParser.OrderedQueryContext)setContext.getChild(2);
                        }
                        nonRecursiveQueryContext.accept(this);
                        SqmSelectStatement recursivePart = new SqmSelectStatement(this.creationContext.getNodeBuilder());
                        this.processingStateStack.pop();
                        this.processingStateStack.push(new SqmQueryPartCreationProcessingStateStandardImpl(this.processingStateStack.getCurrent(), recursivePart, this));
                        JpaCteCriteria cteDefinition = setOperator == SetOperator.UNION ? cteContainer.withRecursiveUnionDistinct(name, cte, cteCriteria -> {
                            this.currentPotentialRecursiveCte = cteCriteria;
                            recursiveQueryContext.accept(this);
                            return recursivePart;
                        }) : cteContainer.withRecursiveUnionAll(name, cte, cteCriteria -> {
                            this.currentPotentialRecursiveCte = cteCriteria;
                            recursiveQueryContext.accept(this);
                            return recursivePart;
                        });
                        if (materialization != null) {
                            cteDefinition.setMaterialization(materialization);
                        }
                        if ((lastChild = ctx.getChild(ctx.getChildCount() - 1)) instanceof HqlParser.CycleClauseContext) {
                            this.applyCycleClause(cteDefinition, (HqlParser.CycleClauseContext)lastChild);
                            potentialSearchClause = ctx.getChild(ctx.getChildCount() - 2);
                        } else {
                            potentialSearchClause = lastChild;
                        }
                        if (potentialSearchClause instanceof HqlParser.SearchClauseContext) {
                            this.applySearchClause(cteDefinition, (HqlParser.SearchClauseContext)potentialSearchClause);
                        }
                        Object var18_18 = null;
                        return var18_18;
                    }
                }
            }
            queryExpressionContext.accept(this);
            JpaCteCriteria cteDefinition = cteContainer.with(name, cte);
            if (materialization != null) {
                cteDefinition.setMaterialization(materialization);
            }
        }
        finally {
            this.processingStateStack.pop();
            this.currentPotentialRecursiveCte = oldCte;
        }
        return null;
    }

    private void applyCycleClause(JpaCteCriteria<?> cteDefinition, HqlParser.CycleClauseContext ctx) {
        String cyclePathAttributeName;
        Boolean noCycleValue;
        Boolean cycleValue;
        HqlParser.CteAttributesContext attributesContext = (HqlParser.CteAttributesContext)ctx.getChild(1);
        String cycleMarkAttributeName = this.visitIdentifier((HqlParser.IdentifierContext)ctx.getChild(3));
        ArrayList<JpaCteCriteriaAttribute> cycleAttributes = new ArrayList<JpaCteCriteriaAttribute>(attributesContext.getChildCount() + 1 >> 1);
        List children = attributesContext.children;
        JpaCteCriteriaType<?> type = cteDefinition.getType();
        for (int i = 0; i < children.size(); i += 2) {
            String attributeName = this.visitIdentifier((HqlParser.IdentifierContext)((Object)children.get(i)));
            JpaCteCriteriaAttribute attribute = type.getAttribute(attributeName);
            if (attribute == null) {
                throw new SemanticException(String.format("Cycle attribute '%s' not found in the CTE %s", attributeName, cteDefinition.getName()));
            }
            cycleAttributes.add(attribute);
        }
        if (ctx.getChildCount() > 4) {
            if (ctx.getChildCount() > 6) {
                SqmLiteral cycleLiteral = (SqmLiteral)this.visitLiteral((HqlParser.LiteralContext)ctx.getChild(5));
                SqmLiteral noCycleLiteral = (SqmLiteral)this.visitLiteral((HqlParser.LiteralContext)ctx.getChild(7));
                cycleValue = cycleLiteral.getLiteralValue();
                noCycleValue = noCycleLiteral.getLiteralValue();
            } else {
                cycleValue = Boolean.TRUE;
                noCycleValue = Boolean.FALSE;
            }
            ParseTree lastChild = ctx.getChild(ctx.getChildCount() - 1);
            cyclePathAttributeName = lastChild instanceof HqlParser.IdentifierContext ? this.visitIdentifier((HqlParser.IdentifierContext)lastChild) : null;
        } else {
            cyclePathAttributeName = null;
            cycleValue = Boolean.TRUE;
            noCycleValue = Boolean.FALSE;
        }
        cteDefinition.cycleUsing(cycleMarkAttributeName, cyclePathAttributeName, cycleValue, noCycleValue, cycleAttributes);
    }

    private void applySearchClause(JpaCteCriteria<?> cteDefinition, HqlParser.SearchClauseContext ctx) {
        CteSearchClauseKind kind = ((TerminalNode)ctx.getChild(1)).getSymbol().getType() == 55 ? CteSearchClauseKind.BREADTH_FIRST : CteSearchClauseKind.DEPTH_FIRST;
        String searchAttributeName = this.visitIdentifier((HqlParser.IdentifierContext)ctx.getChild(ctx.getChildCount() - 1));
        HqlParser.SearchSpecificationsContext searchCtx = (HqlParser.SearchSpecificationsContext)ctx.getChild(4);
        ArrayList<JpaSearchOrder> searchOrders = new ArrayList<JpaSearchOrder>(searchCtx.getChildCount() + 1 >> 1);
        List children = searchCtx.children;
        JpaCteCriteriaType<?> type = cteDefinition.getType();
        for (int i = 0; i < children.size(); i += 2) {
            HqlParser.SearchSpecificationContext specCtx = (HqlParser.SearchSpecificationContext)((Object)children.get(i));
            String attributeName = this.visitIdentifier((HqlParser.IdentifierContext)specCtx.getChild(0));
            JpaCteCriteriaAttribute attribute = type.getAttribute(attributeName);
            if (attribute == null) {
                throw new SemanticException(String.format("Search attribute '%s' not found in the CTE %s", attributeName, cteDefinition.getName()));
            }
            SortDirection sortOrder = SortDirection.ASCENDING;
            NullPrecedence nullPrecedence = NullPrecedence.NONE;
            int index = 1;
            if (index < specCtx.getChildCount()) {
                if (specCtx.getChild(index) instanceof HqlParser.SortDirectionContext) {
                    HqlParser.SortDirectionContext sortCtx = (HqlParser.SortDirectionContext)specCtx.getChild(index);
                    switch (((TerminalNode)sortCtx.getChild(0)).getSymbol().getType()) {
                        case 51: {
                            sortOrder = SortDirection.ASCENDING;
                            break;
                        }
                        case 75: {
                            sortOrder = SortDirection.DESCENDING;
                            break;
                        }
                        default: {
                            throw new SemanticException("Unrecognized sort ordering: " + sortCtx.getText());
                        }
                    }
                    ++index;
                }
                if (index < specCtx.getChildCount()) {
                    HqlParser.NullsPrecedenceContext nullsPrecedenceContext = (HqlParser.NullsPrecedenceContext)specCtx.getChild(index);
                    switch (((TerminalNode)nullsPrecedenceContext.getChild(1)).getSymbol().getType()) {
                        case 93: {
                            nullPrecedence = NullPrecedence.FIRST;
                            break;
                        }
                        case 118: {
                            nullPrecedence = NullPrecedence.LAST;
                            break;
                        }
                        default: {
                            throw new SemanticException("Unrecognized null precedence: " + nullsPrecedenceContext.getText());
                        }
                    }
                }
            }
            searchOrders.add(this.creationContext.getNodeBuilder().search(attribute, sortOrder, nullPrecedence));
        }
        cteDefinition.search(kind, searchAttributeName, searchOrders);
    }

    @Override
    public SqmQueryPart<?> visitSimpleQueryGroup(HqlParser.SimpleQueryGroupContext ctx) {
        int lastChild = ctx.getChildCount() - 1;
        if (lastChild != 0) {
            ctx.getChild(0).accept((ParseTreeVisitor)this);
        }
        return (SqmQueryPart)ctx.getChild(lastChild).accept((ParseTreeVisitor)this);
    }

    @Override
    public SqmQueryPart<?> visitQueryOrderExpression(HqlParser.QueryOrderExpressionContext ctx) {
        SqmQuerySpec<?> sqmQuerySpec = this.currentQuerySpec();
        SqmFromClause fromClause = this.buildInferredFromClause(null);
        sqmQuerySpec.setFromClause(fromClause);
        sqmQuerySpec.setSelectClause(this.buildInferredSelectClause(fromClause));
        this.visitQueryOrder(sqmQuerySpec, ctx.queryOrder());
        return sqmQuerySpec;
    }

    @Override
    public SqmQueryPart<?> visitQuerySpecExpression(HqlParser.QuerySpecExpressionContext ctx) {
        Object queryPart = this.visitQuery(ctx.query());
        HqlParser.QueryOrderContext queryOrderContext = ctx.queryOrder();
        if (queryOrderContext != null) {
            this.visitQueryOrder((SqmQueryPart<?>)queryPart, queryOrderContext);
        }
        return queryPart;
    }

    @Override
    public SqmQueryPart<?> visitNestedQueryExpression(HqlParser.NestedQueryExpressionContext ctx) {
        SqmQueryPart queryPart = (SqmQueryPart)ctx.queryExpression().accept(this);
        HqlParser.QueryOrderContext queryOrderContext = ctx.queryOrder();
        if (queryOrderContext != null) {
            SqmCreationProcessingState firstProcessingState = this.processingStateStack.pop();
            this.processingStateStack.push(new SqmQueryPartCreationProcessingStateStandardImpl(this.processingStateStack.getCurrent(), firstProcessingState.getProcessingQuery(), this));
            this.visitQueryOrder(queryPart, queryOrderContext);
        }
        return queryPart;
    }

    @Override
    public SqmQueryGroup<?> visitSetQueryGroup(HqlParser.SetQueryGroupContext ctx) {
        int firstIndex;
        List children = ctx.children;
        if (children.get(0) instanceof HqlParser.WithClauseContext) {
            ((ParseTree)children.get(0)).accept((ParseTreeVisitor)this);
            firstIndex = 1;
        } else {
            firstIndex = 0;
        }
        if (this.creationOptions.useStrictJpaCompliance()) {
            throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.SET_OPERATIONS);
        }
        SqmQueryPart firstQueryPart = (SqmQueryPart)((ParseTree)children.get(firstIndex)).accept((ParseTreeVisitor)this);
        SqmQueryGroup queryGroup = firstQueryPart instanceof SqmQueryGroup ? (SqmQueryGroup)firstQueryPart : new SqmQueryGroup(firstQueryPart);
        this.setCurrentQueryPart(queryGroup);
        int size = children.size();
        SqmCreationProcessingState firstProcessingState = this.processingStateStack.pop();
        for (int i = firstIndex + 1; i < size; i += 2) {
            SetOperator operator = this.visitSetOperator((HqlParser.SetOperatorContext)((Object)children.get(i)));
            HqlParser.OrderedQueryContext simpleQueryCtx = (HqlParser.OrderedQueryContext)((Object)children.get(i + 1));
            queryGroup = this.getSqmQueryGroup(operator, simpleQueryCtx, queryGroup, size, firstProcessingState, i);
        }
        this.processingStateStack.push(firstProcessingState);
        return queryGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <X> SqmQueryGroup<X> getSqmQueryGroup(SetOperator operator, HqlParser.OrderedQueryContext simpleQueryCtx, SqmQueryGroup<X> queryGroup, int size, SqmCreationProcessingState firstProcessingState, int i) {
        block9: {
            List queryParts;
            this.processingStateStack.push(new SqmQueryPartCreationProcessingStateStandardImpl(this.processingStateStack.getCurrent(), firstProcessingState.getProcessingQuery(), this));
            if (queryGroup.getSetOperator() == null || queryGroup.getSetOperator() == operator) {
                queryGroup.setSetOperator(operator);
                queryParts = queryGroup.queryParts();
            } else {
                queryParts = new ArrayList<SqmQueryPart<X>>(size - (i >> 1));
                queryParts.add(queryGroup);
                queryGroup = new SqmQueryGroup(this.creationContext.getNodeBuilder(), operator, queryParts);
                this.setCurrentQueryPart(queryGroup);
            }
            try {
                List subChildren = simpleQueryCtx.children;
                if (subChildren.get(0) instanceof HqlParser.QueryContext) {
                    SqmQuerySpec querySpec = new SqmQuerySpec(this.creationContext.getNodeBuilder());
                    queryParts.add(querySpec);
                    this.visitQuerySpecExpression((HqlParser.QuerySpecExpressionContext)simpleQueryCtx);
                    break block9;
                }
                try {
                    SqmSelectStatement selectStatement = new SqmSelectStatement(this.creationContext.getNodeBuilder());
                    this.processingStateStack.push(new SqmQueryPartCreationProcessingStateStandardImpl(this.processingStateStack.getCurrent(), selectStatement, this));
                    Object queryPart = this.visitNestedQueryExpression((HqlParser.NestedQueryExpressionContext)simpleQueryCtx);
                    queryParts.add(queryPart);
                }
                finally {
                    this.processingStateStack.pop();
                }
            }
            finally {
                this.processingStateStack.pop();
            }
        }
        return queryGroup;
    }

    @Override
    public SetOperator visitSetOperator(HqlParser.SetOperatorContext ctx) {
        Token token = ((TerminalNode)ctx.getChild(0)).getSymbol();
        boolean all = ctx.getChildCount() == 2;
        switch (token.getType()) {
            case 197: {
                return all ? SetOperator.UNION_ALL : SetOperator.UNION;
            }
            case 112: {
                return all ? SetOperator.INTERSECT_ALL : SetOperator.INTERSECT;
            }
            case 87: {
                return all ? SetOperator.EXCEPT_ALL : SetOperator.EXCEPT;
            }
        }
        throw new ParsingException("Unrecognized set operator: " + token.getText());
    }

    protected void visitQueryOrder(SqmQueryPart<?> sqmQueryPart, HqlParser.QueryOrderContext ctx) {
        SqmOrderByClause orderByClause;
        if (ctx == null) {
            return;
        }
        HqlParser.OrderByClauseContext orderByClauseContext = ctx.orderByClause();
        if (orderByClauseContext != null) {
            if (this.creationOptions.useStrictJpaCompliance() && this.processingStateStack.depth() > 1) {
                throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.SUBQUERY_ORDER_BY);
            }
            orderByClause = this.visitOrderByClause(orderByClauseContext);
            sqmQueryPart.setOrderByClause(orderByClause);
        } else {
            orderByClause = null;
        }
        HqlParser.LimitClauseContext limitClauseContext = ctx.limitClause();
        HqlParser.OffsetClauseContext offsetClauseContext = ctx.offsetClause();
        HqlParser.FetchClauseContext fetchClauseContext = ctx.fetchClause();
        if (limitClauseContext != null || offsetClauseContext != null || fetchClauseContext != null) {
            if (this.getCreationOptions().useStrictJpaCompliance()) {
                throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.LIMIT_OFFSET_CLAUSE);
            }
            if (this.processingStateStack.depth() > 1 && orderByClause == null) {
                throw new SemanticException("A 'limit', 'offset', or 'fetch' clause requires an 'order by' clause when used in a subquery");
            }
            this.setOffsetFetchLimit(sqmQueryPart, limitClauseContext, offsetClauseContext, fetchClauseContext);
        }
    }

    private void setOffsetFetchLimit(SqmQueryPart<?> sqmQueryPart, HqlParser.LimitClauseContext limitClauseContext, HqlParser.OffsetClauseContext offsetClauseContext, HqlParser.FetchClauseContext fetchClauseContext) {
        sqmQueryPart.setOffsetExpression((SqmExpression<Number>)this.visitOffsetClause(offsetClauseContext));
        if (limitClauseContext == null) {
            sqmQueryPart.setFetchExpression((SqmExpression<Number>)this.visitFetchClause(fetchClauseContext), this.visitFetchClauseType(fetchClauseContext));
        } else if (fetchClauseContext == null) {
            sqmQueryPart.setFetchExpression((SqmExpression<Number>)this.visitLimitClause(limitClauseContext));
        } else {
            throw new SemanticException("The 'limit' and 'fetch' clauses may not be used together");
        }
    }

    @Override
    public SqmQuerySpec<?> visitQuery(HqlParser.QueryContext ctx) {
        SqmQuerySpec<?> sqmQuerySpec = this.currentQuerySpec();
        SqmFromClause fromClause = ctx.fromClause() == null ? this.buildInferredFromClause(ctx.selectClause()) : this.visitFromClause(ctx.fromClause());
        sqmQuerySpec.setFromClause(fromClause);
        SqmSelectClause selectClause = ctx.selectClause() == null ? this.buildInferredSelectClause(fromClause) : this.visitSelectClause(ctx.selectClause());
        sqmQuerySpec.setSelectClause(selectClause);
        SqmWhereClause whereClause = new SqmWhereClause(this.creationContext.getNodeBuilder());
        if (ctx.whereClause() != null) {
            whereClause.setPredicate((SqmPredicate)ctx.whereClause().accept(this));
        }
        sqmQuerySpec.setWhereClause(whereClause);
        if (ctx.groupByClause() != null) {
            sqmQuerySpec.setGroupByClauseExpressions((List<SqmExpression<?>>)this.visitGroupByClause(ctx.groupByClause()));
        }
        if (ctx.havingClause() != null) {
            sqmQuerySpec.setHavingClausePredicate(this.visitHavingClause(ctx.havingClause()));
        }
        return sqmQuerySpec;
    }

    private SqmFromClause buildInferredFromClause(HqlParser.SelectClauseContext selectClauseContext) {
        if (selectClauseContext != null || this.processingStateStack.depth() > 1) {
            return new SqmFromClause();
        }
        if (this.creationOptions.useStrictJpaCompliance()) {
            throw new StrictJpaComplianceViolation("Encountered implicit 'from' clause, but strict JPQL compliance was requested", StrictJpaComplianceViolation.Type.IMPLICIT_FROM);
        }
        SqmFromClause fromClause = new SqmFromClause();
        EntityDomainType<R> entityDescriptor = this.getResultEntity();
        if (entityDescriptor != null) {
            SqmRoot<R> sqmRoot = new SqmRoot<R>(entityDescriptor, null, false, this.creationContext.getNodeBuilder());
            this.processingStateStack.getCurrent().getPathRegistry().register(sqmRoot);
            fromClause.addRoot(sqmRoot);
        }
        return fromClause;
    }

    private EntityDomainType<R> getResultEntity() {
        JpaMetamodelImplementor jpaMetamodel = this.creationContext.getJpaMetamodel();
        if (this.expectedResultEntity != null) {
            EntityDomainType entityDescriptor = jpaMetamodel.entity(this.expectedResultEntity);
            if (entityDescriptor == null) {
                throw new SemanticException("Query has no 'from' clause, and the result type '" + this.expectedResultEntity + "' is not an entity type");
            }
            return entityDescriptor;
        }
        if (this.expectedResultType != null) {
            EntityDomainType<R> entityDescriptor = jpaMetamodel.findEntityType(this.expectedResultType);
            if (entityDescriptor == null) {
                throw new SemanticException("Query has no 'from' clause, and the result type '" + this.expectedResultType.getSimpleName() + "' is not an entity type");
            }
            return entityDescriptor;
        }
        return null;
    }

    protected SqmSelectClause buildInferredSelectClause(SqmFromClause fromClause) {
        boolean singleEntityResult;
        SqmSelectClause selectClause;
        if (this.creationOptions.useStrictJpaCompliance()) {
            throw new StrictJpaComplianceViolation("Encountered implicit 'select' clause, but strict JPQL compliance was requested", StrictJpaComplianceViolation.Type.IMPLICIT_SELECT);
        }
        if (fromClause.getNumberOfRoots() == 0) {
            throw new SemanticException("query has no 'select' clause, and no root entities (every selection query must have an explicit 'select', an explicit 'from', or an explicit entity result type)");
        }
        NodeBuilder nodeBuilder = this.creationContext.getNodeBuilder();
        if (this.expectedResultType == null) {
            selectClause = new SqmSelectClause(false, nodeBuilder);
            singleEntityResult = fromClause.getNumberOfRoots() == 1;
        } else {
            boolean bl = singleEntityResult = this.creationContext.getJpaMetamodel().findEntityType(this.expectedResultType) != null;
            if (singleEntityResult) {
                if (fromClause.getNumberOfRoots() > 1) {
                    throw new SemanticException("Query has no 'select' clause, and multiple root entities, but query result type is an entity class (specify an explicit 'select' list, or a different result type, for example, 'Object[].class')");
                }
                SqmRoot<?> sqmRoot2 = fromClause.getRoots().get(0);
                if (sqmRoot2 instanceof SqmCteRoot) {
                    throw new SemanticException("Query has no 'select' clause, and the 'from' clause refers to a CTE, but query result type is an entity class (specify an explicit 'select' list)");
                }
                selectClause = new SqmSelectClause(false, 1, nodeBuilder);
            } else {
                selectClause = new SqmSelectClause(false, nodeBuilder);
            }
        }
        fromClause.visitRoots(sqmRoot -> {
            selectClause.addSelection(new SqmSelection(sqmRoot, sqmRoot.getAlias(), nodeBuilder));
            if (!singleEntityResult) {
                this.applyJoinsToInferredSelectClause((SqmFrom<?, ?>)sqmRoot, selectClause);
            }
        });
        return selectClause;
    }

    private void applyJoinsToInferredSelectClause(SqmFrom<?, ?> sqm, SqmSelectClause selectClause) {
        sqm.visitSqmJoins(sqmJoin -> {
            if (sqmJoin.isImplicitlySelectable()) {
                selectClause.addSelection(new SqmSelection(sqmJoin, sqmJoin.getAlias(), this.creationContext.getNodeBuilder()));
                this.applyJoinsToInferredSelectClause((SqmFrom<?, ?>)sqmJoin, selectClause);
            }
        });
    }

    @Override
    public SqmSelectClause visitSelectClause(HqlParser.SelectClauseContext ctx) {
        SqmSelectClause selectClause = new SqmSelectClause(ctx.DISTINCT() != null, this.creationContext.getNodeBuilder());
        HqlParser.SelectionListContext selectionListContext = ctx.selectionList();
        for (HqlParser.SelectionContext selectionContext : selectionListContext.selection()) {
            selectClause.addSelection((SqmSelection<?>)this.visitSelection(selectionContext));
        }
        return selectClause;
    }

    @Override
    public SqmSelection<?> visitSelection(HqlParser.SelectionContext ctx) {
        SqmSelectableNode<?> selectableNode = this.visitSelectableNode(ctx);
        String resultIdentifier = SqmTreeCreationHelper.extractJpaCompliantAlias(ctx.variable(), this);
        SqmSelection selection = new SqmSelection(selectableNode, resultIdentifier, this.creationContext.getNodeBuilder());
        if (!(selectableNode instanceof SqmDynamicInstantiation)) {
            this.processingStateStack.getCurrent().getPathRegistry().register(selection);
        }
        return selection;
    }

    private SqmSelectableNode<?> visitSelectableNode(HqlParser.SelectionContext ctx) {
        ParseTree subCtx = ctx.getChild(0).getChild(0);
        if (subCtx instanceof HqlParser.ExpressionOrPredicateContext) {
            SqmPath sqmPath;
            SqmExpression sqmExpression = (SqmExpression)subCtx.accept((ParseTreeVisitor)this);
            if (sqmExpression instanceof SqmPath && (sqmPath = (SqmPath)sqmExpression).getReferencedPathSource() instanceof PluralPersistentAttribute) {
                if (this.creationOptions.useStrictJpaCompliance()) {
                    SqmTreeCreationLogger.LOGGER.debugf("Raw selection of plural attribute not supported by JPA: %s.  Use `value(%s)` or `key(%s)` to indicate what part of the collection to select", (Object)sqmPath.getAlias(), (Object)sqmPath.getAlias(), (Object)sqmPath.getAlias());
                }
                SemanticPathPart elementPath = sqmPath.resolvePathPart(CollectionPart.Nature.ELEMENT.getName(), true, this);
                this.processingStateStack.getCurrent().getPathRegistry().register((SqmPath<?>)elementPath);
                return elementPath;
            }
            return sqmExpression;
        }
        return (SqmSelectableNode)subCtx.accept((ParseTreeVisitor)this);
    }

    @Override
    public SqmDynamicInstantiation<?> visitInstantiation(HqlParser.InstantiationContext ctx) {
        SqmDynamicInstantiation<Object> dynamicInstantiation;
        ParseTree instantiationTarget = ctx.instantiationTarget().getChild(0);
        if (instantiationTarget instanceof HqlParser.SimplePathContext) {
            String className = instantiationTarget.getText();
            if (this.expectedResultType != null && this.expectedResultType.getSimpleName().equals(className)) {
                className = this.expectedResultType.getName();
            }
            try {
                dynamicInstantiation = SqmDynamicInstantiation.forClassInstantiation(this.resolveInstantiationTargetJtd(className), this.creationContext.getNodeBuilder());
            }
            catch (ClassLoadingException e) {
                throw new SemanticException("Could not resolve class '" + className + "' named for instantiation");
            }
        } else {
            TerminalNode terminalNode = (TerminalNode)instantiationTarget;
            switch (terminalNode.getSymbol().getType()) {
                case 130: {
                    dynamicInstantiation = SqmDynamicInstantiation.forMapInstantiation(this.mapJavaType, this.creationContext.getNodeBuilder());
                    break;
                }
                case 124: {
                    dynamicInstantiation = SqmDynamicInstantiation.forListInstantiation(this.listJavaType, this.creationContext.getNodeBuilder());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported instantiation target: " + terminalNode);
                }
            }
        }
        for (HqlParser.InstantiationArgumentContext arg : ctx.instantiationArguments().instantiationArgument()) {
            dynamicInstantiation.addArgument((SqmDynamicInstantiationArgument<?>)this.visitInstantiationArgument(arg));
        }
        return dynamicInstantiation;
    }

    private JavaType<?> resolveInstantiationTargetJtd(String className) {
        Class<?> targetJavaType = this.classForName(this.creationContext.getJpaMetamodel().qualifyImportableName(className));
        return this.creationContext.getJpaMetamodel().getTypeConfiguration().getJavaTypeRegistry().resolveDescriptor(targetJavaType);
    }

    private Class<?> classForName(String className) {
        return this.creationContext.getServiceRegistry().getService(ClassLoaderService.class).classForName(className);
    }

    @Override
    public SqmDynamicInstantiationArgument<?> visitInstantiationArgument(HqlParser.InstantiationArgumentContext ctx) {
        String alias = ctx.getChildCount() > 1 ? this.extractAlias((HqlParser.VariableContext)ctx.getChild(ctx.getChildCount() - 1)) : null;
        SqmSelectableNode argExpression = (SqmSelectableNode)ctx.getChild(0).accept((ParseTreeVisitor)this);
        SqmDynamicInstantiationArgument argument = new SqmDynamicInstantiationArgument(argExpression, alias, this.creationContext.getNodeBuilder());
        if (!(argExpression instanceof SqmDynamicInstantiation)) {
            this.processingStateStack.getCurrent().getPathRegistry().register(argument);
        }
        return argument;
    }

    @Override
    public SqmPath<?> visitJpaSelectObjectSyntax(HqlParser.JpaSelectObjectSyntaxContext ctx) {
        String alias = ctx.getChild(2).getText();
        Object sqmFromByAlias = this.processingStateStack.getCurrent().getPathRegistry().findFromByAlias(alias, true);
        if (sqmFromByAlias == null) {
            throw new SemanticException("Could not resolve alias '" + alias + "' in selection [" + ctx.getText() + "]");
        }
        return sqmFromByAlias;
    }

    @Override
    public List<SqmExpression<?>> visitGroupByClause(HqlParser.GroupByClauseContext ctx) {
        int size = ctx.getChildCount();
        int estimateExpressionsCount = (size >> 1) - 1;
        ArrayList expressions = new ArrayList(estimateExpressionsCount);
        for (int i = 0; i < size; ++i) {
            ParseTree parseTree = ctx.getChild(i);
            if (!(parseTree instanceof HqlParser.GroupByExpressionContext)) continue;
            expressions.add((SqmExpression)parseTree.accept((ParseTreeVisitor)this));
        }
        return expressions;
    }

    private SqmExpression<?> resolveOrderByOrGroupByExpression(ParseTree child, boolean definedCollate, boolean allowPositionalOrAliases) {
        NodeBuilder nodeBuilder = this.creationContext.getNodeBuilder();
        SqmCreationProcessingState processingState = this.processingStateStack.getCurrent();
        SqmQuery<?> processingQuery = processingState.getProcessingQuery();
        JpaQueryPart<Object> queryPart = processingQuery instanceof SqmInsertSelectStatement ? ((SqmInsertSelectStatement)processingQuery).getSelectQueryPart() : (processingQuery instanceof SqmSelectQuery ? ((SqmSelectQuery)processingQuery).getQueryPart() : null);
        if (child instanceof TerminalNode) {
            List<SqmSelection<?>> selections;
            if (definedCollate) {
                throw new SyntaxException("'collate' is not allowed for position based 'order by' or 'group by' items");
            }
            if (!allowPositionalOrAliases) {
                throw new SyntaxException("Position based 'order by' is not allowed in 'over' or 'within group' clauses");
            }
            int position = Integer.parseInt(child.getText());
            SqmAliasedNode<Object> nodeByPosition = queryPart instanceof SqmQueryGroup ? (position <= (selections = queryPart.getFirstQuerySpec().getSelectClause().getSelections()).size() ? (SqmAliasedNode)selections.get(position - 1) : null) : processingState.getPathRegistry().findAliasedNodeByPosition(position);
            if (nodeByPosition == null) {
                throw new SemanticException("Numeric literal '" + position + "' used in 'group by' does not match a registered select item");
            }
            return new SqmAliasedNodeRef(position, this.integerDomainType, nodeBuilder);
        }
        if (child instanceof HqlParser.IdentifierContext) {
            String identifierText = this.visitIdentifier((HqlParser.IdentifierContext)child);
            if (queryPart instanceof SqmQueryGroup) {
                SqmPath found = null;
                int sqmPosition = 0;
                List<SqmSelection<?>> selections = queryPart.getFirstQuerySpec().getSelectClause().getSelections();
                for (int i = 0; i < selections.size(); ++i) {
                    SqmPath path;
                    SqmSelection<?> sqmSelection = selections.get(i);
                    if (identifierText.equals(sqmSelection.getAlias())) {
                        return new SqmAliasedNodeRef(i + 1, nodeBuilder.getIntegerType(), nodeBuilder);
                    }
                    SqmSelectableNode<?> selectableNode = sqmSelection.getSelectableNode();
                    if (selectableNode instanceof SqmFrom) {
                        SqmFrom fromElement = (SqmFrom)selectableNode;
                        SqmPathSource pathSource = fromElement.getReferencedPathSource();
                        if (pathSource.findSubPathSource(identifierText) == null) continue;
                        if (sqmPosition != 0) {
                            throw new IllegalStateException("Multiple from elements expose unqualified attribute: " + identifierText);
                        }
                        found = fromElement;
                        sqmPosition = i + 1;
                        continue;
                    }
                    if (!(selectableNode instanceof SqmPath) || !identifierText.equals((path = (SqmPath)selectableNode).getReferencedPathSource().getPathName())) continue;
                    if (sqmPosition != 0) {
                        throw new IllegalStateException("Multiple from elements expose unqualified attribute: " + identifierText);
                    }
                    sqmPosition = i + 1;
                }
                if (found != null) {
                    return new SqmAliasedNodeRef(sqmPosition, found.get(identifierText).getNavigablePath(), nodeBuilder.getIntegerType(), nodeBuilder);
                }
                if (sqmPosition != 0) {
                    return new SqmAliasedNodeRef(sqmPosition, nodeBuilder.getIntegerType(), nodeBuilder);
                }
            } else {
                Integer correspondingPosition;
                Integer n = correspondingPosition = allowPositionalOrAliases ? processingState.getPathRegistry().findAliasedNodePosition(identifierText) : null;
                if (correspondingPosition != null) {
                    if (definedCollate) {
                        throw new SyntaxException("'collate' is not allowed for alias-based 'order by' or 'group by' items");
                    }
                    return new SqmAliasedNodeRef(correspondingPosition, this.integerDomainType, nodeBuilder);
                }
                Object sqmFrom = processingState.getPathRegistry().findFromByAlias(identifierText, true);
                if (sqmFrom != null) {
                    if (definedCollate) {
                        throw new SyntaxException("'collate' is not allowed for alias-based 'order by' or 'group by' items");
                    }
                    return sqmFrom;
                }
                DotIdentifierConsumer dotIdentifierConsumer = this.dotIdentifierConsumerStack.getCurrent();
                dotIdentifierConsumer.consumeIdentifier(identifierText, true, true);
                return (SqmExpression)((Object)dotIdentifierConsumer.getConsumedPart());
            }
        }
        return (SqmExpression)child.accept((ParseTreeVisitor)this);
    }

    @Override
    public SqmExpression<?> visitGroupByExpression(HqlParser.GroupByExpressionContext ctx) {
        return this.resolveOrderByOrGroupByExpression(ctx.getChild(0), ctx.getChildCount() > 1, true);
    }

    @Override
    public SqmPredicate visitHavingClause(HqlParser.HavingClauseContext ctx) {
        return (SqmPredicate)ctx.getChild(1).accept((ParseTreeVisitor)this);
    }

    @Override
    public SqmOrderByClause visitOrderByClause(HqlParser.OrderByClauseContext ctx) {
        return this.visitOrderByClause(ctx, true);
    }

    private SqmOrderByClause visitOrderByClause(HqlParser.OrderByClauseContext ctx, boolean allowPositionalOrAliases) {
        int size = ctx.getChildCount();
        int estimateExpressionsCount = (size >> 1) - 1;
        SqmOrderByClause orderByClause = new SqmOrderByClause(estimateExpressionsCount);
        for (int i = 0; i < size; ++i) {
            ParseTree parseTree = ctx.getChild(i);
            if (!(parseTree instanceof HqlParser.SortSpecificationContext)) continue;
            orderByClause.addSortSpecification(this.visitSortSpecification((HqlParser.SortSpecificationContext)parseTree, allowPositionalOrAliases));
        }
        return orderByClause;
    }

    @Override
    public SqmSortSpecification visitSortSpecification(HqlParser.SortSpecificationContext ctx) {
        return this.visitSortSpecification(ctx, true);
    }

    private SqmSortSpecification visitSortSpecification(HqlParser.SortSpecificationContext ctx, boolean allowPositionalOrAliases) {
        NullPrecedence nullPrecedence;
        SortDirection sortOrder;
        SqmExpression<?> sortExpression = this.visitSortExpression(ctx.sortExpression(), allowPositionalOrAliases);
        if (sortExpression == null) {
            throw new SemanticException("Could not resolve sort expression: '" + ctx.sortExpression().getText() + "'");
        }
        if (sortExpression instanceof SqmLiteral || sortExpression instanceof SqmParameter) {
            HqlLogging.QUERY_LOGGER.debugf("Questionable sorting by constant value : %s", sortExpression);
        }
        SortDirection sortDirection = sortOrder = ctx.sortDirection() == null || ctx.sortDirection().DESC() == null ? SortDirection.ASCENDING : SortDirection.DESCENDING;
        if (ctx.nullsPrecedence() == null) {
            nullPrecedence = NullPrecedence.NONE;
        } else if (ctx.nullsPrecedence().FIRST() != null) {
            nullPrecedence = NullPrecedence.FIRST;
        } else if (ctx.nullsPrecedence().LAST() != null) {
            nullPrecedence = NullPrecedence.LAST;
        } else {
            throw new ParsingException("Unrecognized null precedence");
        }
        return new SqmSortSpecification(sortExpression, sortOrder, nullPrecedence);
    }

    @Override
    public SqmExpression<?> visitSortExpression(HqlParser.SortExpressionContext ctx) {
        return this.visitSortExpression(ctx, true);
    }

    public SqmExpression<?> visitSortExpression(HqlParser.SortExpressionContext ctx, boolean allowPositionalOrAliases) {
        return this.resolveOrderByOrGroupByExpression(ctx.getChild(0), ctx.getChildCount() > 1, allowPositionalOrAliases);
    }

    private SqmQuerySpec<?> currentQuerySpec() {
        SqmQuery<?> processingQuery = this.processingStateStack.getCurrent().getProcessingQuery();
        if (processingQuery instanceof SqmInsertSelectStatement) {
            return ((SqmInsertSelectStatement)processingQuery).getSelectQueryPart().getLastQuerySpec();
        }
        return ((SqmQueryPart)((SqmSelectQuery)processingQuery).getQueryPart()).getLastQuerySpec();
    }

    private <X> void setCurrentQueryPart(SqmQueryPart<X> queryPart) {
        SqmQuery<?> processingQuery = this.processingStateStack.getCurrent().getProcessingQuery();
        if (processingQuery instanceof SqmInsertSelectStatement) {
            ((SqmInsertSelectStatement)processingQuery).setSelectQueryPart(queryPart);
        } else {
            ((AbstractSqmSelectQuery)processingQuery).setQueryPart(queryPart);
        }
    }

    @Override
    public SqmExpression<?> visitLimitClause(HqlParser.LimitClauseContext ctx) {
        if (ctx == null) {
            return null;
        }
        return (SqmExpression)ctx.parameterOrIntegerLiteral().accept(this);
    }

    @Override
    public SqmExpression<?> visitOffsetClause(HqlParser.OffsetClauseContext ctx) {
        if (ctx == null) {
            return null;
        }
        return (SqmExpression)ctx.parameterOrIntegerLiteral().accept(this);
    }

    @Override
    public SqmExpression<?> visitFetchClause(HqlParser.FetchClauseContext ctx) {
        if (ctx == null) {
            return null;
        }
        HqlParser.FetchCountOrPercentContext fetchCountOrPercent = ctx.fetchCountOrPercent();
        if (fetchCountOrPercent.PERCENT() == null) {
            return (SqmExpression)fetchCountOrPercent.parameterOrIntegerLiteral().accept(this);
        }
        return (SqmExpression)fetchCountOrPercent.parameterOrNumberLiteral().accept(this);
    }

    private FetchClauseType visitFetchClauseType(HqlParser.FetchClauseContext ctx) {
        if (ctx == null) {
            return FetchClauseType.ROWS_ONLY;
        }
        if (ctx.fetchCountOrPercent().PERCENT() == null) {
            return ctx.TIES() == null ? FetchClauseType.ROWS_ONLY : FetchClauseType.ROWS_WITH_TIES;
        }
        return ctx.TIES() == null ? FetchClauseType.PERCENT_ONLY : FetchClauseType.PERCENT_WITH_TIES;
    }

    @Override
    public Object visitSyntacticPathExpression(HqlParser.SyntacticPathExpressionContext ctx) {
        SemanticPathPart part = this.visitSyntacticDomainPath(ctx.syntacticDomainPath());
        if (ctx.getChildCount() == 2) {
            this.dotIdentifierConsumerStack.push(new BasicDotIdentifierConsumer(part, this){

                @Override
                protected void reset() {
                }
            });
            try {
                part = (SemanticPathPart)ctx.pathContinuation().accept(this);
            }
            finally {
                this.dotIdentifierConsumerStack.pop();
            }
        }
        if (part instanceof DomainPathPart) {
            return ((DomainPathPart)part).getSqmExpression();
        }
        return part;
    }

    @Override
    public Object visitGeneralPathExpression(HqlParser.GeneralPathExpressionContext ctx) {
        SemanticPathPart part = this.visitGeneralPathFragment(ctx.generalPathFragment());
        if (part instanceof DomainPathPart) {
            return ((DomainPathPart)part).getSqmExpression();
        }
        return part;
    }

    @Override
    public SqmExpression<?> visitFunctionExpression(HqlParser.FunctionExpressionContext ctx) {
        return (SqmExpression)ctx.function().accept(this);
    }

    @Override
    public SqmExpression<?> visitParameterOrIntegerLiteral(HqlParser.ParameterOrIntegerLiteralContext ctx) {
        if (ctx.INTEGER_LITERAL() != null) {
            return this.integerLiteral(ctx.INTEGER_LITERAL().getText());
        }
        return (SqmExpression)ctx.parameter().accept(this);
    }

    @Override
    public SqmExpression<?> visitParameterOrNumberLiteral(HqlParser.ParameterOrNumberLiteralContext ctx) {
        if (ctx.INTEGER_LITERAL() != null) {
            return this.integerLiteral(ctx.INTEGER_LITERAL().getText());
        }
        if (ctx.FLOAT_LITERAL() != null) {
            return this.floatLiteral(ctx.FLOAT_LITERAL().getText());
        }
        if (ctx.DOUBLE_LITERAL() != null) {
            return this.doubleLiteral(ctx.DOUBLE_LITERAL().getText());
        }
        if (ctx.parameter() != null) {
            return (SqmExpression)ctx.parameter().accept(this);
        }
        ParseTree firstChild = ctx.getChild(0);
        if (firstChild instanceof TerminalNode) {
            switch (((TerminalNode)firstChild).getSymbol().getType()) {
                case 3: {
                    return this.integerLiteral(firstChild.getText());
                }
                case 5: {
                    return this.floatLiteral(firstChild.getText());
                }
                case 6: {
                    return this.doubleLiteral(firstChild.getText());
                }
            }
            throw new UnsupportedOperationException("Unsupported literal: " + firstChild.getText());
        }
        return (SqmExpression)firstChild.accept((ParseTreeVisitor)this);
    }

    public String getEntityName(HqlParser.EntityNameContext parserEntityName) {
        StringBuilder sb = new StringBuilder();
        int end = parserEntityName.getChildCount();
        sb.append(this.visitIdentifier((HqlParser.IdentifierContext)parserEntityName.getChild(0)));
        for (int i = 2; i < end; i += 2) {
            sb.append('.');
            sb.append(this.visitIdentifier((HqlParser.IdentifierContext)parserEntityName.getChild(i)));
        }
        return sb.toString();
    }

    @Override
    public String visitIdentifier(HqlParser.IdentifierContext ctx) {
        ParseTree child = ctx.getChild(0);
        return child instanceof TerminalNode ? child.getText() : this.visitNakedIdentifier((HqlParser.NakedIdentifierContext)child);
    }

    @Override
    public String visitNakedIdentifier(HqlParser.NakedIdentifierContext ctx) {
        TerminalNode node = (TerminalNode)ctx.getChild(0);
        String text = node.getText();
        return node.getSymbol().getType() == 214 ? QuotingHelper.unquoteIdentifier(text) : text;
    }

    @Override
    public EntityDomainType<?> visitEntityName(HqlParser.EntityNameContext parserEntityName) {
        String entityName = this.getEntityName(parserEntityName);
        EntityDomainType entityReference = this.getCreationContext().getJpaMetamodel().getHqlEntityReference(entityName);
        if (entityReference == null) {
            throw new UnknownEntityException("Could not resolve target entity '" + entityName + "'", entityName);
        }
        this.checkFQNEntityNameJpaComplianceViolationIfNeeded(entityName, entityReference);
        if (entityReference instanceof SqmPolymorphicRootDescriptor && this.getCreationOptions().useStrictJpaCompliance()) {
            throw new StrictJpaComplianceViolation("Encountered the use of a non entity name [" + entityName + "], but strict JPQL compliance was requested which doesn't allow this", StrictJpaComplianceViolation.Type.NON_ENTITY_NAME);
        }
        return entityReference;
    }

    @Override
    public SqmFromClause visitFromClause(HqlParser.FromClauseContext parserFromClause) {
        List<HqlParser.EntityWithJoinsContext> roots = parserFromClause.entityWithJoins();
        SqmFromClause fromClause = new SqmFromClause(roots.size());
        this.currentQuerySpec().setFromClause(fromClause);
        if (this.creationOptions.useStrictJpaCompliance() && roots.size() > 1) {
            Object sqmRoot = this.visitEntityWithJoins(roots.get(0));
            fromClause.addRoot((SqmRoot<?>)sqmRoot);
            for (int i = 1; i < roots.size(); ++i) {
                HqlParser.EntityWithJoinsContext secondaryRoot = roots.get(i);
                SqmTreeCreationHelper.handleRootAsCrossJoin(secondaryRoot, sqmRoot, this);
            }
        } else {
            for (HqlParser.EntityWithJoinsContext root : roots) {
                Object sqmRoot = this.visitEntityWithJoins(root);
                if (sqmRoot instanceof SqmCorrelation) continue;
                fromClause.addRoot((SqmRoot<?>)sqmRoot);
            }
        }
        return fromClause;
    }

    @Override
    public SqmRoot<?> visitEntityWithJoins(HqlParser.EntityWithJoinsContext parserSpace) {
        SqmRoot sqmRoot = (SqmRoot)parserSpace.fromRoot().accept(this);
        int size = parserSpace.getChildCount();
        for (int i = 1; i < size; ++i) {
            ParseTree parseTree = parserSpace.getChild(i);
            if (parseTree instanceof HqlParser.CrossJoinContext) {
                this.consumeCrossJoin((HqlParser.CrossJoinContext)parseTree, sqmRoot);
                continue;
            }
            if (parseTree instanceof HqlParser.JoinContext) {
                this.consumeJoin((HqlParser.JoinContext)parseTree, sqmRoot);
                continue;
            }
            if (!(parseTree instanceof HqlParser.JpaCollectionJoinContext)) continue;
            this.consumeJpaCollectionJoin((HqlParser.JpaCollectionJoinContext)parseTree, sqmRoot);
        }
        return sqmRoot;
    }

    @Override
    public SqmRoot<?> visitRootEntity(HqlParser.RootEntityContext ctx) {
        HqlParser.EntityNameContext entityNameContext = ctx.entityName();
        String name = this.getEntityName(entityNameContext);
        EntityDomainType entityDescriptor = this.creationContext.getJpaMetamodel().getHqlEntityReference(name);
        String alias = this.extractAlias(ctx.variable());
        SqmCreationProcessingState processingState = this.processingStateStack.getCurrent();
        SqmPathRegistry pathRegistry = processingState.getPathRegistry();
        if (entityDescriptor == null) {
            return this.resolveRootEntity(entityNameContext, name, alias, processingState, pathRegistry);
        }
        this.checkFQNEntityNameJpaComplianceViolationIfNeeded(name, entityDescriptor);
        if (entityDescriptor instanceof SqmPolymorphicRootDescriptor) {
            if (this.getCreationOptions().useStrictJpaCompliance()) {
                throw new StrictJpaComplianceViolation("Encountered unmapped polymorphic reference [" + entityDescriptor.getHibernateEntityName() + "], but strict JPQL compliance was requested", StrictJpaComplianceViolation.Type.UNMAPPED_POLYMORPHISM);
            }
            if (this.processingStateStack.depth() > 1) {
                throw new SemanticException("Implicitly-polymorphic domain path in subquery '" + entityDescriptor.getName() + "'");
            }
        }
        SqmRoot sqmRoot = new SqmRoot(entityDescriptor, alias, true, this.creationContext.getNodeBuilder());
        pathRegistry.register(sqmRoot);
        return sqmRoot;
    }

    private SqmRoot<?> resolveRootEntity(HqlParser.EntityNameContext entityNameContext, String name, String alias, SqmCreationProcessingState processingState, SqmPathRegistry pathRegistry) {
        List entityNameParseTreeChildren = entityNameContext.children;
        int size = entityNameParseTreeChildren.size();
        if (this.processingStateStack.depth() > 1 && size > 2) {
            String parentAlias = ((ParseTree)entityNameParseTreeChildren.get(0)).getText();
            AbstractSqmFrom correlation = (AbstractSqmFrom)processingState.getPathRegistry().findFromByAlias(parentAlias, true);
            if (correlation instanceof SqmCorrelation) {
                QualifiedJoinPathConsumer dotIdentifierConsumer = new QualifiedJoinPathConsumer(correlation, SqmJoinType.INNER, false, alias, (SqmCreationState)this);
                int lastIdx = size - 1;
                for (int i = 2; i != lastIdx; i += 2) {
                    dotIdentifierConsumer.consumeIdentifier(((ParseTree)entityNameParseTreeChildren.get(i)).getText(), false, false);
                }
                dotIdentifierConsumer.consumeIdentifier(((ParseTree)entityNameParseTreeChildren.get(lastIdx)).getText(), false, true);
                return ((SqmCorrelation)((Object)correlation)).getCorrelatedRoot();
            }
            throw new SemanticException("Could not resolve entity or correlation path '" + name + "'");
        }
        SqmCteStatement<?> cteStatement = this.findCteStatement(name);
        if (cteStatement != null) {
            SqmCteRoot root = new SqmCteRoot(cteStatement, alias);
            pathRegistry.register(root);
            return root;
        }
        throw new UnknownEntityException("Could not resolve root entity '" + name + "'", name);
    }

    @Override
    public SqmCteStatement<?> findCteStatement(String name) {
        if (this.currentPotentialRecursiveCte != null && name.equals(this.currentPotentialRecursiveCte.getName())) {
            return (SqmCteStatement)this.currentPotentialRecursiveCte;
        }
        return this.processingStateStack.findCurrentFirstWithParameter(name, SemanticQueryBuilder::matchCteStatement);
    }

    private static SqmCteStatement<?> matchCteStatement(SqmCreationProcessingState state, String n) {
        if (state.getProcessingQuery() instanceof SqmCteContainer) {
            SqmCteContainer container = (SqmCteContainer)((Object)state.getProcessingQuery());
            return container.getCteStatement(n);
        }
        return null;
    }

    @Override
    public SqmRoot<?> visitRootSubquery(HqlParser.RootSubqueryContext ctx) {
        if (this.getCreationOptions().useStrictJpaCompliance()) {
            throw new StrictJpaComplianceViolation("The JPA specification does not support subqueries in the from clause. Please disable the JPA query compliance if you want to use this feature.", StrictJpaComplianceViolation.Type.FROM_SUBQUERY);
        }
        SqmSubQuery subQuery = (SqmSubQuery)ctx.subquery().accept(this);
        String alias = this.extractAlias(ctx.variable());
        SqmDerivedRoot sqmRoot = new SqmDerivedRoot(subQuery, alias);
        this.processingStateStack.getCurrent().getPathRegistry().register(sqmRoot);
        return sqmRoot;
    }

    @Override
    public String visitVariable(HqlParser.VariableContext ctx) {
        return this.extractAlias(ctx);
    }

    protected String extractAlias(HqlParser.VariableContext ctx) {
        return SqmTreeCreationHelper.extractAlias(ctx, this);
    }

    protected String applyJpaCompliance(String text) {
        return SqmTreeCreationHelper.applyJpaCompliance(text, this);
    }

    @Override
    public final SqmCrossJoin<?> visitCrossJoin(HqlParser.CrossJoinContext ctx) {
        throw new UnsupportedOperationException("Unexpected call to #visitCrossJoin, see #consumeCrossJoin");
    }

    protected <T> void consumeCrossJoin(HqlParser.CrossJoinContext parserJoin, SqmRoot<T> sqmRoot) {
        String name = this.getEntityName(parserJoin.entityName());
        SqmTreeCreationLogger.LOGGER.debugf("Handling root path - %s", (Object)name);
        EntityDomainType entityDescriptor = this.getCreationContext().getJpaMetamodel().resolveHqlEntityReference(name);
        if (entityDescriptor instanceof SqmPolymorphicRootDescriptor) {
            throw new SemanticException("Unmapped polymorphic reference cannot be used as a target of 'cross join'");
        }
        SqmCrossJoin join = new SqmCrossJoin(entityDescriptor, this.extractAlias(parserJoin.variable()), sqmRoot);
        this.processingStateStack.getCurrent().getPathRegistry().register(join);
        sqmRoot.addSqmJoin((SqmJoin<T, ?>)join);
    }

    @Override
    public final SqmJoin<?, ?> visitJoin(HqlParser.JoinContext parserJoin) {
        throw new UnsupportedOperationException("Unexpected call to #visitJoin, see #consumeJoin");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <X> void consumeJoin(HqlParser.JoinContext parserJoin, SqmRoot<X> sqmRoot) {
        block12: {
            boolean fetch;
            SqmJoinType joinType = SemanticQueryBuilder.getSqmJoinType(parserJoin.joinType());
            HqlParser.JoinTargetContext qualifiedJoinTargetContext = parserJoin.joinTarget();
            String alias = this.extractAlias(SemanticQueryBuilder.getVariable(qualifiedJoinTargetContext));
            boolean bl = fetch = parserJoin.FETCH() != null;
            if (fetch && this.processingStateStack.depth() > 1) {
                throw new SemanticException("The 'from' clause of a subquery has a 'fetch'");
            }
            this.dotIdentifierConsumerStack.push(new QualifiedJoinPathConsumer(sqmRoot, joinType, fetch, alias, (SqmCreationState)this));
            try {
                SqmQualifiedJoin<X, ?> join = this.getJoin(sqmRoot, joinType, qualifiedJoinTargetContext, alias, fetch);
                HqlParser.JoinRestrictionContext joinRestrictionContext = parserJoin.joinRestriction();
                if (join instanceof SqmEntityJoin || join instanceof SqmDerivedJoin || join instanceof SqmCteJoin) {
                    sqmRoot.addSqmJoin((SqmJoin<X, ?>)join);
                } else if (join instanceof SqmAttributeJoin) {
                    SqmAttributeJoin attributeJoin = (SqmAttributeJoin)join;
                    if (this.getCreationOptions().useStrictJpaCompliance() && join.getExplicitAlias() != null && attributeJoin.isFetched()) {
                        throw new StrictJpaComplianceViolation("Encountered aliased fetch join, but strict JPQL compliance was requested", StrictJpaComplianceViolation.Type.ALIASED_FETCH_JOIN);
                    }
                    if (joinRestrictionContext != null && attributeJoin.isFetched()) {
                        throw new SemanticException("Fetch join has a 'with' clause (use a filter instead)");
                    }
                }
                if (joinRestrictionContext == null) break block12;
                this.dotIdentifierConsumerStack.push(new QualifiedJoinPredicatePathConsumer(join, (SqmCreationState)this));
                try {
                    join.setJoinPredicate((SqmPredicate)joinRestrictionContext.getChild(1).accept((ParseTreeVisitor)this));
                }
                finally {
                    this.dotIdentifierConsumerStack.pop();
                }
            }
            finally {
                this.dotIdentifierConsumerStack.pop();
            }
        }
    }

    private static HqlParser.VariableContext getVariable(HqlParser.JoinTargetContext joinTargetContext) {
        if (joinTargetContext instanceof HqlParser.JoinPathContext) {
            return ((HqlParser.JoinPathContext)joinTargetContext).variable();
        }
        if (joinTargetContext instanceof HqlParser.JoinSubqueryContext) {
            return ((HqlParser.JoinSubqueryContext)joinTargetContext).variable();
        }
        throw new ParsingException("unexpected join type");
    }

    private <X> SqmQualifiedJoin<X, ?> getJoin(SqmRoot<X> sqmRoot, SqmJoinType joinType, HqlParser.JoinTargetContext joinTargetContext, String alias, boolean fetch) {
        if (joinTargetContext instanceof HqlParser.JoinPathContext) {
            HqlParser.JoinPathContext joinPathContext = (HqlParser.JoinPathContext)joinTargetContext;
            return (SqmQualifiedJoin)joinPathContext.path().accept(this);
        }
        if (joinTargetContext instanceof HqlParser.JoinSubqueryContext) {
            if (fetch) {
                throw new SemanticException("The 'from' clause of a subquery has a 'fetch' join");
            }
            if (this.getCreationOptions().useStrictJpaCompliance()) {
                throw new StrictJpaComplianceViolation("The JPA specification does not support subqueries in the from clause. Please disable the JPA query compliance if you want to use this feature.", StrictJpaComplianceViolation.Type.FROM_SUBQUERY);
            }
            HqlParser.JoinSubqueryContext joinSubqueryContext = (HqlParser.JoinSubqueryContext)joinTargetContext;
            boolean lateral = joinSubqueryContext.LATERAL() != null;
            DotIdentifierConsumer identifierConsumer = this.dotIdentifierConsumerStack.pop();
            SqmSubQuery subQuery = (SqmSubQuery)joinSubqueryContext.subquery().accept(this);
            this.dotIdentifierConsumerStack.push(identifierConsumer);
            SqmDerivedJoin join = new SqmDerivedJoin(subQuery, alias, joinType, lateral, sqmRoot);
            this.processingStateStack.getCurrent().getPathRegistry().register(join);
            return join;
        }
        throw new ParsingException("unexpected join type");
    }

    private static SqmJoinType getSqmJoinType(HqlParser.JoinTypeContext joinTypeContext) {
        if (joinTypeContext == null || joinTypeContext.getChildCount() == 0) {
            return SqmJoinType.INNER;
        }
        TerminalNode firstChild = (TerminalNode)joinTypeContext.getChild(0);
        switch (firstChild.getSymbol().getType()) {
            case 98: {
                return SqmJoinType.FULL;
            }
            case 171: {
                return SqmJoinType.RIGHT;
            }
            case 121: 
            case 158: {
                return SqmJoinType.LEFT;
            }
        }
        return SqmJoinType.INNER;
    }

    @Override
    public SqmJoin<?, ?> visitJpaCollectionJoin(HqlParser.JpaCollectionJoinContext ctx) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void consumeJpaCollectionJoin(HqlParser.JpaCollectionJoinContext ctx, SqmRoot<?> sqmRoot) {
        String alias = this.extractAlias(ctx.variable());
        this.dotIdentifierConsumerStack.push(new QualifiedJoinPathConsumer(sqmRoot, SqmJoinType.INNER, false, alias, (SqmCreationState)this));
        try {
            this.consumePluralAttributeReference(ctx.path());
        }
        finally {
            this.dotIdentifierConsumerStack.pop();
        }
    }

    @Override
    public SqmPredicate visitWhereClause(HqlParser.WhereClauseContext ctx) {
        if (ctx == null || ctx.predicate() == null) {
            return null;
        }
        return (SqmPredicate)ctx.predicate().accept(this);
    }

    @Override
    public SqmGroupedPredicate visitGroupedPredicate(HqlParser.GroupedPredicateContext ctx) {
        return new SqmGroupedPredicate((SqmPredicate)ctx.predicate().accept(this), this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmPredicate visitAndPredicate(HqlParser.AndPredicateContext ctx) {
        return this.junction(Predicate.BooleanOperator.AND, (SqmPredicate)ctx.predicate(0).accept(this), (SqmPredicate)ctx.predicate(1).accept(this));
    }

    @Override
    public SqmPredicate visitOrPredicate(HqlParser.OrPredicateContext ctx) {
        return this.junction(Predicate.BooleanOperator.OR, (SqmPredicate)ctx.predicate(0).accept(this), (SqmPredicate)ctx.predicate(1).accept(this));
    }

    private SqmPredicate junction(Predicate.BooleanOperator operator, SqmPredicate lhs, SqmPredicate rhs) {
        SqmJunctionPredicate junction;
        if (lhs instanceof SqmJunctionPredicate && (junction = (SqmJunctionPredicate)lhs).getOperator() == operator) {
            junction.getPredicates().add(rhs);
            return junction;
        }
        if (rhs instanceof SqmJunctionPredicate && (junction = (SqmJunctionPredicate)rhs).getOperator() == operator) {
            junction.getPredicates().add(0, lhs);
            return junction;
        }
        return new SqmJunctionPredicate(operator, lhs, rhs, this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmPredicate visitNegatedPredicate(HqlParser.NegatedPredicateContext ctx) {
        SqmPredicate predicate = (SqmPredicate)ctx.predicate().accept(this);
        if (predicate instanceof SqmNegatablePredicate) {
            ((SqmNegatablePredicate)predicate).negate();
            return predicate;
        }
        return new SqmNegatedPredicate(predicate, this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmBetweenPredicate visitBetweenPredicate(HqlParser.BetweenPredicateContext ctx) {
        return new SqmBetweenPredicate((SqmExpression)ctx.expression(0).accept(this), (SqmExpression)ctx.expression(1).accept(this), (SqmExpression)ctx.expression(2).accept(this), ctx.NOT() != null, this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmNullnessPredicate visitIsNullPredicate(HqlParser.IsNullPredicateContext ctx) {
        return new SqmNullnessPredicate((SqmExpression)ctx.expression().accept(this), ctx.NOT() != null, this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmEmptinessPredicate visitIsEmptyPredicate(HqlParser.IsEmptyPredicateContext ctx) {
        SqmExpression expression = (SqmExpression)ctx.expression().accept(this);
        if (expression instanceof SqmPluralValuedSimplePath) {
            return new SqmEmptinessPredicate((SqmPluralValuedSimplePath)expression, ctx.NOT() != null, this.creationContext.getNodeBuilder());
        }
        throw new SemanticException("Operand of 'is empty' operator must be a plural path");
    }

    @Override
    public Object visitIsTruePredicate(HqlParser.IsTruePredicateContext ctx) {
        return new SqmTruthnessPredicate((SqmExpression)ctx.expression().accept(this), true, ctx.NOT() != null, this.creationContext.getNodeBuilder());
    }

    @Override
    public Object visitIsFalsePredicate(HqlParser.IsFalsePredicateContext ctx) {
        return new SqmTruthnessPredicate((SqmExpression)ctx.expression().accept(this), false, ctx.NOT() != null, this.creationContext.getNodeBuilder());
    }

    @Override
    public Object visitComparisonOperator(HqlParser.ComparisonOperatorContext ctx) {
        TerminalNode firstToken = (TerminalNode)ctx.getChild(0);
        switch (firstToken.getSymbol().getType()) {
            case 16: {
                return ComparisonOperator.EQUAL;
            }
            case 17: {
                return ComparisonOperator.NOT_EQUAL;
            }
            case 20: {
                return ComparisonOperator.LESS_THAN;
            }
            case 21: {
                return ComparisonOperator.LESS_THAN_OR_EQUAL;
            }
            case 18: {
                return ComparisonOperator.GREATER_THAN;
            }
            case 19: {
                return ComparisonOperator.GREATER_THAN_OR_EQUAL;
            }
        }
        throw new ParsingException("Unrecognized comparison operator");
    }

    @Override
    public SqmPredicate visitComparisonPredicate(HqlParser.ComparisonPredicateContext ctx) {
        ComparisonOperator comparisonOperator = (ComparisonOperator)((Object)ctx.comparisonOperator().accept(this));
        HqlParser.ExpressionContext leftExpressionContext = ctx.expression(0);
        HqlParser.ExpressionContext rightExpressionContext = ctx.expression(1);
        return this.createComparisonPredicate(comparisonOperator, leftExpressionContext, rightExpressionContext);
    }

    @Override
    public SqmPredicate visitIsDistinctFromPredicate(HqlParser.IsDistinctFromPredicateContext ctx) {
        HqlParser.ExpressionContext leftExpressionContext = ctx.expression(0);
        HqlParser.ExpressionContext rightExpressionContext = ctx.expression(1);
        ComparisonOperator comparisonOperator = ctx.NOT() == null ? ComparisonOperator.DISTINCT_FROM : ComparisonOperator.NOT_DISTINCT_FROM;
        return this.createComparisonPredicate(comparisonOperator, leftExpressionContext, rightExpressionContext);
    }

    private SqmComparisonPredicate createComparisonPredicate(ComparisonOperator comparisonOperator, HqlParser.ExpressionContext leftExpressionContext, HqlParser.ExpressionContext rightExpressionContext) {
        SqmExpression left;
        SqmExpression right;
        Map<Class<?>, Enum<?>> possibleEnumValues = this.getPossibleEnumValues(leftExpressionContext);
        if (possibleEnumValues != null) {
            right = (SqmExpression)rightExpressionContext.accept(this);
            left = this.resolveEnumShorthandLiteral(leftExpressionContext, possibleEnumValues, right.getJavaType());
        } else {
            possibleEnumValues = this.getPossibleEnumValues(rightExpressionContext);
            if (possibleEnumValues != null) {
                left = (SqmExpression)leftExpressionContext.accept(this);
                right = this.resolveEnumShorthandLiteral(rightExpressionContext, possibleEnumValues, left.getJavaType());
            } else {
                SqmExpression l = (SqmExpression)leftExpressionContext.accept(this);
                SqmExpression r = (SqmExpression)rightExpressionContext.accept(this);
                if (l instanceof AnyDiscriminatorSqmPath && r instanceof SqmLiteralEntityType) {
                    left = l;
                    right = this.createDiscriminatorValue((AnyDiscriminatorSqmPath)left, rightExpressionContext);
                } else if (r instanceof AnyDiscriminatorSqmPath && l instanceof SqmLiteralEntityType) {
                    left = this.createDiscriminatorValue((AnyDiscriminatorSqmPath)r, leftExpressionContext);
                    right = r;
                } else {
                    left = l;
                    right = r;
                }
            }
        }
        return new SqmComparisonPredicate(left, comparisonOperator, right, this.creationContext.getNodeBuilder());
    }

    private <T> SqmExpression<T> createDiscriminatorValue(AnyDiscriminatorSqmPath<T> anyDiscriminatorTypeSqmPath, HqlParser.ExpressionContext valueExpressionContext) {
        return new SqmAnyDiscriminatorValue(anyDiscriminatorTypeSqmPath.getNodeType().getPathName(), this.creationContext.getJpaMetamodel().resolveHqlEntityReference(valueExpressionContext.getText()), ((AnyDiscriminatorSqmPathSource)anyDiscriminatorTypeSqmPath.getExpressible()).getSqmPathType(), this.creationContext.getNodeBuilder());
    }

    private SqmExpression<?> resolveEnumShorthandLiteral(HqlParser.ExpressionContext expressionContext, Map<Class<?>, Enum<?>> possibleEnumValues, Class<?> enumType) {
        Enum<?> enumValue;
        if (possibleEnumValues != null && (enumValue = possibleEnumValues.get(enumType)) != null) {
            DotIdentifierConsumer dotIdentifierConsumer = this.dotIdentifierConsumerStack.getCurrent();
            dotIdentifierConsumer.consumeIdentifier(enumValue.getClass().getName(), true, false);
            dotIdentifierConsumer.consumeIdentifier(enumValue.name(), false, true);
            return (SqmExpression)((Object)this.dotIdentifierConsumerStack.getCurrent().getConsumedPart());
        }
        return (SqmExpression)expressionContext.accept(this);
    }

    private Map<Class<?>, Enum<?>> getPossibleEnumValues(HqlParser.ExpressionContext expressionContext) {
        if (expressionContext instanceof HqlParser.BarePrimaryExpressionContext && expressionContext.getChildCount() == 1) {
            ParseTree ctx = expressionContext.getChild(0);
            while (ctx instanceof HqlParser.PrimaryExpressionContext && ctx.getChildCount() == 1) {
                ctx = ctx.getChild(0);
            }
            if (ctx instanceof HqlParser.GeneralPathFragmentContext && ctx.getChildCount() == 1 && (ctx = ctx.getChild(0)) instanceof HqlParser.SimplePathContext) {
                return this.creationContext.getJpaMetamodel().getAllowedEnumLiteralTexts().get(ctx.getText());
            }
        }
        return null;
    }

    @Override
    public SqmPredicate visitLikePredicate(HqlParser.LikePredicateContext ctx) {
        boolean caseSensitive;
        boolean negated = ctx.NOT() != null;
        boolean bl = caseSensitive = ctx.LIKE() != null;
        if (ctx.likeEscape() == null) {
            return new SqmLikePredicate((SqmExpression)ctx.expression(0).accept(this), (SqmExpression)ctx.expression(1).accept(this), negated, caseSensitive, this.creationContext.getNodeBuilder());
        }
        return new SqmLikePredicate((SqmExpression)ctx.expression(0).accept(this), (SqmExpression)ctx.expression(1).accept(this), (SqmExpression)ctx.likeEscape().accept(this), negated, caseSensitive, this.creationContext.getNodeBuilder());
    }

    @Override
    public Object visitLikeEscape(HqlParser.LikeEscapeContext ctx) {
        HqlParser.ParameterContext parameter = ctx.parameter();
        if (parameter instanceof HqlParser.NamedParameterContext) {
            return this.visitNamedParameter((HqlParser.NamedParameterContext)parameter, this.creationContext.getNodeBuilder().getCharacterType());
        }
        if (parameter instanceof HqlParser.PositionalParameterContext) {
            return this.visitPositionalParameter((HqlParser.PositionalParameterContext)parameter, this.creationContext.getNodeBuilder().getCharacterType());
        }
        TerminalNode terminalNode = (TerminalNode)ctx.getChild(1);
        String escape = QuotingHelper.unquoteStringLiteral(terminalNode.getText());
        if (escape.length() != 1) {
            throw new SemanticException("Escape character literals must have exactly a single character, but found: " + escape);
        }
        return new SqmLiteral<Character>(Character.valueOf(escape.charAt(0)), this.creationContext.getNodeBuilder().getCharacterType(), this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmPredicate visitMemberOfPredicate(HqlParser.MemberOfPredicateContext ctx) {
        boolean negated = ctx.NOT() != null;
        SqmPath<?> sqmPluralPath = this.consumeDomainPath(ctx.path());
        if (sqmPluralPath instanceof SqmPluralValuedSimplePath) {
            return new SqmMemberOfPredicate((SqmExpression)ctx.expression().accept(this), (SqmPluralValuedSimplePath)sqmPluralPath, negated, this.creationContext.getNodeBuilder());
        }
        throw new SemanticException("Operand of 'member of' operator must be a plural path");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqmPredicate visitInPredicate(HqlParser.InPredicateContext ctx) {
        boolean negated = ctx.getChildCount() == 4;
        SqmExpression testExpression = (SqmExpression)ctx.expression().accept(this);
        HqlParser.InListContext inListContext = ctx.inList();
        if (inListContext instanceof HqlParser.ExplicitTupleInListContext) {
            HqlParser.ExplicitTupleInListContext tupleExpressionListContext = (HqlParser.ExplicitTupleInListContext)inListContext;
            int size = tupleExpressionListContext.getChildCount();
            int estimatedSize = size >> 1;
            Class testExpressionJavaType = testExpression.getJavaType();
            boolean isEnum = testExpressionJavaType != null && testExpressionJavaType.isEnum();
            this.parameterDeclarationContextStack.push(() -> size == 3);
            try {
                ArrayList<SqmExpression> listExpressions = new ArrayList<SqmExpression>(estimatedSize);
                for (int i = 1; i < size; ++i) {
                    HqlParser.ExpressionContext expressionContext;
                    Map<Class<?>, Enum<?>> possibleEnumValues;
                    ParseTree parseTree = tupleExpressionListContext.getChild(i);
                    if (!(parseTree instanceof HqlParser.ExpressionOrPredicateContext)) continue;
                    ParseTree child = parseTree.getChild(0);
                    if (isEnum && child instanceof HqlParser.ExpressionContext && (possibleEnumValues = this.getPossibleEnumValues(expressionContext = (HqlParser.ExpressionContext)child)) != null) {
                        listExpressions.add(this.resolveEnumShorthandLiteral(expressionContext, possibleEnumValues, testExpressionJavaType));
                        continue;
                    }
                    listExpressions.add((SqmExpression)child.accept((ParseTreeVisitor)this));
                }
                SqmInListPredicate sqmInListPredicate = new SqmInListPredicate(testExpression, listExpressions, negated, this.creationContext.getNodeBuilder());
                return sqmInListPredicate;
            }
            finally {
                this.parameterDeclarationContextStack.pop();
            }
        }
        if (inListContext instanceof HqlParser.ParamInListContext) {
            HqlParser.ParamInListContext tupleExpressionListContext = (HqlParser.ParamInListContext)inListContext;
            this.parameterDeclarationContextStack.push(() -> true);
            try {
                SqmInListPredicate size = new SqmInListPredicate(testExpression, Collections.singletonList(tupleExpressionListContext.parameter().accept(this)), negated, this.creationContext.getNodeBuilder());
                return size;
            }
            finally {
                this.parameterDeclarationContextStack.pop();
            }
        }
        if (inListContext instanceof HqlParser.SubqueryInListContext) {
            HqlParser.SubqueryInListContext subQueryOrParamInListContext = (HqlParser.SubqueryInListContext)inListContext;
            Object subquery = this.visitSubquery(subQueryOrParamInListContext.subquery());
            return new SqmInSubQueryPredicate(testExpression, subquery, negated, this.creationContext.getNodeBuilder());
        }
        if (inListContext instanceof HqlParser.PersistentCollectionReferenceInListContext) {
            if (this.getCreationOptions().useStrictJpaCompliance()) {
                throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.HQL_COLLECTION_FUNCTION);
            }
            HqlParser.PersistentCollectionReferenceInListContext collectionReferenceInListContext = (HqlParser.PersistentCollectionReferenceInListContext)inListContext;
            return new SqmInSubQueryPredicate(testExpression, this.createCollectionReferenceSubQuery(collectionReferenceInListContext.simplePath(), (TerminalNode)collectionReferenceInListContext.collectionQuantifier().getChild(0).getChild(0)), negated, this.creationContext.getNodeBuilder());
        }
        throw new ParsingException("Unexpected IN predicate type [" + ((Object)((Object)ctx)).getClass().getSimpleName() + "] : " + ctx.getText());
    }

    @Override
    public SqmPredicate visitExistsCollectionPartPredicate(HqlParser.ExistsCollectionPartPredicateContext ctx) {
        SqmSubQuery subQuery = this.createCollectionReferenceSubQuery(ctx.simplePath(), null);
        return new SqmExistsPredicate(subQuery, this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmPredicate visitExistsPredicate(HqlParser.ExistsPredicateContext ctx) {
        SqmExpression expression = (SqmExpression)ctx.expression().accept(this);
        return new SqmExistsPredicate(expression, this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmPredicate visitBooleanExpressionPredicate(HqlParser.BooleanExpressionPredicateContext ctx) {
        SqmExpression expression = (SqmExpression)ctx.expression().accept(this);
        if (expression.getJavaType() != Boolean.class) {
            throw new SemanticException("Non-boolean expression used in predicate context: " + ctx.getText());
        }
        SqmExpression booleanExpression = expression;
        return new SqmBooleanExpressionPredicate(booleanExpression, this.creationContext.getNodeBuilder());
    }

    @Override
    public Object visitEntityTypeExpression(HqlParser.EntityTypeExpressionContext ctx) {
        HqlParser.EntityTypeReferenceContext entityTypeReferenceContext = ctx.entityTypeReference();
        HqlParser.ParameterContext parameter = entityTypeReferenceContext.parameter();
        HqlParser.PathContext path = entityTypeReferenceContext.path();
        if (parameter != null) {
            return new SqmParameterizedEntityType((SqmParameter)parameter.accept(this), this.creationContext.getNodeBuilder());
        }
        if (path != null) {
            SqmPath sqmPath = (SqmPath)path.accept(this);
            return sqmPath.type();
        }
        throw new ParsingException("Could not interpret grammar context as entity type expression: " + ctx.getText());
    }

    @Override
    public SqmExpression<?> visitEntityIdExpression(HqlParser.EntityIdExpressionContext ctx) {
        return this.visitEntityIdReference(ctx.entityIdReference());
    }

    @Override
    public SqmPath<?> visitEntityIdReference(HqlParser.EntityIdReferenceContext ctx) {
        if (ctx.pathContinuation() != null) {
            throw new UnsupportedOperationException("Path continuation from 'id()' reference not yet implemented");
        }
        SqmPath<?> sqmPath = this.consumeDomainPath(ctx.path());
        DomainType<?> sqmPathType = sqmPath.getReferencedPathSource().getSqmPathType();
        if (sqmPathType instanceof IdentifiableDomainType) {
            SqmPathSource<?> identifierDescriptor = ((IdentifiableDomainType)sqmPathType).getIdentifierDescriptor();
            return sqmPath.get(identifierDescriptor.getPathName());
        }
        if (sqmPath instanceof SqmAnyValuedSimplePath) {
            return sqmPath.resolvePathPart("{key}", true, this.processingStateStack.getCurrent().getCreationState());
        }
        throw new FunctionArgumentException("Argument '" + sqmPath.getNavigablePath() + "' of 'id()' function does not resolve to an entity type");
    }

    @Override
    public SqmExpression<?> visitEntityVersionExpression(HqlParser.EntityVersionExpressionContext ctx) {
        return this.visitEntityVersionReference(ctx.entityVersionReference());
    }

    @Override
    public SqmPath<?> visitEntityVersionReference(HqlParser.EntityVersionReferenceContext ctx) {
        SqmPath<?> sqmPath = this.consumeDomainPath(ctx.path());
        DomainType<?> sqmPathType = sqmPath.getReferencedPathSource().getSqmPathType();
        if (sqmPathType instanceof IdentifiableDomainType) {
            IdentifiableDomainType identifiableType = (IdentifiableDomainType)sqmPathType;
            SingularPersistentAttribute versionAttribute = identifiableType.findVersionAttribute();
            if (versionAttribute == null) {
                throw new FunctionArgumentException(String.format("Argument '%s' of 'version()' function resolved to entity type '%s' which does not have a '@Version' attribute", sqmPath.getNavigablePath(), identifiableType.getTypeName()));
            }
            return sqmPath.get(versionAttribute);
        }
        throw new FunctionArgumentException("Argument '" + sqmPath.getNavigablePath() + "' of 'version()' function does not resolve to an entity type");
    }

    @Override
    public SqmPath<?> visitEntityNaturalIdExpression(HqlParser.EntityNaturalIdExpressionContext ctx) {
        return this.visitEntityNaturalIdReference(ctx.entityNaturalIdReference());
    }

    @Override
    public SqmPath<?> visitEntityNaturalIdReference(HqlParser.EntityNaturalIdReferenceContext ctx) {
        if (ctx.pathContinuation() != null) {
            throw new UnsupportedOperationException("Path continuation from 'naturalid()' reference not yet implemented");
        }
        SqmPath<?> sqmPath = this.consumeDomainPath(ctx.path());
        DomainType<?> sqmPathType = sqmPath.getReferencedPathSource().getSqmPathType();
        if (sqmPathType instanceof IdentifiableDomainType) {
            IdentifiableDomainType identifiableType = (IdentifiableDomainType)sqmPathType;
            List attributes = identifiableType.findNaturalIdAttributes();
            if (attributes == null) {
                throw new FunctionArgumentException(String.format("Argument '%s' of 'naturalid()' function resolved to entity type '%s' which does not have a natural id", sqmPath.getNavigablePath(), identifiableType.getTypeName()));
            }
            if (attributes.size() > 1) {
                throw new FunctionArgumentException(String.format("Argument '%s' of 'naturalid()' function resolved to entity type '%s' which has a composite natural id", sqmPath.getNavigablePath(), identifiableType.getTypeName()));
            }
            SingularAttribute naturalIdAttribute = (SingularAttribute)attributes.get(0);
            return sqmPath.get(naturalIdAttribute);
        }
        throw new FunctionArgumentException("Argument '" + sqmPath.getNavigablePath() + "' of 'naturalid()' function does not resolve to an entity type");
    }

    @Override
    public Object visitToOneFkExpression(HqlParser.ToOneFkExpressionContext ctx) {
        return this.visitToOneFkReference((HqlParser.ToOneFkReferenceContext)ctx.getChild(0));
    }

    @Override
    public SqmFkExpression<?> visitToOneFkReference(HqlParser.ToOneFkReferenceContext ctx) {
        boolean validToOneRef;
        SqmPath<?> sqmPath = this.consumeDomainPath((HqlParser.PathContext)ctx.getChild(2));
        SqmPathSource<?> toOneReference = sqmPath.getReferencedPathSource();
        boolean bl = validToOneRef = toOneReference.getBindableType() == Bindable.BindableType.SINGULAR_ATTRIBUTE && toOneReference instanceof EntitySqmPathSource;
        if (!validToOneRef) {
            throw new FunctionArgumentException(String.format(Locale.ROOT, "Argument '%s' of 'fk()' function is not a single-valued association", sqmPath.getNavigablePath()));
        }
        return new SqmFkExpression((SqmEntityValuedSimplePath)sqmPath, this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmMapEntryReference<?, ?> visitMapEntrySelection(HqlParser.MapEntrySelectionContext ctx) {
        return new SqmMapEntryReference(this.consumePluralAttributeReference(ctx.path()), this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmExpression<?> visitConcatenationExpression(HqlParser.ConcatenationExpressionContext ctx) {
        if (ctx.getChildCount() != 3) {
            throw new SyntaxException("Expecting two operands to the '||' operator");
        }
        return this.getFunctionDescriptor("concat").generateSqmExpression(Arrays.asList((SqmExpression)ctx.expression(0).accept(this), (SqmExpression)ctx.expression(1).accept(this)), null, this.creationContext.getQueryEngine());
    }

    @Override
    public Object visitSignOperator(HqlParser.SignOperatorContext ctx) {
        switch (((TerminalNode)ctx.getChild(0)).getSymbol().getType()) {
            case 30: {
                return UnaryArithmeticOperator.UNARY_PLUS;
            }
            case 31: {
                return UnaryArithmeticOperator.UNARY_MINUS;
            }
        }
        throw new ParsingException("Unrecognized sign operator");
    }

    @Override
    public Object visitAdditiveOperator(HqlParser.AdditiveOperatorContext ctx) {
        switch (((TerminalNode)ctx.getChild(0)).getSymbol().getType()) {
            case 30: {
                return BinaryArithmeticOperator.ADD;
            }
            case 31: {
                return BinaryArithmeticOperator.SUBTRACT;
            }
        }
        throw new ParsingException("Unrecognized additive operator");
    }

    @Override
    public Object visitMultiplicativeOperator(HqlParser.MultiplicativeOperatorContext ctx) {
        switch (((TerminalNode)ctx.getChild(0)).getSymbol().getType()) {
            case 32: {
                return BinaryArithmeticOperator.MULTIPLY;
            }
            case 33: {
                return BinaryArithmeticOperator.DIVIDE;
            }
            case 34: {
                return BinaryArithmeticOperator.MODULO;
            }
        }
        throw new ParsingException("Unrecognized multiplicative operator");
    }

    @Override
    public Object visitAdditionExpression(HqlParser.AdditionExpressionContext ctx) {
        if (ctx.getChildCount() != 3) {
            throw new SyntaxException("Expecting two operands to the additive operator");
        }
        SqmExpression left = (SqmExpression)ctx.expression(0).accept(this);
        SqmExpression right = (SqmExpression)ctx.expression(1).accept(this);
        BinaryArithmeticOperator operator = (BinaryArithmeticOperator)((Object)ctx.additiveOperator().accept(this));
        TypecheckUtil.assertOperable(left, right, operator);
        return new SqmBinaryArithmetic(operator, left, right, this.creationContext.getJpaMetamodel(), this.creationContext.getNodeBuilder());
    }

    @Override
    public Object visitMultiplicationExpression(HqlParser.MultiplicationExpressionContext ctx) {
        if (ctx.getChildCount() != 3) {
            throw new SyntaxException("Expecting two operands to the multiplicative operator");
        }
        SqmExpression left = (SqmExpression)ctx.expression(0).accept(this);
        SqmExpression right = (SqmExpression)ctx.expression(1).accept(this);
        BinaryArithmeticOperator operator = (BinaryArithmeticOperator)((Object)ctx.multiplicativeOperator().accept(this));
        TypecheckUtil.assertOperable(left, right, operator);
        if (operator == BinaryArithmeticOperator.MODULO) {
            return this.getFunctionDescriptor("mod").generateSqmExpression(Arrays.asList(left, right), null, this.creationContext.getQueryEngine());
        }
        return new SqmBinaryArithmetic(operator, left, right, this.creationContext.getJpaMetamodel(), this.creationContext.getNodeBuilder());
    }

    @Override
    public Object visitToDurationExpression(HqlParser.ToDurationExpressionContext ctx) {
        return new SqmToDuration<Duration>((SqmExpression)ctx.expression().accept(this), this.toDurationUnit((SqmExtractUnit)ctx.datetimeField().accept(this)), this.resolveExpressibleTypeBasic(Duration.class), this.creationContext.getNodeBuilder());
    }

    private SqmDurationUnit<Long> toDurationUnit(SqmExtractUnit<?> extractUnit) {
        return new SqmDurationUnit<Long>(extractUnit.getUnit(), this.resolveExpressibleTypeBasic(Long.class), this.creationContext.getNodeBuilder());
    }

    @Override
    public Object visitFromDurationExpression(HqlParser.FromDurationExpressionContext ctx) {
        SqmExpression expression = (SqmExpression)ctx.expression().accept(this);
        TypecheckUtil.assertDuration(expression);
        return new SqmByUnit(this.toDurationUnit((SqmExtractUnit)ctx.datetimeField().accept(this)), expression, this.resolveExpressibleTypeBasic(Long.class), this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmUnaryOperation<?> visitUnaryExpression(HqlParser.UnaryExpressionContext ctx) {
        SqmExpression expression = (SqmExpression)ctx.expression().accept(this);
        UnaryArithmeticOperator operator = (UnaryArithmeticOperator)((Object)ctx.signOperator().accept(this));
        TypecheckUtil.assertNumeric(expression, operator);
        return new SqmUnaryOperation(operator, expression);
    }

    @Override
    public Object visitGroupedExpression(HqlParser.GroupedExpressionContext ctx) {
        return ctx.getChild(1).accept((ParseTreeVisitor)this);
    }

    @Override
    public Object visitCollateFunction(HqlParser.CollateFunctionContext ctx) {
        if (this.creationOptions.useStrictJpaCompliance()) {
            throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.COLLATIONS);
        }
        SqmExpression expressionToCollate = (SqmExpression)ctx.expression().accept(this);
        SqmCollation castTargetExpression = (SqmCollation)ctx.collation().accept(this);
        return this.getFunctionDescriptor("collate").generateSqmExpression(Arrays.asList(expressionToCollate, castTargetExpression), null, this.creationContext.getQueryEngine());
    }

    @Override
    public Object visitCollation(HqlParser.CollationContext ctx) {
        return new SqmCollation(ctx.simplePath().getText(), null, this.creationContext.getNodeBuilder());
    }

    @Override
    public Object visitTupleExpression(HqlParser.TupleExpressionContext ctx) {
        if (this.creationOptions.useStrictJpaCompliance()) {
            throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.TUPLES);
        }
        List<SqmExpression<?>> expressions = this.visitExpressions(ctx);
        return new SqmTuple(expressions, this.creationContext.getNodeBuilder());
    }

    private List<SqmExpression<?>> visitExpressions(ParserRuleContext parentContext) {
        int size = parentContext.getChildCount();
        int estimateExpressionsCount = (size >> 1) - 1;
        ArrayList expressions = new ArrayList(estimateExpressionsCount);
        for (int i = 0; i < size; ++i) {
            ParseTree parseTree = parentContext.getChild(i);
            if (!(parseTree instanceof HqlParser.ExpressionOrPredicateContext)) continue;
            expressions.add((SqmExpression)parseTree.accept((ParseTreeVisitor)this));
        }
        return expressions;
    }

    @Override
    public Object visitCaseExpression(HqlParser.CaseExpressionContext ctx) {
        return ctx.getChild(0).accept((ParseTreeVisitor)this);
    }

    @Override
    public SqmCaseSimple<?, ?> visitSimpleCaseList(HqlParser.SimpleCaseListContext ctx) {
        int size = ctx.simpleCaseWhen().size();
        SqmCaseSimple caseExpression = new SqmCaseSimple((SqmExpression)ctx.expressionOrPredicate().accept(this), size, this.creationContext.getNodeBuilder());
        for (int i = 0; i < size; ++i) {
            HqlParser.SimpleCaseWhenContext simpleCaseWhenContext = ctx.simpleCaseWhen(i);
            caseExpression.when((SqmExpression)simpleCaseWhenContext.expression().accept(this), (SqmExpression)simpleCaseWhenContext.expressionOrPredicate().accept(this));
        }
        HqlParser.CaseOtherwiseContext caseOtherwiseContext = ctx.caseOtherwise();
        if (caseOtherwiseContext != null) {
            caseExpression.otherwise((SqmExpression)caseOtherwiseContext.expressionOrPredicate().accept(this));
        }
        return caseExpression;
    }

    @Override
    public SqmCaseSearched<?> visitSearchedCaseList(HqlParser.SearchedCaseListContext ctx) {
        int size = ctx.searchedCaseWhen().size();
        SqmCaseSearched caseExpression = new SqmCaseSearched(size, this.creationContext.getNodeBuilder());
        for (int i = 0; i < size; ++i) {
            HqlParser.SearchedCaseWhenContext searchedCaseWhenContext = ctx.searchedCaseWhen(i);
            caseExpression.when((SqmPredicate)searchedCaseWhenContext.predicate().accept(this), (SqmExpression)searchedCaseWhenContext.expressionOrPredicate().accept(this));
        }
        HqlParser.CaseOtherwiseContext caseOtherwiseContext = ctx.caseOtherwise();
        if (caseOtherwiseContext != null) {
            caseExpression.otherwise((SqmExpression)caseOtherwiseContext.expressionOrPredicate().accept(this));
        }
        return caseExpression;
    }

    @Override
    public SqmExpression<?> visitCurrentDateFunction(HqlParser.CurrentDateFunctionContext ctx) {
        return this.getFunctionDescriptor("current_date").generateSqmExpression(this.resolveExpressibleTypeBasic(Date.class), this.creationContext.getQueryEngine());
    }

    @Override
    public SqmExpression<?> visitCurrentTimeFunction(HqlParser.CurrentTimeFunctionContext ctx) {
        return this.getFunctionDescriptor("current_time").generateSqmExpression(this.resolveExpressibleTypeBasic(Time.class), this.creationContext.getQueryEngine());
    }

    @Override
    public SqmExpression<?> visitCurrentTimestampFunction(HqlParser.CurrentTimestampFunctionContext ctx) {
        return this.getFunctionDescriptor("current_timestamp").generateSqmExpression(this.resolveExpressibleTypeBasic(Timestamp.class), this.creationContext.getQueryEngine());
    }

    @Override
    public SqmExpression<?> visitInstantFunction(HqlParser.InstantFunctionContext ctx) {
        return this.getFunctionDescriptor("instant").generateSqmExpression(this.resolveExpressibleTypeBasic(Instant.class), this.creationContext.getQueryEngine());
    }

    @Override
    public SqmExpression<?> visitLocalDateFunction(HqlParser.LocalDateFunctionContext ctx) {
        return this.getFunctionDescriptor("local_date").generateSqmExpression(this.resolveExpressibleTypeBasic(LocalDate.class), this.creationContext.getQueryEngine());
    }

    @Override
    public SqmExpression<?> visitLocalTimeFunction(HqlParser.LocalTimeFunctionContext ctx) {
        return this.getFunctionDescriptor("local_time").generateSqmExpression(this.resolveExpressibleTypeBasic(LocalTime.class), this.creationContext.getQueryEngine());
    }

    @Override
    public SqmExpression<?> visitLocalDateTimeFunction(HqlParser.LocalDateTimeFunctionContext ctx) {
        return this.getFunctionDescriptor("local_datetime").generateSqmExpression(this.resolveExpressibleTypeBasic(LocalDateTime.class), this.creationContext.getQueryEngine());
    }

    @Override
    public SqmExpression<?> visitOffsetDateTimeFunction(HqlParser.OffsetDateTimeFunctionContext ctx) {
        return this.getFunctionDescriptor("offset_datetime").generateSqmExpression(this.resolveExpressibleTypeBasic(OffsetDateTime.class), this.creationContext.getQueryEngine());
    }

    @Override
    public SqmExpression<?> visitLiteralExpression(HqlParser.LiteralExpressionContext ctx) {
        return (SqmExpression)ctx.getChild(0).accept((ParseTreeVisitor)this);
    }

    @Override
    public SqmExpression<?> visitUnaryNumericLiteralExpression(HqlParser.UnaryNumericLiteralExpressionContext ctx) {
        TerminalNode node = (TerminalNode)ctx.getChild(1).getChild(0);
        Object text = ((TerminalNode)ctx.getChild(0).getChild(0)).getSymbol().getType() == 31 ? "-" + node.getText() : node.getText();
        switch (node.getSymbol().getType()) {
            case 3: {
                return this.integerLiteral((String)text);
            }
            case 4: {
                return this.longLiteral((String)text);
            }
            case 7: {
                return this.bigIntegerLiteral((String)text);
            }
            case 9: {
                return this.hexLiteral((String)text);
            }
            case 5: {
                return this.floatLiteral((String)text);
            }
            case 6: {
                return this.doubleLiteral((String)text);
            }
            case 8: {
                return this.bigDecimalLiteral((String)text);
            }
        }
        throw new ParsingException("Unexpected terminal node [" + (String)text + "]");
    }

    @Override
    public Object visitBinaryLiteral(HqlParser.BinaryLiteralContext ctx) {
        TerminalNode firstNode = (TerminalNode)ctx.getChild(0);
        if (firstNode.getSymbol().getType() == 12) {
            return this.binaryLiteral(firstNode.getText());
        }
        StringBuilder text = new StringBuilder("x'");
        int size = ctx.getChildCount();
        for (int i = 0; i < size; ++i) {
            TerminalNode hex = (TerminalNode)ctx.getChild(i);
            if (hex.getSymbol().getType() != 9) continue;
            String hexText = hex.getText();
            if (hexText.length() != 4) {
                throw new LiteralNumberFormatException("not a byte: " + hexText);
            }
            text.append(hexText, 2, hexText.length());
        }
        return this.binaryLiteral(text.append("'").toString());
    }

    @Override
    public Object visitGeneralizedLiteral(HqlParser.GeneralizedLiteralContext ctx) {
        throw new UnsupportedOperationException();
    }

    public SqmExpression<?> visitTerminal(TerminalNode node) {
        if (node.getSymbol().getType() == -1) {
            return null;
        }
        switch (node.getSymbol().getType()) {
            case 10: {
                return this.stringLiteral(node.getText());
            }
            case 11: {
                return this.javaStringLiteral(node.getText());
            }
            case 3: {
                return this.integerLiteral(node.getText());
            }
            case 4: {
                return this.longLiteral(node.getText());
            }
            case 7: {
                return this.bigIntegerLiteral(node.getText());
            }
            case 9: {
                return this.hexLiteral(node.getText());
            }
            case 5: {
                return this.floatLiteral(node.getText());
            }
            case 6: {
                return this.doubleLiteral(node.getText());
            }
            case 8: {
                return this.bigDecimalLiteral(node.getText());
            }
            case 211: {
                return this.booleanLiteral(false);
            }
            case 210: {
                return this.booleanLiteral(true);
            }
            case 212: {
                return new SqmLiteralNull(this.creationContext.getNodeBuilder());
            }
            case 12: {
                return this.binaryLiteral(node.getText());
            }
        }
        throw new ParsingException("Unexpected terminal node [" + node.getText() + "]");
    }

    @Override
    public Object visitDateTimeLiteral(HqlParser.DateTimeLiteralContext ctx) {
        return ctx.getChild(0).accept((ParseTreeVisitor)this);
    }

    @Override
    public Object visitLocalDateTimeLiteral(HqlParser.LocalDateTimeLiteralContext ctx) {
        return ctx.localDateTime().accept(this);
    }

    @Override
    public Object visitZonedDateTimeLiteral(HqlParser.ZonedDateTimeLiteralContext ctx) {
        return ctx.zonedDateTime().accept(this);
    }

    @Override
    public Object visitOffsetDateTimeLiteral(HqlParser.OffsetDateTimeLiteralContext ctx) {
        if (ctx.offsetDateTime() != null) {
            return ctx.offsetDateTime().accept(this);
        }
        if (ctx.offsetDateTimeWithMinutes() != null) {
            return ctx.offsetDateTimeWithMinutes().accept(this);
        }
        return null;
    }

    @Override
    public Object visitDateLiteral(HqlParser.DateLiteralContext ctx) {
        return ctx.getChild(1).accept((ParseTreeVisitor)this);
    }

    @Override
    public Object visitTimeLiteral(HqlParser.TimeLiteralContext ctx) {
        return ctx.getChild(1).accept((ParseTreeVisitor)this);
    }

    @Override
    public Object visitJdbcTimestampLiteral(HqlParser.JdbcTimestampLiteralContext ctx) {
        ParseTree parseTree = ctx.getChild(1);
        if (parseTree instanceof HqlParser.DateTimeContext) {
            return parseTree.accept((ParseTreeVisitor)this);
        }
        return this.sqlTimestampLiteralFrom(parseTree.getText());
    }

    @Override
    public Object visitJdbcDateLiteral(HqlParser.JdbcDateLiteralContext ctx) {
        ParseTree parseTree = ctx.getChild(1);
        if (parseTree instanceof HqlParser.DateContext) {
            return parseTree.accept((ParseTreeVisitor)this);
        }
        return this.sqlDateLiteralFrom(parseTree.getText());
    }

    @Override
    public Object visitJdbcTimeLiteral(HqlParser.JdbcTimeLiteralContext ctx) {
        ParseTree parseTree = ctx.getChild(1);
        if (parseTree instanceof HqlParser.TimeContext) {
            return parseTree.accept((ParseTreeVisitor)this);
        }
        return this.sqlTimeLiteralFrom(parseTree.getText());
    }

    @Override
    public Object visitDateTime(HqlParser.DateTimeContext ctx) {
        return ctx.getChild(0).accept((ParseTreeVisitor)this);
    }

    @Override
    public Object visitLocalDateTime(HqlParser.LocalDateTimeContext ctx) {
        return this.localDateTimeLiteralFrom(ctx.date(), ctx.time());
    }

    @Override
    public Object visitOffsetDateTime(HqlParser.OffsetDateTimeContext ctx) {
        return this.offsetDatetimeLiteralFrom(ctx.date(), ctx.time(), ctx.offset());
    }

    @Override
    public Object visitOffsetDateTimeWithMinutes(HqlParser.OffsetDateTimeWithMinutesContext ctx) {
        return this.offsetDatetimeLiteralFrom(ctx.date(), ctx.time(), ctx.offsetWithMinutes());
    }

    @Override
    public Object visitZonedDateTime(HqlParser.ZonedDateTimeContext ctx) {
        return this.zonedDateTimeLiteralFrom(ctx.date(), ctx.time(), ctx.zoneId());
    }

    private SqmLiteral<?> localDateTimeLiteralFrom(HqlParser.DateContext date, HqlParser.TimeContext time) {
        return new SqmLiteral<LocalDateTime>(LocalDateTime.of(SemanticQueryBuilder.localDate(date), SemanticQueryBuilder.localTime(time)), this.resolveExpressibleTypeBasic(LocalDateTime.class), this.creationContext.getNodeBuilder());
    }

    private SqmLiteral<?> zonedDateTimeLiteralFrom(HqlParser.DateContext date, HqlParser.TimeContext time, HqlParser.ZoneIdContext timezone) {
        return new SqmLiteral<ZonedDateTime>(ZonedDateTime.of(SemanticQueryBuilder.localDate(date), SemanticQueryBuilder.localTime(time), this.visitZoneId(timezone)), this.resolveExpressibleTypeBasic(ZonedDateTime.class), this.creationContext.getNodeBuilder());
    }

    @Override
    public ZoneId visitZoneId(HqlParser.ZoneIdContext ctx) {
        TerminalNode firstChild = (TerminalNode)ctx.getChild(0);
        String timezoneText = firstChild.getSymbol().getType() == 10 ? QuotingHelper.unquoteStringLiteral(ctx.getText()) : ctx.getText();
        String timezoneFullName = ZoneId.SHORT_IDS.get(timezoneText);
        if (timezoneFullName == null) {
            return ZoneId.of(timezoneText);
        }
        return ZoneId.of(timezoneFullName);
    }

    private SqmLiteral<?> offsetDatetimeLiteralFrom(HqlParser.DateContext date, HqlParser.TimeContext time, HqlParser.OffsetContext offset) {
        return new SqmLiteral<OffsetDateTime>(OffsetDateTime.of(SemanticQueryBuilder.localDate(date), SemanticQueryBuilder.localTime(time), SemanticQueryBuilder.zoneOffset(offset)), this.resolveExpressibleTypeBasic(OffsetDateTime.class), this.creationContext.getNodeBuilder());
    }

    private SqmLiteral<?> offsetDatetimeLiteralFrom(HqlParser.DateContext date, HqlParser.TimeContext time, HqlParser.OffsetWithMinutesContext offset) {
        return new SqmLiteral<OffsetDateTime>(OffsetDateTime.of(SemanticQueryBuilder.localDate(date), SemanticQueryBuilder.localTime(time), SemanticQueryBuilder.zoneOffset(offset)), this.resolveExpressibleTypeBasic(OffsetDateTime.class), this.creationContext.getNodeBuilder());
    }

    @Override
    public Object visitDate(HqlParser.DateContext ctx) {
        return new SqmLiteral<LocalDate>(SemanticQueryBuilder.localDate(ctx), this.resolveExpressibleTypeBasic(LocalDate.class), this.creationContext.getNodeBuilder());
    }

    @Override
    public Object visitTime(HqlParser.TimeContext ctx) {
        return new SqmLiteral<LocalTime>(SemanticQueryBuilder.localTime(ctx), this.resolveExpressibleTypeBasic(LocalTime.class), this.creationContext.getNodeBuilder());
    }

    private static LocalTime localTime(HqlParser.TimeContext ctx) {
        int hour = Integer.parseInt(ctx.hour().getText());
        int minute = Integer.parseInt(ctx.minute().getText());
        HqlParser.SecondContext secondContext = ctx.second();
        if (secondContext != null) {
            String secondText = secondContext.getText();
            int index = secondText.indexOf(46);
            if (index < 0) {
                return LocalTime.of(hour, minute, Integer.parseInt(secondText));
            }
            String secondFractions = secondText.substring(index + 1);
            return LocalTime.of(hour, minute, Integer.parseInt(secondText.substring(0, index)), Integer.parseInt(secondFractions) * (int)Math.pow(10.0, 9 - secondFractions.length()));
        }
        return LocalTime.of(hour, minute);
    }

    private static LocalDate localDate(HqlParser.DateContext ctx) {
        return LocalDate.of(Integer.parseInt(ctx.year().getText()), Integer.parseInt(ctx.month().getText()), Integer.parseInt(ctx.day().getText()));
    }

    private static ZoneOffset zoneOffset(HqlParser.OffsetContext offset) {
        int factor = ((TerminalNode)offset.getChild(0)).getSymbol().getType() == 30 ? 1 : -1;
        int hour = factor * Integer.parseInt(offset.hour().getText());
        if (offset.getChildCount() == 2) {
            return ZoneOffset.ofHours(hour);
        }
        return ZoneOffset.ofHoursMinutes(hour, factor * Integer.parseInt(offset.minute().getText()));
    }

    private static ZoneOffset zoneOffset(HqlParser.OffsetWithMinutesContext offset) {
        int factor = ((TerminalNode)offset.getChild(0)).getSymbol().getType() == 30 ? 1 : -1;
        int hour = factor * Integer.parseInt(offset.hour().getText());
        if (offset.getChildCount() == 2) {
            return ZoneOffset.ofHours(hour);
        }
        return ZoneOffset.ofHoursMinutes(hour, factor * Integer.parseInt(offset.minute().getText()));
    }

    private SqmLiteral<?> sqlTimestampLiteralFrom(String literalText) {
        TemporalAccessor parsed = DateTimeUtils.DATE_TIME.parse(literalText.subSequence(1, literalText.length() - 1));
        try {
            ZonedDateTime zonedDateTime = ZonedDateTime.from(parsed);
            GregorianCalendar literal = GregorianCalendar.from(zonedDateTime);
            return new SqmLiteral<Calendar>(literal, this.resolveExpressibleTypeBasic(Calendar.class), this.creationContext.getNodeBuilder());
        }
        catch (DateTimeException dte) {
            LocalDateTime localDateTime = LocalDateTime.from(parsed);
            Timestamp literal = Timestamp.valueOf(localDateTime);
            return new SqmLiteral<Timestamp>(literal, this.resolveExpressibleTypeBasic(Timestamp.class), this.creationContext.getNodeBuilder());
        }
    }

    private SqmLiteral<Date> sqlDateLiteralFrom(String literalText) {
        LocalDate localDate = LocalDate.from(DateTimeFormatter.ISO_LOCAL_DATE.parse(literalText.subSequence(1, literalText.length() - 1)));
        Date literal = Date.valueOf(localDate);
        return new SqmLiteral<Date>(literal, this.resolveExpressibleTypeBasic(Date.class), this.creationContext.getNodeBuilder());
    }

    private SqmLiteral<Time> sqlTimeLiteralFrom(String literalText) {
        LocalTime localTime = LocalTime.from(DateTimeFormatter.ISO_LOCAL_TIME.parse(literalText.subSequence(1, literalText.length() - 1)));
        Time literal = Time.valueOf(localTime);
        return new SqmLiteral<Time>(literal, this.resolveExpressibleTypeBasic(Time.class), this.creationContext.getNodeBuilder());
    }

    private SqmLiteral<Boolean> booleanLiteral(boolean value) {
        return new SqmLiteral<Boolean>(value, this.resolveExpressibleTypeBasic(Boolean.class), this.creationContext.getNodeBuilder());
    }

    private SqmLiteral<String> stringLiteral(String text) {
        return new SqmLiteral<String>(QuotingHelper.unquoteStringLiteral(text), this.resolveExpressibleTypeBasic(String.class), this.creationContext.getNodeBuilder());
    }

    private SqmLiteral<String> javaStringLiteral(String text) {
        String unquoted = QuotingHelper.unquoteJavaStringLiteral(text);
        return new SqmLiteral<String>(unquoted, this.resolveExpressibleTypeBasic(String.class), this.creationContext.getNodeBuilder());
    }

    private SqmLiteral<byte[]> binaryLiteral(String text) {
        return new SqmLiteral<byte[]>(PrimitiveByteArrayJavaType.INSTANCE.fromString(CharSequenceHelper.subSequence(text, 2, text.length() - 1)), this.resolveExpressibleTypeBasic(byte[].class), this.creationContext.getNodeBuilder());
    }

    private SqmHqlNumericLiteral<Integer> integerLiteral(String text) {
        if (this.isHexOrOctal(text = text.replace("_", ""))) {
            int intValue = Integer.decode(text);
            text = Integer.toString(intValue);
        }
        return new SqmHqlNumericLiteral<Integer>(text, this.integerDomainType, this.creationContext.getNodeBuilder());
    }

    private boolean isHexOrOctal(String text) {
        if (text.startsWith("0x") || text.startsWith("-0x")) {
            return true;
        }
        return text.startsWith("0") && text.length() > 1 || text.startsWith("-0") && text.length() > 2;
    }

    private SqmHqlNumericLiteral<Long> longLiteral(String text) {
        assert (text.endsWith("l") || text.endsWith("L"));
        return new SqmHqlNumericLiteral<Long>(text.substring(0, text.length() - 1).replace("_", ""), (BasicDomainType<Long>)this.resolveExpressibleTypeBasic(Long.class), this.creationContext.getNodeBuilder());
    }

    private SqmHqlNumericLiteral<BigInteger> bigIntegerLiteral(String text) {
        assert (text.endsWith("bi") || text.endsWith("BI"));
        return new SqmHqlNumericLiteral<BigInteger>(text.substring(0, text.length() - 2).replace("_", ""), (BasicDomainType<BigInteger>)this.resolveExpressibleTypeBasic(BigInteger.class), this.creationContext.getNodeBuilder());
    }

    private SqmHqlNumericLiteral<? extends Number> floatLiteral(String text) {
        assert (text.endsWith("f") || text.endsWith("F"));
        return new SqmHqlNumericLiteral<Float>(text.substring(0, text.length() - 1).replace("_", ""), (BasicDomainType<Float>)this.resolveExpressibleTypeBasic(Float.class), this.creationContext.getNodeBuilder());
    }

    private SqmHqlNumericLiteral<Double> doubleLiteral(String text) {
        if (text.endsWith("d") || text.endsWith("D")) {
            text = text.substring(0, text.length() - 1);
        }
        return new SqmHqlNumericLiteral<Double>(text.replace("_", ""), (BasicDomainType<Double>)this.resolveExpressibleTypeBasic(Double.class), this.creationContext.getNodeBuilder());
    }

    private SqmHqlNumericLiteral<BigDecimal> bigDecimalLiteral(String text) {
        assert (text.endsWith("bd") || text.endsWith("BD"));
        return new SqmHqlNumericLiteral<BigDecimal>(text.substring(0, text.length() - 2).replace("_", ""), (BasicDomainType<BigDecimal>)this.resolveExpressibleTypeBasic(BigDecimal.class), this.creationContext.getNodeBuilder());
    }

    private SqmHqlNumericLiteral<? extends Number> hexLiteral(String text) {
        if (text.endsWith("l") || text.endsWith("L")) {
            return this.longLiteral(text);
        }
        return this.integerLiteral(text);
    }

    private <J> BasicType<J> resolveExpressibleTypeBasic(Class<J> javaType) {
        return this.creationContext.getTypeConfiguration().standardBasicTypeForJavaType(javaType);
    }

    @Override
    public Object visitParameterExpression(HqlParser.ParameterExpressionContext ctx) {
        return ctx.getChild(0).accept((ParseTreeVisitor)this);
    }

    @Override
    public SqmNamedParameter<?> visitNamedParameter(HqlParser.NamedParameterContext ctx) {
        return this.visitNamedParameter(ctx, null);
    }

    private <T> SqmNamedParameter<T> visitNamedParameter(HqlParser.NamedParameterContext ctx, SqmExpressible<T> expressibleType) {
        this.parameterStyle = this.parameterStyle.withNamed();
        return this.resolveParameter(new SqmNamedParameter<T>(ctx.getChild(1).getText(), this.parameterDeclarationContextStack.getCurrent().isMultiValuedBindingAllowed(), expressibleType, this.creationContext.getNodeBuilder()));
    }

    @Override
    public SqmPositionalParameter<?> visitPositionalParameter(HqlParser.PositionalParameterContext ctx) {
        return this.visitPositionalParameter(ctx, null);
    }

    private <T> SqmPositionalParameter<T> visitPositionalParameter(HqlParser.PositionalParameterContext ctx, SqmExpressible<T> expressibleType) {
        if (ctx.getChildCount() == 1) {
            throw new ParameterLabelException("Unlabeled ordinal parameter ('?' rather than ?1)");
        }
        this.parameterStyle = this.parameterStyle.withPositional();
        return this.resolveParameter(new SqmPositionalParameter<T>(Integer.parseInt(ctx.getChild(1).getText()), this.parameterDeclarationContextStack.getCurrent().isMultiValuedBindingAllowed(), expressibleType, this.creationContext.getNodeBuilder()));
    }

    private <T extends AbstractSqmParameter<?>> T resolveParameter(T parameter) {
        Object key;
        AbstractSqmParameter<?> existingParameter;
        if (this.parameters == null) {
            this.parameters = new HashMap();
        }
        if ((existingParameter = this.parameters.putIfAbsent(key = parameter.getName() == null ? parameter.getPosition() : parameter.getName(), parameter)) == null) {
            this.parameterCollector.addParameter(parameter);
            return parameter;
        }
        if (existingParameter.allowMultiValuedBinding() && !parameter.allowMultiValuedBinding()) {
            existingParameter.disallowMultiValuedBinding();
        }
        return (T)existingParameter;
    }

    @Override
    public SqmExpression<?> visitJpaNonstandardFunction(HqlParser.JpaNonstandardFunctionContext ctx) {
        String functionName = QuotingHelper.unquoteStringLiteral(ctx.jpaNonstandardFunctionName().getText()).toLowerCase();
        List functionArguments = ctx.getChildCount() > 4 ? (List)ctx.genericFunctionArguments().accept(this) : Collections.emptyList();
        SqmFunctionDescriptor functionTemplate = this.getFunctionDescriptor(functionName);
        if (functionTemplate == null) {
            functionTemplate = new NamedSqmFunctionDescriptor(functionName, true, null, StandardFunctionReturnTypeResolvers.invariant(new BasicTypeImpl<Object>(new UnknownBasicJavaType<Object>(Object.class), ObjectJdbcType.INSTANCE)), null);
        }
        return functionTemplate.generateSqmExpression(functionArguments, null, this.creationContext.getQueryEngine());
    }

    @Override
    public String visitGenericFunctionName(HqlParser.GenericFunctionNameContext ctx) {
        StringBuilder functionName = new StringBuilder(this.visitIdentifier(ctx.simplePath().identifier()));
        for (HqlParser.SimplePathElementContext sp : ctx.simplePath().simplePathElement()) {
            functionName.append('.').append(this.visitIdentifier(sp.identifier()));
        }
        return functionName.toString();
    }

    private String getFunctionName(HqlParser.GenericFunctionContext ctx) {
        String originalFunctionName = this.visitGenericFunctionName(ctx.genericFunctionName());
        String functionName = originalFunctionName.toLowerCase();
        if (this.creationOptions.useStrictJpaCompliance() && !JPA_STANDARD_FUNCTIONS.contains(functionName)) {
            throw new StrictJpaComplianceViolation("Encountered non-compliant non-standard function call [" + originalFunctionName + "], but strict JPA compliance was requested; use FUNCTION(functionName[,...]) syntax name instead", StrictJpaComplianceViolation.Type.FUNCTION_CALL);
        }
        return functionName;
    }

    @Override
    public Object visitGenericFunction(HqlParser.GenericFunctionContext ctx) {
        SelfRenderingSqmFunction function;
        SqmFunctionDescriptor functionTemplate = this.getFunctionTemplate(ctx);
        List<SqmTypedNode<?>> functionArguments = this.getFunctionArguments(ctx);
        SqmPredicate filterExpression = this.getFilterExpression((ParseTree)ctx);
        switch (functionTemplate.getFunctionKind()) {
            case ORDERED_SET_AGGREGATE: {
                function = functionTemplate.generateOrderedSetAggregateSqmExpression(functionArguments, filterExpression, ctx.withinGroupClause() == null ? null : this.visitOrderByClause(ctx.withinGroupClause().orderByClause(), false), null, this.creationContext.getQueryEngine());
                break;
            }
            case AGGREGATE: {
                function = functionTemplate.generateAggregateSqmExpression(functionArguments, filterExpression, null, this.creationContext.getQueryEngine());
                break;
            }
            case WINDOW: {
                function = functionTemplate.generateWindowSqmExpression(functionArguments, filterExpression, null, null, null, this.creationContext.getQueryEngine());
                break;
            }
            default: {
                function = functionTemplate.generateSqmExpression(functionArguments, null, this.creationContext.getQueryEngine());
            }
        }
        return this.applyOverClause(ctx.overClause(), function);
    }

    private SqmFunctionDescriptor getFunctionTemplate(HqlParser.GenericFunctionContext ctx) {
        String functionName = this.getFunctionName(ctx);
        SqmFunctionDescriptor functionTemplate = this.getFunctionDescriptor(functionName);
        if (functionTemplate == null) {
            return new NamedSqmFunctionDescriptor(functionName, true, null, StandardFunctionReturnTypeResolvers.invariant(this.resolveExpressibleTypeBasic(Object.class)), null, functionName, SemanticQueryBuilder.inferFunctionKind(ctx), null, SqlAstNodeRenderingMode.DEFAULT);
        }
        FunctionKind functionKind = functionTemplate.getFunctionKind();
        if (ctx.filterClause() != null && functionKind == FunctionKind.NORMAL) {
            throw new SemanticException("'FILTER' clause is illegal for non-aggregate function: " + functionName);
        }
        if (ctx.overClause() != null && functionKind == FunctionKind.NORMAL) {
            throw new SemanticException("'OVER' clause is illegal for non-aggregate function: " + functionName);
        }
        if (ctx.withinGroupClause() != null && functionKind == FunctionKind.NORMAL) {
            throw new SemanticException("'WITHIN' GROUP clause is illegal for non-aggregate function: " + functionName);
        }
        if (ctx.overClause() == null && functionKind == FunctionKind.WINDOW) {
            throw new SemanticException("'OVER' clause is mandatory for window-only function: " + functionName);
        }
        if (ctx.withinGroupClause() == null && ctx.overClause() == null && functionKind == FunctionKind.ORDERED_SET_AGGREGATE) {
            throw new SemanticException("'WITHIN GROUP' or 'OVER' clause is mandatory for ordered set aggregate function: " + functionName);
        }
        if (ctx.nullsClause() != null) {
            switch (functionName) {
                case "lag": 
                case "lead": 
                case "first_value": 
                case "last_value": 
                case "nth_value": {
                    break;
                }
                default: {
                    throw new SemanticException("'RESPECT NULLS' or 'IGNORE NULLS' are illegal for function: " + functionName);
                }
            }
        }
        if (ctx.nthSideClause() != null && !"nth_value".equals(functionName)) {
            throw new SemanticException("'FROM FIRST' or 'FROM LAST' are illegal for function: " + functionName);
        }
        return functionTemplate;
    }

    private static FunctionKind inferFunctionKind(HqlParser.GenericFunctionContext ctx) {
        if (ctx.withinGroupClause() != null) {
            return FunctionKind.ORDERED_SET_AGGREGATE;
        }
        if (ctx.overClause() != null) {
            return FunctionKind.WINDOW;
        }
        if (ctx.filterClause() != null) {
            return FunctionKind.AGGREGATE;
        }
        return FunctionKind.NORMAL;
    }

    private List<SqmTypedNode<?>> getFunctionArguments(HqlParser.GenericFunctionContext ctx) {
        if (ctx.genericFunctionArguments() != null) {
            List node = (List)ctx.genericFunctionArguments().accept(this);
            return node;
        }
        if (ctx.ASTERISK() != null) {
            return Collections.singletonList(new SqmStar(this.getCreationContext().getNodeBuilder()));
        }
        return Collections.emptyList();
    }

    @Override
    public Object visitListaggFunction(HqlParser.ListaggFunctionContext ctx) {
        if (this.creationOptions.useStrictJpaCompliance()) {
            throw new StrictJpaComplianceViolation("Encountered non-compliant non-standard function call [listagg], but strict JPA compliance was requested; use FUNCTION(functionName[,...]) syntax name instead", StrictJpaComplianceViolation.Type.FUNCTION_CALL);
        }
        SqmFunctionDescriptor functionTemplate = this.getFunctionDescriptor("listagg");
        if (functionTemplate == null) {
            throw new SemanticException("The listagg() function was not registered for the dialect");
        }
        return this.applyOverClause(ctx.overClause(), functionTemplate.generateOrderedSetAggregateSqmExpression(this.getListaggArguments(ctx), this.getFilterExpression((ParseTree)ctx), ctx.withinGroupClause() == null ? null : this.visitOrderByClause(ctx.withinGroupClause().orderByClause(), false), null, this.creationContext.getQueryEngine()));
    }

    private List<SqmTypedNode<?>> getListaggArguments(HqlParser.ListaggFunctionContext ctx) {
        SqmExpression firstArgument = (SqmExpression)ctx.expressionOrPredicate(0).accept(this);
        SqmExpression secondArgument = (SqmExpression)ctx.expressionOrPredicate(1).accept(this);
        HqlParser.OnOverflowClauseContext overflowCtx = ctx.onOverflowClause();
        ArrayList functionArguments = new ArrayList(3);
        if (ctx.DISTINCT() != null) {
            functionArguments.add(new SqmDistinct(firstArgument, this.creationContext.getNodeBuilder()));
        } else {
            functionArguments.add(firstArgument);
        }
        if (overflowCtx != null) {
            if (overflowCtx.ERROR() != null) {
                functionArguments.add(new SqmOverflow(secondArgument, null, false));
            } else {
                SqmLiteral<String> fillerExpression = overflowCtx.expression() != null ? (SqmLiteral<String>)overflowCtx.expression().accept(this) : new SqmLiteral<String>("...", this.resolveExpressibleTypeBasic(String.class), secondArgument.nodeBuilder());
                boolean withCount = overflowCtx.WITH() != null;
                functionArguments.add(new SqmOverflow<String>(secondArgument, fillerExpression, withCount));
            }
        } else {
            functionArguments.add(secondArgument);
        }
        return functionArguments;
    }

    @Override
    public List<SqmTypedNode<?>> visitGenericFunctionArguments(HqlParser.GenericFunctionArgumentsContext ctx) {
        List<HqlParser.ExpressionOrPredicateContext> argumentContexts = ctx.expressionOrPredicate();
        int count = argumentContexts.size();
        ArrayList arguments = new ArrayList(count + 1);
        HqlParser.DatetimeFieldContext datetimeFieldContext = ctx.datetimeField();
        if (datetimeFieldContext != null) {
            arguments.add(this.toDurationUnit((SqmExtractUnit)datetimeFieldContext.accept(this)));
        }
        for (int i = 0; i < count - 1; ++i) {
            HqlParser.ExpressionOrPredicateContext argumentContext = argumentContexts.get(i);
            arguments.add((SqmTypedNode)argumentContext.accept(this));
        }
        HqlParser.ExpressionOrPredicateContext argumentContext = argumentContexts.get(count - 1);
        arguments.add(this.visitFinalFunctionArgument((ParseTree)argumentContext));
        if (ctx.DISTINCT() != null) {
            NodeBuilder nodeBuilder = this.getCreationContext().getNodeBuilder();
            if (arguments.size() == 1) {
                arguments.set(0, new SqmDistinct((SqmExpression)arguments.get(0), nodeBuilder));
            } else {
                ArrayList newArguments = new ArrayList(1);
                ArrayList expressions = arguments;
                newArguments.add(new SqmDistinct(new SqmTuple(expressions, nodeBuilder), nodeBuilder));
                return newArguments;
            }
        }
        return arguments;
    }

    private SqmExpression<?> visitFinalFunctionArgument(ParseTree expression) {
        this.parameterDeclarationContextStack.push(() -> !this.creationOptions.useStrictJpaCompliance());
        try {
            SqmExpression sqmExpression = (SqmExpression)expression.accept((ParseTreeVisitor)this);
            return sqmExpression;
        }
        finally {
            this.parameterDeclarationContextStack.pop();
        }
    }

    private SqmFunctionDescriptor getFunctionDescriptor(String name) {
        return this.creationContext.getQueryEngine().getSqmFunctionRegistry().findFunctionDescriptor(name);
    }

    @Override
    public SqmExtractUnit<?> visitDatetimeField(HqlParser.DatetimeFieldContext ctx) {
        NodeBuilder nodeBuilder = this.creationContext.getNodeBuilder();
        switch (((TerminalNode)ctx.getChild(0)).getSymbol().getType()) {
            case 71: {
                return new SqmExtractUnit<Integer>(TemporalUnit.DAY, this.resolveExpressibleTypeBasic(Integer.class), nodeBuilder);
            }
            case 142: {
                return new SqmExtractUnit<Integer>(TemporalUnit.MONTH, this.resolveExpressibleTypeBasic(Integer.class), nodeBuilder);
            }
            case 208: {
                return new SqmExtractUnit<Integer>(TemporalUnit.YEAR, this.resolveExpressibleTypeBasic(Integer.class), nodeBuilder);
            }
            case 103: {
                return new SqmExtractUnit<Integer>(TemporalUnit.HOUR, this.resolveExpressibleTypeBasic(Integer.class), nodeBuilder);
            }
            case 141: {
                return new SqmExtractUnit<Integer>(TemporalUnit.MINUTE, this.resolveExpressibleTypeBasic(Integer.class), nodeBuilder);
            }
            case 176: {
                return new SqmExtractUnit<Float>(TemporalUnit.SECOND, this.resolveExpressibleTypeBasic(Float.class), nodeBuilder);
            }
            case 143: {
                return new SqmExtractUnit<Long>(TemporalUnit.NANOSECOND, this.resolveExpressibleTypeBasic(Long.class), nodeBuilder);
            }
            case 202: {
                return new SqmExtractUnit<Integer>(TemporalUnit.WEEK, this.resolveExpressibleTypeBasic(Integer.class), nodeBuilder);
            }
            case 168: {
                return new SqmExtractUnit<Integer>(TemporalUnit.QUARTER, this.resolveExpressibleTypeBasic(Integer.class), nodeBuilder);
            }
            case 83: {
                return new SqmExtractUnit<Long>(TemporalUnit.EPOCH, this.resolveExpressibleTypeBasic(Long.class), nodeBuilder);
            }
        }
        throw new ParsingException("Unsupported datetime field [" + ctx.getText() + "]");
    }

    @Override
    public Object visitDayField(HqlParser.DayFieldContext ctx) {
        NodeBuilder nodeBuilder = this.creationContext.getNodeBuilder();
        switch (((TerminalNode)ctx.getChild(2)).getSymbol().getType()) {
            case 142: {
                return new SqmExtractUnit<Integer>(TemporalUnit.DAY_OF_MONTH, this.resolveExpressibleTypeBasic(Integer.class), nodeBuilder);
            }
            case 202: {
                return new SqmExtractUnit<Integer>(TemporalUnit.DAY_OF_WEEK, this.resolveExpressibleTypeBasic(Integer.class), nodeBuilder);
            }
            case 208: {
                return new SqmExtractUnit<Integer>(TemporalUnit.DAY_OF_YEAR, this.resolveExpressibleTypeBasic(Integer.class), nodeBuilder);
            }
        }
        throw new ParsingException("Unsupported day field [" + ctx.getText() + "]");
    }

    @Override
    public Object visitWeekField(HqlParser.WeekFieldContext ctx) {
        NodeBuilder nodeBuilder = this.creationContext.getNodeBuilder();
        switch (((TerminalNode)ctx.getChild(2)).getSymbol().getType()) {
            case 142: {
                return new SqmExtractUnit<Integer>(TemporalUnit.WEEK_OF_MONTH, this.resolveExpressibleTypeBasic(Integer.class), nodeBuilder);
            }
            case 208: {
                return new SqmExtractUnit<Integer>(TemporalUnit.WEEK_OF_YEAR, this.resolveExpressibleTypeBasic(Integer.class), nodeBuilder);
            }
        }
        throw new ParsingException("Unsupported week field [" + ctx.getText() + "]");
    }

    @Override
    public Object visitDateOrTimeField(HqlParser.DateOrTimeFieldContext ctx) {
        NodeBuilder nodeBuilder = this.creationContext.getNodeBuilder();
        switch (((TerminalNode)ctx.getChild(0)).getSymbol().getType()) {
            case 69: {
                return this.isExtractingJdbcTemporalType ? new SqmExtractUnit<Date>(TemporalUnit.DATE, this.resolveExpressibleTypeBasic(Date.class), nodeBuilder) : new SqmExtractUnit<LocalDate>(TemporalUnit.DATE, this.resolveExpressibleTypeBasic(LocalDate.class), nodeBuilder);
            }
            case 185: {
                return this.isExtractingJdbcTemporalType ? new SqmExtractUnit<Time>(TemporalUnit.TIME, this.resolveExpressibleTypeBasic(Time.class), nodeBuilder) : new SqmExtractUnit<LocalTime>(TemporalUnit.TIME, this.resolveExpressibleTypeBasic(LocalTime.class), nodeBuilder);
            }
        }
        throw new ParsingException("Unsupported date or time field [" + ctx.getText() + "]");
    }

    @Override
    public Object visitTimeZoneField(HqlParser.TimeZoneFieldContext ctx) {
        NodeBuilder nodeBuilder = this.creationContext.getNodeBuilder();
        switch (((TerminalNode)ctx.getChild(ctx.getChildCount() - 1)).getSymbol().getType()) {
            case 103: 
            case 187: {
                return new SqmExtractUnit<Integer>(TemporalUnit.TIMEZONE_HOUR, this.resolveExpressibleTypeBasic(Integer.class), nodeBuilder);
            }
            case 141: 
            case 188: {
                return new SqmExtractUnit<Integer>(TemporalUnit.TIMEZONE_MINUTE, this.resolveExpressibleTypeBasic(Integer.class), nodeBuilder);
            }
            case 151: {
                return new SqmExtractUnit<ZoneOffset>(TemporalUnit.OFFSET, this.resolveExpressibleTypeBasic(ZoneOffset.class), nodeBuilder);
            }
        }
        throw new ParsingException("Unsupported time zone field [" + ctx.getText() + "]");
    }

    @Override
    public Object visitExtractFunction(HqlParser.ExtractFunctionContext ctx) {
        SqmExtractUnit extractFieldExpression = ctx.extractField() != null ? (SqmExtractUnit)ctx.extractField().accept(this) : (SqmExtractUnit)ctx.datetimeField().accept(this);
        SqmExpression expressionToExtract = (SqmExpression)ctx.expression().accept(this);
        this.isExtractingJdbcTemporalType = TypeConfiguration.isJdbcTemporalType(expressionToExtract.getNodeType());
        return this.getFunctionDescriptor("extract").generateSqmExpression(Arrays.asList(extractFieldExpression, expressionToExtract), extractFieldExpression.getType(), this.creationContext.getQueryEngine());
    }

    @Override
    public Object visitTruncFunction(HqlParser.TruncFunctionContext ctx) {
        SqmExpression expression = (SqmExpression)ctx.expression(0).accept(this);
        SqmTypedNode secondArg = ctx.expression().size() > 1 ? (SqmTypedNode)ctx.expression(1).accept(this) : (ctx.datetimeField() != null ? (SqmTypedNode)ctx.datetimeField().accept(this) : null);
        return this.getFunctionDescriptor("trunc").generateSqmExpression(secondArg == null ? Collections.singletonList(expression) : Arrays.asList(expression, secondArg), null, this.creationContext.getQueryEngine());
    }

    @Override
    public Object visitFormat(HqlParser.FormatContext ctx) {
        String format = QuotingHelper.unquoteStringLiteral(ctx.STRING_LITERAL().getText());
        return new SqmFormat(format, (SqmExpressible<String>)this.resolveExpressibleTypeBasic(String.class), this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmExpression<?> visitFormatFunction(HqlParser.FormatFunctionContext ctx) {
        SqmExpression expressionToCast = (SqmExpression)ctx.expression().accept(this);
        SqmLiteral format = (SqmLiteral)ctx.format().accept(this);
        return this.getFunctionDescriptor("format").generateSqmExpression(Arrays.asList(expressionToCast, format), null, this.creationContext.getQueryEngine());
    }

    @Override
    public SqmExpression<?> visitCastFunction(HqlParser.CastFunctionContext ctx) {
        SqmExpression expressionToCast = (SqmExpression)ctx.expression().accept(this);
        SqmCastTarget castTargetExpression = (SqmCastTarget)ctx.castTarget().accept(this);
        return this.getFunctionDescriptor("cast").generateSqmExpression(Arrays.asList(expressionToCast, castTargetExpression), castTargetExpression.getType(), this.creationContext.getQueryEngine());
    }

    @Override
    public SqmCastTarget<?> visitCastTarget(HqlParser.CastTargetContext castTargetContext) {
        HqlParser.CastTargetTypeContext castTargetTypeContext = castTargetContext.castTargetType();
        String targetName = castTargetTypeContext.fullTargetName;
        TerminalNode firstArg = castTargetContext.INTEGER_LITERAL(0);
        TerminalNode secondArg = castTargetContext.INTEGER_LITERAL(1);
        Long length = firstArg == null ? null : Long.valueOf(firstArg.getText());
        Integer precision = firstArg == null ? null : Integer.valueOf(firstArg.getText());
        Integer scale = secondArg == null ? null : Integer.valueOf(secondArg.getText());
        return new SqmCastTarget((ReturnableType)((Object)this.creationContext.getTypeConfiguration().resolveCastTargetType(targetName)), length, precision, scale, this.creationContext.getNodeBuilder());
    }

    @Override
    public Object visitPositionFunction(HqlParser.PositionFunctionContext ctx) {
        SqmExpression pattern = (SqmExpression)ctx.positionFunctionPatternArgument().accept(this);
        SqmExpression string = (SqmExpression)ctx.positionFunctionStringArgument().accept(this);
        return this.getFunctionDescriptor("position").generateSqmExpression(Arrays.asList(pattern, string), null, this.creationContext.getQueryEngine());
    }

    @Override
    public Object visitOverlayFunction(HqlParser.OverlayFunctionContext ctx) {
        SqmExpression string = (SqmExpression)ctx.overlayFunctionStringArgument().accept(this);
        SqmExpression replacement = (SqmExpression)ctx.overlayFunctionReplacementArgument().accept(this);
        SqmExpression start = (SqmExpression)ctx.overlayFunctionStartArgument().accept(this);
        SqmExpression length = ctx.overlayFunctionLengthArgument() != null ? (SqmExpression)ctx.overlayFunctionLengthArgument().accept(this) : null;
        return this.getFunctionDescriptor("overlay").generateSqmExpression(length == null ? Arrays.asList(string, replacement, start) : Arrays.asList(string, replacement, start, length), null, this.creationContext.getQueryEngine());
    }

    @Override
    public SqmExpression<?> visitEveryFunction(HqlParser.EveryFunctionContext ctx) {
        if (ctx.subquery() != null) {
            SqmSubQuery subquery = (SqmSubQuery)ctx.subquery().accept(this);
            return new SqmEvery(subquery, this.creationContext.getNodeBuilder());
        }
        if (ctx.predicate() != null) {
            if (this.getCreationOptions().useStrictJpaCompliance()) {
                throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.FUNCTION_CALL);
            }
            SqmExpression argument = (SqmExpression)ctx.predicate().accept(this);
            return this.applyOverClause(ctx.overClause(), this.getFunctionDescriptor("every").generateAggregateSqmExpression(Collections.singletonList(argument), this.getFilterExpression((ParseTree)ctx), this.resolveExpressibleTypeBasic(Boolean.class), this.creationContext.getQueryEngine()));
        }
        if (this.getCreationOptions().useStrictJpaCompliance()) {
            throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.HQL_COLLECTION_FUNCTION);
        }
        return new SqmEvery(this.createCollectionReferenceSubQuery(ctx.simplePath(), (TerminalNode)ctx.collectionQuantifier().getChild(0).getChild(0)), this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmExpression<?> visitAnyFunction(HqlParser.AnyFunctionContext ctx) {
        if (ctx.subquery() != null) {
            SqmSubQuery subquery = (SqmSubQuery)ctx.subquery().accept(this);
            return new SqmAny(subquery, this.creationContext.getNodeBuilder());
        }
        if (ctx.predicate() != null) {
            if (this.getCreationOptions().useStrictJpaCompliance()) {
                throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.FUNCTION_CALL);
            }
            SqmExpression argument = (SqmExpression)ctx.predicate().accept(this);
            return this.applyOverClause(ctx.overClause(), this.getFunctionDescriptor("any").generateAggregateSqmExpression(Collections.singletonList(argument), this.getFilterExpression((ParseTree)ctx), this.resolveExpressibleTypeBasic(Boolean.class), this.creationContext.getQueryEngine()));
        }
        if (this.getCreationOptions().useStrictJpaCompliance()) {
            throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.HQL_COLLECTION_FUNCTION);
        }
        return new SqmAny(this.createCollectionReferenceSubQuery(ctx.simplePath(), (TerminalNode)ctx.collectionQuantifier().getChild(0).getChild(0)), this.creationContext.getNodeBuilder());
    }

    private <X> SqmSubQuery<X> createCollectionReferenceSubQuery(HqlParser.SimplePathContext pathCtx, TerminalNode collectionReferenceCtx) {
        SqmCorrelation correlation;
        SqmPath<?> pluralAttributePath = this.consumeDomainPath(pathCtx);
        SqmPathSource<?> referencedPathSource = pluralAttributePath.getReferencedPathSource();
        if (!(referencedPathSource instanceof PluralPersistentAttribute)) {
            throw new SemanticException("Path is not a plural path '" + pluralAttributePath.getNavigablePath() + "'");
        }
        SqmSubQuery subQuery = new SqmSubQuery(this.processingStateStack.getCurrent().getProcessingQuery(), this.creationContext.getNodeBuilder());
        SqmSelectClause selectClause = new SqmSelectClause(false, 1, this.creationContext.getNodeBuilder());
        SqmFromClause fromClause = new SqmFromClause(1);
        JpaPath lhs = pluralAttributePath.getLhs();
        ArrayList<String> implicitJoinPaths = new ArrayList<String>();
        while (!(lhs instanceof AbstractSqmFrom)) {
            implicitJoinPaths.add(lhs.getNavigablePath().getLocalName());
            lhs = lhs.getLhs();
        }
        AbstractSqmFrom correlationBase = (AbstractSqmFrom)lhs;
        JpaFrom joinBase = correlation = correlationBase.createCorrelation();
        for (int i = implicitJoinPaths.size() - 1; i >= 0; --i) {
            joinBase = joinBase.join((String)implicitJoinPaths.get(i));
        }
        JpaJoin collectionJoin = joinBase.join(pluralAttributePath.getNavigablePath().getLocalName());
        fromClause.addRoot(correlation.getCorrelatedRoot());
        if (collectionReferenceCtx == null) {
            SqmLiteral<Integer> literal = new SqmLiteral<Integer>(1, this.creationContext.getNodeBuilder().getIntegerType(), this.creationContext.getNodeBuilder());
            subQuery.applyInferableType(literal.getNodeType());
            selectClause.setSelection(literal);
        } else {
            String partName;
            switch (collectionReferenceCtx.getSymbol().getType()) {
                case 78: {
                    partName = CollectionPart.Nature.ELEMENT.getName();
                    break;
                }
                case 108: {
                    partName = CollectionPart.Nature.INDEX.getName();
                    break;
                }
                default: {
                    throw new ParsingException("Unexpected collection reference : " + collectionReferenceCtx.getText());
                }
            }
            SemanticPathPart path = collectionJoin.resolvePathPart(partName, true, this);
            subQuery.applyInferableType(path.getNodeType());
            selectClause.setSelection((SqmSelectableNode<?>)((Object)path));
        }
        JpaQueryStructure querySpec = subQuery.getQuerySpec();
        ((SqmQuerySpec)querySpec).setFromClause(fromClause);
        ((SqmQuerySpec)querySpec).setSelectClause(selectClause);
        return subQuery;
    }

    private SqmPredicate getFilterExpression(ParseTree functionCtx) {
        for (int i = functionCtx.getChildCount() - 2; i < functionCtx.getChildCount(); ++i) {
            ParseTree child = functionCtx.getChild(i);
            if (!(child instanceof HqlParser.FilterClauseContext)) continue;
            return (SqmPredicate)child.getChild(2).getChild(1).accept((ParseTreeVisitor)this);
        }
        return null;
    }

    private SqmExpression<?> applyOverClause(HqlParser.OverClauseContext ctx, SqmFunction<?> function) {
        FrameExclusion exclusion;
        SqmExpression startExpression;
        FrameKind startKind;
        SqmExpression endExpression;
        FrameKind endKind;
        FrameMode mode;
        List<SqmSortSpecification> orderList;
        List<SqmExpression<?>> partitions;
        block19: {
            block17: {
                block18: {
                    int frameStartIndex;
                    if (ctx == null) {
                        return function;
                    }
                    if (ctx.partitionClause() != null) {
                        HqlParser.PartitionClauseContext partitionClause = ctx.partitionClause();
                        partitions = new ArrayList((partitionClause.getChildCount() >> 1) - 1);
                        for (int i = 2; i < partitionClause.getChildCount(); i += 2) {
                            partitions.add((SqmExpression)partitionClause.getChild(i).accept((ParseTreeVisitor)this));
                        }
                    } else {
                        partitions = Collections.emptyList();
                    }
                    orderList = ctx.orderByClause() != null ? this.visitOrderByClause(ctx.orderByClause(), false).getSortSpecifications() : Collections.emptyList();
                    HqlParser.FrameClauseContext frameClause = ctx.frameClause();
                    if (frameClause == null) break block17;
                    switch (((TerminalNode)frameClause.getChild(0)).getSymbol().getType()) {
                        case 169: {
                            mode = FrameMode.RANGE;
                            break;
                        }
                        case 174: {
                            mode = FrameMode.ROWS;
                            break;
                        }
                        case 101: {
                            mode = FrameMode.GROUPS;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unexpected frame mode: " + frameClause.getChild(0));
                        }
                    }
                    if (frameClause.getChild(1) instanceof TerminalNode) {
                        frameStartIndex = 2;
                        endKind = this.getFrameKind(frameClause.getChild(4));
                        endExpression = endKind == FrameKind.OFFSET_FOLLOWING || endKind == FrameKind.OFFSET_PRECEDING ? (SqmExpression)frameClause.getChild(4).getChild(0).accept((ParseTreeVisitor)this) : null;
                    } else {
                        frameStartIndex = 1;
                        endKind = FrameKind.CURRENT_ROW;
                        endExpression = null;
                    }
                    startKind = this.getFrameKind(frameClause.getChild(frameStartIndex));
                    startExpression = startKind == FrameKind.OFFSET_FOLLOWING || startKind == FrameKind.OFFSET_PRECEDING ? (SqmExpression)frameClause.getChild(frameStartIndex).getChild(0).accept((ParseTreeVisitor)this) : null;
                    ParseTree lastChild = frameClause.getChild(frameClause.getChildCount() - 1);
                    if (!(lastChild instanceof HqlParser.FrameExclusionContext)) break block18;
                    switch (((TerminalNode)lastChild.getChild(1)).getSymbol().getType()) {
                        case 63: {
                            exclusion = FrameExclusion.CURRENT_ROW;
                            break block19;
                        }
                        case 100: {
                            exclusion = FrameExclusion.GROUP;
                            break block19;
                        }
                        case 184: {
                            exclusion = FrameExclusion.TIES;
                            break block19;
                        }
                        case 146: {
                            exclusion = FrameExclusion.NO_OTHERS;
                            break block19;
                        }
                        default: {
                            throw new IllegalArgumentException("Unexpected frame exclusion: " + lastChild);
                        }
                    }
                }
                exclusion = FrameExclusion.NO_OTHERS;
                break block19;
            }
            mode = FrameMode.RANGE;
            startKind = FrameKind.UNBOUNDED_PRECEDING;
            startExpression = null;
            endKind = FrameKind.CURRENT_ROW;
            endExpression = null;
            exclusion = FrameExclusion.NO_OTHERS;
        }
        return new SqmOver(function, partitions, orderList, mode, startKind, startExpression, endKind, endExpression, exclusion);
    }

    private FrameKind getFrameKind(ParseTree child) {
        switch (((TerminalNode)child.getChild(1)).getSymbol().getType()) {
            case 167: {
                if (child.getChild(0) instanceof TerminalNode) {
                    return FrameKind.UNBOUNDED_PRECEDING;
                }
                return FrameKind.OFFSET_PRECEDING;
            }
            case 94: {
                if (child.getChild(0) instanceof TerminalNode) {
                    return FrameKind.UNBOUNDED_FOLLOWING;
                }
                return FrameKind.OFFSET_FOLLOWING;
            }
            case 173: {
                return FrameKind.CURRENT_ROW;
            }
        }
        throw new IllegalArgumentException("Illegal frame kind: " + child);
    }

    @Override
    public SqmExpression<?> visitCube(HqlParser.CubeContext ctx) {
        return new SqmSummarization(SqmSummarization.Kind.CUBE, this.visitExpressions(ctx), this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmExpression<?> visitRollup(HqlParser.RollupContext ctx) {
        return new SqmSummarization(SqmSummarization.Kind.ROLLUP, this.visitExpressions(ctx), this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmExpression<?> visitSubstringFunction(HqlParser.SubstringFunctionContext ctx) {
        SqmExpression source = (SqmExpression)ctx.expression().accept(this);
        SqmExpression start = (SqmExpression)ctx.substringFunctionStartArgument().accept(this);
        SqmExpression length = ctx.substringFunctionLengthArgument() != null ? (SqmExpression)ctx.substringFunctionLengthArgument().accept(this) : null;
        return this.getFunctionDescriptor("substring").generateSqmExpression(length == null ? Arrays.asList(source, start) : Arrays.asList(source, start, length), null, this.creationContext.getQueryEngine());
    }

    @Override
    public SqmExpression<?> visitPadFunction(HqlParser.PadFunctionContext ctx) {
        SqmExpression source = (SqmExpression)ctx.expression().accept(this);
        SqmExpression length = (SqmExpression)ctx.padLength().accept(this);
        SqmTrimSpecification padSpec = this.visitPadSpecification(ctx.padSpecification());
        Object padChar = ctx.padCharacter() != null ? this.visitPadCharacter(ctx.padCharacter()) : null;
        return this.getFunctionDescriptor("pad").generateSqmExpression(padChar != null ? Arrays.asList(source, length, padSpec, padChar) : Arrays.asList(source, length, padSpec), null, this.creationContext.getQueryEngine());
    }

    @Override
    public SqmTrimSpecification visitPadSpecification(HqlParser.PadSpecificationContext ctx) {
        switch (((TerminalNode)ctx.getChild(0)).getSymbol().getType()) {
            case 120: {
                return new SqmTrimSpecification(TrimSpec.LEADING, this.creationContext.getNodeBuilder());
            }
            case 190: {
                return new SqmTrimSpecification(TrimSpec.TRAILING, this.creationContext.getNodeBuilder());
            }
        }
        throw new ParsingException("Unsupported pad specification [" + ctx.getText() + "]");
    }

    @Override
    public SqmLiteral<Character> visitPadCharacter(HqlParser.PadCharacterContext ctx) {
        String padCharText = ctx.STRING_LITERAL().getText();
        if (padCharText.length() != 3) {
            throw new SemanticException("Pad character for pad() function must be single character, found '" + padCharText + "'");
        }
        return new SqmLiteral<Character>(Character.valueOf(padCharText.charAt(1)), this.resolveExpressibleTypeBasic(Character.class), this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmExpression<?> visitTrimFunction(HqlParser.TrimFunctionContext ctx) {
        SqmExpression source = (SqmExpression)ctx.expression().accept(this);
        SqmTrimSpecification trimSpec = this.visitTrimSpecification(ctx.trimSpecification());
        Object trimChar = this.visitTrimCharacter(ctx.trimCharacter());
        return this.getFunctionDescriptor("trim").generateSqmExpression(Arrays.asList(trimSpec, trimChar, source), null, this.creationContext.getQueryEngine());
    }

    @Override
    public SqmTrimSpecification visitTrimSpecification(HqlParser.TrimSpecificationContext ctx) {
        TrimSpec spec = ctx != null ? SemanticQueryBuilder.trimSpec(ctx) : TrimSpec.BOTH;
        return new SqmTrimSpecification(spec, this.creationContext.getNodeBuilder());
    }

    private static TrimSpec trimSpec(HqlParser.TrimSpecificationContext ctx) {
        switch (((TerminalNode)ctx.getChild(0)).getSymbol().getType()) {
            case 120: {
                return TrimSpec.LEADING;
            }
            case 190: {
                return TrimSpec.TRAILING;
            }
            case 54: {
                return TrimSpec.BOTH;
            }
        }
        throw new ParsingException("Unrecognized trim specification");
    }

    @Override
    public SqmLiteral<Character> visitTrimCharacter(HqlParser.TrimCharacterContext ctx) {
        String trimCharText;
        String string = trimCharText = ctx != null ? QuotingHelper.unquoteStringLiteral(ctx.getText()) : " ";
        if (trimCharText.length() != 1) {
            throw new SemanticException("Trim character for trim() function must be single character, found '" + trimCharText + "'");
        }
        return new SqmLiteral<Character>(Character.valueOf(trimCharText.charAt(0)), this.resolveExpressibleTypeBasic(Character.class), this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmCollectionSize visitCollectionSizeFunction(HqlParser.CollectionSizeFunctionContext ctx) {
        return new SqmCollectionSize(this.consumeDomainPath((HqlParser.PathContext)ctx.getChild(2)), this.resolveExpressibleTypeBasic(Integer.class), this.creationContext.getNodeBuilder());
    }

    private boolean isIndexedPluralAttribute(SqmPath<?> path) {
        return path.getReferencedPathSource() instanceof PluralPersistentAttribute;
    }

    @Override
    public SqmPath<?> visitCollectionFunctionMisuse(HqlParser.CollectionFunctionMisuseContext ctx) {
        CollectionPart.Nature nature;
        log.warn((Object)"Misuse of HQL elements() or indices() function, use element() or index() instead");
        if (this.getCreationOptions().useStrictJpaCompliance()) {
            throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.HQL_COLLECTION_FUNCTION);
        }
        SqmPath<?> pluralAttributePath = this.consumeDomainPath(ctx.path());
        SqmPathSource<?> referencedPathSource = pluralAttributePath.getReferencedPathSource();
        TerminalNode firstNode = (TerminalNode)ctx.getChild(0).getChild(0);
        if (!(referencedPathSource instanceof PluralPersistentAttribute)) {
            throw new FunctionArgumentException(String.format("Argument '%s' of '%s()' function is not a plural path ", pluralAttributePath.getNavigablePath(), firstNode.getSymbol().getText()));
        }
        switch (firstNode.getSymbol().getType()) {
            case 78: {
                nature = CollectionPart.Nature.ELEMENT;
                break;
            }
            case 108: {
                nature = CollectionPart.Nature.INDEX;
                break;
            }
            default: {
                throw new ParsingException("Impossible symbol");
            }
        }
        return pluralAttributePath.resolvePathPart(nature.getName(), true, this);
    }

    @Override
    public SqmExpression<?> visitElementAggregateFunction(HqlParser.ElementAggregateFunctionContext ctx) {
        if (this.creationOptions.useStrictJpaCompliance()) {
            throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.HQL_COLLECTION_FUNCTION);
        }
        String functionName = ctx.getChild(0).getText().substring(0, 3);
        SqmPath<?> pluralPath = this.consumePluralAttributeReference(ctx.path());
        if (pluralPath instanceof SqmPluralValuedSimplePath) {
            return new SqmElementAggregateFunction(pluralPath, functionName);
        }
        if (pluralPath instanceof SqmMapJoin) {
            throw new FunctionArgumentException("Path '" + ctx.path().getText() + "' resolved to a joined map instead of a compound path");
        }
        if (pluralPath instanceof SqmListJoin) {
            throw new FunctionArgumentException("Path '" + ctx.path().getText() + "' resolved to a joined list instead of a compound path");
        }
        throw new FunctionArgumentException("Path '" + ctx.path().getText() + "' did not resolve to a many-valued attribute");
    }

    @Override
    public SqmExpression<?> visitIndexAggregateFunction(HqlParser.IndexAggregateFunctionContext ctx) {
        if (this.creationOptions.useStrictJpaCompliance()) {
            throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.HQL_COLLECTION_FUNCTION);
        }
        String functionName = ctx.getChild(0).getText().substring(0, 3);
        SqmPath<?> pluralPath = this.consumePluralAttributeReference(ctx.path());
        if (pluralPath instanceof SqmPluralValuedSimplePath) {
            if (this.isIndexedPluralAttribute(pluralPath)) {
                return new SqmIndexAggregateFunction(pluralPath, functionName);
            }
            throw new FunctionArgumentException("Path '" + ctx.path() + "' resolved to '" + pluralPath.getReferencedPathSource() + "' which is not an indexed collection");
        }
        if (pluralPath instanceof SqmMapJoin) {
            throw new FunctionArgumentException("Path '" + ctx.path().getText() + "' resolved to a joined map instead of a compound path");
        }
        if (pluralPath instanceof SqmListJoin) {
            throw new FunctionArgumentException("Path '" + ctx.path().getText() + "' resolved to a joined list instead of a compound path");
        }
        throw new FunctionArgumentException("Path '" + ctx.path().getText() + "' did not resolve to a many-valued attribute");
    }

    @Override
    public SqmSubQuery<?> visitSubqueryExpression(HqlParser.SubqueryExpressionContext ctx) {
        return this.visitSubquery((HqlParser.SubqueryContext)ctx.getChild(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqmSubQuery<?> visitSubquery(HqlParser.SubqueryContext ctx) {
        HqlParser.QueryExpressionContext queryExpressionContext = ctx.queryExpression();
        SqmSubQuery subQuery = new SqmSubQuery(this.processingStateStack.getCurrent().getProcessingQuery(), this.creationContext.getNodeBuilder());
        this.processingStateStack.push(new SqmQueryPartCreationProcessingStateStandardImpl(this.processingStateStack.getCurrent(), subQuery, this));
        try {
            queryExpressionContext.accept(this);
            List<SqmSelection<?>> selections = ((SqmQuerySpec)subQuery.getQuerySpec()).getSelectClause().getSelections();
            if (selections.size() == 1) {
                subQuery.applyInferableType(selections.get(0).getNodeType());
            }
            SqmSubQuery sqmSubQuery = subQuery;
            return sqmSubQuery;
        }
        finally {
            this.processingStateStack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SemanticPathPart visitPath(HqlParser.PathContext ctx) {
        HqlParser.SyntacticDomainPathContext syntacticDomainPath = ctx.syntacticDomainPath();
        HqlParser.GeneralPathFragmentContext generalPathFragment = ctx.generalPathFragment();
        if (syntacticDomainPath != null) {
            SemanticPathPart syntacticNavigablePathResult = this.visitSyntacticDomainPath(syntacticDomainPath);
            HqlParser.PathContinuationContext pathContinuation = ctx.pathContinuation();
            if (pathContinuation != null) {
                this.dotIdentifierConsumerStack.push(new BasicDotIdentifierConsumer(syntacticNavigablePathResult, this){

                    @Override
                    protected void reset() {
                    }
                });
                try {
                    SemanticPathPart semanticPathPart = (SemanticPathPart)pathContinuation.accept(this);
                    return semanticPathPart;
                }
                finally {
                    this.dotIdentifierConsumerStack.pop();
                }
            }
            return syntacticNavigablePathResult;
        }
        if (generalPathFragment != null) {
            return (SemanticPathPart)generalPathFragment.accept(this);
        }
        throw new ParsingException("Illegal path '" + ctx.getText() + "'");
    }

    @Override
    public SemanticPathPart visitGeneralPathFragment(HqlParser.GeneralPathFragmentContext ctx) {
        return this.visitIndexedPathAccessFragment(ctx.simplePath(), ctx.indexedPathAccessFragment());
    }

    @Override
    public SemanticPathPart visitSyntacticDomainPath(HqlParser.SyntacticDomainPathContext ctx) {
        if (ctx.treatedNavigablePath() != null) {
            return this.visitTreatedNavigablePath(ctx.treatedNavigablePath());
        }
        if (ctx.collectionValueNavigablePath() != null) {
            return this.visitCollectionValueNavigablePath(ctx.collectionValueNavigablePath());
        }
        if (ctx.mapKeyNavigablePath() != null) {
            return this.visitMapKeyNavigablePath(ctx.mapKeyNavigablePath());
        }
        if (ctx.simplePath() != null && ctx.indexedPathAccessFragment() != null) {
            return this.visitIndexedPathAccessFragment(ctx.simplePath(), ctx.indexedPathAccessFragment());
        }
        throw new ParsingException("Illegal domain path '" + ctx.getText() + "'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SemanticPathPart visitIndexedPathAccessFragment(HqlParser.SimplePathContext ctx, HqlParser.IndexedPathAccessFragmentContext idxCtx) {
        SemanticPathPart pathPart = this.visitSimplePath(ctx);
        if (idxCtx == null) {
            return pathPart;
        }
        SqmExpression indexExpression = (SqmExpression)idxCtx.expression().accept(this);
        boolean hasIndexContinuation = idxCtx.DOT() != null;
        SqmPath<?> indexedPath = pathPart.resolveIndexedAccess(indexExpression, !hasIndexContinuation, this);
        if (hasIndexContinuation) {
            this.dotIdentifierConsumerStack.push(new BasicDotIdentifierConsumer(indexedPath, this){

                @Override
                protected void reset() {
                }
            });
            try {
                SemanticPathPart semanticPathPart = (SemanticPathPart)idxCtx.generalPathFragment().accept(this);
                return semanticPathPart;
            }
            finally {
                this.dotIdentifierConsumerStack.pop();
            }
        }
        return indexedPath;
    }

    @Override
    public SemanticPathPart visitIndexedPathAccessFragment(HqlParser.IndexedPathAccessFragmentContext idxCtx) {
        throw new UnsupportedOperationException("Should be handled by #visitIndexedPathAccessFragment");
    }

    @Override
    public SemanticPathPart visitSimplePath(HqlParser.SimplePathContext ctx) {
        int numberOfContinuations = ctx.simplePathElement().size();
        DotIdentifierConsumer dotIdentifierConsumer = this.dotIdentifierConsumerStack.getCurrent();
        HqlParser.IdentifierContext identifierContext = ctx.identifier();
        assert (identifierContext.getChildCount() == 1);
        dotIdentifierConsumer.consumeIdentifier(this.visitIdentifier(identifierContext), true, numberOfContinuations == 0);
        for (int i = 0; i < numberOfContinuations; ++i) {
            HqlParser.SimplePathElementContext continuation = ctx.simplePathElement(i);
            HqlParser.IdentifierContext identifier = continuation.identifier();
            assert (identifier.getChildCount() == 1);
            dotIdentifierConsumer.consumeIdentifier(this.visitIdentifier(identifier), false, i + 1 == numberOfContinuations);
        }
        return dotIdentifierConsumer.getConsumedPart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqmPath<?> visitTreatedNavigablePath(HqlParser.TreatedNavigablePathContext ctx) {
        boolean madeNested;
        DotIdentifierConsumer consumer = this.dotIdentifierConsumerStack.getCurrent();
        if (consumer instanceof QualifiedJoinPathConsumer) {
            QualifiedJoinPathConsumer qualifiedJoinPathConsumer = (QualifiedJoinPathConsumer)consumer;
            boolean bl = madeNested = !qualifiedJoinPathConsumer.isNested();
            if (madeNested) {
                qualifiedJoinPathConsumer.setNested(true);
            }
        } else {
            madeNested = false;
        }
        this.consumeManagedTypeReference(ctx.path());
        String treatTargetName = ctx.simplePath().getText();
        String treatTargetEntityName = this.getCreationContext().getJpaMetamodel().qualifyImportableName(treatTargetName);
        if (treatTargetEntityName == null) {
            throw new SemanticException("Could not resolve treat target type '" + treatTargetName + "'");
        }
        boolean hasContinuation = ctx.getChildCount() == 7;
        consumer.consumeTreat(treatTargetEntityName, !hasContinuation);
        SqmPath<?> result = (SqmPath<?>)consumer.getConsumedPart();
        if (hasContinuation) {
            boolean addConsumer;
            if (madeNested) {
                ((QualifiedJoinPathConsumer)consumer).setNested(false);
            }
            boolean bl = addConsumer = !(consumer instanceof QualifiedJoinPathConsumer);
            if (addConsumer) {
                this.dotIdentifierConsumerStack.push(new BasicDotIdentifierConsumer(result, this){

                    @Override
                    protected void reset() {
                    }
                });
            }
            try {
                result = this.consumeDomainPath(ctx.pathContinuation().simplePath());
            }
            finally {
                if (addConsumer) {
                    this.dotIdentifierConsumerStack.pop();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqmPath<?> visitCollectionValueNavigablePath(HqlParser.CollectionValueNavigablePathContext ctx) {
        SqmPath<?> result;
        PluralPersistentAttribute attribute;
        boolean madeNested;
        DotIdentifierConsumer consumer = this.dotIdentifierConsumerStack.getCurrent();
        if (consumer instanceof QualifiedJoinPathConsumer) {
            QualifiedJoinPathConsumer qualifiedJoinPathConsumer = (QualifiedJoinPathConsumer)consumer;
            boolean bl = madeNested = !qualifiedJoinPathConsumer.isNested();
            if (madeNested) {
                qualifiedJoinPathConsumer.setNested(true);
            }
        } else {
            madeNested = false;
        }
        SqmPath<?> sqmPath = this.consumeDomainPath(ctx.path());
        boolean hasContinuation = ctx.getChildCount() == 5;
        SqmPathSource<?> referencedPathSource = sqmPath.getReferencedPathSource();
        TerminalNode firstNode = (TerminalNode)ctx.elementValueQuantifier().getChild(0);
        this.checkPluralPath(sqmPath, referencedPathSource, firstNode);
        if (this.getCreationOptions().useStrictJpaCompliance() && (attribute = (PluralPersistentAttribute)referencedPathSource).getCollectionClassification() != CollectionClassification.MAP && firstNode.getSymbol().getType() == 200) {
            throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.VALUE_FUNCTION_ON_NON_MAP);
        }
        if (consumer instanceof QualifiedJoinPathConsumer) {
            if (madeNested && !hasContinuation) {
                ((QualifiedJoinPathConsumer)consumer).setNested(false);
            }
            consumer.consumeIdentifier(CollectionPart.Nature.ELEMENT.getName(), false, !hasContinuation);
            result = (SqmPath)consumer.getConsumedPart();
        } else {
            result = sqmPath.resolvePathPart(CollectionPart.Nature.ELEMENT.getName(), true, this);
        }
        if (hasContinuation) {
            if (madeNested) {
                ((QualifiedJoinPathConsumer)consumer).setNested(false);
            }
            HqlParser.SimplePathContext identCtx = ctx.pathContinuation().simplePath();
            if (consumer instanceof QualifiedJoinPathConsumer) {
                result = this.consumeDomainPath(identCtx);
            } else {
                this.dotIdentifierConsumerStack.push(new BasicDotIdentifierConsumer(result, this){

                    @Override
                    protected void reset() {
                    }
                });
                try {
                    result = this.consumeDomainPath(identCtx);
                }
                finally {
                    this.dotIdentifierConsumerStack.pop();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqmPath<?> visitMapKeyNavigablePath(HqlParser.MapKeyNavigablePathContext ctx) {
        SqmPath<?> result;
        PluralPersistentAttribute attribute;
        boolean madeNested;
        DotIdentifierConsumer consumer = this.dotIdentifierConsumerStack.getCurrent();
        if (consumer instanceof QualifiedJoinPathConsumer) {
            QualifiedJoinPathConsumer qualifiedJoinPathConsumer = (QualifiedJoinPathConsumer)consumer;
            boolean bl = madeNested = !qualifiedJoinPathConsumer.isNested();
            if (madeNested) {
                qualifiedJoinPathConsumer.setNested(true);
            }
        } else {
            madeNested = false;
        }
        SqmPath<?> sqmPath = this.consumeDomainPath(ctx.path());
        boolean hasContinuation = ctx.getChildCount() == 5;
        SqmPathSource<?> referencedPathSource = sqmPath.getReferencedPathSource();
        TerminalNode firstNode = (TerminalNode)ctx.indexKeyQuantifier().getChild(0);
        this.checkPluralPath(sqmPath, referencedPathSource, firstNode);
        if (this.getCreationOptions().useStrictJpaCompliance() && (attribute = (PluralPersistentAttribute)referencedPathSource).getCollectionClassification() != CollectionClassification.MAP && firstNode.getSymbol().getType() == 116) {
            throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.KEY_FUNCTION_ON_NON_MAP);
        }
        if (sqmPath instanceof SqmMapJoin) {
            SqmMapJoin sqmMapJoin = (SqmMapJoin)sqmPath;
            if (consumer instanceof QualifiedJoinPathConsumer) {
                if (madeNested && !hasContinuation) {
                    ((QualifiedJoinPathConsumer)consumer).setNested(false);
                }
                consumer.consumeIdentifier(CollectionPart.Nature.INDEX.getName(), false, !hasContinuation);
                result = (SqmPath)consumer.getConsumedPart();
            } else {
                result = sqmMapJoin.key();
            }
        } else if (sqmPath instanceof SqmListJoin) {
            if (hasContinuation) {
                throw new TerminalPathException("List index has no attributes");
            }
            SqmListJoin listJoin = (SqmListJoin)sqmPath;
            result = listJoin.resolvePathPart(CollectionPart.Nature.INDEX.getName(), true, this);
        } else {
            assert (sqmPath instanceof SqmPluralValuedSimplePath);
            SqmPluralValuedSimplePath mapPath = (SqmPluralValuedSimplePath)sqmPath;
            result = mapPath.resolvePathPart(CollectionPart.Nature.INDEX.getName(), !hasContinuation, this);
        }
        if (hasContinuation) {
            if (madeNested) {
                ((QualifiedJoinPathConsumer)consumer).setNested(false);
            }
            HqlParser.SimplePathContext identCtx = ctx.pathContinuation().simplePath();
            if (consumer instanceof QualifiedJoinPathConsumer) {
                result = this.consumeDomainPath(identCtx);
            } else {
                this.dotIdentifierConsumerStack.push(new BasicDotIdentifierConsumer(result, this){

                    @Override
                    protected void reset() {
                    }
                });
                try {
                    result = this.consumeDomainPath(identCtx);
                }
                finally {
                    this.dotIdentifierConsumerStack.pop();
                }
            }
        }
        return result;
    }

    private void checkPluralPath(SqmPath<?> pluralAttributePath, SqmPathSource<?> referencedPathSource, TerminalNode firstNode) {
        if (!(referencedPathSource instanceof PluralPersistentAttribute)) {
            throw new FunctionArgumentException(String.format("Argument of '%s' is not a plural path '%s'", firstNode.getSymbol().getText(), pluralAttributePath.getNavigablePath()));
        }
    }

    private SqmPath<?> consumeDomainPath(HqlParser.PathContext parserPath) {
        SemanticPathPart consumedPart = (SemanticPathPart)parserPath.accept(this);
        if (consumedPart instanceof SqmPath) {
            return (SqmPath)consumedPart;
        }
        throw new PathException("Expecting domain-model path, but found: " + consumedPart);
    }

    private SqmPath<?> consumeDomainPath(HqlParser.SimplePathContext sequence) {
        SemanticPathPart consumedPart = (SemanticPathPart)sequence.accept(this);
        if (consumedPart instanceof SqmPath) {
            return (SqmPath)consumedPart;
        }
        throw new PathException("Expecting domain-model path, but found: " + consumedPart);
    }

    private SqmPath<?> consumeManagedTypeReference(HqlParser.PathContext parserPath) {
        SqmPath<?> sqmPath = this.consumeDomainPath(parserPath);
        SqmPathSource<?> pathSource = sqmPath.getReferencedPathSource();
        if (pathSource.getSqmPathType() instanceof ManagedDomainType) {
            return sqmPath;
        }
        throw new PathException("Expecting ManagedType valued path [" + sqmPath.getNavigablePath() + "], but found: " + pathSource.getSqmPathType());
    }

    private SqmPath<?> consumePluralAttributeReference(HqlParser.PathContext parserPath) {
        SqmPath<?> sqmPath = this.consumeDomainPath(parserPath);
        if (sqmPath.getReferencedPathSource() instanceof PluralPersistentAttribute) {
            return sqmPath;
        }
        throw new PathException("Expecting plural attribute valued path [" + sqmPath.getNavigablePath() + "], but found: " + sqmPath.getReferencedPathSource().getSqmPathType());
    }

    private void checkFQNEntityNameJpaComplianceViolationIfNeeded(String name, EntityDomainType<?> entityDescriptor) {
        if (this.getCreationOptions().useStrictJpaCompliance() && !name.equals(entityDescriptor.getName())) {
            throw new StrictJpaComplianceViolation("Encountered FQN entity name [" + name + "], but strict JPQL compliance was requested ( [" + entityDescriptor.getName() + "] should be used instead )", StrictJpaComplianceViolation.Type.FQN_ENTITY_NAME);
        }
    }

    static {
        HashSet<String> jpaStandardFunctions = new HashSet<String>();
        jpaStandardFunctions.add("avg");
        jpaStandardFunctions.add("max");
        jpaStandardFunctions.add("min");
        jpaStandardFunctions.add("sum");
        jpaStandardFunctions.add("count");
        jpaStandardFunctions.add("length");
        jpaStandardFunctions.add("locate");
        jpaStandardFunctions.add("abs");
        jpaStandardFunctions.add("sqrt");
        jpaStandardFunctions.add("mod");
        jpaStandardFunctions.add("size");
        jpaStandardFunctions.add("index");
        jpaStandardFunctions.add("current_date");
        jpaStandardFunctions.add("current_time");
        jpaStandardFunctions.add("current_timestamp");
        jpaStandardFunctions.add("concat");
        jpaStandardFunctions.add("substring");
        jpaStandardFunctions.add("trim");
        jpaStandardFunctions.add("lower");
        jpaStandardFunctions.add("upper");
        jpaStandardFunctions.add("coalesce");
        jpaStandardFunctions.add("nullif");
        JPA_STANDARD_FUNCTIONS = jpaStandardFunctions;
    }

    private static enum ParameterStyle {
        UNKNOWN{

            @Override
            ParameterStyle withNamed() {
                return NAMED;
            }

            @Override
            ParameterStyle withPositional() {
                return POSITIONAL;
            }
        }
        ,
        NAMED{

            @Override
            ParameterStyle withNamed() {
                return NAMED;
            }

            @Override
            ParameterStyle withPositional() {
                throw new StrictJpaComplianceViolation("Cannot mix ordinal and named parameters", StrictJpaComplianceViolation.Type.MIXED_POSITIONAL_NAMED_PARAMETERS);
            }
        }
        ,
        POSITIONAL{

            @Override
            ParameterStyle withNamed() {
                throw new StrictJpaComplianceViolation("Cannot mix positional and named parameters", StrictJpaComplianceViolation.Type.MIXED_POSITIONAL_NAMED_PARAMETERS);
            }

            @Override
            ParameterStyle withPositional() {
                return POSITIONAL;
            }
        }
        ,
        MIXED{

            @Override
            ParameterStyle withNamed() {
                return MIXED;
            }

            @Override
            ParameterStyle withPositional() {
                return MIXED;
            }
        };


        abstract ParameterStyle withNamed();

        abstract ParameterStyle withPositional();
    }
}

