/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.collection.internal;

import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.collection.spi.PersistentList;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.collection.internal.AbstractImmediateCollectionInitializer;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public class ListInitializer
extends AbstractImmediateCollectionInitializer {
    private static final String CONCRETE_NAME = ListInitializer.class.getSimpleName();
    private final DomainResultAssembler<Integer> listIndexAssembler;
    private final DomainResultAssembler<?> elementAssembler;
    private final int listIndexBase;

    public ListInitializer(NavigablePath navigablePath, PluralAttributeMapping attributeMapping, FetchParentAccess parentAccess, LockMode lockMode, DomainResultAssembler<?> collectionKeyAssembler, DomainResultAssembler<?> collectionValueKeyAssembler, DomainResultAssembler<Integer> listIndexAssembler, DomainResultAssembler<?> elementAssembler) {
        super(navigablePath, attributeMapping, parentAccess, lockMode, collectionKeyAssembler, collectionValueKeyAssembler);
        this.listIndexAssembler = listIndexAssembler;
        this.elementAssembler = elementAssembler;
        this.listIndexBase = attributeMapping.getIndexMetadata().getListIndexBase();
    }

    @Override
    protected String getSimpleConcreteImplName() {
        return CONCRETE_NAME;
    }

    public PersistentList<?> getCollectionInstance() {
        return (PersistentList)super.getCollectionInstance();
    }

    @Override
    protected void readCollectionRow(CollectionKey collectionKey, List<Object> loadingState, RowProcessingState rowProcessingState) {
        Integer indexValue = this.listIndexAssembler.assemble(rowProcessingState);
        if (indexValue == null) {
            throw new HibernateException("Illegal null value for list index encountered while reading: " + this.getCollectionAttributeMapping().getNavigableRole());
        }
        int index = indexValue;
        if (this.listIndexBase != 0) {
            index -= this.listIndexBase;
        }
        for (int i = loadingState.size(); i <= index; ++i) {
            loadingState.add(i, null);
        }
        loadingState.set(index, this.elementAssembler.assemble(rowProcessingState));
    }

    public String toString() {
        return "ListInitializer(" + LoggingHelper.toLoggableString(this.getNavigablePath()) + ")";
    }
}

