/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.internal;

import jakarta.persistence.GenerationType;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.TableGenerator;
import java.util.ArrayList;
import java.util.UUID;
import org.hibernate.boot.model.IdGeneratorStrategyInterpreter;
import org.hibernate.boot.model.IdentifierGeneratorDefinition;
import org.hibernate.id.IncrementGenerator;
import org.hibernate.id.UUIDGenerator;
import org.hibernate.id.enhanced.SequenceStyleGenerator;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;

public class IdGeneratorInterpreterImpl
implements IdGeneratorStrategyInterpreter {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(IdGeneratorInterpreterImpl.class);
    private final IdGeneratorStrategyInterpreter fallbackInterpreter = FallbackInterpreter.INSTANCE;
    private ArrayList<IdGeneratorStrategyInterpreter> delegates;

    @Override
    public String determineGeneratorName(GenerationType generationType, IdGeneratorStrategyInterpreter.GeneratorNameDeterminationContext context) {
        if (this.delegates != null) {
            for (IdGeneratorStrategyInterpreter delegate : this.delegates) {
                String result = delegate.determineGeneratorName(generationType, context);
                if (result == null) continue;
                return result;
            }
        }
        return this.fallbackInterpreter.determineGeneratorName(generationType, context);
    }

    @Override
    public void interpretTableGenerator(TableGenerator tableGeneratorAnnotation, IdentifierGeneratorDefinition.Builder definitionBuilder) {
        this.fallbackInterpreter.interpretTableGenerator(tableGeneratorAnnotation, definitionBuilder);
        if (this.delegates != null) {
            for (IdGeneratorStrategyInterpreter delegate : this.delegates) {
                delegate.interpretTableGenerator(tableGeneratorAnnotation, definitionBuilder);
            }
        }
    }

    @Override
    public void interpretSequenceGenerator(SequenceGenerator sequenceGeneratorAnnotation, IdentifierGeneratorDefinition.Builder definitionBuilder) {
        this.fallbackInterpreter.interpretSequenceGenerator(sequenceGeneratorAnnotation, definitionBuilder);
        if (this.delegates != null) {
            for (IdGeneratorStrategyInterpreter delegate : this.delegates) {
                delegate.interpretSequenceGenerator(sequenceGeneratorAnnotation, definitionBuilder);
            }
        }
    }

    public void addInterpreterDelegate(IdGeneratorStrategyInterpreter delegate) {
        if (this.delegates == null) {
            this.delegates = new ArrayList();
        }
        this.delegates.add(delegate);
    }

    private static class FallbackInterpreter
    implements IdGeneratorStrategyInterpreter {
        public static final FallbackInterpreter INSTANCE = new FallbackInterpreter();

        private FallbackInterpreter() {
        }

        @Override
        public String determineGeneratorName(GenerationType generationType, IdGeneratorStrategyInterpreter.GeneratorNameDeterminationContext context) {
            switch (generationType) {
                case IDENTITY: {
                    return "identity";
                }
                case SEQUENCE: {
                    return SequenceStyleGenerator.class.getName();
                }
                case TABLE: {
                    return org.hibernate.id.enhanced.TableGenerator.class.getName();
                }
                case AUTO: {
                    if (UUID.class.isAssignableFrom(context.getIdType())) {
                        return UUIDGenerator.class.getName();
                    }
                    if ("increment".equalsIgnoreCase(context.getGeneratedValueGeneratorName())) {
                        return IncrementGenerator.class.getName();
                    }
                    return SequenceStyleGenerator.class.getName();
                }
            }
            if ("UUID".equals(generationType.name())) {
                return UUIDGenerator.class.getName();
            }
            throw new UnsupportedOperationException("Unsupported generation type:" + generationType);
        }

        @Override
        public void interpretTableGenerator(TableGenerator tableGeneratorAnnotation, IdentifierGeneratorDefinition.Builder definitionBuilder) {
            definitionBuilder.setName(tableGeneratorAnnotation.name());
            definitionBuilder.setStrategy(org.hibernate.id.enhanced.TableGenerator.class.getName());
            definitionBuilder.addParam("prefer_entity_table_as_segment_value", "true");
            if (!tableGeneratorAnnotation.catalog().isEmpty()) {
                definitionBuilder.addParam("catalog", tableGeneratorAnnotation.catalog());
            }
            if (!tableGeneratorAnnotation.schema().isEmpty()) {
                definitionBuilder.addParam("schema", tableGeneratorAnnotation.schema());
            }
            if (!tableGeneratorAnnotation.table().isEmpty()) {
                definitionBuilder.addParam("table_name", tableGeneratorAnnotation.table());
            }
            if (!tableGeneratorAnnotation.pkColumnName().isEmpty()) {
                definitionBuilder.addParam("segment_column_name", tableGeneratorAnnotation.pkColumnName());
            }
            if (!tableGeneratorAnnotation.pkColumnValue().isEmpty()) {
                definitionBuilder.addParam("segment_value", tableGeneratorAnnotation.pkColumnValue());
            }
            if (!tableGeneratorAnnotation.valueColumnName().isEmpty()) {
                definitionBuilder.addParam("value_column_name", tableGeneratorAnnotation.valueColumnName());
            }
            definitionBuilder.addParam("increment_size", String.valueOf(tableGeneratorAnnotation.allocationSize()));
            definitionBuilder.addParam("initial_value", String.valueOf(tableGeneratorAnnotation.initialValue() + 1));
            if (tableGeneratorAnnotation.uniqueConstraints() != null && tableGeneratorAnnotation.uniqueConstraints().length > 0) {
                log.ignoringTableGeneratorConstraints(tableGeneratorAnnotation.name());
            }
        }

        @Override
        public void interpretSequenceGenerator(SequenceGenerator sequenceGeneratorAnnotation, IdentifierGeneratorDefinition.Builder definitionBuilder) {
            definitionBuilder.setName(sequenceGeneratorAnnotation.name());
            definitionBuilder.setStrategy(SequenceStyleGenerator.class.getName());
            if (!sequenceGeneratorAnnotation.catalog().isEmpty()) {
                definitionBuilder.addParam("catalog", sequenceGeneratorAnnotation.catalog());
            }
            if (!sequenceGeneratorAnnotation.schema().isEmpty()) {
                definitionBuilder.addParam("schema", sequenceGeneratorAnnotation.schema());
            }
            if (!sequenceGeneratorAnnotation.sequenceName().isEmpty()) {
                definitionBuilder.addParam("sequence_name", sequenceGeneratorAnnotation.sequenceName());
            }
            definitionBuilder.addParam("increment_size", String.valueOf(sequenceGeneratorAnnotation.allocationSize()));
            definitionBuilder.addParam("initial_value", String.valueOf(sequenceGeneratorAnnotation.initialValue()));
        }
    }
}

